// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// OvirtPlatform oVirt platform-specific configuration upon which to perform the installation.
//
// swagger:model ovirt-platform
type OvirtPlatform struct {

	// The CA Bundle of the oVirt's engine certificate.
	CaBundle *string `json:"ca_bundle,omitempty"`

	// The oVirt cluster ID.
	// Format: uuid
	ClusterID *strfmt.UUID `json:"cluster_id,omitempty"`

	// The oVirt's engine fully qualified domain name.
	Fqdn *string `json:"fqdn,omitempty"`

	// Verify oVirt engine certificate.
	Insecure *bool `json:"insecure,omitempty"`

	// The oVirt network the VMs will be attached to.
	NetworkName *string `json:"network_name,omitempty"`

	// The password for the oVirt user name.
	// Format: password
	Password *strfmt.Password `json:"password,omitempty"`

	// The oVirt storage domain ID.
	// Format: uuid
	StorageDomainID *strfmt.UUID `json:"storage_domain_id,omitempty"`

	// The user name to use to connect to the oVirt instance.
	Username *string `json:"username,omitempty"`

	// The oVirt VNIC profile ID.
	// Format: uuid
	VnicProfileID *strfmt.UUID `json:"vnic_profile_id,omitempty"`
}

// Validate validates this ovirt platform
func (m *OvirtPlatform) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClusterID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageDomainID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVnicProfileID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OvirtPlatform) validateClusterID(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterID) { // not required
		return nil
	}

	if err := validate.FormatOf("cluster_id", "body", "uuid", m.ClusterID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *OvirtPlatform) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.FormatOf("password", "body", "password", m.Password.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *OvirtPlatform) validateStorageDomainID(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageDomainID) { // not required
		return nil
	}

	if err := validate.FormatOf("storage_domain_id", "body", "uuid", m.StorageDomainID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *OvirtPlatform) validateVnicProfileID(formats strfmt.Registry) error {
	if swag.IsZero(m.VnicProfileID) { // not required
		return nil
	}

	if err := validate.FormatOf("vnic_profile_id", "body", "uuid", m.VnicProfileID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ovirt platform based on context it is used
func (m *OvirtPlatform) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OvirtPlatform) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OvirtPlatform) UnmarshalBinary(b []byte) error {
	var res OvirtPlatform
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
