// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// VersionedHostRequirements versioned host requirements
//
// swagger:model versioned-host-requirements
type VersionedHostRequirements struct {

	// Master node requirements
	MasterRequirements *ClusterHostRequirementsDetails `json:"master,omitempty"`

	// Single node OpenShift node requirements
	SNORequirements *ClusterHostRequirementsDetails `json:"sno,omitempty"`

	// Worker node requirements
	WorkerRequirements *ClusterHostRequirementsDetails `json:"worker,omitempty"`

	// Version of the component for which requirements are defined
	Version string `json:"version,omitempty"`
}

// Validate validates this versioned host requirements
func (m *VersionedHostRequirements) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMasterRequirements(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSNORequirements(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkerRequirements(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VersionedHostRequirements) validateMasterRequirements(formats strfmt.Registry) error {
	if swag.IsZero(m.MasterRequirements) { // not required
		return nil
	}

	if m.MasterRequirements != nil {
		if err := m.MasterRequirements.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("master")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("master")
			}
			return err
		}
	}

	return nil
}

func (m *VersionedHostRequirements) validateSNORequirements(formats strfmt.Registry) error {
	if swag.IsZero(m.SNORequirements) { // not required
		return nil
	}

	if m.SNORequirements != nil {
		if err := m.SNORequirements.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sno")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("sno")
			}
			return err
		}
	}

	return nil
}

func (m *VersionedHostRequirements) validateWorkerRequirements(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkerRequirements) { // not required
		return nil
	}

	if m.WorkerRequirements != nil {
		if err := m.WorkerRequirements.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("worker")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this versioned host requirements based on the context it is used
func (m *VersionedHostRequirements) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMasterRequirements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSNORequirements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkerRequirements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VersionedHostRequirements) contextValidateMasterRequirements(ctx context.Context, formats strfmt.Registry) error {

	if m.MasterRequirements != nil {
		if err := m.MasterRequirements.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("master")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("master")
			}
			return err
		}
	}

	return nil
}

func (m *VersionedHostRequirements) contextValidateSNORequirements(ctx context.Context, formats strfmt.Registry) error {

	if m.SNORequirements != nil {
		if err := m.SNORequirements.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sno")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("sno")
			}
			return err
		}
	}

	return nil
}

func (m *VersionedHostRequirements) contextValidateWorkerRequirements(ctx context.Context, formats strfmt.Registry) error {

	if m.WorkerRequirements != nil {
		if err := m.WorkerRequirements.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("worker")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VersionedHostRequirements) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VersionedHostRequirements) UnmarshalBinary(b []byte) error {
	var res VersionedHostRequirements
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
