// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NewListClustersParams creates a new ListClustersParams object
// with the default values initialized.
func NewListClustersParams() ListClustersParams {

	var (
		// initialize parameters with default values

		getUnregisteredClustersDefault = bool(false)

		withHostsDefault = bool(false)
	)

	return ListClustersParams{
		GetUnregisteredClusters: &getUnregisteredClustersDefault,

		WithHosts: withHostsDefault,
	}
}

// ListClustersParams contains all the bound params for the list clusters operation
// typically these are obtained from a http.Request
//
// swagger:parameters ListClusters
type ListClustersParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*If non-empty, returned Clusters are filtered to those with matching subscription IDs.
	  In: query
	*/
	AmsSubscriptionIds []string
	/*Whether to return clusters that have been unregistered.
	  In: header
	  Default: false
	*/
	GetUnregisteredClusters *bool
	/*A specific cluster to retrieve.
	  In: query
	*/
	OpenshiftClusterID *strfmt.UUID
	/*Include hosts in the returned list.
	  In: query
	  Default: false
	*/
	WithHosts bool
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewListClustersParams() beforehand.
func (o *ListClustersParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qAmsSubscriptionIds, qhkAmsSubscriptionIds, _ := qs.GetOK("ams_subscription_ids")
	if err := o.bindAmsSubscriptionIds(qAmsSubscriptionIds, qhkAmsSubscriptionIds, route.Formats); err != nil {
		res = append(res, err)
	}

	if err := o.bindGetUnregisteredClusters(r.Header[http.CanonicalHeaderKey("get_unregistered_clusters")], true, route.Formats); err != nil {
		res = append(res, err)
	}

	qOpenshiftClusterID, qhkOpenshiftClusterID, _ := qs.GetOK("openshift_cluster_id")
	if err := o.bindOpenshiftClusterID(qOpenshiftClusterID, qhkOpenshiftClusterID, route.Formats); err != nil {
		res = append(res, err)
	}

	qWithHosts, qhkWithHosts, _ := qs.GetOK("with_hosts")
	if err := o.bindWithHosts(qWithHosts, qhkWithHosts, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindAmsSubscriptionIds binds and validates array parameter AmsSubscriptionIds from query.
//
// Arrays are parsed according to CollectionFormat: "" (defaults to "csv" when empty).
func (o *ListClustersParams) bindAmsSubscriptionIds(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var qvAmsSubscriptionIds string
	if len(rawData) > 0 {
		qvAmsSubscriptionIds = rawData[len(rawData)-1]
	}

	// CollectionFormat:
	amsSubscriptionIdsIC := swag.SplitByFormat(qvAmsSubscriptionIds, "")
	if len(amsSubscriptionIdsIC) == 0 {
		return nil
	}

	var amsSubscriptionIdsIR []string
	for _, amsSubscriptionIdsIV := range amsSubscriptionIdsIC {
		amsSubscriptionIdsI := amsSubscriptionIdsIV

		amsSubscriptionIdsIR = append(amsSubscriptionIdsIR, amsSubscriptionIdsI)
	}

	o.AmsSubscriptionIds = amsSubscriptionIdsIR

	return nil
}

// bindGetUnregisteredClusters binds and validates parameter GetUnregisteredClusters from header.
func (o *ListClustersParams) bindGetUnregisteredClusters(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewListClustersParams()
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("get_unregistered_clusters", "header", "bool", raw)
	}
	o.GetUnregisteredClusters = &value

	return nil
}

// bindOpenshiftClusterID binds and validates parameter OpenshiftClusterID from query.
func (o *ListClustersParams) bindOpenshiftClusterID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}

	// Format: uuid
	value, err := formats.Parse("uuid", raw)
	if err != nil {
		return errors.InvalidType("openshift_cluster_id", "query", "strfmt.UUID", raw)
	}
	o.OpenshiftClusterID = (value.(*strfmt.UUID))

	if err := o.validateOpenshiftClusterID(formats); err != nil {
		return err
	}

	return nil
}

// validateOpenshiftClusterID carries on validations for parameter OpenshiftClusterID
func (o *ListClustersParams) validateOpenshiftClusterID(formats strfmt.Registry) error {

	if err := validate.FormatOf("openshift_cluster_id", "query", "uuid", o.OpenshiftClusterID.String(), formats); err != nil {
		return err
	}
	return nil
}

// bindWithHosts binds and validates parameter WithHosts from query.
func (o *ListClustersParams) bindWithHosts(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: true

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewListClustersParams()
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("with_hosts", "query", "bool", raw)
	}
	o.WithHosts = value

	return nil
}
