// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"errors"
	"net/url"
	golangswaggerpaths "path"
	"strings"

	"github.com/go-openapi/strfmt"
)

// V2DownloadHostIgnitionURL generates an URL for the v2 download host ignition operation
type V2DownloadHostIgnitionURL struct {
	HostID     strfmt.UUID
	InfraEnvID strfmt.UUID

	_basePath string
	// avoid unkeyed usage
	_ struct{}
}

// WithBasePath sets the base path for this url builder, only required when it's different from the
// base path specified in the swagger spec.
// When the value of the base path is an empty string
func (o *V2DownloadHostIgnitionURL) WithBasePath(bp string) *V2DownloadHostIgnitionURL {
	o.SetBasePath(bp)
	return o
}

// SetBasePath sets the base path for this url builder, only required when it's different from the
// base path specified in the swagger spec.
// When the value of the base path is an empty string
func (o *V2DownloadHostIgnitionURL) SetBasePath(bp string) {
	o._basePath = bp
}

// Build a url path and query string
func (o *V2DownloadHostIgnitionURL) Build() (*url.URL, error) {
	var _result url.URL

	var _path = "/v2/infra-env/{infra_env_id}/hosts/{host_id}/downloads/ignition"

	hostID := o.HostID.String()
	if hostID != "" {
		_path = strings.Replace(_path, "{host_id}", hostID, -1)
	} else {
		return nil, errors.New("hostId is required on V2DownloadHostIgnitionURL")
	}

	infraEnvID := o.InfraEnvID.String()
	if infraEnvID != "" {
		_path = strings.Replace(_path, "{infra_env_id}", infraEnvID, -1)
	} else {
		return nil, errors.New("infraEnvId is required on V2DownloadHostIgnitionURL")
	}

	_basePath := o._basePath
	if _basePath == "" {
		_basePath = "/api/assisted-install"
	}
	_result.Path = golangswaggerpaths.Join(_basePath, _path)

	return &_result, nil
}

// Must is a helper function to panic when the url builder returns an error
func (o *V2DownloadHostIgnitionURL) Must(u *url.URL, err error) *url.URL {
	if err != nil {
		panic(err)
	}
	if u == nil {
		panic("url can't be nil")
	}
	return u
}

// String returns the string representation of the path with query string
func (o *V2DownloadHostIgnitionURL) String() string {
	return o.Must(o.Build()).String()
}

// BuildFull builds a full url with scheme, host, path and query string
func (o *V2DownloadHostIgnitionURL) BuildFull(scheme, host string) (*url.URL, error) {
	if scheme == "" {
		return nil, errors.New("scheme is required for a full url on V2DownloadHostIgnitionURL")
	}
	if host == "" {
		return nil, errors.New("host is required for a full url on V2DownloadHostIgnitionURL")
	}

	base, err := o.Build()
	if err != nil {
		return nil, err
	}

	base.Scheme = scheme
	base.Host = host
	return base, nil
}

// StringFull returns the string representation of a complete url
func (o *V2DownloadHostIgnitionURL) StringFull(scheme, host string) string {
	return o.Must(o.BuildFull(scheme, host)).String()
}
