// Code generated by "go generate gonum.org/v1/gonum/unit”; DO NOT EDIT.

// Copyright ©2014 The Gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package unit

import (
	"errors"
	"fmt"
	"math"
	"unicode/utf8"
)

// Resistance represents an electrical resistance, impedance or reactance in Ohms.
type Resistance float64

const (
	Yottaohm Resistance = 1e24
	Zettaohm Resistance = 1e21
	Exaohm   Resistance = 1e18
	Petaohm  Resistance = 1e15
	Teraohm  Resistance = 1e12
	Gigaohm  Resistance = 1e9
	Megaohm  Resistance = 1e6
	Kiloohm  Resistance = 1e3
	Hectoohm Resistance = 1e2
	Decaohm  Resistance = 1e1
	Ohm      Resistance = 1.0
	Deciohm  Resistance = 1e-1
	Centiohm Resistance = 1e-2
	Milliohm Resistance = 1e-3
	Microohm Resistance = 1e-6
	Nanoohm  Resistance = 1e-9
	Picoohm  Resistance = 1e-12
	Femtoohm Resistance = 1e-15
	Attoohm  Resistance = 1e-18
	Zeptoohm Resistance = 1e-21
	Yoctoohm Resistance = 1e-24
)

// Unit converts the Resistance to a *Unit
func (r Resistance) Unit() *Unit {
	return New(float64(r), Dimensions{
		CurrentDim: -2,
		LengthDim:  2,
		MassDim:    1,
		TimeDim:    -3,
	})
}

// Resistance allows Resistance to implement a Resistancer interface
func (r Resistance) Resistance() Resistance {
	return r
}

// From converts the unit into the receiver. From returns an
// error if there is a mismatch in dimension
func (r *Resistance) From(u Uniter) error {
	if !DimensionsMatch(u, Ohm) {
		*r = Resistance(math.NaN())
		return errors.New("Dimension mismatch")
	}
	*r = Resistance(u.Unit().Value())
	return nil
}

func (r Resistance) Format(fs fmt.State, c rune) {
	switch c {
	case 'v':
		if fs.Flag('#') {
			fmt.Fprintf(fs, "%T(%v)", r, float64(r))
			return
		}
		fallthrough
	case 'e', 'E', 'f', 'F', 'g', 'G':
		p, pOk := fs.Precision()
		w, wOk := fs.Width()
		const unit = " Ω"
		switch {
		case pOk && wOk:
			fmt.Fprintf(fs, "%*.*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), p, float64(r))
		case pOk:
			fmt.Fprintf(fs, "%.*"+string(c), p, float64(r))
		case wOk:
			fmt.Fprintf(fs, "%*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), float64(r))
		default:
			fmt.Fprintf(fs, "%"+string(c), float64(r))
		}
		fmt.Fprint(fs, unit)
	default:
		fmt.Fprintf(fs, "%%!%c(%T=%g Ω)", c, r, float64(r))
	}
}
