// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package schemas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type SearchSchemasInput struct {
	_ struct{} `type:"structure"`

	// Keywords is a required field
	Keywords *string `location:"querystring" locationName:"keywords" type:"string" required:"true"`

	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`
}

// String returns the string representation
func (s SearchSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchSchemasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchSchemasInput"}

	if s.Keywords == nil {
		invalidParams.Add(aws.NewErrParamRequired("Keywords"))
	}

	if s.RegistryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RegistryName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SearchSchemasInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.RegistryName != nil {
		v := *s.RegistryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "registryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Keywords != nil {
		v := *s.Keywords

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "keywords", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type SearchSchemasOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Schemas []SearchSchemaSummary `type:"list"`
}

// String returns the string representation
func (s SearchSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SearchSchemasOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schemas != nil {
		v := s.Schemas

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Schemas", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opSearchSchemas = "SearchSchemas"

// SearchSchemasRequest returns a request value for making API operation for
// Schemas.
//
// Search the schemas
//
//    // Example sending a request using SearchSchemasRequest.
//    req := client.SearchSchemasRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/SearchSchemas
func (c *Client) SearchSchemasRequest(input *SearchSchemasInput) SearchSchemasRequest {
	op := &aws.Operation{
		Name:       opSearchSchemas,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/search",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchSchemasInput{}
	}

	req := c.newRequest(op, input, &SearchSchemasOutput{})
	return SearchSchemasRequest{Request: req, Input: input, Copy: c.SearchSchemasRequest}
}

// SearchSchemasRequest is the request type for the
// SearchSchemas API operation.
type SearchSchemasRequest struct {
	*aws.Request
	Input *SearchSchemasInput
	Copy  func(*SearchSchemasInput) SearchSchemasRequest
}

// Send marshals and sends the SearchSchemas API request.
func (r SearchSchemasRequest) Send(ctx context.Context) (*SearchSchemasResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchSchemasResponse{
		SearchSchemasOutput: r.Request.Data.(*SearchSchemasOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchSchemasRequestPaginator returns a paginator for SearchSchemas.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchSchemasRequest(input)
//   p := schemas.NewSearchSchemasRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchSchemasPaginator(req SearchSchemasRequest) SearchSchemasPaginator {
	return SearchSchemasPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchSchemasInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchSchemasPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchSchemasPaginator struct {
	aws.Pager
}

func (p *SearchSchemasPaginator) CurrentPage() *SearchSchemasOutput {
	return p.Pager.CurrentPage().(*SearchSchemasOutput)
}

// SearchSchemasResponse is the response type for the
// SearchSchemas API operation.
type SearchSchemasResponse struct {
	*SearchSchemasOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchSchemas request.
func (r *SearchSchemasResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
