# FAT32 Test Fixtures
This directory contains test fixtures for FAT32 filesystems. Specifically, it contains the following files:

* `fat32.img`: A 10MB filesystem img
* `calcsfn_checksum.c`: A C program that generates correct short filename checksums

To generate the `fat32.img`, based roughly on https://commons.wikimedia.org/wiki/File:VFAT_directory_entries.png :

```
$ docker run -it --rm -v $PWD:/data alpine:3.6
# apk --update add dosfstools mtools
# dd if=/dev/zero of=/data/fat32.img bs=1M count=10
# mkfs.vfat -v -F 32 /data/fat32.img
# echo "mtools_skip_check=1" >> /etc/mtools.conf
# mmd -i /data/fat32.img ::/foo
# mmd -i /data/fat32.img ::/foo/bar
# echo 'Tenemos un archivo corto' > /CORTO1.TXT
# dd if=/dev/zero 'of=/Un archivo con nombre largo.dat' bs=1024 count=2
# dd if=/dev/zero 'of=/tercer_archivo' bs=1024 count=6
# dd if=/dev/zero 'of=/Un archivo con nombre largo.dat' bs=1024 count=7
# dd if=/dev/zero 'of=/some_long_embedded_nameא' bs=1024 count=7
# mcopy -i /data/fat32.img /CORTO1.TXT ::/
# mcopy -i /data/fat32.img '/Un archivo con nombre largo.dat' ::/
# mcopy -i /data/fat32.img '/tercer_archivo' ::/
# mcopy -i /data/fat32.img '/Un archivo con nombre largo.dat' ::/
# mcopy -i /data/fat32.img '/some_long_embedded_nameא' ::/foo/bar
#
# i=0
# until [ $i -gt 75 ]; do mmd -i /data/fat32.img ::/foo/dir${i}; i=$(( $i+1 )); done

# exit
$
```

We make the `\foo` directory with sufficient entries to exceed a single cluster. This allows us to test reading. Since each directory entry is 32 bytes, and a cluster is 4*512 = 2048 bytes, we need 2048/32 = 64 entries to fill the cluster and one more to get to the next one.

You now have the exact fat32 files in `$PWD`

**Note:** Certain data should be copied over to your "valid" test information in test files, notably:

* volume serial number is generated by creation date/time; you cannot "pre-plan" it. Thus, it should be copied into the appropriate place in `getValidDos71EBPB()` [dos71bpb_test.go](../dos71bpb_test.go)
* free data cluster count, should be copied over to the appropriate place in `getValidFSInfoSector` [fsinfosector_test.go](../fsinfosector_test.go)
* last allocated cluster, should be copied over to the appropriate place in `getValidFSInfoSector` [fsinfosector_test.go](../fsinfosector_test.go)
* allocated FAT clusters


## Basic Builds
In addition to the usual test harnesses, this directory contains a file that generates a basic fat32 filesystem. To build it:

```
go build -o fat32 fat32.go
```

and run it as `./fat32`. The output will be a file called `test_file.img`. 

To build an `mtools` based image to compare, run `./mkfat32.sh`. 

