/*
Copyright (c) 2020 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// IMPORTANT: This file has been generated automatically, refrain from modifying it manually as all
// your changes will be lost when the file is generated again.

package v1 // github.com/openshift-online/ocm-sdk-go/accountsmgmt/v1

import (
	"io"
	"net/http"

	jsoniter "github.com/json-iterator/go"
	"github.com/openshift-online/ocm-sdk-go/helpers"
)

// MarshalSkuRule writes a value of the 'sku_rule' type to the given writer.
func MarshalSkuRule(object *SkuRule, writer io.Writer) error {
	stream := helpers.NewStream(writer)
	writeSkuRule(object, stream)
	stream.Flush()
	return stream.Error
}

// writeSkuRule writes a value of the 'sku_rule' type to the given stream.
func writeSkuRule(object *SkuRule, stream *jsoniter.Stream) {
	count := 0
	stream.WriteObjectStart()
	stream.WriteObjectField("kind")
	if object.bitmap_&1 != 0 {
		stream.WriteString(SkuRuleLinkKind)
	} else {
		stream.WriteString(SkuRuleKind)
	}
	count++
	if object.bitmap_&2 != 0 {
		if count > 0 {
			stream.WriteMore()
		}
		stream.WriteObjectField("id")
		stream.WriteString(object.id)
		count++
	}
	if object.bitmap_&4 != 0 {
		if count > 0 {
			stream.WriteMore()
		}
		stream.WriteObjectField("href")
		stream.WriteString(object.href)
		count++
	}
	var present_ bool
	present_ = object.bitmap_&8 != 0
	if present_ {
		if count > 0 {
			stream.WriteMore()
		}
		stream.WriteObjectField("allowed")
		stream.WriteInt(object.allowed)
		count++
	}
	present_ = object.bitmap_&16 != 0
	if present_ {
		if count > 0 {
			stream.WriteMore()
		}
		stream.WriteObjectField("quota_id")
		stream.WriteString(object.quotaId)
		count++
	}
	present_ = object.bitmap_&32 != 0
	if present_ {
		if count > 0 {
			stream.WriteMore()
		}
		stream.WriteObjectField("sku")
		stream.WriteString(object.sku)
		count++
	}
	stream.WriteObjectEnd()
}

// UnmarshalSkuRule reads a value of the 'sku_rule' type from the given
// source, which can be an slice of bytes, a string or a reader.
func UnmarshalSkuRule(source interface{}) (object *SkuRule, err error) {
	if source == http.NoBody {
		return
	}
	iterator, err := helpers.NewIterator(source)
	if err != nil {
		return
	}
	object = readSkuRule(iterator)
	err = iterator.Error
	return
}

// readSkuRule reads a value of the 'sku_rule' type from the given iterator.
func readSkuRule(iterator *jsoniter.Iterator) *SkuRule {
	object := &SkuRule{}
	for {
		field := iterator.ReadObject()
		if field == "" {
			break
		}
		switch field {
		case "kind":
			value := iterator.ReadString()
			if value == SkuRuleLinkKind {
				object.bitmap_ |= 1
			}
		case "id":
			object.id = iterator.ReadString()
			object.bitmap_ |= 2
		case "href":
			object.href = iterator.ReadString()
			object.bitmap_ |= 4
		case "allowed":
			value := iterator.ReadInt()
			object.allowed = value
			object.bitmap_ |= 8
		case "quota_id":
			value := iterator.ReadString()
			object.quotaId = value
			object.bitmap_ |= 16
		case "sku":
			value := iterator.ReadString()
			object.sku = value
			object.bitmap_ |= 32
		default:
			iterator.ReadAny()
		}
	}
	return object
}
