// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// InstallHostReader is a Reader for the InstallHost structure.
type InstallHostReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *InstallHostReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 202:
		result := NewInstallHostAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewInstallHostUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewInstallHostForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewInstallHostNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewInstallHostConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewInstallHostInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewInstallHostAccepted creates a InstallHostAccepted with default headers values
func NewInstallHostAccepted() *InstallHostAccepted {
	return &InstallHostAccepted{}
}

/*InstallHostAccepted handles this case with default header values.

Success.
*/
type InstallHostAccepted struct {
	Payload *models.Host
}

func (o *InstallHostAccepted) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/hosts/{host_id}/actions/install][%d] installHostAccepted  %+v", 202, o.Payload)
}

func (o *InstallHostAccepted) GetPayload() *models.Host {
	return o.Payload
}

func (o *InstallHostAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Host)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInstallHostUnauthorized creates a InstallHostUnauthorized with default headers values
func NewInstallHostUnauthorized() *InstallHostUnauthorized {
	return &InstallHostUnauthorized{}
}

/*InstallHostUnauthorized handles this case with default header values.

Unauthorized.
*/
type InstallHostUnauthorized struct {
	Payload *models.InfraError
}

func (o *InstallHostUnauthorized) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/hosts/{host_id}/actions/install][%d] installHostUnauthorized  %+v", 401, o.Payload)
}

func (o *InstallHostUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *InstallHostUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInstallHostForbidden creates a InstallHostForbidden with default headers values
func NewInstallHostForbidden() *InstallHostForbidden {
	return &InstallHostForbidden{}
}

/*InstallHostForbidden handles this case with default header values.

Forbidden.
*/
type InstallHostForbidden struct {
	Payload *models.InfraError
}

func (o *InstallHostForbidden) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/hosts/{host_id}/actions/install][%d] installHostForbidden  %+v", 403, o.Payload)
}

func (o *InstallHostForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *InstallHostForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInstallHostNotFound creates a InstallHostNotFound with default headers values
func NewInstallHostNotFound() *InstallHostNotFound {
	return &InstallHostNotFound{}
}

/*InstallHostNotFound handles this case with default header values.

Error.
*/
type InstallHostNotFound struct {
	Payload *models.Error
}

func (o *InstallHostNotFound) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/hosts/{host_id}/actions/install][%d] installHostNotFound  %+v", 404, o.Payload)
}

func (o *InstallHostNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *InstallHostNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInstallHostConflict creates a InstallHostConflict with default headers values
func NewInstallHostConflict() *InstallHostConflict {
	return &InstallHostConflict{}
}

/*InstallHostConflict handles this case with default header values.

Error.
*/
type InstallHostConflict struct {
	Payload *models.Error
}

func (o *InstallHostConflict) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/hosts/{host_id}/actions/install][%d] installHostConflict  %+v", 409, o.Payload)
}

func (o *InstallHostConflict) GetPayload() *models.Error {
	return o.Payload
}

func (o *InstallHostConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInstallHostInternalServerError creates a InstallHostInternalServerError with default headers values
func NewInstallHostInternalServerError() *InstallHostInternalServerError {
	return &InstallHostInternalServerError{}
}

/*InstallHostInternalServerError handles this case with default header values.

Error.
*/
type InstallHostInternalServerError struct {
	Payload *models.Error
}

func (o *InstallHostInternalServerError) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/hosts/{host_id}/actions/install][%d] installHostInternalServerError  %+v", 500, o.Payload)
}

func (o *InstallHostInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *InstallHostInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
