// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

//go:generate mockery -name API -inpkg

// API is the interface of the installer client
type API interface {
	/*
	   CancelInstallation Cancels an ongoing installation.*/
	CancelInstallation(ctx context.Context, params *CancelInstallationParams) (*CancelInstallationAccepted, error)
	/*
	   CompleteInstallation Agent API to mark a finalizing installation as complete.*/
	CompleteInstallation(ctx context.Context, params *CompleteInstallationParams) (*CompleteInstallationAccepted, error)
	/*
	   DeregisterCluster Deletes an OpenShift cluster definition.*/
	DeregisterCluster(ctx context.Context, params *DeregisterClusterParams) (*DeregisterClusterNoContent, error)
	/*
	   DeregisterHost Deregisters an OpenShift host.*/
	DeregisterHost(ctx context.Context, params *DeregisterHostParams) (*DeregisterHostNoContent, error)
	/*
	   DeregisterInfraEnv Deletes an InfraEnv.*/
	DeregisterInfraEnv(ctx context.Context, params *DeregisterInfraEnvParams) (*DeregisterInfraEnvNoContent, error)
	/*
	   DisableHost Disables a host for inclusion in the cluster.*/
	DisableHost(ctx context.Context, params *DisableHostParams) (*DisableHostOK, error)
	/*
	   DownloadClusterFiles Downloads files relating to the installed/installing cluster.*/
	DownloadClusterFiles(ctx context.Context, params *DownloadClusterFilesParams, writer io.Writer) (*DownloadClusterFilesOK, error)
	/*
	   DownloadClusterISO Downloads the OpenShift per-cluster Discovery ISO.*/
	DownloadClusterISO(ctx context.Context, params *DownloadClusterISOParams, writer io.Writer) (*DownloadClusterISOOK, error)
	/*
	   DownloadClusterISOHeaders Downloads the OpenShift per-cluster Discovery ISO Headers only.*/
	DownloadClusterISOHeaders(ctx context.Context, params *DownloadClusterISOHeadersParams) (*DownloadClusterISOHeadersOK, error)
	/*
	   DownloadClusterKubeconfig Downloads the kubeconfig file for this cluster.*/
	DownloadClusterKubeconfig(ctx context.Context, params *DownloadClusterKubeconfigParams, writer io.Writer) (*DownloadClusterKubeconfigOK, error)
	/*
	   DownloadClusterLogs Download cluster logs.*/
	DownloadClusterLogs(ctx context.Context, params *DownloadClusterLogsParams, writer io.Writer) (*DownloadClusterLogsOK, error)
	/*
	   DownloadHostIgnition Downloads the customized ignition file for this host*/
	DownloadHostIgnition(ctx context.Context, params *DownloadHostIgnitionParams, writer io.Writer) (*DownloadHostIgnitionOK, error)
	/*
	   DownloadHostLogs Download host logs.*/
	DownloadHostLogs(ctx context.Context, params *DownloadHostLogsParams, writer io.Writer) (*DownloadHostLogsOK, error)
	/*
	   DownloadInfraEnvDiscoveryImage Downloads the discovery image.*/
	DownloadInfraEnvDiscoveryImage(ctx context.Context, params *DownloadInfraEnvDiscoveryImageParams, writer io.Writer) (*DownloadInfraEnvDiscoveryImageOK, error)
	/*
	   DownloadInfraEnvDiscoveryImageHeaders Downloads the discovery image Headers only.*/
	DownloadInfraEnvDiscoveryImageHeaders(ctx context.Context, params *DownloadInfraEnvDiscoveryImageHeadersParams) (*DownloadInfraEnvDiscoveryImageHeadersOK, error)
	/*
	   EnableHost Enables a host for inclusion in the cluster.*/
	EnableHost(ctx context.Context, params *EnableHostParams) (*EnableHostOK, error)
	/*
	   GenerateClusterISO Creates a new OpenShift per-cluster Discovery ISO.*/
	GenerateClusterISO(ctx context.Context, params *GenerateClusterISOParams) (*GenerateClusterISOCreated, error)
	/*
	   GetCluster Retrieves the details of the OpenShift cluster.*/
	GetCluster(ctx context.Context, params *GetClusterParams) (*GetClusterOK, error)
	/*
	   GetClusterDefaultConfig Get the default values for various cluster properties.*/
	GetClusterDefaultConfig(ctx context.Context, params *GetClusterDefaultConfigParams) (*GetClusterDefaultConfigOK, error)
	/*
	   GetClusterHostRequirements Get host requirements of a cluster.*/
	GetClusterHostRequirements(ctx context.Context, params *GetClusterHostRequirementsParams) (*GetClusterHostRequirementsOK, error)
	/*
	   GetClusterInstallConfig Get the cluster's install config YAML.*/
	GetClusterInstallConfig(ctx context.Context, params *GetClusterInstallConfigParams) (*GetClusterInstallConfigOK, error)
	/*
	   GetClusterSupportedPlatforms A list of platforms that this cluster can support in its current configuration.*/
	GetClusterSupportedPlatforms(ctx context.Context, params *GetClusterSupportedPlatformsParams) (*GetClusterSupportedPlatformsOK, error)
	/*
	   GetCredentials Get the cluster admin credentials.*/
	GetCredentials(ctx context.Context, params *GetCredentialsParams) (*GetCredentialsOK, error)
	/*
	   GetDiscoveryIgnition Get the discovery ignition for the cluster based on its attributes and overridden ignition value before generating the discovery ISO.
	   Used to test the validity of the discovery ignition when it is being overridden.
	   For downloading the generated discovery ignition use /clusters/$CLUSTER_ID/downloads/files?file_name=discovery.ign
	*/
	GetDiscoveryIgnition(ctx context.Context, params *GetDiscoveryIgnitionParams) (*GetDiscoveryIgnitionOK, error)
	/*
	   GetFreeAddresses Retrieves the free address list for a network.*/
	GetFreeAddresses(ctx context.Context, params *GetFreeAddressesParams) (*GetFreeAddressesOK, error)
	/*
	   GetHost Retrieves the details of the OpenShift host.*/
	GetHost(ctx context.Context, params *GetHostParams) (*GetHostOK, error)
	/*
	   GetHostIgnition Get the customized ignition file for this host*/
	GetHostIgnition(ctx context.Context, params *GetHostIgnitionParams) (*GetHostIgnitionOK, error)
	/*
	   GetInfraEnv Retrieves the details of the InfraEnv.*/
	GetInfraEnv(ctx context.Context, params *GetInfraEnvParams) (*GetInfraEnvOK, error)
	/*
	   GetNextSteps Retrieves the next operations that the host agent needs to perform.*/
	GetNextSteps(ctx context.Context, params *GetNextStepsParams) (*GetNextStepsOK, error)
	/*
	   GetPreflightRequirements Get preflight requirements for a cluster.*/
	GetPreflightRequirements(ctx context.Context, params *GetPreflightRequirementsParams) (*GetPreflightRequirementsOK, error)
	/*
	   GetPresignedForClusterFiles Retrieves a pre-signed S3 URL for downloading cluster files.*/
	GetPresignedForClusterFiles(ctx context.Context, params *GetPresignedForClusterFilesParams) (*GetPresignedForClusterFilesOK, error)
	/*
	   InstallCluster Installs the OpenShift cluster.*/
	InstallCluster(ctx context.Context, params *InstallClusterParams) (*InstallClusterAccepted, error)
	/*
	   InstallHost install specific host for day2 cluster.*/
	InstallHost(ctx context.Context, params *InstallHostParams) (*InstallHostAccepted, error)
	/*
	   InstallHosts Installs the OpenShift cluster.*/
	InstallHosts(ctx context.Context, params *InstallHostsParams) (*InstallHostsAccepted, error)
	/*
	   ListClusters Retrieves the list of OpenShift clusters.*/
	ListClusters(ctx context.Context, params *ListClustersParams) (*ListClustersOK, error)
	/*
	   ListHosts Retrieves the list of OpenShift hosts.*/
	ListHosts(ctx context.Context, params *ListHostsParams) (*ListHostsOK, error)
	/*
	   ListInfraEnvs Retrieves the list of InfraEnvs.*/
	ListInfraEnvs(ctx context.Context, params *ListInfraEnvsParams) (*ListInfraEnvsOK, error)
	/*
	   PostStepReply Posts the result of the operations from the host agent.*/
	PostStepReply(ctx context.Context, params *PostStepReplyParams) (*PostStepReplyNoContent, error)
	/*
	   RegisterAddHostsCluster Creates a new OpenShift cluster definition for adding nodes to and existing OCP cluster.*/
	RegisterAddHostsCluster(ctx context.Context, params *RegisterAddHostsClusterParams) (*RegisterAddHostsClusterCreated, error)
	/*
	   RegisterCluster Creates a new OpenShift cluster definition.*/
	RegisterCluster(ctx context.Context, params *RegisterClusterParams) (*RegisterClusterCreated, error)
	/*
	   RegisterHost Registers a new OpenShift host.*/
	RegisterHost(ctx context.Context, params *RegisterHostParams) (*RegisterHostCreated, error)
	/*
	   RegisterInfraEnv Creates a new OpenShift Discovery ISO.*/
	RegisterInfraEnv(ctx context.Context, params *RegisterInfraEnvParams) (*RegisterInfraEnvCreated, error)
	/*
	   ResetCluster Resets a failed installation.*/
	ResetCluster(ctx context.Context, params *ResetClusterParams) (*ResetClusterAccepted, error)
	/*
	   ResetHost reset a failed host for day2 cluster.*/
	ResetHost(ctx context.Context, params *ResetHostParams) (*ResetHostOK, error)
	/*
	   ResetHostValidation resets failed host validation

	   Reset failed host validation.  It may be performed on any host validation with persistent validation result.*/
	ResetHostValidation(ctx context.Context, params *ResetHostValidationParams) (*ResetHostValidationOK, error)
	/*
	   UpdateCluster Updates an OpenShift cluster definition.*/
	UpdateCluster(ctx context.Context, params *UpdateClusterParams) (*UpdateClusterCreated, error)
	/*
	   UpdateClusterInstallConfig Override values in the install config.*/
	UpdateClusterInstallConfig(ctx context.Context, params *UpdateClusterInstallConfigParams) (*UpdateClusterInstallConfigCreated, error)
	/*
	   UpdateClusterLogsProgress Update log collection state and progress.*/
	UpdateClusterLogsProgress(ctx context.Context, params *UpdateClusterLogsProgressParams) (*UpdateClusterLogsProgressNoContent, error)
	/*
	   UpdateDiscoveryIgnition Override values in the discovery ignition config.*/
	UpdateDiscoveryIgnition(ctx context.Context, params *UpdateDiscoveryIgnitionParams) (*UpdateDiscoveryIgnitionCreated, error)
	/*
	   UpdateHostIgnition Patch the ignition file for this host*/
	UpdateHostIgnition(ctx context.Context, params *UpdateHostIgnitionParams) (*UpdateHostIgnitionCreated, error)
	/*
	   UpdateHostInstallProgress Update installation progress.*/
	UpdateHostInstallProgress(ctx context.Context, params *UpdateHostInstallProgressParams) (*UpdateHostInstallProgressOK, error)
	/*
	   UpdateHostInstallerArgs Updates a host's installer arguments.*/
	UpdateHostInstallerArgs(ctx context.Context, params *UpdateHostInstallerArgsParams) (*UpdateHostInstallerArgsCreated, error)
	/*
	   UpdateHostLogsProgress Update log collection state and progress.*/
	UpdateHostLogsProgress(ctx context.Context, params *UpdateHostLogsProgressParams) (*UpdateHostLogsProgressNoContent, error)
	/*
	   UpdateInfraEnv Updates an InfraEnv.*/
	UpdateInfraEnv(ctx context.Context, params *UpdateInfraEnvParams) (*UpdateInfraEnvCreated, error)
	/*
	   UploadClusterIngressCert Transfer the ingress certificate for the cluster.*/
	UploadClusterIngressCert(ctx context.Context, params *UploadClusterIngressCertParams) (*UploadClusterIngressCertCreated, error)
	/*
	   UploadHostLogs Agent API to upload logs.*/
	UploadHostLogs(ctx context.Context, params *UploadHostLogsParams) (*UploadHostLogsNoContent, error)
	/*
	   UploadLogs Agent API to upload logs.*/
	UploadLogs(ctx context.Context, params *UploadLogsParams) (*UploadLogsNoContent, error)
	/*
	   V2GetHost Retrieves the details of the OpenShift host.*/
	V2GetHost(ctx context.Context, params *V2GetHostParams) (*V2GetHostOK, error)
	/*
	   V2GetNextSteps Retrieves the next operations that the host agent needs to perform.*/
	V2GetNextSteps(ctx context.Context, params *V2GetNextStepsParams) (*V2GetNextStepsOK, error)
	/*
	   V2PostStepReply Posts the result of the operations from the host agent.*/
	V2PostStepReply(ctx context.Context, params *V2PostStepReplyParams) (*V2PostStepReplyNoContent, error)
	/*
	   V2RegisterHost Registers a new OpenShift agent.*/
	V2RegisterHost(ctx context.Context, params *V2RegisterHostParams) (*V2RegisterHostCreated, error)
	/*
	   V2UpdateHostInstallProgress Update installation progress.*/
	V2UpdateHostInstallProgress(ctx context.Context, params *V2UpdateHostInstallProgressParams) (*V2UpdateHostInstallProgressOK, error)
}

// New creates a new installer API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry, authInfo runtime.ClientAuthInfoWriter) *Client {
	return &Client{
		transport: transport,
		formats:   formats,
		authInfo:  authInfo,
	}
}

/*
Client for installer API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
	authInfo  runtime.ClientAuthInfoWriter
}

/*
CancelInstallation Cancels an ongoing installation.
*/
func (a *Client) CancelInstallation(ctx context.Context, params *CancelInstallationParams) (*CancelInstallationAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "CancelInstallation",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/actions/cancel",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CancelInstallationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CancelInstallationAccepted), nil

}

/*
CompleteInstallation Agent API to mark a finalizing installation as complete.
*/
func (a *Client) CompleteInstallation(ctx context.Context, params *CompleteInstallationParams) (*CompleteInstallationAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "CompleteInstallation",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/actions/complete_installation",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CompleteInstallationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CompleteInstallationAccepted), nil

}

/*
DeregisterCluster Deletes an OpenShift cluster definition.
*/
func (a *Client) DeregisterCluster(ctx context.Context, params *DeregisterClusterParams) (*DeregisterClusterNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeregisterCluster",
		Method:             "DELETE",
		PathPattern:        "/v1/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeregisterClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeregisterClusterNoContent), nil

}

/*
DeregisterHost Deregisters an OpenShift host.
*/
func (a *Client) DeregisterHost(ctx context.Context, params *DeregisterHostParams) (*DeregisterHostNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeregisterHost",
		Method:             "DELETE",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeregisterHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeregisterHostNoContent), nil

}

/*
DeregisterInfraEnv Deletes an InfraEnv.
*/
func (a *Client) DeregisterInfraEnv(ctx context.Context, params *DeregisterInfraEnvParams) (*DeregisterInfraEnvNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeregisterInfraEnv",
		Method:             "DELETE",
		PathPattern:        "/v2/infra-envs/{infra_env_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeregisterInfraEnvReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeregisterInfraEnvNoContent), nil

}

/*
DisableHost Disables a host for inclusion in the cluster.
*/
func (a *Client) DisableHost(ctx context.Context, params *DisableHostParams) (*DisableHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DisableHost",
		Method:             "DELETE",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/enable",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DisableHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DisableHostOK), nil

}

/*
DownloadClusterFiles Downloads files relating to the installed/installing cluster.
*/
func (a *Client) DownloadClusterFiles(ctx context.Context, params *DownloadClusterFilesParams, writer io.Writer) (*DownloadClusterFilesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterFiles",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/downloads/files",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterFilesReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterFilesOK), nil

}

/*
DownloadClusterISO Downloads the OpenShift per-cluster Discovery ISO.
*/
func (a *Client) DownloadClusterISO(ctx context.Context, params *DownloadClusterISOParams, writer io.Writer) (*DownloadClusterISOOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterISO",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/downloads/image",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterISOReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterISOOK), nil

}

/*
DownloadClusterISOHeaders Downloads the OpenShift per-cluster Discovery ISO Headers only.
*/
func (a *Client) DownloadClusterISOHeaders(ctx context.Context, params *DownloadClusterISOHeadersParams) (*DownloadClusterISOHeadersOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterISOHeaders",
		Method:             "HEAD",
		PathPattern:        "/v1/clusters/{cluster_id}/downloads/image",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterISOHeadersReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterISOHeadersOK), nil

}

/*
DownloadClusterKubeconfig Downloads the kubeconfig file for this cluster.
*/
func (a *Client) DownloadClusterKubeconfig(ctx context.Context, params *DownloadClusterKubeconfigParams, writer io.Writer) (*DownloadClusterKubeconfigOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterKubeconfig",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/downloads/kubeconfig",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterKubeconfigReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterKubeconfigOK), nil

}

/*
DownloadClusterLogs Download cluster logs.
*/
func (a *Client) DownloadClusterLogs(ctx context.Context, params *DownloadClusterLogsParams, writer io.Writer) (*DownloadClusterLogsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterLogs",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/logs",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterLogsReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterLogsOK), nil

}

/*
DownloadHostIgnition Downloads the customized ignition file for this host
*/
func (a *Client) DownloadHostIgnition(ctx context.Context, params *DownloadHostIgnitionParams, writer io.Writer) (*DownloadHostIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadHostIgnition",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/downloads/ignition",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadHostIgnitionReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadHostIgnitionOK), nil

}

/*
DownloadHostLogs Download host logs.
*/
func (a *Client) DownloadHostLogs(ctx context.Context, params *DownloadHostLogsParams, writer io.Writer) (*DownloadHostLogsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadHostLogs",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/logs",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadHostLogsReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadHostLogsOK), nil

}

/*
DownloadInfraEnvDiscoveryImage Downloads the discovery image.
*/
func (a *Client) DownloadInfraEnvDiscoveryImage(ctx context.Context, params *DownloadInfraEnvDiscoveryImageParams, writer io.Writer) (*DownloadInfraEnvDiscoveryImageOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadInfraEnvDiscoveryImage",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/image",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadInfraEnvDiscoveryImageReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadInfraEnvDiscoveryImageOK), nil

}

/*
DownloadInfraEnvDiscoveryImageHeaders Downloads the discovery image Headers only.
*/
func (a *Client) DownloadInfraEnvDiscoveryImageHeaders(ctx context.Context, params *DownloadInfraEnvDiscoveryImageHeadersParams) (*DownloadInfraEnvDiscoveryImageHeadersOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadInfraEnvDiscoveryImageHeaders",
		Method:             "HEAD",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/image",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadInfraEnvDiscoveryImageHeadersReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadInfraEnvDiscoveryImageHeadersOK), nil

}

/*
EnableHost Enables a host for inclusion in the cluster.
*/
func (a *Client) EnableHost(ctx context.Context, params *EnableHostParams) (*EnableHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "EnableHost",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/enable",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &EnableHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*EnableHostOK), nil

}

/*
GenerateClusterISO Creates a new OpenShift per-cluster Discovery ISO.
*/
func (a *Client) GenerateClusterISO(ctx context.Context, params *GenerateClusterISOParams) (*GenerateClusterISOCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GenerateClusterISO",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/downloads/image",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GenerateClusterISOReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GenerateClusterISOCreated), nil

}

/*
GetCluster Retrieves the details of the OpenShift cluster.
*/
func (a *Client) GetCluster(ctx context.Context, params *GetClusterParams) (*GetClusterOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetCluster",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterOK), nil

}

/*
GetClusterDefaultConfig Get the default values for various cluster properties.
*/
func (a *Client) GetClusterDefaultConfig(ctx context.Context, params *GetClusterDefaultConfigParams) (*GetClusterDefaultConfigOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetClusterDefaultConfig",
		Method:             "GET",
		PathPattern:        "/v1/clusters/default-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterDefaultConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterDefaultConfigOK), nil

}

/*
GetClusterHostRequirements Get host requirements of a cluster.
*/
func (a *Client) GetClusterHostRequirements(ctx context.Context, params *GetClusterHostRequirementsParams) (*GetClusterHostRequirementsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetClusterHostRequirements",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/host-requirements",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterHostRequirementsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterHostRequirementsOK), nil

}

/*
GetClusterInstallConfig Get the cluster's install config YAML.
*/
func (a *Client) GetClusterInstallConfig(ctx context.Context, params *GetClusterInstallConfigParams) (*GetClusterInstallConfigOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetClusterInstallConfig",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/install-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterInstallConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterInstallConfigOK), nil

}

/*
GetClusterSupportedPlatforms A list of platforms that this cluster can support in its current configuration.
*/
func (a *Client) GetClusterSupportedPlatforms(ctx context.Context, params *GetClusterSupportedPlatformsParams) (*GetClusterSupportedPlatformsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetClusterSupportedPlatforms",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/supported-platforms",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterSupportedPlatformsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterSupportedPlatformsOK), nil

}

/*
GetCredentials Get the cluster admin credentials.
*/
func (a *Client) GetCredentials(ctx context.Context, params *GetCredentialsParams) (*GetCredentialsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetCredentials",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/credentials",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetCredentialsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetCredentialsOK), nil

}

/*
GetDiscoveryIgnition Get the discovery ignition for the cluster based on its attributes and overridden ignition value before generating the discovery ISO.
Used to test the validity of the discovery ignition when it is being overridden.
For downloading the generated discovery ignition use /clusters/$CLUSTER_ID/downloads/files?file_name=discovery.ign

*/
func (a *Client) GetDiscoveryIgnition(ctx context.Context, params *GetDiscoveryIgnitionParams) (*GetDiscoveryIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetDiscoveryIgnition",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/discovery-ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetDiscoveryIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetDiscoveryIgnitionOK), nil

}

/*
GetFreeAddresses Retrieves the free address list for a network.
*/
func (a *Client) GetFreeAddresses(ctx context.Context, params *GetFreeAddressesParams) (*GetFreeAddressesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetFreeAddresses",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/free_addresses",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetFreeAddressesReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetFreeAddressesOK), nil

}

/*
GetHost Retrieves the details of the OpenShift host.
*/
func (a *Client) GetHost(ctx context.Context, params *GetHostParams) (*GetHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetHost",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetHostOK), nil

}

/*
GetHostIgnition Get the customized ignition file for this host
*/
func (a *Client) GetHostIgnition(ctx context.Context, params *GetHostIgnitionParams) (*GetHostIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetHostIgnition",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetHostIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetHostIgnitionOK), nil

}

/*
GetInfraEnv Retrieves the details of the InfraEnv.
*/
func (a *Client) GetInfraEnv(ctx context.Context, params *GetInfraEnvParams) (*GetInfraEnvOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetInfraEnv",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetInfraEnvReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetInfraEnvOK), nil

}

/*
GetNextSteps Retrieves the next operations that the host agent needs to perform.
*/
func (a *Client) GetNextSteps(ctx context.Context, params *GetNextStepsParams) (*GetNextStepsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetNextSteps",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/instructions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetNextStepsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetNextStepsOK), nil

}

/*
GetPreflightRequirements Get preflight requirements for a cluster.
*/
func (a *Client) GetPreflightRequirements(ctx context.Context, params *GetPreflightRequirementsParams) (*GetPreflightRequirementsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetPreflightRequirements",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/preflight-requirements",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetPreflightRequirementsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetPreflightRequirementsOK), nil

}

/*
GetPresignedForClusterFiles Retrieves a pre-signed S3 URL for downloading cluster files.
*/
func (a *Client) GetPresignedForClusterFiles(ctx context.Context, params *GetPresignedForClusterFilesParams) (*GetPresignedForClusterFilesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetPresignedForClusterFiles",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/downloads/files-presigned",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetPresignedForClusterFilesReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetPresignedForClusterFilesOK), nil

}

/*
InstallCluster Installs the OpenShift cluster.
*/
func (a *Client) InstallCluster(ctx context.Context, params *InstallClusterParams) (*InstallClusterAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "InstallCluster",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/actions/install",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &InstallClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*InstallClusterAccepted), nil

}

/*
InstallHost install specific host for day2 cluster.
*/
func (a *Client) InstallHost(ctx context.Context, params *InstallHostParams) (*InstallHostAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "InstallHost",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/install",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &InstallHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*InstallHostAccepted), nil

}

/*
InstallHosts Installs the OpenShift cluster.
*/
func (a *Client) InstallHosts(ctx context.Context, params *InstallHostsParams) (*InstallHostsAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "InstallHosts",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/actions/install_hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &InstallHostsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*InstallHostsAccepted), nil

}

/*
ListClusters Retrieves the list of OpenShift clusters.
*/
func (a *Client) ListClusters(ctx context.Context, params *ListClustersParams) (*ListClustersOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListClusters",
		Method:             "GET",
		PathPattern:        "/v1/clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListClustersReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListClustersOK), nil

}

/*
ListHosts Retrieves the list of OpenShift hosts.
*/
func (a *Client) ListHosts(ctx context.Context, params *ListHostsParams) (*ListHostsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListHosts",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListHostsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListHostsOK), nil

}

/*
ListInfraEnvs Retrieves the list of InfraEnvs.
*/
func (a *Client) ListInfraEnvs(ctx context.Context, params *ListInfraEnvsParams) (*ListInfraEnvsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListInfraEnvs",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListInfraEnvsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListInfraEnvsOK), nil

}

/*
PostStepReply Posts the result of the operations from the host agent.
*/
func (a *Client) PostStepReply(ctx context.Context, params *PostStepReplyParams) (*PostStepReplyNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "PostStepReply",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/instructions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PostStepReplyReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PostStepReplyNoContent), nil

}

/*
RegisterAddHostsCluster Creates a new OpenShift cluster definition for adding nodes to and existing OCP cluster.
*/
func (a *Client) RegisterAddHostsCluster(ctx context.Context, params *RegisterAddHostsClusterParams) (*RegisterAddHostsClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "RegisterAddHostsCluster",
		Method:             "POST",
		PathPattern:        "/v1/add_hosts_clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RegisterAddHostsClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*RegisterAddHostsClusterCreated), nil

}

/*
RegisterCluster Creates a new OpenShift cluster definition.
*/
func (a *Client) RegisterCluster(ctx context.Context, params *RegisterClusterParams) (*RegisterClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "RegisterCluster",
		Method:             "POST",
		PathPattern:        "/v1/clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RegisterClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*RegisterClusterCreated), nil

}

/*
RegisterHost Registers a new OpenShift host.
*/
func (a *Client) RegisterHost(ctx context.Context, params *RegisterHostParams) (*RegisterHostCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "RegisterHost",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RegisterHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*RegisterHostCreated), nil

}

/*
RegisterInfraEnv Creates a new OpenShift Discovery ISO.
*/
func (a *Client) RegisterInfraEnv(ctx context.Context, params *RegisterInfraEnvParams) (*RegisterInfraEnvCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "RegisterInfraEnv",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RegisterInfraEnvReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*RegisterInfraEnvCreated), nil

}

/*
ResetCluster Resets a failed installation.
*/
func (a *Client) ResetCluster(ctx context.Context, params *ResetClusterParams) (*ResetClusterAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ResetCluster",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/actions/reset",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ResetClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ResetClusterAccepted), nil

}

/*
ResetHost reset a failed host for day2 cluster.
*/
func (a *Client) ResetHost(ctx context.Context, params *ResetHostParams) (*ResetHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ResetHost",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/reset",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ResetHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ResetHostOK), nil

}

/*
ResetHostValidation resets failed host validation

Reset failed host validation.  It may be performed on any host validation with persistent validation result.
*/
func (a *Client) ResetHostValidation(ctx context.Context, params *ResetHostValidationParams) (*ResetHostValidationOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ResetHostValidation",
		Method:             "PATCH",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/reset-validation/{validation_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ResetHostValidationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ResetHostValidationOK), nil

}

/*
UpdateCluster Updates an OpenShift cluster definition.
*/
func (a *Client) UpdateCluster(ctx context.Context, params *UpdateClusterParams) (*UpdateClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateCluster",
		Method:             "PATCH",
		PathPattern:        "/v1/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateClusterCreated), nil

}

/*
UpdateClusterInstallConfig Override values in the install config.
*/
func (a *Client) UpdateClusterInstallConfig(ctx context.Context, params *UpdateClusterInstallConfigParams) (*UpdateClusterInstallConfigCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateClusterInstallConfig",
		Method:             "PATCH",
		PathPattern:        "/v1/clusters/{cluster_id}/install-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateClusterInstallConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateClusterInstallConfigCreated), nil

}

/*
UpdateClusterLogsProgress Update log collection state and progress.
*/
func (a *Client) UpdateClusterLogsProgress(ctx context.Context, params *UpdateClusterLogsProgressParams) (*UpdateClusterLogsProgressNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateClusterLogsProgress",
		Method:             "PUT",
		PathPattern:        "/v1/clusters/{cluster_id}/logs_progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateClusterLogsProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateClusterLogsProgressNoContent), nil

}

/*
UpdateDiscoveryIgnition Override values in the discovery ignition config.
*/
func (a *Client) UpdateDiscoveryIgnition(ctx context.Context, params *UpdateDiscoveryIgnitionParams) (*UpdateDiscoveryIgnitionCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateDiscoveryIgnition",
		Method:             "PATCH",
		PathPattern:        "/v1/clusters/{cluster_id}/discovery-ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateDiscoveryIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateDiscoveryIgnitionCreated), nil

}

/*
UpdateHostIgnition Patch the ignition file for this host
*/
func (a *Client) UpdateHostIgnition(ctx context.Context, params *UpdateHostIgnitionParams) (*UpdateHostIgnitionCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateHostIgnition",
		Method:             "PATCH",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateHostIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateHostIgnitionCreated), nil

}

/*
UpdateHostInstallProgress Update installation progress.
*/
func (a *Client) UpdateHostInstallProgress(ctx context.Context, params *UpdateHostInstallProgressParams) (*UpdateHostInstallProgressOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateHostInstallProgress",
		Method:             "PUT",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateHostInstallProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateHostInstallProgressOK), nil

}

/*
UpdateHostInstallerArgs Updates a host's installer arguments.
*/
func (a *Client) UpdateHostInstallerArgs(ctx context.Context, params *UpdateHostInstallerArgsParams) (*UpdateHostInstallerArgsCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateHostInstallerArgs",
		Method:             "PATCH",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/installer-args",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateHostInstallerArgsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateHostInstallerArgsCreated), nil

}

/*
UpdateHostLogsProgress Update log collection state and progress.
*/
func (a *Client) UpdateHostLogsProgress(ctx context.Context, params *UpdateHostLogsProgressParams) (*UpdateHostLogsProgressNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateHostLogsProgress",
		Method:             "PUT",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/logs_progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateHostLogsProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateHostLogsProgressNoContent), nil

}

/*
UpdateInfraEnv Updates an InfraEnv.
*/
func (a *Client) UpdateInfraEnv(ctx context.Context, params *UpdateInfraEnvParams) (*UpdateInfraEnvCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateInfraEnv",
		Method:             "PATCH",
		PathPattern:        "/v2/infra-envs/{infra_env_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateInfraEnvReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateInfraEnvCreated), nil

}

/*
UploadClusterIngressCert Transfer the ingress certificate for the cluster.
*/
func (a *Client) UploadClusterIngressCert(ctx context.Context, params *UploadClusterIngressCertParams) (*UploadClusterIngressCertCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UploadClusterIngressCert",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/uploads/ingress-cert",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UploadClusterIngressCertReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UploadClusterIngressCertCreated), nil

}

/*
UploadHostLogs Agent API to upload logs.
*/
func (a *Client) UploadHostLogs(ctx context.Context, params *UploadHostLogsParams) (*UploadHostLogsNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UploadHostLogs",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/logs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UploadHostLogsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UploadHostLogsNoContent), nil

}

/*
UploadLogs Agent API to upload logs.
*/
func (a *Client) UploadLogs(ctx context.Context, params *UploadLogsParams) (*UploadLogsNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UploadLogs",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/logs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UploadLogsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UploadLogsNoContent), nil

}

/*
V2GetHost Retrieves the details of the OpenShift host.
*/
func (a *Client) V2GetHost(ctx context.Context, params *V2GetHostParams) (*V2GetHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetHost",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetHostOK), nil

}

/*
V2GetNextSteps Retrieves the next operations that the host agent needs to perform.
*/
func (a *Client) V2GetNextSteps(ctx context.Context, params *V2GetNextStepsParams) (*V2GetNextStepsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetNextSteps",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/instructions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetNextStepsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetNextStepsOK), nil

}

/*
V2PostStepReply Posts the result of the operations from the host agent.
*/
func (a *Client) V2PostStepReply(ctx context.Context, params *V2PostStepReplyParams) (*V2PostStepReplyNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2PostStepReply",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/instructions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2PostStepReplyReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2PostStepReplyNoContent), nil

}

/*
V2RegisterHost Registers a new OpenShift agent.
*/
func (a *Client) V2RegisterHost(ctx context.Context, params *V2RegisterHostParams) (*V2RegisterHostCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2RegisterHost",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2RegisterHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2RegisterHostCreated), nil

}

/*
V2UpdateHostInstallProgress Update installation progress.
*/
func (a *Client) V2UpdateHostInstallProgress(ctx context.Context, params *V2UpdateHostInstallProgressParams) (*V2UpdateHostInstallProgressOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateHostInstallProgress",
		Method:             "PUT",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateHostInstallProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateHostInstallProgressOK), nil

}
