// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// UploadLogsReader is a Reader for the UploadLogs structure.
type UploadLogsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UploadLogsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewUploadLogsNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewUploadLogsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUploadLogsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUploadLogsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUploadLogsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 503:
		result := NewUploadLogsServiceUnavailable()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewUploadLogsNoContent creates a UploadLogsNoContent with default headers values
func NewUploadLogsNoContent() *UploadLogsNoContent {
	return &UploadLogsNoContent{}
}

/*UploadLogsNoContent handles this case with default header values.

Success.
*/
type UploadLogsNoContent struct {
}

func (o *UploadLogsNoContent) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/logs][%d] uploadLogsNoContent ", 204)
}

func (o *UploadLogsNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewUploadLogsUnauthorized creates a UploadLogsUnauthorized with default headers values
func NewUploadLogsUnauthorized() *UploadLogsUnauthorized {
	return &UploadLogsUnauthorized{}
}

/*UploadLogsUnauthorized handles this case with default header values.

Unauthorized.
*/
type UploadLogsUnauthorized struct {
	Payload *models.InfraError
}

func (o *UploadLogsUnauthorized) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/logs][%d] uploadLogsUnauthorized  %+v", 401, o.Payload)
}

func (o *UploadLogsUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *UploadLogsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUploadLogsForbidden creates a UploadLogsForbidden with default headers values
func NewUploadLogsForbidden() *UploadLogsForbidden {
	return &UploadLogsForbidden{}
}

/*UploadLogsForbidden handles this case with default header values.

Forbidden.
*/
type UploadLogsForbidden struct {
	Payload *models.InfraError
}

func (o *UploadLogsForbidden) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/logs][%d] uploadLogsForbidden  %+v", 403, o.Payload)
}

func (o *UploadLogsForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *UploadLogsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUploadLogsNotFound creates a UploadLogsNotFound with default headers values
func NewUploadLogsNotFound() *UploadLogsNotFound {
	return &UploadLogsNotFound{}
}

/*UploadLogsNotFound handles this case with default header values.

Error.
*/
type UploadLogsNotFound struct {
	Payload *models.Error
}

func (o *UploadLogsNotFound) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/logs][%d] uploadLogsNotFound  %+v", 404, o.Payload)
}

func (o *UploadLogsNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *UploadLogsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUploadLogsInternalServerError creates a UploadLogsInternalServerError with default headers values
func NewUploadLogsInternalServerError() *UploadLogsInternalServerError {
	return &UploadLogsInternalServerError{}
}

/*UploadLogsInternalServerError handles this case with default header values.

Error.
*/
type UploadLogsInternalServerError struct {
	Payload *models.Error
}

func (o *UploadLogsInternalServerError) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/logs][%d] uploadLogsInternalServerError  %+v", 500, o.Payload)
}

func (o *UploadLogsInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *UploadLogsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUploadLogsServiceUnavailable creates a UploadLogsServiceUnavailable with default headers values
func NewUploadLogsServiceUnavailable() *UploadLogsServiceUnavailable {
	return &UploadLogsServiceUnavailable{}
}

/*UploadLogsServiceUnavailable handles this case with default header values.

Unavailable.
*/
type UploadLogsServiceUnavailable struct {
	Payload *models.Error
}

func (o *UploadLogsServiceUnavailable) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/logs][%d] uploadLogsServiceUnavailable  %+v", 503, o.Payload)
}

func (o *UploadLogsServiceUnavailable) GetPayload() *models.Error {
	return o.Payload
}

func (o *UploadLogsServiceUnavailable) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
