// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// InfraEnvCreateParams infra env create params
//
// swagger:model infra-env-create-params
type InfraEnvCreateParams struct {

	// A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.
	AdditionalNtpSources *string `json:"additional_ntp_sources,omitempty"`

	// If set, all hosts that register will be associated with the specified cluster.
	// Format: uuid
	ClusterID *strfmt.UUID `json:"cluster_id,omitempty"`

	// JSON formatted string containing the user overrides for the initial ignition config.
	IgnitionConfigOverride string `json:"ignition_config_override,omitempty"`

	// image type
	ImageType ImageType `json:"image_type,omitempty"`

	// Name of the InfraEnv.
	// Required: true
	Name *string `json:"name"`

	// Version of the OpenShift cluster (used to infer the RHCOS version - temporary until generic logic implemented).
	// Required: true
	OpenshiftVersion *string `json:"openshift_version"`

	// proxy
	Proxy *Proxy `json:"proxy,omitempty"`

	// The pull secret obtained from Red Hat OpenShift Cluster Manager at cloud.redhat.com/openshift/install/pull-secret.
	// Required: true
	PullSecret *string `json:"pull_secret"`

	// SSH public key for debugging the installation.
	SSHAuthorizedKey *string `json:"ssh_authorized_key,omitempty"`

	// static network config
	StaticNetworkConfig []*HostStaticNetworkConfig `json:"static_network_config"`
}

// Validate validates this infra env create params
func (m *InfraEnvCreateParams) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClusterID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateImageType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOpenshiftVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProxy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePullSecret(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStaticNetworkConfig(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *InfraEnvCreateParams) validateClusterID(formats strfmt.Registry) error {

	if swag.IsZero(m.ClusterID) { // not required
		return nil
	}

	if err := validate.FormatOf("cluster_id", "body", "uuid", m.ClusterID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *InfraEnvCreateParams) validateImageType(formats strfmt.Registry) error {

	if swag.IsZero(m.ImageType) { // not required
		return nil
	}

	if err := m.ImageType.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("image_type")
		}
		return err
	}

	return nil
}

func (m *InfraEnvCreateParams) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *InfraEnvCreateParams) validateOpenshiftVersion(formats strfmt.Registry) error {

	if err := validate.Required("openshift_version", "body", m.OpenshiftVersion); err != nil {
		return err
	}

	return nil
}

func (m *InfraEnvCreateParams) validateProxy(formats strfmt.Registry) error {

	if swag.IsZero(m.Proxy) { // not required
		return nil
	}

	if m.Proxy != nil {
		if err := m.Proxy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proxy")
			}
			return err
		}
	}

	return nil
}

func (m *InfraEnvCreateParams) validatePullSecret(formats strfmt.Registry) error {

	if err := validate.Required("pull_secret", "body", m.PullSecret); err != nil {
		return err
	}

	return nil
}

func (m *InfraEnvCreateParams) validateStaticNetworkConfig(formats strfmt.Registry) error {

	if swag.IsZero(m.StaticNetworkConfig) { // not required
		return nil
	}

	for i := 0; i < len(m.StaticNetworkConfig); i++ {
		if swag.IsZero(m.StaticNetworkConfig[i]) { // not required
			continue
		}

		if m.StaticNetworkConfig[i] != nil {
			if err := m.StaticNetworkConfig[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("static_network_config" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *InfraEnvCreateParams) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *InfraEnvCreateParams) UnmarshalBinary(b []byte) error {
	var res InfraEnvCreateParams
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
