// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// InfraEnvUpdateParams infra env update params
//
// swagger:model infra-env-update-params
type InfraEnvUpdateParams struct {

	// A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.
	AdditionalNtpSources *string `json:"additional_ntp_sources,omitempty"`

	// If set, all hosts that register will be associated with the specified cluster.
	// Format: uuid
	ClusterID *strfmt.UUID `json:"cluster_id,omitempty"`

	// JSON formatted string containing the user overrides for the initial ignition config.
	IgnitionConfigOverride string `json:"ignition_config_override,omitempty"`

	// image type
	ImageType ImageType `json:"image_type,omitempty"`

	// proxy
	Proxy *Proxy `json:"proxy,omitempty"`

	// The pull secret obtained from Red Hat OpenShift Cluster Manager at cloud.redhat.com/openshift/install/pull-secret.
	PullSecret string `json:"pull_secret,omitempty"`

	// SSH public key for debugging the installation.
	SSHAuthorizedKey *string `json:"ssh_authorized_key,omitempty"`

	// static network config
	StaticNetworkConfig []*HostStaticNetworkConfig `json:"static_network_config"`
}

// Validate validates this infra env update params
func (m *InfraEnvUpdateParams) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClusterID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateImageType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProxy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStaticNetworkConfig(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *InfraEnvUpdateParams) validateClusterID(formats strfmt.Registry) error {

	if swag.IsZero(m.ClusterID) { // not required
		return nil
	}

	if err := validate.FormatOf("cluster_id", "body", "uuid", m.ClusterID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *InfraEnvUpdateParams) validateImageType(formats strfmt.Registry) error {

	if swag.IsZero(m.ImageType) { // not required
		return nil
	}

	if err := m.ImageType.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("image_type")
		}
		return err
	}

	return nil
}

func (m *InfraEnvUpdateParams) validateProxy(formats strfmt.Registry) error {

	if swag.IsZero(m.Proxy) { // not required
		return nil
	}

	if m.Proxy != nil {
		if err := m.Proxy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proxy")
			}
			return err
		}
	}

	return nil
}

func (m *InfraEnvUpdateParams) validateStaticNetworkConfig(formats strfmt.Registry) error {

	if swag.IsZero(m.StaticNetworkConfig) { // not required
		return nil
	}

	for i := 0; i < len(m.StaticNetworkConfig); i++ {
		if swag.IsZero(m.StaticNetworkConfig[i]) { // not required
			continue
		}

		if m.StaticNetworkConfig[i] != nil {
			if err := m.StaticNetworkConfig[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("static_network_config" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *InfraEnvUpdateParams) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *InfraEnvUpdateParams) UnmarshalBinary(b []byte) error {
	var res InfraEnvUpdateParams
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
