// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VspherePlatform Vsphere platform specific configuration upon which to perform the installation
//
// swagger:model vsphere_platform
type VspherePlatform struct {

	// The vCenter cluster to install the OpenShift Container Platform cluster in.
	Cluster *string `json:"cluster,omitempty"`

	// The name of the datacenter to use in the vCenter instance.
	Datacenter *string `json:"datacenter,omitempty"`

	// The name of the default datastore to use for provisioning volumes.
	DefaultDatastore *string `json:"defaultDatastore,omitempty"`

	// Optional. The absolute path of an existing folder where the installation program creates the virtual machines. If you do not provide this value, the installation program creates a folder that is named with the infrastructure ID in the datacenter virtual machine folder.
	Folder *string `json:"folder,omitempty"`

	// The network in the vCenter instance that contains the virtual IP addresses and DNS records that you configured.
	Network *string `json:"network,omitempty"`

	// The password for the vCenter user name.
	// Format: password
	Password *strfmt.Password `json:"password,omitempty"`

	// The user name to use to connect to the vCenter instance with. This user must have at least the roles and privileges that are required for static or dynamic persistent volume provisioning in vSphere.
	Username *string `json:"username,omitempty"`

	// The fully-qualified hostname or IP address of the vCenter server.
	VCenter *string `json:"vCenter,omitempty"`
}

// Validate validates this vsphere platform
func (m *VspherePlatform) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VspherePlatform) validatePassword(formats strfmt.Registry) error {

	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.FormatOf("password", "body", "password", m.Password.String(), formats); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VspherePlatform) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VspherePlatform) UnmarshalBinary(b []byte) error {
	var res VspherePlatform
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
