// Code generated by go-swagger; DO NOT EDIT.

package restapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http",
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "Assisted installation",
    "title": "AssistedInstall",
    "license": {
      "name": "Apache 2.0",
      "url": "http://www.apache.org/licenses/LICENSE-2.0.html"
    },
    "version": "1.0.0"
  },
  "host": "api.openshift.com",
  "basePath": "/api/assisted-install",
  "paths": {
    "/v1/add_hosts_clusters": {
      "post": {
        "description": "Creates a new OpenShift cluster definition for adding nodes to and existing OCP cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "RegisterAddHostsCluster",
        "parameters": [
          {
            "description": "Parameters for creating a new cluster for adding nodes.",
            "name": "new-add-hosts-cluster-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/add-hosts-cluster-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/assisted-service-iso": {
      "post": {
        "description": "Creates ISO for the user and uploads to S3.",
        "tags": [
          "assisted-service-iso"
        ],
        "operationId": "CreateISOAndUploadToS3",
        "parameters": [
          {
            "description": "Parameters for creating an Assisted Service ISO.",
            "name": "assisted-service-iso-create-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/assisted-service-iso-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/assisted-service-iso/data": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Downloads the Assisted Service ISO.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "assisted-service-iso"
        ],
        "operationId": "DownloadISO",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/assisted-service-iso/presigned": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves a pre-signed S3 URL for downloading assisted-service ISO.",
        "tags": [
          "assisted-service-iso"
        ],
        "operationId": "GetPresignedForAssistedServiceISO",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/presigned"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves the list of OpenShift clusters.",
        "tags": [
          "installer"
        ],
        "operationId": "ListClusters",
        "parameters": [
          {
            "type": "boolean",
            "default": false,
            "description": "Whether to return clusters that have been unregistered.",
            "name": "get_unregistered_clusters",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "A specific cluster to retrieve.",
            "name": "openshift_cluster_id",
            "in": "query"
          },
          {
            "type": "array",
            "items": {
              "type": "string"
            },
            "description": "If non-empty, returned Clusters are filtered to those with matching subscription IDs.",
            "name": "ams_subscription_ids",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "Include hosts in the returned list.",
            "name": "with_hosts",
            "in": "query",
            "allowEmptyValue": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "description": "Creates a new OpenShift cluster definition.",
        "tags": [
          "installer"
        ],
        "operationId": "RegisterCluster",
        "parameters": [
          {
            "description": "The properties describing the new cluster.",
            "name": "new-cluster-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cluster-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/default-config": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Get the default values for various cluster properties.",
        "tags": [
          "installer"
        ],
        "operationId": "GetClusterDefaultConfig",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster_default_config"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "agentAuth": []
          }
        ],
        "description": "Retrieves the details of the OpenShift cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "GetCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to be retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is retrieving the cluster details.",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "Whether to return clusters that have been unregistered.",
            "name": "get_unregistered_clusters",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "description": "Deletes an OpenShift cluster definition.",
        "tags": [
          "installer"
        ],
        "operationId": "DeregisterCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to be deregistered.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "description": "Updates an OpenShift cluster definition.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to be updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The properties to update.",
            "name": "cluster-update-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cluster-update-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/actions/cancel": {
      "post": {
        "description": "Cancels an ongoing installation.",
        "tags": [
          "installer"
        ],
        "operationId": "CancelInstallation",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose installation is to be canceled.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/actions/complete_installation": {
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Agent API to mark a finalizing installation as complete.",
        "tags": [
          "installer"
        ],
        "operationId": "CompleteInstallation",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose installation is being completing.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The final status of the cluster installation.",
            "name": "completion-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/completion-params"
            }
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is completing the installation.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/actions/install": {
      "post": {
        "description": "Installs the OpenShift cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "InstallCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to be installed.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/actions/install_hosts": {
      "post": {
        "description": "Installs the OpenShift cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "InstallHosts",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The existing cluster whose hosts should be added.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/actions/reset": {
      "post": {
        "description": "Resets a failed installation.",
        "tags": [
          "installer"
        ],
        "operationId": "ResetCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose installation is to be reset.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/credentials": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Get the cluster admin credentials.",
        "tags": [
          "installer"
        ],
        "operationId": "GetCredentials",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose admin credentials should be retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/credentials"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/discovery-ignition": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Get the discovery ignition for the cluster based on its attributes and overridden ignition value before generating the discovery ISO.\nUsed to test the validity of the discovery ignition when it is being overridden.\nFor downloading the generated discovery ignition use /clusters/$CLUSTER_ID/downloads/files?file_name=discovery.ign\n",
        "tags": [
          "installer"
        ],
        "operationId": "GetDiscoveryIgnition",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster for which the discovery ignition config should be retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/discovery-ignition-params"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "description": "Override values in the discovery ignition config.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateDiscoveryIgnition",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster for which the discovery ignition config should be updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "Overrides for the discovery ignition config.",
            "name": "discovery-ignition-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/discovery-ignition-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/downloads/files": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "agentAuth": []
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Downloads files relating to the installed/installing cluster.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadClusterFiles",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster that owns the file that should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "bootstrap.ign",
              "master.ign",
              "metadata.json",
              "worker.ign",
              "kubeadmin-password",
              "kubeconfig",
              "kubeconfig-noingress",
              "install-config.yaml",
              "discovery.ign",
              "custom_manifests.yaml"
            ],
            "type": "string",
            "description": "The file to be downloaded.",
            "name": "file_name",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is downloading the file.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/downloads/files-presigned": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves a pre-signed S3 URL for downloading cluster files.",
        "tags": [
          "installer"
        ],
        "operationId": "GetPresignedForClusterFiles",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster that owns the file that should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "bootstrap.ign",
              "master.ign",
              "metadata.json",
              "worker.ign",
              "kubeadmin-password",
              "kubeconfig",
              "kubeconfig-noingress",
              "install-config.yaml",
              "logs",
              "manifests"
            ],
            "type": "string",
            "description": "The file to be downloaded.",
            "name": "file_name",
            "in": "query",
            "required": true
          },
          {
            "enum": [
              "host",
              "controller",
              "all"
            ],
            "type": "string",
            "description": "If downloading logs, the type of logs to download.",
            "name": "logs_type",
            "in": "query"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "If downloading a file related to a host, the relevant host.",
            "name": "host_id",
            "in": "query"
          },
          {
            "type": "string",
            "description": "If downloading a manifest, the file name, prefaced with folder name, for example, openshift/99-openshift-xyz.yaml.",
            "name": "additional_name",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/presigned"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/downloads/image": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Downloads the OpenShift per-cluster Discovery ISO.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadClusterISO",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose ISO should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed."
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "description": "Creates a new OpenShift per-cluster Discovery ISO.",
        "tags": [
          "installer"
        ],
        "operationId": "GenerateClusterISO",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose ISO should be generated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The parameters for the generated ISO.",
            "name": "image-create-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/image-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "head": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Downloads the OpenShift per-cluster Discovery ISO Headers only.",
        "tags": [
          "installer"
        ],
        "operationId": "DownloadClusterISOHeaders",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose ISO headers should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "headers": {
              "Content-Length": {
                "type": "integer",
                "description": "Size of the ISO in bytes"
              }
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed."
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/downloads/kubeconfig": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Downloads the kubeconfig file for this cluster.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadClusterKubeconfig",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose kubeconfig should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/events": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Lists events for a cluster.",
        "tags": [
          "events"
        ],
        "operationId": "ListEvents",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to return events for.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "A host in the specified cluster to return events for.",
            "name": "host_id",
            "in": "query"
          },
          {
            "type": "array",
            "items": {
              "type": "string"
            },
            "description": "A comma-separated list of event categories.",
            "name": "categories",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/event-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/free_addresses": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves the free address list for a network.",
        "tags": [
          "installer"
        ],
        "operationId": "GetFreeAddresses",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to return free addresses for.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$",
            "type": "string",
            "description": "The cluster network to return free addresses for.",
            "name": "network",
            "in": "query",
            "required": true
          },
          {
            "maximum": 8000,
            "minimum": 1,
            "type": "integer",
            "default": 8000,
            "description": "The maximum number of free addresses to return.",
            "name": "limit",
            "in": "query"
          },
          {
            "type": "string",
            "description": "A prefix for the free addresses to return.",
            "name": "prefix",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/free-addresses-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/host-requirements": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Get host requirements of a cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "GetClusterHostRequirements",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to return operators for.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster-host-requirements-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "agentAuth": []
          }
        ],
        "description": "Retrieves the list of OpenShift hosts.",
        "tags": [
          "installer"
        ],
        "operationId": "ListHosts",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose hosts should be listed.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is listing hosts.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Registers a new OpenShift host.",
        "tags": [
          "installer"
        ],
        "operationId": "RegisterHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster into which the host should be registered.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The description of the host being registered.",
            "name": "new-host-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-create-params"
            }
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is registering the host.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host_registration_response"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Cluster cannot accept new hosts due to its current state.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves the details of the OpenShift host.",
        "tags": [
          "installer"
        ],
        "operationId": "GetHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that should be retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that should be retrieved.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "description": "Deregisters an OpenShift host.",
        "tags": [
          "installer"
        ],
        "operationId": "DeregisterHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that should be deregistered.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that should be deregistered.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/enable": {
      "post": {
        "description": "Enables a host for inclusion in the cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "EnableHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that is being enabled.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is being enabled.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "description": "Disables a host for inclusion in the cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "DisableHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that is being disabled.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is being disabled.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/install": {
      "post": {
        "description": "install specific host for day2 cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "InstallHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that is being installed.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is being installed.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/reset": {
      "post": {
        "description": "reset a failed host for day2 cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "ResetHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that is being reset.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is being reset.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/reset-validation/{validation_id}": {
      "patch": {
        "description": "Reset failed host validation.  It may be performed on any host validation with persistent validation result.",
        "tags": [
          "installer"
        ],
        "summary": "Reset failed host validation.",
        "operationId": "ResetHostValidation",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that its validation is being reset.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that its validation is being reset.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The id of the validation being reset.",
            "name": "validation_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "400": {
            "description": "Bad Request",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/downloads/ignition": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "agentAuth": []
          }
        ],
        "description": "Downloads the customized ignition file for this host",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadHostIgnition",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host whose ignition file should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose ignition file should be downloaded.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/ignition": {
      "get": {
        "description": "Get the customized ignition file for this host",
        "tags": [
          "installer"
        ],
        "operationId": "GetHostIgnition",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host whose customized ignition file should be retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose customized ignition file should be retrieved.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host-ignition-params"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "description": "Patch the ignition file for this host",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateHostIgnition",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host whose ignition file should be updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose ignition file should be updated.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "Ignition config overrides.",
            "name": "host-ignition-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-ignition-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/installer-args": {
      "patch": {
        "description": "Updates a host's installer arguments.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateHostInstallerArgs",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host whose installer arguments should be updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose installer arguments should be updated.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The updated installer arguments.",
            "name": "installer-args-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/installer-args-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/instructions": {
      "get": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Retrieves the next operations that the host agent needs to perform.",
        "tags": [
          "installer"
        ],
        "operationId": "GetNextSteps",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that is retrieving instructions.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is retrieving instructions.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is retrieving instructions.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/steps"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Posts the result of the operations from the host agent.",
        "tags": [
          "installer"
        ],
        "operationId": "PostStepReply",
        "parameters": [
          {
            "type": "string",
            "description": "The software version of the discovery agent that is posting results.",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that is posting results.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is posting results.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The results to be posted.",
            "name": "reply",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/step-reply"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/logs": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Download host logs.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadHostLogs",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host whose logs should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose logs should be downloaded.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Agent API to upload logs.",
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "UploadHostLogs",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host whose logs should be uploaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose logs should be uploaded.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "type": "file",
            "x-mimetype": "application/zip",
            "description": "The log file to be uploaded.",
            "name": "upfile",
            "in": "formData"
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is uploading the logs.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/logs_progress": {
      "put": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Update log collection state and progress.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateHostLogsProgress",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose log progress is being updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose log progress is being updated.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "Parameters for updating log progress.",
            "name": "logs-progress-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/logs-progress-params"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Update cluster install progress."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/progress": {
      "put": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Update installation progress.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateHostInstallProgress",
        "parameters": [
          {
            "type": "string",
            "description": "The software version of the discovery agent that is updating progress.",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the cluster to retrieve.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the host to retrieve.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "New progress value.",
            "name": "host-progress",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-progress"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Update install progress."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/install-config": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Get the cluster's install config YAML.",
        "tags": [
          "installer"
        ],
        "operationId": "GetClusterInstallConfig",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose install config is being retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "description": "Override values in the install config.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateClusterInstallConfig",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose install config is being updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "Install config overrides.",
            "name": "install-config-params",
            "in": "body",
            "required": true,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/logs": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Download cluster logs.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadClusterLogs",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose logs should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "host",
              "controller",
              "all"
            ],
            "type": "string",
            "description": "The type of logs to be downloaded.",
            "name": "logs_type",
            "in": "query"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "A specific host in the cluster whose logs should be downloaded.",
            "name": "host_id",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Agent API to upload logs.",
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "UploadLogs",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose logs should be uploaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "maxLength": 104857600,
            "type": "file",
            "x-mimetype": "application/zip",
            "description": "The log file to be uploaded.",
            "name": "upfile",
            "in": "formData"
          },
          {
            "enum": [
              "host",
              "controller"
            ],
            "type": "string",
            "description": "The type of log file to be uploaded.",
            "name": "logs_type",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose logs should be uploaded.",
            "name": "host_id",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/logs_progress": {
      "put": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Update log collection state and progress.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateClusterLogsProgress",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose log progress is being updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "Parameters for updating log progress.",
            "name": "logs-progress-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/logs-progress-params"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Update cluster install progress."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/manifests": {
      "get": {
        "security": [
          {
            "userAuth": []
          }
        ],
        "description": "Lists manifests for customizing cluster installation.",
        "tags": [
          "manifests"
        ],
        "operationId": "ListClusterManifests",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster for which the manifests should be listed.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/list-manifests"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "userAuth": []
          }
        ],
        "description": "Creates a manifest for customizing cluster installation.",
        "tags": [
          "manifests"
        ],
        "operationId": "CreateClusterManifest",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster for which a new manifest should be created.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The new manifest to create.",
            "name": "CreateManifestParams",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/create-manifest-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/manifest"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "description": "Deletes a manifest from the cluster.",
        "tags": [
          "manifests"
        ],
        "operationId": "DeleteClusterManifest",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose manifest should be deleted.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "manifests",
              "openshift"
            ],
            "type": "string",
            "default": "manifests",
            "description": "The folder that contains the files. Manifests can be placed in 'manifests' or 'openshift' directories.",
            "name": "folder",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The manifest file name to delete from the cluster.",
            "name": "file_name",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/manifests/files": {
      "get": {
        "security": [
          {
            "userAuth": []
          }
        ],
        "description": "Downloads cluster manifest.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "manifests"
        ],
        "operationId": "DownloadClusterManifest",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose manifest should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "manifests",
              "openshift"
            ],
            "type": "string",
            "default": "manifests",
            "description": "The folder that contains the files. Manifests can be placed in 'manifests' or 'openshift' directories.",
            "name": "folder",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The manifest file name to download.",
            "name": "file_name",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/monitored_operators": {
      "get": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Lists operators to be monitored for a cluster.",
        "tags": [
          "operators",
          "installer"
        ],
        "operationId": "ListOfClusterOperators",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to return operators for.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "An operator in the specified cluster to return its data.",
            "name": "operator_name",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/monitored-operators-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "put": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Controller API to report of monitored operators.",
        "tags": [
          "operators",
          "installer"
        ],
        "operationId": "ReportMonitoredOperatorStatus",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose operators are being monitored.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The operators monitor report.",
            "name": "report-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/operator-monitor-report"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Success."
          },
          "400": {
            "description": "Bad Request",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/preflight-requirements": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Get preflight requirements for a cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "GetPreflightRequirements",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to return preflight requrements for.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/preflight-hardware-requirements"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/uploads/ingress-cert": {
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Transfer the ingress certificate for the cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "UploadClusterIngressCert",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to associate with the ingress certificate.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The ingress certificate.",
            "name": "ingress-cert-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ingress-cert-params"
            }
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is uploading the ingress certificate.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/component_versions": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "List of component versions.",
        "tags": [
          "versions"
        ],
        "operationId": "ListComponentVersions",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/list-versions"
            }
          }
        }
      }
    },
    "/v1/domains": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "List of managed DNS domains.",
        "tags": [
          "managed_domains"
        ],
        "operationId": "ListManagedDomains",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/list-managed-domains"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/openshift_versions": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves the list of OpenShift supported versions.",
        "tags": [
          "versions"
        ],
        "operationId": "ListSupportedOpenshiftVersions",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/openshift-versions"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/supported-operators": {
      "get": {
        "description": "Retrieves the list of supported operators.",
        "tags": [
          "operators"
        ],
        "operationId": "ListSupportedOperators",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/supported-operators/{operator_name}": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Lists properties for an operator.",
        "tags": [
          "operators"
        ],
        "operationId": "ListOperatorProperties",
        "parameters": [
          {
            "type": "string",
            "description": "The operator name.",
            "name": "operator_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/operator-properties"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/clusters/{cluster_id}/supported-platforms": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "A list of platforms that this cluster can support in its current configuration.",
        "tags": [
          "installer"
        ],
        "operationId": "GetClusterSupportedPlatforms",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose platform types should be retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/platform_type"
              }
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves the list of InfraEnvs.",
        "tags": [
          "installer"
        ],
        "operationId": "ListInfraEnvs",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/infra-env-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "description": "Creates a new OpenShift Discovery ISO.",
        "tags": [
          "installer"
        ],
        "operationId": "RegisterInfraEnv",
        "parameters": [
          {
            "description": "The parameters for the generated ISO.",
            "name": "infraenv-create-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/infra-env-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/infra-env"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs/{infra_env_id}": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "agentAuth": []
          }
        ],
        "description": "Retrieves the details of the InfraEnv.",
        "tags": [
          "installer"
        ],
        "operationId": "GetInfraEnv",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv to be retrieved.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/infra-env"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "description": "Deletes an InfraEnv.",
        "tags": [
          "installer"
        ],
        "operationId": "DeregisterInfraEnv",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv to be deleted.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "description": "Updates an InfraEnv.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateInfraEnv",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv to be updated.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The properties to update.",
            "name": "infra-env-update-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/infra-env-update-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/infra-env"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs/{infra_env_id}/hosts": {
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Registers a new OpenShift agent.",
        "tags": [
          "installer"
        ],
        "operationId": "v2RegisterHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv that the agent is associated with.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The description of the agent being registered.",
            "name": "new-host-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-create-params"
            }
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is registering the agent.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host_registration_response"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Cluster cannot accept new agents due to its current state.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs/{infra_env_id}/hosts/{host_id}": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves the details of the OpenShift host.",
        "tags": [
          "installer"
        ],
        "operationId": "v2GetHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The infra env of the host that should be retrieved.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that should be retrieved.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/instructions": {
      "get": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Retrieves the next operations that the host agent needs to perform.",
        "tags": [
          "installer"
        ],
        "operationId": "v2GetNextSteps",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The infra env of the host that is retrieving instructions.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is retrieving instructions.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is retrieving instructions.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/steps"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Posts the result of the operations from the host agent.",
        "tags": [
          "installer"
        ],
        "operationId": "v2PostStepReply",
        "parameters": [
          {
            "type": "string",
            "description": "The software version of the discovery agent that is posting results.",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The infra env of the host that is posting results.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is posting results.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The results to be posted.",
            "name": "reply",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/step-reply"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/progress": {
      "put": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Update installation progress.",
        "tags": [
          "installer"
        ],
        "operationId": "v2UpdateHostInstallProgress",
        "parameters": [
          {
            "type": "string",
            "description": "The software version of the discovery agent that is updating progress.",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv of the host being updated.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the host to update.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "New progress value.",
            "name": "host-progress",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-progress"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Update install progress."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs/{infra_env_id}/image": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Downloads the discovery image.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadInfraEnvDiscoveryImage",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv whose image should be downloaded.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed."
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "head": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Downloads the discovery image Headers only.",
        "tags": [
          "installer"
        ],
        "operationId": "DownloadInfraEnvDiscoveryImageHeaders",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv whose image headers should be retrieved.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "headers": {
              "Content-Length": {
                "type": "integer",
                "description": "Size of the ISO in bytes"
              }
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed."
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "add-hosts-cluster-create-params": {
      "type": "object",
      "required": [
        "id",
        "name",
        "api_vip_dnsname",
        "openshift_version"
      ],
      "properties": {
        "api_vip_dnsname": {
          "description": "api vip domain.",
          "type": "string"
        },
        "id": {
          "description": "Unique identifier of the object.",
          "type": "string",
          "format": "uuid"
        },
        "name": {
          "description": "Name of the OpenShift cluster.",
          "type": "string"
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster.",
          "type": "string"
        }
      }
    },
    "api_vip_connectivity_request": {
      "type": "object",
      "required": [
        "url"
      ],
      "properties": {
        "url": {
          "description": "URL address of the API.",
          "type": "string"
        },
        "verify_cidr": {
          "description": "Whether to verify if the API VIP belongs to one of the interfaces.",
          "type": "boolean"
        }
      }
    },
    "api_vip_connectivity_response": {
      "type": "object",
      "properties": {
        "is_success": {
          "description": "API VIP connectivity check result.",
          "type": "boolean"
        }
      }
    },
    "assisted-service-iso-create-params": {
      "type": "object",
      "properties": {
        "openshift_version": {
          "description": "Version of the OpenShift cluster.",
          "type": "string"
        },
        "pull_secret": {
          "description": "The pull secret obtained from Red Hat OpenShift Cluster Manager at cloud.redhat.com/openshift/install/pull-secret.",
          "type": "string"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string"
        }
      }
    },
    "boot": {
      "type": "object",
      "properties": {
        "current_boot_mode": {
          "type": "string"
        },
        "pxe_interface": {
          "type": "string"
        }
      }
    },
    "cluster": {
      "type": "object",
      "required": [
        "kind",
        "id",
        "href",
        "image_info",
        "status",
        "status_info"
      ],
      "properties": {
        "additional_ntp_source": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string"
        },
        "ams_subscription_id": {
          "description": "Unique identifier of the AMS subscription in OCM.",
          "type": "string",
          "format": "uuid"
        },
        "api_vip": {
          "description": "The virtual IP used to reach the OpenShift cluster's API.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3})|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,}))$"
        },
        "api_vip_dns_name": {
          "description": "The domain name used to reach the OpenShift cluster API.",
          "type": "string",
          "x-nullable": true
        },
        "base_dns_domain": {
          "description": "Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.",
          "type": "string"
        },
        "cluster_network_cidr": {
          "description": "IP address block from which Pod IPs are allocated. This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$"
        },
        "cluster_network_host_prefix": {
          "description": "The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.",
          "type": "integer",
          "maximum": 128,
          "minimum": 1
        },
        "connectivity_majority_groups": {
          "description": "Json formatted string containing the majority groups for connectivity checks.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "controller_logs_collected_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "controller_logs_started_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "created_at": {
          "description": "The time that this cluster was created.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "deleted_at": {
          "description": "The time that the cluster was deleted.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\"",
          "x-nullable": true
        },
        "email_domain": {
          "type": "string"
        },
        "enabled_host_count": {
          "description": "hosts associated to this cluster that are not in 'disabled' state.",
          "type": "integer",
          "format": "int64",
          "x-go-custom-tag": "gorm:\"-\""
        },
        "feature_usage": {
          "description": "JSON-formatted string containing the usage information by feature name",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "high_availability_mode": {
          "description": "Guaranteed availability of the installed cluster. 'Full' installs a Highly-Available cluster\nover multiple master nodes whereas 'None' installs a full cluster over one node.\n",
          "type": "string",
          "default": "Full",
          "enum": [
            "Full",
            "None"
          ]
        },
        "host_networks": {
          "description": "List of host networks to be filled during query.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/host_network"
          },
          "x-go-custom-tag": "gorm:\"-\""
        },
        "hosts": {
          "description": "Hosts that are associated with this cluster.",
          "type": "array",
          "items": {
            "type": "object",
            "$ref": "#/definitions/host"
          },
          "x-go-custom-tag": "gorm:\"foreignkey:ClusterID;association_foreignkey:ID\""
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string"
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-go-custom-tag": "gorm:\"column:https_proxy\""
        },
        "hyperthreading": {
          "description": "Enable/disable hyperthreading on master nodes, worker nodes, or all nodes",
          "type": "string",
          "enum": [
            "masters",
            "workers",
            "all",
            "none"
          ]
        },
        "id": {
          "description": "Unique identifier of the object.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key\""
        },
        "ignition_config_overrides": {
          "description": "Json formatted string containing the user overrides for the initial ignition config",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\"",
          "example": "{\"ignition\": {\"version\": \"3.1.0\"}, \"storage\": {\"files\": [{\"path\": \"/tmp/example\", \"contents\": {\"source\": \"data:text/plain;base64,aGVscGltdHJhcHBlZGluYXN3YWdnZXJzcGVj\"}}]}}"
        },
        "image_info": {
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:image_\"",
          "$ref": "#/definitions/image_info"
        },
        "ingress_vip": {
          "description": "The virtual IP used for cluster ingress traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3})|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,}))$"
        },
        "install_completed_at": {
          "description": "The time that this cluster completed installation.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone;default:'2000-01-01 00:00:00z'\""
        },
        "install_config_overrides": {
          "description": "JSON-formatted string containing the user overrides for the install-config.yaml file.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\"",
          "example": "{\"networking\":{\"networkType\": \"OVN-Kubernetes\"},\"fips\":true}"
        },
        "install_started_at": {
          "description": "The time that this cluster started installation.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone;default:'2000-01-01 00:00:00z'\""
        },
        "kind": {
          "description": "Indicates the type of this object. Will be 'Cluster' if this is a complete object,\n'AddHostsCluster' for cluster that add hosts to existing OCP cluster,\n",
          "type": "string",
          "enum": [
            "Cluster",
            "AddHostsCluster"
          ]
        },
        "logs_info": {
          "description": "The progress of log collection or empty if logs are not applicable",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\"",
          "$ref": "#/definitions/logs_state"
        },
        "machine_network_cidr": {
          "description": "A CIDR that all hosts belonging to the cluster should have an interfaces with IP address that belongs to this CIDR. The api_vip belongs to this CIDR.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$"
        },
        "monitored_operators": {
          "description": "Operators that are associated with this cluster.",
          "type": "array",
          "items": {
            "type": "object",
            "$ref": "#/definitions/monitored-operator"
          },
          "x-go-custom-tag": "gorm:\"foreignkey:ClusterID;association_foreignkey:ID\""
        },
        "name": {
          "description": "Name of the OpenShift cluster.",
          "type": "string"
        },
        "network_configuration": {
          "description": "JSON-formatted string containing the networking data for the install-config.yaml file.",
          "type": "string"
        },
        "network_type": {
          "description": "The desired network type used.",
          "type": "string",
          "enum": [
            "OpenShiftSDN",
            "OVNKubernetes"
          ],
          "x-nullable": true
        },
        "no_proxy": {
          "description": "A comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude from proxying.",
          "type": "string"
        },
        "ocp_release_image": {
          "description": "OpenShift release image URI.",
          "type": "string"
        },
        "openshift_cluster_id": {
          "description": "Cluster ID on OCP system.",
          "type": "string",
          "format": "uuid"
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster.",
          "type": "string"
        },
        "org_id": {
          "type": "string"
        },
        "platform": {
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:platform_\"",
          "$ref": "#/definitions/platform"
        },
        "progress": {
          "description": "Installation progress percentages of the cluster.",
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:progress_\"",
          "$ref": "#/definitions/cluster-progress-info"
        },
        "pull_secret_set": {
          "description": "True if the pull secret has been added to the cluster.",
          "type": "boolean"
        },
        "ready_host_count": {
          "description": "hosts associated to this cluster that are in 'known' state.",
          "type": "integer",
          "format": "int64",
          "x-go-custom-tag": "gorm:\"-\""
        },
        "schedulable_masters": {
          "description": "Schedule workloads on masters",
          "type": "boolean",
          "default": false
        },
        "service_network_cidr": {
          "description": "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging OpenShift nodes.",
          "type": "string"
        },
        "status": {
          "description": "Status of the OpenShift cluster.",
          "type": "string",
          "enum": [
            "insufficient",
            "ready",
            "error",
            "preparing-for-installation",
            "pending-for-input",
            "installing",
            "finalizing",
            "installed",
            "adding-hosts",
            "cancelled",
            "installing-pending-user-action"
          ]
        },
        "status_info": {
          "description": "Additional information pertaining to the status of the OpenShift cluster.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "status_updated_at": {
          "description": "The last time that the cluster status was updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "total_host_count": {
          "description": "All hosts associated to this cluster.",
          "type": "integer",
          "format": "int64",
          "x-go-custom-tag": "gorm:\"-\""
        },
        "updated_at": {
          "description": "The last time that this cluster was updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "user_managed_networking": {
          "description": "Indicate if the networking is managed by the user.",
          "type": "boolean",
          "x-nullable": true
        },
        "user_name": {
          "type": "string"
        },
        "validations_info": {
          "description": "JSON-formatted string containing the validation results for each validation id grouped by category (network, hosts-data, etc.)",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "vip_dhcp_allocation": {
          "description": "Indicate if virtual IP DHCP allocation mode is enabled.",
          "type": "boolean",
          "x-nullable": true
        }
      }
    },
    "cluster-create-params": {
      "type": "object",
      "required": [
        "name",
        "openshift_version",
        "pull_secret"
      ],
      "properties": {
        "additional_ntp_source": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string",
          "x-nullable": true
        },
        "base_dns_domain": {
          "description": "Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.",
          "type": "string"
        },
        "cluster_network_cidr": {
          "description": "IP address block from which Pod IPs are allocated. This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "default": "10.128.0.0/14",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$"
        },
        "cluster_network_host_prefix": {
          "description": "The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.",
          "type": "integer",
          "default": 23,
          "maximum": 128,
          "minimum": 1
        },
        "high_availability_mode": {
          "description": "Guaranteed availability of the installed cluster. 'Full' installs a Highly-Available cluster\nover multiple master nodes whereas 'None' installs a full cluster over one node.\n",
          "type": "string",
          "default": "Full",
          "enum": [
            "Full",
            "None"
          ]
        },
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "hyperthreading": {
          "description": "Enable/disable hyperthreading on master nodes, worker nodes, or all nodes.",
          "type": "string",
          "default": "all",
          "enum": [
            "masters",
            "workers",
            "none",
            "all"
          ]
        },
        "ingress_vip": {
          "description": "The virtual IP used for cluster ingress traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3})|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,}))$"
        },
        "name": {
          "description": "Name of the OpenShift cluster.",
          "type": "string",
          "maxLength": 54,
          "minLength": 1
        },
        "network_configuration": {
          "x-nullable": true,
          "$ref": "#/definitions/network_configuration"
        },
        "network_type": {
          "description": "The desired network type used.",
          "type": "string",
          "default": "OpenShiftSDN",
          "enum": [
            "OpenShiftSDN",
            "OVNKubernetes"
          ]
        },
        "no_proxy": {
          "description": "An \"*\" or a comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude from proxying.",
          "type": "string",
          "x-nullable": true
        },
        "ocp_release_image": {
          "description": "OpenShift release image URI.",
          "type": "string"
        },
        "olm_operators": {
          "description": "List of OLM operators to be installed.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/operator-create-params"
          }
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster.",
          "type": "string"
        },
        "platform": {
          "type": "object",
          "x-nullable": true,
          "$ref": "#/definitions/platform"
        },
        "pull_secret": {
          "description": "The pull secret obtained from Red Hat OpenShift Cluster Manager at cloud.redhat.com/openshift/install/pull-secret.",
          "type": "string"
        },
        "schedulable_masters": {
          "description": "Schedule workloads on masters",
          "type": "boolean",
          "default": false
        },
        "service_network_cidr": {
          "description": "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "default": "172.30.0.0/16",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging OpenShift nodes.",
          "type": "string"
        },
        "user_managed_networking": {
          "description": "Indicate if the networking is managed by the user.",
          "type": "boolean",
          "default": false,
          "x-nullable": true
        },
        "vip_dhcp_allocation": {
          "description": "Indicate if virtual IP DHCP allocation mode is enabled.",
          "type": "boolean",
          "default": true,
          "x-nullable": true
        }
      }
    },
    "cluster-host-requirements": {
      "type": "object",
      "properties": {
        "host_id": {
          "description": "Unique identifier of the host the requirements relate to.",
          "type": "string",
          "format": "uuid"
        },
        "ocp": {
          "description": "Host requirements for the OCP installation",
          "$ref": "#/definitions/cluster-host-requirements-details"
        },
        "operators": {
          "description": "Host requirements related to requested operators",
          "type": "array",
          "items": {
            "$ref": "#/definitions/operator-host-requirements"
          }
        },
        "total": {
          "description": "Total host requirements for the cluster configuration",
          "$ref": "#/definitions/cluster-host-requirements-details"
        }
      }
    },
    "cluster-host-requirements-details": {
      "type": "object",
      "properties": {
        "cpu_cores": {
          "description": "Required number of CPU cores",
          "type": "integer"
        },
        "disk_size_gb": {
          "description": "Required disk size in GB",
          "type": "integer"
        },
        "installation_disk_speed_threshold_ms": {
          "description": "Required installation disk speed in ms",
          "type": "integer"
        },
        "network_latency_threshold_ms": {
          "description": "Maximum network average latency (RTT) at L3 for role.",
          "type": "number",
          "format": "double",
          "x-nullable": true
        },
        "packet_loss_percentage": {
          "description": "Maximum packet loss allowed at L3 for role.",
          "type": "number",
          "format": "double",
          "x-nullable": true
        },
        "ram_mib": {
          "description": "Required number of RAM in MiB",
          "type": "integer"
        }
      }
    },
    "cluster-host-requirements-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/cluster-host-requirements"
      }
    },
    "cluster-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/cluster"
      }
    },
    "cluster-progress-info": {
      "type": "object",
      "properties": {
        "finalizing_stage_percentage": {
          "type": "integer"
        },
        "installing_stage_percentage": {
          "type": "integer"
        },
        "preparing_for_installation_stage_percentage": {
          "type": "integer"
        },
        "total_percentage": {
          "type": "integer"
        }
      }
    },
    "cluster-update-params": {
      "type": "object",
      "properties": {
        "additional_ntp_source": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string",
          "x-nullable": true
        },
        "api_vip": {
          "description": "The virtual IP used to reach the OpenShift cluster's API.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3})|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,}))?$",
          "x-nullable": true
        },
        "api_vip_dns_name": {
          "description": "The domain name used to reach the OpenShift cluster API.",
          "type": "string",
          "x-nullable": true
        },
        "base_dns_domain": {
          "description": "Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.",
          "type": "string",
          "x-nullable": true
        },
        "cluster_network_cidr": {
          "description": "IP address block from which Pod IPs are allocated. This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$",
          "x-nullable": true
        },
        "cluster_network_host_prefix": {
          "description": "The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.",
          "type": "integer",
          "maximum": 128,
          "minimum": 1,
          "x-nullable": true
        },
        "disks_selected_config": {
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "disks_config": {
                "description": "The desired disks parameters (such as the disk's role).",
                "type": "array",
                "items": {
                  "$ref": "#/definitions/disk-config-params"
                }
              },
              "id": {
                "type": "string",
                "format": "uuid"
              }
            }
          },
          "x-nullable": true
        },
        "hosts_machine_config_pool_names": {
          "description": "The desired machine config pool for hosts associated with the cluster.",
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "id": {
                "type": "string",
                "format": "uuid"
              },
              "machine_config_pool_name": {
                "type": "string"
              }
            }
          },
          "x-nullable": true
        },
        "hosts_names": {
          "description": "The desired hostname for hosts associated with the cluster.",
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "hostname": {
                "type": "string"
              },
              "id": {
                "type": "string",
                "format": "uuid"
              }
            }
          },
          "x-nullable": true
        },
        "hosts_roles": {
          "description": "The desired role for hosts associated with the cluster.",
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "id": {
                "type": "string",
                "format": "uuid"
              },
              "role": {
                "$ref": "#/definitions/host-role-update-params"
              }
            }
          },
          "x-nullable": true
        },
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "hyperthreading": {
          "description": "Enable/disable hyperthreading on master nodes, worker nodes, or all nodes.",
          "type": "string",
          "enum": [
            "masters",
            "workers",
            "all",
            "none"
          ],
          "x-nullable": true
        },
        "ingress_vip": {
          "description": "The virtual IP used for cluster ingress traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3})|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,}))?$",
          "x-nullable": true
        },
        "machine_network_cidr": {
          "description": "A CIDR that all hosts belonging to the cluster should have an interfaces with IP address that belongs to this CIDR. The api_vip belongs to this CIDR.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$",
          "x-nullable": true
        },
        "name": {
          "description": "OpenShift cluster name.",
          "type": "string",
          "maxLength": 54,
          "minLength": 1,
          "x-nullable": true
        },
        "network_configuration": {
          "x-nullable": true,
          "$ref": "#/definitions/network_configuration"
        },
        "network_type": {
          "description": "The desired network type used.",
          "type": "string",
          "enum": [
            "OpenShiftSDN",
            "OVNKubernetes"
          ],
          "x-nullable": true
        },
        "no_proxy": {
          "description": "An \"*\" or a comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude from proxying.",
          "type": "string",
          "x-nullable": true
        },
        "olm_operators": {
          "description": "List of OLM operators to be installed.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/operator-create-params"
          }
        },
        "platform": {
          "type": "object",
          "$ref": "#/definitions/platform"
        },
        "pull_secret": {
          "description": "The pull secret obtained from Red Hat OpenShift Cluster Manager at cloud.redhat.com/openshift/install/pull-secret.",
          "type": "string",
          "x-nullable": true
        },
        "schedulable_masters": {
          "description": "Schedule workloads on masters",
          "type": "boolean",
          "default": false
        },
        "service_network_cidr": {
          "description": "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$",
          "x-nullable": true
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging OpenShift nodes.",
          "type": "string",
          "x-nullable": true
        },
        "user_managed_networking": {
          "description": "Indicate if the networking is managed by the user.",
          "type": "boolean",
          "x-nullable": true
        },
        "vip_dhcp_allocation": {
          "description": "Indicate if virtual IP DHCP allocation mode is enabled.",
          "type": "boolean",
          "x-nullable": true
        }
      }
    },
    "cluster-validation-id": {
      "type": "string",
      "enum": [
        "machine-cidr-defined",
        "cluster-cidr-defined",
        "service-cidr-defined",
        "no-cidrs-overlapping",
        "network-prefix-valid",
        "machine-cidr-equals-to-calculated-cidr",
        "api-vip-defined",
        "api-vip-valid",
        "ingress-vip-defined",
        "ingress-vip-valid",
        "all-hosts-are-ready-to-install",
        "sufficient-masters-count",
        "dns-domain-defined",
        "pull-secret-set",
        "ntp-server-configured",
        "lso-requirements-satisfied",
        "ocs-requirements-satisfied",
        "cnv-requirements-satisfied",
        "network-type-valid"
      ]
    },
    "cluster_default_config": {
      "type": "object",
      "properties": {
        "cluster_network_cidr": {
          "type": "string",
          "pattern": "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)[\\/]([1-9]|[1-2][0-9]|3[0-2]?)$"
        },
        "cluster_network_host_prefix": {
          "type": "integer",
          "maximum": 32,
          "minimum": 1
        },
        "inactive_deletion_hours": {
          "type": "integer"
        },
        "ntp_source": {
          "type": "string",
          "x-omitempty": false
        },
        "service_network_cidr": {
          "type": "string",
          "pattern": "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)[\\/]([1-9]|[1-2][0-9]|3[0-2]?)$"
        }
      }
    },
    "cluster_network": {
      "description": "IP address block for pod IP blocks.",
      "type": "object",
      "properties": {
        "cidr": {
          "description": "The IP block address pool.",
          "$ref": "#/definitions/subnet"
        },
        "host_prefix": {
          "description": "The prefix size to allocate to each node from the CIDR. For example, 24 would allocate 2^8=256 adresses to each node.",
          "type": "integer",
          "maximum": 128,
          "minimum": 1
        }
      }
    },
    "completion-params": {
      "type": "object",
      "required": [
        "is_success"
      ],
      "properties": {
        "error_info": {
          "type": "string"
        },
        "is_success": {
          "type": "boolean"
        }
      }
    },
    "connectivity-check-host": {
      "type": "object",
      "properties": {
        "host_id": {
          "type": "string",
          "format": "uuid"
        },
        "nics": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/connectivity-check-nic"
          }
        }
      }
    },
    "connectivity-check-nic": {
      "type": "object",
      "properties": {
        "ip_addresses": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "mac": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "connectivity-check-params": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/connectivity-check-host"
      }
    },
    "connectivity-remote-host": {
      "type": "object",
      "properties": {
        "host_id": {
          "type": "string",
          "format": "uuid"
        },
        "l2_connectivity": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/l2-connectivity"
          }
        },
        "l3_connectivity": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/l3-connectivity"
          }
        }
      }
    },
    "connectivity-report": {
      "type": "object",
      "properties": {
        "remote_hosts": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/connectivity-remote-host"
          }
        }
      }
    },
    "container_image_availability": {
      "type": "object",
      "properties": {
        "download_rate": {
          "description": "The rate of size/time in seconds MBps.",
          "type": "number"
        },
        "name": {
          "description": "A fully qualified image name (FQIN).",
          "type": "string"
        },
        "result": {
          "$ref": "#/definitions/container_image_availability_result"
        },
        "size_bytes": {
          "description": "Size of the image in bytes.",
          "type": "number"
        },
        "time": {
          "description": "Seconds it took to pull the image.",
          "type": "number"
        }
      }
    },
    "container_image_availability_request": {
      "type": "object",
      "required": [
        "images"
      ],
      "properties": {
        "images": {
          "description": "List of image names to be checked.",
          "type": "array",
          "items": {
            "description": "A fully qualified image name (FQIN).",
            "type": "string"
          }
        },
        "timeout": {
          "description": "Positive number represents a timeout in seconds for a pull operation.",
          "type": "integer"
        }
      }
    },
    "container_image_availability_response": {
      "type": "object",
      "required": [
        "images"
      ],
      "properties": {
        "images": {
          "description": "List of images that were checked.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/container_image_availability"
          }
        }
      }
    },
    "container_image_availability_result": {
      "description": "Image availability result.",
      "type": "string",
      "enum": [
        "success",
        "failure"
      ]
    },
    "cpu": {
      "type": "object",
      "properties": {
        "architecture": {
          "type": "string"
        },
        "count": {
          "type": "integer"
        },
        "flags": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "frequency": {
          "type": "number"
        },
        "model_name": {
          "type": "string"
        }
      }
    },
    "create-manifest-params": {
      "type": "object",
      "required": [
        "file_name",
        "content"
      ],
      "properties": {
        "content": {
          "description": "base64 encoded manifest content.",
          "type": "string"
        },
        "file_name": {
          "description": "The name of the manifest to customize the installed OCP cluster.",
          "type": "string",
          "pattern": "^[^/]*\\.(yaml|yml|json)$"
        },
        "folder": {
          "description": "The folder that contains the files. Manifests can be placed in 'manifests' or 'openshift' directories.",
          "type": "string",
          "default": "manifests",
          "enum": [
            "manifests",
            "openshift"
          ]
        }
      }
    },
    "credentials": {
      "type": "object",
      "properties": {
        "console_url": {
          "type": "string"
        },
        "password": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "dhcp_allocation_request": {
      "type": "object",
      "required": [
        "interface",
        "api_vip_mac",
        "ingress_vip_mac"
      ],
      "properties": {
        "api_vip_lease": {
          "description": "Contents of lease file to be used for API virtual IP.",
          "type": "string"
        },
        "api_vip_mac": {
          "description": "MAC address for the API virtual IP.",
          "type": "string",
          "format": "mac"
        },
        "ingress_vip_lease": {
          "description": "Contents of lease file to be used for for Ingress virtual IP.",
          "type": "string"
        },
        "ingress_vip_mac": {
          "description": "MAC address for the Ingress virtual IP.",
          "type": "string",
          "format": "mac"
        },
        "interface": {
          "description": "The network interface (NIC) to run the DHCP requests on.",
          "type": "string"
        }
      }
    },
    "dhcp_allocation_response": {
      "type": "object",
      "required": [
        "api_vip_address",
        "ingress_vip_address"
      ],
      "properties": {
        "api_vip_address": {
          "description": "The IPv4 address that was allocated by DHCP for the API virtual IP.",
          "type": "string",
          "format": "ipv4"
        },
        "api_vip_lease": {
          "description": "Contents of last acquired lease for API virtual IP.",
          "type": "string"
        },
        "ingress_vip_address": {
          "description": "The IPv4 address that was allocated by DHCP for the Ingress virtual IP.",
          "type": "string",
          "format": "ipv4"
        },
        "ingress_vip_lease": {
          "description": "Contents of last acquired lease for Ingress virtual IP.",
          "type": "string"
        }
      }
    },
    "discovery-ignition-params": {
      "properties": {
        "config": {
          "type": "string"
        }
      }
    },
    "disk": {
      "type": "object",
      "properties": {
        "bootable": {
          "type": "boolean"
        },
        "by_id": {
          "description": "by-id is the World Wide Number of the device which guaranteed to be unique for every storage device",
          "type": "string"
        },
        "by_path": {
          "description": "by-path is the shortest physical path to the device",
          "type": "string"
        },
        "drive_type": {
          "type": "string"
        },
        "hctl": {
          "type": "string"
        },
        "id": {
          "description": "Determine the disk's unique identifier which is the by-id field if it exists and fallback to the by-path field otherwise",
          "type": "string"
        },
        "installation_eligibility": {
          "type": "object",
          "properties": {
            "eligible": {
              "description": "Whether the disk is eligible for installation or not.",
              "type": "boolean"
            },
            "not_eligible_reasons": {
              "description": "Reasons for why this disk is not eligible for installation.",
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "x-nullable": false
        },
        "io_perf": {
          "$ref": "#/definitions/io_perf"
        },
        "is_installation_media": {
          "description": "Whether the disk appears to be an installation media or not",
          "type": "boolean"
        },
        "model": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "path": {
          "type": "string"
        },
        "serial": {
          "type": "string"
        },
        "size_bytes": {
          "type": "integer"
        },
        "smart": {
          "type": "string"
        },
        "vendor": {
          "type": "string"
        },
        "wwn": {
          "type": "string"
        }
      }
    },
    "disk-config-params": {
      "type": "object",
      "required": [
        "id"
      ],
      "properties": {
        "id": {
          "type": "string"
        },
        "role": {
          "$ref": "#/definitions/disk-role"
        }
      }
    },
    "disk-role": {
      "type": "string",
      "enum": [
        "none",
        "install"
      ]
    },
    "disk_info": {
      "type": "object",
      "properties": {
        "disk_speed": {
          "$ref": "#/definitions/disk_speed"
        },
        "id": {
          "type": "string",
          "format": "uuid"
        },
        "path": {
          "type": "string"
        }
      }
    },
    "disk_speed": {
      "type": "object",
      "properties": {
        "exit_code": {
          "type": "integer"
        },
        "speed_ms": {
          "type": "integer"
        },
        "tested": {
          "type": "boolean"
        }
      }
    },
    "disk_speed_check_request": {
      "type": "object",
      "required": [
        "path"
      ],
      "properties": {
        "path": {
          "description": "--filename argument for fio (expects a file or a block device path).",
          "type": "string"
        }
      }
    },
    "disk_speed_check_response": {
      "type": "object",
      "properties": {
        "io_sync_duration": {
          "description": "The 99th percentile of fdatasync durations in milliseconds.",
          "type": "integer"
        },
        "path": {
          "description": "The device path.",
          "type": "string"
        }
      }
    },
    "domain_resolution_request": {
      "type": "object",
      "required": [
        "domains"
      ],
      "properties": {
        "domains": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "domain_name"
            ],
            "properties": {
              "domain_name": {
                "description": "The domain name that should be resolved",
                "type": "string"
              }
            },
            "x-go-name": "DomainResolutionRequestDomain"
          }
        }
      }
    },
    "domain_resolution_response": {
      "type": "object",
      "required": [
        "resolutions"
      ],
      "properties": {
        "resolutions": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "domain_name"
            ],
            "properties": {
              "domain_name": {
                "description": "The domain that was resolved",
                "type": "string"
              },
              "ipv4_addresses": {
                "description": "The IPv4 addresses of the domain, empty if none",
                "type": "array",
                "items": {
                  "type": "string",
                  "format": "ipv4"
                }
              },
              "ipv6_addresses": {
                "description": "The IPv6 addresses of the domain, empty if none",
                "type": "array",
                "items": {
                  "type": "string",
                  "format": "ipv6"
                }
              }
            },
            "x-go-name": "DomainResolutionResponseDomain"
          }
        }
      }
    },
    "error": {
      "type": "object",
      "required": [
        "kind",
        "id",
        "href",
        "code",
        "reason"
      ],
      "properties": {
        "code": {
          "description": "Globally unique code of the error, composed of the unique identifier of the API and the numeric identifier of the error. For example, if the numeric identifier of the error is 93 and the identifier of the API is assisted_install then the code will be ASSISTED-INSTALL-93.",
          "type": "string"
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "id": {
          "description": "Numeric identifier of the error.",
          "type": "integer",
          "format": "int32",
          "maximum": 504,
          "minimum": 400
        },
        "kind": {
          "description": "Indicates the type of this object. Will always be 'Error'.",
          "type": "string",
          "enum": [
            "Error"
          ]
        },
        "reason": {
          "description": "Human-readable description of the error.",
          "type": "string"
        }
      }
    },
    "event": {
      "type": "object",
      "required": [
        "cluster_id",
        "severity",
        "message",
        "event_time"
      ],
      "properties": {
        "category": {
          "type": "string",
          "enum": [
            "user",
            "metrics"
          ],
          "x-go-custom-tag": "gorm:\"default:'user'\""
        },
        "cluster_id": {
          "description": "Unique identifier of the cluster this event relates to.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"index\""
        },
        "event_time": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "host_id": {
          "description": "Unique identifier of the host this event relates to.",
          "type": "string",
          "format": "uuid"
        },
        "message": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(4096)\""
        },
        "props": {
          "description": "Additional properties for the event in JSON format.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "request_id": {
          "description": "Unique identifier of the request that caused this event to occur.",
          "type": "string",
          "format": "uuid"
        },
        "severity": {
          "type": "string",
          "enum": [
            "info",
            "warning",
            "error",
            "critical"
          ]
        }
      }
    },
    "event-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/event"
      }
    },
    "free-addresses-list": {
      "type": "array",
      "items": {
        "type": "string",
        "format": "ipv4"
      }
    },
    "free_addresses_request": {
      "type": "array",
      "items": {
        "type": "string",
        "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
      }
    },
    "free_network_addresses": {
      "type": "object",
      "properties": {
        "free_addresses": {
          "type": "array",
          "items": {
            "type": "string",
            "format": "ipv4"
          }
        },
        "network": {
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        }
      }
    },
    "free_networks_addresses": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/free_network_addresses"
      }
    },
    "gpu": {
      "type": "object",
      "properties": {
        "address": {
          "description": "Device address (for example \"0000:00:02.0\")",
          "type": "string"
        },
        "device_id": {
          "description": "ID of the device (for example \"3ea0\")",
          "type": "string"
        },
        "name": {
          "description": "Product name of the device (for example \"UHD Graphics 620 (Whiskey Lake)\")",
          "type": "string"
        },
        "vendor": {
          "description": "The name of the device vendor (for example \"Intel Corporation\")",
          "type": "string"
        },
        "vendor_id": {
          "description": "ID of the vendor (for example \"8086\")",
          "type": "string"
        }
      }
    },
    "host": {
      "type": "object",
      "required": [
        "kind",
        "id",
        "href",
        "status",
        "status_info"
      ],
      "properties": {
        "api_vip_connectivity": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "bootstrap": {
          "type": "boolean"
        },
        "checked_in_at": {
          "description": "The last time the host's agent communicated with the service.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "cluster_id": {
          "description": "The cluster that this host is associated with.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"foreignkey:Cluster\"",
          "x-nullable": true
        },
        "connectivity": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "created_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "deleted_at": {
          "description": "The time that the host was deleted.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\"",
          "x-nullable": true
        },
        "discovery_agent_version": {
          "type": "string"
        },
        "disks_info": {
          "description": "Additional information about disks, formatted as JSON.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "domain_name_resolutions": {
          "description": "The domain name resolution result.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "free_addresses": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "id": {
          "description": "Unique identifier of the object.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key\""
        },
        "ignition_config_overrides": {
          "description": "Json formatted string containing the user overrides for the host's pointer ignition",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\"",
          "example": "{\"ignition\": {\"version\": \"3.1.0\"}, \"storage\": {\"files\": [{\"path\": \"/tmp/example\", \"contents\": {\"source\": \"data:text/plain;base64,aGVscGltdHJhcHBlZGluYXN3YWdnZXJzcGVj\"}}]}}"
        },
        "images_status": {
          "description": "Array of image statuses.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "infra_env_id": {
          "description": "The InfraEnv that this host is associated with.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key;foreignkey:InfraEnvID\""
        },
        "installation_disk_id": {
          "description": "Contains the inventory disk id to install on.",
          "type": "string"
        },
        "installation_disk_path": {
          "description": "Contains the inventory disk path, This field is replaced by installation_disk_id field and used for backward compatability with the old UI.",
          "type": "string",
          "example": "/dev/sda"
        },
        "installer_args": {
          "type": "string"
        },
        "installer_version": {
          "description": "Installer version.",
          "type": "string"
        },
        "inventory": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "kind": {
          "description": "Indicates the type of this object. Will be 'Host' if this is a complete object or 'HostLink' if it is just a link, or\n'AddToExistingClusterHost' for host being added to existing OCP cluster, or\n",
          "type": "string",
          "enum": [
            "Host",
            "AddToExistingClusterHost"
          ]
        },
        "logs_collected_at": {
          "type": "string",
          "format": "datetime",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "logs_info": {
          "description": "The progress of log collection or empty if logs are not applicable",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\"",
          "$ref": "#/definitions/logs_state"
        },
        "logs_started_at": {
          "type": "string",
          "format": "datetime",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "machine_config_pool_name": {
          "type": "string"
        },
        "ntp_sources": {
          "description": "The configured NTP sources on the host.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "progress": {
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:progress_\"",
          "$ref": "#/definitions/host-progress-info"
        },
        "progress_stages": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/host-stage"
          },
          "x-go-custom-tag": "gorm:\"-\""
        },
        "requested_hostname": {
          "type": "string"
        },
        "role": {
          "$ref": "#/definitions/host-role"
        },
        "stage_started_at": {
          "description": "Time at which the current progress stage started.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "stage_updated_at": {
          "description": "Time at which the current progress stage was last updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "status": {
          "type": "string",
          "enum": [
            "discovering",
            "known",
            "disconnected",
            "insufficient",
            "disabled",
            "preparing-for-installation",
            "preparing-successful",
            "pending-for-input",
            "installing",
            "installing-in-progress",
            "installing-pending-user-action",
            "resetting-pending-user-action",
            "installed",
            "error",
            "resetting",
            "added-to-existing-cluster",
            "cancelled",
            "binding",
            "known-unbound",
            "disconnected-unbound",
            "insufficient-unbound",
            "disabled-unbound",
            "discovering-unbound"
          ]
        },
        "status_info": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "status_updated_at": {
          "description": "The last time that the host status was updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "updated_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "user_name": {
          "type": "string"
        },
        "validations_info": {
          "description": "JSON-formatted string containing the validation results for each validation id grouped by category (network, hardware, etc.)",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        }
      }
    },
    "host-create-params": {
      "type": "object",
      "required": [
        "host_id"
      ],
      "properties": {
        "discovery_agent_version": {
          "type": "string"
        },
        "host_id": {
          "type": "string",
          "format": "uuid"
        }
      }
    },
    "host-ignition-params": {
      "properties": {
        "config": {
          "type": "string"
        }
      }
    },
    "host-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/host"
      }
    },
    "host-progress": {
      "type": "object",
      "required": [
        "current_stage"
      ],
      "properties": {
        "current_stage": {
          "type": "string",
          "$ref": "#/definitions/host-stage"
        },
        "progress_info": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        }
      }
    },
    "host-progress-info": {
      "type": "object",
      "required": [
        "current_stage"
      ],
      "properties": {
        "current_stage": {
          "type": "string",
          "$ref": "#/definitions/host-stage"
        },
        "installation_percentage": {
          "type": "integer"
        },
        "progress_info": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "stage_started_at": {
          "description": "Time at which the current progress stage started.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "stage_updated_at": {
          "description": "Time at which the current progress stage was last updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        }
      }
    },
    "host-role": {
      "type": "string",
      "enum": [
        "auto-assign",
        "master",
        "worker",
        "bootstrap"
      ]
    },
    "host-role-update-params": {
      "type": "string",
      "enum": [
        "auto-assign",
        "master",
        "worker"
      ]
    },
    "host-stage": {
      "type": "string",
      "enum": [
        "Starting installation",
        "Waiting for control plane",
        "Waiting for bootkube",
        "Waiting for controller",
        "Installing",
        "Writing image to disk",
        "Rebooting",
        "Waiting for ignition",
        "Configuring",
        "Joined",
        "Done",
        "Failed"
      ]
    },
    "host-type-hardware-requirements": {
      "type": "object",
      "properties": {
        "qualitative": {
          "description": "Host requirements that cannot be quantified at the time of calculation. Descriptions or formulas of requiements",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "quantitative": {
          "description": "Host requirements that can be quantified",
          "$ref": "#/definitions/cluster-host-requirements-details"
        }
      }
    },
    "host-type-hardware-requirements-wrapper": {
      "type": "object",
      "properties": {
        "master": {
          "description": "Requirements towards a master node",
          "$ref": "#/definitions/host-type-hardware-requirements"
        },
        "worker": {
          "description": "Requirements towards a worker node",
          "$ref": "#/definitions/host-type-hardware-requirements"
        }
      }
    },
    "host-validation-id": {
      "type": "string",
      "enum": [
        "connected",
        "has-inventory",
        "has-min-cpu-cores",
        "has-min-valid-disks",
        "has-min-memory",
        "machine-cidr-defined",
        "has-cpu-cores-for-role",
        "has-memory-for-role",
        "hostname-unique",
        "hostname-valid",
        "belongs-to-machine-cidr",
        "api-vip-connected",
        "belongs-to-majority-group",
        "valid-platform",
        "ntp-synced",
        "container-images-available",
        "lso-requirements-satisfied",
        "ocs-requirements-satisfied",
        "sufficient-installation-disk-speed",
        "cnv-requirements-satisfied",
        "sufficient-network-latency-requirement-for-role",
        "sufficient-packet-loss-requirement-for-role",
        "has-default-route",
        "api-domain-name-resolved-correctly",
        "api-int-domain-name-resolved-correctly",
        "apps-domain-name-resolved-correctly",
        "compatible-with-cluster-platform"
      ]
    },
    "host_network": {
      "type": "object",
      "properties": {
        "cidr": {
          "type": "string"
        },
        "host_ids": {
          "type": "array",
          "items": {
            "type": "string",
            "format": "uuid"
          }
        }
      }
    },
    "host_registration_response": {
      "allOf": [
        {
          "$ref": "#/definitions/host"
        },
        {
          "properties": {
            "next_step_runner_command": {
              "description": "Command for starting the next step runner",
              "type": "object",
              "properties": {
                "args": {
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                },
                "command": {
                  "type": "string"
                },
                "retry_seconds": {
                  "description": "How long in seconds to wait before retrying registration if the command fails",
                  "type": "integer"
                }
              }
            }
          }
        }
      ]
    },
    "host_static_network_config": {
      "type": "object",
      "properties": {
        "mac_interface_map": {
          "description": "mapping of host macs to logical interfaces used in the network yaml",
          "$ref": "#/definitions/mac_interface_map"
        },
        "network_yaml": {
          "description": "yaml string that can be processed by nmstate",
          "type": "string"
        }
      }
    },
    "image-create-params": {
      "type": "object",
      "properties": {
        "image_type": {
          "description": "Type of image that should be generated.",
          "$ref": "#/definitions/image_type"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string"
        },
        "static_network_config": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/host_static_network_config"
          }
        }
      }
    },
    "image_info": {
      "type": "object",
      "properties": {
        "created_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "download_url": {
          "type": "string"
        },
        "expires_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "generator_version": {
          "description": "Image generator version.",
          "type": "string"
        },
        "size_bytes": {
          "type": "integer"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string"
        },
        "static_network_config": {
          "description": "static network configuration string in the format expected by discovery ignition generation",
          "type": "string"
        },
        "type": {
          "$ref": "#/definitions/image_type"
        }
      }
    },
    "image_type": {
      "type": "string",
      "enum": [
        "full-iso",
        "minimal-iso"
      ]
    },
    "infra-env": {
      "type": "object",
      "properties": {
        "additional_ntp_sources": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string"
        },
        "cluster_id": {
          "description": "If set, all hosts that register will be associated with the specified cluster.",
          "type": "string",
          "format": "uuid"
        },
        "created_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "download_url": {
          "type": "string"
        },
        "expires_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "generator_version": {
          "description": "Image generator version.",
          "type": "string"
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "id": {
          "description": "Unique identifier of the object.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key\""
        },
        "ignition_config_override": {
          "description": "Json formatted string containing the user overrides for the initial ignition config.",
          "type": "string"
        },
        "kind": {
          "description": "Indicates the type of this object.",
          "type": "string",
          "enum": [
            "InfraEnv"
          ]
        },
        "name": {
          "description": "Name of the InfraEnv.",
          "type": "string"
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster (used to infer the RHCOS version - temporary until generic logic implemented).",
          "type": "string"
        },
        "proxy": {
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:proxy_\"",
          "$ref": "#/definitions/proxy"
        },
        "pull_secret_set": {
          "description": "True if the pull secret has been added to the cluster.",
          "type": "boolean"
        },
        "size_bytes": {
          "type": "integer"
        },
        "ssh_authorized_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string"
        },
        "static_network_config": {
          "description": "static network configuration string in the format expected by discovery ignition generation.",
          "type": "string"
        },
        "type": {
          "$ref": "#/definitions/image_type"
        },
        "updated_at": {
          "description": "The last time that this infraenv was updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        }
      }
    },
    "infra-env-create-params": {
      "type": "object",
      "required": [
        "name",
        "openshift_version",
        "pull_secret"
      ],
      "properties": {
        "additional_ntp_sources": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string",
          "x-nullable": true
        },
        "cluster_id": {
          "description": "If set, all hosts that register will be associated with the specified cluster.",
          "type": "string",
          "format": "uuid",
          "x-nullable": true
        },
        "ignition_config_override": {
          "description": "JSON formatted string containing the user overrides for the initial ignition config.",
          "type": "string"
        },
        "image_type": {
          "$ref": "#/definitions/image_type"
        },
        "name": {
          "description": "Name of the InfraEnv.",
          "type": "string"
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster (used to infer the RHCOS version - temporary until generic logic implemented).",
          "type": "string"
        },
        "proxy": {
          "$ref": "#/definitions/proxy"
        },
        "pull_secret": {
          "description": "The pull secret obtained from Red Hat OpenShift Cluster Manager at cloud.redhat.com/openshift/install/pull-secret.",
          "type": "string"
        },
        "ssh_authorized_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string",
          "x-nullable": true
        },
        "static_network_config": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/host_static_network_config"
          }
        }
      }
    },
    "infra-env-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/infra-env"
      }
    },
    "infra-env-update-params": {
      "type": "object",
      "properties": {
        "additional_ntp_sources": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string",
          "x-nullable": true
        },
        "cluster_id": {
          "description": "If set, all hosts that register will be associated with the specified cluster.",
          "type": "string",
          "format": "uuid",
          "x-nullable": true
        },
        "ignition_config_override": {
          "description": "JSON formatted string containing the user overrides for the initial ignition config.",
          "type": "string"
        },
        "image_type": {
          "$ref": "#/definitions/image_type"
        },
        "proxy": {
          "$ref": "#/definitions/proxy"
        },
        "pull_secret": {
          "description": "The pull secret obtained from Red Hat OpenShift Cluster Manager at cloud.redhat.com/openshift/install/pull-secret.",
          "type": "string"
        },
        "ssh_authorized_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string",
          "x-nullable": true
        },
        "static_network_config": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/host_static_network_config"
          }
        }
      }
    },
    "infra_error": {
      "type": "object",
      "required": [
        "code",
        "message"
      ],
      "properties": {
        "code": {
          "description": "Numeric identifier of the error.",
          "type": "integer",
          "format": "int32",
          "maximum": 403,
          "minimum": 401
        },
        "message": {
          "description": "Human-readable description of the error.",
          "type": "string"
        }
      }
    },
    "ingress-cert-params": {
      "type": "string"
    },
    "installer-args-params": {
      "type": "object",
      "properties": {
        "args": {
          "description": "List of additional arguments passed to coreos-installer",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "--append-karg",
            "ip=192.0.2.2::192.0.2.254:255.255.255.0:core0.example.com:enp1s0:none",
            "--save-partindex",
            "1",
            "-n"
          ]
        }
      }
    },
    "interface": {
      "type": "object",
      "properties": {
        "biosdevname": {
          "type": "string"
        },
        "client_id": {
          "type": "string"
        },
        "flags": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "has_carrier": {
          "type": "boolean"
        },
        "ipv4_addresses": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "ipv6_addresses": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "mac_address": {
          "type": "string"
        },
        "mtu": {
          "type": "integer"
        },
        "name": {
          "type": "string"
        },
        "product": {
          "type": "string"
        },
        "speed_mbps": {
          "type": "integer"
        },
        "vendor": {
          "type": "string"
        }
      }
    },
    "inventory": {
      "type": "object",
      "properties": {
        "bmc_address": {
          "type": "string"
        },
        "bmc_v6address": {
          "type": "string"
        },
        "boot": {
          "$ref": "#/definitions/boot"
        },
        "cpu": {
          "$ref": "#/definitions/cpu"
        },
        "disks": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/disk"
          }
        },
        "gpus": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/gpu"
          }
        },
        "hostname": {
          "type": "string"
        },
        "interfaces": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/interface"
          }
        },
        "memory": {
          "$ref": "#/definitions/memory"
        },
        "routes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/route"
          }
        },
        "system_vendor": {
          "$ref": "#/definitions/system_vendor"
        },
        "timestamp": {
          "type": "integer"
        }
      }
    },
    "io_perf": {
      "type": "object",
      "properties": {
        "sync_duration": {
          "description": "99th percentile of fsync duration in milliseconds",
          "type": "integer"
        }
      }
    },
    "l2-connectivity": {
      "type": "object",
      "properties": {
        "outgoing_ip_address": {
          "type": "string"
        },
        "outgoing_nic": {
          "type": "string"
        },
        "remote_ip_address": {
          "type": "string"
        },
        "remote_mac": {
          "type": "string"
        },
        "successful": {
          "type": "boolean"
        }
      }
    },
    "l3-connectivity": {
      "type": "object",
      "properties": {
        "average_rtt_ms": {
          "description": "Average round trip time in milliseconds.",
          "type": "number",
          "format": "double",
          "x-go-name": "AverageRTTMs"
        },
        "outgoing_nic": {
          "type": "string"
        },
        "packet_loss_percentage": {
          "description": "Percentage of packets lost during connectivity check.",
          "type": "number",
          "format": "double"
        },
        "remote_ip_address": {
          "type": "string"
        },
        "successful": {
          "type": "boolean"
        }
      }
    },
    "list-managed-domains": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/managed-domain"
      }
    },
    "list-manifests": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/manifest"
      }
    },
    "list-versions": {
      "type": "object",
      "properties": {
        "release_tag": {
          "type": "string"
        },
        "versions": {
          "$ref": "#/definitions/versions"
        }
      }
    },
    "logs-progress-params": {
      "type": "object",
      "required": [
        "logs_state"
      ],
      "properties": {
        "logs_state": {
          "description": "The state of collecting logs.",
          "$ref": "#/definitions/logs_state"
        }
      }
    },
    "logs_state": {
      "type": "string",
      "enum": [
        "requested",
        "collecting",
        "completed",
        "timeout",
        ""
      ]
    },
    "logs_type": {
      "type": "string",
      "enum": [
        "host",
        "controller",
        "all",
        ""
      ]
    },
    "mac_interface_map": {
      "type": "array",
      "items": {
        "type": "object",
        "properties": {
          "logical_nic_name": {
            "description": "nic name used in the yaml, which relates 1:1 to the mac address",
            "type": "string"
          },
          "mac_address": {
            "description": "mac address present on the host",
            "type": "string",
            "pattern": "^([0-9A-Fa-f]{2}[:]){5}([0-9A-Fa-f]{2})$"
          }
        }
      }
    },
    "machine_network": {
      "description": "IP address block for node IP blocks.",
      "type": "object",
      "properties": {
        "cidr": {
          "description": "The IP block address pool for machines within the cluster.",
          "$ref": "#/definitions/subnet"
        }
      }
    },
    "managed-domain": {
      "type": "object",
      "properties": {
        "domain": {
          "type": "string"
        },
        "provider": {
          "type": "string",
          "enum": [
            "route53"
          ]
        }
      }
    },
    "manifest": {
      "type": "object",
      "properties": {
        "file_name": {
          "description": "The file name prefaced by the folder that contains it.",
          "type": "string"
        },
        "folder": {
          "description": "The folder that contains the files. Manifests can be placed in 'manifests' or 'openshift' directories.",
          "type": "string",
          "enum": [
            "manifests",
            "openshift"
          ]
        }
      }
    },
    "memory": {
      "type": "object",
      "properties": {
        "physical_bytes": {
          "type": "integer"
        },
        "usable_bytes": {
          "type": "integer"
        }
      }
    },
    "monitored-operator": {
      "type": "object",
      "properties": {
        "cluster_id": {
          "description": "The cluster that this operator is associated with.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key;foreignkey:Cluster\""
        },
        "name": {
          "description": "Unique name of the operator.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"primary_key\""
        },
        "namespace": {
          "description": "Namespace where to deploy an operator. Only some operators require a namespace.",
          "type": "string"
        },
        "operator_type": {
          "$ref": "#/definitions/operator-type"
        },
        "properties": {
          "description": "Blob of operator-dependent parameters that are required for installation.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "status": {
          "$ref": "#/definitions/operator-status"
        },
        "status_info": {
          "description": "Detailed information about the operator state.",
          "type": "string"
        },
        "status_updated_at": {
          "description": "Time at which the operator was last updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "subscription_name": {
          "description": "The name of the subscription of the operator.",
          "type": "string"
        },
        "timeout_seconds": {
          "description": "Positive number represents a timeout in seconds for the operator to be available.",
          "type": "integer"
        }
      }
    },
    "monitored-operators-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/monitored-operator"
      }
    },
    "network_configuration": {
      "type": "object",
      "properties": {
        "cluster_network": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/cluster_network"
          }
        },
        "machine_network": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/machine_network"
          }
        },
        "service_network": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/service_network"
          }
        }
      }
    },
    "ntp_source": {
      "type": "object",
      "properties": {
        "source_name": {
          "description": "NTP source name or IP.",
          "type": "string"
        },
        "source_state": {
          "description": "Indication of state of an NTP source.",
          "$ref": "#/definitions/source_state"
        }
      }
    },
    "ntp_synchronization_request": {
      "type": "object",
      "required": [
        "ntp_source"
      ],
      "properties": {
        "ntp_source": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string"
        }
      }
    },
    "ntp_synchronization_response": {
      "properties": {
        "ntp_sources": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/ntp_source"
          }
        }
      }
    },
    "openshift-version": {
      "type": "object",
      "required": [
        "display_name",
        "release_image",
        "release_version",
        "rhcos_image",
        "rhcos_rootfs",
        "rhcos_version",
        "support_level"
      ],
      "properties": {
        "default": {
          "description": "Indication that the version is the recommended one.",
          "type": "boolean"
        },
        "display_name": {
          "description": "Name of the version to be presented to the user.",
          "type": "string"
        },
        "release_image": {
          "description": "The installation image of the OpenShift cluster.",
          "type": "string"
        },
        "release_version": {
          "description": "OCP version from the release metadata.",
          "type": "string"
        },
        "rhcos_image": {
          "description": "The base RHCOS image used for the discovery iso.",
          "type": "string"
        },
        "rhcos_rootfs": {
          "description": "The RHCOS rootfs url.",
          "type": "string"
        },
        "rhcos_version": {
          "description": "Build ID of the RHCOS image.",
          "type": "string"
        },
        "support_level": {
          "description": "Level of support of the version.",
          "type": "string",
          "enum": [
            "beta",
            "production",
            "custom"
          ]
        }
      }
    },
    "openshift-versions": {
      "type": "object",
      "additionalProperties": {
        "$ref": "#/definitions/openshift-version"
      }
    },
    "operator-create-params": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "properties": {
          "description": "Blob of operator-dependent parameters that are required for installation.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        }
      }
    },
    "operator-hardware-requirements": {
      "type": "object",
      "properties": {
        "dependencies": {
          "description": "List of other operator unique names that are required to be installed. Corresponds to name property of the monitored-operator, i.e. \"lso\", \"cnv\", etc.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "operator_name": {
          "description": "Unique name of the operator. Corresponds to name property of the monitored-operator, i.e. \"lso\", \"cnv\", etc.",
          "type": "string"
        },
        "requirements": {
          "$ref": "#/definitions/host-type-hardware-requirements-wrapper"
        }
      }
    },
    "operator-host-requirements": {
      "type": "object",
      "properties": {
        "operator_name": {
          "description": "Name of the operator",
          "type": "string"
        },
        "requirements": {
          "description": "Host requirements for the operator",
          "$ref": "#/definitions/cluster-host-requirements-details"
        }
      }
    },
    "operator-monitor-report": {
      "type": "object",
      "properties": {
        "name": {
          "description": "Unique name of the operator.",
          "type": "string"
        },
        "status": {
          "$ref": "#/definitions/operator-status"
        },
        "status_info": {
          "description": "Detailed information about the operator state.",
          "type": "string"
        }
      }
    },
    "operator-properties": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/operator-property"
      }
    },
    "operator-property": {
      "type": "object",
      "properties": {
        "data_type": {
          "description": "Type of the property",
          "type": "string",
          "enum": [
            "boolean",
            "string",
            "integer",
            "float"
          ]
        },
        "default_value": {
          "description": "Default value for the property",
          "type": "string"
        },
        "description": {
          "description": "Description of a property",
          "type": "string"
        },
        "mandatory": {
          "description": "Indicates whether the property is reqired",
          "type": "boolean"
        },
        "name": {
          "description": "Name of the property",
          "type": "string"
        },
        "options": {
          "description": "Values to select from",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "operator-status": {
      "description": "Represents the operator state.",
      "type": "string",
      "enum": [
        "failed",
        "progressing",
        "available"
      ]
    },
    "operator-type": {
      "description": "Kind of operator. Different types are monitored by the service differently.",
      "type": "string",
      "enum": [
        "builtin",
        "olm"
      ]
    },
    "platform": {
      "description": "The configuration for the specific platform upon which to perform the installation.",
      "type": "object",
      "required": [
        "type"
      ],
      "properties": {
        "type": {
          "$ref": "#/definitions/platform_type"
        },
        "vsphere": {
          "type": "object",
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:vsphere_\"",
          "x-nullable": true,
          "$ref": "#/definitions/vsphere_platform"
        }
      }
    },
    "platform_type": {
      "type": "string",
      "enum": [
        "baremetal",
        "vsphere"
      ]
    },
    "preflight-hardware-requirements": {
      "type": "object",
      "properties": {
        "ocp": {
          "description": "Preflight OCP requirements",
          "$ref": "#/definitions/host-type-hardware-requirements-wrapper"
        },
        "operators": {
          "description": "Preflight operators hardware requirements",
          "type": "array",
          "items": {
            "$ref": "#/definitions/operator-hardware-requirements"
          }
        }
      }
    },
    "presigned": {
      "type": "object",
      "required": [
        "url"
      ],
      "properties": {
        "url": {
          "type": "string"
        }
      }
    },
    "proxy": {
      "type": "object",
      "properties": {
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "no_proxy": {
          "description": "An \"*\" or a comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude from proxying.",
          "type": "string",
          "x-nullable": true
        }
      }
    },
    "route": {
      "type": "object",
      "properties": {
        "destination": {
          "description": "The destination network or destination host",
          "type": "string"
        },
        "family": {
          "description": "Defines whether this is an IPv4 (4) or IPv6 route (6)",
          "type": "integer",
          "format": "int32"
        },
        "gateway": {
          "description": "Gateway address where the packets are sent",
          "type": "string"
        },
        "interface": {
          "description": "Interface to which packets for this route will be sent",
          "type": "string"
        }
      }
    },
    "service_network": {
      "description": "List of IP address pools for services.",
      "type": "object",
      "properties": {
        "cidr": {
          "description": "The IP block address pool.",
          "$ref": "#/definitions/subnet"
        }
      }
    },
    "source_state": {
      "type": "string",
      "enum": [
        "synced",
        "combined",
        "not_combined",
        "error",
        "variable",
        "unreachable"
      ]
    },
    "step": {
      "type": "object",
      "properties": {
        "args": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "command": {
          "type": "string"
        },
        "step_id": {
          "type": "string"
        },
        "step_type": {
          "$ref": "#/definitions/step-type"
        }
      }
    },
    "step-reply": {
      "type": "object",
      "properties": {
        "error": {
          "type": "string"
        },
        "exit_code": {
          "type": "integer"
        },
        "output": {
          "type": "string"
        },
        "step_id": {
          "type": "string"
        },
        "step_type": {
          "$ref": "#/definitions/step-type"
        }
      }
    },
    "step-type": {
      "type": "string",
      "enum": [
        "connectivity-check",
        "execute",
        "inventory",
        "install",
        "free-network-addresses",
        "reset-installation",
        "dhcp-lease-allocate",
        "api-vip-connectivity-check",
        "ntp-synchronizer",
        "installation-disk-speed-check",
        "container-image-availability",
        "domain-resolution"
      ]
    },
    "steps": {
      "type": "object",
      "properties": {
        "instructions": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/step"
          }
        },
        "next_instruction_seconds": {
          "type": "integer"
        },
        "post_step_action": {
          "description": "What to do after finishing to run step instructions",
          "type": "string",
          "default": "continue",
          "enum": [
            "exit",
            "continue"
          ]
        }
      }
    },
    "steps-reply": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/step-reply"
      }
    },
    "subnet": {
      "type": "string",
      "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$"
    },
    "system_vendor": {
      "type": "object",
      "properties": {
        "manufacturer": {
          "type": "string"
        },
        "product_name": {
          "type": "string"
        },
        "serial_number": {
          "type": "string"
        },
        "virtual": {
          "description": "Whether the machine appears to be a virtual machine or not",
          "type": "boolean"
        }
      }
    },
    "usage": {
      "type": "object",
      "properties": {
        "data": {
          "description": "additional properties of the feature",
          "type": "object",
          "additionalProperties": {
            "type": "object"
          }
        },
        "name": {
          "description": "name of the feature to track",
          "type": "string"
        }
      }
    },
    "versioned-host-requirements": {
      "type": "object",
      "properties": {
        "master": {
          "description": "Master node requirements",
          "x-go-name": "MasterRequirements",
          "$ref": "#/definitions/cluster-host-requirements-details"
        },
        "sno": {
          "description": "Single node OpenShift node requirements",
          "x-go-name": "SNORequirements",
          "$ref": "#/definitions/cluster-host-requirements-details"
        },
        "version": {
          "description": "Version of the component for which requirements are defined",
          "type": "string"
        },
        "worker": {
          "description": "Worker node requirements",
          "x-go-name": "WorkerRequirements",
          "$ref": "#/definitions/cluster-host-requirements-details"
        }
      }
    },
    "versions": {
      "type": "object",
      "additionalProperties": {
        "type": "string"
      }
    },
    "vsphere_platform": {
      "description": "Vsphere platform specific configuration upon which to perform the installation",
      "type": "object",
      "properties": {
        "cluster": {
          "description": "The vCenter cluster to install the OpenShift Container Platform cluster in.",
          "type": "string",
          "x-nullable": true
        },
        "datacenter": {
          "description": "The name of the datacenter to use in the vCenter instance.",
          "type": "string",
          "x-nullable": true
        },
        "defaultDatastore": {
          "description": "The name of the default datastore to use for provisioning volumes.",
          "type": "string",
          "x-nullable": true
        },
        "folder": {
          "description": "Optional. The absolute path of an existing folder where the installation program creates the virtual machines. If you do not provide this value, the installation program creates a folder that is named with the infrastructure ID in the datacenter virtual machine folder.",
          "type": "string",
          "x-nullable": true
        },
        "network": {
          "description": "The network in the vCenter instance that contains the virtual IP addresses and DNS records that you configured.",
          "type": "string",
          "x-nullable": true
        },
        "password": {
          "description": "The password for the vCenter user name.",
          "type": "string",
          "format": "password",
          "x-nullable": true
        },
        "username": {
          "description": "The user name to use to connect to the vCenter instance with. This user must have at least the roles and privileges that are required for static or dynamic persistent volume provisioning in vSphere.",
          "type": "string",
          "x-nullable": true
        },
        "vCenter": {
          "description": "The fully-qualified hostname or IP address of the vCenter server.",
          "type": "string",
          "x-nullable": true
        }
      }
    }
  },
  "securityDefinitions": {
    "agentAuth": {
      "type": "apiKey",
      "name": "X-Secret-Key",
      "in": "header"
    },
    "urlAuth": {
      "type": "apiKey",
      "name": "api_key",
      "in": "query"
    },
    "userAuth": {
      "type": "apiKey",
      "name": "Authorization",
      "in": "header"
    }
  },
  "security": [
    {
      "userAuth": [
        "admin",
        "user"
      ]
    }
  ],
  "tags": [
    {
      "description": "Agent-driven installation",
      "name": "Assisted installation"
    },
    {
      "description": "ISO that contains the Assisted Service.",
      "name": "assisted-service-iso"
    },
    {
      "description": "Events related to a cluster installation.",
      "name": "events"
    },
    {
      "description": "General OpenShift cluster installation APIs.",
      "name": "installer"
    },
    {
      "description": "Managed dns domains for a cluster installation.",
      "name": "managed_domains"
    },
    {
      "description": "Manifests for customizing a cluster installation.",
      "name": "manifests"
    },
    {
      "description": "Information regarding supported operators.",
      "name": "operators"
    },
    {
      "description": "Information regarding versions.",
      "name": "versions"
    }
  ]
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http",
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "Assisted installation",
    "title": "AssistedInstall",
    "license": {
      "name": "Apache 2.0",
      "url": "http://www.apache.org/licenses/LICENSE-2.0.html"
    },
    "version": "1.0.0"
  },
  "host": "api.openshift.com",
  "basePath": "/api/assisted-install",
  "paths": {
    "/v1/add_hosts_clusters": {
      "post": {
        "description": "Creates a new OpenShift cluster definition for adding nodes to and existing OCP cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "RegisterAddHostsCluster",
        "parameters": [
          {
            "description": "Parameters for creating a new cluster for adding nodes.",
            "name": "new-add-hosts-cluster-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/add-hosts-cluster-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/assisted-service-iso": {
      "post": {
        "description": "Creates ISO for the user and uploads to S3.",
        "tags": [
          "assisted-service-iso"
        ],
        "operationId": "CreateISOAndUploadToS3",
        "parameters": [
          {
            "description": "Parameters for creating an Assisted Service ISO.",
            "name": "assisted-service-iso-create-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/assisted-service-iso-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/assisted-service-iso/data": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Downloads the Assisted Service ISO.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "assisted-service-iso"
        ],
        "operationId": "DownloadISO",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/assisted-service-iso/presigned": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves a pre-signed S3 URL for downloading assisted-service ISO.",
        "tags": [
          "assisted-service-iso"
        ],
        "operationId": "GetPresignedForAssistedServiceISO",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/presigned"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves the list of OpenShift clusters.",
        "tags": [
          "installer"
        ],
        "operationId": "ListClusters",
        "parameters": [
          {
            "type": "boolean",
            "default": false,
            "description": "Whether to return clusters that have been unregistered.",
            "name": "get_unregistered_clusters",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "A specific cluster to retrieve.",
            "name": "openshift_cluster_id",
            "in": "query"
          },
          {
            "type": "array",
            "items": {
              "type": "string"
            },
            "description": "If non-empty, returned Clusters are filtered to those with matching subscription IDs.",
            "name": "ams_subscription_ids",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "Include hosts in the returned list.",
            "name": "with_hosts",
            "in": "query",
            "allowEmptyValue": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "description": "Creates a new OpenShift cluster definition.",
        "tags": [
          "installer"
        ],
        "operationId": "RegisterCluster",
        "parameters": [
          {
            "description": "The properties describing the new cluster.",
            "name": "new-cluster-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cluster-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/default-config": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Get the default values for various cluster properties.",
        "tags": [
          "installer"
        ],
        "operationId": "GetClusterDefaultConfig",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster_default_config"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "agentAuth": []
          }
        ],
        "description": "Retrieves the details of the OpenShift cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "GetCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to be retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is retrieving the cluster details.",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "Whether to return clusters that have been unregistered.",
            "name": "get_unregistered_clusters",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "description": "Deletes an OpenShift cluster definition.",
        "tags": [
          "installer"
        ],
        "operationId": "DeregisterCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to be deregistered.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "description": "Updates an OpenShift cluster definition.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to be updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The properties to update.",
            "name": "cluster-update-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cluster-update-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/actions/cancel": {
      "post": {
        "description": "Cancels an ongoing installation.",
        "tags": [
          "installer"
        ],
        "operationId": "CancelInstallation",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose installation is to be canceled.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/actions/complete_installation": {
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Agent API to mark a finalizing installation as complete.",
        "tags": [
          "installer"
        ],
        "operationId": "CompleteInstallation",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose installation is being completing.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The final status of the cluster installation.",
            "name": "completion-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/completion-params"
            }
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is completing the installation.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/actions/install": {
      "post": {
        "description": "Installs the OpenShift cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "InstallCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to be installed.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/actions/install_hosts": {
      "post": {
        "description": "Installs the OpenShift cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "InstallHosts",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The existing cluster whose hosts should be added.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/actions/reset": {
      "post": {
        "description": "Resets a failed installation.",
        "tags": [
          "installer"
        ],
        "operationId": "ResetCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose installation is to be reset.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/credentials": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Get the cluster admin credentials.",
        "tags": [
          "installer"
        ],
        "operationId": "GetCredentials",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose admin credentials should be retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/credentials"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/discovery-ignition": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Get the discovery ignition for the cluster based on its attributes and overridden ignition value before generating the discovery ISO.\nUsed to test the validity of the discovery ignition when it is being overridden.\nFor downloading the generated discovery ignition use /clusters/$CLUSTER_ID/downloads/files?file_name=discovery.ign\n",
        "tags": [
          "installer"
        ],
        "operationId": "GetDiscoveryIgnition",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster for which the discovery ignition config should be retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/discovery-ignition-params"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "description": "Override values in the discovery ignition config.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateDiscoveryIgnition",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster for which the discovery ignition config should be updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "Overrides for the discovery ignition config.",
            "name": "discovery-ignition-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/discovery-ignition-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/downloads/files": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "agentAuth": []
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Downloads files relating to the installed/installing cluster.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadClusterFiles",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster that owns the file that should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "bootstrap.ign",
              "master.ign",
              "metadata.json",
              "worker.ign",
              "kubeadmin-password",
              "kubeconfig",
              "kubeconfig-noingress",
              "install-config.yaml",
              "discovery.ign",
              "custom_manifests.yaml"
            ],
            "type": "string",
            "description": "The file to be downloaded.",
            "name": "file_name",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is downloading the file.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/downloads/files-presigned": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves a pre-signed S3 URL for downloading cluster files.",
        "tags": [
          "installer"
        ],
        "operationId": "GetPresignedForClusterFiles",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster that owns the file that should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "bootstrap.ign",
              "master.ign",
              "metadata.json",
              "worker.ign",
              "kubeadmin-password",
              "kubeconfig",
              "kubeconfig-noingress",
              "install-config.yaml",
              "logs",
              "manifests"
            ],
            "type": "string",
            "description": "The file to be downloaded.",
            "name": "file_name",
            "in": "query",
            "required": true
          },
          {
            "enum": [
              "host",
              "controller",
              "all"
            ],
            "type": "string",
            "description": "If downloading logs, the type of logs to download.",
            "name": "logs_type",
            "in": "query"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "If downloading a file related to a host, the relevant host.",
            "name": "host_id",
            "in": "query"
          },
          {
            "type": "string",
            "description": "If downloading a manifest, the file name, prefaced with folder name, for example, openshift/99-openshift-xyz.yaml.",
            "name": "additional_name",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/presigned"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/downloads/image": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Downloads the OpenShift per-cluster Discovery ISO.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadClusterISO",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose ISO should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed."
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "description": "Creates a new OpenShift per-cluster Discovery ISO.",
        "tags": [
          "installer"
        ],
        "operationId": "GenerateClusterISO",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose ISO should be generated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The parameters for the generated ISO.",
            "name": "image-create-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/image-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "head": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Downloads the OpenShift per-cluster Discovery ISO Headers only.",
        "tags": [
          "installer"
        ],
        "operationId": "DownloadClusterISOHeaders",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose ISO headers should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "headers": {
              "Content-Length": {
                "type": "integer",
                "description": "Size of the ISO in bytes"
              }
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed."
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/downloads/kubeconfig": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Downloads the kubeconfig file for this cluster.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadClusterKubeconfig",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose kubeconfig should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/events": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Lists events for a cluster.",
        "tags": [
          "events"
        ],
        "operationId": "ListEvents",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to return events for.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "A host in the specified cluster to return events for.",
            "name": "host_id",
            "in": "query"
          },
          {
            "type": "array",
            "items": {
              "type": "string"
            },
            "description": "A comma-separated list of event categories.",
            "name": "categories",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/event-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/free_addresses": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves the free address list for a network.",
        "tags": [
          "installer"
        ],
        "operationId": "GetFreeAddresses",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to return free addresses for.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$",
            "type": "string",
            "description": "The cluster network to return free addresses for.",
            "name": "network",
            "in": "query",
            "required": true
          },
          {
            "maximum": 8000,
            "minimum": 1,
            "type": "integer",
            "default": 8000,
            "description": "The maximum number of free addresses to return.",
            "name": "limit",
            "in": "query"
          },
          {
            "type": "string",
            "description": "A prefix for the free addresses to return.",
            "name": "prefix",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/free-addresses-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/host-requirements": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Get host requirements of a cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "GetClusterHostRequirements",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to return operators for.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster-host-requirements-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "agentAuth": []
          }
        ],
        "description": "Retrieves the list of OpenShift hosts.",
        "tags": [
          "installer"
        ],
        "operationId": "ListHosts",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose hosts should be listed.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is listing hosts.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Registers a new OpenShift host.",
        "tags": [
          "installer"
        ],
        "operationId": "RegisterHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster into which the host should be registered.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The description of the host being registered.",
            "name": "new-host-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-create-params"
            }
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is registering the host.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host_registration_response"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Cluster cannot accept new hosts due to its current state.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves the details of the OpenShift host.",
        "tags": [
          "installer"
        ],
        "operationId": "GetHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that should be retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that should be retrieved.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "description": "Deregisters an OpenShift host.",
        "tags": [
          "installer"
        ],
        "operationId": "DeregisterHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that should be deregistered.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that should be deregistered.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/enable": {
      "post": {
        "description": "Enables a host for inclusion in the cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "EnableHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that is being enabled.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is being enabled.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "description": "Disables a host for inclusion in the cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "DisableHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that is being disabled.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is being disabled.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/install": {
      "post": {
        "description": "install specific host for day2 cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "InstallHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that is being installed.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is being installed.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/reset": {
      "post": {
        "description": "reset a failed host for day2 cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "ResetHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that is being reset.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is being reset.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/reset-validation/{validation_id}": {
      "patch": {
        "description": "Reset failed host validation.  It may be performed on any host validation with persistent validation result.",
        "tags": [
          "installer"
        ],
        "summary": "Reset failed host validation.",
        "operationId": "ResetHostValidation",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that its validation is being reset.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that its validation is being reset.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The id of the validation being reset.",
            "name": "validation_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "400": {
            "description": "Bad Request",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/downloads/ignition": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "agentAuth": []
          }
        ],
        "description": "Downloads the customized ignition file for this host",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadHostIgnition",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host whose ignition file should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose ignition file should be downloaded.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/ignition": {
      "get": {
        "description": "Get the customized ignition file for this host",
        "tags": [
          "installer"
        ],
        "operationId": "GetHostIgnition",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host whose customized ignition file should be retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose customized ignition file should be retrieved.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host-ignition-params"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "description": "Patch the ignition file for this host",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateHostIgnition",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host whose ignition file should be updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose ignition file should be updated.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "Ignition config overrides.",
            "name": "host-ignition-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-ignition-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/installer-args": {
      "patch": {
        "description": "Updates a host's installer arguments.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateHostInstallerArgs",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host whose installer arguments should be updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose installer arguments should be updated.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The updated installer arguments.",
            "name": "installer-args-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/installer-args-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/instructions": {
      "get": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Retrieves the next operations that the host agent needs to perform.",
        "tags": [
          "installer"
        ],
        "operationId": "GetNextSteps",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that is retrieving instructions.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is retrieving instructions.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is retrieving instructions.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/steps"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Posts the result of the operations from the host agent.",
        "tags": [
          "installer"
        ],
        "operationId": "PostStepReply",
        "parameters": [
          {
            "type": "string",
            "description": "The software version of the discovery agent that is posting results.",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host that is posting results.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is posting results.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The results to be posted.",
            "name": "reply",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/step-reply"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/logs": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Download host logs.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadHostLogs",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host whose logs should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose logs should be downloaded.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Agent API to upload logs.",
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "UploadHostLogs",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster of the host whose logs should be uploaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose logs should be uploaded.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "type": "file",
            "x-mimetype": "application/zip",
            "description": "The log file to be uploaded.",
            "name": "upfile",
            "in": "formData"
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is uploading the logs.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/logs_progress": {
      "put": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Update log collection state and progress.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateHostLogsProgress",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose log progress is being updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose log progress is being updated.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "Parameters for updating log progress.",
            "name": "logs-progress-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/logs-progress-params"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Update cluster install progress."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/hosts/{host_id}/progress": {
      "put": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Update installation progress.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateHostInstallProgress",
        "parameters": [
          {
            "type": "string",
            "description": "The software version of the discovery agent that is updating progress.",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the cluster to retrieve.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the host to retrieve.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "New progress value.",
            "name": "host-progress",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-progress"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Update install progress."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/install-config": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Get the cluster's install config YAML.",
        "tags": [
          "installer"
        ],
        "operationId": "GetClusterInstallConfig",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose install config is being retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "description": "Override values in the install config.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateClusterInstallConfig",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose install config is being updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "Install config overrides.",
            "name": "install-config-params",
            "in": "body",
            "required": true,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/logs": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Download cluster logs.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadClusterLogs",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose logs should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "host",
              "controller",
              "all"
            ],
            "type": "string",
            "description": "The type of logs to be downloaded.",
            "name": "logs_type",
            "in": "query"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "A specific host in the cluster whose logs should be downloaded.",
            "name": "host_id",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Agent API to upload logs.",
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "UploadLogs",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose logs should be uploaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "maxLength": 104857600,
            "type": "file",
            "x-mimetype": "application/zip",
            "description": "The log file to be uploaded.",
            "name": "upfile",
            "in": "formData"
          },
          {
            "enum": [
              "host",
              "controller"
            ],
            "type": "string",
            "description": "The type of log file to be uploaded.",
            "name": "logs_type",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host whose logs should be uploaded.",
            "name": "host_id",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/logs_progress": {
      "put": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Update log collection state and progress.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateClusterLogsProgress",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose log progress is being updated.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "Parameters for updating log progress.",
            "name": "logs-progress-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/logs-progress-params"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Update cluster install progress."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/manifests": {
      "get": {
        "security": [
          {
            "userAuth": []
          }
        ],
        "description": "Lists manifests for customizing cluster installation.",
        "tags": [
          "manifests"
        ],
        "operationId": "ListClusterManifests",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster for which the manifests should be listed.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/list-manifests"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "userAuth": []
          }
        ],
        "description": "Creates a manifest for customizing cluster installation.",
        "tags": [
          "manifests"
        ],
        "operationId": "CreateClusterManifest",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster for which a new manifest should be created.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The new manifest to create.",
            "name": "CreateManifestParams",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/create-manifest-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/manifest"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "description": "Deletes a manifest from the cluster.",
        "tags": [
          "manifests"
        ],
        "operationId": "DeleteClusterManifest",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose manifest should be deleted.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "manifests",
              "openshift"
            ],
            "type": "string",
            "default": "manifests",
            "description": "The folder that contains the files. Manifests can be placed in 'manifests' or 'openshift' directories.",
            "name": "folder",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The manifest file name to delete from the cluster.",
            "name": "file_name",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/manifests/files": {
      "get": {
        "security": [
          {
            "userAuth": []
          }
        ],
        "description": "Downloads cluster manifest.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "manifests"
        ],
        "operationId": "DownloadClusterManifest",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose manifest should be downloaded.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "manifests",
              "openshift"
            ],
            "type": "string",
            "default": "manifests",
            "description": "The folder that contains the files. Manifests can be placed in 'manifests' or 'openshift' directories.",
            "name": "folder",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The manifest file name to download.",
            "name": "file_name",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/monitored_operators": {
      "get": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Lists operators to be monitored for a cluster.",
        "tags": [
          "operators",
          "installer"
        ],
        "operationId": "ListOfClusterOperators",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to return operators for.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "An operator in the specified cluster to return its data.",
            "name": "operator_name",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/monitored-operators-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "put": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Controller API to report of monitored operators.",
        "tags": [
          "operators",
          "installer"
        ],
        "operationId": "ReportMonitoredOperatorStatus",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose operators are being monitored.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The operators monitor report.",
            "name": "report-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/operator-monitor-report"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Success."
          },
          "400": {
            "description": "Bad Request",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/preflight-requirements": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Get preflight requirements for a cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "GetPreflightRequirements",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to return preflight requrements for.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/preflight-hardware-requirements"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/clusters/{cluster_id}/uploads/ingress-cert": {
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Transfer the ingress certificate for the cluster.",
        "tags": [
          "installer"
        ],
        "operationId": "UploadClusterIngressCert",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster to associate with the ingress certificate.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The ingress certificate.",
            "name": "ingress-cert-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ingress-cert-params"
            }
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is uploading the ingress certificate.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/component_versions": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "List of component versions.",
        "tags": [
          "versions"
        ],
        "operationId": "ListComponentVersions",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/list-versions"
            }
          }
        }
      }
    },
    "/v1/domains": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "List of managed DNS domains.",
        "tags": [
          "managed_domains"
        ],
        "operationId": "ListManagedDomains",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/list-managed-domains"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/openshift_versions": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves the list of OpenShift supported versions.",
        "tags": [
          "versions"
        ],
        "operationId": "ListSupportedOpenshiftVersions",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/openshift-versions"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/supported-operators": {
      "get": {
        "description": "Retrieves the list of supported operators.",
        "tags": [
          "operators"
        ],
        "operationId": "ListSupportedOperators",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v1/supported-operators/{operator_name}": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Lists properties for an operator.",
        "tags": [
          "operators"
        ],
        "operationId": "ListOperatorProperties",
        "parameters": [
          {
            "type": "string",
            "description": "The operator name.",
            "name": "operator_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/operator-properties"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/clusters/{cluster_id}/supported-platforms": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "A list of platforms that this cluster can support in its current configuration.",
        "tags": [
          "installer"
        ],
        "operationId": "GetClusterSupportedPlatforms",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The cluster whose platform types should be retrieved.",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/platform_type"
              }
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves the list of InfraEnvs.",
        "tags": [
          "installer"
        ],
        "operationId": "ListInfraEnvs",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/infra-env-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "description": "Creates a new OpenShift Discovery ISO.",
        "tags": [
          "installer"
        ],
        "operationId": "RegisterInfraEnv",
        "parameters": [
          {
            "description": "The parameters for the generated ISO.",
            "name": "infraenv-create-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/infra-env-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/infra-env"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs/{infra_env_id}": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "agentAuth": []
          }
        ],
        "description": "Retrieves the details of the InfraEnv.",
        "tags": [
          "installer"
        ],
        "operationId": "GetInfraEnv",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv to be retrieved.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/infra-env"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "description": "Deletes an InfraEnv.",
        "tags": [
          "installer"
        ],
        "operationId": "DeregisterInfraEnv",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv to be deleted.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "description": "Updates an InfraEnv.",
        "tags": [
          "installer"
        ],
        "operationId": "UpdateInfraEnv",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv to be updated.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The properties to update.",
            "name": "infra-env-update-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/infra-env-update-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/infra-env"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs/{infra_env_id}/hosts": {
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Registers a new OpenShift agent.",
        "tags": [
          "installer"
        ],
        "operationId": "v2RegisterHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv that the agent is associated with.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The description of the agent being registered.",
            "name": "new-host-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-create-params"
            }
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is registering the agent.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host_registration_response"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Cluster cannot accept new agents due to its current state.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs/{infra_env_id}/hosts/{host_id}": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          }
        ],
        "description": "Retrieves the details of the OpenShift host.",
        "tags": [
          "installer"
        ],
        "operationId": "v2GetHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The infra env of the host that should be retrieved.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that should be retrieved.",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/instructions": {
      "get": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Retrieves the next operations that the host agent needs to perform.",
        "tags": [
          "installer"
        ],
        "operationId": "v2GetNextSteps",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The infra env of the host that is retrieving instructions.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is retrieving instructions.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The software version of the discovery agent that is retrieving instructions.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/steps"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Posts the result of the operations from the host agent.",
        "tags": [
          "installer"
        ],
        "operationId": "v2PostStepReply",
        "parameters": [
          {
            "type": "string",
            "description": "The software version of the discovery agent that is posting results.",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The infra env of the host that is posting results.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The host that is posting results.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The results to be posted.",
            "name": "reply",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/step-reply"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/progress": {
      "put": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "description": "Update installation progress.",
        "tags": [
          "installer"
        ],
        "operationId": "v2UpdateHostInstallProgress",
        "parameters": [
          {
            "type": "string",
            "description": "The software version of the discovery agent that is updating progress.",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv of the host being updated.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the host to update.",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "New progress value.",
            "name": "host-progress",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-progress"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Update install progress."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/v2/infra-envs/{infra_env_id}/image": {
      "get": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Downloads the discovery image.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "operationId": "DownloadInfraEnvDiscoveryImage",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv whose image should be downloaded.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed."
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "head": {
        "security": [
          {
            "userAuth": [
              "admin",
              "read-only-admin",
              "user"
            ]
          },
          {
            "urlAuth": []
          }
        ],
        "description": "Downloads the discovery image Headers only.",
        "tags": [
          "installer"
        ],
        "operationId": "DownloadInfraEnvDiscoveryImageHeaders",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The InfraEnv whose image headers should be retrieved.",
            "name": "infra_env_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "headers": {
              "Content-Length": {
                "type": "integer",
                "description": "Size of the ISO in bytes"
              }
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed."
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "501": {
            "description": "Not implemented.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "ClusterUpdateParamsDisksSelectedConfigItems0": {
      "type": "object",
      "properties": {
        "disks_config": {
          "description": "The desired disks parameters (such as the disk's role).",
          "type": "array",
          "items": {
            "$ref": "#/definitions/disk-config-params"
          }
        },
        "id": {
          "type": "string",
          "format": "uuid"
        }
      }
    },
    "ClusterUpdateParamsHostsMachineConfigPoolNamesItems0": {
      "type": "object",
      "properties": {
        "id": {
          "type": "string",
          "format": "uuid"
        },
        "machine_config_pool_name": {
          "type": "string"
        }
      }
    },
    "ClusterUpdateParamsHostsNamesItems0": {
      "type": "object",
      "properties": {
        "hostname": {
          "type": "string"
        },
        "id": {
          "type": "string",
          "format": "uuid"
        }
      }
    },
    "ClusterUpdateParamsHostsRolesItems0": {
      "type": "object",
      "properties": {
        "id": {
          "type": "string",
          "format": "uuid"
        },
        "role": {
          "$ref": "#/definitions/host-role-update-params"
        }
      }
    },
    "DiskInstallationEligibility": {
      "type": "object",
      "properties": {
        "eligible": {
          "description": "Whether the disk is eligible for installation or not.",
          "type": "boolean"
        },
        "not_eligible_reasons": {
          "description": "Reasons for why this disk is not eligible for installation.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      },
      "x-nullable": false
    },
    "DomainResolutionRequestDomainsItems0": {
      "type": "object",
      "required": [
        "domain_name"
      ],
      "properties": {
        "domain_name": {
          "description": "The domain name that should be resolved",
          "type": "string"
        }
      },
      "x-go-name": "DomainResolutionRequestDomain"
    },
    "DomainResolutionResponseResolutionsItems0": {
      "type": "object",
      "required": [
        "domain_name"
      ],
      "properties": {
        "domain_name": {
          "description": "The domain that was resolved",
          "type": "string"
        },
        "ipv4_addresses": {
          "description": "The IPv4 addresses of the domain, empty if none",
          "type": "array",
          "items": {
            "type": "string",
            "format": "ipv4"
          }
        },
        "ipv6_addresses": {
          "description": "The IPv6 addresses of the domain, empty if none",
          "type": "array",
          "items": {
            "type": "string",
            "format": "ipv6"
          }
        }
      },
      "x-go-name": "DomainResolutionResponseDomain"
    },
    "HostRegistrationResponseAO1NextStepRunnerCommand": {
      "description": "Command for starting the next step runner",
      "type": "object",
      "properties": {
        "args": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "command": {
          "type": "string"
        },
        "retry_seconds": {
          "description": "How long in seconds to wait before retrying registration if the command fails",
          "type": "integer"
        }
      }
    },
    "MacInterfaceMapItems0": {
      "type": "object",
      "properties": {
        "logical_nic_name": {
          "description": "nic name used in the yaml, which relates 1:1 to the mac address",
          "type": "string"
        },
        "mac_address": {
          "description": "mac address present on the host",
          "type": "string",
          "pattern": "^([0-9A-Fa-f]{2}[:]){5}([0-9A-Fa-f]{2})$"
        }
      }
    },
    "add-hosts-cluster-create-params": {
      "type": "object",
      "required": [
        "id",
        "name",
        "api_vip_dnsname",
        "openshift_version"
      ],
      "properties": {
        "api_vip_dnsname": {
          "description": "api vip domain.",
          "type": "string"
        },
        "id": {
          "description": "Unique identifier of the object.",
          "type": "string",
          "format": "uuid"
        },
        "name": {
          "description": "Name of the OpenShift cluster.",
          "type": "string"
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster.",
          "type": "string"
        }
      }
    },
    "api_vip_connectivity_request": {
      "type": "object",
      "required": [
        "url"
      ],
      "properties": {
        "url": {
          "description": "URL address of the API.",
          "type": "string"
        },
        "verify_cidr": {
          "description": "Whether to verify if the API VIP belongs to one of the interfaces.",
          "type": "boolean"
        }
      }
    },
    "api_vip_connectivity_response": {
      "type": "object",
      "properties": {
        "is_success": {
          "description": "API VIP connectivity check result.",
          "type": "boolean"
        }
      }
    },
    "assisted-service-iso-create-params": {
      "type": "object",
      "properties": {
        "openshift_version": {
          "description": "Version of the OpenShift cluster.",
          "type": "string"
        },
        "pull_secret": {
          "description": "The pull secret obtained from Red Hat OpenShift Cluster Manager at cloud.redhat.com/openshift/install/pull-secret.",
          "type": "string"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string"
        }
      }
    },
    "boot": {
      "type": "object",
      "properties": {
        "current_boot_mode": {
          "type": "string"
        },
        "pxe_interface": {
          "type": "string"
        }
      }
    },
    "cluster": {
      "type": "object",
      "required": [
        "kind",
        "id",
        "href",
        "image_info",
        "status",
        "status_info"
      ],
      "properties": {
        "additional_ntp_source": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string"
        },
        "ams_subscription_id": {
          "description": "Unique identifier of the AMS subscription in OCM.",
          "type": "string",
          "format": "uuid"
        },
        "api_vip": {
          "description": "The virtual IP used to reach the OpenShift cluster's API.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3})|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,}))$"
        },
        "api_vip_dns_name": {
          "description": "The domain name used to reach the OpenShift cluster API.",
          "type": "string",
          "x-nullable": true
        },
        "base_dns_domain": {
          "description": "Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.",
          "type": "string"
        },
        "cluster_network_cidr": {
          "description": "IP address block from which Pod IPs are allocated. This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$"
        },
        "cluster_network_host_prefix": {
          "description": "The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.",
          "type": "integer",
          "maximum": 128,
          "minimum": 1
        },
        "connectivity_majority_groups": {
          "description": "Json formatted string containing the majority groups for connectivity checks.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "controller_logs_collected_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "controller_logs_started_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "created_at": {
          "description": "The time that this cluster was created.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "deleted_at": {
          "description": "The time that the cluster was deleted.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\"",
          "x-nullable": true
        },
        "email_domain": {
          "type": "string"
        },
        "enabled_host_count": {
          "description": "hosts associated to this cluster that are not in 'disabled' state.",
          "type": "integer",
          "format": "int64",
          "x-go-custom-tag": "gorm:\"-\""
        },
        "feature_usage": {
          "description": "JSON-formatted string containing the usage information by feature name",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "high_availability_mode": {
          "description": "Guaranteed availability of the installed cluster. 'Full' installs a Highly-Available cluster\nover multiple master nodes whereas 'None' installs a full cluster over one node.\n",
          "type": "string",
          "default": "Full",
          "enum": [
            "Full",
            "None"
          ]
        },
        "host_networks": {
          "description": "List of host networks to be filled during query.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/host_network"
          },
          "x-go-custom-tag": "gorm:\"-\""
        },
        "hosts": {
          "description": "Hosts that are associated with this cluster.",
          "type": "array",
          "items": {
            "type": "object",
            "$ref": "#/definitions/host"
          },
          "x-go-custom-tag": "gorm:\"foreignkey:ClusterID;association_foreignkey:ID\""
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string"
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-go-custom-tag": "gorm:\"column:https_proxy\""
        },
        "hyperthreading": {
          "description": "Enable/disable hyperthreading on master nodes, worker nodes, or all nodes",
          "type": "string",
          "enum": [
            "masters",
            "workers",
            "all",
            "none"
          ]
        },
        "id": {
          "description": "Unique identifier of the object.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key\""
        },
        "ignition_config_overrides": {
          "description": "Json formatted string containing the user overrides for the initial ignition config",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\"",
          "example": "{\"ignition\": {\"version\": \"3.1.0\"}, \"storage\": {\"files\": [{\"path\": \"/tmp/example\", \"contents\": {\"source\": \"data:text/plain;base64,aGVscGltdHJhcHBlZGluYXN3YWdnZXJzcGVj\"}}]}}"
        },
        "image_info": {
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:image_\"",
          "$ref": "#/definitions/image_info"
        },
        "ingress_vip": {
          "description": "The virtual IP used for cluster ingress traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3})|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,}))$"
        },
        "install_completed_at": {
          "description": "The time that this cluster completed installation.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone;default:'2000-01-01 00:00:00z'\""
        },
        "install_config_overrides": {
          "description": "JSON-formatted string containing the user overrides for the install-config.yaml file.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\"",
          "example": "{\"networking\":{\"networkType\": \"OVN-Kubernetes\"},\"fips\":true}"
        },
        "install_started_at": {
          "description": "The time that this cluster started installation.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone;default:'2000-01-01 00:00:00z'\""
        },
        "kind": {
          "description": "Indicates the type of this object. Will be 'Cluster' if this is a complete object,\n'AddHostsCluster' for cluster that add hosts to existing OCP cluster,\n",
          "type": "string",
          "enum": [
            "Cluster",
            "AddHostsCluster"
          ]
        },
        "logs_info": {
          "description": "The progress of log collection or empty if logs are not applicable",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\"",
          "$ref": "#/definitions/logs_state"
        },
        "machine_network_cidr": {
          "description": "A CIDR that all hosts belonging to the cluster should have an interfaces with IP address that belongs to this CIDR. The api_vip belongs to this CIDR.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$"
        },
        "monitored_operators": {
          "description": "Operators that are associated with this cluster.",
          "type": "array",
          "items": {
            "type": "object",
            "$ref": "#/definitions/monitored-operator"
          },
          "x-go-custom-tag": "gorm:\"foreignkey:ClusterID;association_foreignkey:ID\""
        },
        "name": {
          "description": "Name of the OpenShift cluster.",
          "type": "string"
        },
        "network_configuration": {
          "description": "JSON-formatted string containing the networking data for the install-config.yaml file.",
          "type": "string"
        },
        "network_type": {
          "description": "The desired network type used.",
          "type": "string",
          "enum": [
            "OpenShiftSDN",
            "OVNKubernetes"
          ],
          "x-nullable": true
        },
        "no_proxy": {
          "description": "A comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude from proxying.",
          "type": "string"
        },
        "ocp_release_image": {
          "description": "OpenShift release image URI.",
          "type": "string"
        },
        "openshift_cluster_id": {
          "description": "Cluster ID on OCP system.",
          "type": "string",
          "format": "uuid"
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster.",
          "type": "string"
        },
        "org_id": {
          "type": "string"
        },
        "platform": {
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:platform_\"",
          "$ref": "#/definitions/platform"
        },
        "progress": {
          "description": "Installation progress percentages of the cluster.",
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:progress_\"",
          "$ref": "#/definitions/cluster-progress-info"
        },
        "pull_secret_set": {
          "description": "True if the pull secret has been added to the cluster.",
          "type": "boolean"
        },
        "ready_host_count": {
          "description": "hosts associated to this cluster that are in 'known' state.",
          "type": "integer",
          "format": "int64",
          "x-go-custom-tag": "gorm:\"-\""
        },
        "schedulable_masters": {
          "description": "Schedule workloads on masters",
          "type": "boolean",
          "default": false
        },
        "service_network_cidr": {
          "description": "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging OpenShift nodes.",
          "type": "string"
        },
        "status": {
          "description": "Status of the OpenShift cluster.",
          "type": "string",
          "enum": [
            "insufficient",
            "ready",
            "error",
            "preparing-for-installation",
            "pending-for-input",
            "installing",
            "finalizing",
            "installed",
            "adding-hosts",
            "cancelled",
            "installing-pending-user-action"
          ]
        },
        "status_info": {
          "description": "Additional information pertaining to the status of the OpenShift cluster.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "status_updated_at": {
          "description": "The last time that the cluster status was updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "total_host_count": {
          "description": "All hosts associated to this cluster.",
          "type": "integer",
          "format": "int64",
          "x-go-custom-tag": "gorm:\"-\""
        },
        "updated_at": {
          "description": "The last time that this cluster was updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "user_managed_networking": {
          "description": "Indicate if the networking is managed by the user.",
          "type": "boolean",
          "x-nullable": true
        },
        "user_name": {
          "type": "string"
        },
        "validations_info": {
          "description": "JSON-formatted string containing the validation results for each validation id grouped by category (network, hosts-data, etc.)",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "vip_dhcp_allocation": {
          "description": "Indicate if virtual IP DHCP allocation mode is enabled.",
          "type": "boolean",
          "x-nullable": true
        }
      }
    },
    "cluster-create-params": {
      "type": "object",
      "required": [
        "name",
        "openshift_version",
        "pull_secret"
      ],
      "properties": {
        "additional_ntp_source": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string",
          "x-nullable": true
        },
        "base_dns_domain": {
          "description": "Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.",
          "type": "string"
        },
        "cluster_network_cidr": {
          "description": "IP address block from which Pod IPs are allocated. This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "default": "10.128.0.0/14",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$"
        },
        "cluster_network_host_prefix": {
          "description": "The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.",
          "type": "integer",
          "default": 23,
          "maximum": 128,
          "minimum": 1
        },
        "high_availability_mode": {
          "description": "Guaranteed availability of the installed cluster. 'Full' installs a Highly-Available cluster\nover multiple master nodes whereas 'None' installs a full cluster over one node.\n",
          "type": "string",
          "default": "Full",
          "enum": [
            "Full",
            "None"
          ]
        },
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "hyperthreading": {
          "description": "Enable/disable hyperthreading on master nodes, worker nodes, or all nodes.",
          "type": "string",
          "default": "all",
          "enum": [
            "masters",
            "workers",
            "none",
            "all"
          ]
        },
        "ingress_vip": {
          "description": "The virtual IP used for cluster ingress traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3})|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,}))$"
        },
        "name": {
          "description": "Name of the OpenShift cluster.",
          "type": "string",
          "maxLength": 54,
          "minLength": 1
        },
        "network_configuration": {
          "x-nullable": true,
          "$ref": "#/definitions/network_configuration"
        },
        "network_type": {
          "description": "The desired network type used.",
          "type": "string",
          "default": "OpenShiftSDN",
          "enum": [
            "OpenShiftSDN",
            "OVNKubernetes"
          ]
        },
        "no_proxy": {
          "description": "An \"*\" or a comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude from proxying.",
          "type": "string",
          "x-nullable": true
        },
        "ocp_release_image": {
          "description": "OpenShift release image URI.",
          "type": "string"
        },
        "olm_operators": {
          "description": "List of OLM operators to be installed.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/operator-create-params"
          }
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster.",
          "type": "string"
        },
        "platform": {
          "type": "object",
          "x-nullable": true,
          "$ref": "#/definitions/platform"
        },
        "pull_secret": {
          "description": "The pull secret obtained from Red Hat OpenShift Cluster Manager at cloud.redhat.com/openshift/install/pull-secret.",
          "type": "string"
        },
        "schedulable_masters": {
          "description": "Schedule workloads on masters",
          "type": "boolean",
          "default": false
        },
        "service_network_cidr": {
          "description": "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "default": "172.30.0.0/16",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging OpenShift nodes.",
          "type": "string"
        },
        "user_managed_networking": {
          "description": "Indicate if the networking is managed by the user.",
          "type": "boolean",
          "default": false,
          "x-nullable": true
        },
        "vip_dhcp_allocation": {
          "description": "Indicate if virtual IP DHCP allocation mode is enabled.",
          "type": "boolean",
          "default": true,
          "x-nullable": true
        }
      }
    },
    "cluster-host-requirements": {
      "type": "object",
      "properties": {
        "host_id": {
          "description": "Unique identifier of the host the requirements relate to.",
          "type": "string",
          "format": "uuid"
        },
        "ocp": {
          "description": "Host requirements for the OCP installation",
          "$ref": "#/definitions/cluster-host-requirements-details"
        },
        "operators": {
          "description": "Host requirements related to requested operators",
          "type": "array",
          "items": {
            "$ref": "#/definitions/operator-host-requirements"
          }
        },
        "total": {
          "description": "Total host requirements for the cluster configuration",
          "$ref": "#/definitions/cluster-host-requirements-details"
        }
      }
    },
    "cluster-host-requirements-details": {
      "type": "object",
      "properties": {
        "cpu_cores": {
          "description": "Required number of CPU cores",
          "type": "integer"
        },
        "disk_size_gb": {
          "description": "Required disk size in GB",
          "type": "integer"
        },
        "installation_disk_speed_threshold_ms": {
          "description": "Required installation disk speed in ms",
          "type": "integer"
        },
        "network_latency_threshold_ms": {
          "description": "Maximum network average latency (RTT) at L3 for role.",
          "type": "number",
          "format": "double",
          "x-nullable": true
        },
        "packet_loss_percentage": {
          "description": "Maximum packet loss allowed at L3 for role.",
          "type": "number",
          "format": "double",
          "x-nullable": true
        },
        "ram_mib": {
          "description": "Required number of RAM in MiB",
          "type": "integer"
        }
      }
    },
    "cluster-host-requirements-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/cluster-host-requirements"
      }
    },
    "cluster-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/cluster"
      }
    },
    "cluster-progress-info": {
      "type": "object",
      "properties": {
        "finalizing_stage_percentage": {
          "type": "integer"
        },
        "installing_stage_percentage": {
          "type": "integer"
        },
        "preparing_for_installation_stage_percentage": {
          "type": "integer"
        },
        "total_percentage": {
          "type": "integer"
        }
      }
    },
    "cluster-update-params": {
      "type": "object",
      "properties": {
        "additional_ntp_source": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string",
          "x-nullable": true
        },
        "api_vip": {
          "description": "The virtual IP used to reach the OpenShift cluster's API.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3})|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,}))?$",
          "x-nullable": true
        },
        "api_vip_dns_name": {
          "description": "The domain name used to reach the OpenShift cluster API.",
          "type": "string",
          "x-nullable": true
        },
        "base_dns_domain": {
          "description": "Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.",
          "type": "string",
          "x-nullable": true
        },
        "cluster_network_cidr": {
          "description": "IP address block from which Pod IPs are allocated. This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$",
          "x-nullable": true
        },
        "cluster_network_host_prefix": {
          "description": "The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.",
          "type": "integer",
          "maximum": 128,
          "minimum": 1,
          "x-nullable": true
        },
        "disks_selected_config": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/ClusterUpdateParamsDisksSelectedConfigItems0"
          },
          "x-nullable": true
        },
        "hosts_machine_config_pool_names": {
          "description": "The desired machine config pool for hosts associated with the cluster.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/ClusterUpdateParamsHostsMachineConfigPoolNamesItems0"
          },
          "x-nullable": true
        },
        "hosts_names": {
          "description": "The desired hostname for hosts associated with the cluster.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/ClusterUpdateParamsHostsNamesItems0"
          },
          "x-nullable": true
        },
        "hosts_roles": {
          "description": "The desired role for hosts associated with the cluster.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/ClusterUpdateParamsHostsRolesItems0"
          },
          "x-nullable": true
        },
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "hyperthreading": {
          "description": "Enable/disable hyperthreading on master nodes, worker nodes, or all nodes.",
          "type": "string",
          "enum": [
            "masters",
            "workers",
            "all",
            "none"
          ],
          "x-nullable": true
        },
        "ingress_vip": {
          "description": "The virtual IP used for cluster ingress traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3})|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,}))?$",
          "x-nullable": true
        },
        "machine_network_cidr": {
          "description": "A CIDR that all hosts belonging to the cluster should have an interfaces with IP address that belongs to this CIDR. The api_vip belongs to this CIDR.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$",
          "x-nullable": true
        },
        "name": {
          "description": "OpenShift cluster name.",
          "type": "string",
          "maxLength": 54,
          "minLength": 1,
          "x-nullable": true
        },
        "network_configuration": {
          "x-nullable": true,
          "$ref": "#/definitions/network_configuration"
        },
        "network_type": {
          "description": "The desired network type used.",
          "type": "string",
          "enum": [
            "OpenShiftSDN",
            "OVNKubernetes"
          ],
          "x-nullable": true
        },
        "no_proxy": {
          "description": "An \"*\" or a comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude from proxying.",
          "type": "string",
          "x-nullable": true
        },
        "olm_operators": {
          "description": "List of OLM operators to be installed.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/operator-create-params"
          }
        },
        "platform": {
          "type": "object",
          "$ref": "#/definitions/platform"
        },
        "pull_secret": {
          "description": "The pull secret obtained from Red Hat OpenShift Cluster Manager at cloud.redhat.com/openshift/install/pull-secret.",
          "type": "string",
          "x-nullable": true
        },
        "schedulable_masters": {
          "description": "Schedule workloads on masters",
          "type": "boolean",
          "default": false
        },
        "service_network_cidr": {
          "description": "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$",
          "x-nullable": true
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging OpenShift nodes.",
          "type": "string",
          "x-nullable": true
        },
        "user_managed_networking": {
          "description": "Indicate if the networking is managed by the user.",
          "type": "boolean",
          "x-nullable": true
        },
        "vip_dhcp_allocation": {
          "description": "Indicate if virtual IP DHCP allocation mode is enabled.",
          "type": "boolean",
          "x-nullable": true
        }
      }
    },
    "cluster-validation-id": {
      "type": "string",
      "enum": [
        "machine-cidr-defined",
        "cluster-cidr-defined",
        "service-cidr-defined",
        "no-cidrs-overlapping",
        "network-prefix-valid",
        "machine-cidr-equals-to-calculated-cidr",
        "api-vip-defined",
        "api-vip-valid",
        "ingress-vip-defined",
        "ingress-vip-valid",
        "all-hosts-are-ready-to-install",
        "sufficient-masters-count",
        "dns-domain-defined",
        "pull-secret-set",
        "ntp-server-configured",
        "lso-requirements-satisfied",
        "ocs-requirements-satisfied",
        "cnv-requirements-satisfied",
        "network-type-valid"
      ]
    },
    "cluster_default_config": {
      "type": "object",
      "properties": {
        "cluster_network_cidr": {
          "type": "string",
          "pattern": "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)[\\/]([1-9]|[1-2][0-9]|3[0-2]?)$"
        },
        "cluster_network_host_prefix": {
          "type": "integer",
          "maximum": 32,
          "minimum": 1
        },
        "inactive_deletion_hours": {
          "type": "integer"
        },
        "ntp_source": {
          "type": "string",
          "x-omitempty": false
        },
        "service_network_cidr": {
          "type": "string",
          "pattern": "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)[\\/]([1-9]|[1-2][0-9]|3[0-2]?)$"
        }
      }
    },
    "cluster_network": {
      "description": "IP address block for pod IP blocks.",
      "type": "object",
      "properties": {
        "cidr": {
          "description": "The IP block address pool.",
          "$ref": "#/definitions/subnet"
        },
        "host_prefix": {
          "description": "The prefix size to allocate to each node from the CIDR. For example, 24 would allocate 2^8=256 adresses to each node.",
          "type": "integer",
          "maximum": 128,
          "minimum": 1
        }
      }
    },
    "completion-params": {
      "type": "object",
      "required": [
        "is_success"
      ],
      "properties": {
        "error_info": {
          "type": "string"
        },
        "is_success": {
          "type": "boolean"
        }
      }
    },
    "connectivity-check-host": {
      "type": "object",
      "properties": {
        "host_id": {
          "type": "string",
          "format": "uuid"
        },
        "nics": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/connectivity-check-nic"
          }
        }
      }
    },
    "connectivity-check-nic": {
      "type": "object",
      "properties": {
        "ip_addresses": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "mac": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "connectivity-check-params": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/connectivity-check-host"
      }
    },
    "connectivity-remote-host": {
      "type": "object",
      "properties": {
        "host_id": {
          "type": "string",
          "format": "uuid"
        },
        "l2_connectivity": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/l2-connectivity"
          }
        },
        "l3_connectivity": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/l3-connectivity"
          }
        }
      }
    },
    "connectivity-report": {
      "type": "object",
      "properties": {
        "remote_hosts": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/connectivity-remote-host"
          }
        }
      }
    },
    "container_image_availability": {
      "type": "object",
      "properties": {
        "download_rate": {
          "description": "The rate of size/time in seconds MBps.",
          "type": "number"
        },
        "name": {
          "description": "A fully qualified image name (FQIN).",
          "type": "string"
        },
        "result": {
          "$ref": "#/definitions/container_image_availability_result"
        },
        "size_bytes": {
          "description": "Size of the image in bytes.",
          "type": "number"
        },
        "time": {
          "description": "Seconds it took to pull the image.",
          "type": "number"
        }
      }
    },
    "container_image_availability_request": {
      "type": "object",
      "required": [
        "images"
      ],
      "properties": {
        "images": {
          "description": "List of image names to be checked.",
          "type": "array",
          "items": {
            "description": "A fully qualified image name (FQIN).",
            "type": "string"
          }
        },
        "timeout": {
          "description": "Positive number represents a timeout in seconds for a pull operation.",
          "type": "integer"
        }
      }
    },
    "container_image_availability_response": {
      "type": "object",
      "required": [
        "images"
      ],
      "properties": {
        "images": {
          "description": "List of images that were checked.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/container_image_availability"
          }
        }
      }
    },
    "container_image_availability_result": {
      "description": "Image availability result.",
      "type": "string",
      "enum": [
        "success",
        "failure"
      ]
    },
    "cpu": {
      "type": "object",
      "properties": {
        "architecture": {
          "type": "string"
        },
        "count": {
          "type": "integer"
        },
        "flags": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "frequency": {
          "type": "number"
        },
        "model_name": {
          "type": "string"
        }
      }
    },
    "create-manifest-params": {
      "type": "object",
      "required": [
        "file_name",
        "content"
      ],
      "properties": {
        "content": {
          "description": "base64 encoded manifest content.",
          "type": "string"
        },
        "file_name": {
          "description": "The name of the manifest to customize the installed OCP cluster.",
          "type": "string",
          "pattern": "^[^/]*\\.(yaml|yml|json)$"
        },
        "folder": {
          "description": "The folder that contains the files. Manifests can be placed in 'manifests' or 'openshift' directories.",
          "type": "string",
          "default": "manifests",
          "enum": [
            "manifests",
            "openshift"
          ]
        }
      }
    },
    "credentials": {
      "type": "object",
      "properties": {
        "console_url": {
          "type": "string"
        },
        "password": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "dhcp_allocation_request": {
      "type": "object",
      "required": [
        "interface",
        "api_vip_mac",
        "ingress_vip_mac"
      ],
      "properties": {
        "api_vip_lease": {
          "description": "Contents of lease file to be used for API virtual IP.",
          "type": "string"
        },
        "api_vip_mac": {
          "description": "MAC address for the API virtual IP.",
          "type": "string",
          "format": "mac"
        },
        "ingress_vip_lease": {
          "description": "Contents of lease file to be used for for Ingress virtual IP.",
          "type": "string"
        },
        "ingress_vip_mac": {
          "description": "MAC address for the Ingress virtual IP.",
          "type": "string",
          "format": "mac"
        },
        "interface": {
          "description": "The network interface (NIC) to run the DHCP requests on.",
          "type": "string"
        }
      }
    },
    "dhcp_allocation_response": {
      "type": "object",
      "required": [
        "api_vip_address",
        "ingress_vip_address"
      ],
      "properties": {
        "api_vip_address": {
          "description": "The IPv4 address that was allocated by DHCP for the API virtual IP.",
          "type": "string",
          "format": "ipv4"
        },
        "api_vip_lease": {
          "description": "Contents of last acquired lease for API virtual IP.",
          "type": "string"
        },
        "ingress_vip_address": {
          "description": "The IPv4 address that was allocated by DHCP for the Ingress virtual IP.",
          "type": "string",
          "format": "ipv4"
        },
        "ingress_vip_lease": {
          "description": "Contents of last acquired lease for Ingress virtual IP.",
          "type": "string"
        }
      }
    },
    "discovery-ignition-params": {
      "properties": {
        "config": {
          "type": "string"
        }
      }
    },
    "disk": {
      "type": "object",
      "properties": {
        "bootable": {
          "type": "boolean"
        },
        "by_id": {
          "description": "by-id is the World Wide Number of the device which guaranteed to be unique for every storage device",
          "type": "string"
        },
        "by_path": {
          "description": "by-path is the shortest physical path to the device",
          "type": "string"
        },
        "drive_type": {
          "type": "string"
        },
        "hctl": {
          "type": "string"
        },
        "id": {
          "description": "Determine the disk's unique identifier which is the by-id field if it exists and fallback to the by-path field otherwise",
          "type": "string"
        },
        "installation_eligibility": {
          "type": "object",
          "properties": {
            "eligible": {
              "description": "Whether the disk is eligible for installation or not.",
              "type": "boolean"
            },
            "not_eligible_reasons": {
              "description": "Reasons for why this disk is not eligible for installation.",
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "x-nullable": false
        },
        "io_perf": {
          "$ref": "#/definitions/io_perf"
        },
        "is_installation_media": {
          "description": "Whether the disk appears to be an installation media or not",
          "type": "boolean"
        },
        "model": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "path": {
          "type": "string"
        },
        "serial": {
          "type": "string"
        },
        "size_bytes": {
          "type": "integer"
        },
        "smart": {
          "type": "string"
        },
        "vendor": {
          "type": "string"
        },
        "wwn": {
          "type": "string"
        }
      }
    },
    "disk-config-params": {
      "type": "object",
      "required": [
        "id"
      ],
      "properties": {
        "id": {
          "type": "string"
        },
        "role": {
          "$ref": "#/definitions/disk-role"
        }
      }
    },
    "disk-role": {
      "type": "string",
      "enum": [
        "none",
        "install"
      ]
    },
    "disk_info": {
      "type": "object",
      "properties": {
        "disk_speed": {
          "$ref": "#/definitions/disk_speed"
        },
        "id": {
          "type": "string",
          "format": "uuid"
        },
        "path": {
          "type": "string"
        }
      }
    },
    "disk_speed": {
      "type": "object",
      "properties": {
        "exit_code": {
          "type": "integer"
        },
        "speed_ms": {
          "type": "integer"
        },
        "tested": {
          "type": "boolean"
        }
      }
    },
    "disk_speed_check_request": {
      "type": "object",
      "required": [
        "path"
      ],
      "properties": {
        "path": {
          "description": "--filename argument for fio (expects a file or a block device path).",
          "type": "string"
        }
      }
    },
    "disk_speed_check_response": {
      "type": "object",
      "properties": {
        "io_sync_duration": {
          "description": "The 99th percentile of fdatasync durations in milliseconds.",
          "type": "integer"
        },
        "path": {
          "description": "The device path.",
          "type": "string"
        }
      }
    },
    "domain_resolution_request": {
      "type": "object",
      "required": [
        "domains"
      ],
      "properties": {
        "domains": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/DomainResolutionRequestDomainsItems0"
          }
        }
      }
    },
    "domain_resolution_response": {
      "type": "object",
      "required": [
        "resolutions"
      ],
      "properties": {
        "resolutions": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/DomainResolutionResponseResolutionsItems0"
          }
        }
      }
    },
    "error": {
      "type": "object",
      "required": [
        "kind",
        "id",
        "href",
        "code",
        "reason"
      ],
      "properties": {
        "code": {
          "description": "Globally unique code of the error, composed of the unique identifier of the API and the numeric identifier of the error. For example, if the numeric identifier of the error is 93 and the identifier of the API is assisted_install then the code will be ASSISTED-INSTALL-93.",
          "type": "string"
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "id": {
          "description": "Numeric identifier of the error.",
          "type": "integer",
          "format": "int32",
          "maximum": 504,
          "minimum": 400
        },
        "kind": {
          "description": "Indicates the type of this object. Will always be 'Error'.",
          "type": "string",
          "enum": [
            "Error"
          ]
        },
        "reason": {
          "description": "Human-readable description of the error.",
          "type": "string"
        }
      }
    },
    "event": {
      "type": "object",
      "required": [
        "cluster_id",
        "severity",
        "message",
        "event_time"
      ],
      "properties": {
        "category": {
          "type": "string",
          "enum": [
            "user",
            "metrics"
          ],
          "x-go-custom-tag": "gorm:\"default:'user'\""
        },
        "cluster_id": {
          "description": "Unique identifier of the cluster this event relates to.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"index\""
        },
        "event_time": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "host_id": {
          "description": "Unique identifier of the host this event relates to.",
          "type": "string",
          "format": "uuid"
        },
        "message": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(4096)\""
        },
        "props": {
          "description": "Additional properties for the event in JSON format.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "request_id": {
          "description": "Unique identifier of the request that caused this event to occur.",
          "type": "string",
          "format": "uuid"
        },
        "severity": {
          "type": "string",
          "enum": [
            "info",
            "warning",
            "error",
            "critical"
          ]
        }
      }
    },
    "event-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/event"
      }
    },
    "free-addresses-list": {
      "type": "array",
      "items": {
        "type": "string",
        "format": "ipv4"
      }
    },
    "free_addresses_request": {
      "type": "array",
      "items": {
        "type": "string",
        "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
      }
    },
    "free_network_addresses": {
      "type": "object",
      "properties": {
        "free_addresses": {
          "type": "array",
          "items": {
            "type": "string",
            "format": "ipv4"
          }
        },
        "network": {
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        }
      }
    },
    "free_networks_addresses": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/free_network_addresses"
      }
    },
    "gpu": {
      "type": "object",
      "properties": {
        "address": {
          "description": "Device address (for example \"0000:00:02.0\")",
          "type": "string"
        },
        "device_id": {
          "description": "ID of the device (for example \"3ea0\")",
          "type": "string"
        },
        "name": {
          "description": "Product name of the device (for example \"UHD Graphics 620 (Whiskey Lake)\")",
          "type": "string"
        },
        "vendor": {
          "description": "The name of the device vendor (for example \"Intel Corporation\")",
          "type": "string"
        },
        "vendor_id": {
          "description": "ID of the vendor (for example \"8086\")",
          "type": "string"
        }
      }
    },
    "host": {
      "type": "object",
      "required": [
        "kind",
        "id",
        "href",
        "status",
        "status_info"
      ],
      "properties": {
        "api_vip_connectivity": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "bootstrap": {
          "type": "boolean"
        },
        "checked_in_at": {
          "description": "The last time the host's agent communicated with the service.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "cluster_id": {
          "description": "The cluster that this host is associated with.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"foreignkey:Cluster\"",
          "x-nullable": true
        },
        "connectivity": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "created_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "deleted_at": {
          "description": "The time that the host was deleted.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\"",
          "x-nullable": true
        },
        "discovery_agent_version": {
          "type": "string"
        },
        "disks_info": {
          "description": "Additional information about disks, formatted as JSON.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "domain_name_resolutions": {
          "description": "The domain name resolution result.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "free_addresses": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "id": {
          "description": "Unique identifier of the object.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key\""
        },
        "ignition_config_overrides": {
          "description": "Json formatted string containing the user overrides for the host's pointer ignition",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\"",
          "example": "{\"ignition\": {\"version\": \"3.1.0\"}, \"storage\": {\"files\": [{\"path\": \"/tmp/example\", \"contents\": {\"source\": \"data:text/plain;base64,aGVscGltdHJhcHBlZGluYXN3YWdnZXJzcGVj\"}}]}}"
        },
        "images_status": {
          "description": "Array of image statuses.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "infra_env_id": {
          "description": "The InfraEnv that this host is associated with.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key;foreignkey:InfraEnvID\""
        },
        "installation_disk_id": {
          "description": "Contains the inventory disk id to install on.",
          "type": "string"
        },
        "installation_disk_path": {
          "description": "Contains the inventory disk path, This field is replaced by installation_disk_id field and used for backward compatability with the old UI.",
          "type": "string",
          "example": "/dev/sda"
        },
        "installer_args": {
          "type": "string"
        },
        "installer_version": {
          "description": "Installer version.",
          "type": "string"
        },
        "inventory": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "kind": {
          "description": "Indicates the type of this object. Will be 'Host' if this is a complete object or 'HostLink' if it is just a link, or\n'AddToExistingClusterHost' for host being added to existing OCP cluster, or\n",
          "type": "string",
          "enum": [
            "Host",
            "AddToExistingClusterHost"
          ]
        },
        "logs_collected_at": {
          "type": "string",
          "format": "datetime",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "logs_info": {
          "description": "The progress of log collection or empty if logs are not applicable",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\"",
          "$ref": "#/definitions/logs_state"
        },
        "logs_started_at": {
          "type": "string",
          "format": "datetime",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "machine_config_pool_name": {
          "type": "string"
        },
        "ntp_sources": {
          "description": "The configured NTP sources on the host.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "progress": {
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:progress_\"",
          "$ref": "#/definitions/host-progress-info"
        },
        "progress_stages": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/host-stage"
          },
          "x-go-custom-tag": "gorm:\"-\""
        },
        "requested_hostname": {
          "type": "string"
        },
        "role": {
          "$ref": "#/definitions/host-role"
        },
        "stage_started_at": {
          "description": "Time at which the current progress stage started.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "stage_updated_at": {
          "description": "Time at which the current progress stage was last updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "status": {
          "type": "string",
          "enum": [
            "discovering",
            "known",
            "disconnected",
            "insufficient",
            "disabled",
            "preparing-for-installation",
            "preparing-successful",
            "pending-for-input",
            "installing",
            "installing-in-progress",
            "installing-pending-user-action",
            "resetting-pending-user-action",
            "installed",
            "error",
            "resetting",
            "added-to-existing-cluster",
            "cancelled",
            "binding",
            "known-unbound",
            "disconnected-unbound",
            "insufficient-unbound",
            "disabled-unbound",
            "discovering-unbound"
          ]
        },
        "status_info": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "status_updated_at": {
          "description": "The last time that the host status was updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "updated_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "user_name": {
          "type": "string"
        },
        "validations_info": {
          "description": "JSON-formatted string containing the validation results for each validation id grouped by category (network, hardware, etc.)",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        }
      }
    },
    "host-create-params": {
      "type": "object",
      "required": [
        "host_id"
      ],
      "properties": {
        "discovery_agent_version": {
          "type": "string"
        },
        "host_id": {
          "type": "string",
          "format": "uuid"
        }
      }
    },
    "host-ignition-params": {
      "properties": {
        "config": {
          "type": "string"
        }
      }
    },
    "host-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/host"
      }
    },
    "host-progress": {
      "type": "object",
      "required": [
        "current_stage"
      ],
      "properties": {
        "current_stage": {
          "type": "string",
          "$ref": "#/definitions/host-stage"
        },
        "progress_info": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        }
      }
    },
    "host-progress-info": {
      "type": "object",
      "required": [
        "current_stage"
      ],
      "properties": {
        "current_stage": {
          "type": "string",
          "$ref": "#/definitions/host-stage"
        },
        "installation_percentage": {
          "type": "integer"
        },
        "progress_info": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "stage_started_at": {
          "description": "Time at which the current progress stage started.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "stage_updated_at": {
          "description": "Time at which the current progress stage was last updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        }
      }
    },
    "host-role": {
      "type": "string",
      "enum": [
        "auto-assign",
        "master",
        "worker",
        "bootstrap"
      ]
    },
    "host-role-update-params": {
      "type": "string",
      "enum": [
        "auto-assign",
        "master",
        "worker"
      ]
    },
    "host-stage": {
      "type": "string",
      "enum": [
        "Starting installation",
        "Waiting for control plane",
        "Waiting for bootkube",
        "Waiting for controller",
        "Installing",
        "Writing image to disk",
        "Rebooting",
        "Waiting for ignition",
        "Configuring",
        "Joined",
        "Done",
        "Failed"
      ]
    },
    "host-type-hardware-requirements": {
      "type": "object",
      "properties": {
        "qualitative": {
          "description": "Host requirements that cannot be quantified at the time of calculation. Descriptions or formulas of requiements",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "quantitative": {
          "description": "Host requirements that can be quantified",
          "$ref": "#/definitions/cluster-host-requirements-details"
        }
      }
    },
    "host-type-hardware-requirements-wrapper": {
      "type": "object",
      "properties": {
        "master": {
          "description": "Requirements towards a master node",
          "$ref": "#/definitions/host-type-hardware-requirements"
        },
        "worker": {
          "description": "Requirements towards a worker node",
          "$ref": "#/definitions/host-type-hardware-requirements"
        }
      }
    },
    "host-validation-id": {
      "type": "string",
      "enum": [
        "connected",
        "has-inventory",
        "has-min-cpu-cores",
        "has-min-valid-disks",
        "has-min-memory",
        "machine-cidr-defined",
        "has-cpu-cores-for-role",
        "has-memory-for-role",
        "hostname-unique",
        "hostname-valid",
        "belongs-to-machine-cidr",
        "api-vip-connected",
        "belongs-to-majority-group",
        "valid-platform",
        "ntp-synced",
        "container-images-available",
        "lso-requirements-satisfied",
        "ocs-requirements-satisfied",
        "sufficient-installation-disk-speed",
        "cnv-requirements-satisfied",
        "sufficient-network-latency-requirement-for-role",
        "sufficient-packet-loss-requirement-for-role",
        "has-default-route",
        "api-domain-name-resolved-correctly",
        "api-int-domain-name-resolved-correctly",
        "apps-domain-name-resolved-correctly",
        "compatible-with-cluster-platform"
      ]
    },
    "host_network": {
      "type": "object",
      "properties": {
        "cidr": {
          "type": "string"
        },
        "host_ids": {
          "type": "array",
          "items": {
            "type": "string",
            "format": "uuid"
          }
        }
      }
    },
    "host_registration_response": {
      "allOf": [
        {
          "$ref": "#/definitions/host"
        },
        {
          "properties": {
            "next_step_runner_command": {
              "description": "Command for starting the next step runner",
              "type": "object",
              "properties": {
                "args": {
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                },
                "command": {
                  "type": "string"
                },
                "retry_seconds": {
                  "description": "How long in seconds to wait before retrying registration if the command fails",
                  "type": "integer"
                }
              }
            }
          }
        }
      ]
    },
    "host_static_network_config": {
      "type": "object",
      "properties": {
        "mac_interface_map": {
          "description": "mapping of host macs to logical interfaces used in the network yaml",
          "$ref": "#/definitions/mac_interface_map"
        },
        "network_yaml": {
          "description": "yaml string that can be processed by nmstate",
          "type": "string"
        }
      }
    },
    "image-create-params": {
      "type": "object",
      "properties": {
        "image_type": {
          "description": "Type of image that should be generated.",
          "$ref": "#/definitions/image_type"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string"
        },
        "static_network_config": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/host_static_network_config"
          }
        }
      }
    },
    "image_info": {
      "type": "object",
      "properties": {
        "created_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "download_url": {
          "type": "string"
        },
        "expires_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "generator_version": {
          "description": "Image generator version.",
          "type": "string"
        },
        "size_bytes": {
          "type": "integer",
          "minimum": 0
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string"
        },
        "static_network_config": {
          "description": "static network configuration string in the format expected by discovery ignition generation",
          "type": "string"
        },
        "type": {
          "$ref": "#/definitions/image_type"
        }
      }
    },
    "image_type": {
      "type": "string",
      "enum": [
        "full-iso",
        "minimal-iso"
      ]
    },
    "infra-env": {
      "type": "object",
      "properties": {
        "additional_ntp_sources": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string"
        },
        "cluster_id": {
          "description": "If set, all hosts that register will be associated with the specified cluster.",
          "type": "string",
          "format": "uuid"
        },
        "created_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "download_url": {
          "type": "string"
        },
        "expires_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "generator_version": {
          "description": "Image generator version.",
          "type": "string"
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "id": {
          "description": "Unique identifier of the object.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key\""
        },
        "ignition_config_override": {
          "description": "Json formatted string containing the user overrides for the initial ignition config.",
          "type": "string"
        },
        "kind": {
          "description": "Indicates the type of this object.",
          "type": "string",
          "enum": [
            "InfraEnv"
          ]
        },
        "name": {
          "description": "Name of the InfraEnv.",
          "type": "string"
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster (used to infer the RHCOS version - temporary until generic logic implemented).",
          "type": "string"
        },
        "proxy": {
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:proxy_\"",
          "$ref": "#/definitions/proxy"
        },
        "pull_secret_set": {
          "description": "True if the pull secret has been added to the cluster.",
          "type": "boolean"
        },
        "size_bytes": {
          "type": "integer",
          "minimum": 0
        },
        "ssh_authorized_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string"
        },
        "static_network_config": {
          "description": "static network configuration string in the format expected by discovery ignition generation.",
          "type": "string"
        },
        "type": {
          "$ref": "#/definitions/image_type"
        },
        "updated_at": {
          "description": "The last time that this infraenv was updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        }
      }
    },
    "infra-env-create-params": {
      "type": "object",
      "required": [
        "name",
        "openshift_version",
        "pull_secret"
      ],
      "properties": {
        "additional_ntp_sources": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string",
          "x-nullable": true
        },
        "cluster_id": {
          "description": "If set, all hosts that register will be associated with the specified cluster.",
          "type": "string",
          "format": "uuid",
          "x-nullable": true
        },
        "ignition_config_override": {
          "description": "JSON formatted string containing the user overrides for the initial ignition config.",
          "type": "string"
        },
        "image_type": {
          "$ref": "#/definitions/image_type"
        },
        "name": {
          "description": "Name of the InfraEnv.",
          "type": "string"
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster (used to infer the RHCOS version - temporary until generic logic implemented).",
          "type": "string"
        },
        "proxy": {
          "$ref": "#/definitions/proxy"
        },
        "pull_secret": {
          "description": "The pull secret obtained from Red Hat OpenShift Cluster Manager at cloud.redhat.com/openshift/install/pull-secret.",
          "type": "string"
        },
        "ssh_authorized_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string",
          "x-nullable": true
        },
        "static_network_config": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/host_static_network_config"
          }
        }
      }
    },
    "infra-env-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/infra-env"
      }
    },
    "infra-env-update-params": {
      "type": "object",
      "properties": {
        "additional_ntp_sources": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string",
          "x-nullable": true
        },
        "cluster_id": {
          "description": "If set, all hosts that register will be associated with the specified cluster.",
          "type": "string",
          "format": "uuid",
          "x-nullable": true
        },
        "ignition_config_override": {
          "description": "JSON formatted string containing the user overrides for the initial ignition config.",
          "type": "string"
        },
        "image_type": {
          "$ref": "#/definitions/image_type"
        },
        "proxy": {
          "$ref": "#/definitions/proxy"
        },
        "pull_secret": {
          "description": "The pull secret obtained from Red Hat OpenShift Cluster Manager at cloud.redhat.com/openshift/install/pull-secret.",
          "type": "string"
        },
        "ssh_authorized_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string",
          "x-nullable": true
        },
        "static_network_config": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/host_static_network_config"
          }
        }
      }
    },
    "infra_error": {
      "type": "object",
      "required": [
        "code",
        "message"
      ],
      "properties": {
        "code": {
          "description": "Numeric identifier of the error.",
          "type": "integer",
          "format": "int32",
          "maximum": 403,
          "minimum": 401
        },
        "message": {
          "description": "Human-readable description of the error.",
          "type": "string"
        }
      }
    },
    "ingress-cert-params": {
      "type": "string"
    },
    "installer-args-params": {
      "type": "object",
      "properties": {
        "args": {
          "description": "List of additional arguments passed to coreos-installer",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "--append-karg",
            "ip=192.0.2.2::192.0.2.254:255.255.255.0:core0.example.com:enp1s0:none",
            "--save-partindex",
            "1",
            "-n"
          ]
        }
      }
    },
    "interface": {
      "type": "object",
      "properties": {
        "biosdevname": {
          "type": "string"
        },
        "client_id": {
          "type": "string"
        },
        "flags": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "has_carrier": {
          "type": "boolean"
        },
        "ipv4_addresses": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "ipv6_addresses": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "mac_address": {
          "type": "string"
        },
        "mtu": {
          "type": "integer"
        },
        "name": {
          "type": "string"
        },
        "product": {
          "type": "string"
        },
        "speed_mbps": {
          "type": "integer"
        },
        "vendor": {
          "type": "string"
        }
      }
    },
    "inventory": {
      "type": "object",
      "properties": {
        "bmc_address": {
          "type": "string"
        },
        "bmc_v6address": {
          "type": "string"
        },
        "boot": {
          "$ref": "#/definitions/boot"
        },
        "cpu": {
          "$ref": "#/definitions/cpu"
        },
        "disks": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/disk"
          }
        },
        "gpus": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/gpu"
          }
        },
        "hostname": {
          "type": "string"
        },
        "interfaces": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/interface"
          }
        },
        "memory": {
          "$ref": "#/definitions/memory"
        },
        "routes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/route"
          }
        },
        "system_vendor": {
          "$ref": "#/definitions/system_vendor"
        },
        "timestamp": {
          "type": "integer"
        }
      }
    },
    "io_perf": {
      "type": "object",
      "properties": {
        "sync_duration": {
          "description": "99th percentile of fsync duration in milliseconds",
          "type": "integer"
        }
      }
    },
    "l2-connectivity": {
      "type": "object",
      "properties": {
        "outgoing_ip_address": {
          "type": "string"
        },
        "outgoing_nic": {
          "type": "string"
        },
        "remote_ip_address": {
          "type": "string"
        },
        "remote_mac": {
          "type": "string"
        },
        "successful": {
          "type": "boolean"
        }
      }
    },
    "l3-connectivity": {
      "type": "object",
      "properties": {
        "average_rtt_ms": {
          "description": "Average round trip time in milliseconds.",
          "type": "number",
          "format": "double",
          "x-go-name": "AverageRTTMs"
        },
        "outgoing_nic": {
          "type": "string"
        },
        "packet_loss_percentage": {
          "description": "Percentage of packets lost during connectivity check.",
          "type": "number",
          "format": "double"
        },
        "remote_ip_address": {
          "type": "string"
        },
        "successful": {
          "type": "boolean"
        }
      }
    },
    "list-managed-domains": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/managed-domain"
      }
    },
    "list-manifests": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/manifest"
      }
    },
    "list-versions": {
      "type": "object",
      "properties": {
        "release_tag": {
          "type": "string"
        },
        "versions": {
          "$ref": "#/definitions/versions"
        }
      }
    },
    "logs-progress-params": {
      "type": "object",
      "required": [
        "logs_state"
      ],
      "properties": {
        "logs_state": {
          "description": "The state of collecting logs.",
          "$ref": "#/definitions/logs_state"
        }
      }
    },
    "logs_state": {
      "type": "string",
      "enum": [
        "requested",
        "collecting",
        "completed",
        "timeout",
        ""
      ]
    },
    "logs_type": {
      "type": "string",
      "enum": [
        "host",
        "controller",
        "all",
        ""
      ]
    },
    "mac_interface_map": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/MacInterfaceMapItems0"
      }
    },
    "machine_network": {
      "description": "IP address block for node IP blocks.",
      "type": "object",
      "properties": {
        "cidr": {
          "description": "The IP block address pool for machines within the cluster.",
          "$ref": "#/definitions/subnet"
        }
      }
    },
    "managed-domain": {
      "type": "object",
      "properties": {
        "domain": {
          "type": "string"
        },
        "provider": {
          "type": "string",
          "enum": [
            "route53"
          ]
        }
      }
    },
    "manifest": {
      "type": "object",
      "properties": {
        "file_name": {
          "description": "The file name prefaced by the folder that contains it.",
          "type": "string"
        },
        "folder": {
          "description": "The folder that contains the files. Manifests can be placed in 'manifests' or 'openshift' directories.",
          "type": "string",
          "enum": [
            "manifests",
            "openshift"
          ]
        }
      }
    },
    "memory": {
      "type": "object",
      "properties": {
        "physical_bytes": {
          "type": "integer"
        },
        "usable_bytes": {
          "type": "integer"
        }
      }
    },
    "monitored-operator": {
      "type": "object",
      "properties": {
        "cluster_id": {
          "description": "The cluster that this operator is associated with.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key;foreignkey:Cluster\""
        },
        "name": {
          "description": "Unique name of the operator.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"primary_key\""
        },
        "namespace": {
          "description": "Namespace where to deploy an operator. Only some operators require a namespace.",
          "type": "string"
        },
        "operator_type": {
          "$ref": "#/definitions/operator-type"
        },
        "properties": {
          "description": "Blob of operator-dependent parameters that are required for installation.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "status": {
          "$ref": "#/definitions/operator-status"
        },
        "status_info": {
          "description": "Detailed information about the operator state.",
          "type": "string"
        },
        "status_updated_at": {
          "description": "Time at which the operator was last updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "subscription_name": {
          "description": "The name of the subscription of the operator.",
          "type": "string"
        },
        "timeout_seconds": {
          "description": "Positive number represents a timeout in seconds for the operator to be available.",
          "type": "integer"
        }
      }
    },
    "monitored-operators-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/monitored-operator"
      }
    },
    "network_configuration": {
      "type": "object",
      "properties": {
        "cluster_network": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/cluster_network"
          }
        },
        "machine_network": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/machine_network"
          }
        },
        "service_network": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/service_network"
          }
        }
      }
    },
    "ntp_source": {
      "type": "object",
      "properties": {
        "source_name": {
          "description": "NTP source name or IP.",
          "type": "string"
        },
        "source_state": {
          "description": "Indication of state of an NTP source.",
          "$ref": "#/definitions/source_state"
        }
      }
    },
    "ntp_synchronization_request": {
      "type": "object",
      "required": [
        "ntp_source"
      ],
      "properties": {
        "ntp_source": {
          "description": "A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.",
          "type": "string"
        }
      }
    },
    "ntp_synchronization_response": {
      "properties": {
        "ntp_sources": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/ntp_source"
          }
        }
      }
    },
    "openshift-version": {
      "type": "object",
      "required": [
        "display_name",
        "release_image",
        "release_version",
        "rhcos_image",
        "rhcos_rootfs",
        "rhcos_version",
        "support_level"
      ],
      "properties": {
        "default": {
          "description": "Indication that the version is the recommended one.",
          "type": "boolean"
        },
        "display_name": {
          "description": "Name of the version to be presented to the user.",
          "type": "string"
        },
        "release_image": {
          "description": "The installation image of the OpenShift cluster.",
          "type": "string"
        },
        "release_version": {
          "description": "OCP version from the release metadata.",
          "type": "string"
        },
        "rhcos_image": {
          "description": "The base RHCOS image used for the discovery iso.",
          "type": "string"
        },
        "rhcos_rootfs": {
          "description": "The RHCOS rootfs url.",
          "type": "string"
        },
        "rhcos_version": {
          "description": "Build ID of the RHCOS image.",
          "type": "string"
        },
        "support_level": {
          "description": "Level of support of the version.",
          "type": "string",
          "enum": [
            "beta",
            "production",
            "custom"
          ]
        }
      }
    },
    "openshift-versions": {
      "type": "object",
      "additionalProperties": {
        "$ref": "#/definitions/openshift-version"
      }
    },
    "operator-create-params": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "properties": {
          "description": "Blob of operator-dependent parameters that are required for installation.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        }
      }
    },
    "operator-hardware-requirements": {
      "type": "object",
      "properties": {
        "dependencies": {
          "description": "List of other operator unique names that are required to be installed. Corresponds to name property of the monitored-operator, i.e. \"lso\", \"cnv\", etc.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "operator_name": {
          "description": "Unique name of the operator. Corresponds to name property of the monitored-operator, i.e. \"lso\", \"cnv\", etc.",
          "type": "string"
        },
        "requirements": {
          "$ref": "#/definitions/host-type-hardware-requirements-wrapper"
        }
      }
    },
    "operator-host-requirements": {
      "type": "object",
      "properties": {
        "operator_name": {
          "description": "Name of the operator",
          "type": "string"
        },
        "requirements": {
          "description": "Host requirements for the operator",
          "$ref": "#/definitions/cluster-host-requirements-details"
        }
      }
    },
    "operator-monitor-report": {
      "type": "object",
      "properties": {
        "name": {
          "description": "Unique name of the operator.",
          "type": "string"
        },
        "status": {
          "$ref": "#/definitions/operator-status"
        },
        "status_info": {
          "description": "Detailed information about the operator state.",
          "type": "string"
        }
      }
    },
    "operator-properties": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/operator-property"
      }
    },
    "operator-property": {
      "type": "object",
      "properties": {
        "data_type": {
          "description": "Type of the property",
          "type": "string",
          "enum": [
            "boolean",
            "string",
            "integer",
            "float"
          ]
        },
        "default_value": {
          "description": "Default value for the property",
          "type": "string"
        },
        "description": {
          "description": "Description of a property",
          "type": "string"
        },
        "mandatory": {
          "description": "Indicates whether the property is reqired",
          "type": "boolean"
        },
        "name": {
          "description": "Name of the property",
          "type": "string"
        },
        "options": {
          "description": "Values to select from",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "operator-status": {
      "description": "Represents the operator state.",
      "type": "string",
      "enum": [
        "failed",
        "progressing",
        "available"
      ]
    },
    "operator-type": {
      "description": "Kind of operator. Different types are monitored by the service differently.",
      "type": "string",
      "enum": [
        "builtin",
        "olm"
      ]
    },
    "platform": {
      "description": "The configuration for the specific platform upon which to perform the installation.",
      "type": "object",
      "required": [
        "type"
      ],
      "properties": {
        "type": {
          "$ref": "#/definitions/platform_type"
        },
        "vsphere": {
          "type": "object",
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:vsphere_\"",
          "x-nullable": true,
          "$ref": "#/definitions/vsphere_platform"
        }
      }
    },
    "platform_type": {
      "type": "string",
      "enum": [
        "baremetal",
        "vsphere"
      ]
    },
    "preflight-hardware-requirements": {
      "type": "object",
      "properties": {
        "ocp": {
          "description": "Preflight OCP requirements",
          "$ref": "#/definitions/host-type-hardware-requirements-wrapper"
        },
        "operators": {
          "description": "Preflight operators hardware requirements",
          "type": "array",
          "items": {
            "$ref": "#/definitions/operator-hardware-requirements"
          }
        }
      }
    },
    "presigned": {
      "type": "object",
      "required": [
        "url"
      ],
      "properties": {
        "url": {
          "type": "string"
        }
      }
    },
    "proxy": {
      "type": "object",
      "properties": {
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "no_proxy": {
          "description": "An \"*\" or a comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude from proxying.",
          "type": "string",
          "x-nullable": true
        }
      }
    },
    "route": {
      "type": "object",
      "properties": {
        "destination": {
          "description": "The destination network or destination host",
          "type": "string"
        },
        "family": {
          "description": "Defines whether this is an IPv4 (4) or IPv6 route (6)",
          "type": "integer",
          "format": "int32"
        },
        "gateway": {
          "description": "Gateway address where the packets are sent",
          "type": "string"
        },
        "interface": {
          "description": "Interface to which packets for this route will be sent",
          "type": "string"
        }
      }
    },
    "service_network": {
      "description": "List of IP address pools for services.",
      "type": "object",
      "properties": {
        "cidr": {
          "description": "The IP block address pool.",
          "$ref": "#/definitions/subnet"
        }
      }
    },
    "source_state": {
      "type": "string",
      "enum": [
        "synced",
        "combined",
        "not_combined",
        "error",
        "variable",
        "unreachable"
      ]
    },
    "step": {
      "type": "object",
      "properties": {
        "args": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "command": {
          "type": "string"
        },
        "step_id": {
          "type": "string"
        },
        "step_type": {
          "$ref": "#/definitions/step-type"
        }
      }
    },
    "step-reply": {
      "type": "object",
      "properties": {
        "error": {
          "type": "string"
        },
        "exit_code": {
          "type": "integer"
        },
        "output": {
          "type": "string"
        },
        "step_id": {
          "type": "string"
        },
        "step_type": {
          "$ref": "#/definitions/step-type"
        }
      }
    },
    "step-type": {
      "type": "string",
      "enum": [
        "connectivity-check",
        "execute",
        "inventory",
        "install",
        "free-network-addresses",
        "reset-installation",
        "dhcp-lease-allocate",
        "api-vip-connectivity-check",
        "ntp-synchronizer",
        "installation-disk-speed-check",
        "container-image-availability",
        "domain-resolution"
      ]
    },
    "steps": {
      "type": "object",
      "properties": {
        "instructions": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/step"
          }
        },
        "next_instruction_seconds": {
          "type": "integer"
        },
        "post_step_action": {
          "description": "What to do after finishing to run step instructions",
          "type": "string",
          "default": "continue",
          "enum": [
            "exit",
            "continue"
          ]
        }
      }
    },
    "steps-reply": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/step-reply"
      }
    },
    "subnet": {
      "type": "string",
      "pattern": "^(?:(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\/(?:(?:[0-9])|(?:[1-2][0-9])|(?:3[0-2])))|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,})/(?:(?:[0-9])|(?:[1-9][0-9])|(?:1[0-1][0-9])|(?:12[0-8])))$"
    },
    "system_vendor": {
      "type": "object",
      "properties": {
        "manufacturer": {
          "type": "string"
        },
        "product_name": {
          "type": "string"
        },
        "serial_number": {
          "type": "string"
        },
        "virtual": {
          "description": "Whether the machine appears to be a virtual machine or not",
          "type": "boolean"
        }
      }
    },
    "usage": {
      "type": "object",
      "properties": {
        "data": {
          "description": "additional properties of the feature",
          "type": "object",
          "additionalProperties": {
            "type": "object"
          }
        },
        "name": {
          "description": "name of the feature to track",
          "type": "string"
        }
      }
    },
    "versioned-host-requirements": {
      "type": "object",
      "properties": {
        "master": {
          "description": "Master node requirements",
          "x-go-name": "MasterRequirements",
          "$ref": "#/definitions/cluster-host-requirements-details"
        },
        "sno": {
          "description": "Single node OpenShift node requirements",
          "x-go-name": "SNORequirements",
          "$ref": "#/definitions/cluster-host-requirements-details"
        },
        "version": {
          "description": "Version of the component for which requirements are defined",
          "type": "string"
        },
        "worker": {
          "description": "Worker node requirements",
          "x-go-name": "WorkerRequirements",
          "$ref": "#/definitions/cluster-host-requirements-details"
        }
      }
    },
    "versions": {
      "type": "object",
      "additionalProperties": {
        "type": "string"
      }
    },
    "vsphere_platform": {
      "description": "Vsphere platform specific configuration upon which to perform the installation",
      "type": "object",
      "properties": {
        "cluster": {
          "description": "The vCenter cluster to install the OpenShift Container Platform cluster in.",
          "type": "string",
          "x-nullable": true
        },
        "datacenter": {
          "description": "The name of the datacenter to use in the vCenter instance.",
          "type": "string",
          "x-nullable": true
        },
        "defaultDatastore": {
          "description": "The name of the default datastore to use for provisioning volumes.",
          "type": "string",
          "x-nullable": true
        },
        "folder": {
          "description": "Optional. The absolute path of an existing folder where the installation program creates the virtual machines. If you do not provide this value, the installation program creates a folder that is named with the infrastructure ID in the datacenter virtual machine folder.",
          "type": "string",
          "x-nullable": true
        },
        "network": {
          "description": "The network in the vCenter instance that contains the virtual IP addresses and DNS records that you configured.",
          "type": "string",
          "x-nullable": true
        },
        "password": {
          "description": "The password for the vCenter user name.",
          "type": "string",
          "format": "password",
          "x-nullable": true
        },
        "username": {
          "description": "The user name to use to connect to the vCenter instance with. This user must have at least the roles and privileges that are required for static or dynamic persistent volume provisioning in vSphere.",
          "type": "string",
          "x-nullable": true
        },
        "vCenter": {
          "description": "The fully-qualified hostname or IP address of the vCenter server.",
          "type": "string",
          "x-nullable": true
        }
      }
    }
  },
  "securityDefinitions": {
    "agentAuth": {
      "type": "apiKey",
      "name": "X-Secret-Key",
      "in": "header"
    },
    "urlAuth": {
      "type": "apiKey",
      "name": "api_key",
      "in": "query"
    },
    "userAuth": {
      "type": "apiKey",
      "name": "Authorization",
      "in": "header"
    }
  },
  "security": [
    {
      "userAuth": [
        "admin",
        "user"
      ]
    }
  ],
  "tags": [
    {
      "description": "Agent-driven installation",
      "name": "Assisted installation"
    },
    {
      "description": "ISO that contains the Assisted Service.",
      "name": "assisted-service-iso"
    },
    {
      "description": "Events related to a cluster installation.",
      "name": "events"
    },
    {
      "description": "General OpenShift cluster installation APIs.",
      "name": "installer"
    },
    {
      "description": "Managed dns domains for a cluster installation.",
      "name": "managed_domains"
    },
    {
      "description": "Manifests for customizing a cluster installation.",
      "name": "manifests"
    },
    {
      "description": "Information regarding supported operators.",
      "name": "operators"
    },
    {
      "description": "Information regarding versions.",
      "name": "versions"
    }
  ]
}`))
}
