// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"io"
	"mime/multipart"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// NewUploadLogsParams creates a new UploadLogsParams object
// no default values defined in spec.
func NewUploadLogsParams() UploadLogsParams {

	return UploadLogsParams{}
}

// UploadLogsParams contains all the bound params for the upload logs operation
// typically these are obtained from a http.Request
//
// swagger:parameters UploadLogs
type UploadLogsParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*
	  Required: true
	  In: path
	*/
	ClusterID strfmt.UUID
	/*
	  In: query
	*/
	HostID *strfmt.UUID
	/*
	  Required: true
	  In: query
	*/
	LogsType string
	/*The file to upload.
	  Max Length: 104857600
	  In: formData
	*/
	Upfile io.ReadCloser
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewUploadLogsParams() beforehand.
func (o *UploadLogsParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	if err := r.ParseMultipartForm(32 << 20); err != nil {
		if err != http.ErrNotMultipart {
			return errors.New(400, "%v", err)
		} else if err := r.ParseForm(); err != nil {
			return errors.New(400, "%v", err)
		}
	}

	rClusterID, rhkClusterID, _ := route.Params.GetOK("cluster_id")
	if err := o.bindClusterID(rClusterID, rhkClusterID, route.Formats); err != nil {
		res = append(res, err)
	}

	qHostID, qhkHostID, _ := qs.GetOK("host_id")
	if err := o.bindHostID(qHostID, qhkHostID, route.Formats); err != nil {
		res = append(res, err)
	}

	qLogsType, qhkLogsType, _ := qs.GetOK("logs_type")
	if err := o.bindLogsType(qLogsType, qhkLogsType, route.Formats); err != nil {
		res = append(res, err)
	}

	upfile, upfileHeader, err := r.FormFile("upfile")
	if err != nil && err != http.ErrMissingFile {
		res = append(res, errors.New(400, "reading file %q failed: %v", "upfile", err))
	} else if err == http.ErrMissingFile {
		// no-op for missing but optional file parameter
	} else if err := o.bindUpfile(upfile, upfileHeader); err != nil {
		res = append(res, err)
	} else {
		o.Upfile = &runtime.File{Data: upfile, Header: upfileHeader}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindClusterID binds and validates parameter ClusterID from path.
func (o *UploadLogsParams) bindClusterID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route

	// Format: uuid
	value, err := formats.Parse("uuid", raw)
	if err != nil {
		return errors.InvalidType("cluster_id", "path", "strfmt.UUID", raw)
	}
	o.ClusterID = *(value.(*strfmt.UUID))

	if err := o.validateClusterID(formats); err != nil {
		return err
	}

	return nil
}

// validateClusterID carries on validations for parameter ClusterID
func (o *UploadLogsParams) validateClusterID(formats strfmt.Registry) error {

	if err := validate.FormatOf("cluster_id", "path", "uuid", o.ClusterID.String(), formats); err != nil {
		return err
	}
	return nil
}

// bindHostID binds and validates parameter HostID from query.
func (o *UploadLogsParams) bindHostID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false
	if raw == "" { // empty values pass all other validations
		return nil
	}

	// Format: uuid
	value, err := formats.Parse("uuid", raw)
	if err != nil {
		return errors.InvalidType("host_id", "query", "strfmt.UUID", raw)
	}
	o.HostID = (value.(*strfmt.UUID))

	if err := o.validateHostID(formats); err != nil {
		return err
	}

	return nil
}

// validateHostID carries on validations for parameter HostID
func (o *UploadLogsParams) validateHostID(formats strfmt.Registry) error {

	if err := validate.FormatOf("host_id", "query", "uuid", o.HostID.String(), formats); err != nil {
		return err
	}
	return nil
}

// bindLogsType binds and validates parameter LogsType from query.
func (o *UploadLogsParams) bindLogsType(rawData []string, hasKey bool, formats strfmt.Registry) error {
	if !hasKey {
		return errors.Required("logs_type", "query", rawData)
	}
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// AllowEmptyValue: false
	if err := validate.RequiredString("logs_type", "query", raw); err != nil {
		return err
	}

	o.LogsType = raw

	if err := o.validateLogsType(formats); err != nil {
		return err
	}

	return nil
}

// validateLogsType carries on validations for parameter LogsType
func (o *UploadLogsParams) validateLogsType(formats strfmt.Registry) error {

	if err := validate.EnumCase("logs_type", "query", o.LogsType, []interface{}{"host", "controller"}, true); err != nil {
		return err
	}

	return nil
}

// bindUpfile binds file parameter Upfile.
//
// The only supported validations on files are MinLength and MaxLength
func (o *UploadLogsParams) bindUpfile(file multipart.File, header *multipart.FileHeader) error {
	size, _ := file.Seek(0, io.SeekEnd)
	file.Seek(0, io.SeekStart)
	if size > 104857600 {
		return errors.ExceedsMaximum("upfile", "formData", 104857600, false, size)
	}
	return nil
}
