/*
Copyright (c) 2020 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// IMPORTANT: This file has been generated automatically, refrain from modifying it manually as all
// your changes will be lost when the file is generated again.

package v1 // github.com/openshift-online/ocm-sdk-go/clustersmgmt/v1

import (
	"bytes"
	"context"
	"io"
	"io/ioutil"
	"net/http"
	"net/url"
	"time"

	jsoniter "github.com/json-iterator/go"
	"github.com/openshift-online/ocm-sdk-go/errors"
	"github.com/openshift-online/ocm-sdk-go/helpers"
)

// SyncsetClient is the client of the 'syncset' resource.
//
// Manages a specific syncset.
type SyncsetClient struct {
	transport http.RoundTripper
	path      string
	metric    string
}

// NewSyncsetClient creates a new client for the 'syncset'
// resource using the given transport to send the requests and receive the
// responses.
func NewSyncsetClient(transport http.RoundTripper, path string, metric string) *SyncsetClient {
	return &SyncsetClient{
		transport: transport,
		path:      path,
		metric:    metric,
	}
}

// Delete creates a request for the 'delete' method.
//
// Deletes the syncset.
func (c *SyncsetClient) Delete() *SyncsetDeleteRequest {
	return &SyncsetDeleteRequest{
		transport: c.transport,
		path:      c.path,
		metric:    c.metric,
	}
}

// Get creates a request for the 'get' method.
//
// Retrieves the details of the syncset.
func (c *SyncsetClient) Get() *SyncsetGetRequest {
	return &SyncsetGetRequest{
		transport: c.transport,
		path:      c.path,
		metric:    c.metric,
	}
}

// Update creates a request for the 'update' method.
//
// Update the syncset.
func (c *SyncsetClient) Update() *SyncsetUpdateRequest {
	return &SyncsetUpdateRequest{
		transport: c.transport,
		path:      c.path,
		metric:    c.metric,
	}
}

// SyncsetPollRequest is the request for the Poll method.
type SyncsetPollRequest struct {
	request    *SyncsetGetRequest
	interval   time.Duration
	statuses   []int
	predicates []func(interface{}) bool
}

// Parameter adds a query parameter to all the requests that will be used to retrieve the object.
func (r *SyncsetPollRequest) Parameter(name string, value interface{}) *SyncsetPollRequest {
	r.request.Parameter(name, value)
	return r
}

// Header adds a request header to all the requests that will be used to retrieve the object.
func (r *SyncsetPollRequest) Header(name string, value interface{}) *SyncsetPollRequest {
	r.request.Header(name, value)
	return r
}

// Interval sets the polling interval. This parameter is mandatory and must be greater than zero.
func (r *SyncsetPollRequest) Interval(value time.Duration) *SyncsetPollRequest {
	r.interval = value
	return r
}

// Status set the expected status of the response. Multiple values can be set calling this method
// multiple times. The response will be considered successful if the status is any of those values.
func (r *SyncsetPollRequest) Status(value int) *SyncsetPollRequest {
	r.statuses = append(r.statuses, value)
	return r
}

// Predicate adds a predicate that the response should satisfy be considered successful. Multiple
// predicates can be set calling this method multiple times. The response will be considered successful
// if all the predicates are satisfied.
func (r *SyncsetPollRequest) Predicate(value func(*SyncsetGetResponse) bool) *SyncsetPollRequest {
	r.predicates = append(r.predicates, func(response interface{}) bool {
		return value(response.(*SyncsetGetResponse))
	})
	return r
}

// StartContext starts the polling loop. Responses will be considered successful if the status is one of
// the values specified with the Status method and if all the predicates specified with the Predicate
// method return nil.
//
// The context must have a timeout or deadline, otherwise this method will immediately return an error.
func (r *SyncsetPollRequest) StartContext(ctx context.Context) (response *SyncsetPollResponse, err error) {
	result, err := helpers.PollContext(ctx, r.interval, r.statuses, r.predicates, r.task)
	if result != nil {
		response = &SyncsetPollResponse{
			response: result.(*SyncsetGetResponse),
		}
	}
	return
}

// task adapts the types of the request/response types so that they can be used with the generic
// polling function from the helpers package.
func (r *SyncsetPollRequest) task(ctx context.Context) (status int, result interface{}, err error) {
	response, err := r.request.SendContext(ctx)
	if response != nil {
		status = response.Status()
		result = response
	}
	return
}

// SyncsetPollResponse is the response for the Poll method.
type SyncsetPollResponse struct {
	response *SyncsetGetResponse
}

// Status returns the response status code.
func (r *SyncsetPollResponse) Status() int {
	if r == nil {
		return 0
	}
	return r.response.Status()
}

// Header returns header of the response.
func (r *SyncsetPollResponse) Header() http.Header {
	if r == nil {
		return nil
	}
	return r.response.Header()
}

// Error returns the response error.
func (r *SyncsetPollResponse) Error() *errors.Error {
	if r == nil {
		return nil
	}
	return r.response.Error()
}

// Body returns the value of the 'body' parameter.
//
//
func (r *SyncsetPollResponse) Body() *Syncset {
	return r.response.Body()
}

// GetBody returns the value of the 'body' parameter and
// a flag indicating if the parameter has a value.
//
//
func (r *SyncsetPollResponse) GetBody() (value *Syncset, ok bool) {
	return r.response.GetBody()
}

// Poll creates a request to repeatedly retrieve the object till the response has one of a given set
// of states and satisfies a set of predicates.
func (c *SyncsetClient) Poll() *SyncsetPollRequest {
	return &SyncsetPollRequest{
		request: c.Get(),
	}
}

// SyncsetDeleteRequest is the request for the 'delete' method.
type SyncsetDeleteRequest struct {
	transport http.RoundTripper
	path      string
	metric    string
	query     url.Values
	header    http.Header
}

// Parameter adds a query parameter.
func (r *SyncsetDeleteRequest) Parameter(name string, value interface{}) *SyncsetDeleteRequest {
	helpers.AddValue(&r.query, name, value)
	return r
}

// Header adds a request header.
func (r *SyncsetDeleteRequest) Header(name string, value interface{}) *SyncsetDeleteRequest {
	helpers.AddHeader(&r.header, name, value)
	return r
}

// Send sends this request, waits for the response, and returns it.
//
// This is a potentially lengthy operation, as it requires network communication.
// Consider using a context and the SendContext method.
func (r *SyncsetDeleteRequest) Send() (result *SyncsetDeleteResponse, err error) {
	return r.SendContext(context.Background())
}

// SendContext sends this request, waits for the response, and returns it.
func (r *SyncsetDeleteRequest) SendContext(ctx context.Context) (result *SyncsetDeleteResponse, err error) {
	query := helpers.CopyQuery(r.query)
	header := helpers.SetHeader(r.header, r.metric)
	uri := &url.URL{
		Path:     r.path,
		RawQuery: query.Encode(),
	}
	request := &http.Request{
		Method: "DELETE",
		URL:    uri,
		Header: header,
	}
	if ctx != nil {
		request = request.WithContext(ctx)
	}
	response, err := r.transport.RoundTrip(request)
	if err != nil {
		return
	}
	defer response.Body.Close()
	result = &SyncsetDeleteResponse{}
	result.status = response.StatusCode
	result.header = response.Header
	if result.status >= 400 {
		result.err, err = errors.UnmarshalError(response.Body)
		if err != nil {
			return
		}
		err = result.err
		return
	}
	return
}

// SyncsetDeleteResponse is the response for the 'delete' method.
type SyncsetDeleteResponse struct {
	status int
	header http.Header
	err    *errors.Error
}

// Status returns the response status code.
func (r *SyncsetDeleteResponse) Status() int {
	if r == nil {
		return 0
	}
	return r.status
}

// Header returns header of the response.
func (r *SyncsetDeleteResponse) Header() http.Header {
	if r == nil {
		return nil
	}
	return r.header
}

// Error returns the response error.
func (r *SyncsetDeleteResponse) Error() *errors.Error {
	if r == nil {
		return nil
	}
	return r.err
}

// SyncsetGetRequest is the request for the 'get' method.
type SyncsetGetRequest struct {
	transport http.RoundTripper
	path      string
	metric    string
	query     url.Values
	header    http.Header
}

// Parameter adds a query parameter.
func (r *SyncsetGetRequest) Parameter(name string, value interface{}) *SyncsetGetRequest {
	helpers.AddValue(&r.query, name, value)
	return r
}

// Header adds a request header.
func (r *SyncsetGetRequest) Header(name string, value interface{}) *SyncsetGetRequest {
	helpers.AddHeader(&r.header, name, value)
	return r
}

// Send sends this request, waits for the response, and returns it.
//
// This is a potentially lengthy operation, as it requires network communication.
// Consider using a context and the SendContext method.
func (r *SyncsetGetRequest) Send() (result *SyncsetGetResponse, err error) {
	return r.SendContext(context.Background())
}

// SendContext sends this request, waits for the response, and returns it.
func (r *SyncsetGetRequest) SendContext(ctx context.Context) (result *SyncsetGetResponse, err error) {
	query := helpers.CopyQuery(r.query)
	header := helpers.SetHeader(r.header, r.metric)
	uri := &url.URL{
		Path:     r.path,
		RawQuery: query.Encode(),
	}
	request := &http.Request{
		Method: "GET",
		URL:    uri,
		Header: header,
	}
	if ctx != nil {
		request = request.WithContext(ctx)
	}
	response, err := r.transport.RoundTrip(request)
	if err != nil {
		return
	}
	defer response.Body.Close()
	result = &SyncsetGetResponse{}
	result.status = response.StatusCode
	result.header = response.Header
	if result.status >= 400 {
		result.err, err = errors.UnmarshalError(response.Body)
		if err != nil {
			return
		}
		err = result.err
		return
	}
	err = readSyncsetGetResponse(result, response.Body)
	if err != nil {
		return
	}
	return
}

// SyncsetGetResponse is the response for the 'get' method.
type SyncsetGetResponse struct {
	status int
	header http.Header
	err    *errors.Error
	body   *Syncset
}

// Status returns the response status code.
func (r *SyncsetGetResponse) Status() int {
	if r == nil {
		return 0
	}
	return r.status
}

// Header returns header of the response.
func (r *SyncsetGetResponse) Header() http.Header {
	if r == nil {
		return nil
	}
	return r.header
}

// Error returns the response error.
func (r *SyncsetGetResponse) Error() *errors.Error {
	if r == nil {
		return nil
	}
	return r.err
}

// Body returns the value of the 'body' parameter.
//
//
func (r *SyncsetGetResponse) Body() *Syncset {
	if r == nil {
		return nil
	}
	return r.body
}

// GetBody returns the value of the 'body' parameter and
// a flag indicating if the parameter has a value.
//
//
func (r *SyncsetGetResponse) GetBody() (value *Syncset, ok bool) {
	ok = r != nil && r.body != nil
	if ok {
		value = r.body
	}
	return
}

// SyncsetUpdateRequest is the request for the 'update' method.
type SyncsetUpdateRequest struct {
	transport http.RoundTripper
	path      string
	metric    string
	query     url.Values
	header    http.Header
	body      *Syncset
}

// Parameter adds a query parameter.
func (r *SyncsetUpdateRequest) Parameter(name string, value interface{}) *SyncsetUpdateRequest {
	helpers.AddValue(&r.query, name, value)
	return r
}

// Header adds a request header.
func (r *SyncsetUpdateRequest) Header(name string, value interface{}) *SyncsetUpdateRequest {
	helpers.AddHeader(&r.header, name, value)
	return r
}

// Body sets the value of the 'body' parameter.
//
//
func (r *SyncsetUpdateRequest) Body(value *Syncset) *SyncsetUpdateRequest {
	r.body = value
	return r
}

// Send sends this request, waits for the response, and returns it.
//
// This is a potentially lengthy operation, as it requires network communication.
// Consider using a context and the SendContext method.
func (r *SyncsetUpdateRequest) Send() (result *SyncsetUpdateResponse, err error) {
	return r.SendContext(context.Background())
}

// SendContext sends this request, waits for the response, and returns it.
func (r *SyncsetUpdateRequest) SendContext(ctx context.Context) (result *SyncsetUpdateResponse, err error) {
	query := helpers.CopyQuery(r.query)
	header := helpers.SetHeader(r.header, r.metric)
	buffer := &bytes.Buffer{}
	err = writeSyncsetUpdateRequest(r, buffer)
	if err != nil {
		return
	}
	uri := &url.URL{
		Path:     r.path,
		RawQuery: query.Encode(),
	}
	request := &http.Request{
		Method: "PATCH",
		URL:    uri,
		Header: header,
		Body:   ioutil.NopCloser(buffer),
	}
	if ctx != nil {
		request = request.WithContext(ctx)
	}
	response, err := r.transport.RoundTrip(request)
	if err != nil {
		return
	}
	defer response.Body.Close()
	result = &SyncsetUpdateResponse{}
	result.status = response.StatusCode
	result.header = response.Header
	if result.status >= 400 {
		result.err, err = errors.UnmarshalError(response.Body)
		if err != nil {
			return
		}
		err = result.err
		return
	}
	err = readSyncsetUpdateResponse(result, response.Body)
	if err != nil {
		return
	}
	return
}

// marshall is the method used internally to marshal requests for the
// 'update' method.
func (r *SyncsetUpdateRequest) marshal(writer io.Writer) error {
	stream := helpers.NewStream(writer)
	r.stream(stream)
	return stream.Error
}
func (r *SyncsetUpdateRequest) stream(stream *jsoniter.Stream) {
}

// SyncsetUpdateResponse is the response for the 'update' method.
type SyncsetUpdateResponse struct {
	status int
	header http.Header
	err    *errors.Error
	body   *Syncset
}

// Status returns the response status code.
func (r *SyncsetUpdateResponse) Status() int {
	if r == nil {
		return 0
	}
	return r.status
}

// Header returns header of the response.
func (r *SyncsetUpdateResponse) Header() http.Header {
	if r == nil {
		return nil
	}
	return r.header
}

// Error returns the response error.
func (r *SyncsetUpdateResponse) Error() *errors.Error {
	if r == nil {
		return nil
	}
	return r.err
}

// Body returns the value of the 'body' parameter.
//
//
func (r *SyncsetUpdateResponse) Body() *Syncset {
	if r == nil {
		return nil
	}
	return r.body
}

// GetBody returns the value of the 'body' parameter and
// a flag indicating if the parameter has a value.
//
//
func (r *SyncsetUpdateResponse) GetBody() (value *Syncset, ok bool) {
	ok = r != nil && r.body != nil
	if ok {
		value = r.body
	}
	return
}
