// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

//go:generate mockery -name API -inpkg

// API is the interface of the installer client
type API interface {
	/*
	   CancelInstallation cancels an ongoing installation*/
	CancelInstallation(ctx context.Context, params *CancelInstallationParams) (*CancelInstallationAccepted, error)
	/*
	   CompleteInstallation agents API to mark a finalizing installation as complete*/
	CompleteInstallation(ctx context.Context, params *CompleteInstallationParams) (*CompleteInstallationAccepted, error)
	/*
	   DeregisterCluster deletes an open shift bare metal cluster definition*/
	DeregisterCluster(ctx context.Context, params *DeregisterClusterParams) (*DeregisterClusterNoContent, error)
	/*
	   DeregisterHost deregisters an open shift bare metal host*/
	DeregisterHost(ctx context.Context, params *DeregisterHostParams) (*DeregisterHostNoContent, error)
	/*
	   DisableHost disables a host for inclusion in the cluster*/
	DisableHost(ctx context.Context, params *DisableHostParams) (*DisableHostOK, error)
	/*
	   DownloadClusterFiles downloads files relating to the installed installing cluster*/
	DownloadClusterFiles(ctx context.Context, params *DownloadClusterFilesParams, writer io.Writer) (*DownloadClusterFilesOK, error)
	/*
	   DownloadClusterISO downloads the open shift per cluster discovery i s o*/
	DownloadClusterISO(ctx context.Context, params *DownloadClusterISOParams, writer io.Writer) (*DownloadClusterISOOK, error)
	/*
	   DownloadClusterKubeconfig downloads the kubeconfig file for this cluster*/
	DownloadClusterKubeconfig(ctx context.Context, params *DownloadClusterKubeconfigParams, writer io.Writer) (*DownloadClusterKubeconfigOK, error)
	/*
	   DownloadClusterLogs downloads cluster logs*/
	DownloadClusterLogs(ctx context.Context, params *DownloadClusterLogsParams, writer io.Writer) (*DownloadClusterLogsOK, error)
	/*
	   DownloadHostIgnition downloads the customized ignition file for this host*/
	DownloadHostIgnition(ctx context.Context, params *DownloadHostIgnitionParams, writer io.Writer) (*DownloadHostIgnitionOK, error)
	/*
	   DownloadHostLogs downloads host logs*/
	DownloadHostLogs(ctx context.Context, params *DownloadHostLogsParams, writer io.Writer) (*DownloadHostLogsOK, error)
	/*
	   EnableHost enables a host for inclusion in the cluster*/
	EnableHost(ctx context.Context, params *EnableHostParams) (*EnableHostOK, error)
	/*
	   GenerateClusterISO creates a new open shift per cluster discovery i s o*/
	GenerateClusterISO(ctx context.Context, params *GenerateClusterISOParams) (*GenerateClusterISOCreated, error)
	/*
	   GetCluster retrieves the details of the open shift bare metal cluster*/
	GetCluster(ctx context.Context, params *GetClusterParams) (*GetClusterOK, error)
	/*
	   GetClusterInstallConfig gets the cluster s install config y a m l*/
	GetClusterInstallConfig(ctx context.Context, params *GetClusterInstallConfigParams) (*GetClusterInstallConfigOK, error)
	/*
	   GetCredentials gets the cluster admin credentials*/
	GetCredentials(ctx context.Context, params *GetCredentialsParams) (*GetCredentialsOK, error)
	/*
	   GetDiscoveryIgnition gets the cluster discovery ignition config*/
	GetDiscoveryIgnition(ctx context.Context, params *GetDiscoveryIgnitionParams) (*GetDiscoveryIgnitionOK, error)
	/*
	   GetFreeAddresses retrieves the free address list for a network*/
	GetFreeAddresses(ctx context.Context, params *GetFreeAddressesParams) (*GetFreeAddressesOK, error)
	/*
	   GetHost retrieves the details of the open shift bare metal host*/
	GetHost(ctx context.Context, params *GetHostParams) (*GetHostOK, error)
	/*
	   GetHostIgnition gets the customized ignition file for this host*/
	GetHostIgnition(ctx context.Context, params *GetHostIgnitionParams) (*GetHostIgnitionOK, error)
	/*
	   GetHostRequirements gets minimum host requirements*/
	GetHostRequirements(ctx context.Context, params *GetHostRequirementsParams) (*GetHostRequirementsOK, error)
	/*
	   GetNextSteps retrieves the next operations that the host agent needs to perform*/
	GetNextSteps(ctx context.Context, params *GetNextStepsParams) (*GetNextStepsOK, error)
	/*
	   GetPresignedForClusterFiles retrieves a pre signed s3 URL for downloading cluster files*/
	GetPresignedForClusterFiles(ctx context.Context, params *GetPresignedForClusterFilesParams) (*GetPresignedForClusterFilesOK, error)
	/*
	   InstallCluster installs the open shift bare metal cluster*/
	InstallCluster(ctx context.Context, params *InstallClusterParams) (*InstallClusterAccepted, error)
	/*
	   InstallHost installs specific host for day2 cluster*/
	InstallHost(ctx context.Context, params *InstallHostParams) (*InstallHostAccepted, error)
	/*
	   InstallHosts installs the open shift bare metal cluster*/
	InstallHosts(ctx context.Context, params *InstallHostsParams) (*InstallHostsAccepted, error)
	/*
	   ListClusters retrieves the list of open shift bare metal clusters*/
	ListClusters(ctx context.Context, params *ListClustersParams) (*ListClustersOK, error)
	/*
	   ListHosts retrieves the list of open shift bare metal hosts*/
	ListHosts(ctx context.Context, params *ListHostsParams) (*ListHostsOK, error)
	/*
	   PostStepReply posts the result of the operations from the host agent*/
	PostStepReply(ctx context.Context, params *PostStepReplyParams) (*PostStepReplyNoContent, error)
	/*
	   RegisterAddHostsCluster creates a new open shift bare metal cluster definition for adding nodes to and existing o c p cluster*/
	RegisterAddHostsCluster(ctx context.Context, params *RegisterAddHostsClusterParams) (*RegisterAddHostsClusterCreated, error)
	/*
	   RegisterCluster creates a new open shift bare metal cluster definition*/
	RegisterCluster(ctx context.Context, params *RegisterClusterParams) (*RegisterClusterCreated, error)
	/*
	   RegisterHost registers a new open shift bare metal host*/
	RegisterHost(ctx context.Context, params *RegisterHostParams) (*RegisterHostCreated, error)
	/*
	   ResetCluster resets a failed installation*/
	ResetCluster(ctx context.Context, params *ResetClusterParams) (*ResetClusterAccepted, error)
	/*
	   ResetHost resets a failed host for day2 cluster*/
	ResetHost(ctx context.Context, params *ResetHostParams) (*ResetHostOK, error)
	/*
	   UpdateCluster updates an open shift bare metal cluster definition*/
	UpdateCluster(ctx context.Context, params *UpdateClusterParams) (*UpdateClusterCreated, error)
	/*
	   UpdateClusterInstallConfig overrides values in the install config*/
	UpdateClusterInstallConfig(ctx context.Context, params *UpdateClusterInstallConfigParams) (*UpdateClusterInstallConfigCreated, error)
	/*
	   UpdateClusterInstallProgress updates cluster installation progress*/
	UpdateClusterInstallProgress(ctx context.Context, params *UpdateClusterInstallProgressParams) (*UpdateClusterInstallProgressNoContent, error)
	/*
	   UpdateDiscoveryIgnition overrides values in the discovery ignition config*/
	UpdateDiscoveryIgnition(ctx context.Context, params *UpdateDiscoveryIgnitionParams) (*UpdateDiscoveryIgnitionCreated, error)
	/*
	   UpdateHostIgnition patches the ignition file for this host*/
	UpdateHostIgnition(ctx context.Context, params *UpdateHostIgnitionParams) (*UpdateHostIgnitionCreated, error)
	/*
	   UpdateHostInstallProgress updates installation progress*/
	UpdateHostInstallProgress(ctx context.Context, params *UpdateHostInstallProgressParams) (*UpdateHostInstallProgressOK, error)
	/*
	   UpdateHostInstallerArgs updates an open shift bare metal host*/
	UpdateHostInstallerArgs(ctx context.Context, params *UpdateHostInstallerArgsParams) (*UpdateHostInstallerArgsCreated, error)
	/*
	   UploadClusterIngressCert transfers the ingress certificate for the cluster*/
	UploadClusterIngressCert(ctx context.Context, params *UploadClusterIngressCertParams) (*UploadClusterIngressCertCreated, error)
	/*
	   UploadHostLogs agents API to upload logs*/
	UploadHostLogs(ctx context.Context, params *UploadHostLogsParams) (*UploadHostLogsNoContent, error)
	/*
	   UploadLogs agents API to upload logs*/
	UploadLogs(ctx context.Context, params *UploadLogsParams) (*UploadLogsNoContent, error)
}

// New creates a new installer API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry, authInfo runtime.ClientAuthInfoWriter) *Client {
	return &Client{
		transport: transport,
		formats:   formats,
		authInfo:  authInfo,
	}
}

/*
Client for installer API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
	authInfo  runtime.ClientAuthInfoWriter
}

/*
CancelInstallation cancels an ongoing installation
*/
func (a *Client) CancelInstallation(ctx context.Context, params *CancelInstallationParams) (*CancelInstallationAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "CancelInstallation",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/actions/cancel",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CancelInstallationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CancelInstallationAccepted), nil

}

/*
CompleteInstallation agents API to mark a finalizing installation as complete
*/
func (a *Client) CompleteInstallation(ctx context.Context, params *CompleteInstallationParams) (*CompleteInstallationAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "CompleteInstallation",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/actions/complete_installation",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CompleteInstallationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CompleteInstallationAccepted), nil

}

/*
DeregisterCluster deletes an open shift bare metal cluster definition
*/
func (a *Client) DeregisterCluster(ctx context.Context, params *DeregisterClusterParams) (*DeregisterClusterNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeregisterCluster",
		Method:             "DELETE",
		PathPattern:        "/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeregisterClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeregisterClusterNoContent), nil

}

/*
DeregisterHost deregisters an open shift bare metal host
*/
func (a *Client) DeregisterHost(ctx context.Context, params *DeregisterHostParams) (*DeregisterHostNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeregisterHost",
		Method:             "DELETE",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeregisterHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeregisterHostNoContent), nil

}

/*
DisableHost disables a host for inclusion in the cluster
*/
func (a *Client) DisableHost(ctx context.Context, params *DisableHostParams) (*DisableHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DisableHost",
		Method:             "DELETE",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/actions/enable",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DisableHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DisableHostOK), nil

}

/*
DownloadClusterFiles downloads files relating to the installed installing cluster
*/
func (a *Client) DownloadClusterFiles(ctx context.Context, params *DownloadClusterFilesParams, writer io.Writer) (*DownloadClusterFilesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterFiles",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/downloads/files",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterFilesReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterFilesOK), nil

}

/*
DownloadClusterISO downloads the open shift per cluster discovery i s o
*/
func (a *Client) DownloadClusterISO(ctx context.Context, params *DownloadClusterISOParams, writer io.Writer) (*DownloadClusterISOOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterISO",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/downloads/image",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterISOReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterISOOK), nil

}

/*
DownloadClusterKubeconfig downloads the kubeconfig file for this cluster
*/
func (a *Client) DownloadClusterKubeconfig(ctx context.Context, params *DownloadClusterKubeconfigParams, writer io.Writer) (*DownloadClusterKubeconfigOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterKubeconfig",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/downloads/kubeconfig",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterKubeconfigReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterKubeconfigOK), nil

}

/*
DownloadClusterLogs downloads cluster logs
*/
func (a *Client) DownloadClusterLogs(ctx context.Context, params *DownloadClusterLogsParams, writer io.Writer) (*DownloadClusterLogsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterLogs",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/logs",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterLogsReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterLogsOK), nil

}

/*
DownloadHostIgnition downloads the customized ignition file for this host
*/
func (a *Client) DownloadHostIgnition(ctx context.Context, params *DownloadHostIgnitionParams, writer io.Writer) (*DownloadHostIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadHostIgnition",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/downloads/ignition",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadHostIgnitionReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadHostIgnitionOK), nil

}

/*
DownloadHostLogs downloads host logs
*/
func (a *Client) DownloadHostLogs(ctx context.Context, params *DownloadHostLogsParams, writer io.Writer) (*DownloadHostLogsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadHostLogs",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/logs",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadHostLogsReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadHostLogsOK), nil

}

/*
EnableHost enables a host for inclusion in the cluster
*/
func (a *Client) EnableHost(ctx context.Context, params *EnableHostParams) (*EnableHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "EnableHost",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/actions/enable",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &EnableHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*EnableHostOK), nil

}

/*
GenerateClusterISO creates a new open shift per cluster discovery i s o
*/
func (a *Client) GenerateClusterISO(ctx context.Context, params *GenerateClusterISOParams) (*GenerateClusterISOCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GenerateClusterISO",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/downloads/image",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GenerateClusterISOReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GenerateClusterISOCreated), nil

}

/*
GetCluster retrieves the details of the open shift bare metal cluster
*/
func (a *Client) GetCluster(ctx context.Context, params *GetClusterParams) (*GetClusterOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetCluster",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterOK), nil

}

/*
GetClusterInstallConfig gets the cluster s install config y a m l
*/
func (a *Client) GetClusterInstallConfig(ctx context.Context, params *GetClusterInstallConfigParams) (*GetClusterInstallConfigOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetClusterInstallConfig",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/install-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterInstallConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterInstallConfigOK), nil

}

/*
GetCredentials gets the cluster admin credentials
*/
func (a *Client) GetCredentials(ctx context.Context, params *GetCredentialsParams) (*GetCredentialsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetCredentials",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/credentials",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetCredentialsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetCredentialsOK), nil

}

/*
GetDiscoveryIgnition gets the cluster discovery ignition config
*/
func (a *Client) GetDiscoveryIgnition(ctx context.Context, params *GetDiscoveryIgnitionParams) (*GetDiscoveryIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetDiscoveryIgnition",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/discovery-ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetDiscoveryIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetDiscoveryIgnitionOK), nil

}

/*
GetFreeAddresses retrieves the free address list for a network
*/
func (a *Client) GetFreeAddresses(ctx context.Context, params *GetFreeAddressesParams) (*GetFreeAddressesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetFreeAddresses",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/free_addresses",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetFreeAddressesReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetFreeAddressesOK), nil

}

/*
GetHost retrieves the details of the open shift bare metal host
*/
func (a *Client) GetHost(ctx context.Context, params *GetHostParams) (*GetHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetHost",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetHostOK), nil

}

/*
GetHostIgnition gets the customized ignition file for this host
*/
func (a *Client) GetHostIgnition(ctx context.Context, params *GetHostIgnitionParams) (*GetHostIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetHostIgnition",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetHostIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetHostIgnitionOK), nil

}

/*
GetHostRequirements gets minimum host requirements
*/
func (a *Client) GetHostRequirements(ctx context.Context, params *GetHostRequirementsParams) (*GetHostRequirementsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetHostRequirements",
		Method:             "GET",
		PathPattern:        "/host_requirements",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetHostRequirementsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetHostRequirementsOK), nil

}

/*
GetNextSteps retrieves the next operations that the host agent needs to perform
*/
func (a *Client) GetNextSteps(ctx context.Context, params *GetNextStepsParams) (*GetNextStepsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetNextSteps",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/instructions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetNextStepsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetNextStepsOK), nil

}

/*
GetPresignedForClusterFiles retrieves a pre signed s3 URL for downloading cluster files
*/
func (a *Client) GetPresignedForClusterFiles(ctx context.Context, params *GetPresignedForClusterFilesParams) (*GetPresignedForClusterFilesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetPresignedForClusterFiles",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/downloads/files-presigned",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetPresignedForClusterFilesReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetPresignedForClusterFilesOK), nil

}

/*
InstallCluster installs the open shift bare metal cluster
*/
func (a *Client) InstallCluster(ctx context.Context, params *InstallClusterParams) (*InstallClusterAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "InstallCluster",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/actions/install",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &InstallClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*InstallClusterAccepted), nil

}

/*
InstallHost installs specific host for day2 cluster
*/
func (a *Client) InstallHost(ctx context.Context, params *InstallHostParams) (*InstallHostAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "InstallHost",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/actions/install",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &InstallHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*InstallHostAccepted), nil

}

/*
InstallHosts installs the open shift bare metal cluster
*/
func (a *Client) InstallHosts(ctx context.Context, params *InstallHostsParams) (*InstallHostsAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "InstallHosts",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/actions/install_hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &InstallHostsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*InstallHostsAccepted), nil

}

/*
ListClusters retrieves the list of open shift bare metal clusters
*/
func (a *Client) ListClusters(ctx context.Context, params *ListClustersParams) (*ListClustersOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListClusters",
		Method:             "GET",
		PathPattern:        "/clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListClustersReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListClustersOK), nil

}

/*
ListHosts retrieves the list of open shift bare metal hosts
*/
func (a *Client) ListHosts(ctx context.Context, params *ListHostsParams) (*ListHostsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListHosts",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListHostsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListHostsOK), nil

}

/*
PostStepReply posts the result of the operations from the host agent
*/
func (a *Client) PostStepReply(ctx context.Context, params *PostStepReplyParams) (*PostStepReplyNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "PostStepReply",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/instructions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PostStepReplyReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PostStepReplyNoContent), nil

}

/*
RegisterAddHostsCluster creates a new open shift bare metal cluster definition for adding nodes to and existing o c p cluster
*/
func (a *Client) RegisterAddHostsCluster(ctx context.Context, params *RegisterAddHostsClusterParams) (*RegisterAddHostsClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "RegisterAddHostsCluster",
		Method:             "POST",
		PathPattern:        "/add_hosts_clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RegisterAddHostsClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*RegisterAddHostsClusterCreated), nil

}

/*
RegisterCluster creates a new open shift bare metal cluster definition
*/
func (a *Client) RegisterCluster(ctx context.Context, params *RegisterClusterParams) (*RegisterClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "RegisterCluster",
		Method:             "POST",
		PathPattern:        "/clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RegisterClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*RegisterClusterCreated), nil

}

/*
RegisterHost registers a new open shift bare metal host
*/
func (a *Client) RegisterHost(ctx context.Context, params *RegisterHostParams) (*RegisterHostCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "RegisterHost",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RegisterHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*RegisterHostCreated), nil

}

/*
ResetCluster resets a failed installation
*/
func (a *Client) ResetCluster(ctx context.Context, params *ResetClusterParams) (*ResetClusterAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ResetCluster",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/actions/reset",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ResetClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ResetClusterAccepted), nil

}

/*
ResetHost resets a failed host for day2 cluster
*/
func (a *Client) ResetHost(ctx context.Context, params *ResetHostParams) (*ResetHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ResetHost",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/actions/reset",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ResetHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ResetHostOK), nil

}

/*
UpdateCluster updates an open shift bare metal cluster definition
*/
func (a *Client) UpdateCluster(ctx context.Context, params *UpdateClusterParams) (*UpdateClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateCluster",
		Method:             "PATCH",
		PathPattern:        "/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateClusterCreated), nil

}

/*
UpdateClusterInstallConfig overrides values in the install config
*/
func (a *Client) UpdateClusterInstallConfig(ctx context.Context, params *UpdateClusterInstallConfigParams) (*UpdateClusterInstallConfigCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateClusterInstallConfig",
		Method:             "PATCH",
		PathPattern:        "/clusters/{cluster_id}/install-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateClusterInstallConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateClusterInstallConfigCreated), nil

}

/*
UpdateClusterInstallProgress updates cluster installation progress
*/
func (a *Client) UpdateClusterInstallProgress(ctx context.Context, params *UpdateClusterInstallProgressParams) (*UpdateClusterInstallProgressNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateClusterInstallProgress",
		Method:             "PUT",
		PathPattern:        "/clusters/{cluster_id}/progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateClusterInstallProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateClusterInstallProgressNoContent), nil

}

/*
UpdateDiscoveryIgnition overrides values in the discovery ignition config
*/
func (a *Client) UpdateDiscoveryIgnition(ctx context.Context, params *UpdateDiscoveryIgnitionParams) (*UpdateDiscoveryIgnitionCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateDiscoveryIgnition",
		Method:             "PATCH",
		PathPattern:        "/clusters/{cluster_id}/discovery-ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateDiscoveryIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateDiscoveryIgnitionCreated), nil

}

/*
UpdateHostIgnition patches the ignition file for this host
*/
func (a *Client) UpdateHostIgnition(ctx context.Context, params *UpdateHostIgnitionParams) (*UpdateHostIgnitionCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateHostIgnition",
		Method:             "PATCH",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateHostIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateHostIgnitionCreated), nil

}

/*
UpdateHostInstallProgress updates installation progress
*/
func (a *Client) UpdateHostInstallProgress(ctx context.Context, params *UpdateHostInstallProgressParams) (*UpdateHostInstallProgressOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateHostInstallProgress",
		Method:             "PUT",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateHostInstallProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateHostInstallProgressOK), nil

}

/*
UpdateHostInstallerArgs updates an open shift bare metal host
*/
func (a *Client) UpdateHostInstallerArgs(ctx context.Context, params *UpdateHostInstallerArgsParams) (*UpdateHostInstallerArgsCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateHostInstallerArgs",
		Method:             "PATCH",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/installer-args",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateHostInstallerArgsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateHostInstallerArgsCreated), nil

}

/*
UploadClusterIngressCert transfers the ingress certificate for the cluster
*/
func (a *Client) UploadClusterIngressCert(ctx context.Context, params *UploadClusterIngressCertParams) (*UploadClusterIngressCertCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UploadClusterIngressCert",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/uploads/ingress-cert",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UploadClusterIngressCertReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UploadClusterIngressCertCreated), nil

}

/*
UploadHostLogs agents API to upload logs
*/
func (a *Client) UploadHostLogs(ctx context.Context, params *UploadHostLogsParams) (*UploadHostLogsNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UploadHostLogs",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/hosts/{host_id}/logs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UploadHostLogsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UploadHostLogsNoContent), nil

}

/*
UploadLogs agents API to upload logs
*/
func (a *Client) UploadLogs(ctx context.Context, params *UploadLogsParams) (*UploadLogsNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UploadLogs",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/logs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UploadLogsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UploadLogsNoContent), nil

}
