// Code generated by go-swagger; DO NOT EDIT.

package manifests

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

//go:generate mockery -name API -inpkg

// API is the interface of the manifests client
type API interface {
	/*
	   CreateClusterManifest creates a manifest for customizing cluster installation*/
	CreateClusterManifest(ctx context.Context, params *CreateClusterManifestParams) (*CreateClusterManifestCreated, error)
	/*
	   DeleteClusterManifest deletes a manifest from the cluster*/
	DeleteClusterManifest(ctx context.Context, params *DeleteClusterManifestParams) (*DeleteClusterManifestOK, error)
	/*
	   DownloadClusterManifest downloads cluster manifest*/
	DownloadClusterManifest(ctx context.Context, params *DownloadClusterManifestParams, writer io.Writer) (*DownloadClusterManifestOK, error)
	/*
	   ListClusterManifests lists manifests for customizing cluster installation*/
	ListClusterManifests(ctx context.Context, params *ListClusterManifestsParams) (*ListClusterManifestsOK, error)
}

// New creates a new manifests API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry, authInfo runtime.ClientAuthInfoWriter) *Client {
	return &Client{
		transport: transport,
		formats:   formats,
		authInfo:  authInfo,
	}
}

/*
Client for manifests API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
	authInfo  runtime.ClientAuthInfoWriter
}

/*
CreateClusterManifest creates a manifest for customizing cluster installation
*/
func (a *Client) CreateClusterManifest(ctx context.Context, params *CreateClusterManifestParams) (*CreateClusterManifestCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "CreateClusterManifest",
		Method:             "POST",
		PathPattern:        "/clusters/{cluster_id}/manifests",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateClusterManifestReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CreateClusterManifestCreated), nil

}

/*
DeleteClusterManifest deletes a manifest from the cluster
*/
func (a *Client) DeleteClusterManifest(ctx context.Context, params *DeleteClusterManifestParams) (*DeleteClusterManifestOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeleteClusterManifest",
		Method:             "DELETE",
		PathPattern:        "/clusters/{cluster_id}/manifests",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteClusterManifestReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeleteClusterManifestOK), nil

}

/*
DownloadClusterManifest downloads cluster manifest
*/
func (a *Client) DownloadClusterManifest(ctx context.Context, params *DownloadClusterManifestParams, writer io.Writer) (*DownloadClusterManifestOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterManifest",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/manifests/files",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterManifestReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterManifestOK), nil

}

/*
ListClusterManifests lists manifests for customizing cluster installation
*/
func (a *Client) ListClusterManifests(ctx context.Context, params *ListClusterManifestsParams) (*ListClusterManifestsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListClusterManifests",
		Method:             "GET",
		PathPattern:        "/clusters/{cluster_id}/manifests",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListClusterManifestsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListClusterManifestsOK), nil

}
