// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StaticIPConfig static ip config
//
// swagger:model static-ip-config
type StaticIPConfig struct {

	// dns
	DNS string `json:"dns,omitempty"`

	// gateway
	// Pattern: ^([0-9]{1,3}\.){3}[0-9]{1,3}$
	Gateway string `json:"gateway,omitempty"`

	// ip
	// Pattern: ^([0-9]{1,3}\.){3}[0-9]{1,3}$
	IP string `json:"ip,omitempty"`

	// mac
	// Pattern: ^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$
	Mac string `json:"mac,omitempty"`

	// mask
	// Pattern: ^[0-9]|[1-2][0-9]|3[0-2]?$
	Mask string `json:"mask,omitempty"`
}

// Validate validates this static ip config
func (m *StaticIPConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGateway(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMac(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StaticIPConfig) validateGateway(formats strfmt.Registry) error {

	if swag.IsZero(m.Gateway) { // not required
		return nil
	}

	if err := validate.Pattern("gateway", "body", string(m.Gateway), `^([0-9]{1,3}\.){3}[0-9]{1,3}$`); err != nil {
		return err
	}

	return nil
}

func (m *StaticIPConfig) validateIP(formats strfmt.Registry) error {

	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if err := validate.Pattern("ip", "body", string(m.IP), `^([0-9]{1,3}\.){3}[0-9]{1,3}$`); err != nil {
		return err
	}

	return nil
}

func (m *StaticIPConfig) validateMac(formats strfmt.Registry) error {

	if swag.IsZero(m.Mac) { // not required
		return nil
	}

	if err := validate.Pattern("mac", "body", string(m.Mac), `^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$`); err != nil {
		return err
	}

	return nil
}

func (m *StaticIPConfig) validateMask(formats strfmt.Registry) error {

	if swag.IsZero(m.Mask) { // not required
		return nil
	}

	if err := validate.Pattern("mask", "body", string(m.Mask), `^[0-9]|[1-2][0-9]|3[0-2]?$`); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StaticIPConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StaticIPConfig) UnmarshalBinary(b []byte) error {
	var res StaticIPConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
