/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	"encoding/json"
	"fmt"
)

// Type the model 'Type'
type Type string

// List of Type
const (
	DATACENTER Type = "datacenter"
	SERVER Type = "server"
	VOLUME Type = "volume"
	NIC Type = "nic"
	LOADBALANCER Type = "loadbalancer"
	LOCATION Type = "location"
	FIREWALL_RULE Type = "firewall-rule"
	IMAGE Type = "image"
	SNAPSHOT Type = "snapshot"
	LAN Type = "lan"
	IPBLOCK Type = "ipblock"
	PCC Type = "pcc"
	CONTRACT Type = "contract"
	USER Type = "user"
	GROUP Type = "group"
	COLLECTION Type = "collection"
	RESOURCE Type = "resource"
	REQUEST Type = "request"
	REQUEST_STATUS Type = "request-status"
	S3KEY Type = "s3key"
	BACKUPUNIT Type = "backupunit"
	LABEL Type = "label"
	K8S Type = "k8s"
	NODEPOOL Type = "nodepool"
)

func (v *Type) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := Type(value)
	for _, existing := range []Type{ "datacenter", "server", "volume", "nic", "loadbalancer", "location", "firewall-rule", "image", "snapshot", "lan", "ipblock", "pcc", "contract", "user", "group", "collection", "resource", "request", "request-status", "s3key", "backupunit", "label", "k8s", "nodepool",   } {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid Type", value)
}

// Ptr returns reference to Type value
func (v Type) Ptr() *Type {
	return &v
}

type NullableType struct {
	value *Type
	isSet bool
}

func (v NullableType) Get() *Type {
	return v.value
}

func (v *NullableType) Set(val *Type) {
	v.value = val
	v.isSet = true
}

func (v NullableType) IsSet() bool {
	return v.isSet
}

func (v *NullableType) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableType(val *Type) *NullableType {
	return &NullableType{value: val, isSet: true}
}

func (v NullableType) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableType) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}

