/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery v2.3.0. DO NOT EDIT.

package ionoscloud

import (
	mock "github.com/stretchr/testify/mock"
	cloudprovider "k8s.io/autoscaler/cluster-autoscaler/cloudprovider"

	v1 "k8s.io/api/core/v1"
)

// MockIonosCloudManager is an autogenerated mock type for the IonosCloudManager type
type MockIonosCloudManager struct {
	mock.Mock
}

// DeleteNode provides a mock function with given fields: nodeGroup, nodeId
func (_m *MockIonosCloudManager) DeleteNode(nodeGroup cloudprovider.NodeGroup, nodeId string) error {
	ret := _m.Called(nodeGroup, nodeId)

	var r0 error
	if rf, ok := ret.Get(0).(func(cloudprovider.NodeGroup, string) error); ok {
		r0 = rf(nodeGroup, nodeId)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetInstancesForNodeGroup provides a mock function with given fields: nodeGroup
func (_m *MockIonosCloudManager) GetInstancesForNodeGroup(nodeGroup cloudprovider.NodeGroup) ([]cloudprovider.Instance, error) {
	ret := _m.Called(nodeGroup)

	var r0 []cloudprovider.Instance
	if rf, ok := ret.Get(0).(func(cloudprovider.NodeGroup) []cloudprovider.Instance); ok {
		r0 = rf(nodeGroup)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]cloudprovider.Instance)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(cloudprovider.NodeGroup) error); ok {
		r1 = rf(nodeGroup)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetNodeGroupForNode provides a mock function with given fields: node
func (_m *MockIonosCloudManager) GetNodeGroupForNode(node *v1.Node) cloudprovider.NodeGroup {
	ret := _m.Called(node)

	var r0 cloudprovider.NodeGroup
	if rf, ok := ret.Get(0).(func(*v1.Node) cloudprovider.NodeGroup); ok {
		r0 = rf(node)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(cloudprovider.NodeGroup)
		}
	}

	return r0
}

// GetNodeGroupSize provides a mock function with given fields: nodeGroup
func (_m *MockIonosCloudManager) GetNodeGroupSize(nodeGroup cloudprovider.NodeGroup) (int, error) {
	ret := _m.Called(nodeGroup)

	var r0 int
	if rf, ok := ret.Get(0).(func(cloudprovider.NodeGroup) int); ok {
		r0 = rf(nodeGroup)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(cloudprovider.NodeGroup) error); ok {
		r1 = rf(nodeGroup)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetNodeGroupTargetSize provides a mock function with given fields: nodeGroup
func (_m *MockIonosCloudManager) GetNodeGroupTargetSize(nodeGroup cloudprovider.NodeGroup) (int, error) {
	ret := _m.Called(nodeGroup)

	var r0 int
	if rf, ok := ret.Get(0).(func(cloudprovider.NodeGroup) int); ok {
		r0 = rf(nodeGroup)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(cloudprovider.NodeGroup) error); ok {
		r1 = rf(nodeGroup)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetNodeGroups provides a mock function with given fields:
func (_m *MockIonosCloudManager) GetNodeGroups() []cloudprovider.NodeGroup {
	ret := _m.Called()

	var r0 []cloudprovider.NodeGroup
	if rf, ok := ret.Get(0).(func() []cloudprovider.NodeGroup); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]cloudprovider.NodeGroup)
		}
	}

	return r0
}

// SetNodeGroupSize provides a mock function with given fields: nodeGroup, size
func (_m *MockIonosCloudManager) SetNodeGroupSize(nodeGroup cloudprovider.NodeGroup, size int) error {
	ret := _m.Called(nodeGroup, size)

	var r0 error
	if rf, ok := ret.Get(0).(func(cloudprovider.NodeGroup, int) error); ok {
		r0 = rf(nodeGroup, size)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// TryLockNodeGroup provides a mock function with given fields: nodeGroup
func (_m *MockIonosCloudManager) TryLockNodeGroup(nodeGroup cloudprovider.NodeGroup) bool {
	ret := _m.Called(nodeGroup)

	var r0 bool
	if rf, ok := ret.Get(0).(func(cloudprovider.NodeGroup) bool); ok {
		r0 = rf(nodeGroup)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// UnlockNodeGroup provides a mock function with given fields: nodeGroup
func (_m *MockIonosCloudManager) UnlockNodeGroup(nodeGroup cloudprovider.NodeGroup) {
	_m.Called(nodeGroup)
}
