// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/clouderrorreporting/v1beta1/error_stats_service.proto

package clouderrorreporting

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Specifies how the time periods of error group counts are aligned.
type TimedCountAlignment int32

const (
	// No alignment specified.
	TimedCountAlignment_ERROR_COUNT_ALIGNMENT_UNSPECIFIED TimedCountAlignment = 0
	// The time periods shall be consecutive, have width equal to the
	// requested duration, and be aligned at the `alignment_time` provided in
	// the request.
	// The `alignment_time` does not have to be inside the query period but
	// even if it is outside, only time periods are returned which overlap
	// with the query period.
	// A rounded alignment will typically result in a
	// different size of the first or the last time period.
	TimedCountAlignment_ALIGNMENT_EQUAL_ROUNDED TimedCountAlignment = 1
	// The time periods shall be consecutive, have width equal to the
	// requested duration, and be aligned at the end of the requested time
	// period. This can result in a different size of the
	// first time period.
	TimedCountAlignment_ALIGNMENT_EQUAL_AT_END TimedCountAlignment = 2
)

var TimedCountAlignment_name = map[int32]string{
	0: "ERROR_COUNT_ALIGNMENT_UNSPECIFIED",
	1: "ALIGNMENT_EQUAL_ROUNDED",
	2: "ALIGNMENT_EQUAL_AT_END",
}

var TimedCountAlignment_value = map[string]int32{
	"ERROR_COUNT_ALIGNMENT_UNSPECIFIED": 0,
	"ALIGNMENT_EQUAL_ROUNDED":           1,
	"ALIGNMENT_EQUAL_AT_END":            2,
}

func (x TimedCountAlignment) String() string {
	return proto.EnumName(TimedCountAlignment_name, int32(x))
}

func (TimedCountAlignment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{0}
}

// A sorting order of error groups.
type ErrorGroupOrder int32

const (
	// No group order specified.
	ErrorGroupOrder_GROUP_ORDER_UNSPECIFIED ErrorGroupOrder = 0
	// Total count of errors in the given time window in descending order.
	ErrorGroupOrder_COUNT_DESC ErrorGroupOrder = 1
	// Timestamp when the group was last seen in the given time window
	// in descending order.
	ErrorGroupOrder_LAST_SEEN_DESC ErrorGroupOrder = 2
	// Timestamp when the group was created in descending order.
	ErrorGroupOrder_CREATED_DESC ErrorGroupOrder = 3
	// Number of affected users in the given time window in descending order.
	ErrorGroupOrder_AFFECTED_USERS_DESC ErrorGroupOrder = 4
)

var ErrorGroupOrder_name = map[int32]string{
	0: "GROUP_ORDER_UNSPECIFIED",
	1: "COUNT_DESC",
	2: "LAST_SEEN_DESC",
	3: "CREATED_DESC",
	4: "AFFECTED_USERS_DESC",
}

var ErrorGroupOrder_value = map[string]int32{
	"GROUP_ORDER_UNSPECIFIED": 0,
	"COUNT_DESC":              1,
	"LAST_SEEN_DESC":          2,
	"CREATED_DESC":            3,
	"AFFECTED_USERS_DESC":     4,
}

func (x ErrorGroupOrder) String() string {
	return proto.EnumName(ErrorGroupOrder_name, int32(x))
}

func (ErrorGroupOrder) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{1}
}

// The supported time ranges.
type QueryTimeRange_Period int32

const (
	// Do not use.
	QueryTimeRange_PERIOD_UNSPECIFIED QueryTimeRange_Period = 0
	// Retrieve data for the last hour.
	// Recommended minimum timed count duration: 1 min.
	QueryTimeRange_PERIOD_1_HOUR QueryTimeRange_Period = 1
	// Retrieve data for the last 6 hours.
	// Recommended minimum timed count duration: 10 min.
	QueryTimeRange_PERIOD_6_HOURS QueryTimeRange_Period = 2
	// Retrieve data for the last day.
	// Recommended minimum timed count duration: 1 hour.
	QueryTimeRange_PERIOD_1_DAY QueryTimeRange_Period = 3
	// Retrieve data for the last week.
	// Recommended minimum timed count duration: 6 hours.
	QueryTimeRange_PERIOD_1_WEEK QueryTimeRange_Period = 4
	// Retrieve data for the last 30 days.
	// Recommended minimum timed count duration: 1 day.
	QueryTimeRange_PERIOD_30_DAYS QueryTimeRange_Period = 5
)

var QueryTimeRange_Period_name = map[int32]string{
	0: "PERIOD_UNSPECIFIED",
	1: "PERIOD_1_HOUR",
	2: "PERIOD_6_HOURS",
	3: "PERIOD_1_DAY",
	4: "PERIOD_1_WEEK",
	5: "PERIOD_30_DAYS",
}

var QueryTimeRange_Period_value = map[string]int32{
	"PERIOD_UNSPECIFIED": 0,
	"PERIOD_1_HOUR":      1,
	"PERIOD_6_HOURS":     2,
	"PERIOD_1_DAY":       3,
	"PERIOD_1_WEEK":      4,
	"PERIOD_30_DAYS":     5,
}

func (x QueryTimeRange_Period) String() string {
	return proto.EnumName(QueryTimeRange_Period_name, int32(x))
}

func (QueryTimeRange_Period) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{6, 0}
}

// Specifies a set of `ErrorGroupStats` to return.
type ListGroupStatsRequest struct {
	// Required. The resource name of the Google Cloud Platform project. Written
	// as <code>projects/</code> plus the
	// <a href="https://support.google.com/cloud/answer/6158840">Google Cloud
	// Platform project ID</a>.
	//
	// Example: <code>projects/my-project-123</code>.
	ProjectName string `protobuf:"bytes,1,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	// Optional. List all <code>ErrorGroupStats</code> with these IDs.
	GroupId []string `protobuf:"bytes,2,rep,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// Optional. List only <code>ErrorGroupStats</code> which belong to a service
	// context that matches the filter.
	// Data for all service contexts is returned if this field is not specified.
	ServiceFilter *ServiceContextFilter `protobuf:"bytes,3,opt,name=service_filter,json=serviceFilter,proto3" json:"service_filter,omitempty"`
	// Optional. List data for the given time range.
	// If not set, a default time range is used. The field
	// <code>time_range_begin</code> in the response will specify the beginning
	// of this time range.
	// Only <code>ErrorGroupStats</code> with a non-zero count in the given time
	// range are returned, unless the request contains an explicit
	// <code>group_id</code> list. If a <code>group_id</code> list is given, also
	// <code>ErrorGroupStats</code> with zero occurrences are returned.
	TimeRange *QueryTimeRange `protobuf:"bytes,5,opt,name=time_range,json=timeRange,proto3" json:"time_range,omitempty"`
	// Optional. The preferred duration for a single returned `TimedCount`.
	// If not set, no timed counts are returned.
	TimedCountDuration *duration.Duration `protobuf:"bytes,6,opt,name=timed_count_duration,json=timedCountDuration,proto3" json:"timed_count_duration,omitempty"`
	// Optional. The alignment of the timed counts to be returned.
	// Default is `ALIGNMENT_EQUAL_AT_END`.
	Alignment TimedCountAlignment `protobuf:"varint,7,opt,name=alignment,proto3,enum=google.devtools.clouderrorreporting.v1beta1.TimedCountAlignment" json:"alignment,omitempty"`
	// Optional. Time where the timed counts shall be aligned if rounded
	// alignment is chosen. Default is 00:00 UTC.
	AlignmentTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=alignment_time,json=alignmentTime,proto3" json:"alignment_time,omitempty"`
	// Optional. The sort order in which the results are returned.
	// Default is `COUNT_DESC`.
	Order ErrorGroupOrder `protobuf:"varint,9,opt,name=order,proto3,enum=google.devtools.clouderrorreporting.v1beta1.ErrorGroupOrder" json:"order,omitempty"`
	// Optional. The maximum number of results to return per response.
	// Default is 20.
	PageSize int32 `protobuf:"varint,11,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A `next_page_token` provided by a previous response. To view
	// additional results, pass this token along with the identical query
	// parameters as the first request.
	PageToken            string   `protobuf:"bytes,12,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListGroupStatsRequest) Reset()         { *m = ListGroupStatsRequest{} }
func (m *ListGroupStatsRequest) String() string { return proto.CompactTextString(m) }
func (*ListGroupStatsRequest) ProtoMessage()    {}
func (*ListGroupStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{0}
}

func (m *ListGroupStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGroupStatsRequest.Unmarshal(m, b)
}
func (m *ListGroupStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGroupStatsRequest.Marshal(b, m, deterministic)
}
func (m *ListGroupStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGroupStatsRequest.Merge(m, src)
}
func (m *ListGroupStatsRequest) XXX_Size() int {
	return xxx_messageInfo_ListGroupStatsRequest.Size(m)
}
func (m *ListGroupStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGroupStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListGroupStatsRequest proto.InternalMessageInfo

func (m *ListGroupStatsRequest) GetProjectName() string {
	if m != nil {
		return m.ProjectName
	}
	return ""
}

func (m *ListGroupStatsRequest) GetGroupId() []string {
	if m != nil {
		return m.GroupId
	}
	return nil
}

func (m *ListGroupStatsRequest) GetServiceFilter() *ServiceContextFilter {
	if m != nil {
		return m.ServiceFilter
	}
	return nil
}

func (m *ListGroupStatsRequest) GetTimeRange() *QueryTimeRange {
	if m != nil {
		return m.TimeRange
	}
	return nil
}

func (m *ListGroupStatsRequest) GetTimedCountDuration() *duration.Duration {
	if m != nil {
		return m.TimedCountDuration
	}
	return nil
}

func (m *ListGroupStatsRequest) GetAlignment() TimedCountAlignment {
	if m != nil {
		return m.Alignment
	}
	return TimedCountAlignment_ERROR_COUNT_ALIGNMENT_UNSPECIFIED
}

func (m *ListGroupStatsRequest) GetAlignmentTime() *timestamp.Timestamp {
	if m != nil {
		return m.AlignmentTime
	}
	return nil
}

func (m *ListGroupStatsRequest) GetOrder() ErrorGroupOrder {
	if m != nil {
		return m.Order
	}
	return ErrorGroupOrder_GROUP_ORDER_UNSPECIFIED
}

func (m *ListGroupStatsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListGroupStatsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Contains a set of requested error group stats.
type ListGroupStatsResponse struct {
	// The error group stats which match the given request.
	ErrorGroupStats []*ErrorGroupStats `protobuf:"bytes,1,rep,name=error_group_stats,json=errorGroupStats,proto3" json:"error_group_stats,omitempty"`
	// If non-empty, more results are available.
	// Pass this token, along with the same query parameters as the first
	// request, to view the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The timestamp specifies the start time to which the request was restricted.
	// The start time is set based on the requested time range. It may be adjusted
	// to a later time if a project has exceeded the storage quota and older data
	// has been deleted.
	TimeRangeBegin       *timestamp.Timestamp `protobuf:"bytes,4,opt,name=time_range_begin,json=timeRangeBegin,proto3" json:"time_range_begin,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListGroupStatsResponse) Reset()         { *m = ListGroupStatsResponse{} }
func (m *ListGroupStatsResponse) String() string { return proto.CompactTextString(m) }
func (*ListGroupStatsResponse) ProtoMessage()    {}
func (*ListGroupStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{1}
}

func (m *ListGroupStatsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGroupStatsResponse.Unmarshal(m, b)
}
func (m *ListGroupStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGroupStatsResponse.Marshal(b, m, deterministic)
}
func (m *ListGroupStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGroupStatsResponse.Merge(m, src)
}
func (m *ListGroupStatsResponse) XXX_Size() int {
	return xxx_messageInfo_ListGroupStatsResponse.Size(m)
}
func (m *ListGroupStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGroupStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListGroupStatsResponse proto.InternalMessageInfo

func (m *ListGroupStatsResponse) GetErrorGroupStats() []*ErrorGroupStats {
	if m != nil {
		return m.ErrorGroupStats
	}
	return nil
}

func (m *ListGroupStatsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListGroupStatsResponse) GetTimeRangeBegin() *timestamp.Timestamp {
	if m != nil {
		return m.TimeRangeBegin
	}
	return nil
}

// Data extracted for a specific group based on certain filter criteria,
// such as a given time period and/or service filter.
type ErrorGroupStats struct {
	// Group data that is independent of the filter criteria.
	Group *ErrorGroup `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// Approximate total number of events in the given group that match
	// the filter criteria.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	// Approximate number of affected users in the given group that
	// match the filter criteria.
	// Users are distinguished by data in the `ErrorContext` of the
	// individual error events, such as their login name or their remote
	// IP address in case of HTTP requests.
	// The number of affected users can be zero even if the number of
	// errors is non-zero if no data was provided from which the
	// affected user could be deduced.
	// Users are counted based on data in the request
	// context that was provided in the error report. If more users are
	// implicitly affected, such as due to a crash of the whole service,
	// this is not reflected here.
	AffectedUsersCount int64 `protobuf:"varint,3,opt,name=affected_users_count,json=affectedUsersCount,proto3" json:"affected_users_count,omitempty"`
	// Approximate number of occurrences over time.
	// Timed counts returned by ListGroups are guaranteed to be:
	//
	// - Inside the requested time interval
	// - Non-overlapping, and
	// - Ordered by ascending time.
	TimedCounts []*TimedCount `protobuf:"bytes,4,rep,name=timed_counts,json=timedCounts,proto3" json:"timed_counts,omitempty"`
	// Approximate first occurrence that was ever seen for this group
	// and which matches the given filter criteria, ignoring the
	// time_range that was specified in the request.
	FirstSeenTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=first_seen_time,json=firstSeenTime,proto3" json:"first_seen_time,omitempty"`
	// Approximate last occurrence that was ever seen for this group and
	// which matches the given filter criteria, ignoring the time_range
	// that was specified in the request.
	LastSeenTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=last_seen_time,json=lastSeenTime,proto3" json:"last_seen_time,omitempty"`
	// Service contexts with a non-zero error count for the given filter
	// criteria. This list can be truncated if multiple services are affected.
	// Refer to `num_affected_services` for the total count.
	AffectedServices []*ServiceContext `protobuf:"bytes,7,rep,name=affected_services,json=affectedServices,proto3" json:"affected_services,omitempty"`
	// The total number of services with a non-zero error count for the given
	// filter criteria.
	NumAffectedServices int32 `protobuf:"varint,8,opt,name=num_affected_services,json=numAffectedServices,proto3" json:"num_affected_services,omitempty"`
	// An arbitrary event that is chosen as representative for the whole group.
	// The representative event is intended to be used as a quick preview for
	// the whole group. Events in the group are usually sufficiently similar
	// to each other such that showing an arbitrary representative provides
	// insight into the characteristics of the group as a whole.
	Representative       *ErrorEvent `protobuf:"bytes,9,opt,name=representative,proto3" json:"representative,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ErrorGroupStats) Reset()         { *m = ErrorGroupStats{} }
func (m *ErrorGroupStats) String() string { return proto.CompactTextString(m) }
func (*ErrorGroupStats) ProtoMessage()    {}
func (*ErrorGroupStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{2}
}

func (m *ErrorGroupStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ErrorGroupStats.Unmarshal(m, b)
}
func (m *ErrorGroupStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ErrorGroupStats.Marshal(b, m, deterministic)
}
func (m *ErrorGroupStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ErrorGroupStats.Merge(m, src)
}
func (m *ErrorGroupStats) XXX_Size() int {
	return xxx_messageInfo_ErrorGroupStats.Size(m)
}
func (m *ErrorGroupStats) XXX_DiscardUnknown() {
	xxx_messageInfo_ErrorGroupStats.DiscardUnknown(m)
}

var xxx_messageInfo_ErrorGroupStats proto.InternalMessageInfo

func (m *ErrorGroupStats) GetGroup() *ErrorGroup {
	if m != nil {
		return m.Group
	}
	return nil
}

func (m *ErrorGroupStats) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *ErrorGroupStats) GetAffectedUsersCount() int64 {
	if m != nil {
		return m.AffectedUsersCount
	}
	return 0
}

func (m *ErrorGroupStats) GetTimedCounts() []*TimedCount {
	if m != nil {
		return m.TimedCounts
	}
	return nil
}

func (m *ErrorGroupStats) GetFirstSeenTime() *timestamp.Timestamp {
	if m != nil {
		return m.FirstSeenTime
	}
	return nil
}

func (m *ErrorGroupStats) GetLastSeenTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastSeenTime
	}
	return nil
}

func (m *ErrorGroupStats) GetAffectedServices() []*ServiceContext {
	if m != nil {
		return m.AffectedServices
	}
	return nil
}

func (m *ErrorGroupStats) GetNumAffectedServices() int32 {
	if m != nil {
		return m.NumAffectedServices
	}
	return 0
}

func (m *ErrorGroupStats) GetRepresentative() *ErrorEvent {
	if m != nil {
		return m.Representative
	}
	return nil
}

// The number of errors in a given time period.
// All numbers are approximate since the error events are sampled
// before counting them.
type TimedCount struct {
	// Approximate number of occurrences in the given time period.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Start of the time period to which `count` refers (included).
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End of the time period to which `count` refers (excluded).
	EndTime              *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TimedCount) Reset()         { *m = TimedCount{} }
func (m *TimedCount) String() string { return proto.CompactTextString(m) }
func (*TimedCount) ProtoMessage()    {}
func (*TimedCount) Descriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{3}
}

func (m *TimedCount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimedCount.Unmarshal(m, b)
}
func (m *TimedCount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimedCount.Marshal(b, m, deterministic)
}
func (m *TimedCount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimedCount.Merge(m, src)
}
func (m *TimedCount) XXX_Size() int {
	return xxx_messageInfo_TimedCount.Size(m)
}
func (m *TimedCount) XXX_DiscardUnknown() {
	xxx_messageInfo_TimedCount.DiscardUnknown(m)
}

var xxx_messageInfo_TimedCount proto.InternalMessageInfo

func (m *TimedCount) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *TimedCount) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TimedCount) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Specifies a set of error events to return.
type ListEventsRequest struct {
	// Required. The resource name of the Google Cloud Platform project. Written
	// as `projects/` plus the
	// [Google Cloud Platform project
	// ID](https://support.google.com/cloud/answer/6158840).
	// Example: `projects/my-project-123`.
	ProjectName string `protobuf:"bytes,1,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	// Required. The group for which events shall be returned.
	GroupId string `protobuf:"bytes,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// Optional. List only ErrorGroups which belong to a service context that
	// matches the filter.
	// Data for all service contexts is returned if this field is not specified.
	ServiceFilter *ServiceContextFilter `protobuf:"bytes,3,opt,name=service_filter,json=serviceFilter,proto3" json:"service_filter,omitempty"`
	// Optional. List only data for the given time range.
	// If not set a default time range is used. The field time_range_begin
	// in the response will specify the beginning of this time range.
	TimeRange *QueryTimeRange `protobuf:"bytes,4,opt,name=time_range,json=timeRange,proto3" json:"time_range,omitempty"`
	// Optional. The maximum number of results to return per response.
	PageSize int32 `protobuf:"varint,6,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A `next_page_token` provided by a previous response.
	PageToken            string   `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEventsRequest) Reset()         { *m = ListEventsRequest{} }
func (m *ListEventsRequest) String() string { return proto.CompactTextString(m) }
func (*ListEventsRequest) ProtoMessage()    {}
func (*ListEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{4}
}

func (m *ListEventsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEventsRequest.Unmarshal(m, b)
}
func (m *ListEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEventsRequest.Marshal(b, m, deterministic)
}
func (m *ListEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEventsRequest.Merge(m, src)
}
func (m *ListEventsRequest) XXX_Size() int {
	return xxx_messageInfo_ListEventsRequest.Size(m)
}
func (m *ListEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListEventsRequest proto.InternalMessageInfo

func (m *ListEventsRequest) GetProjectName() string {
	if m != nil {
		return m.ProjectName
	}
	return ""
}

func (m *ListEventsRequest) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *ListEventsRequest) GetServiceFilter() *ServiceContextFilter {
	if m != nil {
		return m.ServiceFilter
	}
	return nil
}

func (m *ListEventsRequest) GetTimeRange() *QueryTimeRange {
	if m != nil {
		return m.TimeRange
	}
	return nil
}

func (m *ListEventsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListEventsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Contains a set of requested error events.
type ListEventsResponse struct {
	// The error events which match the given request.
	ErrorEvents []*ErrorEvent `protobuf:"bytes,1,rep,name=error_events,json=errorEvents,proto3" json:"error_events,omitempty"`
	// If non-empty, more results are available.
	// Pass this token, along with the same query parameters as the first
	// request, to view the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The timestamp specifies the start time to which the request was restricted.
	TimeRangeBegin       *timestamp.Timestamp `protobuf:"bytes,4,opt,name=time_range_begin,json=timeRangeBegin,proto3" json:"time_range_begin,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListEventsResponse) Reset()         { *m = ListEventsResponse{} }
func (m *ListEventsResponse) String() string { return proto.CompactTextString(m) }
func (*ListEventsResponse) ProtoMessage()    {}
func (*ListEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{5}
}

func (m *ListEventsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEventsResponse.Unmarshal(m, b)
}
func (m *ListEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEventsResponse.Marshal(b, m, deterministic)
}
func (m *ListEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEventsResponse.Merge(m, src)
}
func (m *ListEventsResponse) XXX_Size() int {
	return xxx_messageInfo_ListEventsResponse.Size(m)
}
func (m *ListEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEventsResponse proto.InternalMessageInfo

func (m *ListEventsResponse) GetErrorEvents() []*ErrorEvent {
	if m != nil {
		return m.ErrorEvents
	}
	return nil
}

func (m *ListEventsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListEventsResponse) GetTimeRangeBegin() *timestamp.Timestamp {
	if m != nil {
		return m.TimeRangeBegin
	}
	return nil
}

// Requests might be rejected or the resulting timed count durations might be
// adjusted for lower durations.
type QueryTimeRange struct {
	// Restricts the query to the specified time range.
	Period               QueryTimeRange_Period `protobuf:"varint,1,opt,name=period,proto3,enum=google.devtools.clouderrorreporting.v1beta1.QueryTimeRange_Period" json:"period,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *QueryTimeRange) Reset()         { *m = QueryTimeRange{} }
func (m *QueryTimeRange) String() string { return proto.CompactTextString(m) }
func (*QueryTimeRange) ProtoMessage()    {}
func (*QueryTimeRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{6}
}

func (m *QueryTimeRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryTimeRange.Unmarshal(m, b)
}
func (m *QueryTimeRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryTimeRange.Marshal(b, m, deterministic)
}
func (m *QueryTimeRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryTimeRange.Merge(m, src)
}
func (m *QueryTimeRange) XXX_Size() int {
	return xxx_messageInfo_QueryTimeRange.Size(m)
}
func (m *QueryTimeRange) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryTimeRange.DiscardUnknown(m)
}

var xxx_messageInfo_QueryTimeRange proto.InternalMessageInfo

func (m *QueryTimeRange) GetPeriod() QueryTimeRange_Period {
	if m != nil {
		return m.Period
	}
	return QueryTimeRange_PERIOD_UNSPECIFIED
}

// Specifies criteria for filtering a subset of service contexts.
// The fields in the filter correspond to the fields in `ServiceContext`.
// Only exact, case-sensitive matches are supported.
// If a field is unset or empty, it matches arbitrary values.
type ServiceContextFilter struct {
	// Optional. The exact value to match against
	// [`ServiceContext.service`](/error-reporting/reference/rest/v1beta1/ServiceContext#FIELDS.service).
	Service string `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	// Optional. The exact value to match against
	// [`ServiceContext.version`](/error-reporting/reference/rest/v1beta1/ServiceContext#FIELDS.version).
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. The exact value to match against
	// [`ServiceContext.resource_type`](/error-reporting/reference/rest/v1beta1/ServiceContext#FIELDS.resource_type).
	ResourceType         string   `protobuf:"bytes,4,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServiceContextFilter) Reset()         { *m = ServiceContextFilter{} }
func (m *ServiceContextFilter) String() string { return proto.CompactTextString(m) }
func (*ServiceContextFilter) ProtoMessage()    {}
func (*ServiceContextFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{7}
}

func (m *ServiceContextFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServiceContextFilter.Unmarshal(m, b)
}
func (m *ServiceContextFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServiceContextFilter.Marshal(b, m, deterministic)
}
func (m *ServiceContextFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceContextFilter.Merge(m, src)
}
func (m *ServiceContextFilter) XXX_Size() int {
	return xxx_messageInfo_ServiceContextFilter.Size(m)
}
func (m *ServiceContextFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceContextFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceContextFilter proto.InternalMessageInfo

func (m *ServiceContextFilter) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *ServiceContextFilter) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ServiceContextFilter) GetResourceType() string {
	if m != nil {
		return m.ResourceType
	}
	return ""
}

// Deletes all events in the project.
type DeleteEventsRequest struct {
	// Required. The resource name of the Google Cloud Platform project. Written
	// as `projects/` plus the
	// [Google Cloud Platform project
	// ID](https://support.google.com/cloud/answer/6158840).
	// Example: `projects/my-project-123`.
	ProjectName          string   `protobuf:"bytes,1,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteEventsRequest) Reset()         { *m = DeleteEventsRequest{} }
func (m *DeleteEventsRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteEventsRequest) ProtoMessage()    {}
func (*DeleteEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{8}
}

func (m *DeleteEventsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteEventsRequest.Unmarshal(m, b)
}
func (m *DeleteEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteEventsRequest.Marshal(b, m, deterministic)
}
func (m *DeleteEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteEventsRequest.Merge(m, src)
}
func (m *DeleteEventsRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteEventsRequest.Size(m)
}
func (m *DeleteEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteEventsRequest proto.InternalMessageInfo

func (m *DeleteEventsRequest) GetProjectName() string {
	if m != nil {
		return m.ProjectName
	}
	return ""
}

// Response message for deleting error events.
type DeleteEventsResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteEventsResponse) Reset()         { *m = DeleteEventsResponse{} }
func (m *DeleteEventsResponse) String() string { return proto.CompactTextString(m) }
func (*DeleteEventsResponse) ProtoMessage()    {}
func (*DeleteEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ab5fabd294dba66f, []int{9}
}

func (m *DeleteEventsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteEventsResponse.Unmarshal(m, b)
}
func (m *DeleteEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteEventsResponse.Marshal(b, m, deterministic)
}
func (m *DeleteEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteEventsResponse.Merge(m, src)
}
func (m *DeleteEventsResponse) XXX_Size() int {
	return xxx_messageInfo_DeleteEventsResponse.Size(m)
}
func (m *DeleteEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteEventsResponse proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("google.devtools.clouderrorreporting.v1beta1.TimedCountAlignment", TimedCountAlignment_name, TimedCountAlignment_value)
	proto.RegisterEnum("google.devtools.clouderrorreporting.v1beta1.ErrorGroupOrder", ErrorGroupOrder_name, ErrorGroupOrder_value)
	proto.RegisterEnum("google.devtools.clouderrorreporting.v1beta1.QueryTimeRange_Period", QueryTimeRange_Period_name, QueryTimeRange_Period_value)
	proto.RegisterType((*ListGroupStatsRequest)(nil), "google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest")
	proto.RegisterType((*ListGroupStatsResponse)(nil), "google.devtools.clouderrorreporting.v1beta1.ListGroupStatsResponse")
	proto.RegisterType((*ErrorGroupStats)(nil), "google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats")
	proto.RegisterType((*TimedCount)(nil), "google.devtools.clouderrorreporting.v1beta1.TimedCount")
	proto.RegisterType((*ListEventsRequest)(nil), "google.devtools.clouderrorreporting.v1beta1.ListEventsRequest")
	proto.RegisterType((*ListEventsResponse)(nil), "google.devtools.clouderrorreporting.v1beta1.ListEventsResponse")
	proto.RegisterType((*QueryTimeRange)(nil), "google.devtools.clouderrorreporting.v1beta1.QueryTimeRange")
	proto.RegisterType((*ServiceContextFilter)(nil), "google.devtools.clouderrorreporting.v1beta1.ServiceContextFilter")
	proto.RegisterType((*DeleteEventsRequest)(nil), "google.devtools.clouderrorreporting.v1beta1.DeleteEventsRequest")
	proto.RegisterType((*DeleteEventsResponse)(nil), "google.devtools.clouderrorreporting.v1beta1.DeleteEventsResponse")
}

func init() {
	proto.RegisterFile("google/devtools/clouderrorreporting/v1beta1/error_stats_service.proto", fileDescriptor_ab5fabd294dba66f)
}

var fileDescriptor_ab5fabd294dba66f = []byte{
	// 1483 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xcb, 0x6f, 0x1b, 0x55,
	0x17, 0xff, 0xc6, 0x8e, 0xf3, 0x38, 0x71, 0x1c, 0xe7, 0x26, 0x4d, 0x5c, 0x7f, 0xdf, 0xd7, 0x2f,
	0x9f, 0x11, 0x28, 0xa4, 0xd4, 0x6e, 0x52, 0x41, 0x81, 0xf2, 0xe8, 0xd8, 0x9e, 0x84, 0x88, 0xd4,
	0x76, 0xc7, 0x76, 0x2a, 0xa2, 0x8a, 0xd1, 0xc4, 0x3e, 0x71, 0x06, 0x3c, 0x0f, 0x66, 0xae, 0xd3,
	0x07, 0x2a, 0x42, 0xec, 0x10, 0x4b, 0xf8, 0x07, 0xd8, 0xf2, 0xa7, 0x74, 0x09, 0x42, 0x42, 0x5d,
	0xa0, 0x2e, 0x58, 0xb1, 0x81, 0x25, 0xaa, 0x84, 0x84, 0xee, 0x63, 0xfc, 0xaa, 0xa5, 0xd4, 0x09,
	0xaa, 0xd8, 0xf9, 0x9e, 0xc7, 0xef, 0x9c, 0x73, 0xef, 0xef, 0x9c, 0x7b, 0xc7, 0xa0, 0xb5, 0x5c,
	0xb7, 0xd5, 0xc6, 0x5c, 0x13, 0x8f, 0xa9, 0xeb, 0xb6, 0x83, 0x5c, 0xa3, 0xed, 0x76, 0x9a, 0xe8,
	0xfb, 0xae, 0xef, 0xa3, 0xe7, 0xfa, 0xd4, 0x72, 0x5a, 0xb9, 0xe3, 0x8d, 0x03, 0xa4, 0xe6, 0x46,
	0x8e, 0x8b, 0x8d, 0x80, 0x9a, 0x34, 0x30, 0x02, 0xf4, 0x8f, 0xad, 0x06, 0x66, 0x3d, 0xdf, 0xa5,
	0x2e, 0xb9, 0x28, 0x60, 0xb2, 0x21, 0x4c, 0x76, 0x04, 0x4c, 0x56, 0xc2, 0xa4, 0xff, 0x23, 0x63,
	0x9a, 0x9e, 0x95, 0x33, 0x1d, 0xc7, 0xa5, 0x26, 0xb5, 0x5c, 0x27, 0x10, 0x50, 0xe9, 0x95, 0x3e,
	0x6d, 0xa3, 0x6d, 0xa1, 0x43, 0xa5, 0xe2, 0x7f, 0x7d, 0x8a, 0x43, 0x0b, 0xdb, 0x4d, 0xe3, 0x00,
	0x8f, 0xcc, 0x63, 0xcb, 0xf5, 0xa5, 0xc1, 0xf9, 0x3e, 0x03, 0x1f, 0x03, 0xb7, 0xe3, 0x87, 0xf9,
	0xa5, 0x5f, 0x1f, 0xa7, 0xcc, 0x86, 0x6b, 0xdb, 0xae, 0x23, 0x3d, 0x2f, 0x48, 0x4f, 0xbe, 0x3a,
	0xe8, 0x1c, 0xe6, 0x9a, 0x1d, 0x9f, 0xe7, 0x3b, 0x94, 0x55, 0x57, 0x4f, 0x2d, 0x1b, 0x03, 0x6a,
	0xda, 0x9e, 0x30, 0xc8, 0xfc, 0x19, 0x83, 0x73, 0xbb, 0x56, 0x40, 0xb7, 0x7d, 0xb7, 0xe3, 0x55,
	0xd9, 0xde, 0xe9, 0xf8, 0x49, 0x07, 0x03, 0x4a, 0xf6, 0x20, 0xee, 0xf9, 0xee, 0x47, 0xd8, 0xa0,
	0x86, 0x63, 0xda, 0x98, 0x52, 0x56, 0x95, 0xb5, 0x99, 0xfc, 0x95, 0xc7, 0x6a, 0xe4, 0x89, 0x7a,
	0x09, 0x2e, 0xf2, 0x14, 0xc3, 0x3a, 0x6c, 0xd3, 0x31, 0x5b, 0xe8, 0x67, 0x45, 0x34, 0xd3, 0xb3,
	0x82, 0x6c, 0xc3, 0xb5, 0x73, 0x15, 0xe1, 0xaf, 0xcf, 0x4a, 0xa0, 0x92, 0x69, 0x23, 0xb9, 0x00,
	0xd3, 0x2d, 0x16, 0xcc, 0xb0, 0x9a, 0xa9, 0xc8, 0x6a, 0x74, 0x6d, 0x26, 0x1f, 0x7d, 0xac, 0x2a,
	0xfa, 0x14, 0x17, 0xee, 0x34, 0x89, 0x0d, 0x09, 0x79, 0x7a, 0xc6, 0xa1, 0xd5, 0xa6, 0xe8, 0xa7,
	0xa2, 0xab, 0xca, 0xda, 0xec, 0xa6, 0x9a, 0x1d, 0xe3, 0x14, 0xb3, 0x55, 0x01, 0x51, 0x70, 0x1d,
	0x8a, 0x77, 0xe9, 0x16, 0x07, 0x12, 0x81, 0xe6, 0x24, 0xba, 0x90, 0x11, 0x03, 0x80, 0xed, 0x89,
	0xe1, 0x9b, 0x4e, 0x0b, 0x53, 0x31, 0x1e, 0xea, 0xda, 0x58, 0xa1, 0x6e, 0x76, 0xd0, 0xbf, 0x57,
	0xb3, 0x6c, 0xd4, 0x19, 0x84, 0x08, 0x32, 0x43, 0xc3, 0x35, 0xa9, 0xc0, 0x12, 0x5b, 0x34, 0x8d,
	0x86, 0xdb, 0x71, 0xa8, 0x11, 0x1e, 0x50, 0x6a, 0x92, 0x87, 0x3a, 0x1f, 0x86, 0x0a, 0x4f, 0x28,
	0x5b, 0x94, 0x06, 0x02, 0x88, 0x70, 0xdf, 0x02, 0x73, 0x0d, 0x15, 0xa4, 0x01, 0x33, 0x66, 0xdb,
	0x6a, 0x39, 0x36, 0x3a, 0x34, 0x35, 0xb5, 0xaa, 0xac, 0x25, 0x36, 0xaf, 0x8f, 0x95, 0x71, 0xad,
	0x8b, 0xa9, 0x86, 0x38, 0x32, 0xed, 0x2e, 0x2e, 0xd9, 0x82, 0x44, 0x77, 0x61, 0xb0, 0x24, 0x52,
	0xd3, 0x3c, 0xe1, 0xf4, 0x53, 0x09, 0xd7, 0x42, 0x4a, 0xc9, 0xfd, 0xed, 0xba, 0x31, 0x05, 0xb9,
	0x05, 0x31, 0xd7, 0x6f, 0xa2, 0x9f, 0x9a, 0xe1, 0x89, 0xbe, 0x35, 0x56, 0xa2, 0x1a, 0x13, 0x73,
	0x6a, 0x96, 0x19, 0x86, 0x08, 0x20, 0xf0, 0xc8, 0x2a, 0xcc, 0x78, 0x66, 0x0b, 0x8d, 0xc0, 0xba,
	0x8f, 0xa9, 0xd9, 0x55, 0x65, 0x2d, 0x26, 0xd4, 0xd3, 0x4c, 0x5a, 0xb5, 0xee, 0x23, 0xc9, 0x00,
	0x70, 0x0b, 0xea, 0x7e, 0x8c, 0x4e, 0x2a, 0xce, 0xf9, 0x2b, 0xca, 0x64, 0xe2, 0x1a, 0x93, 0x66,
	0x7e, 0x57, 0x60, 0x79, 0x98, 0xff, 0x81, 0xe7, 0x3a, 0x01, 0x92, 0x23, 0x58, 0x10, 0x23, 0x45,
	0xd0, 0x95, 0x0f, 0x96, 0x94, 0xb2, 0x1a, 0x5d, 0x9b, 0x3d, 0x75, 0x15, 0x22, 0xc0, 0x3c, 0x0e,
	0x0a, 0xc8, 0x4b, 0x30, 0xef, 0xe0, 0x5d, 0x6a, 0xf4, 0x65, 0x1b, 0x61, 0xd9, 0xea, 0x73, 0x4c,
	0x5c, 0x09, 0x93, 0x25, 0x45, 0x48, 0xf6, 0xb8, 0x6a, 0x1c, 0x60, 0xcb, 0x72, 0x52, 0x13, 0x27,
	0x9d, 0x8a, 0x9e, 0xe8, 0x72, 0x31, 0xcf, 0x3c, 0x32, 0x5f, 0xc6, 0x60, 0x7e, 0x28, 0x25, 0x72,
	0x03, 0x62, 0xbc, 0x4a, 0xde, 0xe5, 0xb3, 0x9b, 0x57, 0x4f, 0x59, 0x9f, 0x2e, 0x50, 0xc8, 0x12,
	0xc4, 0x38, 0xdb, 0x79, 0x19, 0x51, 0x5d, 0x2c, 0xc8, 0x65, 0x58, 0x32, 0x0f, 0x0f, 0xb1, 0x41,
	0xb1, 0x69, 0x74, 0x02, 0xf4, 0x03, 0xd1, 0x12, 0xbc, 0xbf, 0xa3, 0x3a, 0x09, 0x75, 0x75, 0xa6,
	0xe2, 0xec, 0x24, 0xfb, 0x10, 0xef, 0xeb, 0x9d, 0x20, 0x35, 0xc1, 0x77, 0xff, 0xea, 0x29, 0xc9,
	0xae, 0xcf, 0xf6, 0x9a, 0x29, 0x20, 0x79, 0x98, 0x3f, 0xb4, 0xfc, 0x80, 0x1a, 0x01, 0xa2, 0x23,
	0x18, 0x1e, 0x3b, 0x71, 0x2f, 0xe7, 0xb8, 0x4b, 0x15, 0xd1, 0xe1, 0xe4, 0xbe, 0x0e, 0x89, 0xb6,
	0x39, 0x00, 0x31, 0x79, 0x22, 0x44, 0x9c, 0x79, 0x74, 0x11, 0x8e, 0x60, 0xa1, 0xbb, 0x27, 0x72,
	0x30, 0x05, 0xa9, 0x29, 0x5e, 0xe6, 0xb5, 0x33, 0x0c, 0x3c, 0x3d, 0x19, 0xa2, 0x4a, 0x79, 0x40,
	0x36, 0xe1, 0x9c, 0xd3, 0xb1, 0x8d, 0xa7, 0xa3, 0xb1, 0xbe, 0x8e, 0xe9, 0x8b, 0x4e, 0xc7, 0x56,
	0x87, 0x7d, 0x0c, 0x48, 0xf8, 0xe8, 0xf9, 0x18, 0xa0, 0xc3, 0xae, 0xc1, 0x63, 0xe4, 0x5d, 0x7c,
	0x2a, 0x7e, 0x68, 0xc7, 0xe8, 0x50, 0x7d, 0x08, 0x2e, 0xf3, 0x8d, 0x02, 0xd0, 0x3b, 0xa0, 0x1e,
	0x6f, 0x94, 0x7e, 0xde, 0xbc, 0x01, 0x10, 0x50, 0xd3, 0x97, 0x63, 0x28, 0x72, 0xe2, 0x0e, 0xcf,
	0x70, 0x6b, 0xbe, 0xbd, 0xaf, 0xc2, 0x34, 0x3a, 0x4d, 0xe1, 0x18, 0x3d, 0xd1, 0x71, 0x0a, 0x9d,
	0x26, 0x5b, 0x65, 0xbe, 0x8d, 0xc2, 0x02, 0x9b, 0x0a, 0x3c, 0xe9, 0xe7, 0x7c, 0x23, 0xca, 0x29,
	0x15, 0xf9, 0x87, 0xdc, 0x88, 0x13, 0x7f, 0xff, 0x8d, 0x38, 0x30, 0xb9, 0x27, 0x4f, 0x9e, 0xdc,
	0x53, 0x23, 0x27, 0xf7, 0xcf, 0x0a, 0x90, 0xfe, 0x33, 0x92, 0x53, 0x7b, 0x1f, 0xe2, 0x62, 0x6a,
	0x23, 0x97, 0xcb, 0x81, 0x7d, 0x6a, 0xc2, 0xce, 0x62, 0xf7, 0xf7, 0xf3, 0x9e, 0xd3, 0xbf, 0x29,
	0x90, 0x18, 0xdc, 0x49, 0xb2, 0x0f, 0x93, 0x1e, 0xfa, 0x96, 0xdb, 0xe4, 0xdc, 0x4b, 0x6c, 0xe6,
	0xcf, 0x70, 0x2c, 0xd9, 0x0a, 0x47, 0xd2, 0x25, 0x62, 0xe6, 0x73, 0x05, 0x26, 0x85, 0x88, 0x2c,
	0x03, 0xa9, 0x68, 0xfa, 0x4e, 0xb9, 0x68, 0xd4, 0x4b, 0xd5, 0x8a, 0x56, 0xd8, 0xd9, 0xda, 0xd1,
	0x8a, 0xc9, 0x7f, 0x91, 0x05, 0x98, 0x93, 0xf2, 0x0d, 0xe3, 0xbd, 0x72, 0x5d, 0x4f, 0x2a, 0x84,
	0x40, 0x42, 0x8a, 0x5e, 0xe3, 0xa2, 0x6a, 0x32, 0x42, 0x92, 0x10, 0xef, 0x9a, 0x15, 0xd5, 0x0f,
	0x92, 0xd1, 0x01, 0xc7, 0x5b, 0x9a, 0xf6, 0x7e, 0x72, 0xa2, 0xcf, 0xf1, 0xca, 0x65, 0x66, 0x55,
	0x4d, 0xc6, 0x32, 0x9f, 0xc1, 0xd2, 0x28, 0x96, 0x92, 0xff, 0xc2, 0x94, 0xa4, 0x68, 0xaf, 0x3f,
	0x14, 0x3d, 0x94, 0x31, 0xf5, 0x31, 0xfa, 0x01, 0x7b, 0x54, 0x45, 0xfb, 0xd4, 0x52, 0x46, 0xd6,
	0x60, 0x2e, 0xec, 0x4a, 0x83, 0xde, 0xf3, 0x04, 0xa5, 0xa5, 0x51, 0x3c, 0xd4, 0xd4, 0xee, 0x79,
	0x98, 0xb1, 0x61, 0xb1, 0x88, 0x6d, 0xa4, 0xf8, 0x5c, 0xfa, 0x3e, 0xb3, 0x0c, 0x4b, 0x83, 0xe1,
	0x04, 0x85, 0xd7, 0x3b, 0xb0, 0x38, 0xe2, 0x85, 0x46, 0x5e, 0x84, 0xff, 0x6b, 0xba, 0x5e, 0xd6,
	0x8d, 0x42, 0xb9, 0x5e, 0xaa, 0x19, 0xea, 0xee, 0xce, 0x76, 0xe9, 0x86, 0x56, 0xaa, 0x0d, 0x1d,
	0xd2, 0xbf, 0x61, 0xa5, 0xa7, 0xd2, 0x6e, 0xd6, 0xd5, 0x5d, 0x43, 0x2f, 0xd7, 0x4b, 0x45, 0xad,
	0x98, 0x54, 0x48, 0x1a, 0x96, 0x87, 0x95, 0x6a, 0xcd, 0xd0, 0x4a, 0xc5, 0x64, 0x64, 0xfd, 0x41,
	0xff, 0xb3, 0x80, 0xbf, 0xb7, 0x18, 0xd6, 0xb6, 0x5e, 0xae, 0x57, 0x8c, 0xb2, 0x5e, 0xd4, 0xf4,
	0xa1, 0x40, 0x09, 0x00, 0x91, 0x49, 0x51, 0xab, 0x16, 0x04, 0x15, 0x76, 0xd5, 0x6a, 0xcd, 0xa8,
	0x6a, 0x5a, 0x49, 0xc8, 0x38, 0x15, 0x0a, 0xba, 0xa6, 0xd6, 0xb4, 0xa2, 0x90, 0x44, 0xc9, 0x0a,
	0x2c, 0xaa, 0x5b, 0x5b, 0x5a, 0x81, 0x89, 0xea, 0x55, 0x4d, 0xaf, 0x0a, 0xc5, 0xc4, 0xe6, 0x57,
	0x93, 0xb0, 0xc0, 0xe3, 0xf3, 0x17, 0x89, 0xe4, 0x01, 0xf9, 0x55, 0x81, 0xc4, 0xe0, 0xfb, 0x8c,
	0x8c, 0x47, 0xfa, 0x91, 0x1f, 0x37, 0xe9, 0xc2, 0x99, 0x30, 0xc4, 0x39, 0x65, 0xca, 0x8f, 0xd4,
	0x95, 0x7e, 0x62, 0xbc, 0xd2, 0x6b, 0xfa, 0x2f, 0x7e, 0xf8, 0xe5, 0xeb, 0x48, 0x8e, 0x5c, 0xea,
	0x7e, 0xb5, 0x7d, 0xda, 0x6f, 0xf8, 0xb6, 0x5c, 0x04, 0xb9, 0xf5, 0x07, 0xb9, 0x56, 0xaf, 0xb2,
	0x9f, 0x14, 0x80, 0xde, 0x48, 0x23, 0xef, 0x8c, 0x9d, 0xe4, 0x00, 0x6f, 0xd3, 0xef, 0x9e, 0xda,
	0x5f, 0x16, 0xb8, 0xf3, 0x48, 0x3d, 0x37, 0x50, 0x60, 0x78, 0x4d, 0xf1, 0xf2, 0x2e, 0x92, 0x97,
	0x9f, 0xa1, 0x3c, 0x31, 0x86, 0xc9, 0x8f, 0x0a, 0xc4, 0xfb, 0xc9, 0x4e, 0xc6, 0xfb, 0x62, 0x19,
	0xd1, 0x96, 0x69, 0xf5, 0x0c, 0x08, 0xb2, 0xc0, 0xeb, 0x8f, 0xd4, 0x81, 0xd6, 0x16, 0x75, 0xad,
	0x3f, 0x7b, 0x5d, 0xe9, 0xbd, 0x87, 0x6a, 0x66, 0x54, 0xd8, 0xc1, 0xfe, 0xff, 0x5e, 0xcd, 0x1e,
	0x51, 0xea, 0x05, 0x6f, 0xe6, 0x72, 0x77, 0xee, 0xdc, 0x19, 0x1e, 0x0e, 0x66, 0x87, 0x1e, 0x89,
	0x4f, 0xfe, 0x4b, 0x5e, 0xdb, 0xa4, 0x87, 0xae, 0x6f, 0xe7, 0x9f, 0x28, 0xc0, 0xbe, 0xf4, 0xc7,
	0x29, 0x31, 0xbf, 0xfc, 0x54, 0xfb, 0x54, 0xd8, 0x2d, 0x53, 0x51, 0xf6, 0x3f, 0x94, 0x30, 0x2d,
	0xb7, 0x6d, 0x3a, 0xad, 0xac, 0xeb, 0xb7, 0x72, 0x2d, 0x74, 0xf8, 0x1d, 0x94, 0xeb, 0x25, 0xf3,
	0x4c, 0xff, 0x3f, 0x5c, 0x1b, 0xa1, 0xfb, 0x43, 0x51, 0xbe, 0x8b, 0xbc, 0xb0, 0x2d, 0x62, 0x14,
	0x98, 0x5e, 0x5c, 0xa1, 0x7a, 0x37, 0xc5, 0xbd, 0x8d, 0x3c, 0x73, 0x7e, 0x18, 0x5a, 0xdd, 0xe6,
	0x56, 0xb7, 0x07, 0xad, 0x6e, 0xef, 0x89, 0x10, 0x07, 0x93, 0x3c, 0xb3, 0x2b, 0x7f, 0x05, 0x00,
	0x00, 0xff, 0xff, 0x8e, 0xc2, 0x05, 0xeb, 0xff, 0x11, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ErrorStatsServiceClient is the client API for ErrorStatsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ErrorStatsServiceClient interface {
	// Lists the specified groups.
	ListGroupStats(ctx context.Context, in *ListGroupStatsRequest, opts ...grpc.CallOption) (*ListGroupStatsResponse, error)
	// Lists the specified events.
	ListEvents(ctx context.Context, in *ListEventsRequest, opts ...grpc.CallOption) (*ListEventsResponse, error)
	// Deletes all error events of a given project.
	DeleteEvents(ctx context.Context, in *DeleteEventsRequest, opts ...grpc.CallOption) (*DeleteEventsResponse, error)
}

type errorStatsServiceClient struct {
	cc *grpc.ClientConn
}

func NewErrorStatsServiceClient(cc *grpc.ClientConn) ErrorStatsServiceClient {
	return &errorStatsServiceClient{cc}
}

func (c *errorStatsServiceClient) ListGroupStats(ctx context.Context, in *ListGroupStatsRequest, opts ...grpc.CallOption) (*ListGroupStatsResponse, error) {
	out := new(ListGroupStatsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/ListGroupStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *errorStatsServiceClient) ListEvents(ctx context.Context, in *ListEventsRequest, opts ...grpc.CallOption) (*ListEventsResponse, error) {
	out := new(ListEventsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/ListEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *errorStatsServiceClient) DeleteEvents(ctx context.Context, in *DeleteEventsRequest, opts ...grpc.CallOption) (*DeleteEventsResponse, error) {
	out := new(DeleteEventsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/DeleteEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ErrorStatsServiceServer is the server API for ErrorStatsService service.
type ErrorStatsServiceServer interface {
	// Lists the specified groups.
	ListGroupStats(context.Context, *ListGroupStatsRequest) (*ListGroupStatsResponse, error)
	// Lists the specified events.
	ListEvents(context.Context, *ListEventsRequest) (*ListEventsResponse, error)
	// Deletes all error events of a given project.
	DeleteEvents(context.Context, *DeleteEventsRequest) (*DeleteEventsResponse, error)
}

// UnimplementedErrorStatsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedErrorStatsServiceServer struct {
}

func (*UnimplementedErrorStatsServiceServer) ListGroupStats(ctx context.Context, req *ListGroupStatsRequest) (*ListGroupStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGroupStats not implemented")
}
func (*UnimplementedErrorStatsServiceServer) ListEvents(ctx context.Context, req *ListEventsRequest) (*ListEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEvents not implemented")
}
func (*UnimplementedErrorStatsServiceServer) DeleteEvents(ctx context.Context, req *DeleteEventsRequest) (*DeleteEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEvents not implemented")
}

func RegisterErrorStatsServiceServer(s *grpc.Server, srv ErrorStatsServiceServer) {
	s.RegisterService(&_ErrorStatsService_serviceDesc, srv)
}

func _ErrorStatsService_ListGroupStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGroupStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorStatsServiceServer).ListGroupStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/ListGroupStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorStatsServiceServer).ListGroupStats(ctx, req.(*ListGroupStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ErrorStatsService_ListEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorStatsServiceServer).ListEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/ListEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorStatsServiceServer).ListEvents(ctx, req.(*ListEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ErrorStatsService_DeleteEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorStatsServiceServer).DeleteEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/DeleteEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorStatsServiceServer).DeleteEvents(ctx, req.(*DeleteEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ErrorStatsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.clouderrorreporting.v1beta1.ErrorStatsService",
	HandlerType: (*ErrorStatsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListGroupStats",
			Handler:    _ErrorStatsService_ListGroupStats_Handler,
		},
		{
			MethodName: "ListEvents",
			Handler:    _ErrorStatsService_ListEvents_Handler,
		},
		{
			MethodName: "DeleteEvents",
			Handler:    _ErrorStatsService_DeleteEvents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/clouderrorreporting/v1beta1/error_stats_service.proto",
}
