// Package  implements the Azure ARM  service API version v1.
//
// Composite Swagger for Application Insights Data Client
package insights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

const (
	// DefaultBaseURI is the default URI used for the service
	DefaultBaseURI = "https://api.applicationinsights.io/v1"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// BaseClient is the base client for .
type BaseClient struct {
	autorest.Client
	BaseURI string
	AppID   string
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// New creates an instance of the BaseClient client.
func New(appID string) BaseClient {
	return NewWithBaseURI(DefaultBaseURI, appID)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// NewWithBaseURI creates an instance of the BaseClient client.
func NewWithBaseURI(baseURI string, appID string) BaseClient {
	return BaseClient{
		Client:  autorest.NewClientWithUserAgent(UserAgent()),
		BaseURI: baseURI,
		AppID:   appID,
	}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetEventMethod gets the data for a single event
//
// eventType is the type of events to query; either a standard event type (`traces`, `customEvents`, `pageViews`,
// `requests`, `dependencies`, `exceptions`, `availabilityResults`) or `$all` to query across all event types.
// eventID is ID of event. timespan is optional. The timespan over which to retrieve events. This is an ISO8601
// time period value.  This timespan is applied in addition to any that are specified in the Odata expression.
func (client BaseClient) GetEventMethod(ctx context.Context, eventType EventTypeEnum, eventID string, timespan *string) (result EventsResultsType, err error) {
	req, err := client.GetEventMethodPreparer(ctx, eventType, eventID, timespan)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetEventMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEventMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetEventMethod", resp, "Failure sending request")
		return
	}

	result, err = client.GetEventMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetEventMethod", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetEventMethodPreparer prepares the GetEventMethod request.
func (client BaseClient) GetEventMethodPreparer(ctx context.Context, eventType EventTypeEnum, eventID string, timespan *string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", client.AppID),
		"eventId":   autorest.Encode("path", eventID),
		"eventType": autorest.Encode("path", eventType),
	}

	queryParameters := map[string]interface{}{}
	if timespan != nil {
		queryParameters["timespan"] = autorest.Encode("query", *timespan)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/apps/{appId}/events/{eventType}/{eventId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetEventMethodSender sends the GetEventMethod request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetEventMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetEventMethodResponder handles the response to the GetEventMethod request. The method always
// closes the http.Response Body.
func (client BaseClient) GetEventMethodResponder(resp *http.Response) (result EventsResultsType, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetEventsMetadataODataMethod gets OData EDMX metadata describing the event data model
func (client BaseClient) GetEventsMetadataODataMethod(ctx context.Context) (result SetObjectType, err error) {
	req, err := client.GetEventsMetadataODataMethodPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetEventsMetadataODataMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEventsMetadataODataMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetEventsMetadataODataMethod", resp, "Failure sending request")
		return
	}

	result, err = client.GetEventsMetadataODataMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetEventsMetadataODataMethod", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetEventsMetadataODataMethodPreparer prepares the GetEventsMetadataODataMethod request.
func (client BaseClient) GetEventsMetadataODataMethodPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", client.AppID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/apps/{appId}/events/$metadata", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetEventsMetadataODataMethodSender sends the GetEventsMetadataODataMethod request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetEventsMetadataODataMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetEventsMetadataODataMethodResponder handles the response to the GetEventsMetadataODataMethod request. The method always
// closes the http.Response Body.
func (client BaseClient) GetEventsMetadataODataMethodResponder(resp *http.Response) (result SetObjectType, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetEventsMethod executes an OData query for events
//
// eventType is the type of events to query; either a standard event type (`traces`, `customEvents`, `pageViews`,
// `requests`, `dependencies`, `exceptions`, `availabilityResults`) or `$all` to query across all event types.
// timespan is optional. The timespan over which to retrieve events. This is an ISO8601 time period value.  This
// timespan is applied in addition to any that are specified in the Odata expression. filter is an expression used
// to filter the returned events search is a free-text search expression to match for whether a particular event
// should be returned orderby is a comma-separated list of properties with \"asc\" (the default) or \"desc\" to
// control the order of returned events selectParameter is limits the properties to just those requested on each
// returned event skip is the number of items to skip over before returning events top is the number of events to
// return formatParameter is format for the returned events count is request a count of matching items included
// with the returned events apply is an expression used for aggregation over returned events
func (client BaseClient) GetEventsMethod(ctx context.Context, eventType EventTypeEnum, timespan *string, filter string, search string, orderby string, selectParameter string, skip *int32, top *int32, formatParameter string, count *bool, apply string) (result EventsResultsType, err error) {
	req, err := client.GetEventsMethodPreparer(ctx, eventType, timespan, filter, search, orderby, selectParameter, skip, top, formatParameter, count, apply)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetEventsMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEventsMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetEventsMethod", resp, "Failure sending request")
		return
	}

	result, err = client.GetEventsMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetEventsMethod", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetEventsMethodPreparer prepares the GetEventsMethod request.
func (client BaseClient) GetEventsMethodPreparer(ctx context.Context, eventType EventTypeEnum, timespan *string, filter string, search string, orderby string, selectParameter string, skip *int32, top *int32, formatParameter string, count *bool, apply string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", client.AppID),
		"eventType": autorest.Encode("path", eventType),
	}

	queryParameters := map[string]interface{}{}
	if timespan != nil {
		queryParameters["timespan"] = autorest.Encode("query", *timespan)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(search) > 0 {
		queryParameters["$search"] = autorest.Encode("query", search)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(formatParameter) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}
	if len(apply) > 0 {
		queryParameters["$apply"] = autorest.Encode("query", apply)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/apps/{appId}/events/{eventType}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetEventsMethodSender sends the GetEventsMethod request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetEventsMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetEventsMethodResponder handles the response to the GetEventsMethod request. The method always
// closes the http.Response Body.
func (client BaseClient) GetEventsMethodResponder(resp *http.Response) (result EventsResultsType, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetMetricMethod gets data for a single metric.
//
// metricID is ID of the metric. This is either a standard AI metric, or an application-specific custom metric.
// timespan is the timespan over which to retrieve metric values. This is an ISO8601 time period value. If timespan
// is omitted, a default time range of `PT12H` ("last 12 hours") is used. The actual timespan that is queried may
// be adjusted by the server based. In all cases, the actual time span used for the query is included in the
// response. interval is the time interval to use when retrieving metric values. This is an ISO8601 duration. If
// interval is omitted, the metric value is aggregated across the entire timespan. If interval is supplied, the
// server may adjust the interval to a more appropriate size based on the timespan used for the query. In all
// cases, the actual interval used for the query is included in the response. aggregation is the aggregation to use
// when computing the metric values. To retrieve more than one aggregation at a time, separate them with a comma.
// If no aggregation is specified, then the default aggregation for the metric is used. segment is the name of the
// dimension to segment the metric values by. This dimension must be applicable to the metric you are retrieving.
// To segment by more than one dimension at a time, separate them with a comma (,). In this case, the metric data
// will be segmented in the order the dimensions are listed in the parameter. top is the number of segments to
// return.  This value is only valid when segment is specified. orderby is the aggregation function and direction
// to sort the segments by.  This value is only valid when segment is specified. filter is an expression used to
// filter the results.  This value should be a valid OData filter expression where the keys of each clause should
// be applicable dimensions for the metric you are retrieving.
func (client BaseClient) GetMetricMethod(ctx context.Context, metricID string, timespan *string, interval *string, aggregation []string, segment []string, top *int32, orderby string, filter string) (result MetricsResultType, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: aggregation,
			Constraints: []validation.Constraint{{Target: "aggregation", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "aggregation", Name: validation.MinItems, Rule: 1, Chain: nil}}}}},
		{TargetValue: segment,
			Constraints: []validation.Constraint{{Target: "segment", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "segment", Name: validation.MinItems, Rule: 1, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError(".BaseClient", "GetMetricMethod", err.Error())
	}

	req, err := client.GetMetricMethodPreparer(ctx, metricID, timespan, interval, aggregation, segment, top, orderby, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetMetricMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMetricMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetMetricMethod", resp, "Failure sending request")
		return
	}

	result, err = client.GetMetricMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetMetricMethod", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetMetricMethodPreparer prepares the GetMetricMethod request.
func (client BaseClient) GetMetricMethodPreparer(ctx context.Context, metricID string, timespan *string, interval *string, aggregation []string, segment []string, top *int32, orderby string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appId":    autorest.Encode("path", client.AppID),
		"metricId": autorest.Encode("path", metricID),
	}

	queryParameters := map[string]interface{}{}
	if timespan != nil {
		queryParameters["timespan"] = autorest.Encode("query", *timespan)
	}
	if interval != nil {
		queryParameters["interval"] = autorest.Encode("query", *interval)
	}
	if aggregation != nil && len(aggregation) > 0 {
		queryParameters["aggregation"] = autorest.Encode("query", aggregation, ",")
	}
	if segment != nil && len(segment) > 0 {
		queryParameters["segment"] = autorest.Encode("query", segment, ",")
	}
	if top != nil {
		queryParameters["top"] = autorest.Encode("query", *top)
	}
	if len(orderby) > 0 {
		queryParameters["orderby"] = autorest.Encode("query", orderby)
	}
	if len(filter) > 0 {
		queryParameters["filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/apps/{appId}/metrics/{metricId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetMetricMethodSender sends the GetMetricMethod request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetMetricMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetMetricMethodResponder handles the response to the GetMetricMethod request. The method always
// closes the http.Response Body.
func (client BaseClient) GetMetricMethodResponder(resp *http.Response) (result MetricsResultType, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetMetricsMetadataMethod gets metadata describing the available metrics
func (client BaseClient) GetMetricsMetadataMethod(ctx context.Context) (result SetObjectType, err error) {
	req, err := client.GetMetricsMetadataMethodPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetMetricsMetadataMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMetricsMetadataMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetMetricsMetadataMethod", resp, "Failure sending request")
		return
	}

	result, err = client.GetMetricsMetadataMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetMetricsMetadataMethod", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetMetricsMetadataMethodPreparer prepares the GetMetricsMetadataMethod request.
func (client BaseClient) GetMetricsMetadataMethodPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", client.AppID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/apps/{appId}/metrics/metadata", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetMetricsMetadataMethodSender sends the GetMetricsMetadataMethod request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetMetricsMetadataMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetMetricsMetadataMethodResponder handles the response to the GetMetricsMetadataMethod request. The method always
// closes the http.Response Body.
func (client BaseClient) GetMetricsMetadataMethodResponder(resp *http.Response) (result SetObjectType, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetMetricsMethod gets metric values for multiple metrics
//
// body is the batched metrics query.
func (client BaseClient) GetMetricsMethod(ctx context.Context, body []MetricsPostBodySchemaType) (result ListMetricsResultsItemType, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError(".BaseClient", "GetMetricsMethod", err.Error())
	}

	req, err := client.GetMetricsMethodPreparer(ctx, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetMetricsMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMetricsMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetMetricsMethod", resp, "Failure sending request")
		return
	}

	result, err = client.GetMetricsMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetMetricsMethod", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetMetricsMethodPreparer prepares the GetMetricsMethod request.
func (client BaseClient) GetMetricsMethodPreparer(ctx context.Context, body []MetricsPostBodySchemaType) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", client.AppID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/apps/{appId}/metrics", pathParameters),
		autorest.WithJSON(body))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetMetricsMethodSender sends the GetMetricsMethod request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetMetricsMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetMetricsMethodResponder handles the response to the GetMetricsMethod request. The method always
// closes the http.Response Body.
func (client BaseClient) GetMetricsMethodResponder(resp *http.Response) (result ListMetricsResultsItemType, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetQueryMethod executes an Analytics query for data
//
// query is the Analytics query. Learn more about the [Analytics query
// syntax](https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/) timespan is
// optional. The timespan over which to query data. This is an ISO8601 time period value.  This timespan is applied
// in addition to any that are specified in the query expression.
func (client BaseClient) GetQueryMethod(ctx context.Context, query string, timespan *string) (result QueryResultsType, err error) {
	req, err := client.GetQueryMethodPreparer(ctx, query, timespan)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetQueryMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetQueryMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetQueryMethod", resp, "Failure sending request")
		return
	}

	result, err = client.GetQueryMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetQueryMethod", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetQueryMethodPreparer prepares the GetQueryMethod request.
func (client BaseClient) GetQueryMethodPreparer(ctx context.Context, query string, timespan *string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", client.AppID),
	}

	queryParameters := map[string]interface{}{
		"query": autorest.Encode("query", query),
	}
	if timespan != nil {
		queryParameters["timespan"] = autorest.Encode("query", *timespan)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/apps/{appId}/query", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetQueryMethodSender sends the GetQueryMethod request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetQueryMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetQueryMethodResponder handles the response to the GetQueryMethod request. The method always
// closes the http.Response Body.
func (client BaseClient) GetQueryMethodResponder(resp *http.Response) (result QueryResultsType, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetQuerySchemaMethod gets Analytics query schema describing the data model
func (client BaseClient) GetQuerySchemaMethod(ctx context.Context) (result QueryResultsType, err error) {
	req, err := client.GetQuerySchemaMethodPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetQuerySchemaMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetQuerySchemaMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetQuerySchemaMethod", resp, "Failure sending request")
		return
	}

	result, err = client.GetQuerySchemaMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "GetQuerySchemaMethod", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetQuerySchemaMethodPreparer prepares the GetQuerySchemaMethod request.
func (client BaseClient) GetQuerySchemaMethodPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", client.AppID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/apps/{appId}/query/schema", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetQuerySchemaMethodSender sends the GetQuerySchemaMethod request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetQuerySchemaMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// GetQuerySchemaMethodResponder handles the response to the GetQuerySchemaMethod request. The method always
// closes the http.Response Body.
func (client BaseClient) GetQuerySchemaMethodResponder(resp *http.Response) (result QueryResultsType, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// QueryMethod executes an Analytics query for data. [Here](/documentation/2-Using-the-API/Query) is an example for
// using POST with an Analytics query.
//
// body is the Analytics query. Learn more about the [Analytics query
// syntax](https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/) timespan is
// optional. The timespan over which to query data. This is an ISO8601 time period value.  This timespan is applied
// in addition to any that are specified in the query expression.
func (client BaseClient) QueryMethod(ctx context.Context, body QueryBodyType, timespan *string) (result QueryResultsType, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body.Query", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError(".BaseClient", "QueryMethod", err.Error())
	}

	req, err := client.QueryMethodPreparer(ctx, body, timespan)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "QueryMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.QueryMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, ".BaseClient", "QueryMethod", resp, "Failure sending request")
		return
	}

	result, err = client.QueryMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, ".BaseClient", "QueryMethod", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// QueryMethodPreparer prepares the QueryMethod request.
func (client BaseClient) QueryMethodPreparer(ctx context.Context, body QueryBodyType, timespan *string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", client.AppID),
	}

	queryParameters := map[string]interface{}{}
	if timespan != nil {
		queryParameters["timespan"] = autorest.Encode("query", *timespan)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/apps/{appId}/query", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// QueryMethodSender sends the QueryMethod request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) QueryMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// QueryMethodResponder handles the response to the QueryMethod request. The method always
// closes the http.Response Body.
func (client BaseClient) QueryMethodResponder(resp *http.Response) (result QueryResultsType, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
