// Copyright 2012-2018 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// NOTE: The following code was generated by "scripts/unicode.py", do not edit directly

#![allow(missing_docs, non_upper_case_globals, non_snake_case)]
    // official Unicode test data
    // http://www.unicode.org/Public/9.0.0/ucd/auxiliary/GraphemeBreakTest.txt
    pub const TEST_SAME: &'static [(&'static str, &'static [&'static str])] = &[
        ("\u{20}\u{20}", &["\u{20}", "\u{20}"]), ("\u{20}\u{308}\u{20}", &["\u{20}\u{308}",
        "\u{20}"]), ("\u{20}\u{d}", &["\u{20}", "\u{d}"]), ("\u{20}\u{308}\u{d}", &["\u{20}\u{308}",
        "\u{d}"]), ("\u{20}\u{a}", &["\u{20}", "\u{a}"]), ("\u{20}\u{308}\u{a}", &["\u{20}\u{308}",
        "\u{a}"]), ("\u{20}\u{1}", &["\u{20}", "\u{1}"]), ("\u{20}\u{308}\u{1}", &["\u{20}\u{308}",
        "\u{1}"]), ("\u{20}\u{300}", &["\u{20}\u{300}"]), ("\u{20}\u{308}\u{300}",
        &["\u{20}\u{308}\u{300}"]), ("\u{20}\u{600}", &["\u{20}", "\u{600}"]),
        ("\u{20}\u{308}\u{600}", &["\u{20}\u{308}", "\u{600}"]), ("\u{20}\u{1100}", &["\u{20}",
        "\u{1100}"]), ("\u{20}\u{308}\u{1100}", &["\u{20}\u{308}", "\u{1100}"]), ("\u{20}\u{1160}",
        &["\u{20}", "\u{1160}"]), ("\u{20}\u{308}\u{1160}", &["\u{20}\u{308}", "\u{1160}"]),
        ("\u{20}\u{11a8}", &["\u{20}", "\u{11a8}"]), ("\u{20}\u{308}\u{11a8}", &["\u{20}\u{308}",
        "\u{11a8}"]), ("\u{20}\u{ac00}", &["\u{20}", "\u{ac00}"]), ("\u{20}\u{308}\u{ac00}",
        &["\u{20}\u{308}", "\u{ac00}"]), ("\u{20}\u{ac01}", &["\u{20}", "\u{ac01}"]),
        ("\u{20}\u{308}\u{ac01}", &["\u{20}\u{308}", "\u{ac01}"]), ("\u{20}\u{1f1e6}", &["\u{20}",
        "\u{1f1e6}"]), ("\u{20}\u{308}\u{1f1e6}", &["\u{20}\u{308}", "\u{1f1e6}"]),
        ("\u{20}\u{261d}", &["\u{20}", "\u{261d}"]), ("\u{20}\u{308}\u{261d}", &["\u{20}\u{308}",
        "\u{261d}"]), ("\u{20}\u{1f3fb}", &["\u{20}", "\u{1f3fb}"]), ("\u{20}\u{308}\u{1f3fb}",
        &["\u{20}\u{308}", "\u{1f3fb}"]), ("\u{20}\u{200d}", &["\u{20}\u{200d}"]),
        ("\u{20}\u{308}\u{200d}", &["\u{20}\u{308}\u{200d}"]), ("\u{20}\u{2764}", &["\u{20}",
        "\u{2764}"]), ("\u{20}\u{308}\u{2764}", &["\u{20}\u{308}", "\u{2764}"]), ("\u{20}\u{1f466}",
        &["\u{20}", "\u{1f466}"]), ("\u{20}\u{308}\u{1f466}", &["\u{20}\u{308}", "\u{1f466}"]),
        ("\u{20}\u{378}", &["\u{20}", "\u{378}"]), ("\u{20}\u{308}\u{378}", &["\u{20}\u{308}",
        "\u{378}"]), ("\u{d}\u{20}", &["\u{d}", "\u{20}"]), ("\u{d}\u{308}\u{20}", &["\u{d}",
        "\u{308}", "\u{20}"]), ("\u{d}\u{d}", &["\u{d}", "\u{d}"]), ("\u{d}\u{308}\u{d}", &["\u{d}",
        "\u{308}", "\u{d}"]), ("\u{d}\u{a}", &["\u{d}\u{a}"]), ("\u{d}\u{308}\u{a}", &["\u{d}",
        "\u{308}", "\u{a}"]), ("\u{d}\u{1}", &["\u{d}", "\u{1}"]), ("\u{d}\u{308}\u{1}", &["\u{d}",
        "\u{308}", "\u{1}"]), ("\u{d}\u{300}", &["\u{d}", "\u{300}"]), ("\u{d}\u{308}\u{300}",
        &["\u{d}", "\u{308}\u{300}"]), ("\u{d}\u{600}", &["\u{d}", "\u{600}"]),
        ("\u{d}\u{308}\u{600}", &["\u{d}", "\u{308}", "\u{600}"]), ("\u{d}\u{903}", &["\u{d}",
        "\u{903}"]), ("\u{d}\u{1100}", &["\u{d}", "\u{1100}"]), ("\u{d}\u{308}\u{1100}", &["\u{d}",
        "\u{308}", "\u{1100}"]), ("\u{d}\u{1160}", &["\u{d}", "\u{1160}"]), ("\u{d}\u{308}\u{1160}",
        &["\u{d}", "\u{308}", "\u{1160}"]), ("\u{d}\u{11a8}", &["\u{d}", "\u{11a8}"]),
        ("\u{d}\u{308}\u{11a8}", &["\u{d}", "\u{308}", "\u{11a8}"]), ("\u{d}\u{ac00}", &["\u{d}",
        "\u{ac00}"]), ("\u{d}\u{308}\u{ac00}", &["\u{d}", "\u{308}", "\u{ac00}"]), ("\u{d}\u{ac01}",
        &["\u{d}", "\u{ac01}"]), ("\u{d}\u{308}\u{ac01}", &["\u{d}", "\u{308}", "\u{ac01}"]),
        ("\u{d}\u{1f1e6}", &["\u{d}", "\u{1f1e6}"]), ("\u{d}\u{308}\u{1f1e6}", &["\u{d}", "\u{308}",
        "\u{1f1e6}"]), ("\u{d}\u{261d}", &["\u{d}", "\u{261d}"]), ("\u{d}\u{308}\u{261d}",
        &["\u{d}", "\u{308}", "\u{261d}"]), ("\u{d}\u{1f3fb}", &["\u{d}", "\u{1f3fb}"]),
        ("\u{d}\u{308}\u{1f3fb}", &["\u{d}", "\u{308}", "\u{1f3fb}"]), ("\u{d}\u{200d}", &["\u{d}",
        "\u{200d}"]), ("\u{d}\u{308}\u{200d}", &["\u{d}", "\u{308}\u{200d}"]), ("\u{d}\u{2764}",
        &["\u{d}", "\u{2764}"]), ("\u{d}\u{308}\u{2764}", &["\u{d}", "\u{308}", "\u{2764}"]),
        ("\u{d}\u{1f466}", &["\u{d}", "\u{1f466}"]), ("\u{d}\u{308}\u{1f466}", &["\u{d}", "\u{308}",
        "\u{1f466}"]), ("\u{d}\u{378}", &["\u{d}", "\u{378}"]), ("\u{d}\u{308}\u{378}", &["\u{d}",
        "\u{308}", "\u{378}"]), ("\u{a}\u{20}", &["\u{a}", "\u{20}"]), ("\u{a}\u{308}\u{20}",
        &["\u{a}", "\u{308}", "\u{20}"]), ("\u{a}\u{d}", &["\u{a}", "\u{d}"]), ("\u{a}\u{308}\u{d}",
        &["\u{a}", "\u{308}", "\u{d}"]), ("\u{a}\u{a}", &["\u{a}", "\u{a}"]), ("\u{a}\u{308}\u{a}",
        &["\u{a}", "\u{308}", "\u{a}"]), ("\u{a}\u{1}", &["\u{a}", "\u{1}"]), ("\u{a}\u{308}\u{1}",
        &["\u{a}", "\u{308}", "\u{1}"]), ("\u{a}\u{300}", &["\u{a}", "\u{300}"]),
        ("\u{a}\u{308}\u{300}", &["\u{a}", "\u{308}\u{300}"]), ("\u{a}\u{600}", &["\u{a}",
        "\u{600}"]), ("\u{a}\u{308}\u{600}", &["\u{a}", "\u{308}", "\u{600}"]), ("\u{a}\u{903}",
        &["\u{a}", "\u{903}"]), ("\u{a}\u{1100}", &["\u{a}", "\u{1100}"]), ("\u{a}\u{308}\u{1100}",
        &["\u{a}", "\u{308}", "\u{1100}"]), ("\u{a}\u{1160}", &["\u{a}", "\u{1160}"]),
        ("\u{a}\u{308}\u{1160}", &["\u{a}", "\u{308}", "\u{1160}"]), ("\u{a}\u{11a8}", &["\u{a}",
        "\u{11a8}"]), ("\u{a}\u{308}\u{11a8}", &["\u{a}", "\u{308}", "\u{11a8}"]), ("\u{a}\u{ac00}",
        &["\u{a}", "\u{ac00}"]), ("\u{a}\u{308}\u{ac00}", &["\u{a}", "\u{308}", "\u{ac00}"]),
        ("\u{a}\u{ac01}", &["\u{a}", "\u{ac01}"]), ("\u{a}\u{308}\u{ac01}", &["\u{a}", "\u{308}",
        "\u{ac01}"]), ("\u{a}\u{1f1e6}", &["\u{a}", "\u{1f1e6}"]), ("\u{a}\u{308}\u{1f1e6}",
        &["\u{a}", "\u{308}", "\u{1f1e6}"]), ("\u{a}\u{261d}", &["\u{a}", "\u{261d}"]),
        ("\u{a}\u{308}\u{261d}", &["\u{a}", "\u{308}", "\u{261d}"]), ("\u{a}\u{1f3fb}", &["\u{a}",
        "\u{1f3fb}"]), ("\u{a}\u{308}\u{1f3fb}", &["\u{a}", "\u{308}", "\u{1f3fb}"]),
        ("\u{a}\u{200d}", &["\u{a}", "\u{200d}"]), ("\u{a}\u{308}\u{200d}", &["\u{a}",
        "\u{308}\u{200d}"]), ("\u{a}\u{2764}", &["\u{a}", "\u{2764}"]), ("\u{a}\u{308}\u{2764}",
        &["\u{a}", "\u{308}", "\u{2764}"]), ("\u{a}\u{1f466}", &["\u{a}", "\u{1f466}"]),
        ("\u{a}\u{308}\u{1f466}", &["\u{a}", "\u{308}", "\u{1f466}"]), ("\u{a}\u{378}", &["\u{a}",
        "\u{378}"]), ("\u{a}\u{308}\u{378}", &["\u{a}", "\u{308}", "\u{378}"]), ("\u{1}\u{20}",
        &["\u{1}", "\u{20}"]), ("\u{1}\u{308}\u{20}", &["\u{1}", "\u{308}", "\u{20}"]),
        ("\u{1}\u{d}", &["\u{1}", "\u{d}"]), ("\u{1}\u{308}\u{d}", &["\u{1}", "\u{308}", "\u{d}"]),
        ("\u{1}\u{a}", &["\u{1}", "\u{a}"]), ("\u{1}\u{308}\u{a}", &["\u{1}", "\u{308}", "\u{a}"]),
        ("\u{1}\u{1}", &["\u{1}", "\u{1}"]), ("\u{1}\u{308}\u{1}", &["\u{1}", "\u{308}", "\u{1}"]),
        ("\u{1}\u{300}", &["\u{1}", "\u{300}"]), ("\u{1}\u{308}\u{300}", &["\u{1}",
        "\u{308}\u{300}"]), ("\u{1}\u{600}", &["\u{1}", "\u{600}"]), ("\u{1}\u{308}\u{600}",
        &["\u{1}", "\u{308}", "\u{600}"]), ("\u{1}\u{903}", &["\u{1}", "\u{903}"]),
        ("\u{1}\u{1100}", &["\u{1}", "\u{1100}"]), ("\u{1}\u{308}\u{1100}", &["\u{1}", "\u{308}",
        "\u{1100}"]), ("\u{1}\u{1160}", &["\u{1}", "\u{1160}"]), ("\u{1}\u{308}\u{1160}", &["\u{1}",
        "\u{308}", "\u{1160}"]), ("\u{1}\u{11a8}", &["\u{1}", "\u{11a8}"]), ("\u{1}\u{308}\u{11a8}",
        &["\u{1}", "\u{308}", "\u{11a8}"]), ("\u{1}\u{ac00}", &["\u{1}", "\u{ac00}"]),
        ("\u{1}\u{308}\u{ac00}", &["\u{1}", "\u{308}", "\u{ac00}"]), ("\u{1}\u{ac01}", &["\u{1}",
        "\u{ac01}"]), ("\u{1}\u{308}\u{ac01}", &["\u{1}", "\u{308}", "\u{ac01}"]),
        ("\u{1}\u{1f1e6}", &["\u{1}", "\u{1f1e6}"]), ("\u{1}\u{308}\u{1f1e6}", &["\u{1}", "\u{308}",
        "\u{1f1e6}"]), ("\u{1}\u{261d}", &["\u{1}", "\u{261d}"]), ("\u{1}\u{308}\u{261d}",
        &["\u{1}", "\u{308}", "\u{261d}"]), ("\u{1}\u{1f3fb}", &["\u{1}", "\u{1f3fb}"]),
        ("\u{1}\u{308}\u{1f3fb}", &["\u{1}", "\u{308}", "\u{1f3fb}"]), ("\u{1}\u{200d}", &["\u{1}",
        "\u{200d}"]), ("\u{1}\u{308}\u{200d}", &["\u{1}", "\u{308}\u{200d}"]), ("\u{1}\u{2764}",
        &["\u{1}", "\u{2764}"]), ("\u{1}\u{308}\u{2764}", &["\u{1}", "\u{308}", "\u{2764}"]),
        ("\u{1}\u{1f466}", &["\u{1}", "\u{1f466}"]), ("\u{1}\u{308}\u{1f466}", &["\u{1}", "\u{308}",
        "\u{1f466}"]), ("\u{1}\u{378}", &["\u{1}", "\u{378}"]), ("\u{1}\u{308}\u{378}", &["\u{1}",
        "\u{308}", "\u{378}"]), ("\u{300}\u{20}", &["\u{300}", "\u{20}"]), ("\u{300}\u{308}\u{20}",
        &["\u{300}\u{308}", "\u{20}"]), ("\u{300}\u{d}", &["\u{300}", "\u{d}"]),
        ("\u{300}\u{308}\u{d}", &["\u{300}\u{308}", "\u{d}"]), ("\u{300}\u{a}", &["\u{300}",
        "\u{a}"]), ("\u{300}\u{308}\u{a}", &["\u{300}\u{308}", "\u{a}"]), ("\u{300}\u{1}",
        &["\u{300}", "\u{1}"]), ("\u{300}\u{308}\u{1}", &["\u{300}\u{308}", "\u{1}"]),
        ("\u{300}\u{300}", &["\u{300}\u{300}"]), ("\u{300}\u{308}\u{300}",
        &["\u{300}\u{308}\u{300}"]), ("\u{300}\u{600}", &["\u{300}", "\u{600}"]),
        ("\u{300}\u{308}\u{600}", &["\u{300}\u{308}", "\u{600}"]), ("\u{300}\u{1100}", &["\u{300}",
        "\u{1100}"]), ("\u{300}\u{308}\u{1100}", &["\u{300}\u{308}", "\u{1100}"]),
        ("\u{300}\u{1160}", &["\u{300}", "\u{1160}"]), ("\u{300}\u{308}\u{1160}",
        &["\u{300}\u{308}", "\u{1160}"]), ("\u{300}\u{11a8}", &["\u{300}", "\u{11a8}"]),
        ("\u{300}\u{308}\u{11a8}", &["\u{300}\u{308}", "\u{11a8}"]), ("\u{300}\u{ac00}",
        &["\u{300}", "\u{ac00}"]), ("\u{300}\u{308}\u{ac00}", &["\u{300}\u{308}", "\u{ac00}"]),
        ("\u{300}\u{ac01}", &["\u{300}", "\u{ac01}"]), ("\u{300}\u{308}\u{ac01}",
        &["\u{300}\u{308}", "\u{ac01}"]), ("\u{300}\u{1f1e6}", &["\u{300}", "\u{1f1e6}"]),
        ("\u{300}\u{308}\u{1f1e6}", &["\u{300}\u{308}", "\u{1f1e6}"]), ("\u{300}\u{261d}",
        &["\u{300}", "\u{261d}"]), ("\u{300}\u{308}\u{261d}", &["\u{300}\u{308}", "\u{261d}"]),
        ("\u{300}\u{1f3fb}", &["\u{300}", "\u{1f3fb}"]), ("\u{300}\u{308}\u{1f3fb}",
        &["\u{300}\u{308}", "\u{1f3fb}"]), ("\u{300}\u{200d}", &["\u{300}\u{200d}"]),
        ("\u{300}\u{308}\u{200d}", &["\u{300}\u{308}\u{200d}"]), ("\u{300}\u{2764}", &["\u{300}",
        "\u{2764}"]), ("\u{300}\u{308}\u{2764}", &["\u{300}\u{308}", "\u{2764}"]),
        ("\u{300}\u{1f466}", &["\u{300}", "\u{1f466}"]), ("\u{300}\u{308}\u{1f466}",
        &["\u{300}\u{308}", "\u{1f466}"]), ("\u{300}\u{378}", &["\u{300}", "\u{378}"]),
        ("\u{300}\u{308}\u{378}", &["\u{300}\u{308}", "\u{378}"]), ("\u{600}\u{308}\u{20}",
        &["\u{600}\u{308}", "\u{20}"]), ("\u{600}\u{d}", &["\u{600}", "\u{d}"]),
        ("\u{600}\u{308}\u{d}", &["\u{600}\u{308}", "\u{d}"]), ("\u{600}\u{a}", &["\u{600}",
        "\u{a}"]), ("\u{600}\u{308}\u{a}", &["\u{600}\u{308}", "\u{a}"]), ("\u{600}\u{1}",
        &["\u{600}", "\u{1}"]), ("\u{600}\u{308}\u{1}", &["\u{600}\u{308}", "\u{1}"]),
        ("\u{600}\u{300}", &["\u{600}\u{300}"]), ("\u{600}\u{308}\u{300}",
        &["\u{600}\u{308}\u{300}"]), ("\u{600}\u{308}\u{600}", &["\u{600}\u{308}", "\u{600}"]),
        ("\u{600}\u{308}\u{1100}", &["\u{600}\u{308}", "\u{1100}"]), ("\u{600}\u{308}\u{1160}",
        &["\u{600}\u{308}", "\u{1160}"]), ("\u{600}\u{308}\u{11a8}", &["\u{600}\u{308}",
        "\u{11a8}"]), ("\u{600}\u{308}\u{ac00}", &["\u{600}\u{308}", "\u{ac00}"]),
        ("\u{600}\u{308}\u{ac01}", &["\u{600}\u{308}", "\u{ac01}"]), ("\u{600}\u{308}\u{1f1e6}",
        &["\u{600}\u{308}", "\u{1f1e6}"]), ("\u{600}\u{308}\u{261d}", &["\u{600}\u{308}",
        "\u{261d}"]), ("\u{600}\u{308}\u{1f3fb}", &["\u{600}\u{308}", "\u{1f3fb}"]),
        ("\u{600}\u{200d}", &["\u{600}\u{200d}"]), ("\u{600}\u{308}\u{200d}",
        &["\u{600}\u{308}\u{200d}"]), ("\u{600}\u{308}\u{2764}", &["\u{600}\u{308}", "\u{2764}"]),
        ("\u{600}\u{308}\u{1f466}", &["\u{600}\u{308}", "\u{1f466}"]), ("\u{600}\u{308}\u{378}",
        &["\u{600}\u{308}", "\u{378}"]), ("\u{903}\u{20}", &["\u{903}", "\u{20}"]),
        ("\u{903}\u{308}\u{20}", &["\u{903}\u{308}", "\u{20}"]), ("\u{903}\u{d}", &["\u{903}",
        "\u{d}"]), ("\u{903}\u{308}\u{d}", &["\u{903}\u{308}", "\u{d}"]), ("\u{903}\u{a}",
        &["\u{903}", "\u{a}"]), ("\u{903}\u{308}\u{a}", &["\u{903}\u{308}", "\u{a}"]),
        ("\u{903}\u{1}", &["\u{903}", "\u{1}"]), ("\u{903}\u{308}\u{1}", &["\u{903}\u{308}",
        "\u{1}"]), ("\u{903}\u{300}", &["\u{903}\u{300}"]), ("\u{903}\u{308}\u{300}",
        &["\u{903}\u{308}\u{300}"]), ("\u{903}\u{600}", &["\u{903}", "\u{600}"]),
        ("\u{903}\u{308}\u{600}", &["\u{903}\u{308}", "\u{600}"]), ("\u{903}\u{1100}", &["\u{903}",
        "\u{1100}"]), ("\u{903}\u{308}\u{1100}", &["\u{903}\u{308}", "\u{1100}"]),
        ("\u{903}\u{1160}", &["\u{903}", "\u{1160}"]), ("\u{903}\u{308}\u{1160}",
        &["\u{903}\u{308}", "\u{1160}"]), ("\u{903}\u{11a8}", &["\u{903}", "\u{11a8}"]),
        ("\u{903}\u{308}\u{11a8}", &["\u{903}\u{308}", "\u{11a8}"]), ("\u{903}\u{ac00}",
        &["\u{903}", "\u{ac00}"]), ("\u{903}\u{308}\u{ac00}", &["\u{903}\u{308}", "\u{ac00}"]),
        ("\u{903}\u{ac01}", &["\u{903}", "\u{ac01}"]), ("\u{903}\u{308}\u{ac01}",
        &["\u{903}\u{308}", "\u{ac01}"]), ("\u{903}\u{1f1e6}", &["\u{903}", "\u{1f1e6}"]),
        ("\u{903}\u{308}\u{1f1e6}", &["\u{903}\u{308}", "\u{1f1e6}"]), ("\u{903}\u{261d}",
        &["\u{903}", "\u{261d}"]), ("\u{903}\u{308}\u{261d}", &["\u{903}\u{308}", "\u{261d}"]),
        ("\u{903}\u{1f3fb}", &["\u{903}", "\u{1f3fb}"]), ("\u{903}\u{308}\u{1f3fb}",
        &["\u{903}\u{308}", "\u{1f3fb}"]), ("\u{903}\u{200d}", &["\u{903}\u{200d}"]),
        ("\u{903}\u{308}\u{200d}", &["\u{903}\u{308}\u{200d}"]), ("\u{903}\u{2764}", &["\u{903}",
        "\u{2764}"]), ("\u{903}\u{308}\u{2764}", &["\u{903}\u{308}", "\u{2764}"]),
        ("\u{903}\u{1f466}", &["\u{903}", "\u{1f466}"]), ("\u{903}\u{308}\u{1f466}",
        &["\u{903}\u{308}", "\u{1f466}"]), ("\u{903}\u{378}", &["\u{903}", "\u{378}"]),
        ("\u{903}\u{308}\u{378}", &["\u{903}\u{308}", "\u{378}"]), ("\u{1100}\u{20}", &["\u{1100}",
        "\u{20}"]), ("\u{1100}\u{308}\u{20}", &["\u{1100}\u{308}", "\u{20}"]), ("\u{1100}\u{d}",
        &["\u{1100}", "\u{d}"]), ("\u{1100}\u{308}\u{d}", &["\u{1100}\u{308}", "\u{d}"]),
        ("\u{1100}\u{a}", &["\u{1100}", "\u{a}"]), ("\u{1100}\u{308}\u{a}", &["\u{1100}\u{308}",
        "\u{a}"]), ("\u{1100}\u{1}", &["\u{1100}", "\u{1}"]), ("\u{1100}\u{308}\u{1}",
        &["\u{1100}\u{308}", "\u{1}"]), ("\u{1100}\u{300}", &["\u{1100}\u{300}"]),
        ("\u{1100}\u{308}\u{300}", &["\u{1100}\u{308}\u{300}"]), ("\u{1100}\u{600}", &["\u{1100}",
        "\u{600}"]), ("\u{1100}\u{308}\u{600}", &["\u{1100}\u{308}", "\u{600}"]),
        ("\u{1100}\u{1100}", &["\u{1100}\u{1100}"]), ("\u{1100}\u{308}\u{1100}",
        &["\u{1100}\u{308}", "\u{1100}"]), ("\u{1100}\u{1160}", &["\u{1100}\u{1160}"]),
        ("\u{1100}\u{308}\u{1160}", &["\u{1100}\u{308}", "\u{1160}"]), ("\u{1100}\u{11a8}",
        &["\u{1100}", "\u{11a8}"]), ("\u{1100}\u{308}\u{11a8}", &["\u{1100}\u{308}", "\u{11a8}"]),
        ("\u{1100}\u{ac00}", &["\u{1100}\u{ac00}"]), ("\u{1100}\u{308}\u{ac00}",
        &["\u{1100}\u{308}", "\u{ac00}"]), ("\u{1100}\u{ac01}", &["\u{1100}\u{ac01}"]),
        ("\u{1100}\u{308}\u{ac01}", &["\u{1100}\u{308}", "\u{ac01}"]), ("\u{1100}\u{1f1e6}",
        &["\u{1100}", "\u{1f1e6}"]), ("\u{1100}\u{308}\u{1f1e6}", &["\u{1100}\u{308}",
        "\u{1f1e6}"]), ("\u{1100}\u{261d}", &["\u{1100}", "\u{261d}"]), ("\u{1100}\u{308}\u{261d}",
        &["\u{1100}\u{308}", "\u{261d}"]), ("\u{1100}\u{1f3fb}", &["\u{1100}", "\u{1f3fb}"]),
        ("\u{1100}\u{308}\u{1f3fb}", &["\u{1100}\u{308}", "\u{1f3fb}"]), ("\u{1100}\u{200d}",
        &["\u{1100}\u{200d}"]), ("\u{1100}\u{308}\u{200d}", &["\u{1100}\u{308}\u{200d}"]),
        ("\u{1100}\u{2764}", &["\u{1100}", "\u{2764}"]), ("\u{1100}\u{308}\u{2764}",
        &["\u{1100}\u{308}", "\u{2764}"]), ("\u{1100}\u{1f466}", &["\u{1100}", "\u{1f466}"]),
        ("\u{1100}\u{308}\u{1f466}", &["\u{1100}\u{308}", "\u{1f466}"]), ("\u{1100}\u{378}",
        &["\u{1100}", "\u{378}"]), ("\u{1100}\u{308}\u{378}", &["\u{1100}\u{308}", "\u{378}"]),
        ("\u{1160}\u{20}", &["\u{1160}", "\u{20}"]), ("\u{1160}\u{308}\u{20}", &["\u{1160}\u{308}",
        "\u{20}"]), ("\u{1160}\u{d}", &["\u{1160}", "\u{d}"]), ("\u{1160}\u{308}\u{d}",
        &["\u{1160}\u{308}", "\u{d}"]), ("\u{1160}\u{a}", &["\u{1160}", "\u{a}"]),
        ("\u{1160}\u{308}\u{a}", &["\u{1160}\u{308}", "\u{a}"]), ("\u{1160}\u{1}", &["\u{1160}",
        "\u{1}"]), ("\u{1160}\u{308}\u{1}", &["\u{1160}\u{308}", "\u{1}"]), ("\u{1160}\u{300}",
        &["\u{1160}\u{300}"]), ("\u{1160}\u{308}\u{300}", &["\u{1160}\u{308}\u{300}"]),
        ("\u{1160}\u{600}", &["\u{1160}", "\u{600}"]), ("\u{1160}\u{308}\u{600}",
        &["\u{1160}\u{308}", "\u{600}"]), ("\u{1160}\u{1100}", &["\u{1160}", "\u{1100}"]),
        ("\u{1160}\u{308}\u{1100}", &["\u{1160}\u{308}", "\u{1100}"]), ("\u{1160}\u{1160}",
        &["\u{1160}\u{1160}"]), ("\u{1160}\u{308}\u{1160}", &["\u{1160}\u{308}", "\u{1160}"]),
        ("\u{1160}\u{11a8}", &["\u{1160}\u{11a8}"]), ("\u{1160}\u{308}\u{11a8}",
        &["\u{1160}\u{308}", "\u{11a8}"]), ("\u{1160}\u{ac00}", &["\u{1160}", "\u{ac00}"]),
        ("\u{1160}\u{308}\u{ac00}", &["\u{1160}\u{308}", "\u{ac00}"]), ("\u{1160}\u{ac01}",
        &["\u{1160}", "\u{ac01}"]), ("\u{1160}\u{308}\u{ac01}", &["\u{1160}\u{308}", "\u{ac01}"]),
        ("\u{1160}\u{1f1e6}", &["\u{1160}", "\u{1f1e6}"]), ("\u{1160}\u{308}\u{1f1e6}",
        &["\u{1160}\u{308}", "\u{1f1e6}"]), ("\u{1160}\u{261d}", &["\u{1160}", "\u{261d}"]),
        ("\u{1160}\u{308}\u{261d}", &["\u{1160}\u{308}", "\u{261d}"]), ("\u{1160}\u{1f3fb}",
        &["\u{1160}", "\u{1f3fb}"]), ("\u{1160}\u{308}\u{1f3fb}", &["\u{1160}\u{308}",
        "\u{1f3fb}"]), ("\u{1160}\u{200d}", &["\u{1160}\u{200d}"]), ("\u{1160}\u{308}\u{200d}",
        &["\u{1160}\u{308}\u{200d}"]), ("\u{1160}\u{2764}", &["\u{1160}", "\u{2764}"]),
        ("\u{1160}\u{308}\u{2764}", &["\u{1160}\u{308}", "\u{2764}"]), ("\u{1160}\u{1f466}",
        &["\u{1160}", "\u{1f466}"]), ("\u{1160}\u{308}\u{1f466}", &["\u{1160}\u{308}",
        "\u{1f466}"]), ("\u{1160}\u{378}", &["\u{1160}", "\u{378}"]), ("\u{1160}\u{308}\u{378}",
        &["\u{1160}\u{308}", "\u{378}"]), ("\u{11a8}\u{20}", &["\u{11a8}", "\u{20}"]),
        ("\u{11a8}\u{308}\u{20}", &["\u{11a8}\u{308}", "\u{20}"]), ("\u{11a8}\u{d}", &["\u{11a8}",
        "\u{d}"]), ("\u{11a8}\u{308}\u{d}", &["\u{11a8}\u{308}", "\u{d}"]), ("\u{11a8}\u{a}",
        &["\u{11a8}", "\u{a}"]), ("\u{11a8}\u{308}\u{a}", &["\u{11a8}\u{308}", "\u{a}"]),
        ("\u{11a8}\u{1}", &["\u{11a8}", "\u{1}"]), ("\u{11a8}\u{308}\u{1}", &["\u{11a8}\u{308}",
        "\u{1}"]), ("\u{11a8}\u{300}", &["\u{11a8}\u{300}"]), ("\u{11a8}\u{308}\u{300}",
        &["\u{11a8}\u{308}\u{300}"]), ("\u{11a8}\u{600}", &["\u{11a8}", "\u{600}"]),
        ("\u{11a8}\u{308}\u{600}", &["\u{11a8}\u{308}", "\u{600}"]), ("\u{11a8}\u{1100}",
        &["\u{11a8}", "\u{1100}"]), ("\u{11a8}\u{308}\u{1100}", &["\u{11a8}\u{308}", "\u{1100}"]),
        ("\u{11a8}\u{1160}", &["\u{11a8}", "\u{1160}"]), ("\u{11a8}\u{308}\u{1160}",
        &["\u{11a8}\u{308}", "\u{1160}"]), ("\u{11a8}\u{11a8}", &["\u{11a8}\u{11a8}"]),
        ("\u{11a8}\u{308}\u{11a8}", &["\u{11a8}\u{308}", "\u{11a8}"]), ("\u{11a8}\u{ac00}",
        &["\u{11a8}", "\u{ac00}"]), ("\u{11a8}\u{308}\u{ac00}", &["\u{11a8}\u{308}", "\u{ac00}"]),
        ("\u{11a8}\u{ac01}", &["\u{11a8}", "\u{ac01}"]), ("\u{11a8}\u{308}\u{ac01}",
        &["\u{11a8}\u{308}", "\u{ac01}"]), ("\u{11a8}\u{1f1e6}", &["\u{11a8}", "\u{1f1e6}"]),
        ("\u{11a8}\u{308}\u{1f1e6}", &["\u{11a8}\u{308}", "\u{1f1e6}"]), ("\u{11a8}\u{261d}",
        &["\u{11a8}", "\u{261d}"]), ("\u{11a8}\u{308}\u{261d}", &["\u{11a8}\u{308}", "\u{261d}"]),
        ("\u{11a8}\u{1f3fb}", &["\u{11a8}", "\u{1f3fb}"]), ("\u{11a8}\u{308}\u{1f3fb}",
        &["\u{11a8}\u{308}", "\u{1f3fb}"]), ("\u{11a8}\u{200d}", &["\u{11a8}\u{200d}"]),
        ("\u{11a8}\u{308}\u{200d}", &["\u{11a8}\u{308}\u{200d}"]), ("\u{11a8}\u{2764}",
        &["\u{11a8}", "\u{2764}"]), ("\u{11a8}\u{308}\u{2764}", &["\u{11a8}\u{308}", "\u{2764}"]),
        ("\u{11a8}\u{1f466}", &["\u{11a8}", "\u{1f466}"]), ("\u{11a8}\u{308}\u{1f466}",
        &["\u{11a8}\u{308}", "\u{1f466}"]), ("\u{11a8}\u{378}", &["\u{11a8}", "\u{378}"]),
        ("\u{11a8}\u{308}\u{378}", &["\u{11a8}\u{308}", "\u{378}"]), ("\u{ac00}\u{20}",
        &["\u{ac00}", "\u{20}"]), ("\u{ac00}\u{308}\u{20}", &["\u{ac00}\u{308}", "\u{20}"]),
        ("\u{ac00}\u{d}", &["\u{ac00}", "\u{d}"]), ("\u{ac00}\u{308}\u{d}", &["\u{ac00}\u{308}",
        "\u{d}"]), ("\u{ac00}\u{a}", &["\u{ac00}", "\u{a}"]), ("\u{ac00}\u{308}\u{a}",
        &["\u{ac00}\u{308}", "\u{a}"]), ("\u{ac00}\u{1}", &["\u{ac00}", "\u{1}"]),
        ("\u{ac00}\u{308}\u{1}", &["\u{ac00}\u{308}", "\u{1}"]), ("\u{ac00}\u{300}",
        &["\u{ac00}\u{300}"]), ("\u{ac00}\u{308}\u{300}", &["\u{ac00}\u{308}\u{300}"]),
        ("\u{ac00}\u{600}", &["\u{ac00}", "\u{600}"]), ("\u{ac00}\u{308}\u{600}",
        &["\u{ac00}\u{308}", "\u{600}"]), ("\u{ac00}\u{1100}", &["\u{ac00}", "\u{1100}"]),
        ("\u{ac00}\u{308}\u{1100}", &["\u{ac00}\u{308}", "\u{1100}"]), ("\u{ac00}\u{1160}",
        &["\u{ac00}\u{1160}"]), ("\u{ac00}\u{308}\u{1160}", &["\u{ac00}\u{308}", "\u{1160}"]),
        ("\u{ac00}\u{11a8}", &["\u{ac00}\u{11a8}"]), ("\u{ac00}\u{308}\u{11a8}",
        &["\u{ac00}\u{308}", "\u{11a8}"]), ("\u{ac00}\u{ac00}", &["\u{ac00}", "\u{ac00}"]),
        ("\u{ac00}\u{308}\u{ac00}", &["\u{ac00}\u{308}", "\u{ac00}"]), ("\u{ac00}\u{ac01}",
        &["\u{ac00}", "\u{ac01}"]), ("\u{ac00}\u{308}\u{ac01}", &["\u{ac00}\u{308}", "\u{ac01}"]),
        ("\u{ac00}\u{1f1e6}", &["\u{ac00}", "\u{1f1e6}"]), ("\u{ac00}\u{308}\u{1f1e6}",
        &["\u{ac00}\u{308}", "\u{1f1e6}"]), ("\u{ac00}\u{261d}", &["\u{ac00}", "\u{261d}"]),
        ("\u{ac00}\u{308}\u{261d}", &["\u{ac00}\u{308}", "\u{261d}"]), ("\u{ac00}\u{1f3fb}",
        &["\u{ac00}", "\u{1f3fb}"]), ("\u{ac00}\u{308}\u{1f3fb}", &["\u{ac00}\u{308}",
        "\u{1f3fb}"]), ("\u{ac00}\u{200d}", &["\u{ac00}\u{200d}"]), ("\u{ac00}\u{308}\u{200d}",
        &["\u{ac00}\u{308}\u{200d}"]), ("\u{ac00}\u{2764}", &["\u{ac00}", "\u{2764}"]),
        ("\u{ac00}\u{308}\u{2764}", &["\u{ac00}\u{308}", "\u{2764}"]), ("\u{ac00}\u{1f466}",
        &["\u{ac00}", "\u{1f466}"]), ("\u{ac00}\u{308}\u{1f466}", &["\u{ac00}\u{308}",
        "\u{1f466}"]), ("\u{ac00}\u{378}", &["\u{ac00}", "\u{378}"]), ("\u{ac00}\u{308}\u{378}",
        &["\u{ac00}\u{308}", "\u{378}"]), ("\u{ac01}\u{20}", &["\u{ac01}", "\u{20}"]),
        ("\u{ac01}\u{308}\u{20}", &["\u{ac01}\u{308}", "\u{20}"]), ("\u{ac01}\u{d}", &["\u{ac01}",
        "\u{d}"]), ("\u{ac01}\u{308}\u{d}", &["\u{ac01}\u{308}", "\u{d}"]), ("\u{ac01}\u{a}",
        &["\u{ac01}", "\u{a}"]), ("\u{ac01}\u{308}\u{a}", &["\u{ac01}\u{308}", "\u{a}"]),
        ("\u{ac01}\u{1}", &["\u{ac01}", "\u{1}"]), ("\u{ac01}\u{308}\u{1}", &["\u{ac01}\u{308}",
        "\u{1}"]), ("\u{ac01}\u{300}", &["\u{ac01}\u{300}"]), ("\u{ac01}\u{308}\u{300}",
        &["\u{ac01}\u{308}\u{300}"]), ("\u{ac01}\u{600}", &["\u{ac01}", "\u{600}"]),
        ("\u{ac01}\u{308}\u{600}", &["\u{ac01}\u{308}", "\u{600}"]), ("\u{ac01}\u{1100}",
        &["\u{ac01}", "\u{1100}"]), ("\u{ac01}\u{308}\u{1100}", &["\u{ac01}\u{308}", "\u{1100}"]),
        ("\u{ac01}\u{1160}", &["\u{ac01}", "\u{1160}"]), ("\u{ac01}\u{308}\u{1160}",
        &["\u{ac01}\u{308}", "\u{1160}"]), ("\u{ac01}\u{11a8}", &["\u{ac01}\u{11a8}"]),
        ("\u{ac01}\u{308}\u{11a8}", &["\u{ac01}\u{308}", "\u{11a8}"]), ("\u{ac01}\u{ac00}",
        &["\u{ac01}", "\u{ac00}"]), ("\u{ac01}\u{308}\u{ac00}", &["\u{ac01}\u{308}", "\u{ac00}"]),
        ("\u{ac01}\u{ac01}", &["\u{ac01}", "\u{ac01}"]), ("\u{ac01}\u{308}\u{ac01}",
        &["\u{ac01}\u{308}", "\u{ac01}"]), ("\u{ac01}\u{1f1e6}", &["\u{ac01}", "\u{1f1e6}"]),
        ("\u{ac01}\u{308}\u{1f1e6}", &["\u{ac01}\u{308}", "\u{1f1e6}"]), ("\u{ac01}\u{261d}",
        &["\u{ac01}", "\u{261d}"]), ("\u{ac01}\u{308}\u{261d}", &["\u{ac01}\u{308}", "\u{261d}"]),
        ("\u{ac01}\u{1f3fb}", &["\u{ac01}", "\u{1f3fb}"]), ("\u{ac01}\u{308}\u{1f3fb}",
        &["\u{ac01}\u{308}", "\u{1f3fb}"]), ("\u{ac01}\u{200d}", &["\u{ac01}\u{200d}"]),
        ("\u{ac01}\u{308}\u{200d}", &["\u{ac01}\u{308}\u{200d}"]), ("\u{ac01}\u{2764}",
        &["\u{ac01}", "\u{2764}"]), ("\u{ac01}\u{308}\u{2764}", &["\u{ac01}\u{308}", "\u{2764}"]),
        ("\u{ac01}\u{1f466}", &["\u{ac01}", "\u{1f466}"]), ("\u{ac01}\u{308}\u{1f466}",
        &["\u{ac01}\u{308}", "\u{1f466}"]), ("\u{ac01}\u{378}", &["\u{ac01}", "\u{378}"]),
        ("\u{ac01}\u{308}\u{378}", &["\u{ac01}\u{308}", "\u{378}"]), ("\u{1f1e6}\u{20}",
        &["\u{1f1e6}", "\u{20}"]), ("\u{1f1e6}\u{308}\u{20}", &["\u{1f1e6}\u{308}", "\u{20}"]),
        ("\u{1f1e6}\u{d}", &["\u{1f1e6}", "\u{d}"]), ("\u{1f1e6}\u{308}\u{d}", &["\u{1f1e6}\u{308}",
        "\u{d}"]), ("\u{1f1e6}\u{a}", &["\u{1f1e6}", "\u{a}"]), ("\u{1f1e6}\u{308}\u{a}",
        &["\u{1f1e6}\u{308}", "\u{a}"]), ("\u{1f1e6}\u{1}", &["\u{1f1e6}", "\u{1}"]),
        ("\u{1f1e6}\u{308}\u{1}", &["\u{1f1e6}\u{308}", "\u{1}"]), ("\u{1f1e6}\u{300}",
        &["\u{1f1e6}\u{300}"]), ("\u{1f1e6}\u{308}\u{300}", &["\u{1f1e6}\u{308}\u{300}"]),
        ("\u{1f1e6}\u{600}", &["\u{1f1e6}", "\u{600}"]), ("\u{1f1e6}\u{308}\u{600}",
        &["\u{1f1e6}\u{308}", "\u{600}"]), ("\u{1f1e6}\u{1100}", &["\u{1f1e6}", "\u{1100}"]),
        ("\u{1f1e6}\u{308}\u{1100}", &["\u{1f1e6}\u{308}", "\u{1100}"]), ("\u{1f1e6}\u{1160}",
        &["\u{1f1e6}", "\u{1160}"]), ("\u{1f1e6}\u{308}\u{1160}", &["\u{1f1e6}\u{308}",
        "\u{1160}"]), ("\u{1f1e6}\u{11a8}", &["\u{1f1e6}", "\u{11a8}"]),
        ("\u{1f1e6}\u{308}\u{11a8}", &["\u{1f1e6}\u{308}", "\u{11a8}"]), ("\u{1f1e6}\u{ac00}",
        &["\u{1f1e6}", "\u{ac00}"]), ("\u{1f1e6}\u{308}\u{ac00}", &["\u{1f1e6}\u{308}",
        "\u{ac00}"]), ("\u{1f1e6}\u{ac01}", &["\u{1f1e6}", "\u{ac01}"]),
        ("\u{1f1e6}\u{308}\u{ac01}", &["\u{1f1e6}\u{308}", "\u{ac01}"]), ("\u{1f1e6}\u{1f1e6}",
        &["\u{1f1e6}\u{1f1e6}"]), ("\u{1f1e6}\u{308}\u{1f1e6}", &["\u{1f1e6}\u{308}", "\u{1f1e6}"]),
        ("\u{1f1e6}\u{261d}", &["\u{1f1e6}", "\u{261d}"]), ("\u{1f1e6}\u{308}\u{261d}",
        &["\u{1f1e6}\u{308}", "\u{261d}"]), ("\u{1f1e6}\u{1f3fb}", &["\u{1f1e6}", "\u{1f3fb}"]),
        ("\u{1f1e6}\u{308}\u{1f3fb}", &["\u{1f1e6}\u{308}", "\u{1f3fb}"]), ("\u{1f1e6}\u{200d}",
        &["\u{1f1e6}\u{200d}"]), ("\u{1f1e6}\u{308}\u{200d}", &["\u{1f1e6}\u{308}\u{200d}"]),
        ("\u{1f1e6}\u{2764}", &["\u{1f1e6}", "\u{2764}"]), ("\u{1f1e6}\u{308}\u{2764}",
        &["\u{1f1e6}\u{308}", "\u{2764}"]), ("\u{1f1e6}\u{1f466}", &["\u{1f1e6}", "\u{1f466}"]),
        ("\u{1f1e6}\u{308}\u{1f466}", &["\u{1f1e6}\u{308}", "\u{1f466}"]), ("\u{1f1e6}\u{378}",
        &["\u{1f1e6}", "\u{378}"]), ("\u{1f1e6}\u{308}\u{378}", &["\u{1f1e6}\u{308}", "\u{378}"]),
        ("\u{261d}\u{20}", &["\u{261d}", "\u{20}"]), ("\u{261d}\u{308}\u{20}", &["\u{261d}\u{308}",
        "\u{20}"]), ("\u{261d}\u{d}", &["\u{261d}", "\u{d}"]), ("\u{261d}\u{308}\u{d}",
        &["\u{261d}\u{308}", "\u{d}"]), ("\u{261d}\u{a}", &["\u{261d}", "\u{a}"]),
        ("\u{261d}\u{308}\u{a}", &["\u{261d}\u{308}", "\u{a}"]), ("\u{261d}\u{1}", &["\u{261d}",
        "\u{1}"]), ("\u{261d}\u{308}\u{1}", &["\u{261d}\u{308}", "\u{1}"]), ("\u{261d}\u{300}",
        &["\u{261d}\u{300}"]), ("\u{261d}\u{308}\u{300}", &["\u{261d}\u{308}\u{300}"]),
        ("\u{261d}\u{600}", &["\u{261d}", "\u{600}"]), ("\u{261d}\u{308}\u{600}",
        &["\u{261d}\u{308}", "\u{600}"]), ("\u{261d}\u{1100}", &["\u{261d}", "\u{1100}"]),
        ("\u{261d}\u{308}\u{1100}", &["\u{261d}\u{308}", "\u{1100}"]), ("\u{261d}\u{1160}",
        &["\u{261d}", "\u{1160}"]), ("\u{261d}\u{308}\u{1160}", &["\u{261d}\u{308}", "\u{1160}"]),
        ("\u{261d}\u{11a8}", &["\u{261d}", "\u{11a8}"]), ("\u{261d}\u{308}\u{11a8}",
        &["\u{261d}\u{308}", "\u{11a8}"]), ("\u{261d}\u{ac00}", &["\u{261d}", "\u{ac00}"]),
        ("\u{261d}\u{308}\u{ac00}", &["\u{261d}\u{308}", "\u{ac00}"]), ("\u{261d}\u{ac01}",
        &["\u{261d}", "\u{ac01}"]), ("\u{261d}\u{308}\u{ac01}", &["\u{261d}\u{308}", "\u{ac01}"]),
        ("\u{261d}\u{1f1e6}", &["\u{261d}", "\u{1f1e6}"]), ("\u{261d}\u{308}\u{1f1e6}",
        &["\u{261d}\u{308}", "\u{1f1e6}"]), ("\u{261d}\u{261d}", &["\u{261d}", "\u{261d}"]),
        ("\u{261d}\u{308}\u{261d}", &["\u{261d}\u{308}", "\u{261d}"]), ("\u{261d}\u{1f3fb}",
        &["\u{261d}\u{1f3fb}"]), ("\u{261d}\u{308}\u{1f3fb}", &["\u{261d}\u{308}\u{1f3fb}"]),
        ("\u{261d}\u{200d}", &["\u{261d}\u{200d}"]), ("\u{261d}\u{308}\u{200d}",
        &["\u{261d}\u{308}\u{200d}"]), ("\u{261d}\u{2764}", &["\u{261d}", "\u{2764}"]),
        ("\u{261d}\u{308}\u{2764}", &["\u{261d}\u{308}", "\u{2764}"]), ("\u{261d}\u{1f466}",
        &["\u{261d}", "\u{1f466}"]), ("\u{261d}\u{308}\u{1f466}", &["\u{261d}\u{308}",
        "\u{1f466}"]), ("\u{261d}\u{378}", &["\u{261d}", "\u{378}"]), ("\u{261d}\u{308}\u{378}",
        &["\u{261d}\u{308}", "\u{378}"]), ("\u{1f3fb}\u{20}", &["\u{1f3fb}", "\u{20}"]),
        ("\u{1f3fb}\u{308}\u{20}", &["\u{1f3fb}\u{308}", "\u{20}"]), ("\u{1f3fb}\u{d}",
        &["\u{1f3fb}", "\u{d}"]), ("\u{1f3fb}\u{308}\u{d}", &["\u{1f3fb}\u{308}", "\u{d}"]),
        ("\u{1f3fb}\u{a}", &["\u{1f3fb}", "\u{a}"]), ("\u{1f3fb}\u{308}\u{a}", &["\u{1f3fb}\u{308}",
        "\u{a}"]), ("\u{1f3fb}\u{1}", &["\u{1f3fb}", "\u{1}"]), ("\u{1f3fb}\u{308}\u{1}",
        &["\u{1f3fb}\u{308}", "\u{1}"]), ("\u{1f3fb}\u{300}", &["\u{1f3fb}\u{300}"]),
        ("\u{1f3fb}\u{308}\u{300}", &["\u{1f3fb}\u{308}\u{300}"]), ("\u{1f3fb}\u{600}",
        &["\u{1f3fb}", "\u{600}"]), ("\u{1f3fb}\u{308}\u{600}", &["\u{1f3fb}\u{308}", "\u{600}"]),
        ("\u{1f3fb}\u{1100}", &["\u{1f3fb}", "\u{1100}"]), ("\u{1f3fb}\u{308}\u{1100}",
        &["\u{1f3fb}\u{308}", "\u{1100}"]), ("\u{1f3fb}\u{1160}", &["\u{1f3fb}", "\u{1160}"]),
        ("\u{1f3fb}\u{308}\u{1160}", &["\u{1f3fb}\u{308}", "\u{1160}"]), ("\u{1f3fb}\u{11a8}",
        &["\u{1f3fb}", "\u{11a8}"]), ("\u{1f3fb}\u{308}\u{11a8}", &["\u{1f3fb}\u{308}",
        "\u{11a8}"]), ("\u{1f3fb}\u{ac00}", &["\u{1f3fb}", "\u{ac00}"]),
        ("\u{1f3fb}\u{308}\u{ac00}", &["\u{1f3fb}\u{308}", "\u{ac00}"]), ("\u{1f3fb}\u{ac01}",
        &["\u{1f3fb}", "\u{ac01}"]), ("\u{1f3fb}\u{308}\u{ac01}", &["\u{1f3fb}\u{308}",
        "\u{ac01}"]), ("\u{1f3fb}\u{1f1e6}", &["\u{1f3fb}", "\u{1f1e6}"]),
        ("\u{1f3fb}\u{308}\u{1f1e6}", &["\u{1f3fb}\u{308}", "\u{1f1e6}"]), ("\u{1f3fb}\u{261d}",
        &["\u{1f3fb}", "\u{261d}"]), ("\u{1f3fb}\u{308}\u{261d}", &["\u{1f3fb}\u{308}",
        "\u{261d}"]), ("\u{1f3fb}\u{1f3fb}", &["\u{1f3fb}", "\u{1f3fb}"]),
        ("\u{1f3fb}\u{308}\u{1f3fb}", &["\u{1f3fb}\u{308}", "\u{1f3fb}"]), ("\u{1f3fb}\u{200d}",
        &["\u{1f3fb}\u{200d}"]), ("\u{1f3fb}\u{308}\u{200d}", &["\u{1f3fb}\u{308}\u{200d}"]),
        ("\u{1f3fb}\u{2764}", &["\u{1f3fb}", "\u{2764}"]), ("\u{1f3fb}\u{308}\u{2764}",
        &["\u{1f3fb}\u{308}", "\u{2764}"]), ("\u{1f3fb}\u{1f466}", &["\u{1f3fb}", "\u{1f466}"]),
        ("\u{1f3fb}\u{308}\u{1f466}", &["\u{1f3fb}\u{308}", "\u{1f466}"]), ("\u{1f3fb}\u{378}",
        &["\u{1f3fb}", "\u{378}"]), ("\u{1f3fb}\u{308}\u{378}", &["\u{1f3fb}\u{308}", "\u{378}"]),
        ("\u{200d}\u{20}", &["\u{200d}", "\u{20}"]), ("\u{200d}\u{308}\u{20}", &["\u{200d}\u{308}",
        "\u{20}"]), ("\u{200d}\u{d}", &["\u{200d}", "\u{d}"]), ("\u{200d}\u{308}\u{d}",
        &["\u{200d}\u{308}", "\u{d}"]), ("\u{200d}\u{a}", &["\u{200d}", "\u{a}"]),
        ("\u{200d}\u{308}\u{a}", &["\u{200d}\u{308}", "\u{a}"]), ("\u{200d}\u{1}", &["\u{200d}",
        "\u{1}"]), ("\u{200d}\u{308}\u{1}", &["\u{200d}\u{308}", "\u{1}"]), ("\u{200d}\u{300}",
        &["\u{200d}\u{300}"]), ("\u{200d}\u{308}\u{300}", &["\u{200d}\u{308}\u{300}"]),
        ("\u{200d}\u{600}", &["\u{200d}", "\u{600}"]), ("\u{200d}\u{308}\u{600}",
        &["\u{200d}\u{308}", "\u{600}"]), ("\u{200d}\u{1100}", &["\u{200d}", "\u{1100}"]),
        ("\u{200d}\u{308}\u{1100}", &["\u{200d}\u{308}", "\u{1100}"]), ("\u{200d}\u{1160}",
        &["\u{200d}", "\u{1160}"]), ("\u{200d}\u{308}\u{1160}", &["\u{200d}\u{308}", "\u{1160}"]),
        ("\u{200d}\u{11a8}", &["\u{200d}", "\u{11a8}"]), ("\u{200d}\u{308}\u{11a8}",
        &["\u{200d}\u{308}", "\u{11a8}"]), ("\u{200d}\u{ac00}", &["\u{200d}", "\u{ac00}"]),
        ("\u{200d}\u{308}\u{ac00}", &["\u{200d}\u{308}", "\u{ac00}"]), ("\u{200d}\u{ac01}",
        &["\u{200d}", "\u{ac01}"]), ("\u{200d}\u{308}\u{ac01}", &["\u{200d}\u{308}", "\u{ac01}"]),
        ("\u{200d}\u{1f1e6}", &["\u{200d}", "\u{1f1e6}"]), ("\u{200d}\u{308}\u{1f1e6}",
        &["\u{200d}\u{308}", "\u{1f1e6}"]), ("\u{200d}\u{261d}", &["\u{200d}", "\u{261d}"]),
        ("\u{200d}\u{308}\u{261d}", &["\u{200d}\u{308}", "\u{261d}"]), ("\u{200d}\u{1f3fb}",
        &["\u{200d}", "\u{1f3fb}"]), ("\u{200d}\u{308}\u{1f3fb}", &["\u{200d}\u{308}",
        "\u{1f3fb}"]), ("\u{200d}\u{200d}", &["\u{200d}\u{200d}"]), ("\u{200d}\u{308}\u{200d}",
        &["\u{200d}\u{308}\u{200d}"]), ("\u{200d}\u{2764}", &["\u{200d}\u{2764}"]),
        ("\u{200d}\u{308}\u{2764}", &["\u{200d}\u{308}", "\u{2764}"]), ("\u{200d}\u{1f466}",
        &["\u{200d}\u{1f466}"]), ("\u{200d}\u{308}\u{1f466}", &["\u{200d}\u{308}", "\u{1f466}"]),
        ("\u{200d}\u{378}", &["\u{200d}", "\u{378}"]), ("\u{200d}\u{308}\u{378}",
        &["\u{200d}\u{308}", "\u{378}"]), ("\u{2764}\u{20}", &["\u{2764}", "\u{20}"]),
        ("\u{2764}\u{308}\u{20}", &["\u{2764}\u{308}", "\u{20}"]), ("\u{2764}\u{d}", &["\u{2764}",
        "\u{d}"]), ("\u{2764}\u{308}\u{d}", &["\u{2764}\u{308}", "\u{d}"]), ("\u{2764}\u{a}",
        &["\u{2764}", "\u{a}"]), ("\u{2764}\u{308}\u{a}", &["\u{2764}\u{308}", "\u{a}"]),
        ("\u{2764}\u{1}", &["\u{2764}", "\u{1}"]), ("\u{2764}\u{308}\u{1}", &["\u{2764}\u{308}",
        "\u{1}"]), ("\u{2764}\u{300}", &["\u{2764}\u{300}"]), ("\u{2764}\u{308}\u{300}",
        &["\u{2764}\u{308}\u{300}"]), ("\u{2764}\u{600}", &["\u{2764}", "\u{600}"]),
        ("\u{2764}\u{308}\u{600}", &["\u{2764}\u{308}", "\u{600}"]), ("\u{2764}\u{1100}",
        &["\u{2764}", "\u{1100}"]), ("\u{2764}\u{308}\u{1100}", &["\u{2764}\u{308}", "\u{1100}"]),
        ("\u{2764}\u{1160}", &["\u{2764}", "\u{1160}"]), ("\u{2764}\u{308}\u{1160}",
        &["\u{2764}\u{308}", "\u{1160}"]), ("\u{2764}\u{11a8}", &["\u{2764}", "\u{11a8}"]),
        ("\u{2764}\u{308}\u{11a8}", &["\u{2764}\u{308}", "\u{11a8}"]), ("\u{2764}\u{ac00}",
        &["\u{2764}", "\u{ac00}"]), ("\u{2764}\u{308}\u{ac00}", &["\u{2764}\u{308}", "\u{ac00}"]),
        ("\u{2764}\u{ac01}", &["\u{2764}", "\u{ac01}"]), ("\u{2764}\u{308}\u{ac01}",
        &["\u{2764}\u{308}", "\u{ac01}"]), ("\u{2764}\u{1f1e6}", &["\u{2764}", "\u{1f1e6}"]),
        ("\u{2764}\u{308}\u{1f1e6}", &["\u{2764}\u{308}", "\u{1f1e6}"]), ("\u{2764}\u{261d}",
        &["\u{2764}", "\u{261d}"]), ("\u{2764}\u{308}\u{261d}", &["\u{2764}\u{308}", "\u{261d}"]),
        ("\u{2764}\u{1f3fb}", &["\u{2764}", "\u{1f3fb}"]), ("\u{2764}\u{308}\u{1f3fb}",
        &["\u{2764}\u{308}", "\u{1f3fb}"]), ("\u{2764}\u{200d}", &["\u{2764}\u{200d}"]),
        ("\u{2764}\u{308}\u{200d}", &["\u{2764}\u{308}\u{200d}"]), ("\u{2764}\u{2764}",
        &["\u{2764}", "\u{2764}"]), ("\u{2764}\u{308}\u{2764}", &["\u{2764}\u{308}", "\u{2764}"]),
        ("\u{2764}\u{1f466}", &["\u{2764}", "\u{1f466}"]), ("\u{2764}\u{308}\u{1f466}",
        &["\u{2764}\u{308}", "\u{1f466}"]), ("\u{2764}\u{378}", &["\u{2764}", "\u{378}"]),
        ("\u{2764}\u{308}\u{378}", &["\u{2764}\u{308}", "\u{378}"]), ("\u{1f466}\u{20}",
        &["\u{1f466}", "\u{20}"]), ("\u{1f466}\u{308}\u{20}", &["\u{1f466}\u{308}", "\u{20}"]),
        ("\u{1f466}\u{d}", &["\u{1f466}", "\u{d}"]), ("\u{1f466}\u{308}\u{d}", &["\u{1f466}\u{308}",
        "\u{d}"]), ("\u{1f466}\u{a}", &["\u{1f466}", "\u{a}"]), ("\u{1f466}\u{308}\u{a}",
        &["\u{1f466}\u{308}", "\u{a}"]), ("\u{1f466}\u{1}", &["\u{1f466}", "\u{1}"]),
        ("\u{1f466}\u{308}\u{1}", &["\u{1f466}\u{308}", "\u{1}"]), ("\u{1f466}\u{300}",
        &["\u{1f466}\u{300}"]), ("\u{1f466}\u{308}\u{300}", &["\u{1f466}\u{308}\u{300}"]),
        ("\u{1f466}\u{600}", &["\u{1f466}", "\u{600}"]), ("\u{1f466}\u{308}\u{600}",
        &["\u{1f466}\u{308}", "\u{600}"]), ("\u{1f466}\u{1100}", &["\u{1f466}", "\u{1100}"]),
        ("\u{1f466}\u{308}\u{1100}", &["\u{1f466}\u{308}", "\u{1100}"]), ("\u{1f466}\u{1160}",
        &["\u{1f466}", "\u{1160}"]), ("\u{1f466}\u{308}\u{1160}", &["\u{1f466}\u{308}",
        "\u{1160}"]), ("\u{1f466}\u{11a8}", &["\u{1f466}", "\u{11a8}"]),
        ("\u{1f466}\u{308}\u{11a8}", &["\u{1f466}\u{308}", "\u{11a8}"]), ("\u{1f466}\u{ac00}",
        &["\u{1f466}", "\u{ac00}"]), ("\u{1f466}\u{308}\u{ac00}", &["\u{1f466}\u{308}",
        "\u{ac00}"]), ("\u{1f466}\u{ac01}", &["\u{1f466}", "\u{ac01}"]),
        ("\u{1f466}\u{308}\u{ac01}", &["\u{1f466}\u{308}", "\u{ac01}"]), ("\u{1f466}\u{1f1e6}",
        &["\u{1f466}", "\u{1f1e6}"]), ("\u{1f466}\u{308}\u{1f1e6}", &["\u{1f466}\u{308}",
        "\u{1f1e6}"]), ("\u{1f466}\u{261d}", &["\u{1f466}", "\u{261d}"]),
        ("\u{1f466}\u{308}\u{261d}", &["\u{1f466}\u{308}", "\u{261d}"]), ("\u{1f466}\u{1f3fb}",
        &["\u{1f466}\u{1f3fb}"]), ("\u{1f466}\u{308}\u{1f3fb}", &["\u{1f466}\u{308}\u{1f3fb}"]),
        ("\u{1f466}\u{200d}", &["\u{1f466}\u{200d}"]), ("\u{1f466}\u{308}\u{200d}",
        &["\u{1f466}\u{308}\u{200d}"]), ("\u{1f466}\u{2764}", &["\u{1f466}", "\u{2764}"]),
        ("\u{1f466}\u{308}\u{2764}", &["\u{1f466}\u{308}", "\u{2764}"]), ("\u{1f466}\u{1f466}",
        &["\u{1f466}", "\u{1f466}"]), ("\u{1f466}\u{308}\u{1f466}", &["\u{1f466}\u{308}",
        "\u{1f466}"]), ("\u{1f466}\u{378}", &["\u{1f466}", "\u{378}"]), ("\u{1f466}\u{308}\u{378}",
        &["\u{1f466}\u{308}", "\u{378}"]), ("\u{378}\u{20}", &["\u{378}", "\u{20}"]),
        ("\u{378}\u{308}\u{20}", &["\u{378}\u{308}", "\u{20}"]), ("\u{378}\u{d}", &["\u{378}",
        "\u{d}"]), ("\u{378}\u{308}\u{d}", &["\u{378}\u{308}", "\u{d}"]), ("\u{378}\u{a}",
        &["\u{378}", "\u{a}"]), ("\u{378}\u{308}\u{a}", &["\u{378}\u{308}", "\u{a}"]),
        ("\u{378}\u{1}", &["\u{378}", "\u{1}"]), ("\u{378}\u{308}\u{1}", &["\u{378}\u{308}",
        "\u{1}"]), ("\u{378}\u{300}", &["\u{378}\u{300}"]), ("\u{378}\u{308}\u{300}",
        &["\u{378}\u{308}\u{300}"]), ("\u{378}\u{600}", &["\u{378}", "\u{600}"]),
        ("\u{378}\u{308}\u{600}", &["\u{378}\u{308}", "\u{600}"]), ("\u{378}\u{1100}", &["\u{378}",
        "\u{1100}"]), ("\u{378}\u{308}\u{1100}", &["\u{378}\u{308}", "\u{1100}"]),
        ("\u{378}\u{1160}", &["\u{378}", "\u{1160}"]), ("\u{378}\u{308}\u{1160}",
        &["\u{378}\u{308}", "\u{1160}"]), ("\u{378}\u{11a8}", &["\u{378}", "\u{11a8}"]),
        ("\u{378}\u{308}\u{11a8}", &["\u{378}\u{308}", "\u{11a8}"]), ("\u{378}\u{ac00}",
        &["\u{378}", "\u{ac00}"]), ("\u{378}\u{308}\u{ac00}", &["\u{378}\u{308}", "\u{ac00}"]),
        ("\u{378}\u{ac01}", &["\u{378}", "\u{ac01}"]), ("\u{378}\u{308}\u{ac01}",
        &["\u{378}\u{308}", "\u{ac01}"]), ("\u{378}\u{1f1e6}", &["\u{378}", "\u{1f1e6}"]),
        ("\u{378}\u{308}\u{1f1e6}", &["\u{378}\u{308}", "\u{1f1e6}"]), ("\u{378}\u{261d}",
        &["\u{378}", "\u{261d}"]), ("\u{378}\u{308}\u{261d}", &["\u{378}\u{308}", "\u{261d}"]),
        ("\u{378}\u{1f3fb}", &["\u{378}", "\u{1f3fb}"]), ("\u{378}\u{308}\u{1f3fb}",
        &["\u{378}\u{308}", "\u{1f3fb}"]), ("\u{378}\u{200d}", &["\u{378}\u{200d}"]),
        ("\u{378}\u{308}\u{200d}", &["\u{378}\u{308}\u{200d}"]), ("\u{378}\u{2764}", &["\u{378}",
        "\u{2764}"]), ("\u{378}\u{308}\u{2764}", &["\u{378}\u{308}", "\u{2764}"]),
        ("\u{378}\u{1f466}", &["\u{378}", "\u{1f466}"]), ("\u{378}\u{308}\u{1f466}",
        &["\u{378}\u{308}", "\u{1f466}"]), ("\u{378}\u{378}", &["\u{378}", "\u{378}"]),
        ("\u{378}\u{308}\u{378}", &["\u{378}\u{308}", "\u{378}"]), ("\u{d}\u{a}\u{61}\u{a}\u{308}",
        &["\u{d}\u{a}", "\u{61}", "\u{a}", "\u{308}"]), ("\u{61}\u{308}", &["\u{61}\u{308}"]),
        ("\u{20}\u{200d}\u{646}", &["\u{20}\u{200d}", "\u{646}"]), ("\u{646}\u{200d}\u{20}",
        &["\u{646}\u{200d}", "\u{20}"]), ("\u{1100}\u{1100}", &["\u{1100}\u{1100}"]),
        ("\u{ac00}\u{11a8}\u{1100}", &["\u{ac00}\u{11a8}", "\u{1100}"]),
        ("\u{ac01}\u{11a8}\u{1100}", &["\u{ac01}\u{11a8}", "\u{1100}"]),
        ("\u{1f1e6}\u{1f1e7}\u{1f1e8}\u{62}", &["\u{1f1e6}\u{1f1e7}", "\u{1f1e8}", "\u{62}"]),
        ("\u{61}\u{1f1e6}\u{1f1e7}\u{1f1e8}\u{62}", &["\u{61}", "\u{1f1e6}\u{1f1e7}", "\u{1f1e8}",
        "\u{62}"]), ("\u{61}\u{1f1e6}\u{1f1e7}\u{200d}\u{1f1e8}\u{62}", &["\u{61}",
        "\u{1f1e6}\u{1f1e7}\u{200d}", "\u{1f1e8}", "\u{62}"]),
        ("\u{61}\u{1f1e6}\u{200d}\u{1f1e7}\u{1f1e8}\u{62}", &["\u{61}", "\u{1f1e6}\u{200d}",
        "\u{1f1e7}\u{1f1e8}", "\u{62}"]), ("\u{61}\u{1f1e6}\u{1f1e7}\u{1f1e8}\u{1f1e9}\u{62}",
        &["\u{61}", "\u{1f1e6}\u{1f1e7}", "\u{1f1e8}\u{1f1e9}", "\u{62}"]), ("\u{61}\u{200d}",
        &["\u{61}\u{200d}"]), ("\u{61}\u{308}\u{62}", &["\u{61}\u{308}", "\u{62}"]),
        ("\u{261d}\u{1f3fb}\u{261d}", &["\u{261d}\u{1f3fb}", "\u{261d}"]), ("\u{1f466}\u{1f3fb}",
        &["\u{1f466}\u{1f3fb}"]), ("\u{200d}\u{1f466}\u{1f3fb}", &["\u{200d}\u{1f466}\u{1f3fb}"]),
        ("\u{200d}\u{2764}", &["\u{200d}\u{2764}"]), ("\u{200d}\u{1f466}", &["\u{200d}\u{1f466}"]),
        ("\u{1f466}\u{1f466}", &["\u{1f466}", "\u{1f466}"])
    ];

    pub const TEST_DIFF: &'static [(&'static str, &'static [&'static str], &'static [&'static str])] = &[
        ("\u{20}\u{903}", &["\u{20}\u{903}"], &["\u{20}", "\u{903}"]), ("\u{20}\u{308}\u{903}",
        &["\u{20}\u{308}\u{903}"], &["\u{20}\u{308}", "\u{903}"]), ("\u{d}\u{308}\u{903}",
        &["\u{d}", "\u{308}\u{903}"], &["\u{d}", "\u{308}", "\u{903}"]), ("\u{a}\u{308}\u{903}",
        &["\u{a}", "\u{308}\u{903}"], &["\u{a}", "\u{308}", "\u{903}"]), ("\u{1}\u{308}\u{903}",
        &["\u{1}", "\u{308}\u{903}"], &["\u{1}", "\u{308}", "\u{903}"]), ("\u{300}\u{903}",
        &["\u{300}\u{903}"], &["\u{300}", "\u{903}"]), ("\u{300}\u{308}\u{903}",
        &["\u{300}\u{308}\u{903}"], &["\u{300}\u{308}", "\u{903}"]), ("\u{600}\u{20}",
        &["\u{600}\u{20}"], &["\u{600}", "\u{20}"]), ("\u{600}\u{600}", &["\u{600}\u{600}"],
        &["\u{600}", "\u{600}"]), ("\u{600}\u{903}", &["\u{600}\u{903}"], &["\u{600}", "\u{903}"]),
        ("\u{600}\u{308}\u{903}", &["\u{600}\u{308}\u{903}"], &["\u{600}\u{308}", "\u{903}"]),
        ("\u{600}\u{1100}", &["\u{600}\u{1100}"], &["\u{600}", "\u{1100}"]), ("\u{600}\u{1160}",
        &["\u{600}\u{1160}"], &["\u{600}", "\u{1160}"]), ("\u{600}\u{11a8}", &["\u{600}\u{11a8}"],
        &["\u{600}", "\u{11a8}"]), ("\u{600}\u{ac00}", &["\u{600}\u{ac00}"], &["\u{600}",
        "\u{ac00}"]), ("\u{600}\u{ac01}", &["\u{600}\u{ac01}"], &["\u{600}", "\u{ac01}"]),
        ("\u{600}\u{1f1e6}", &["\u{600}\u{1f1e6}"], &["\u{600}", "\u{1f1e6}"]), ("\u{600}\u{261d}",
        &["\u{600}\u{261d}"], &["\u{600}", "\u{261d}"]), ("\u{600}\u{1f3fb}", &["\u{600}\u{1f3fb}"],
        &["\u{600}", "\u{1f3fb}"]), ("\u{600}\u{2764}", &["\u{600}\u{2764}"], &["\u{600}",
        "\u{2764}"]), ("\u{600}\u{1f466}", &["\u{600}\u{1f466}"], &["\u{600}", "\u{1f466}"]),
        ("\u{600}\u{378}", &["\u{600}\u{378}"], &["\u{600}", "\u{378}"]), ("\u{903}\u{903}",
        &["\u{903}\u{903}"], &["\u{903}", "\u{903}"]), ("\u{903}\u{308}\u{903}",
        &["\u{903}\u{308}\u{903}"], &["\u{903}\u{308}", "\u{903}"]), ("\u{1100}\u{903}",
        &["\u{1100}\u{903}"], &["\u{1100}", "\u{903}"]), ("\u{1100}\u{308}\u{903}",
        &["\u{1100}\u{308}\u{903}"], &["\u{1100}\u{308}", "\u{903}"]), ("\u{1160}\u{903}",
        &["\u{1160}\u{903}"], &["\u{1160}", "\u{903}"]), ("\u{1160}\u{308}\u{903}",
        &["\u{1160}\u{308}\u{903}"], &["\u{1160}\u{308}", "\u{903}"]), ("\u{11a8}\u{903}",
        &["\u{11a8}\u{903}"], &["\u{11a8}", "\u{903}"]), ("\u{11a8}\u{308}\u{903}",
        &["\u{11a8}\u{308}\u{903}"], &["\u{11a8}\u{308}", "\u{903}"]), ("\u{ac00}\u{903}",
        &["\u{ac00}\u{903}"], &["\u{ac00}", "\u{903}"]), ("\u{ac00}\u{308}\u{903}",
        &["\u{ac00}\u{308}\u{903}"], &["\u{ac00}\u{308}", "\u{903}"]), ("\u{ac01}\u{903}",
        &["\u{ac01}\u{903}"], &["\u{ac01}", "\u{903}"]), ("\u{ac01}\u{308}\u{903}",
        &["\u{ac01}\u{308}\u{903}"], &["\u{ac01}\u{308}", "\u{903}"]), ("\u{1f1e6}\u{903}",
        &["\u{1f1e6}\u{903}"], &["\u{1f1e6}", "\u{903}"]), ("\u{1f1e6}\u{308}\u{903}",
        &["\u{1f1e6}\u{308}\u{903}"], &["\u{1f1e6}\u{308}", "\u{903}"]), ("\u{261d}\u{903}",
        &["\u{261d}\u{903}"], &["\u{261d}", "\u{903}"]), ("\u{261d}\u{308}\u{903}",
        &["\u{261d}\u{308}\u{903}"], &["\u{261d}\u{308}", "\u{903}"]), ("\u{1f3fb}\u{903}",
        &["\u{1f3fb}\u{903}"], &["\u{1f3fb}", "\u{903}"]), ("\u{1f3fb}\u{308}\u{903}",
        &["\u{1f3fb}\u{308}\u{903}"], &["\u{1f3fb}\u{308}", "\u{903}"]), ("\u{200d}\u{903}",
        &["\u{200d}\u{903}"], &["\u{200d}", "\u{903}"]), ("\u{200d}\u{308}\u{903}",
        &["\u{200d}\u{308}\u{903}"], &["\u{200d}\u{308}", "\u{903}"]), ("\u{2764}\u{903}",
        &["\u{2764}\u{903}"], &["\u{2764}", "\u{903}"]), ("\u{2764}\u{308}\u{903}",
        &["\u{2764}\u{308}\u{903}"], &["\u{2764}\u{308}", "\u{903}"]), ("\u{1f466}\u{903}",
        &["\u{1f466}\u{903}"], &["\u{1f466}", "\u{903}"]), ("\u{1f466}\u{308}\u{903}",
        &["\u{1f466}\u{308}\u{903}"], &["\u{1f466}\u{308}", "\u{903}"]), ("\u{378}\u{903}",
        &["\u{378}\u{903}"], &["\u{378}", "\u{903}"]), ("\u{378}\u{308}\u{903}",
        &["\u{378}\u{308}\u{903}"], &["\u{378}\u{308}", "\u{903}"]), ("\u{61}\u{903}\u{62}",
        &["\u{61}\u{903}", "\u{62}"], &["\u{61}", "\u{903}", "\u{62}"]), ("\u{61}\u{600}\u{62}",
        &["\u{61}", "\u{600}\u{62}"], &["\u{61}", "\u{600}", "\u{62}"])
    ];

    // official Unicode test data
    // http://www.unicode.org/Public/9.0.0/ucd/auxiliary/WordBreakTest.txt
    pub const TEST_WORD: &'static [(&'static str, &'static [&'static str])] = &[
        ("\u{1}\u{1}", &["\u{1}", "\u{1}"]), ("\u{1}\u{308}\u{1}", &["\u{1}\u{308}", "\u{1}"]),
        ("\u{1}\u{d}", &["\u{1}", "\u{d}"]), ("\u{1}\u{308}\u{d}", &["\u{1}\u{308}", "\u{d}"]),
        ("\u{1}\u{a}", &["\u{1}", "\u{a}"]), ("\u{1}\u{308}\u{a}", &["\u{1}\u{308}", "\u{a}"]),
        ("\u{1}\u{b}", &["\u{1}", "\u{b}"]), ("\u{1}\u{308}\u{b}", &["\u{1}\u{308}", "\u{b}"]),
        ("\u{1}\u{3031}", &["\u{1}", "\u{3031}"]), ("\u{1}\u{308}\u{3031}", &["\u{1}\u{308}",
        "\u{3031}"]), ("\u{1}\u{41}", &["\u{1}", "\u{41}"]), ("\u{1}\u{308}\u{41}",
        &["\u{1}\u{308}", "\u{41}"]), ("\u{1}\u{3a}", &["\u{1}", "\u{3a}"]), ("\u{1}\u{308}\u{3a}",
        &["\u{1}\u{308}", "\u{3a}"]), ("\u{1}\u{2c}", &["\u{1}", "\u{2c}"]), ("\u{1}\u{308}\u{2c}",
        &["\u{1}\u{308}", "\u{2c}"]), ("\u{1}\u{2e}", &["\u{1}", "\u{2e}"]), ("\u{1}\u{308}\u{2e}",
        &["\u{1}\u{308}", "\u{2e}"]), ("\u{1}\u{30}", &["\u{1}", "\u{30}"]), ("\u{1}\u{308}\u{30}",
        &["\u{1}\u{308}", "\u{30}"]), ("\u{1}\u{5f}", &["\u{1}", "\u{5f}"]), ("\u{1}\u{308}\u{5f}",
        &["\u{1}\u{308}", "\u{5f}"]), ("\u{1}\u{1f1e6}", &["\u{1}", "\u{1f1e6}"]),
        ("\u{1}\u{308}\u{1f1e6}", &["\u{1}\u{308}", "\u{1f1e6}"]), ("\u{1}\u{5d0}", &["\u{1}",
        "\u{5d0}"]), ("\u{1}\u{308}\u{5d0}", &["\u{1}\u{308}", "\u{5d0}"]), ("\u{1}\u{22}",
        &["\u{1}", "\u{22}"]), ("\u{1}\u{308}\u{22}", &["\u{1}\u{308}", "\u{22}"]), ("\u{1}\u{27}",
        &["\u{1}", "\u{27}"]), ("\u{1}\u{308}\u{27}", &["\u{1}\u{308}", "\u{27}"]),
        ("\u{1}\u{261d}", &["\u{1}", "\u{261d}"]), ("\u{1}\u{308}\u{261d}", &["\u{1}\u{308}",
        "\u{261d}"]), ("\u{1}\u{1f3fb}", &["\u{1}", "\u{1f3fb}"]), ("\u{1}\u{308}\u{1f3fb}",
        &["\u{1}\u{308}", "\u{1f3fb}"]), ("\u{1}\u{2764}", &["\u{1}", "\u{2764}"]),
        ("\u{1}\u{308}\u{2764}", &["\u{1}\u{308}", "\u{2764}"]), ("\u{1}\u{1f466}", &["\u{1}",
        "\u{1f466}"]), ("\u{1}\u{308}\u{1f466}", &["\u{1}\u{308}", "\u{1f466}"]), ("\u{1}\u{ad}",
        &["\u{1}\u{ad}"]), ("\u{1}\u{308}\u{ad}", &["\u{1}\u{308}\u{ad}"]), ("\u{1}\u{300}",
        &["\u{1}\u{300}"]), ("\u{1}\u{308}\u{300}", &["\u{1}\u{308}\u{300}"]), ("\u{1}\u{200d}",
        &["\u{1}\u{200d}"]), ("\u{1}\u{308}\u{200d}", &["\u{1}\u{308}\u{200d}"]),
        ("\u{1}\u{61}\u{2060}", &["\u{1}", "\u{61}\u{2060}"]), ("\u{1}\u{308}\u{61}\u{2060}",
        &["\u{1}\u{308}", "\u{61}\u{2060}"]), ("\u{1}\u{61}\u{3a}", &["\u{1}", "\u{61}", "\u{3a}"]),
        ("\u{1}\u{308}\u{61}\u{3a}", &["\u{1}\u{308}", "\u{61}", "\u{3a}"]), ("\u{1}\u{61}\u{27}",
        &["\u{1}", "\u{61}", "\u{27}"]), ("\u{1}\u{308}\u{61}\u{27}", &["\u{1}\u{308}", "\u{61}",
        "\u{27}"]), ("\u{1}\u{61}\u{27}\u{2060}", &["\u{1}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{1}\u{308}\u{61}\u{27}\u{2060}", &["\u{1}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{1}\u{61}\u{2c}", &["\u{1}", "\u{61}", "\u{2c}"]), ("\u{1}\u{308}\u{61}\u{2c}",
        &["\u{1}\u{308}", "\u{61}", "\u{2c}"]), ("\u{1}\u{31}\u{3a}", &["\u{1}", "\u{31}",
        "\u{3a}"]), ("\u{1}\u{308}\u{31}\u{3a}", &["\u{1}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{1}\u{31}\u{27}", &["\u{1}", "\u{31}", "\u{27}"]), ("\u{1}\u{308}\u{31}\u{27}",
        &["\u{1}\u{308}", "\u{31}", "\u{27}"]), ("\u{1}\u{31}\u{2c}", &["\u{1}", "\u{31}",
        "\u{2c}"]), ("\u{1}\u{308}\u{31}\u{2c}", &["\u{1}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{1}\u{31}\u{2e}\u{2060}", &["\u{1}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{1}\u{308}\u{31}\u{2e}\u{2060}", &["\u{1}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{d}\u{1}", &["\u{d}", "\u{1}"]), ("\u{d}\u{308}\u{1}", &["\u{d}", "\u{308}", "\u{1}"]),
        ("\u{d}\u{d}", &["\u{d}", "\u{d}"]), ("\u{d}\u{308}\u{d}", &["\u{d}", "\u{308}", "\u{d}"]),
        ("\u{d}\u{a}", &["\u{d}\u{a}"]), ("\u{d}\u{308}\u{a}", &["\u{d}", "\u{308}", "\u{a}"]),
        ("\u{d}\u{b}", &["\u{d}", "\u{b}"]), ("\u{d}\u{308}\u{b}", &["\u{d}", "\u{308}", "\u{b}"]),
        ("\u{d}\u{3031}", &["\u{d}", "\u{3031}"]), ("\u{d}\u{308}\u{3031}", &["\u{d}", "\u{308}",
        "\u{3031}"]), ("\u{d}\u{41}", &["\u{d}", "\u{41}"]), ("\u{d}\u{308}\u{41}", &["\u{d}",
        "\u{308}", "\u{41}"]), ("\u{d}\u{3a}", &["\u{d}", "\u{3a}"]), ("\u{d}\u{308}\u{3a}",
        &["\u{d}", "\u{308}", "\u{3a}"]), ("\u{d}\u{2c}", &["\u{d}", "\u{2c}"]),
        ("\u{d}\u{308}\u{2c}", &["\u{d}", "\u{308}", "\u{2c}"]), ("\u{d}\u{2e}", &["\u{d}",
        "\u{2e}"]), ("\u{d}\u{308}\u{2e}", &["\u{d}", "\u{308}", "\u{2e}"]), ("\u{d}\u{30}",
        &["\u{d}", "\u{30}"]), ("\u{d}\u{308}\u{30}", &["\u{d}", "\u{308}", "\u{30}"]),
        ("\u{d}\u{5f}", &["\u{d}", "\u{5f}"]), ("\u{d}\u{308}\u{5f}", &["\u{d}", "\u{308}",
        "\u{5f}"]), ("\u{d}\u{1f1e6}", &["\u{d}", "\u{1f1e6}"]), ("\u{d}\u{308}\u{1f1e6}",
        &["\u{d}", "\u{308}", "\u{1f1e6}"]), ("\u{d}\u{5d0}", &["\u{d}", "\u{5d0}"]),
        ("\u{d}\u{308}\u{5d0}", &["\u{d}", "\u{308}", "\u{5d0}"]), ("\u{d}\u{22}", &["\u{d}",
        "\u{22}"]), ("\u{d}\u{308}\u{22}", &["\u{d}", "\u{308}", "\u{22}"]), ("\u{d}\u{27}",
        &["\u{d}", "\u{27}"]), ("\u{d}\u{308}\u{27}", &["\u{d}", "\u{308}", "\u{27}"]),
        ("\u{d}\u{261d}", &["\u{d}", "\u{261d}"]), ("\u{d}\u{308}\u{261d}", &["\u{d}", "\u{308}",
        "\u{261d}"]), ("\u{d}\u{1f3fb}", &["\u{d}", "\u{1f3fb}"]), ("\u{d}\u{308}\u{1f3fb}",
        &["\u{d}", "\u{308}", "\u{1f3fb}"]), ("\u{d}\u{2764}", &["\u{d}", "\u{2764}"]),
        ("\u{d}\u{308}\u{2764}", &["\u{d}", "\u{308}", "\u{2764}"]), ("\u{d}\u{1f466}", &["\u{d}",
        "\u{1f466}"]), ("\u{d}\u{308}\u{1f466}", &["\u{d}", "\u{308}", "\u{1f466}"]),
        ("\u{d}\u{ad}", &["\u{d}", "\u{ad}"]), ("\u{d}\u{308}\u{ad}", &["\u{d}", "\u{308}\u{ad}"]),
        ("\u{d}\u{300}", &["\u{d}", "\u{300}"]), ("\u{d}\u{308}\u{300}", &["\u{d}",
        "\u{308}\u{300}"]), ("\u{d}\u{200d}", &["\u{d}", "\u{200d}"]), ("\u{d}\u{308}\u{200d}",
        &["\u{d}", "\u{308}\u{200d}"]), ("\u{d}\u{61}\u{2060}", &["\u{d}", "\u{61}\u{2060}"]),
        ("\u{d}\u{308}\u{61}\u{2060}", &["\u{d}", "\u{308}", "\u{61}\u{2060}"]),
        ("\u{d}\u{61}\u{3a}", &["\u{d}", "\u{61}", "\u{3a}"]), ("\u{d}\u{308}\u{61}\u{3a}",
        &["\u{d}", "\u{308}", "\u{61}", "\u{3a}"]), ("\u{d}\u{61}\u{27}", &["\u{d}", "\u{61}",
        "\u{27}"]), ("\u{d}\u{308}\u{61}\u{27}", &["\u{d}", "\u{308}", "\u{61}", "\u{27}"]),
        ("\u{d}\u{61}\u{27}\u{2060}", &["\u{d}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{d}\u{308}\u{61}\u{27}\u{2060}", &["\u{d}", "\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{d}\u{61}\u{2c}", &["\u{d}", "\u{61}", "\u{2c}"]), ("\u{d}\u{308}\u{61}\u{2c}",
        &["\u{d}", "\u{308}", "\u{61}", "\u{2c}"]), ("\u{d}\u{31}\u{3a}", &["\u{d}", "\u{31}",
        "\u{3a}"]), ("\u{d}\u{308}\u{31}\u{3a}", &["\u{d}", "\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{d}\u{31}\u{27}", &["\u{d}", "\u{31}", "\u{27}"]), ("\u{d}\u{308}\u{31}\u{27}",
        &["\u{d}", "\u{308}", "\u{31}", "\u{27}"]), ("\u{d}\u{31}\u{2c}", &["\u{d}", "\u{31}",
        "\u{2c}"]), ("\u{d}\u{308}\u{31}\u{2c}", &["\u{d}", "\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{d}\u{31}\u{2e}\u{2060}", &["\u{d}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{d}\u{308}\u{31}\u{2e}\u{2060}", &["\u{d}", "\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{a}\u{1}", &["\u{a}", "\u{1}"]), ("\u{a}\u{308}\u{1}", &["\u{a}", "\u{308}", "\u{1}"]),
        ("\u{a}\u{d}", &["\u{a}", "\u{d}"]), ("\u{a}\u{308}\u{d}", &["\u{a}", "\u{308}", "\u{d}"]),
        ("\u{a}\u{a}", &["\u{a}", "\u{a}"]), ("\u{a}\u{308}\u{a}", &["\u{a}", "\u{308}", "\u{a}"]),
        ("\u{a}\u{b}", &["\u{a}", "\u{b}"]), ("\u{a}\u{308}\u{b}", &["\u{a}", "\u{308}", "\u{b}"]),
        ("\u{a}\u{3031}", &["\u{a}", "\u{3031}"]), ("\u{a}\u{308}\u{3031}", &["\u{a}", "\u{308}",
        "\u{3031}"]), ("\u{a}\u{41}", &["\u{a}", "\u{41}"]), ("\u{a}\u{308}\u{41}", &["\u{a}",
        "\u{308}", "\u{41}"]), ("\u{a}\u{3a}", &["\u{a}", "\u{3a}"]), ("\u{a}\u{308}\u{3a}",
        &["\u{a}", "\u{308}", "\u{3a}"]), ("\u{a}\u{2c}", &["\u{a}", "\u{2c}"]),
        ("\u{a}\u{308}\u{2c}", &["\u{a}", "\u{308}", "\u{2c}"]), ("\u{a}\u{2e}", &["\u{a}",
        "\u{2e}"]), ("\u{a}\u{308}\u{2e}", &["\u{a}", "\u{308}", "\u{2e}"]), ("\u{a}\u{30}",
        &["\u{a}", "\u{30}"]), ("\u{a}\u{308}\u{30}", &["\u{a}", "\u{308}", "\u{30}"]),
        ("\u{a}\u{5f}", &["\u{a}", "\u{5f}"]), ("\u{a}\u{308}\u{5f}", &["\u{a}", "\u{308}",
        "\u{5f}"]), ("\u{a}\u{1f1e6}", &["\u{a}", "\u{1f1e6}"]), ("\u{a}\u{308}\u{1f1e6}",
        &["\u{a}", "\u{308}", "\u{1f1e6}"]), ("\u{a}\u{5d0}", &["\u{a}", "\u{5d0}"]),
        ("\u{a}\u{308}\u{5d0}", &["\u{a}", "\u{308}", "\u{5d0}"]), ("\u{a}\u{22}", &["\u{a}",
        "\u{22}"]), ("\u{a}\u{308}\u{22}", &["\u{a}", "\u{308}", "\u{22}"]), ("\u{a}\u{27}",
        &["\u{a}", "\u{27}"]), ("\u{a}\u{308}\u{27}", &["\u{a}", "\u{308}", "\u{27}"]),
        ("\u{a}\u{261d}", &["\u{a}", "\u{261d}"]), ("\u{a}\u{308}\u{261d}", &["\u{a}", "\u{308}",
        "\u{261d}"]), ("\u{a}\u{1f3fb}", &["\u{a}", "\u{1f3fb}"]), ("\u{a}\u{308}\u{1f3fb}",
        &["\u{a}", "\u{308}", "\u{1f3fb}"]), ("\u{a}\u{2764}", &["\u{a}", "\u{2764}"]),
        ("\u{a}\u{308}\u{2764}", &["\u{a}", "\u{308}", "\u{2764}"]), ("\u{a}\u{1f466}", &["\u{a}",
        "\u{1f466}"]), ("\u{a}\u{308}\u{1f466}", &["\u{a}", "\u{308}", "\u{1f466}"]),
        ("\u{a}\u{ad}", &["\u{a}", "\u{ad}"]), ("\u{a}\u{308}\u{ad}", &["\u{a}", "\u{308}\u{ad}"]),
        ("\u{a}\u{300}", &["\u{a}", "\u{300}"]), ("\u{a}\u{308}\u{300}", &["\u{a}",
        "\u{308}\u{300}"]), ("\u{a}\u{200d}", &["\u{a}", "\u{200d}"]), ("\u{a}\u{308}\u{200d}",
        &["\u{a}", "\u{308}\u{200d}"]), ("\u{a}\u{61}\u{2060}", &["\u{a}", "\u{61}\u{2060}"]),
        ("\u{a}\u{308}\u{61}\u{2060}", &["\u{a}", "\u{308}", "\u{61}\u{2060}"]),
        ("\u{a}\u{61}\u{3a}", &["\u{a}", "\u{61}", "\u{3a}"]), ("\u{a}\u{308}\u{61}\u{3a}",
        &["\u{a}", "\u{308}", "\u{61}", "\u{3a}"]), ("\u{a}\u{61}\u{27}", &["\u{a}", "\u{61}",
        "\u{27}"]), ("\u{a}\u{308}\u{61}\u{27}", &["\u{a}", "\u{308}", "\u{61}", "\u{27}"]),
        ("\u{a}\u{61}\u{27}\u{2060}", &["\u{a}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{a}\u{308}\u{61}\u{27}\u{2060}", &["\u{a}", "\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{a}\u{61}\u{2c}", &["\u{a}", "\u{61}", "\u{2c}"]), ("\u{a}\u{308}\u{61}\u{2c}",
        &["\u{a}", "\u{308}", "\u{61}", "\u{2c}"]), ("\u{a}\u{31}\u{3a}", &["\u{a}", "\u{31}",
        "\u{3a}"]), ("\u{a}\u{308}\u{31}\u{3a}", &["\u{a}", "\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{a}\u{31}\u{27}", &["\u{a}", "\u{31}", "\u{27}"]), ("\u{a}\u{308}\u{31}\u{27}",
        &["\u{a}", "\u{308}", "\u{31}", "\u{27}"]), ("\u{a}\u{31}\u{2c}", &["\u{a}", "\u{31}",
        "\u{2c}"]), ("\u{a}\u{308}\u{31}\u{2c}", &["\u{a}", "\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{a}\u{31}\u{2e}\u{2060}", &["\u{a}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{a}\u{308}\u{31}\u{2e}\u{2060}", &["\u{a}", "\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{b}\u{1}", &["\u{b}", "\u{1}"]), ("\u{b}\u{308}\u{1}", &["\u{b}", "\u{308}", "\u{1}"]),
        ("\u{b}\u{d}", &["\u{b}", "\u{d}"]), ("\u{b}\u{308}\u{d}", &["\u{b}", "\u{308}", "\u{d}"]),
        ("\u{b}\u{a}", &["\u{b}", "\u{a}"]), ("\u{b}\u{308}\u{a}", &["\u{b}", "\u{308}", "\u{a}"]),
        ("\u{b}\u{b}", &["\u{b}", "\u{b}"]), ("\u{b}\u{308}\u{b}", &["\u{b}", "\u{308}", "\u{b}"]),
        ("\u{b}\u{3031}", &["\u{b}", "\u{3031}"]), ("\u{b}\u{308}\u{3031}", &["\u{b}", "\u{308}",
        "\u{3031}"]), ("\u{b}\u{41}", &["\u{b}", "\u{41}"]), ("\u{b}\u{308}\u{41}", &["\u{b}",
        "\u{308}", "\u{41}"]), ("\u{b}\u{3a}", &["\u{b}", "\u{3a}"]), ("\u{b}\u{308}\u{3a}",
        &["\u{b}", "\u{308}", "\u{3a}"]), ("\u{b}\u{2c}", &["\u{b}", "\u{2c}"]),
        ("\u{b}\u{308}\u{2c}", &["\u{b}", "\u{308}", "\u{2c}"]), ("\u{b}\u{2e}", &["\u{b}",
        "\u{2e}"]), ("\u{b}\u{308}\u{2e}", &["\u{b}", "\u{308}", "\u{2e}"]), ("\u{b}\u{30}",
        &["\u{b}", "\u{30}"]), ("\u{b}\u{308}\u{30}", &["\u{b}", "\u{308}", "\u{30}"]),
        ("\u{b}\u{5f}", &["\u{b}", "\u{5f}"]), ("\u{b}\u{308}\u{5f}", &["\u{b}", "\u{308}",
        "\u{5f}"]), ("\u{b}\u{1f1e6}", &["\u{b}", "\u{1f1e6}"]), ("\u{b}\u{308}\u{1f1e6}",
        &["\u{b}", "\u{308}", "\u{1f1e6}"]), ("\u{b}\u{5d0}", &["\u{b}", "\u{5d0}"]),
        ("\u{b}\u{308}\u{5d0}", &["\u{b}", "\u{308}", "\u{5d0}"]), ("\u{b}\u{22}", &["\u{b}",
        "\u{22}"]), ("\u{b}\u{308}\u{22}", &["\u{b}", "\u{308}", "\u{22}"]), ("\u{b}\u{27}",
        &["\u{b}", "\u{27}"]), ("\u{b}\u{308}\u{27}", &["\u{b}", "\u{308}", "\u{27}"]),
        ("\u{b}\u{261d}", &["\u{b}", "\u{261d}"]), ("\u{b}\u{308}\u{261d}", &["\u{b}", "\u{308}",
        "\u{261d}"]), ("\u{b}\u{1f3fb}", &["\u{b}", "\u{1f3fb}"]), ("\u{b}\u{308}\u{1f3fb}",
        &["\u{b}", "\u{308}", "\u{1f3fb}"]), ("\u{b}\u{2764}", &["\u{b}", "\u{2764}"]),
        ("\u{b}\u{308}\u{2764}", &["\u{b}", "\u{308}", "\u{2764}"]), ("\u{b}\u{1f466}", &["\u{b}",
        "\u{1f466}"]), ("\u{b}\u{308}\u{1f466}", &["\u{b}", "\u{308}", "\u{1f466}"]),
        ("\u{b}\u{ad}", &["\u{b}", "\u{ad}"]), ("\u{b}\u{308}\u{ad}", &["\u{b}", "\u{308}\u{ad}"]),
        ("\u{b}\u{300}", &["\u{b}", "\u{300}"]), ("\u{b}\u{308}\u{300}", &["\u{b}",
        "\u{308}\u{300}"]), ("\u{b}\u{200d}", &["\u{b}", "\u{200d}"]), ("\u{b}\u{308}\u{200d}",
        &["\u{b}", "\u{308}\u{200d}"]), ("\u{b}\u{61}\u{2060}", &["\u{b}", "\u{61}\u{2060}"]),
        ("\u{b}\u{308}\u{61}\u{2060}", &["\u{b}", "\u{308}", "\u{61}\u{2060}"]),
        ("\u{b}\u{61}\u{3a}", &["\u{b}", "\u{61}", "\u{3a}"]), ("\u{b}\u{308}\u{61}\u{3a}",
        &["\u{b}", "\u{308}", "\u{61}", "\u{3a}"]), ("\u{b}\u{61}\u{27}", &["\u{b}", "\u{61}",
        "\u{27}"]), ("\u{b}\u{308}\u{61}\u{27}", &["\u{b}", "\u{308}", "\u{61}", "\u{27}"]),
        ("\u{b}\u{61}\u{27}\u{2060}", &["\u{b}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{b}\u{308}\u{61}\u{27}\u{2060}", &["\u{b}", "\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{b}\u{61}\u{2c}", &["\u{b}", "\u{61}", "\u{2c}"]), ("\u{b}\u{308}\u{61}\u{2c}",
        &["\u{b}", "\u{308}", "\u{61}", "\u{2c}"]), ("\u{b}\u{31}\u{3a}", &["\u{b}", "\u{31}",
        "\u{3a}"]), ("\u{b}\u{308}\u{31}\u{3a}", &["\u{b}", "\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{b}\u{31}\u{27}", &["\u{b}", "\u{31}", "\u{27}"]), ("\u{b}\u{308}\u{31}\u{27}",
        &["\u{b}", "\u{308}", "\u{31}", "\u{27}"]), ("\u{b}\u{31}\u{2c}", &["\u{b}", "\u{31}",
        "\u{2c}"]), ("\u{b}\u{308}\u{31}\u{2c}", &["\u{b}", "\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{b}\u{31}\u{2e}\u{2060}", &["\u{b}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{b}\u{308}\u{31}\u{2e}\u{2060}", &["\u{b}", "\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{3031}\u{1}", &["\u{3031}", "\u{1}"]), ("\u{3031}\u{308}\u{1}", &["\u{3031}\u{308}",
        "\u{1}"]), ("\u{3031}\u{d}", &["\u{3031}", "\u{d}"]), ("\u{3031}\u{308}\u{d}",
        &["\u{3031}\u{308}", "\u{d}"]), ("\u{3031}\u{a}", &["\u{3031}", "\u{a}"]),
        ("\u{3031}\u{308}\u{a}", &["\u{3031}\u{308}", "\u{a}"]), ("\u{3031}\u{b}", &["\u{3031}",
        "\u{b}"]), ("\u{3031}\u{308}\u{b}", &["\u{3031}\u{308}", "\u{b}"]), ("\u{3031}\u{3031}",
        &["\u{3031}\u{3031}"]), ("\u{3031}\u{308}\u{3031}", &["\u{3031}\u{308}\u{3031}"]),
        ("\u{3031}\u{41}", &["\u{3031}", "\u{41}"]), ("\u{3031}\u{308}\u{41}", &["\u{3031}\u{308}",
        "\u{41}"]), ("\u{3031}\u{3a}", &["\u{3031}", "\u{3a}"]), ("\u{3031}\u{308}\u{3a}",
        &["\u{3031}\u{308}", "\u{3a}"]), ("\u{3031}\u{2c}", &["\u{3031}", "\u{2c}"]),
        ("\u{3031}\u{308}\u{2c}", &["\u{3031}\u{308}", "\u{2c}"]), ("\u{3031}\u{2e}", &["\u{3031}",
        "\u{2e}"]), ("\u{3031}\u{308}\u{2e}", &["\u{3031}\u{308}", "\u{2e}"]), ("\u{3031}\u{30}",
        &["\u{3031}", "\u{30}"]), ("\u{3031}\u{308}\u{30}", &["\u{3031}\u{308}", "\u{30}"]),
        ("\u{3031}\u{5f}", &["\u{3031}\u{5f}"]), ("\u{3031}\u{308}\u{5f}",
        &["\u{3031}\u{308}\u{5f}"]), ("\u{3031}\u{1f1e6}", &["\u{3031}", "\u{1f1e6}"]),
        ("\u{3031}\u{308}\u{1f1e6}", &["\u{3031}\u{308}", "\u{1f1e6}"]), ("\u{3031}\u{5d0}",
        &["\u{3031}", "\u{5d0}"]), ("\u{3031}\u{308}\u{5d0}", &["\u{3031}\u{308}", "\u{5d0}"]),
        ("\u{3031}\u{22}", &["\u{3031}", "\u{22}"]), ("\u{3031}\u{308}\u{22}", &["\u{3031}\u{308}",
        "\u{22}"]), ("\u{3031}\u{27}", &["\u{3031}", "\u{27}"]), ("\u{3031}\u{308}\u{27}",
        &["\u{3031}\u{308}", "\u{27}"]), ("\u{3031}\u{261d}", &["\u{3031}", "\u{261d}"]),
        ("\u{3031}\u{308}\u{261d}", &["\u{3031}\u{308}", "\u{261d}"]), ("\u{3031}\u{1f3fb}",
        &["\u{3031}", "\u{1f3fb}"]), ("\u{3031}\u{308}\u{1f3fb}", &["\u{3031}\u{308}",
        "\u{1f3fb}"]), ("\u{3031}\u{2764}", &["\u{3031}", "\u{2764}"]), ("\u{3031}\u{308}\u{2764}",
        &["\u{3031}\u{308}", "\u{2764}"]), ("\u{3031}\u{1f466}", &["\u{3031}", "\u{1f466}"]),
        ("\u{3031}\u{308}\u{1f466}", &["\u{3031}\u{308}", "\u{1f466}"]), ("\u{3031}\u{ad}",
        &["\u{3031}\u{ad}"]), ("\u{3031}\u{308}\u{ad}", &["\u{3031}\u{308}\u{ad}"]),
        ("\u{3031}\u{300}", &["\u{3031}\u{300}"]), ("\u{3031}\u{308}\u{300}",
        &["\u{3031}\u{308}\u{300}"]), ("\u{3031}\u{200d}", &["\u{3031}\u{200d}"]),
        ("\u{3031}\u{308}\u{200d}", &["\u{3031}\u{308}\u{200d}"]), ("\u{3031}\u{61}\u{2060}",
        &["\u{3031}", "\u{61}\u{2060}"]), ("\u{3031}\u{308}\u{61}\u{2060}", &["\u{3031}\u{308}",
        "\u{61}\u{2060}"]), ("\u{3031}\u{61}\u{3a}", &["\u{3031}", "\u{61}", "\u{3a}"]),
        ("\u{3031}\u{308}\u{61}\u{3a}", &["\u{3031}\u{308}", "\u{61}", "\u{3a}"]),
        ("\u{3031}\u{61}\u{27}", &["\u{3031}", "\u{61}", "\u{27}"]), ("\u{3031}\u{308}\u{61}\u{27}",
        &["\u{3031}\u{308}", "\u{61}", "\u{27}"]), ("\u{3031}\u{61}\u{27}\u{2060}", &["\u{3031}",
        "\u{61}", "\u{27}\u{2060}"]), ("\u{3031}\u{308}\u{61}\u{27}\u{2060}", &["\u{3031}\u{308}",
        "\u{61}", "\u{27}\u{2060}"]), ("\u{3031}\u{61}\u{2c}", &["\u{3031}", "\u{61}", "\u{2c}"]),
        ("\u{3031}\u{308}\u{61}\u{2c}", &["\u{3031}\u{308}", "\u{61}", "\u{2c}"]),
        ("\u{3031}\u{31}\u{3a}", &["\u{3031}", "\u{31}", "\u{3a}"]), ("\u{3031}\u{308}\u{31}\u{3a}",
        &["\u{3031}\u{308}", "\u{31}", "\u{3a}"]), ("\u{3031}\u{31}\u{27}", &["\u{3031}", "\u{31}",
        "\u{27}"]), ("\u{3031}\u{308}\u{31}\u{27}", &["\u{3031}\u{308}", "\u{31}", "\u{27}"]),
        ("\u{3031}\u{31}\u{2c}", &["\u{3031}", "\u{31}", "\u{2c}"]), ("\u{3031}\u{308}\u{31}\u{2c}",
        &["\u{3031}\u{308}", "\u{31}", "\u{2c}"]), ("\u{3031}\u{31}\u{2e}\u{2060}", &["\u{3031}",
        "\u{31}", "\u{2e}\u{2060}"]), ("\u{3031}\u{308}\u{31}\u{2e}\u{2060}", &["\u{3031}\u{308}",
        "\u{31}", "\u{2e}\u{2060}"]), ("\u{41}\u{1}", &["\u{41}", "\u{1}"]), ("\u{41}\u{308}\u{1}",
        &["\u{41}\u{308}", "\u{1}"]), ("\u{41}\u{d}", &["\u{41}", "\u{d}"]), ("\u{41}\u{308}\u{d}",
        &["\u{41}\u{308}", "\u{d}"]), ("\u{41}\u{a}", &["\u{41}", "\u{a}"]), ("\u{41}\u{308}\u{a}",
        &["\u{41}\u{308}", "\u{a}"]), ("\u{41}\u{b}", &["\u{41}", "\u{b}"]), ("\u{41}\u{308}\u{b}",
        &["\u{41}\u{308}", "\u{b}"]), ("\u{41}\u{3031}", &["\u{41}", "\u{3031}"]),
        ("\u{41}\u{308}\u{3031}", &["\u{41}\u{308}", "\u{3031}"]), ("\u{41}\u{41}",
        &["\u{41}\u{41}"]), ("\u{41}\u{308}\u{41}", &["\u{41}\u{308}\u{41}"]), ("\u{41}\u{3a}",
        &["\u{41}", "\u{3a}"]), ("\u{41}\u{308}\u{3a}", &["\u{41}\u{308}", "\u{3a}"]),
        ("\u{41}\u{2c}", &["\u{41}", "\u{2c}"]), ("\u{41}\u{308}\u{2c}", &["\u{41}\u{308}",
        "\u{2c}"]), ("\u{41}\u{2e}", &["\u{41}", "\u{2e}"]), ("\u{41}\u{308}\u{2e}",
        &["\u{41}\u{308}", "\u{2e}"]), ("\u{41}\u{30}", &["\u{41}\u{30}"]), ("\u{41}\u{308}\u{30}",
        &["\u{41}\u{308}\u{30}"]), ("\u{41}\u{5f}", &["\u{41}\u{5f}"]), ("\u{41}\u{308}\u{5f}",
        &["\u{41}\u{308}\u{5f}"]), ("\u{41}\u{1f1e6}", &["\u{41}", "\u{1f1e6}"]),
        ("\u{41}\u{308}\u{1f1e6}", &["\u{41}\u{308}", "\u{1f1e6}"]), ("\u{41}\u{5d0}",
        &["\u{41}\u{5d0}"]), ("\u{41}\u{308}\u{5d0}", &["\u{41}\u{308}\u{5d0}"]), ("\u{41}\u{22}",
        &["\u{41}", "\u{22}"]), ("\u{41}\u{308}\u{22}", &["\u{41}\u{308}", "\u{22}"]),
        ("\u{41}\u{27}", &["\u{41}", "\u{27}"]), ("\u{41}\u{308}\u{27}", &["\u{41}\u{308}",
        "\u{27}"]), ("\u{41}\u{261d}", &["\u{41}", "\u{261d}"]), ("\u{41}\u{308}\u{261d}",
        &["\u{41}\u{308}", "\u{261d}"]), ("\u{41}\u{1f3fb}", &["\u{41}", "\u{1f3fb}"]),
        ("\u{41}\u{308}\u{1f3fb}", &["\u{41}\u{308}", "\u{1f3fb}"]), ("\u{41}\u{2764}", &["\u{41}",
        "\u{2764}"]), ("\u{41}\u{308}\u{2764}", &["\u{41}\u{308}", "\u{2764}"]), ("\u{41}\u{1f466}",
        &["\u{41}", "\u{1f466}"]), ("\u{41}\u{308}\u{1f466}", &["\u{41}\u{308}", "\u{1f466}"]),
        ("\u{41}\u{ad}", &["\u{41}\u{ad}"]), ("\u{41}\u{308}\u{ad}", &["\u{41}\u{308}\u{ad}"]),
        ("\u{41}\u{300}", &["\u{41}\u{300}"]), ("\u{41}\u{308}\u{300}", &["\u{41}\u{308}\u{300}"]),
        ("\u{41}\u{200d}", &["\u{41}\u{200d}"]), ("\u{41}\u{308}\u{200d}",
        &["\u{41}\u{308}\u{200d}"]), ("\u{41}\u{61}\u{2060}", &["\u{41}\u{61}\u{2060}"]),
        ("\u{41}\u{308}\u{61}\u{2060}", &["\u{41}\u{308}\u{61}\u{2060}"]), ("\u{41}\u{61}\u{3a}",
        &["\u{41}\u{61}", "\u{3a}"]), ("\u{41}\u{308}\u{61}\u{3a}", &["\u{41}\u{308}\u{61}",
        "\u{3a}"]), ("\u{41}\u{61}\u{27}", &["\u{41}\u{61}", "\u{27}"]),
        ("\u{41}\u{308}\u{61}\u{27}", &["\u{41}\u{308}\u{61}", "\u{27}"]),
        ("\u{41}\u{61}\u{27}\u{2060}", &["\u{41}\u{61}", "\u{27}\u{2060}"]),
        ("\u{41}\u{308}\u{61}\u{27}\u{2060}", &["\u{41}\u{308}\u{61}", "\u{27}\u{2060}"]),
        ("\u{41}\u{61}\u{2c}", &["\u{41}\u{61}", "\u{2c}"]), ("\u{41}\u{308}\u{61}\u{2c}",
        &["\u{41}\u{308}\u{61}", "\u{2c}"]), ("\u{41}\u{31}\u{3a}", &["\u{41}\u{31}", "\u{3a}"]),
        ("\u{41}\u{308}\u{31}\u{3a}", &["\u{41}\u{308}\u{31}", "\u{3a}"]), ("\u{41}\u{31}\u{27}",
        &["\u{41}\u{31}", "\u{27}"]), ("\u{41}\u{308}\u{31}\u{27}", &["\u{41}\u{308}\u{31}",
        "\u{27}"]), ("\u{41}\u{31}\u{2c}", &["\u{41}\u{31}", "\u{2c}"]),
        ("\u{41}\u{308}\u{31}\u{2c}", &["\u{41}\u{308}\u{31}", "\u{2c}"]),
        ("\u{41}\u{31}\u{2e}\u{2060}", &["\u{41}\u{31}", "\u{2e}\u{2060}"]),
        ("\u{41}\u{308}\u{31}\u{2e}\u{2060}", &["\u{41}\u{308}\u{31}", "\u{2e}\u{2060}"]),
        ("\u{3a}\u{1}", &["\u{3a}", "\u{1}"]), ("\u{3a}\u{308}\u{1}", &["\u{3a}\u{308}", "\u{1}"]),
        ("\u{3a}\u{d}", &["\u{3a}", "\u{d}"]), ("\u{3a}\u{308}\u{d}", &["\u{3a}\u{308}", "\u{d}"]),
        ("\u{3a}\u{a}", &["\u{3a}", "\u{a}"]), ("\u{3a}\u{308}\u{a}", &["\u{3a}\u{308}", "\u{a}"]),
        ("\u{3a}\u{b}", &["\u{3a}", "\u{b}"]), ("\u{3a}\u{308}\u{b}", &["\u{3a}\u{308}", "\u{b}"]),
        ("\u{3a}\u{3031}", &["\u{3a}", "\u{3031}"]), ("\u{3a}\u{308}\u{3031}", &["\u{3a}\u{308}",
        "\u{3031}"]), ("\u{3a}\u{41}", &["\u{3a}", "\u{41}"]), ("\u{3a}\u{308}\u{41}",
        &["\u{3a}\u{308}", "\u{41}"]), ("\u{3a}\u{3a}", &["\u{3a}", "\u{3a}"]),
        ("\u{3a}\u{308}\u{3a}", &["\u{3a}\u{308}", "\u{3a}"]), ("\u{3a}\u{2c}", &["\u{3a}",
        "\u{2c}"]), ("\u{3a}\u{308}\u{2c}", &["\u{3a}\u{308}", "\u{2c}"]), ("\u{3a}\u{2e}",
        &["\u{3a}", "\u{2e}"]), ("\u{3a}\u{308}\u{2e}", &["\u{3a}\u{308}", "\u{2e}"]),
        ("\u{3a}\u{30}", &["\u{3a}", "\u{30}"]), ("\u{3a}\u{308}\u{30}", &["\u{3a}\u{308}",
        "\u{30}"]), ("\u{3a}\u{5f}", &["\u{3a}", "\u{5f}"]), ("\u{3a}\u{308}\u{5f}",
        &["\u{3a}\u{308}", "\u{5f}"]), ("\u{3a}\u{1f1e6}", &["\u{3a}", "\u{1f1e6}"]),
        ("\u{3a}\u{308}\u{1f1e6}", &["\u{3a}\u{308}", "\u{1f1e6}"]), ("\u{3a}\u{5d0}", &["\u{3a}",
        "\u{5d0}"]), ("\u{3a}\u{308}\u{5d0}", &["\u{3a}\u{308}", "\u{5d0}"]), ("\u{3a}\u{22}",
        &["\u{3a}", "\u{22}"]), ("\u{3a}\u{308}\u{22}", &["\u{3a}\u{308}", "\u{22}"]),
        ("\u{3a}\u{27}", &["\u{3a}", "\u{27}"]), ("\u{3a}\u{308}\u{27}", &["\u{3a}\u{308}",
        "\u{27}"]), ("\u{3a}\u{261d}", &["\u{3a}", "\u{261d}"]), ("\u{3a}\u{308}\u{261d}",
        &["\u{3a}\u{308}", "\u{261d}"]), ("\u{3a}\u{1f3fb}", &["\u{3a}", "\u{1f3fb}"]),
        ("\u{3a}\u{308}\u{1f3fb}", &["\u{3a}\u{308}", "\u{1f3fb}"]), ("\u{3a}\u{2764}", &["\u{3a}",
        "\u{2764}"]), ("\u{3a}\u{308}\u{2764}", &["\u{3a}\u{308}", "\u{2764}"]), ("\u{3a}\u{1f466}",
        &["\u{3a}", "\u{1f466}"]), ("\u{3a}\u{308}\u{1f466}", &["\u{3a}\u{308}", "\u{1f466}"]),
        ("\u{3a}\u{ad}", &["\u{3a}\u{ad}"]), ("\u{3a}\u{308}\u{ad}", &["\u{3a}\u{308}\u{ad}"]),
        ("\u{3a}\u{300}", &["\u{3a}\u{300}"]), ("\u{3a}\u{308}\u{300}", &["\u{3a}\u{308}\u{300}"]),
        ("\u{3a}\u{200d}", &["\u{3a}\u{200d}"]), ("\u{3a}\u{308}\u{200d}",
        &["\u{3a}\u{308}\u{200d}"]), ("\u{3a}\u{61}\u{2060}", &["\u{3a}", "\u{61}\u{2060}"]),
        ("\u{3a}\u{308}\u{61}\u{2060}", &["\u{3a}\u{308}", "\u{61}\u{2060}"]),
        ("\u{3a}\u{61}\u{3a}", &["\u{3a}", "\u{61}", "\u{3a}"]), ("\u{3a}\u{308}\u{61}\u{3a}",
        &["\u{3a}\u{308}", "\u{61}", "\u{3a}"]), ("\u{3a}\u{61}\u{27}", &["\u{3a}", "\u{61}",
        "\u{27}"]), ("\u{3a}\u{308}\u{61}\u{27}", &["\u{3a}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{3a}\u{61}\u{27}\u{2060}", &["\u{3a}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{3a}\u{308}\u{61}\u{27}\u{2060}", &["\u{3a}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{3a}\u{61}\u{2c}", &["\u{3a}", "\u{61}", "\u{2c}"]), ("\u{3a}\u{308}\u{61}\u{2c}",
        &["\u{3a}\u{308}", "\u{61}", "\u{2c}"]), ("\u{3a}\u{31}\u{3a}", &["\u{3a}", "\u{31}",
        "\u{3a}"]), ("\u{3a}\u{308}\u{31}\u{3a}", &["\u{3a}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{3a}\u{31}\u{27}", &["\u{3a}", "\u{31}", "\u{27}"]), ("\u{3a}\u{308}\u{31}\u{27}",
        &["\u{3a}\u{308}", "\u{31}", "\u{27}"]), ("\u{3a}\u{31}\u{2c}", &["\u{3a}", "\u{31}",
        "\u{2c}"]), ("\u{3a}\u{308}\u{31}\u{2c}", &["\u{3a}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{3a}\u{31}\u{2e}\u{2060}", &["\u{3a}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{3a}\u{308}\u{31}\u{2e}\u{2060}", &["\u{3a}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{2c}\u{1}", &["\u{2c}", "\u{1}"]), ("\u{2c}\u{308}\u{1}", &["\u{2c}\u{308}", "\u{1}"]),
        ("\u{2c}\u{d}", &["\u{2c}", "\u{d}"]), ("\u{2c}\u{308}\u{d}", &["\u{2c}\u{308}", "\u{d}"]),
        ("\u{2c}\u{a}", &["\u{2c}", "\u{a}"]), ("\u{2c}\u{308}\u{a}", &["\u{2c}\u{308}", "\u{a}"]),
        ("\u{2c}\u{b}", &["\u{2c}", "\u{b}"]), ("\u{2c}\u{308}\u{b}", &["\u{2c}\u{308}", "\u{b}"]),
        ("\u{2c}\u{3031}", &["\u{2c}", "\u{3031}"]), ("\u{2c}\u{308}\u{3031}", &["\u{2c}\u{308}",
        "\u{3031}"]), ("\u{2c}\u{41}", &["\u{2c}", "\u{41}"]), ("\u{2c}\u{308}\u{41}",
        &["\u{2c}\u{308}", "\u{41}"]), ("\u{2c}\u{3a}", &["\u{2c}", "\u{3a}"]),
        ("\u{2c}\u{308}\u{3a}", &["\u{2c}\u{308}", "\u{3a}"]), ("\u{2c}\u{2c}", &["\u{2c}",
        "\u{2c}"]), ("\u{2c}\u{308}\u{2c}", &["\u{2c}\u{308}", "\u{2c}"]), ("\u{2c}\u{2e}",
        &["\u{2c}", "\u{2e}"]), ("\u{2c}\u{308}\u{2e}", &["\u{2c}\u{308}", "\u{2e}"]),
        ("\u{2c}\u{30}", &["\u{2c}", "\u{30}"]), ("\u{2c}\u{308}\u{30}", &["\u{2c}\u{308}",
        "\u{30}"]), ("\u{2c}\u{5f}", &["\u{2c}", "\u{5f}"]), ("\u{2c}\u{308}\u{5f}",
        &["\u{2c}\u{308}", "\u{5f}"]), ("\u{2c}\u{1f1e6}", &["\u{2c}", "\u{1f1e6}"]),
        ("\u{2c}\u{308}\u{1f1e6}", &["\u{2c}\u{308}", "\u{1f1e6}"]), ("\u{2c}\u{5d0}", &["\u{2c}",
        "\u{5d0}"]), ("\u{2c}\u{308}\u{5d0}", &["\u{2c}\u{308}", "\u{5d0}"]), ("\u{2c}\u{22}",
        &["\u{2c}", "\u{22}"]), ("\u{2c}\u{308}\u{22}", &["\u{2c}\u{308}", "\u{22}"]),
        ("\u{2c}\u{27}", &["\u{2c}", "\u{27}"]), ("\u{2c}\u{308}\u{27}", &["\u{2c}\u{308}",
        "\u{27}"]), ("\u{2c}\u{261d}", &["\u{2c}", "\u{261d}"]), ("\u{2c}\u{308}\u{261d}",
        &["\u{2c}\u{308}", "\u{261d}"]), ("\u{2c}\u{1f3fb}", &["\u{2c}", "\u{1f3fb}"]),
        ("\u{2c}\u{308}\u{1f3fb}", &["\u{2c}\u{308}", "\u{1f3fb}"]), ("\u{2c}\u{2764}", &["\u{2c}",
        "\u{2764}"]), ("\u{2c}\u{308}\u{2764}", &["\u{2c}\u{308}", "\u{2764}"]), ("\u{2c}\u{1f466}",
        &["\u{2c}", "\u{1f466}"]), ("\u{2c}\u{308}\u{1f466}", &["\u{2c}\u{308}", "\u{1f466}"]),
        ("\u{2c}\u{ad}", &["\u{2c}\u{ad}"]), ("\u{2c}\u{308}\u{ad}", &["\u{2c}\u{308}\u{ad}"]),
        ("\u{2c}\u{300}", &["\u{2c}\u{300}"]), ("\u{2c}\u{308}\u{300}", &["\u{2c}\u{308}\u{300}"]),
        ("\u{2c}\u{200d}", &["\u{2c}\u{200d}"]), ("\u{2c}\u{308}\u{200d}",
        &["\u{2c}\u{308}\u{200d}"]), ("\u{2c}\u{61}\u{2060}", &["\u{2c}", "\u{61}\u{2060}"]),
        ("\u{2c}\u{308}\u{61}\u{2060}", &["\u{2c}\u{308}", "\u{61}\u{2060}"]),
        ("\u{2c}\u{61}\u{3a}", &["\u{2c}", "\u{61}", "\u{3a}"]), ("\u{2c}\u{308}\u{61}\u{3a}",
        &["\u{2c}\u{308}", "\u{61}", "\u{3a}"]), ("\u{2c}\u{61}\u{27}", &["\u{2c}", "\u{61}",
        "\u{27}"]), ("\u{2c}\u{308}\u{61}\u{27}", &["\u{2c}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{2c}\u{61}\u{27}\u{2060}", &["\u{2c}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{2c}\u{308}\u{61}\u{27}\u{2060}", &["\u{2c}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{2c}\u{61}\u{2c}", &["\u{2c}", "\u{61}", "\u{2c}"]), ("\u{2c}\u{308}\u{61}\u{2c}",
        &["\u{2c}\u{308}", "\u{61}", "\u{2c}"]), ("\u{2c}\u{31}\u{3a}", &["\u{2c}", "\u{31}",
        "\u{3a}"]), ("\u{2c}\u{308}\u{31}\u{3a}", &["\u{2c}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{2c}\u{31}\u{27}", &["\u{2c}", "\u{31}", "\u{27}"]), ("\u{2c}\u{308}\u{31}\u{27}",
        &["\u{2c}\u{308}", "\u{31}", "\u{27}"]), ("\u{2c}\u{31}\u{2c}", &["\u{2c}", "\u{31}",
        "\u{2c}"]), ("\u{2c}\u{308}\u{31}\u{2c}", &["\u{2c}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{2c}\u{31}\u{2e}\u{2060}", &["\u{2c}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{2c}\u{308}\u{31}\u{2e}\u{2060}", &["\u{2c}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{2e}\u{1}", &["\u{2e}", "\u{1}"]), ("\u{2e}\u{308}\u{1}", &["\u{2e}\u{308}", "\u{1}"]),
        ("\u{2e}\u{d}", &["\u{2e}", "\u{d}"]), ("\u{2e}\u{308}\u{d}", &["\u{2e}\u{308}", "\u{d}"]),
        ("\u{2e}\u{a}", &["\u{2e}", "\u{a}"]), ("\u{2e}\u{308}\u{a}", &["\u{2e}\u{308}", "\u{a}"]),
        ("\u{2e}\u{b}", &["\u{2e}", "\u{b}"]), ("\u{2e}\u{308}\u{b}", &["\u{2e}\u{308}", "\u{b}"]),
        ("\u{2e}\u{3031}", &["\u{2e}", "\u{3031}"]), ("\u{2e}\u{308}\u{3031}", &["\u{2e}\u{308}",
        "\u{3031}"]), ("\u{2e}\u{41}", &["\u{2e}", "\u{41}"]), ("\u{2e}\u{308}\u{41}",
        &["\u{2e}\u{308}", "\u{41}"]), ("\u{2e}\u{3a}", &["\u{2e}", "\u{3a}"]),
        ("\u{2e}\u{308}\u{3a}", &["\u{2e}\u{308}", "\u{3a}"]), ("\u{2e}\u{2c}", &["\u{2e}",
        "\u{2c}"]), ("\u{2e}\u{308}\u{2c}", &["\u{2e}\u{308}", "\u{2c}"]), ("\u{2e}\u{2e}",
        &["\u{2e}", "\u{2e}"]), ("\u{2e}\u{308}\u{2e}", &["\u{2e}\u{308}", "\u{2e}"]),
        ("\u{2e}\u{30}", &["\u{2e}", "\u{30}"]), ("\u{2e}\u{308}\u{30}", &["\u{2e}\u{308}",
        "\u{30}"]), ("\u{2e}\u{5f}", &["\u{2e}", "\u{5f}"]), ("\u{2e}\u{308}\u{5f}",
        &["\u{2e}\u{308}", "\u{5f}"]), ("\u{2e}\u{1f1e6}", &["\u{2e}", "\u{1f1e6}"]),
        ("\u{2e}\u{308}\u{1f1e6}", &["\u{2e}\u{308}", "\u{1f1e6}"]), ("\u{2e}\u{5d0}", &["\u{2e}",
        "\u{5d0}"]), ("\u{2e}\u{308}\u{5d0}", &["\u{2e}\u{308}", "\u{5d0}"]), ("\u{2e}\u{22}",
        &["\u{2e}", "\u{22}"]), ("\u{2e}\u{308}\u{22}", &["\u{2e}\u{308}", "\u{22}"]),
        ("\u{2e}\u{27}", &["\u{2e}", "\u{27}"]), ("\u{2e}\u{308}\u{27}", &["\u{2e}\u{308}",
        "\u{27}"]), ("\u{2e}\u{261d}", &["\u{2e}", "\u{261d}"]), ("\u{2e}\u{308}\u{261d}",
        &["\u{2e}\u{308}", "\u{261d}"]), ("\u{2e}\u{1f3fb}", &["\u{2e}", "\u{1f3fb}"]),
        ("\u{2e}\u{308}\u{1f3fb}", &["\u{2e}\u{308}", "\u{1f3fb}"]), ("\u{2e}\u{2764}", &["\u{2e}",
        "\u{2764}"]), ("\u{2e}\u{308}\u{2764}", &["\u{2e}\u{308}", "\u{2764}"]), ("\u{2e}\u{1f466}",
        &["\u{2e}", "\u{1f466}"]), ("\u{2e}\u{308}\u{1f466}", &["\u{2e}\u{308}", "\u{1f466}"]),
        ("\u{2e}\u{ad}", &["\u{2e}\u{ad}"]), ("\u{2e}\u{308}\u{ad}", &["\u{2e}\u{308}\u{ad}"]),
        ("\u{2e}\u{300}", &["\u{2e}\u{300}"]), ("\u{2e}\u{308}\u{300}", &["\u{2e}\u{308}\u{300}"]),
        ("\u{2e}\u{200d}", &["\u{2e}\u{200d}"]), ("\u{2e}\u{308}\u{200d}",
        &["\u{2e}\u{308}\u{200d}"]), ("\u{2e}\u{61}\u{2060}", &["\u{2e}", "\u{61}\u{2060}"]),
        ("\u{2e}\u{308}\u{61}\u{2060}", &["\u{2e}\u{308}", "\u{61}\u{2060}"]),
        ("\u{2e}\u{61}\u{3a}", &["\u{2e}", "\u{61}", "\u{3a}"]), ("\u{2e}\u{308}\u{61}\u{3a}",
        &["\u{2e}\u{308}", "\u{61}", "\u{3a}"]), ("\u{2e}\u{61}\u{27}", &["\u{2e}", "\u{61}",
        "\u{27}"]), ("\u{2e}\u{308}\u{61}\u{27}", &["\u{2e}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{2e}\u{61}\u{27}\u{2060}", &["\u{2e}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{2e}\u{308}\u{61}\u{27}\u{2060}", &["\u{2e}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{2e}\u{61}\u{2c}", &["\u{2e}", "\u{61}", "\u{2c}"]), ("\u{2e}\u{308}\u{61}\u{2c}",
        &["\u{2e}\u{308}", "\u{61}", "\u{2c}"]), ("\u{2e}\u{31}\u{3a}", &["\u{2e}", "\u{31}",
        "\u{3a}"]), ("\u{2e}\u{308}\u{31}\u{3a}", &["\u{2e}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{2e}\u{31}\u{27}", &["\u{2e}", "\u{31}", "\u{27}"]), ("\u{2e}\u{308}\u{31}\u{27}",
        &["\u{2e}\u{308}", "\u{31}", "\u{27}"]), ("\u{2e}\u{31}\u{2c}", &["\u{2e}", "\u{31}",
        "\u{2c}"]), ("\u{2e}\u{308}\u{31}\u{2c}", &["\u{2e}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{2e}\u{31}\u{2e}\u{2060}", &["\u{2e}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{2e}\u{308}\u{31}\u{2e}\u{2060}", &["\u{2e}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{30}\u{1}", &["\u{30}", "\u{1}"]), ("\u{30}\u{308}\u{1}", &["\u{30}\u{308}", "\u{1}"]),
        ("\u{30}\u{d}", &["\u{30}", "\u{d}"]), ("\u{30}\u{308}\u{d}", &["\u{30}\u{308}", "\u{d}"]),
        ("\u{30}\u{a}", &["\u{30}", "\u{a}"]), ("\u{30}\u{308}\u{a}", &["\u{30}\u{308}", "\u{a}"]),
        ("\u{30}\u{b}", &["\u{30}", "\u{b}"]), ("\u{30}\u{308}\u{b}", &["\u{30}\u{308}", "\u{b}"]),
        ("\u{30}\u{3031}", &["\u{30}", "\u{3031}"]), ("\u{30}\u{308}\u{3031}", &["\u{30}\u{308}",
        "\u{3031}"]), ("\u{30}\u{41}", &["\u{30}\u{41}"]), ("\u{30}\u{308}\u{41}",
        &["\u{30}\u{308}\u{41}"]), ("\u{30}\u{3a}", &["\u{30}", "\u{3a}"]), ("\u{30}\u{308}\u{3a}",
        &["\u{30}\u{308}", "\u{3a}"]), ("\u{30}\u{2c}", &["\u{30}", "\u{2c}"]),
        ("\u{30}\u{308}\u{2c}", &["\u{30}\u{308}", "\u{2c}"]), ("\u{30}\u{2e}", &["\u{30}",
        "\u{2e}"]), ("\u{30}\u{308}\u{2e}", &["\u{30}\u{308}", "\u{2e}"]), ("\u{30}\u{30}",
        &["\u{30}\u{30}"]), ("\u{30}\u{308}\u{30}", &["\u{30}\u{308}\u{30}"]), ("\u{30}\u{5f}",
        &["\u{30}\u{5f}"]), ("\u{30}\u{308}\u{5f}", &["\u{30}\u{308}\u{5f}"]), ("\u{30}\u{1f1e6}",
        &["\u{30}", "\u{1f1e6}"]), ("\u{30}\u{308}\u{1f1e6}", &["\u{30}\u{308}", "\u{1f1e6}"]),
        ("\u{30}\u{5d0}", &["\u{30}\u{5d0}"]), ("\u{30}\u{308}\u{5d0}", &["\u{30}\u{308}\u{5d0}"]),
        ("\u{30}\u{22}", &["\u{30}", "\u{22}"]), ("\u{30}\u{308}\u{22}", &["\u{30}\u{308}",
        "\u{22}"]), ("\u{30}\u{27}", &["\u{30}", "\u{27}"]), ("\u{30}\u{308}\u{27}",
        &["\u{30}\u{308}", "\u{27}"]), ("\u{30}\u{261d}", &["\u{30}", "\u{261d}"]),
        ("\u{30}\u{308}\u{261d}", &["\u{30}\u{308}", "\u{261d}"]), ("\u{30}\u{1f3fb}", &["\u{30}",
        "\u{1f3fb}"]), ("\u{30}\u{308}\u{1f3fb}", &["\u{30}\u{308}", "\u{1f3fb}"]),
        ("\u{30}\u{2764}", &["\u{30}", "\u{2764}"]), ("\u{30}\u{308}\u{2764}", &["\u{30}\u{308}",
        "\u{2764}"]), ("\u{30}\u{1f466}", &["\u{30}", "\u{1f466}"]), ("\u{30}\u{308}\u{1f466}",
        &["\u{30}\u{308}", "\u{1f466}"]), ("\u{30}\u{ad}", &["\u{30}\u{ad}"]),
        ("\u{30}\u{308}\u{ad}", &["\u{30}\u{308}\u{ad}"]), ("\u{30}\u{300}", &["\u{30}\u{300}"]),
        ("\u{30}\u{308}\u{300}", &["\u{30}\u{308}\u{300}"]), ("\u{30}\u{200d}",
        &["\u{30}\u{200d}"]), ("\u{30}\u{308}\u{200d}", &["\u{30}\u{308}\u{200d}"]),
        ("\u{30}\u{61}\u{2060}", &["\u{30}\u{61}\u{2060}"]), ("\u{30}\u{308}\u{61}\u{2060}",
        &["\u{30}\u{308}\u{61}\u{2060}"]), ("\u{30}\u{61}\u{3a}", &["\u{30}\u{61}", "\u{3a}"]),
        ("\u{30}\u{308}\u{61}\u{3a}", &["\u{30}\u{308}\u{61}", "\u{3a}"]), ("\u{30}\u{61}\u{27}",
        &["\u{30}\u{61}", "\u{27}"]), ("\u{30}\u{308}\u{61}\u{27}", &["\u{30}\u{308}\u{61}",
        "\u{27}"]), ("\u{30}\u{61}\u{27}\u{2060}", &["\u{30}\u{61}", "\u{27}\u{2060}"]),
        ("\u{30}\u{308}\u{61}\u{27}\u{2060}", &["\u{30}\u{308}\u{61}", "\u{27}\u{2060}"]),
        ("\u{30}\u{61}\u{2c}", &["\u{30}\u{61}", "\u{2c}"]), ("\u{30}\u{308}\u{61}\u{2c}",
        &["\u{30}\u{308}\u{61}", "\u{2c}"]), ("\u{30}\u{31}\u{3a}", &["\u{30}\u{31}", "\u{3a}"]),
        ("\u{30}\u{308}\u{31}\u{3a}", &["\u{30}\u{308}\u{31}", "\u{3a}"]), ("\u{30}\u{31}\u{27}",
        &["\u{30}\u{31}", "\u{27}"]), ("\u{30}\u{308}\u{31}\u{27}", &["\u{30}\u{308}\u{31}",
        "\u{27}"]), ("\u{30}\u{31}\u{2c}", &["\u{30}\u{31}", "\u{2c}"]),
        ("\u{30}\u{308}\u{31}\u{2c}", &["\u{30}\u{308}\u{31}", "\u{2c}"]),
        ("\u{30}\u{31}\u{2e}\u{2060}", &["\u{30}\u{31}", "\u{2e}\u{2060}"]),
        ("\u{30}\u{308}\u{31}\u{2e}\u{2060}", &["\u{30}\u{308}\u{31}", "\u{2e}\u{2060}"]),
        ("\u{5f}\u{1}", &["\u{5f}", "\u{1}"]), ("\u{5f}\u{308}\u{1}", &["\u{5f}\u{308}", "\u{1}"]),
        ("\u{5f}\u{d}", &["\u{5f}", "\u{d}"]), ("\u{5f}\u{308}\u{d}", &["\u{5f}\u{308}", "\u{d}"]),
        ("\u{5f}\u{a}", &["\u{5f}", "\u{a}"]), ("\u{5f}\u{308}\u{a}", &["\u{5f}\u{308}", "\u{a}"]),
        ("\u{5f}\u{b}", &["\u{5f}", "\u{b}"]), ("\u{5f}\u{308}\u{b}", &["\u{5f}\u{308}", "\u{b}"]),
        ("\u{5f}\u{3031}", &["\u{5f}\u{3031}"]), ("\u{5f}\u{308}\u{3031}",
        &["\u{5f}\u{308}\u{3031}"]), ("\u{5f}\u{41}", &["\u{5f}\u{41}"]), ("\u{5f}\u{308}\u{41}",
        &["\u{5f}\u{308}\u{41}"]), ("\u{5f}\u{3a}", &["\u{5f}", "\u{3a}"]), ("\u{5f}\u{308}\u{3a}",
        &["\u{5f}\u{308}", "\u{3a}"]), ("\u{5f}\u{2c}", &["\u{5f}", "\u{2c}"]),
        ("\u{5f}\u{308}\u{2c}", &["\u{5f}\u{308}", "\u{2c}"]), ("\u{5f}\u{2e}", &["\u{5f}",
        "\u{2e}"]), ("\u{5f}\u{308}\u{2e}", &["\u{5f}\u{308}", "\u{2e}"]), ("\u{5f}\u{30}",
        &["\u{5f}\u{30}"]), ("\u{5f}\u{308}\u{30}", &["\u{5f}\u{308}\u{30}"]), ("\u{5f}\u{5f}",
        &["\u{5f}\u{5f}"]), ("\u{5f}\u{308}\u{5f}", &["\u{5f}\u{308}\u{5f}"]), ("\u{5f}\u{1f1e6}",
        &["\u{5f}", "\u{1f1e6}"]), ("\u{5f}\u{308}\u{1f1e6}", &["\u{5f}\u{308}", "\u{1f1e6}"]),
        ("\u{5f}\u{5d0}", &["\u{5f}\u{5d0}"]), ("\u{5f}\u{308}\u{5d0}", &["\u{5f}\u{308}\u{5d0}"]),
        ("\u{5f}\u{22}", &["\u{5f}", "\u{22}"]), ("\u{5f}\u{308}\u{22}", &["\u{5f}\u{308}",
        "\u{22}"]), ("\u{5f}\u{27}", &["\u{5f}", "\u{27}"]), ("\u{5f}\u{308}\u{27}",
        &["\u{5f}\u{308}", "\u{27}"]), ("\u{5f}\u{261d}", &["\u{5f}", "\u{261d}"]),
        ("\u{5f}\u{308}\u{261d}", &["\u{5f}\u{308}", "\u{261d}"]), ("\u{5f}\u{1f3fb}", &["\u{5f}",
        "\u{1f3fb}"]), ("\u{5f}\u{308}\u{1f3fb}", &["\u{5f}\u{308}", "\u{1f3fb}"]),
        ("\u{5f}\u{2764}", &["\u{5f}", "\u{2764}"]), ("\u{5f}\u{308}\u{2764}", &["\u{5f}\u{308}",
        "\u{2764}"]), ("\u{5f}\u{1f466}", &["\u{5f}", "\u{1f466}"]), ("\u{5f}\u{308}\u{1f466}",
        &["\u{5f}\u{308}", "\u{1f466}"]), ("\u{5f}\u{ad}", &["\u{5f}\u{ad}"]),
        ("\u{5f}\u{308}\u{ad}", &["\u{5f}\u{308}\u{ad}"]), ("\u{5f}\u{300}", &["\u{5f}\u{300}"]),
        ("\u{5f}\u{308}\u{300}", &["\u{5f}\u{308}\u{300}"]), ("\u{5f}\u{200d}",
        &["\u{5f}\u{200d}"]), ("\u{5f}\u{308}\u{200d}", &["\u{5f}\u{308}\u{200d}"]),
        ("\u{5f}\u{61}\u{2060}", &["\u{5f}\u{61}\u{2060}"]), ("\u{5f}\u{308}\u{61}\u{2060}",
        &["\u{5f}\u{308}\u{61}\u{2060}"]), ("\u{5f}\u{61}\u{3a}", &["\u{5f}\u{61}", "\u{3a}"]),
        ("\u{5f}\u{308}\u{61}\u{3a}", &["\u{5f}\u{308}\u{61}", "\u{3a}"]), ("\u{5f}\u{61}\u{27}",
        &["\u{5f}\u{61}", "\u{27}"]), ("\u{5f}\u{308}\u{61}\u{27}", &["\u{5f}\u{308}\u{61}",
        "\u{27}"]), ("\u{5f}\u{61}\u{27}\u{2060}", &["\u{5f}\u{61}", "\u{27}\u{2060}"]),
        ("\u{5f}\u{308}\u{61}\u{27}\u{2060}", &["\u{5f}\u{308}\u{61}", "\u{27}\u{2060}"]),
        ("\u{5f}\u{61}\u{2c}", &["\u{5f}\u{61}", "\u{2c}"]), ("\u{5f}\u{308}\u{61}\u{2c}",
        &["\u{5f}\u{308}\u{61}", "\u{2c}"]), ("\u{5f}\u{31}\u{3a}", &["\u{5f}\u{31}", "\u{3a}"]),
        ("\u{5f}\u{308}\u{31}\u{3a}", &["\u{5f}\u{308}\u{31}", "\u{3a}"]), ("\u{5f}\u{31}\u{27}",
        &["\u{5f}\u{31}", "\u{27}"]), ("\u{5f}\u{308}\u{31}\u{27}", &["\u{5f}\u{308}\u{31}",
        "\u{27}"]), ("\u{5f}\u{31}\u{2c}", &["\u{5f}\u{31}", "\u{2c}"]),
        ("\u{5f}\u{308}\u{31}\u{2c}", &["\u{5f}\u{308}\u{31}", "\u{2c}"]),
        ("\u{5f}\u{31}\u{2e}\u{2060}", &["\u{5f}\u{31}", "\u{2e}\u{2060}"]),
        ("\u{5f}\u{308}\u{31}\u{2e}\u{2060}", &["\u{5f}\u{308}\u{31}", "\u{2e}\u{2060}"]),
        ("\u{1f1e6}\u{1}", &["\u{1f1e6}", "\u{1}"]), ("\u{1f1e6}\u{308}\u{1}", &["\u{1f1e6}\u{308}",
        "\u{1}"]), ("\u{1f1e6}\u{d}", &["\u{1f1e6}", "\u{d}"]), ("\u{1f1e6}\u{308}\u{d}",
        &["\u{1f1e6}\u{308}", "\u{d}"]), ("\u{1f1e6}\u{a}", &["\u{1f1e6}", "\u{a}"]),
        ("\u{1f1e6}\u{308}\u{a}", &["\u{1f1e6}\u{308}", "\u{a}"]), ("\u{1f1e6}\u{b}", &["\u{1f1e6}",
        "\u{b}"]), ("\u{1f1e6}\u{308}\u{b}", &["\u{1f1e6}\u{308}", "\u{b}"]), ("\u{1f1e6}\u{3031}",
        &["\u{1f1e6}", "\u{3031}"]), ("\u{1f1e6}\u{308}\u{3031}", &["\u{1f1e6}\u{308}",
        "\u{3031}"]), ("\u{1f1e6}\u{41}", &["\u{1f1e6}", "\u{41}"]), ("\u{1f1e6}\u{308}\u{41}",
        &["\u{1f1e6}\u{308}", "\u{41}"]), ("\u{1f1e6}\u{3a}", &["\u{1f1e6}", "\u{3a}"]),
        ("\u{1f1e6}\u{308}\u{3a}", &["\u{1f1e6}\u{308}", "\u{3a}"]), ("\u{1f1e6}\u{2c}",
        &["\u{1f1e6}", "\u{2c}"]), ("\u{1f1e6}\u{308}\u{2c}", &["\u{1f1e6}\u{308}", "\u{2c}"]),
        ("\u{1f1e6}\u{2e}", &["\u{1f1e6}", "\u{2e}"]), ("\u{1f1e6}\u{308}\u{2e}",
        &["\u{1f1e6}\u{308}", "\u{2e}"]), ("\u{1f1e6}\u{30}", &["\u{1f1e6}", "\u{30}"]),
        ("\u{1f1e6}\u{308}\u{30}", &["\u{1f1e6}\u{308}", "\u{30}"]), ("\u{1f1e6}\u{5f}",
        &["\u{1f1e6}", "\u{5f}"]), ("\u{1f1e6}\u{308}\u{5f}", &["\u{1f1e6}\u{308}", "\u{5f}"]),
        ("\u{1f1e6}\u{1f1e6}", &["\u{1f1e6}\u{1f1e6}"]), ("\u{1f1e6}\u{308}\u{1f1e6}",
        &["\u{1f1e6}\u{308}\u{1f1e6}"]), ("\u{1f1e6}\u{5d0}", &["\u{1f1e6}", "\u{5d0}"]),
        ("\u{1f1e6}\u{308}\u{5d0}", &["\u{1f1e6}\u{308}", "\u{5d0}"]), ("\u{1f1e6}\u{22}",
        &["\u{1f1e6}", "\u{22}"]), ("\u{1f1e6}\u{308}\u{22}", &["\u{1f1e6}\u{308}", "\u{22}"]),
        ("\u{1f1e6}\u{27}", &["\u{1f1e6}", "\u{27}"]), ("\u{1f1e6}\u{308}\u{27}",
        &["\u{1f1e6}\u{308}", "\u{27}"]), ("\u{1f1e6}\u{261d}", &["\u{1f1e6}", "\u{261d}"]),
        ("\u{1f1e6}\u{308}\u{261d}", &["\u{1f1e6}\u{308}", "\u{261d}"]), ("\u{1f1e6}\u{1f3fb}",
        &["\u{1f1e6}", "\u{1f3fb}"]), ("\u{1f1e6}\u{308}\u{1f3fb}", &["\u{1f1e6}\u{308}",
        "\u{1f3fb}"]), ("\u{1f1e6}\u{2764}", &["\u{1f1e6}", "\u{2764}"]),
        ("\u{1f1e6}\u{308}\u{2764}", &["\u{1f1e6}\u{308}", "\u{2764}"]), ("\u{1f1e6}\u{1f466}",
        &["\u{1f1e6}", "\u{1f466}"]), ("\u{1f1e6}\u{308}\u{1f466}", &["\u{1f1e6}\u{308}",
        "\u{1f466}"]), ("\u{1f1e6}\u{ad}", &["\u{1f1e6}\u{ad}"]), ("\u{1f1e6}\u{308}\u{ad}",
        &["\u{1f1e6}\u{308}\u{ad}"]), ("\u{1f1e6}\u{300}", &["\u{1f1e6}\u{300}"]),
        ("\u{1f1e6}\u{308}\u{300}", &["\u{1f1e6}\u{308}\u{300}"]), ("\u{1f1e6}\u{200d}",
        &["\u{1f1e6}\u{200d}"]), ("\u{1f1e6}\u{308}\u{200d}", &["\u{1f1e6}\u{308}\u{200d}"]),
        ("\u{1f1e6}\u{61}\u{2060}", &["\u{1f1e6}", "\u{61}\u{2060}"]),
        ("\u{1f1e6}\u{308}\u{61}\u{2060}", &["\u{1f1e6}\u{308}", "\u{61}\u{2060}"]),
        ("\u{1f1e6}\u{61}\u{3a}", &["\u{1f1e6}", "\u{61}", "\u{3a}"]),
        ("\u{1f1e6}\u{308}\u{61}\u{3a}", &["\u{1f1e6}\u{308}", "\u{61}", "\u{3a}"]),
        ("\u{1f1e6}\u{61}\u{27}", &["\u{1f1e6}", "\u{61}", "\u{27}"]),
        ("\u{1f1e6}\u{308}\u{61}\u{27}", &["\u{1f1e6}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{1f1e6}\u{61}\u{27}\u{2060}", &["\u{1f1e6}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{1f1e6}\u{308}\u{61}\u{27}\u{2060}", &["\u{1f1e6}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{1f1e6}\u{61}\u{2c}", &["\u{1f1e6}", "\u{61}", "\u{2c}"]),
        ("\u{1f1e6}\u{308}\u{61}\u{2c}", &["\u{1f1e6}\u{308}", "\u{61}", "\u{2c}"]),
        ("\u{1f1e6}\u{31}\u{3a}", &["\u{1f1e6}", "\u{31}", "\u{3a}"]),
        ("\u{1f1e6}\u{308}\u{31}\u{3a}", &["\u{1f1e6}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{1f1e6}\u{31}\u{27}", &["\u{1f1e6}", "\u{31}", "\u{27}"]),
        ("\u{1f1e6}\u{308}\u{31}\u{27}", &["\u{1f1e6}\u{308}", "\u{31}", "\u{27}"]),
        ("\u{1f1e6}\u{31}\u{2c}", &["\u{1f1e6}", "\u{31}", "\u{2c}"]),
        ("\u{1f1e6}\u{308}\u{31}\u{2c}", &["\u{1f1e6}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{1f1e6}\u{31}\u{2e}\u{2060}", &["\u{1f1e6}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{1f1e6}\u{308}\u{31}\u{2e}\u{2060}", &["\u{1f1e6}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{5d0}\u{1}", &["\u{5d0}", "\u{1}"]), ("\u{5d0}\u{308}\u{1}", &["\u{5d0}\u{308}",
        "\u{1}"]), ("\u{5d0}\u{d}", &["\u{5d0}", "\u{d}"]), ("\u{5d0}\u{308}\u{d}",
        &["\u{5d0}\u{308}", "\u{d}"]), ("\u{5d0}\u{a}", &["\u{5d0}", "\u{a}"]),
        ("\u{5d0}\u{308}\u{a}", &["\u{5d0}\u{308}", "\u{a}"]), ("\u{5d0}\u{b}", &["\u{5d0}",
        "\u{b}"]), ("\u{5d0}\u{308}\u{b}", &["\u{5d0}\u{308}", "\u{b}"]), ("\u{5d0}\u{3031}",
        &["\u{5d0}", "\u{3031}"]), ("\u{5d0}\u{308}\u{3031}", &["\u{5d0}\u{308}", "\u{3031}"]),
        ("\u{5d0}\u{41}", &["\u{5d0}\u{41}"]), ("\u{5d0}\u{308}\u{41}", &["\u{5d0}\u{308}\u{41}"]),
        ("\u{5d0}\u{3a}", &["\u{5d0}", "\u{3a}"]), ("\u{5d0}\u{308}\u{3a}", &["\u{5d0}\u{308}",
        "\u{3a}"]), ("\u{5d0}\u{2c}", &["\u{5d0}", "\u{2c}"]), ("\u{5d0}\u{308}\u{2c}",
        &["\u{5d0}\u{308}", "\u{2c}"]), ("\u{5d0}\u{2e}", &["\u{5d0}", "\u{2e}"]),
        ("\u{5d0}\u{308}\u{2e}", &["\u{5d0}\u{308}", "\u{2e}"]), ("\u{5d0}\u{30}",
        &["\u{5d0}\u{30}"]), ("\u{5d0}\u{308}\u{30}", &["\u{5d0}\u{308}\u{30}"]), ("\u{5d0}\u{5f}",
        &["\u{5d0}\u{5f}"]), ("\u{5d0}\u{308}\u{5f}", &["\u{5d0}\u{308}\u{5f}"]),
        ("\u{5d0}\u{1f1e6}", &["\u{5d0}", "\u{1f1e6}"]), ("\u{5d0}\u{308}\u{1f1e6}",
        &["\u{5d0}\u{308}", "\u{1f1e6}"]), ("\u{5d0}\u{5d0}", &["\u{5d0}\u{5d0}"]),
        ("\u{5d0}\u{308}\u{5d0}", &["\u{5d0}\u{308}\u{5d0}"]), ("\u{5d0}\u{22}", &["\u{5d0}",
        "\u{22}"]), ("\u{5d0}\u{308}\u{22}", &["\u{5d0}\u{308}", "\u{22}"]), ("\u{5d0}\u{27}",
        &["\u{5d0}\u{27}"]), ("\u{5d0}\u{308}\u{27}", &["\u{5d0}\u{308}\u{27}"]),
        ("\u{5d0}\u{261d}", &["\u{5d0}", "\u{261d}"]), ("\u{5d0}\u{308}\u{261d}",
        &["\u{5d0}\u{308}", "\u{261d}"]), ("\u{5d0}\u{1f3fb}", &["\u{5d0}", "\u{1f3fb}"]),
        ("\u{5d0}\u{308}\u{1f3fb}", &["\u{5d0}\u{308}", "\u{1f3fb}"]), ("\u{5d0}\u{2764}",
        &["\u{5d0}", "\u{2764}"]), ("\u{5d0}\u{308}\u{2764}", &["\u{5d0}\u{308}", "\u{2764}"]),
        ("\u{5d0}\u{1f466}", &["\u{5d0}", "\u{1f466}"]), ("\u{5d0}\u{308}\u{1f466}",
        &["\u{5d0}\u{308}", "\u{1f466}"]), ("\u{5d0}\u{ad}", &["\u{5d0}\u{ad}"]),
        ("\u{5d0}\u{308}\u{ad}", &["\u{5d0}\u{308}\u{ad}"]), ("\u{5d0}\u{300}",
        &["\u{5d0}\u{300}"]), ("\u{5d0}\u{308}\u{300}", &["\u{5d0}\u{308}\u{300}"]),
        ("\u{5d0}\u{200d}", &["\u{5d0}\u{200d}"]), ("\u{5d0}\u{308}\u{200d}",
        &["\u{5d0}\u{308}\u{200d}"]), ("\u{5d0}\u{61}\u{2060}", &["\u{5d0}\u{61}\u{2060}"]),
        ("\u{5d0}\u{308}\u{61}\u{2060}", &["\u{5d0}\u{308}\u{61}\u{2060}"]), ("\u{5d0}\u{61}\u{3a}",
        &["\u{5d0}\u{61}", "\u{3a}"]), ("\u{5d0}\u{308}\u{61}\u{3a}", &["\u{5d0}\u{308}\u{61}",
        "\u{3a}"]), ("\u{5d0}\u{61}\u{27}", &["\u{5d0}\u{61}", "\u{27}"]),
        ("\u{5d0}\u{308}\u{61}\u{27}", &["\u{5d0}\u{308}\u{61}", "\u{27}"]),
        ("\u{5d0}\u{61}\u{27}\u{2060}", &["\u{5d0}\u{61}", "\u{27}\u{2060}"]),
        ("\u{5d0}\u{308}\u{61}\u{27}\u{2060}", &["\u{5d0}\u{308}\u{61}", "\u{27}\u{2060}"]),
        ("\u{5d0}\u{61}\u{2c}", &["\u{5d0}\u{61}", "\u{2c}"]), ("\u{5d0}\u{308}\u{61}\u{2c}",
        &["\u{5d0}\u{308}\u{61}", "\u{2c}"]), ("\u{5d0}\u{31}\u{3a}", &["\u{5d0}\u{31}", "\u{3a}"]),
        ("\u{5d0}\u{308}\u{31}\u{3a}", &["\u{5d0}\u{308}\u{31}", "\u{3a}"]), ("\u{5d0}\u{31}\u{27}",
        &["\u{5d0}\u{31}", "\u{27}"]), ("\u{5d0}\u{308}\u{31}\u{27}", &["\u{5d0}\u{308}\u{31}",
        "\u{27}"]), ("\u{5d0}\u{31}\u{2c}", &["\u{5d0}\u{31}", "\u{2c}"]),
        ("\u{5d0}\u{308}\u{31}\u{2c}", &["\u{5d0}\u{308}\u{31}", "\u{2c}"]),
        ("\u{5d0}\u{31}\u{2e}\u{2060}", &["\u{5d0}\u{31}", "\u{2e}\u{2060}"]),
        ("\u{5d0}\u{308}\u{31}\u{2e}\u{2060}", &["\u{5d0}\u{308}\u{31}", "\u{2e}\u{2060}"]),
        ("\u{22}\u{1}", &["\u{22}", "\u{1}"]), ("\u{22}\u{308}\u{1}", &["\u{22}\u{308}", "\u{1}"]),
        ("\u{22}\u{d}", &["\u{22}", "\u{d}"]), ("\u{22}\u{308}\u{d}", &["\u{22}\u{308}", "\u{d}"]),
        ("\u{22}\u{a}", &["\u{22}", "\u{a}"]), ("\u{22}\u{308}\u{a}", &["\u{22}\u{308}", "\u{a}"]),
        ("\u{22}\u{b}", &["\u{22}", "\u{b}"]), ("\u{22}\u{308}\u{b}", &["\u{22}\u{308}", "\u{b}"]),
        ("\u{22}\u{3031}", &["\u{22}", "\u{3031}"]), ("\u{22}\u{308}\u{3031}", &["\u{22}\u{308}",
        "\u{3031}"]), ("\u{22}\u{41}", &["\u{22}", "\u{41}"]), ("\u{22}\u{308}\u{41}",
        &["\u{22}\u{308}", "\u{41}"]), ("\u{22}\u{3a}", &["\u{22}", "\u{3a}"]),
        ("\u{22}\u{308}\u{3a}", &["\u{22}\u{308}", "\u{3a}"]), ("\u{22}\u{2c}", &["\u{22}",
        "\u{2c}"]), ("\u{22}\u{308}\u{2c}", &["\u{22}\u{308}", "\u{2c}"]), ("\u{22}\u{2e}",
        &["\u{22}", "\u{2e}"]), ("\u{22}\u{308}\u{2e}", &["\u{22}\u{308}", "\u{2e}"]),
        ("\u{22}\u{30}", &["\u{22}", "\u{30}"]), ("\u{22}\u{308}\u{30}", &["\u{22}\u{308}",
        "\u{30}"]), ("\u{22}\u{5f}", &["\u{22}", "\u{5f}"]), ("\u{22}\u{308}\u{5f}",
        &["\u{22}\u{308}", "\u{5f}"]), ("\u{22}\u{1f1e6}", &["\u{22}", "\u{1f1e6}"]),
        ("\u{22}\u{308}\u{1f1e6}", &["\u{22}\u{308}", "\u{1f1e6}"]), ("\u{22}\u{5d0}", &["\u{22}",
        "\u{5d0}"]), ("\u{22}\u{308}\u{5d0}", &["\u{22}\u{308}", "\u{5d0}"]), ("\u{22}\u{22}",
        &["\u{22}", "\u{22}"]), ("\u{22}\u{308}\u{22}", &["\u{22}\u{308}", "\u{22}"]),
        ("\u{22}\u{27}", &["\u{22}", "\u{27}"]), ("\u{22}\u{308}\u{27}", &["\u{22}\u{308}",
        "\u{27}"]), ("\u{22}\u{261d}", &["\u{22}", "\u{261d}"]), ("\u{22}\u{308}\u{261d}",
        &["\u{22}\u{308}", "\u{261d}"]), ("\u{22}\u{1f3fb}", &["\u{22}", "\u{1f3fb}"]),
        ("\u{22}\u{308}\u{1f3fb}", &["\u{22}\u{308}", "\u{1f3fb}"]), ("\u{22}\u{2764}", &["\u{22}",
        "\u{2764}"]), ("\u{22}\u{308}\u{2764}", &["\u{22}\u{308}", "\u{2764}"]), ("\u{22}\u{1f466}",
        &["\u{22}", "\u{1f466}"]), ("\u{22}\u{308}\u{1f466}", &["\u{22}\u{308}", "\u{1f466}"]),
        ("\u{22}\u{ad}", &["\u{22}\u{ad}"]), ("\u{22}\u{308}\u{ad}", &["\u{22}\u{308}\u{ad}"]),
        ("\u{22}\u{300}", &["\u{22}\u{300}"]), ("\u{22}\u{308}\u{300}", &["\u{22}\u{308}\u{300}"]),
        ("\u{22}\u{200d}", &["\u{22}\u{200d}"]), ("\u{22}\u{308}\u{200d}",
        &["\u{22}\u{308}\u{200d}"]), ("\u{22}\u{61}\u{2060}", &["\u{22}", "\u{61}\u{2060}"]),
        ("\u{22}\u{308}\u{61}\u{2060}", &["\u{22}\u{308}", "\u{61}\u{2060}"]),
        ("\u{22}\u{61}\u{3a}", &["\u{22}", "\u{61}", "\u{3a}"]), ("\u{22}\u{308}\u{61}\u{3a}",
        &["\u{22}\u{308}", "\u{61}", "\u{3a}"]), ("\u{22}\u{61}\u{27}", &["\u{22}", "\u{61}",
        "\u{27}"]), ("\u{22}\u{308}\u{61}\u{27}", &["\u{22}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{22}\u{61}\u{27}\u{2060}", &["\u{22}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{22}\u{308}\u{61}\u{27}\u{2060}", &["\u{22}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{22}\u{61}\u{2c}", &["\u{22}", "\u{61}", "\u{2c}"]), ("\u{22}\u{308}\u{61}\u{2c}",
        &["\u{22}\u{308}", "\u{61}", "\u{2c}"]), ("\u{22}\u{31}\u{3a}", &["\u{22}", "\u{31}",
        "\u{3a}"]), ("\u{22}\u{308}\u{31}\u{3a}", &["\u{22}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{22}\u{31}\u{27}", &["\u{22}", "\u{31}", "\u{27}"]), ("\u{22}\u{308}\u{31}\u{27}",
        &["\u{22}\u{308}", "\u{31}", "\u{27}"]), ("\u{22}\u{31}\u{2c}", &["\u{22}", "\u{31}",
        "\u{2c}"]), ("\u{22}\u{308}\u{31}\u{2c}", &["\u{22}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{22}\u{31}\u{2e}\u{2060}", &["\u{22}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{22}\u{308}\u{31}\u{2e}\u{2060}", &["\u{22}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{27}\u{1}", &["\u{27}", "\u{1}"]), ("\u{27}\u{308}\u{1}", &["\u{27}\u{308}", "\u{1}"]),
        ("\u{27}\u{d}", &["\u{27}", "\u{d}"]), ("\u{27}\u{308}\u{d}", &["\u{27}\u{308}", "\u{d}"]),
        ("\u{27}\u{a}", &["\u{27}", "\u{a}"]), ("\u{27}\u{308}\u{a}", &["\u{27}\u{308}", "\u{a}"]),
        ("\u{27}\u{b}", &["\u{27}", "\u{b}"]), ("\u{27}\u{308}\u{b}", &["\u{27}\u{308}", "\u{b}"]),
        ("\u{27}\u{3031}", &["\u{27}", "\u{3031}"]), ("\u{27}\u{308}\u{3031}", &["\u{27}\u{308}",
        "\u{3031}"]), ("\u{27}\u{41}", &["\u{27}", "\u{41}"]), ("\u{27}\u{308}\u{41}",
        &["\u{27}\u{308}", "\u{41}"]), ("\u{27}\u{3a}", &["\u{27}", "\u{3a}"]),
        ("\u{27}\u{308}\u{3a}", &["\u{27}\u{308}", "\u{3a}"]), ("\u{27}\u{2c}", &["\u{27}",
        "\u{2c}"]), ("\u{27}\u{308}\u{2c}", &["\u{27}\u{308}", "\u{2c}"]), ("\u{27}\u{2e}",
        &["\u{27}", "\u{2e}"]), ("\u{27}\u{308}\u{2e}", &["\u{27}\u{308}", "\u{2e}"]),
        ("\u{27}\u{30}", &["\u{27}", "\u{30}"]), ("\u{27}\u{308}\u{30}", &["\u{27}\u{308}",
        "\u{30}"]), ("\u{27}\u{5f}", &["\u{27}", "\u{5f}"]), ("\u{27}\u{308}\u{5f}",
        &["\u{27}\u{308}", "\u{5f}"]), ("\u{27}\u{1f1e6}", &["\u{27}", "\u{1f1e6}"]),
        ("\u{27}\u{308}\u{1f1e6}", &["\u{27}\u{308}", "\u{1f1e6}"]), ("\u{27}\u{5d0}", &["\u{27}",
        "\u{5d0}"]), ("\u{27}\u{308}\u{5d0}", &["\u{27}\u{308}", "\u{5d0}"]), ("\u{27}\u{22}",
        &["\u{27}", "\u{22}"]), ("\u{27}\u{308}\u{22}", &["\u{27}\u{308}", "\u{22}"]),
        ("\u{27}\u{27}", &["\u{27}", "\u{27}"]), ("\u{27}\u{308}\u{27}", &["\u{27}\u{308}",
        "\u{27}"]), ("\u{27}\u{261d}", &["\u{27}", "\u{261d}"]), ("\u{27}\u{308}\u{261d}",
        &["\u{27}\u{308}", "\u{261d}"]), ("\u{27}\u{1f3fb}", &["\u{27}", "\u{1f3fb}"]),
        ("\u{27}\u{308}\u{1f3fb}", &["\u{27}\u{308}", "\u{1f3fb}"]), ("\u{27}\u{2764}", &["\u{27}",
        "\u{2764}"]), ("\u{27}\u{308}\u{2764}", &["\u{27}\u{308}", "\u{2764}"]), ("\u{27}\u{1f466}",
        &["\u{27}", "\u{1f466}"]), ("\u{27}\u{308}\u{1f466}", &["\u{27}\u{308}", "\u{1f466}"]),
        ("\u{27}\u{ad}", &["\u{27}\u{ad}"]), ("\u{27}\u{308}\u{ad}", &["\u{27}\u{308}\u{ad}"]),
        ("\u{27}\u{300}", &["\u{27}\u{300}"]), ("\u{27}\u{308}\u{300}", &["\u{27}\u{308}\u{300}"]),
        ("\u{27}\u{200d}", &["\u{27}\u{200d}"]), ("\u{27}\u{308}\u{200d}",
        &["\u{27}\u{308}\u{200d}"]), ("\u{27}\u{61}\u{2060}", &["\u{27}", "\u{61}\u{2060}"]),
        ("\u{27}\u{308}\u{61}\u{2060}", &["\u{27}\u{308}", "\u{61}\u{2060}"]),
        ("\u{27}\u{61}\u{3a}", &["\u{27}", "\u{61}", "\u{3a}"]), ("\u{27}\u{308}\u{61}\u{3a}",
        &["\u{27}\u{308}", "\u{61}", "\u{3a}"]), ("\u{27}\u{61}\u{27}", &["\u{27}", "\u{61}",
        "\u{27}"]), ("\u{27}\u{308}\u{61}\u{27}", &["\u{27}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{27}\u{61}\u{27}\u{2060}", &["\u{27}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{27}\u{308}\u{61}\u{27}\u{2060}", &["\u{27}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{27}\u{61}\u{2c}", &["\u{27}", "\u{61}", "\u{2c}"]), ("\u{27}\u{308}\u{61}\u{2c}",
        &["\u{27}\u{308}", "\u{61}", "\u{2c}"]), ("\u{27}\u{31}\u{3a}", &["\u{27}", "\u{31}",
        "\u{3a}"]), ("\u{27}\u{308}\u{31}\u{3a}", &["\u{27}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{27}\u{31}\u{27}", &["\u{27}", "\u{31}", "\u{27}"]), ("\u{27}\u{308}\u{31}\u{27}",
        &["\u{27}\u{308}", "\u{31}", "\u{27}"]), ("\u{27}\u{31}\u{2c}", &["\u{27}", "\u{31}",
        "\u{2c}"]), ("\u{27}\u{308}\u{31}\u{2c}", &["\u{27}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{27}\u{31}\u{2e}\u{2060}", &["\u{27}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{27}\u{308}\u{31}\u{2e}\u{2060}", &["\u{27}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{261d}\u{1}", &["\u{261d}", "\u{1}"]), ("\u{261d}\u{308}\u{1}", &["\u{261d}\u{308}",
        "\u{1}"]), ("\u{261d}\u{d}", &["\u{261d}", "\u{d}"]), ("\u{261d}\u{308}\u{d}",
        &["\u{261d}\u{308}", "\u{d}"]), ("\u{261d}\u{a}", &["\u{261d}", "\u{a}"]),
        ("\u{261d}\u{308}\u{a}", &["\u{261d}\u{308}", "\u{a}"]), ("\u{261d}\u{b}", &["\u{261d}",
        "\u{b}"]), ("\u{261d}\u{308}\u{b}", &["\u{261d}\u{308}", "\u{b}"]), ("\u{261d}\u{3031}",
        &["\u{261d}", "\u{3031}"]), ("\u{261d}\u{308}\u{3031}", &["\u{261d}\u{308}", "\u{3031}"]),
        ("\u{261d}\u{41}", &["\u{261d}", "\u{41}"]), ("\u{261d}\u{308}\u{41}", &["\u{261d}\u{308}",
        "\u{41}"]), ("\u{261d}\u{3a}", &["\u{261d}", "\u{3a}"]), ("\u{261d}\u{308}\u{3a}",
        &["\u{261d}\u{308}", "\u{3a}"]), ("\u{261d}\u{2c}", &["\u{261d}", "\u{2c}"]),
        ("\u{261d}\u{308}\u{2c}", &["\u{261d}\u{308}", "\u{2c}"]), ("\u{261d}\u{2e}", &["\u{261d}",
        "\u{2e}"]), ("\u{261d}\u{308}\u{2e}", &["\u{261d}\u{308}", "\u{2e}"]), ("\u{261d}\u{30}",
        &["\u{261d}", "\u{30}"]), ("\u{261d}\u{308}\u{30}", &["\u{261d}\u{308}", "\u{30}"]),
        ("\u{261d}\u{5f}", &["\u{261d}", "\u{5f}"]), ("\u{261d}\u{308}\u{5f}", &["\u{261d}\u{308}",
        "\u{5f}"]), ("\u{261d}\u{1f1e6}", &["\u{261d}", "\u{1f1e6}"]), ("\u{261d}\u{308}\u{1f1e6}",
        &["\u{261d}\u{308}", "\u{1f1e6}"]), ("\u{261d}\u{5d0}", &["\u{261d}", "\u{5d0}"]),
        ("\u{261d}\u{308}\u{5d0}", &["\u{261d}\u{308}", "\u{5d0}"]), ("\u{261d}\u{22}",
        &["\u{261d}", "\u{22}"]), ("\u{261d}\u{308}\u{22}", &["\u{261d}\u{308}", "\u{22}"]),
        ("\u{261d}\u{27}", &["\u{261d}", "\u{27}"]), ("\u{261d}\u{308}\u{27}", &["\u{261d}\u{308}",
        "\u{27}"]), ("\u{261d}\u{261d}", &["\u{261d}", "\u{261d}"]), ("\u{261d}\u{308}\u{261d}",
        &["\u{261d}\u{308}", "\u{261d}"]), ("\u{261d}\u{1f3fb}", &["\u{261d}\u{1f3fb}"]),
        ("\u{261d}\u{308}\u{1f3fb}", &["\u{261d}\u{308}\u{1f3fb}"]), ("\u{261d}\u{2764}",
        &["\u{261d}", "\u{2764}"]), ("\u{261d}\u{308}\u{2764}", &["\u{261d}\u{308}", "\u{2764}"]),
        ("\u{261d}\u{1f466}", &["\u{261d}", "\u{1f466}"]), ("\u{261d}\u{308}\u{1f466}",
        &["\u{261d}\u{308}", "\u{1f466}"]), ("\u{261d}\u{ad}", &["\u{261d}\u{ad}"]),
        ("\u{261d}\u{308}\u{ad}", &["\u{261d}\u{308}\u{ad}"]), ("\u{261d}\u{300}",
        &["\u{261d}\u{300}"]), ("\u{261d}\u{308}\u{300}", &["\u{261d}\u{308}\u{300}"]),
        ("\u{261d}\u{200d}", &["\u{261d}\u{200d}"]), ("\u{261d}\u{308}\u{200d}",
        &["\u{261d}\u{308}\u{200d}"]), ("\u{261d}\u{61}\u{2060}", &["\u{261d}", "\u{61}\u{2060}"]),
        ("\u{261d}\u{308}\u{61}\u{2060}", &["\u{261d}\u{308}", "\u{61}\u{2060}"]),
        ("\u{261d}\u{61}\u{3a}", &["\u{261d}", "\u{61}", "\u{3a}"]), ("\u{261d}\u{308}\u{61}\u{3a}",
        &["\u{261d}\u{308}", "\u{61}", "\u{3a}"]), ("\u{261d}\u{61}\u{27}", &["\u{261d}", "\u{61}",
        "\u{27}"]), ("\u{261d}\u{308}\u{61}\u{27}", &["\u{261d}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{261d}\u{61}\u{27}\u{2060}", &["\u{261d}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{261d}\u{308}\u{61}\u{27}\u{2060}", &["\u{261d}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{261d}\u{61}\u{2c}", &["\u{261d}", "\u{61}", "\u{2c}"]), ("\u{261d}\u{308}\u{61}\u{2c}",
        &["\u{261d}\u{308}", "\u{61}", "\u{2c}"]), ("\u{261d}\u{31}\u{3a}", &["\u{261d}", "\u{31}",
        "\u{3a}"]), ("\u{261d}\u{308}\u{31}\u{3a}", &["\u{261d}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{261d}\u{31}\u{27}", &["\u{261d}", "\u{31}", "\u{27}"]), ("\u{261d}\u{308}\u{31}\u{27}",
        &["\u{261d}\u{308}", "\u{31}", "\u{27}"]), ("\u{261d}\u{31}\u{2c}", &["\u{261d}", "\u{31}",
        "\u{2c}"]), ("\u{261d}\u{308}\u{31}\u{2c}", &["\u{261d}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{261d}\u{31}\u{2e}\u{2060}", &["\u{261d}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{261d}\u{308}\u{31}\u{2e}\u{2060}", &["\u{261d}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{1f3fb}\u{1}", &["\u{1f3fb}", "\u{1}"]), ("\u{1f3fb}\u{308}\u{1}", &["\u{1f3fb}\u{308}",
        "\u{1}"]), ("\u{1f3fb}\u{d}", &["\u{1f3fb}", "\u{d}"]), ("\u{1f3fb}\u{308}\u{d}",
        &["\u{1f3fb}\u{308}", "\u{d}"]), ("\u{1f3fb}\u{a}", &["\u{1f3fb}", "\u{a}"]),
        ("\u{1f3fb}\u{308}\u{a}", &["\u{1f3fb}\u{308}", "\u{a}"]), ("\u{1f3fb}\u{b}", &["\u{1f3fb}",
        "\u{b}"]), ("\u{1f3fb}\u{308}\u{b}", &["\u{1f3fb}\u{308}", "\u{b}"]), ("\u{1f3fb}\u{3031}",
        &["\u{1f3fb}", "\u{3031}"]), ("\u{1f3fb}\u{308}\u{3031}", &["\u{1f3fb}\u{308}",
        "\u{3031}"]), ("\u{1f3fb}\u{41}", &["\u{1f3fb}", "\u{41}"]), ("\u{1f3fb}\u{308}\u{41}",
        &["\u{1f3fb}\u{308}", "\u{41}"]), ("\u{1f3fb}\u{3a}", &["\u{1f3fb}", "\u{3a}"]),
        ("\u{1f3fb}\u{308}\u{3a}", &["\u{1f3fb}\u{308}", "\u{3a}"]), ("\u{1f3fb}\u{2c}",
        &["\u{1f3fb}", "\u{2c}"]), ("\u{1f3fb}\u{308}\u{2c}", &["\u{1f3fb}\u{308}", "\u{2c}"]),
        ("\u{1f3fb}\u{2e}", &["\u{1f3fb}", "\u{2e}"]), ("\u{1f3fb}\u{308}\u{2e}",
        &["\u{1f3fb}\u{308}", "\u{2e}"]), ("\u{1f3fb}\u{30}", &["\u{1f3fb}", "\u{30}"]),
        ("\u{1f3fb}\u{308}\u{30}", &["\u{1f3fb}\u{308}", "\u{30}"]), ("\u{1f3fb}\u{5f}",
        &["\u{1f3fb}", "\u{5f}"]), ("\u{1f3fb}\u{308}\u{5f}", &["\u{1f3fb}\u{308}", "\u{5f}"]),
        ("\u{1f3fb}\u{1f1e6}", &["\u{1f3fb}", "\u{1f1e6}"]), ("\u{1f3fb}\u{308}\u{1f1e6}",
        &["\u{1f3fb}\u{308}", "\u{1f1e6}"]), ("\u{1f3fb}\u{5d0}", &["\u{1f3fb}", "\u{5d0}"]),
        ("\u{1f3fb}\u{308}\u{5d0}", &["\u{1f3fb}\u{308}", "\u{5d0}"]), ("\u{1f3fb}\u{22}",
        &["\u{1f3fb}", "\u{22}"]), ("\u{1f3fb}\u{308}\u{22}", &["\u{1f3fb}\u{308}", "\u{22}"]),
        ("\u{1f3fb}\u{27}", &["\u{1f3fb}", "\u{27}"]), ("\u{1f3fb}\u{308}\u{27}",
        &["\u{1f3fb}\u{308}", "\u{27}"]), ("\u{1f3fb}\u{261d}", &["\u{1f3fb}", "\u{261d}"]),
        ("\u{1f3fb}\u{308}\u{261d}", &["\u{1f3fb}\u{308}", "\u{261d}"]), ("\u{1f3fb}\u{1f3fb}",
        &["\u{1f3fb}", "\u{1f3fb}"]), ("\u{1f3fb}\u{308}\u{1f3fb}", &["\u{1f3fb}\u{308}",
        "\u{1f3fb}"]), ("\u{1f3fb}\u{2764}", &["\u{1f3fb}", "\u{2764}"]),
        ("\u{1f3fb}\u{308}\u{2764}", &["\u{1f3fb}\u{308}", "\u{2764}"]), ("\u{1f3fb}\u{1f466}",
        &["\u{1f3fb}", "\u{1f466}"]), ("\u{1f3fb}\u{308}\u{1f466}", &["\u{1f3fb}\u{308}",
        "\u{1f466}"]), ("\u{1f3fb}\u{ad}", &["\u{1f3fb}\u{ad}"]), ("\u{1f3fb}\u{308}\u{ad}",
        &["\u{1f3fb}\u{308}\u{ad}"]), ("\u{1f3fb}\u{300}", &["\u{1f3fb}\u{300}"]),
        ("\u{1f3fb}\u{308}\u{300}", &["\u{1f3fb}\u{308}\u{300}"]), ("\u{1f3fb}\u{200d}",
        &["\u{1f3fb}\u{200d}"]), ("\u{1f3fb}\u{308}\u{200d}", &["\u{1f3fb}\u{308}\u{200d}"]),
        ("\u{1f3fb}\u{61}\u{2060}", &["\u{1f3fb}", "\u{61}\u{2060}"]),
        ("\u{1f3fb}\u{308}\u{61}\u{2060}", &["\u{1f3fb}\u{308}", "\u{61}\u{2060}"]),
        ("\u{1f3fb}\u{61}\u{3a}", &["\u{1f3fb}", "\u{61}", "\u{3a}"]),
        ("\u{1f3fb}\u{308}\u{61}\u{3a}", &["\u{1f3fb}\u{308}", "\u{61}", "\u{3a}"]),
        ("\u{1f3fb}\u{61}\u{27}", &["\u{1f3fb}", "\u{61}", "\u{27}"]),
        ("\u{1f3fb}\u{308}\u{61}\u{27}", &["\u{1f3fb}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{1f3fb}\u{61}\u{27}\u{2060}", &["\u{1f3fb}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{1f3fb}\u{308}\u{61}\u{27}\u{2060}", &["\u{1f3fb}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{1f3fb}\u{61}\u{2c}", &["\u{1f3fb}", "\u{61}", "\u{2c}"]),
        ("\u{1f3fb}\u{308}\u{61}\u{2c}", &["\u{1f3fb}\u{308}", "\u{61}", "\u{2c}"]),
        ("\u{1f3fb}\u{31}\u{3a}", &["\u{1f3fb}", "\u{31}", "\u{3a}"]),
        ("\u{1f3fb}\u{308}\u{31}\u{3a}", &["\u{1f3fb}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{1f3fb}\u{31}\u{27}", &["\u{1f3fb}", "\u{31}", "\u{27}"]),
        ("\u{1f3fb}\u{308}\u{31}\u{27}", &["\u{1f3fb}\u{308}", "\u{31}", "\u{27}"]),
        ("\u{1f3fb}\u{31}\u{2c}", &["\u{1f3fb}", "\u{31}", "\u{2c}"]),
        ("\u{1f3fb}\u{308}\u{31}\u{2c}", &["\u{1f3fb}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{1f3fb}\u{31}\u{2e}\u{2060}", &["\u{1f3fb}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{1f3fb}\u{308}\u{31}\u{2e}\u{2060}", &["\u{1f3fb}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{2764}\u{1}", &["\u{2764}", "\u{1}"]), ("\u{2764}\u{308}\u{1}", &["\u{2764}\u{308}",
        "\u{1}"]), ("\u{2764}\u{d}", &["\u{2764}", "\u{d}"]), ("\u{2764}\u{308}\u{d}",
        &["\u{2764}\u{308}", "\u{d}"]), ("\u{2764}\u{a}", &["\u{2764}", "\u{a}"]),
        ("\u{2764}\u{308}\u{a}", &["\u{2764}\u{308}", "\u{a}"]), ("\u{2764}\u{b}", &["\u{2764}",
        "\u{b}"]), ("\u{2764}\u{308}\u{b}", &["\u{2764}\u{308}", "\u{b}"]), ("\u{2764}\u{3031}",
        &["\u{2764}", "\u{3031}"]), ("\u{2764}\u{308}\u{3031}", &["\u{2764}\u{308}", "\u{3031}"]),
        ("\u{2764}\u{41}", &["\u{2764}", "\u{41}"]), ("\u{2764}\u{308}\u{41}", &["\u{2764}\u{308}",
        "\u{41}"]), ("\u{2764}\u{3a}", &["\u{2764}", "\u{3a}"]), ("\u{2764}\u{308}\u{3a}",
        &["\u{2764}\u{308}", "\u{3a}"]), ("\u{2764}\u{2c}", &["\u{2764}", "\u{2c}"]),
        ("\u{2764}\u{308}\u{2c}", &["\u{2764}\u{308}", "\u{2c}"]), ("\u{2764}\u{2e}", &["\u{2764}",
        "\u{2e}"]), ("\u{2764}\u{308}\u{2e}", &["\u{2764}\u{308}", "\u{2e}"]), ("\u{2764}\u{30}",
        &["\u{2764}", "\u{30}"]), ("\u{2764}\u{308}\u{30}", &["\u{2764}\u{308}", "\u{30}"]),
        ("\u{2764}\u{5f}", &["\u{2764}", "\u{5f}"]), ("\u{2764}\u{308}\u{5f}", &["\u{2764}\u{308}",
        "\u{5f}"]), ("\u{2764}\u{1f1e6}", &["\u{2764}", "\u{1f1e6}"]), ("\u{2764}\u{308}\u{1f1e6}",
        &["\u{2764}\u{308}", "\u{1f1e6}"]), ("\u{2764}\u{5d0}", &["\u{2764}", "\u{5d0}"]),
        ("\u{2764}\u{308}\u{5d0}", &["\u{2764}\u{308}", "\u{5d0}"]), ("\u{2764}\u{22}",
        &["\u{2764}", "\u{22}"]), ("\u{2764}\u{308}\u{22}", &["\u{2764}\u{308}", "\u{22}"]),
        ("\u{2764}\u{27}", &["\u{2764}", "\u{27}"]), ("\u{2764}\u{308}\u{27}", &["\u{2764}\u{308}",
        "\u{27}"]), ("\u{2764}\u{261d}", &["\u{2764}", "\u{261d}"]), ("\u{2764}\u{308}\u{261d}",
        &["\u{2764}\u{308}", "\u{261d}"]), ("\u{2764}\u{1f3fb}", &["\u{2764}", "\u{1f3fb}"]),
        ("\u{2764}\u{308}\u{1f3fb}", &["\u{2764}\u{308}", "\u{1f3fb}"]), ("\u{2764}\u{2764}",
        &["\u{2764}", "\u{2764}"]), ("\u{2764}\u{308}\u{2764}", &["\u{2764}\u{308}", "\u{2764}"]),
        ("\u{2764}\u{1f466}", &["\u{2764}", "\u{1f466}"]), ("\u{2764}\u{308}\u{1f466}",
        &["\u{2764}\u{308}", "\u{1f466}"]), ("\u{2764}\u{ad}", &["\u{2764}\u{ad}"]),
        ("\u{2764}\u{308}\u{ad}", &["\u{2764}\u{308}\u{ad}"]), ("\u{2764}\u{300}",
        &["\u{2764}\u{300}"]), ("\u{2764}\u{308}\u{300}", &["\u{2764}\u{308}\u{300}"]),
        ("\u{2764}\u{200d}", &["\u{2764}\u{200d}"]), ("\u{2764}\u{308}\u{200d}",
        &["\u{2764}\u{308}\u{200d}"]), ("\u{2764}\u{61}\u{2060}", &["\u{2764}", "\u{61}\u{2060}"]),
        ("\u{2764}\u{308}\u{61}\u{2060}", &["\u{2764}\u{308}", "\u{61}\u{2060}"]),
        ("\u{2764}\u{61}\u{3a}", &["\u{2764}", "\u{61}", "\u{3a}"]), ("\u{2764}\u{308}\u{61}\u{3a}",
        &["\u{2764}\u{308}", "\u{61}", "\u{3a}"]), ("\u{2764}\u{61}\u{27}", &["\u{2764}", "\u{61}",
        "\u{27}"]), ("\u{2764}\u{308}\u{61}\u{27}", &["\u{2764}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{2764}\u{61}\u{27}\u{2060}", &["\u{2764}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{2764}\u{308}\u{61}\u{27}\u{2060}", &["\u{2764}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{2764}\u{61}\u{2c}", &["\u{2764}", "\u{61}", "\u{2c}"]), ("\u{2764}\u{308}\u{61}\u{2c}",
        &["\u{2764}\u{308}", "\u{61}", "\u{2c}"]), ("\u{2764}\u{31}\u{3a}", &["\u{2764}", "\u{31}",
        "\u{3a}"]), ("\u{2764}\u{308}\u{31}\u{3a}", &["\u{2764}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{2764}\u{31}\u{27}", &["\u{2764}", "\u{31}", "\u{27}"]), ("\u{2764}\u{308}\u{31}\u{27}",
        &["\u{2764}\u{308}", "\u{31}", "\u{27}"]), ("\u{2764}\u{31}\u{2c}", &["\u{2764}", "\u{31}",
        "\u{2c}"]), ("\u{2764}\u{308}\u{31}\u{2c}", &["\u{2764}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{2764}\u{31}\u{2e}\u{2060}", &["\u{2764}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{2764}\u{308}\u{31}\u{2e}\u{2060}", &["\u{2764}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{1f466}\u{1}", &["\u{1f466}", "\u{1}"]), ("\u{1f466}\u{308}\u{1}", &["\u{1f466}\u{308}",
        "\u{1}"]), ("\u{1f466}\u{d}", &["\u{1f466}", "\u{d}"]), ("\u{1f466}\u{308}\u{d}",
        &["\u{1f466}\u{308}", "\u{d}"]), ("\u{1f466}\u{a}", &["\u{1f466}", "\u{a}"]),
        ("\u{1f466}\u{308}\u{a}", &["\u{1f466}\u{308}", "\u{a}"]), ("\u{1f466}\u{b}", &["\u{1f466}",
        "\u{b}"]), ("\u{1f466}\u{308}\u{b}", &["\u{1f466}\u{308}", "\u{b}"]), ("\u{1f466}\u{3031}",
        &["\u{1f466}", "\u{3031}"]), ("\u{1f466}\u{308}\u{3031}", &["\u{1f466}\u{308}",
        "\u{3031}"]), ("\u{1f466}\u{41}", &["\u{1f466}", "\u{41}"]), ("\u{1f466}\u{308}\u{41}",
        &["\u{1f466}\u{308}", "\u{41}"]), ("\u{1f466}\u{3a}", &["\u{1f466}", "\u{3a}"]),
        ("\u{1f466}\u{308}\u{3a}", &["\u{1f466}\u{308}", "\u{3a}"]), ("\u{1f466}\u{2c}",
        &["\u{1f466}", "\u{2c}"]), ("\u{1f466}\u{308}\u{2c}", &["\u{1f466}\u{308}", "\u{2c}"]),
        ("\u{1f466}\u{2e}", &["\u{1f466}", "\u{2e}"]), ("\u{1f466}\u{308}\u{2e}",
        &["\u{1f466}\u{308}", "\u{2e}"]), ("\u{1f466}\u{30}", &["\u{1f466}", "\u{30}"]),
        ("\u{1f466}\u{308}\u{30}", &["\u{1f466}\u{308}", "\u{30}"]), ("\u{1f466}\u{5f}",
        &["\u{1f466}", "\u{5f}"]), ("\u{1f466}\u{308}\u{5f}", &["\u{1f466}\u{308}", "\u{5f}"]),
        ("\u{1f466}\u{1f1e6}", &["\u{1f466}", "\u{1f1e6}"]), ("\u{1f466}\u{308}\u{1f1e6}",
        &["\u{1f466}\u{308}", "\u{1f1e6}"]), ("\u{1f466}\u{5d0}", &["\u{1f466}", "\u{5d0}"]),
        ("\u{1f466}\u{308}\u{5d0}", &["\u{1f466}\u{308}", "\u{5d0}"]), ("\u{1f466}\u{22}",
        &["\u{1f466}", "\u{22}"]), ("\u{1f466}\u{308}\u{22}", &["\u{1f466}\u{308}", "\u{22}"]),
        ("\u{1f466}\u{27}", &["\u{1f466}", "\u{27}"]), ("\u{1f466}\u{308}\u{27}",
        &["\u{1f466}\u{308}", "\u{27}"]), ("\u{1f466}\u{261d}", &["\u{1f466}", "\u{261d}"]),
        ("\u{1f466}\u{308}\u{261d}", &["\u{1f466}\u{308}", "\u{261d}"]), ("\u{1f466}\u{1f3fb}",
        &["\u{1f466}\u{1f3fb}"]), ("\u{1f466}\u{308}\u{1f3fb}", &["\u{1f466}\u{308}\u{1f3fb}"]),
        ("\u{1f466}\u{2764}", &["\u{1f466}", "\u{2764}"]), ("\u{1f466}\u{308}\u{2764}",
        &["\u{1f466}\u{308}", "\u{2764}"]), ("\u{1f466}\u{1f466}", &["\u{1f466}", "\u{1f466}"]),
        ("\u{1f466}\u{308}\u{1f466}", &["\u{1f466}\u{308}", "\u{1f466}"]), ("\u{1f466}\u{ad}",
        &["\u{1f466}\u{ad}"]), ("\u{1f466}\u{308}\u{ad}", &["\u{1f466}\u{308}\u{ad}"]),
        ("\u{1f466}\u{300}", &["\u{1f466}\u{300}"]), ("\u{1f466}\u{308}\u{300}",
        &["\u{1f466}\u{308}\u{300}"]), ("\u{1f466}\u{200d}", &["\u{1f466}\u{200d}"]),
        ("\u{1f466}\u{308}\u{200d}", &["\u{1f466}\u{308}\u{200d}"]), ("\u{1f466}\u{61}\u{2060}",
        &["\u{1f466}", "\u{61}\u{2060}"]), ("\u{1f466}\u{308}\u{61}\u{2060}", &["\u{1f466}\u{308}",
        "\u{61}\u{2060}"]), ("\u{1f466}\u{61}\u{3a}", &["\u{1f466}", "\u{61}", "\u{3a}"]),
        ("\u{1f466}\u{308}\u{61}\u{3a}", &["\u{1f466}\u{308}", "\u{61}", "\u{3a}"]),
        ("\u{1f466}\u{61}\u{27}", &["\u{1f466}", "\u{61}", "\u{27}"]),
        ("\u{1f466}\u{308}\u{61}\u{27}", &["\u{1f466}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{1f466}\u{61}\u{27}\u{2060}", &["\u{1f466}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{1f466}\u{308}\u{61}\u{27}\u{2060}", &["\u{1f466}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{1f466}\u{61}\u{2c}", &["\u{1f466}", "\u{61}", "\u{2c}"]),
        ("\u{1f466}\u{308}\u{61}\u{2c}", &["\u{1f466}\u{308}", "\u{61}", "\u{2c}"]),
        ("\u{1f466}\u{31}\u{3a}", &["\u{1f466}", "\u{31}", "\u{3a}"]),
        ("\u{1f466}\u{308}\u{31}\u{3a}", &["\u{1f466}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{1f466}\u{31}\u{27}", &["\u{1f466}", "\u{31}", "\u{27}"]),
        ("\u{1f466}\u{308}\u{31}\u{27}", &["\u{1f466}\u{308}", "\u{31}", "\u{27}"]),
        ("\u{1f466}\u{31}\u{2c}", &["\u{1f466}", "\u{31}", "\u{2c}"]),
        ("\u{1f466}\u{308}\u{31}\u{2c}", &["\u{1f466}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{1f466}\u{31}\u{2e}\u{2060}", &["\u{1f466}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{1f466}\u{308}\u{31}\u{2e}\u{2060}", &["\u{1f466}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{ad}\u{1}", &["\u{ad}", "\u{1}"]), ("\u{ad}\u{308}\u{1}", &["\u{ad}\u{308}", "\u{1}"]),
        ("\u{ad}\u{d}", &["\u{ad}", "\u{d}"]), ("\u{ad}\u{308}\u{d}", &["\u{ad}\u{308}", "\u{d}"]),
        ("\u{ad}\u{a}", &["\u{ad}", "\u{a}"]), ("\u{ad}\u{308}\u{a}", &["\u{ad}\u{308}", "\u{a}"]),
        ("\u{ad}\u{b}", &["\u{ad}", "\u{b}"]), ("\u{ad}\u{308}\u{b}", &["\u{ad}\u{308}", "\u{b}"]),
        ("\u{ad}\u{3031}", &["\u{ad}", "\u{3031}"]), ("\u{ad}\u{308}\u{3031}", &["\u{ad}\u{308}",
        "\u{3031}"]), ("\u{ad}\u{41}", &["\u{ad}", "\u{41}"]), ("\u{ad}\u{308}\u{41}",
        &["\u{ad}\u{308}", "\u{41}"]), ("\u{ad}\u{3a}", &["\u{ad}", "\u{3a}"]),
        ("\u{ad}\u{308}\u{3a}", &["\u{ad}\u{308}", "\u{3a}"]), ("\u{ad}\u{2c}", &["\u{ad}",
        "\u{2c}"]), ("\u{ad}\u{308}\u{2c}", &["\u{ad}\u{308}", "\u{2c}"]), ("\u{ad}\u{2e}",
        &["\u{ad}", "\u{2e}"]), ("\u{ad}\u{308}\u{2e}", &["\u{ad}\u{308}", "\u{2e}"]),
        ("\u{ad}\u{30}", &["\u{ad}", "\u{30}"]), ("\u{ad}\u{308}\u{30}", &["\u{ad}\u{308}",
        "\u{30}"]), ("\u{ad}\u{5f}", &["\u{ad}", "\u{5f}"]), ("\u{ad}\u{308}\u{5f}",
        &["\u{ad}\u{308}", "\u{5f}"]), ("\u{ad}\u{1f1e6}", &["\u{ad}", "\u{1f1e6}"]),
        ("\u{ad}\u{308}\u{1f1e6}", &["\u{ad}\u{308}", "\u{1f1e6}"]), ("\u{ad}\u{5d0}", &["\u{ad}",
        "\u{5d0}"]), ("\u{ad}\u{308}\u{5d0}", &["\u{ad}\u{308}", "\u{5d0}"]), ("\u{ad}\u{22}",
        &["\u{ad}", "\u{22}"]), ("\u{ad}\u{308}\u{22}", &["\u{ad}\u{308}", "\u{22}"]),
        ("\u{ad}\u{27}", &["\u{ad}", "\u{27}"]), ("\u{ad}\u{308}\u{27}", &["\u{ad}\u{308}",
        "\u{27}"]), ("\u{ad}\u{261d}", &["\u{ad}", "\u{261d}"]), ("\u{ad}\u{308}\u{261d}",
        &["\u{ad}\u{308}", "\u{261d}"]), ("\u{ad}\u{1f3fb}", &["\u{ad}", "\u{1f3fb}"]),
        ("\u{ad}\u{308}\u{1f3fb}", &["\u{ad}\u{308}", "\u{1f3fb}"]), ("\u{ad}\u{2764}", &["\u{ad}",
        "\u{2764}"]), ("\u{ad}\u{308}\u{2764}", &["\u{ad}\u{308}", "\u{2764}"]), ("\u{ad}\u{1f466}",
        &["\u{ad}", "\u{1f466}"]), ("\u{ad}\u{308}\u{1f466}", &["\u{ad}\u{308}", "\u{1f466}"]),
        ("\u{ad}\u{ad}", &["\u{ad}\u{ad}"]), ("\u{ad}\u{308}\u{ad}", &["\u{ad}\u{308}\u{ad}"]),
        ("\u{ad}\u{300}", &["\u{ad}\u{300}"]), ("\u{ad}\u{308}\u{300}", &["\u{ad}\u{308}\u{300}"]),
        ("\u{ad}\u{200d}", &["\u{ad}\u{200d}"]), ("\u{ad}\u{308}\u{200d}",
        &["\u{ad}\u{308}\u{200d}"]), ("\u{ad}\u{61}\u{2060}", &["\u{ad}", "\u{61}\u{2060}"]),
        ("\u{ad}\u{308}\u{61}\u{2060}", &["\u{ad}\u{308}", "\u{61}\u{2060}"]),
        ("\u{ad}\u{61}\u{3a}", &["\u{ad}", "\u{61}", "\u{3a}"]), ("\u{ad}\u{308}\u{61}\u{3a}",
        &["\u{ad}\u{308}", "\u{61}", "\u{3a}"]), ("\u{ad}\u{61}\u{27}", &["\u{ad}", "\u{61}",
        "\u{27}"]), ("\u{ad}\u{308}\u{61}\u{27}", &["\u{ad}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{ad}\u{61}\u{27}\u{2060}", &["\u{ad}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{ad}\u{308}\u{61}\u{27}\u{2060}", &["\u{ad}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{ad}\u{61}\u{2c}", &["\u{ad}", "\u{61}", "\u{2c}"]), ("\u{ad}\u{308}\u{61}\u{2c}",
        &["\u{ad}\u{308}", "\u{61}", "\u{2c}"]), ("\u{ad}\u{31}\u{3a}", &["\u{ad}", "\u{31}",
        "\u{3a}"]), ("\u{ad}\u{308}\u{31}\u{3a}", &["\u{ad}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{ad}\u{31}\u{27}", &["\u{ad}", "\u{31}", "\u{27}"]), ("\u{ad}\u{308}\u{31}\u{27}",
        &["\u{ad}\u{308}", "\u{31}", "\u{27}"]), ("\u{ad}\u{31}\u{2c}", &["\u{ad}", "\u{31}",
        "\u{2c}"]), ("\u{ad}\u{308}\u{31}\u{2c}", &["\u{ad}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{ad}\u{31}\u{2e}\u{2060}", &["\u{ad}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{ad}\u{308}\u{31}\u{2e}\u{2060}", &["\u{ad}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{300}\u{1}", &["\u{300}", "\u{1}"]), ("\u{300}\u{308}\u{1}", &["\u{300}\u{308}",
        "\u{1}"]), ("\u{300}\u{d}", &["\u{300}", "\u{d}"]), ("\u{300}\u{308}\u{d}",
        &["\u{300}\u{308}", "\u{d}"]), ("\u{300}\u{a}", &["\u{300}", "\u{a}"]),
        ("\u{300}\u{308}\u{a}", &["\u{300}\u{308}", "\u{a}"]), ("\u{300}\u{b}", &["\u{300}",
        "\u{b}"]), ("\u{300}\u{308}\u{b}", &["\u{300}\u{308}", "\u{b}"]), ("\u{300}\u{3031}",
        &["\u{300}", "\u{3031}"]), ("\u{300}\u{308}\u{3031}", &["\u{300}\u{308}", "\u{3031}"]),
        ("\u{300}\u{41}", &["\u{300}", "\u{41}"]), ("\u{300}\u{308}\u{41}", &["\u{300}\u{308}",
        "\u{41}"]), ("\u{300}\u{3a}", &["\u{300}", "\u{3a}"]), ("\u{300}\u{308}\u{3a}",
        &["\u{300}\u{308}", "\u{3a}"]), ("\u{300}\u{2c}", &["\u{300}", "\u{2c}"]),
        ("\u{300}\u{308}\u{2c}", &["\u{300}\u{308}", "\u{2c}"]), ("\u{300}\u{2e}", &["\u{300}",
        "\u{2e}"]), ("\u{300}\u{308}\u{2e}", &["\u{300}\u{308}", "\u{2e}"]), ("\u{300}\u{30}",
        &["\u{300}", "\u{30}"]), ("\u{300}\u{308}\u{30}", &["\u{300}\u{308}", "\u{30}"]),
        ("\u{300}\u{5f}", &["\u{300}", "\u{5f}"]), ("\u{300}\u{308}\u{5f}", &["\u{300}\u{308}",
        "\u{5f}"]), ("\u{300}\u{1f1e6}", &["\u{300}", "\u{1f1e6}"]), ("\u{300}\u{308}\u{1f1e6}",
        &["\u{300}\u{308}", "\u{1f1e6}"]), ("\u{300}\u{5d0}", &["\u{300}", "\u{5d0}"]),
        ("\u{300}\u{308}\u{5d0}", &["\u{300}\u{308}", "\u{5d0}"]), ("\u{300}\u{22}", &["\u{300}",
        "\u{22}"]), ("\u{300}\u{308}\u{22}", &["\u{300}\u{308}", "\u{22}"]), ("\u{300}\u{27}",
        &["\u{300}", "\u{27}"]), ("\u{300}\u{308}\u{27}", &["\u{300}\u{308}", "\u{27}"]),
        ("\u{300}\u{261d}", &["\u{300}", "\u{261d}"]), ("\u{300}\u{308}\u{261d}",
        &["\u{300}\u{308}", "\u{261d}"]), ("\u{300}\u{1f3fb}", &["\u{300}", "\u{1f3fb}"]),
        ("\u{300}\u{308}\u{1f3fb}", &["\u{300}\u{308}", "\u{1f3fb}"]), ("\u{300}\u{2764}",
        &["\u{300}", "\u{2764}"]), ("\u{300}\u{308}\u{2764}", &["\u{300}\u{308}", "\u{2764}"]),
        ("\u{300}\u{1f466}", &["\u{300}", "\u{1f466}"]), ("\u{300}\u{308}\u{1f466}",
        &["\u{300}\u{308}", "\u{1f466}"]), ("\u{300}\u{ad}", &["\u{300}\u{ad}"]),
        ("\u{300}\u{308}\u{ad}", &["\u{300}\u{308}\u{ad}"]), ("\u{300}\u{300}",
        &["\u{300}\u{300}"]), ("\u{300}\u{308}\u{300}", &["\u{300}\u{308}\u{300}"]),
        ("\u{300}\u{200d}", &["\u{300}\u{200d}"]), ("\u{300}\u{308}\u{200d}",
        &["\u{300}\u{308}\u{200d}"]), ("\u{300}\u{61}\u{2060}", &["\u{300}", "\u{61}\u{2060}"]),
        ("\u{300}\u{308}\u{61}\u{2060}", &["\u{300}\u{308}", "\u{61}\u{2060}"]),
        ("\u{300}\u{61}\u{3a}", &["\u{300}", "\u{61}", "\u{3a}"]), ("\u{300}\u{308}\u{61}\u{3a}",
        &["\u{300}\u{308}", "\u{61}", "\u{3a}"]), ("\u{300}\u{61}\u{27}", &["\u{300}", "\u{61}",
        "\u{27}"]), ("\u{300}\u{308}\u{61}\u{27}", &["\u{300}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{300}\u{61}\u{27}\u{2060}", &["\u{300}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{300}\u{308}\u{61}\u{27}\u{2060}", &["\u{300}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{300}\u{61}\u{2c}", &["\u{300}", "\u{61}", "\u{2c}"]), ("\u{300}\u{308}\u{61}\u{2c}",
        &["\u{300}\u{308}", "\u{61}", "\u{2c}"]), ("\u{300}\u{31}\u{3a}", &["\u{300}", "\u{31}",
        "\u{3a}"]), ("\u{300}\u{308}\u{31}\u{3a}", &["\u{300}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{300}\u{31}\u{27}", &["\u{300}", "\u{31}", "\u{27}"]), ("\u{300}\u{308}\u{31}\u{27}",
        &["\u{300}\u{308}", "\u{31}", "\u{27}"]), ("\u{300}\u{31}\u{2c}", &["\u{300}", "\u{31}",
        "\u{2c}"]), ("\u{300}\u{308}\u{31}\u{2c}", &["\u{300}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{300}\u{31}\u{2e}\u{2060}", &["\u{300}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{300}\u{308}\u{31}\u{2e}\u{2060}", &["\u{300}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{200d}\u{1}", &["\u{200d}", "\u{1}"]), ("\u{200d}\u{308}\u{1}", &["\u{200d}\u{308}",
        "\u{1}"]), ("\u{200d}\u{d}", &["\u{200d}", "\u{d}"]), ("\u{200d}\u{308}\u{d}",
        &["\u{200d}\u{308}", "\u{d}"]), ("\u{200d}\u{a}", &["\u{200d}", "\u{a}"]),
        ("\u{200d}\u{308}\u{a}", &["\u{200d}\u{308}", "\u{a}"]), ("\u{200d}\u{b}", &["\u{200d}",
        "\u{b}"]), ("\u{200d}\u{308}\u{b}", &["\u{200d}\u{308}", "\u{b}"]), ("\u{200d}\u{3031}",
        &["\u{200d}", "\u{3031}"]), ("\u{200d}\u{308}\u{3031}", &["\u{200d}\u{308}", "\u{3031}"]),
        ("\u{200d}\u{41}", &["\u{200d}", "\u{41}"]), ("\u{200d}\u{308}\u{41}", &["\u{200d}\u{308}",
        "\u{41}"]), ("\u{200d}\u{3a}", &["\u{200d}", "\u{3a}"]), ("\u{200d}\u{308}\u{3a}",
        &["\u{200d}\u{308}", "\u{3a}"]), ("\u{200d}\u{2c}", &["\u{200d}", "\u{2c}"]),
        ("\u{200d}\u{308}\u{2c}", &["\u{200d}\u{308}", "\u{2c}"]), ("\u{200d}\u{2e}", &["\u{200d}",
        "\u{2e}"]), ("\u{200d}\u{308}\u{2e}", &["\u{200d}\u{308}", "\u{2e}"]), ("\u{200d}\u{30}",
        &["\u{200d}", "\u{30}"]), ("\u{200d}\u{308}\u{30}", &["\u{200d}\u{308}", "\u{30}"]),
        ("\u{200d}\u{5f}", &["\u{200d}", "\u{5f}"]), ("\u{200d}\u{308}\u{5f}", &["\u{200d}\u{308}",
        "\u{5f}"]), ("\u{200d}\u{1f1e6}", &["\u{200d}", "\u{1f1e6}"]), ("\u{200d}\u{308}\u{1f1e6}",
        &["\u{200d}\u{308}", "\u{1f1e6}"]), ("\u{200d}\u{5d0}", &["\u{200d}", "\u{5d0}"]),
        ("\u{200d}\u{308}\u{5d0}", &["\u{200d}\u{308}", "\u{5d0}"]), ("\u{200d}\u{22}",
        &["\u{200d}", "\u{22}"]), ("\u{200d}\u{308}\u{22}", &["\u{200d}\u{308}", "\u{22}"]),
        ("\u{200d}\u{27}", &["\u{200d}", "\u{27}"]), ("\u{200d}\u{308}\u{27}", &["\u{200d}\u{308}",
        "\u{27}"]), ("\u{200d}\u{261d}", &["\u{200d}", "\u{261d}"]), ("\u{200d}\u{308}\u{261d}",
        &["\u{200d}\u{308}", "\u{261d}"]), ("\u{200d}\u{1f3fb}", &["\u{200d}", "\u{1f3fb}"]),
        ("\u{200d}\u{308}\u{1f3fb}", &["\u{200d}\u{308}", "\u{1f3fb}"]), ("\u{200d}\u{2764}",
        &["\u{200d}\u{2764}"]), ("\u{200d}\u{308}\u{2764}", &["\u{200d}\u{308}", "\u{2764}"]),
        ("\u{200d}\u{1f466}", &["\u{200d}\u{1f466}"]), ("\u{200d}\u{308}\u{1f466}",
        &["\u{200d}\u{308}", "\u{1f466}"]), ("\u{200d}\u{ad}", &["\u{200d}\u{ad}"]),
        ("\u{200d}\u{308}\u{ad}", &["\u{200d}\u{308}\u{ad}"]), ("\u{200d}\u{300}",
        &["\u{200d}\u{300}"]), ("\u{200d}\u{308}\u{300}", &["\u{200d}\u{308}\u{300}"]),
        ("\u{200d}\u{200d}", &["\u{200d}\u{200d}"]), ("\u{200d}\u{308}\u{200d}",
        &["\u{200d}\u{308}\u{200d}"]), ("\u{200d}\u{61}\u{2060}", &["\u{200d}", "\u{61}\u{2060}"]),
        ("\u{200d}\u{308}\u{61}\u{2060}", &["\u{200d}\u{308}", "\u{61}\u{2060}"]),
        ("\u{200d}\u{61}\u{3a}", &["\u{200d}", "\u{61}", "\u{3a}"]), ("\u{200d}\u{308}\u{61}\u{3a}",
        &["\u{200d}\u{308}", "\u{61}", "\u{3a}"]), ("\u{200d}\u{61}\u{27}", &["\u{200d}", "\u{61}",
        "\u{27}"]), ("\u{200d}\u{308}\u{61}\u{27}", &["\u{200d}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{200d}\u{61}\u{27}\u{2060}", &["\u{200d}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{200d}\u{308}\u{61}\u{27}\u{2060}", &["\u{200d}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{200d}\u{61}\u{2c}", &["\u{200d}", "\u{61}", "\u{2c}"]), ("\u{200d}\u{308}\u{61}\u{2c}",
        &["\u{200d}\u{308}", "\u{61}", "\u{2c}"]), ("\u{200d}\u{31}\u{3a}", &["\u{200d}", "\u{31}",
        "\u{3a}"]), ("\u{200d}\u{308}\u{31}\u{3a}", &["\u{200d}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{200d}\u{31}\u{27}", &["\u{200d}", "\u{31}", "\u{27}"]), ("\u{200d}\u{308}\u{31}\u{27}",
        &["\u{200d}\u{308}", "\u{31}", "\u{27}"]), ("\u{200d}\u{31}\u{2c}", &["\u{200d}", "\u{31}",
        "\u{2c}"]), ("\u{200d}\u{308}\u{31}\u{2c}", &["\u{200d}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{200d}\u{31}\u{2e}\u{2060}", &["\u{200d}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{200d}\u{308}\u{31}\u{2e}\u{2060}", &["\u{200d}\u{308}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{61}\u{2060}\u{1}", &["\u{61}\u{2060}", "\u{1}"]), ("\u{61}\u{2060}\u{308}\u{1}",
        &["\u{61}\u{2060}\u{308}", "\u{1}"]), ("\u{61}\u{2060}\u{d}", &["\u{61}\u{2060}", "\u{d}"]),
        ("\u{61}\u{2060}\u{308}\u{d}", &["\u{61}\u{2060}\u{308}", "\u{d}"]), ("\u{61}\u{2060}\u{a}",
        &["\u{61}\u{2060}", "\u{a}"]), ("\u{61}\u{2060}\u{308}\u{a}", &["\u{61}\u{2060}\u{308}",
        "\u{a}"]), ("\u{61}\u{2060}\u{b}", &["\u{61}\u{2060}", "\u{b}"]),
        ("\u{61}\u{2060}\u{308}\u{b}", &["\u{61}\u{2060}\u{308}", "\u{b}"]),
        ("\u{61}\u{2060}\u{3031}", &["\u{61}\u{2060}", "\u{3031}"]),
        ("\u{61}\u{2060}\u{308}\u{3031}", &["\u{61}\u{2060}\u{308}", "\u{3031}"]),
        ("\u{61}\u{2060}\u{41}", &["\u{61}\u{2060}\u{41}"]), ("\u{61}\u{2060}\u{308}\u{41}",
        &["\u{61}\u{2060}\u{308}\u{41}"]), ("\u{61}\u{2060}\u{3a}", &["\u{61}\u{2060}", "\u{3a}"]),
        ("\u{61}\u{2060}\u{308}\u{3a}", &["\u{61}\u{2060}\u{308}", "\u{3a}"]),
        ("\u{61}\u{2060}\u{2c}", &["\u{61}\u{2060}", "\u{2c}"]), ("\u{61}\u{2060}\u{308}\u{2c}",
        &["\u{61}\u{2060}\u{308}", "\u{2c}"]), ("\u{61}\u{2060}\u{2e}", &["\u{61}\u{2060}",
        "\u{2e}"]), ("\u{61}\u{2060}\u{308}\u{2e}", &["\u{61}\u{2060}\u{308}", "\u{2e}"]),
        ("\u{61}\u{2060}\u{30}", &["\u{61}\u{2060}\u{30}"]), ("\u{61}\u{2060}\u{308}\u{30}",
        &["\u{61}\u{2060}\u{308}\u{30}"]), ("\u{61}\u{2060}\u{5f}", &["\u{61}\u{2060}\u{5f}"]),
        ("\u{61}\u{2060}\u{308}\u{5f}", &["\u{61}\u{2060}\u{308}\u{5f}"]),
        ("\u{61}\u{2060}\u{1f1e6}", &["\u{61}\u{2060}", "\u{1f1e6}"]),
        ("\u{61}\u{2060}\u{308}\u{1f1e6}", &["\u{61}\u{2060}\u{308}", "\u{1f1e6}"]),
        ("\u{61}\u{2060}\u{5d0}", &["\u{61}\u{2060}\u{5d0}"]), ("\u{61}\u{2060}\u{308}\u{5d0}",
        &["\u{61}\u{2060}\u{308}\u{5d0}"]), ("\u{61}\u{2060}\u{22}", &["\u{61}\u{2060}", "\u{22}"]),
        ("\u{61}\u{2060}\u{308}\u{22}", &["\u{61}\u{2060}\u{308}", "\u{22}"]),
        ("\u{61}\u{2060}\u{27}", &["\u{61}\u{2060}", "\u{27}"]), ("\u{61}\u{2060}\u{308}\u{27}",
        &["\u{61}\u{2060}\u{308}", "\u{27}"]), ("\u{61}\u{2060}\u{261d}", &["\u{61}\u{2060}",
        "\u{261d}"]), ("\u{61}\u{2060}\u{308}\u{261d}", &["\u{61}\u{2060}\u{308}", "\u{261d}"]),
        ("\u{61}\u{2060}\u{1f3fb}", &["\u{61}\u{2060}", "\u{1f3fb}"]),
        ("\u{61}\u{2060}\u{308}\u{1f3fb}", &["\u{61}\u{2060}\u{308}", "\u{1f3fb}"]),
        ("\u{61}\u{2060}\u{2764}", &["\u{61}\u{2060}", "\u{2764}"]),
        ("\u{61}\u{2060}\u{308}\u{2764}", &["\u{61}\u{2060}\u{308}", "\u{2764}"]),
        ("\u{61}\u{2060}\u{1f466}", &["\u{61}\u{2060}", "\u{1f466}"]),
        ("\u{61}\u{2060}\u{308}\u{1f466}", &["\u{61}\u{2060}\u{308}", "\u{1f466}"]),
        ("\u{61}\u{2060}\u{ad}", &["\u{61}\u{2060}\u{ad}"]), ("\u{61}\u{2060}\u{308}\u{ad}",
        &["\u{61}\u{2060}\u{308}\u{ad}"]), ("\u{61}\u{2060}\u{300}", &["\u{61}\u{2060}\u{300}"]),
        ("\u{61}\u{2060}\u{308}\u{300}", &["\u{61}\u{2060}\u{308}\u{300}"]),
        ("\u{61}\u{2060}\u{200d}", &["\u{61}\u{2060}\u{200d}"]), ("\u{61}\u{2060}\u{308}\u{200d}",
        &["\u{61}\u{2060}\u{308}\u{200d}"]), ("\u{61}\u{2060}\u{61}\u{2060}",
        &["\u{61}\u{2060}\u{61}\u{2060}"]), ("\u{61}\u{2060}\u{308}\u{61}\u{2060}",
        &["\u{61}\u{2060}\u{308}\u{61}\u{2060}"]), ("\u{61}\u{2060}\u{61}\u{3a}",
        &["\u{61}\u{2060}\u{61}", "\u{3a}"]), ("\u{61}\u{2060}\u{308}\u{61}\u{3a}",
        &["\u{61}\u{2060}\u{308}\u{61}", "\u{3a}"]), ("\u{61}\u{2060}\u{61}\u{27}",
        &["\u{61}\u{2060}\u{61}", "\u{27}"]), ("\u{61}\u{2060}\u{308}\u{61}\u{27}",
        &["\u{61}\u{2060}\u{308}\u{61}", "\u{27}"]), ("\u{61}\u{2060}\u{61}\u{27}\u{2060}",
        &["\u{61}\u{2060}\u{61}", "\u{27}\u{2060}"]), ("\u{61}\u{2060}\u{308}\u{61}\u{27}\u{2060}",
        &["\u{61}\u{2060}\u{308}\u{61}", "\u{27}\u{2060}"]), ("\u{61}\u{2060}\u{61}\u{2c}",
        &["\u{61}\u{2060}\u{61}", "\u{2c}"]), ("\u{61}\u{2060}\u{308}\u{61}\u{2c}",
        &["\u{61}\u{2060}\u{308}\u{61}", "\u{2c}"]), ("\u{61}\u{2060}\u{31}\u{3a}",
        &["\u{61}\u{2060}\u{31}", "\u{3a}"]), ("\u{61}\u{2060}\u{308}\u{31}\u{3a}",
        &["\u{61}\u{2060}\u{308}\u{31}", "\u{3a}"]), ("\u{61}\u{2060}\u{31}\u{27}",
        &["\u{61}\u{2060}\u{31}", "\u{27}"]), ("\u{61}\u{2060}\u{308}\u{31}\u{27}",
        &["\u{61}\u{2060}\u{308}\u{31}", "\u{27}"]), ("\u{61}\u{2060}\u{31}\u{2c}",
        &["\u{61}\u{2060}\u{31}", "\u{2c}"]), ("\u{61}\u{2060}\u{308}\u{31}\u{2c}",
        &["\u{61}\u{2060}\u{308}\u{31}", "\u{2c}"]), ("\u{61}\u{2060}\u{31}\u{2e}\u{2060}",
        &["\u{61}\u{2060}\u{31}", "\u{2e}\u{2060}"]), ("\u{61}\u{2060}\u{308}\u{31}\u{2e}\u{2060}",
        &["\u{61}\u{2060}\u{308}\u{31}", "\u{2e}\u{2060}"]), ("\u{61}\u{3a}\u{1}", &["\u{61}",
        "\u{3a}", "\u{1}"]), ("\u{61}\u{3a}\u{308}\u{1}", &["\u{61}", "\u{3a}\u{308}", "\u{1}"]),
        ("\u{61}\u{3a}\u{d}", &["\u{61}", "\u{3a}", "\u{d}"]), ("\u{61}\u{3a}\u{308}\u{d}",
        &["\u{61}", "\u{3a}\u{308}", "\u{d}"]), ("\u{61}\u{3a}\u{a}", &["\u{61}", "\u{3a}",
        "\u{a}"]), ("\u{61}\u{3a}\u{308}\u{a}", &["\u{61}", "\u{3a}\u{308}", "\u{a}"]),
        ("\u{61}\u{3a}\u{b}", &["\u{61}", "\u{3a}", "\u{b}"]), ("\u{61}\u{3a}\u{308}\u{b}",
        &["\u{61}", "\u{3a}\u{308}", "\u{b}"]), ("\u{61}\u{3a}\u{3031}", &["\u{61}", "\u{3a}",
        "\u{3031}"]), ("\u{61}\u{3a}\u{308}\u{3031}", &["\u{61}", "\u{3a}\u{308}", "\u{3031}"]),
        ("\u{61}\u{3a}\u{41}", &["\u{61}\u{3a}\u{41}"]), ("\u{61}\u{3a}\u{308}\u{41}",
        &["\u{61}\u{3a}\u{308}\u{41}"]), ("\u{61}\u{3a}\u{3a}", &["\u{61}", "\u{3a}", "\u{3a}"]),
        ("\u{61}\u{3a}\u{308}\u{3a}", &["\u{61}", "\u{3a}\u{308}", "\u{3a}"]),
        ("\u{61}\u{3a}\u{2c}", &["\u{61}", "\u{3a}", "\u{2c}"]), ("\u{61}\u{3a}\u{308}\u{2c}",
        &["\u{61}", "\u{3a}\u{308}", "\u{2c}"]), ("\u{61}\u{3a}\u{2e}", &["\u{61}", "\u{3a}",
        "\u{2e}"]), ("\u{61}\u{3a}\u{308}\u{2e}", &["\u{61}", "\u{3a}\u{308}", "\u{2e}"]),
        ("\u{61}\u{3a}\u{30}", &["\u{61}", "\u{3a}", "\u{30}"]), ("\u{61}\u{3a}\u{308}\u{30}",
        &["\u{61}", "\u{3a}\u{308}", "\u{30}"]), ("\u{61}\u{3a}\u{5f}", &["\u{61}", "\u{3a}",
        "\u{5f}"]), ("\u{61}\u{3a}\u{308}\u{5f}", &["\u{61}", "\u{3a}\u{308}", "\u{5f}"]),
        ("\u{61}\u{3a}\u{1f1e6}", &["\u{61}", "\u{3a}", "\u{1f1e6}"]),
        ("\u{61}\u{3a}\u{308}\u{1f1e6}", &["\u{61}", "\u{3a}\u{308}", "\u{1f1e6}"]),
        ("\u{61}\u{3a}\u{5d0}", &["\u{61}\u{3a}\u{5d0}"]), ("\u{61}\u{3a}\u{308}\u{5d0}",
        &["\u{61}\u{3a}\u{308}\u{5d0}"]), ("\u{61}\u{3a}\u{22}", &["\u{61}", "\u{3a}", "\u{22}"]),
        ("\u{61}\u{3a}\u{308}\u{22}", &["\u{61}", "\u{3a}\u{308}", "\u{22}"]),
        ("\u{61}\u{3a}\u{27}", &["\u{61}", "\u{3a}", "\u{27}"]), ("\u{61}\u{3a}\u{308}\u{27}",
        &["\u{61}", "\u{3a}\u{308}", "\u{27}"]), ("\u{61}\u{3a}\u{261d}", &["\u{61}", "\u{3a}",
        "\u{261d}"]), ("\u{61}\u{3a}\u{308}\u{261d}", &["\u{61}", "\u{3a}\u{308}", "\u{261d}"]),
        ("\u{61}\u{3a}\u{1f3fb}", &["\u{61}", "\u{3a}", "\u{1f3fb}"]),
        ("\u{61}\u{3a}\u{308}\u{1f3fb}", &["\u{61}", "\u{3a}\u{308}", "\u{1f3fb}"]),
        ("\u{61}\u{3a}\u{2764}", &["\u{61}", "\u{3a}", "\u{2764}"]), ("\u{61}\u{3a}\u{308}\u{2764}",
        &["\u{61}", "\u{3a}\u{308}", "\u{2764}"]), ("\u{61}\u{3a}\u{1f466}", &["\u{61}", "\u{3a}",
        "\u{1f466}"]), ("\u{61}\u{3a}\u{308}\u{1f466}", &["\u{61}", "\u{3a}\u{308}", "\u{1f466}"]),
        ("\u{61}\u{3a}\u{ad}", &["\u{61}", "\u{3a}\u{ad}"]), ("\u{61}\u{3a}\u{308}\u{ad}",
        &["\u{61}", "\u{3a}\u{308}\u{ad}"]), ("\u{61}\u{3a}\u{300}", &["\u{61}", "\u{3a}\u{300}"]),
        ("\u{61}\u{3a}\u{308}\u{300}", &["\u{61}", "\u{3a}\u{308}\u{300}"]),
        ("\u{61}\u{3a}\u{200d}", &["\u{61}", "\u{3a}\u{200d}"]), ("\u{61}\u{3a}\u{308}\u{200d}",
        &["\u{61}", "\u{3a}\u{308}\u{200d}"]), ("\u{61}\u{3a}\u{61}\u{2060}",
        &["\u{61}\u{3a}\u{61}\u{2060}"]), ("\u{61}\u{3a}\u{308}\u{61}\u{2060}",
        &["\u{61}\u{3a}\u{308}\u{61}\u{2060}"]), ("\u{61}\u{3a}\u{61}\u{3a}",
        &["\u{61}\u{3a}\u{61}", "\u{3a}"]), ("\u{61}\u{3a}\u{308}\u{61}\u{3a}",
        &["\u{61}\u{3a}\u{308}\u{61}", "\u{3a}"]), ("\u{61}\u{3a}\u{61}\u{27}",
        &["\u{61}\u{3a}\u{61}", "\u{27}"]), ("\u{61}\u{3a}\u{308}\u{61}\u{27}",
        &["\u{61}\u{3a}\u{308}\u{61}", "\u{27}"]), ("\u{61}\u{3a}\u{61}\u{27}\u{2060}",
        &["\u{61}\u{3a}\u{61}", "\u{27}\u{2060}"]), ("\u{61}\u{3a}\u{308}\u{61}\u{27}\u{2060}",
        &["\u{61}\u{3a}\u{308}\u{61}", "\u{27}\u{2060}"]), ("\u{61}\u{3a}\u{61}\u{2c}",
        &["\u{61}\u{3a}\u{61}", "\u{2c}"]), ("\u{61}\u{3a}\u{308}\u{61}\u{2c}",
        &["\u{61}\u{3a}\u{308}\u{61}", "\u{2c}"]), ("\u{61}\u{3a}\u{31}\u{3a}", &["\u{61}",
        "\u{3a}", "\u{31}", "\u{3a}"]), ("\u{61}\u{3a}\u{308}\u{31}\u{3a}", &["\u{61}",
        "\u{3a}\u{308}", "\u{31}", "\u{3a}"]), ("\u{61}\u{3a}\u{31}\u{27}", &["\u{61}", "\u{3a}",
        "\u{31}", "\u{27}"]), ("\u{61}\u{3a}\u{308}\u{31}\u{27}", &["\u{61}", "\u{3a}\u{308}",
        "\u{31}", "\u{27}"]), ("\u{61}\u{3a}\u{31}\u{2c}", &["\u{61}", "\u{3a}", "\u{31}",
        "\u{2c}"]), ("\u{61}\u{3a}\u{308}\u{31}\u{2c}", &["\u{61}", "\u{3a}\u{308}", "\u{31}",
        "\u{2c}"]), ("\u{61}\u{3a}\u{31}\u{2e}\u{2060}", &["\u{61}", "\u{3a}", "\u{31}",
        "\u{2e}\u{2060}"]), ("\u{61}\u{3a}\u{308}\u{31}\u{2e}\u{2060}", &["\u{61}", "\u{3a}\u{308}",
        "\u{31}", "\u{2e}\u{2060}"]), ("\u{61}\u{27}\u{1}", &["\u{61}", "\u{27}", "\u{1}"]),
        ("\u{61}\u{27}\u{308}\u{1}", &["\u{61}", "\u{27}\u{308}", "\u{1}"]), ("\u{61}\u{27}\u{d}",
        &["\u{61}", "\u{27}", "\u{d}"]), ("\u{61}\u{27}\u{308}\u{d}", &["\u{61}", "\u{27}\u{308}",
        "\u{d}"]), ("\u{61}\u{27}\u{a}", &["\u{61}", "\u{27}", "\u{a}"]),
        ("\u{61}\u{27}\u{308}\u{a}", &["\u{61}", "\u{27}\u{308}", "\u{a}"]), ("\u{61}\u{27}\u{b}",
        &["\u{61}", "\u{27}", "\u{b}"]), ("\u{61}\u{27}\u{308}\u{b}", &["\u{61}", "\u{27}\u{308}",
        "\u{b}"]), ("\u{61}\u{27}\u{3031}", &["\u{61}", "\u{27}", "\u{3031}"]),
        ("\u{61}\u{27}\u{308}\u{3031}", &["\u{61}", "\u{27}\u{308}", "\u{3031}"]),
        ("\u{61}\u{27}\u{41}", &["\u{61}\u{27}\u{41}"]), ("\u{61}\u{27}\u{308}\u{41}",
        &["\u{61}\u{27}\u{308}\u{41}"]), ("\u{61}\u{27}\u{3a}", &["\u{61}", "\u{27}", "\u{3a}"]),
        ("\u{61}\u{27}\u{308}\u{3a}", &["\u{61}", "\u{27}\u{308}", "\u{3a}"]),
        ("\u{61}\u{27}\u{2c}", &["\u{61}", "\u{27}", "\u{2c}"]), ("\u{61}\u{27}\u{308}\u{2c}",
        &["\u{61}", "\u{27}\u{308}", "\u{2c}"]), ("\u{61}\u{27}\u{2e}", &["\u{61}", "\u{27}",
        "\u{2e}"]), ("\u{61}\u{27}\u{308}\u{2e}", &["\u{61}", "\u{27}\u{308}", "\u{2e}"]),
        ("\u{61}\u{27}\u{30}", &["\u{61}", "\u{27}", "\u{30}"]), ("\u{61}\u{27}\u{308}\u{30}",
        &["\u{61}", "\u{27}\u{308}", "\u{30}"]), ("\u{61}\u{27}\u{5f}", &["\u{61}", "\u{27}",
        "\u{5f}"]), ("\u{61}\u{27}\u{308}\u{5f}", &["\u{61}", "\u{27}\u{308}", "\u{5f}"]),
        ("\u{61}\u{27}\u{1f1e6}", &["\u{61}", "\u{27}", "\u{1f1e6}"]),
        ("\u{61}\u{27}\u{308}\u{1f1e6}", &["\u{61}", "\u{27}\u{308}", "\u{1f1e6}"]),
        ("\u{61}\u{27}\u{5d0}", &["\u{61}\u{27}\u{5d0}"]), ("\u{61}\u{27}\u{308}\u{5d0}",
        &["\u{61}\u{27}\u{308}\u{5d0}"]), ("\u{61}\u{27}\u{22}", &["\u{61}", "\u{27}", "\u{22}"]),
        ("\u{61}\u{27}\u{308}\u{22}", &["\u{61}", "\u{27}\u{308}", "\u{22}"]),
        ("\u{61}\u{27}\u{27}", &["\u{61}", "\u{27}", "\u{27}"]), ("\u{61}\u{27}\u{308}\u{27}",
        &["\u{61}", "\u{27}\u{308}", "\u{27}"]), ("\u{61}\u{27}\u{261d}", &["\u{61}", "\u{27}",
        "\u{261d}"]), ("\u{61}\u{27}\u{308}\u{261d}", &["\u{61}", "\u{27}\u{308}", "\u{261d}"]),
        ("\u{61}\u{27}\u{1f3fb}", &["\u{61}", "\u{27}", "\u{1f3fb}"]),
        ("\u{61}\u{27}\u{308}\u{1f3fb}", &["\u{61}", "\u{27}\u{308}", "\u{1f3fb}"]),
        ("\u{61}\u{27}\u{2764}", &["\u{61}", "\u{27}", "\u{2764}"]), ("\u{61}\u{27}\u{308}\u{2764}",
        &["\u{61}", "\u{27}\u{308}", "\u{2764}"]), ("\u{61}\u{27}\u{1f466}", &["\u{61}", "\u{27}",
        "\u{1f466}"]), ("\u{61}\u{27}\u{308}\u{1f466}", &["\u{61}", "\u{27}\u{308}", "\u{1f466}"]),
        ("\u{61}\u{27}\u{ad}", &["\u{61}", "\u{27}\u{ad}"]), ("\u{61}\u{27}\u{308}\u{ad}",
        &["\u{61}", "\u{27}\u{308}\u{ad}"]), ("\u{61}\u{27}\u{300}", &["\u{61}", "\u{27}\u{300}"]),
        ("\u{61}\u{27}\u{308}\u{300}", &["\u{61}", "\u{27}\u{308}\u{300}"]),
        ("\u{61}\u{27}\u{200d}", &["\u{61}", "\u{27}\u{200d}"]), ("\u{61}\u{27}\u{308}\u{200d}",
        &["\u{61}", "\u{27}\u{308}\u{200d}"]), ("\u{61}\u{27}\u{61}\u{2060}",
        &["\u{61}\u{27}\u{61}\u{2060}"]), ("\u{61}\u{27}\u{308}\u{61}\u{2060}",
        &["\u{61}\u{27}\u{308}\u{61}\u{2060}"]), ("\u{61}\u{27}\u{61}\u{3a}",
        &["\u{61}\u{27}\u{61}", "\u{3a}"]), ("\u{61}\u{27}\u{308}\u{61}\u{3a}",
        &["\u{61}\u{27}\u{308}\u{61}", "\u{3a}"]), ("\u{61}\u{27}\u{61}\u{27}",
        &["\u{61}\u{27}\u{61}", "\u{27}"]), ("\u{61}\u{27}\u{308}\u{61}\u{27}",
        &["\u{61}\u{27}\u{308}\u{61}", "\u{27}"]), ("\u{61}\u{27}\u{61}\u{27}\u{2060}",
        &["\u{61}\u{27}\u{61}", "\u{27}\u{2060}"]), ("\u{61}\u{27}\u{308}\u{61}\u{27}\u{2060}",
        &["\u{61}\u{27}\u{308}\u{61}", "\u{27}\u{2060}"]), ("\u{61}\u{27}\u{61}\u{2c}",
        &["\u{61}\u{27}\u{61}", "\u{2c}"]), ("\u{61}\u{27}\u{308}\u{61}\u{2c}",
        &["\u{61}\u{27}\u{308}\u{61}", "\u{2c}"]), ("\u{61}\u{27}\u{31}\u{3a}", &["\u{61}",
        "\u{27}", "\u{31}", "\u{3a}"]), ("\u{61}\u{27}\u{308}\u{31}\u{3a}", &["\u{61}",
        "\u{27}\u{308}", "\u{31}", "\u{3a}"]), ("\u{61}\u{27}\u{31}\u{27}", &["\u{61}", "\u{27}",
        "\u{31}", "\u{27}"]), ("\u{61}\u{27}\u{308}\u{31}\u{27}", &["\u{61}", "\u{27}\u{308}",
        "\u{31}", "\u{27}"]), ("\u{61}\u{27}\u{31}\u{2c}", &["\u{61}", "\u{27}", "\u{31}",
        "\u{2c}"]), ("\u{61}\u{27}\u{308}\u{31}\u{2c}", &["\u{61}", "\u{27}\u{308}", "\u{31}",
        "\u{2c}"]), ("\u{61}\u{27}\u{31}\u{2e}\u{2060}", &["\u{61}", "\u{27}", "\u{31}",
        "\u{2e}\u{2060}"]), ("\u{61}\u{27}\u{308}\u{31}\u{2e}\u{2060}", &["\u{61}", "\u{27}\u{308}",
        "\u{31}", "\u{2e}\u{2060}"]), ("\u{61}\u{27}\u{2060}\u{1}", &["\u{61}", "\u{27}\u{2060}",
        "\u{1}"]), ("\u{61}\u{27}\u{2060}\u{308}\u{1}", &["\u{61}", "\u{27}\u{2060}\u{308}",
        "\u{1}"]), ("\u{61}\u{27}\u{2060}\u{d}", &["\u{61}", "\u{27}\u{2060}", "\u{d}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{d}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{d}"]),
        ("\u{61}\u{27}\u{2060}\u{a}", &["\u{61}", "\u{27}\u{2060}", "\u{a}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{a}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{a}"]),
        ("\u{61}\u{27}\u{2060}\u{b}", &["\u{61}", "\u{27}\u{2060}", "\u{b}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{b}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{b}"]),
        ("\u{61}\u{27}\u{2060}\u{3031}", &["\u{61}", "\u{27}\u{2060}", "\u{3031}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{3031}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{3031}"]),
        ("\u{61}\u{27}\u{2060}\u{41}", &["\u{61}\u{27}\u{2060}\u{41}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{41}", &["\u{61}\u{27}\u{2060}\u{308}\u{41}"]),
        ("\u{61}\u{27}\u{2060}\u{3a}", &["\u{61}", "\u{27}\u{2060}", "\u{3a}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{3a}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{3a}"]),
        ("\u{61}\u{27}\u{2060}\u{2c}", &["\u{61}", "\u{27}\u{2060}", "\u{2c}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{2c}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{2c}"]),
        ("\u{61}\u{27}\u{2060}\u{2e}", &["\u{61}", "\u{27}\u{2060}", "\u{2e}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{2e}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{2e}"]),
        ("\u{61}\u{27}\u{2060}\u{30}", &["\u{61}", "\u{27}\u{2060}", "\u{30}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{30}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{30}"]),
        ("\u{61}\u{27}\u{2060}\u{5f}", &["\u{61}", "\u{27}\u{2060}", "\u{5f}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{5f}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{5f}"]),
        ("\u{61}\u{27}\u{2060}\u{1f1e6}", &["\u{61}", "\u{27}\u{2060}", "\u{1f1e6}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{1f1e6}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{1f1e6}"]),
        ("\u{61}\u{27}\u{2060}\u{5d0}", &["\u{61}\u{27}\u{2060}\u{5d0}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{5d0}", &["\u{61}\u{27}\u{2060}\u{308}\u{5d0}"]),
        ("\u{61}\u{27}\u{2060}\u{22}", &["\u{61}", "\u{27}\u{2060}", "\u{22}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{22}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{22}"]),
        ("\u{61}\u{27}\u{2060}\u{27}", &["\u{61}", "\u{27}\u{2060}", "\u{27}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{27}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{27}"]),
        ("\u{61}\u{27}\u{2060}\u{261d}", &["\u{61}", "\u{27}\u{2060}", "\u{261d}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{261d}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{261d}"]),
        ("\u{61}\u{27}\u{2060}\u{1f3fb}", &["\u{61}", "\u{27}\u{2060}", "\u{1f3fb}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{1f3fb}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{1f3fb}"]),
        ("\u{61}\u{27}\u{2060}\u{2764}", &["\u{61}", "\u{27}\u{2060}", "\u{2764}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{2764}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{2764}"]),
        ("\u{61}\u{27}\u{2060}\u{1f466}", &["\u{61}", "\u{27}\u{2060}", "\u{1f466}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{1f466}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{1f466}"]),
        ("\u{61}\u{27}\u{2060}\u{ad}", &["\u{61}", "\u{27}\u{2060}\u{ad}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{ad}", &["\u{61}", "\u{27}\u{2060}\u{308}\u{ad}"]),
        ("\u{61}\u{27}\u{2060}\u{300}", &["\u{61}", "\u{27}\u{2060}\u{300}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{300}", &["\u{61}", "\u{27}\u{2060}\u{308}\u{300}"]),
        ("\u{61}\u{27}\u{2060}\u{200d}", &["\u{61}", "\u{27}\u{2060}\u{200d}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{200d}", &["\u{61}", "\u{27}\u{2060}\u{308}\u{200d}"]),
        ("\u{61}\u{27}\u{2060}\u{61}\u{2060}", &["\u{61}\u{27}\u{2060}\u{61}\u{2060}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{61}\u{2060}",
        &["\u{61}\u{27}\u{2060}\u{308}\u{61}\u{2060}"]), ("\u{61}\u{27}\u{2060}\u{61}\u{3a}",
        &["\u{61}\u{27}\u{2060}\u{61}", "\u{3a}"]), ("\u{61}\u{27}\u{2060}\u{308}\u{61}\u{3a}",
        &["\u{61}\u{27}\u{2060}\u{308}\u{61}", "\u{3a}"]), ("\u{61}\u{27}\u{2060}\u{61}\u{27}",
        &["\u{61}\u{27}\u{2060}\u{61}", "\u{27}"]), ("\u{61}\u{27}\u{2060}\u{308}\u{61}\u{27}",
        &["\u{61}\u{27}\u{2060}\u{308}\u{61}", "\u{27}"]),
        ("\u{61}\u{27}\u{2060}\u{61}\u{27}\u{2060}", &["\u{61}\u{27}\u{2060}\u{61}",
        "\u{27}\u{2060}"]), ("\u{61}\u{27}\u{2060}\u{308}\u{61}\u{27}\u{2060}",
        &["\u{61}\u{27}\u{2060}\u{308}\u{61}", "\u{27}\u{2060}"]),
        ("\u{61}\u{27}\u{2060}\u{61}\u{2c}", &["\u{61}\u{27}\u{2060}\u{61}", "\u{2c}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{61}\u{2c}", &["\u{61}\u{27}\u{2060}\u{308}\u{61}",
        "\u{2c}"]), ("\u{61}\u{27}\u{2060}\u{31}\u{3a}", &["\u{61}", "\u{27}\u{2060}", "\u{31}",
        "\u{3a}"]), ("\u{61}\u{27}\u{2060}\u{308}\u{31}\u{3a}", &["\u{61}", "\u{27}\u{2060}\u{308}",
        "\u{31}", "\u{3a}"]), ("\u{61}\u{27}\u{2060}\u{31}\u{27}", &["\u{61}", "\u{27}\u{2060}",
        "\u{31}", "\u{27}"]), ("\u{61}\u{27}\u{2060}\u{308}\u{31}\u{27}", &["\u{61}",
        "\u{27}\u{2060}\u{308}", "\u{31}", "\u{27}"]), ("\u{61}\u{27}\u{2060}\u{31}\u{2c}",
        &["\u{61}", "\u{27}\u{2060}", "\u{31}", "\u{2c}"]),
        ("\u{61}\u{27}\u{2060}\u{308}\u{31}\u{2c}", &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{31}",
        "\u{2c}"]), ("\u{61}\u{27}\u{2060}\u{31}\u{2e}\u{2060}", &["\u{61}", "\u{27}\u{2060}",
        "\u{31}", "\u{2e}\u{2060}"]), ("\u{61}\u{27}\u{2060}\u{308}\u{31}\u{2e}\u{2060}",
        &["\u{61}", "\u{27}\u{2060}\u{308}", "\u{31}", "\u{2e}\u{2060}"]), ("\u{61}\u{2c}\u{1}",
        &["\u{61}", "\u{2c}", "\u{1}"]), ("\u{61}\u{2c}\u{308}\u{1}", &["\u{61}", "\u{2c}\u{308}",
        "\u{1}"]), ("\u{61}\u{2c}\u{d}", &["\u{61}", "\u{2c}", "\u{d}"]),
        ("\u{61}\u{2c}\u{308}\u{d}", &["\u{61}", "\u{2c}\u{308}", "\u{d}"]), ("\u{61}\u{2c}\u{a}",
        &["\u{61}", "\u{2c}", "\u{a}"]), ("\u{61}\u{2c}\u{308}\u{a}", &["\u{61}", "\u{2c}\u{308}",
        "\u{a}"]), ("\u{61}\u{2c}\u{b}", &["\u{61}", "\u{2c}", "\u{b}"]),
        ("\u{61}\u{2c}\u{308}\u{b}", &["\u{61}", "\u{2c}\u{308}", "\u{b}"]),
        ("\u{61}\u{2c}\u{3031}", &["\u{61}", "\u{2c}", "\u{3031}"]), ("\u{61}\u{2c}\u{308}\u{3031}",
        &["\u{61}", "\u{2c}\u{308}", "\u{3031}"]), ("\u{61}\u{2c}\u{41}", &["\u{61}", "\u{2c}",
        "\u{41}"]), ("\u{61}\u{2c}\u{308}\u{41}", &["\u{61}", "\u{2c}\u{308}", "\u{41}"]),
        ("\u{61}\u{2c}\u{3a}", &["\u{61}", "\u{2c}", "\u{3a}"]), ("\u{61}\u{2c}\u{308}\u{3a}",
        &["\u{61}", "\u{2c}\u{308}", "\u{3a}"]), ("\u{61}\u{2c}\u{2c}", &["\u{61}", "\u{2c}",
        "\u{2c}"]), ("\u{61}\u{2c}\u{308}\u{2c}", &["\u{61}", "\u{2c}\u{308}", "\u{2c}"]),
        ("\u{61}\u{2c}\u{2e}", &["\u{61}", "\u{2c}", "\u{2e}"]), ("\u{61}\u{2c}\u{308}\u{2e}",
        &["\u{61}", "\u{2c}\u{308}", "\u{2e}"]), ("\u{61}\u{2c}\u{30}", &["\u{61}", "\u{2c}",
        "\u{30}"]), ("\u{61}\u{2c}\u{308}\u{30}", &["\u{61}", "\u{2c}\u{308}", "\u{30}"]),
        ("\u{61}\u{2c}\u{5f}", &["\u{61}", "\u{2c}", "\u{5f}"]), ("\u{61}\u{2c}\u{308}\u{5f}",
        &["\u{61}", "\u{2c}\u{308}", "\u{5f}"]), ("\u{61}\u{2c}\u{1f1e6}", &["\u{61}", "\u{2c}",
        "\u{1f1e6}"]), ("\u{61}\u{2c}\u{308}\u{1f1e6}", &["\u{61}", "\u{2c}\u{308}", "\u{1f1e6}"]),
        ("\u{61}\u{2c}\u{5d0}", &["\u{61}", "\u{2c}", "\u{5d0}"]), ("\u{61}\u{2c}\u{308}\u{5d0}",
        &["\u{61}", "\u{2c}\u{308}", "\u{5d0}"]), ("\u{61}\u{2c}\u{22}", &["\u{61}", "\u{2c}",
        "\u{22}"]), ("\u{61}\u{2c}\u{308}\u{22}", &["\u{61}", "\u{2c}\u{308}", "\u{22}"]),
        ("\u{61}\u{2c}\u{27}", &["\u{61}", "\u{2c}", "\u{27}"]), ("\u{61}\u{2c}\u{308}\u{27}",
        &["\u{61}", "\u{2c}\u{308}", "\u{27}"]), ("\u{61}\u{2c}\u{261d}", &["\u{61}", "\u{2c}",
        "\u{261d}"]), ("\u{61}\u{2c}\u{308}\u{261d}", &["\u{61}", "\u{2c}\u{308}", "\u{261d}"]),
        ("\u{61}\u{2c}\u{1f3fb}", &["\u{61}", "\u{2c}", "\u{1f3fb}"]),
        ("\u{61}\u{2c}\u{308}\u{1f3fb}", &["\u{61}", "\u{2c}\u{308}", "\u{1f3fb}"]),
        ("\u{61}\u{2c}\u{2764}", &["\u{61}", "\u{2c}", "\u{2764}"]), ("\u{61}\u{2c}\u{308}\u{2764}",
        &["\u{61}", "\u{2c}\u{308}", "\u{2764}"]), ("\u{61}\u{2c}\u{1f466}", &["\u{61}", "\u{2c}",
        "\u{1f466}"]), ("\u{61}\u{2c}\u{308}\u{1f466}", &["\u{61}", "\u{2c}\u{308}", "\u{1f466}"]),
        ("\u{61}\u{2c}\u{ad}", &["\u{61}", "\u{2c}\u{ad}"]), ("\u{61}\u{2c}\u{308}\u{ad}",
        &["\u{61}", "\u{2c}\u{308}\u{ad}"]), ("\u{61}\u{2c}\u{300}", &["\u{61}", "\u{2c}\u{300}"]),
        ("\u{61}\u{2c}\u{308}\u{300}", &["\u{61}", "\u{2c}\u{308}\u{300}"]),
        ("\u{61}\u{2c}\u{200d}", &["\u{61}", "\u{2c}\u{200d}"]), ("\u{61}\u{2c}\u{308}\u{200d}",
        &["\u{61}", "\u{2c}\u{308}\u{200d}"]), ("\u{61}\u{2c}\u{61}\u{2060}", &["\u{61}", "\u{2c}",
        "\u{61}\u{2060}"]), ("\u{61}\u{2c}\u{308}\u{61}\u{2060}", &["\u{61}", "\u{2c}\u{308}",
        "\u{61}\u{2060}"]), ("\u{61}\u{2c}\u{61}\u{3a}", &["\u{61}", "\u{2c}", "\u{61}", "\u{3a}"]),
        ("\u{61}\u{2c}\u{308}\u{61}\u{3a}", &["\u{61}", "\u{2c}\u{308}", "\u{61}", "\u{3a}"]),
        ("\u{61}\u{2c}\u{61}\u{27}", &["\u{61}", "\u{2c}", "\u{61}", "\u{27}"]),
        ("\u{61}\u{2c}\u{308}\u{61}\u{27}", &["\u{61}", "\u{2c}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{61}\u{2c}\u{61}\u{27}\u{2060}", &["\u{61}", "\u{2c}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{61}\u{2c}\u{308}\u{61}\u{27}\u{2060}", &["\u{61}", "\u{2c}\u{308}", "\u{61}",
        "\u{27}\u{2060}"]), ("\u{61}\u{2c}\u{61}\u{2c}", &["\u{61}", "\u{2c}", "\u{61}", "\u{2c}"]),
        ("\u{61}\u{2c}\u{308}\u{61}\u{2c}", &["\u{61}", "\u{2c}\u{308}", "\u{61}", "\u{2c}"]),
        ("\u{61}\u{2c}\u{31}\u{3a}", &["\u{61}", "\u{2c}", "\u{31}", "\u{3a}"]),
        ("\u{61}\u{2c}\u{308}\u{31}\u{3a}", &["\u{61}", "\u{2c}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{61}\u{2c}\u{31}\u{27}", &["\u{61}", "\u{2c}", "\u{31}", "\u{27}"]),
        ("\u{61}\u{2c}\u{308}\u{31}\u{27}", &["\u{61}", "\u{2c}\u{308}", "\u{31}", "\u{27}"]),
        ("\u{61}\u{2c}\u{31}\u{2c}", &["\u{61}", "\u{2c}", "\u{31}", "\u{2c}"]),
        ("\u{61}\u{2c}\u{308}\u{31}\u{2c}", &["\u{61}", "\u{2c}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{61}\u{2c}\u{31}\u{2e}\u{2060}", &["\u{61}", "\u{2c}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{61}\u{2c}\u{308}\u{31}\u{2e}\u{2060}", &["\u{61}", "\u{2c}\u{308}", "\u{31}",
        "\u{2e}\u{2060}"]), ("\u{31}\u{3a}\u{1}", &["\u{31}", "\u{3a}", "\u{1}"]),
        ("\u{31}\u{3a}\u{308}\u{1}", &["\u{31}", "\u{3a}\u{308}", "\u{1}"]), ("\u{31}\u{3a}\u{d}",
        &["\u{31}", "\u{3a}", "\u{d}"]), ("\u{31}\u{3a}\u{308}\u{d}", &["\u{31}", "\u{3a}\u{308}",
        "\u{d}"]), ("\u{31}\u{3a}\u{a}", &["\u{31}", "\u{3a}", "\u{a}"]),
        ("\u{31}\u{3a}\u{308}\u{a}", &["\u{31}", "\u{3a}\u{308}", "\u{a}"]), ("\u{31}\u{3a}\u{b}",
        &["\u{31}", "\u{3a}", "\u{b}"]), ("\u{31}\u{3a}\u{308}\u{b}", &["\u{31}", "\u{3a}\u{308}",
        "\u{b}"]), ("\u{31}\u{3a}\u{3031}", &["\u{31}", "\u{3a}", "\u{3031}"]),
        ("\u{31}\u{3a}\u{308}\u{3031}", &["\u{31}", "\u{3a}\u{308}", "\u{3031}"]),
        ("\u{31}\u{3a}\u{41}", &["\u{31}", "\u{3a}", "\u{41}"]), ("\u{31}\u{3a}\u{308}\u{41}",
        &["\u{31}", "\u{3a}\u{308}", "\u{41}"]), ("\u{31}\u{3a}\u{3a}", &["\u{31}", "\u{3a}",
        "\u{3a}"]), ("\u{31}\u{3a}\u{308}\u{3a}", &["\u{31}", "\u{3a}\u{308}", "\u{3a}"]),
        ("\u{31}\u{3a}\u{2c}", &["\u{31}", "\u{3a}", "\u{2c}"]), ("\u{31}\u{3a}\u{308}\u{2c}",
        &["\u{31}", "\u{3a}\u{308}", "\u{2c}"]), ("\u{31}\u{3a}\u{2e}", &["\u{31}", "\u{3a}",
        "\u{2e}"]), ("\u{31}\u{3a}\u{308}\u{2e}", &["\u{31}", "\u{3a}\u{308}", "\u{2e}"]),
        ("\u{31}\u{3a}\u{30}", &["\u{31}", "\u{3a}", "\u{30}"]), ("\u{31}\u{3a}\u{308}\u{30}",
        &["\u{31}", "\u{3a}\u{308}", "\u{30}"]), ("\u{31}\u{3a}\u{5f}", &["\u{31}", "\u{3a}",
        "\u{5f}"]), ("\u{31}\u{3a}\u{308}\u{5f}", &["\u{31}", "\u{3a}\u{308}", "\u{5f}"]),
        ("\u{31}\u{3a}\u{1f1e6}", &["\u{31}", "\u{3a}", "\u{1f1e6}"]),
        ("\u{31}\u{3a}\u{308}\u{1f1e6}", &["\u{31}", "\u{3a}\u{308}", "\u{1f1e6}"]),
        ("\u{31}\u{3a}\u{5d0}", &["\u{31}", "\u{3a}", "\u{5d0}"]), ("\u{31}\u{3a}\u{308}\u{5d0}",
        &["\u{31}", "\u{3a}\u{308}", "\u{5d0}"]), ("\u{31}\u{3a}\u{22}", &["\u{31}", "\u{3a}",
        "\u{22}"]), ("\u{31}\u{3a}\u{308}\u{22}", &["\u{31}", "\u{3a}\u{308}", "\u{22}"]),
        ("\u{31}\u{3a}\u{27}", &["\u{31}", "\u{3a}", "\u{27}"]), ("\u{31}\u{3a}\u{308}\u{27}",
        &["\u{31}", "\u{3a}\u{308}", "\u{27}"]), ("\u{31}\u{3a}\u{261d}", &["\u{31}", "\u{3a}",
        "\u{261d}"]), ("\u{31}\u{3a}\u{308}\u{261d}", &["\u{31}", "\u{3a}\u{308}", "\u{261d}"]),
        ("\u{31}\u{3a}\u{1f3fb}", &["\u{31}", "\u{3a}", "\u{1f3fb}"]),
        ("\u{31}\u{3a}\u{308}\u{1f3fb}", &["\u{31}", "\u{3a}\u{308}", "\u{1f3fb}"]),
        ("\u{31}\u{3a}\u{2764}", &["\u{31}", "\u{3a}", "\u{2764}"]), ("\u{31}\u{3a}\u{308}\u{2764}",
        &["\u{31}", "\u{3a}\u{308}", "\u{2764}"]), ("\u{31}\u{3a}\u{1f466}", &["\u{31}", "\u{3a}",
        "\u{1f466}"]), ("\u{31}\u{3a}\u{308}\u{1f466}", &["\u{31}", "\u{3a}\u{308}", "\u{1f466}"]),
        ("\u{31}\u{3a}\u{ad}", &["\u{31}", "\u{3a}\u{ad}"]), ("\u{31}\u{3a}\u{308}\u{ad}",
        &["\u{31}", "\u{3a}\u{308}\u{ad}"]), ("\u{31}\u{3a}\u{300}", &["\u{31}", "\u{3a}\u{300}"]),
        ("\u{31}\u{3a}\u{308}\u{300}", &["\u{31}", "\u{3a}\u{308}\u{300}"]),
        ("\u{31}\u{3a}\u{200d}", &["\u{31}", "\u{3a}\u{200d}"]), ("\u{31}\u{3a}\u{308}\u{200d}",
        &["\u{31}", "\u{3a}\u{308}\u{200d}"]), ("\u{31}\u{3a}\u{61}\u{2060}", &["\u{31}", "\u{3a}",
        "\u{61}\u{2060}"]), ("\u{31}\u{3a}\u{308}\u{61}\u{2060}", &["\u{31}", "\u{3a}\u{308}",
        "\u{61}\u{2060}"]), ("\u{31}\u{3a}\u{61}\u{3a}", &["\u{31}", "\u{3a}", "\u{61}", "\u{3a}"]),
        ("\u{31}\u{3a}\u{308}\u{61}\u{3a}", &["\u{31}", "\u{3a}\u{308}", "\u{61}", "\u{3a}"]),
        ("\u{31}\u{3a}\u{61}\u{27}", &["\u{31}", "\u{3a}", "\u{61}", "\u{27}"]),
        ("\u{31}\u{3a}\u{308}\u{61}\u{27}", &["\u{31}", "\u{3a}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{31}\u{3a}\u{61}\u{27}\u{2060}", &["\u{31}", "\u{3a}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{31}\u{3a}\u{308}\u{61}\u{27}\u{2060}", &["\u{31}", "\u{3a}\u{308}", "\u{61}",
        "\u{27}\u{2060}"]), ("\u{31}\u{3a}\u{61}\u{2c}", &["\u{31}", "\u{3a}", "\u{61}", "\u{2c}"]),
        ("\u{31}\u{3a}\u{308}\u{61}\u{2c}", &["\u{31}", "\u{3a}\u{308}", "\u{61}", "\u{2c}"]),
        ("\u{31}\u{3a}\u{31}\u{3a}", &["\u{31}", "\u{3a}", "\u{31}", "\u{3a}"]),
        ("\u{31}\u{3a}\u{308}\u{31}\u{3a}", &["\u{31}", "\u{3a}\u{308}", "\u{31}", "\u{3a}"]),
        ("\u{31}\u{3a}\u{31}\u{27}", &["\u{31}", "\u{3a}", "\u{31}", "\u{27}"]),
        ("\u{31}\u{3a}\u{308}\u{31}\u{27}", &["\u{31}", "\u{3a}\u{308}", "\u{31}", "\u{27}"]),
        ("\u{31}\u{3a}\u{31}\u{2c}", &["\u{31}", "\u{3a}", "\u{31}", "\u{2c}"]),
        ("\u{31}\u{3a}\u{308}\u{31}\u{2c}", &["\u{31}", "\u{3a}\u{308}", "\u{31}", "\u{2c}"]),
        ("\u{31}\u{3a}\u{31}\u{2e}\u{2060}", &["\u{31}", "\u{3a}", "\u{31}", "\u{2e}\u{2060}"]),
        ("\u{31}\u{3a}\u{308}\u{31}\u{2e}\u{2060}", &["\u{31}", "\u{3a}\u{308}", "\u{31}",
        "\u{2e}\u{2060}"]), ("\u{31}\u{27}\u{1}", &["\u{31}", "\u{27}", "\u{1}"]),
        ("\u{31}\u{27}\u{308}\u{1}", &["\u{31}", "\u{27}\u{308}", "\u{1}"]), ("\u{31}\u{27}\u{d}",
        &["\u{31}", "\u{27}", "\u{d}"]), ("\u{31}\u{27}\u{308}\u{d}", &["\u{31}", "\u{27}\u{308}",
        "\u{d}"]), ("\u{31}\u{27}\u{a}", &["\u{31}", "\u{27}", "\u{a}"]),
        ("\u{31}\u{27}\u{308}\u{a}", &["\u{31}", "\u{27}\u{308}", "\u{a}"]), ("\u{31}\u{27}\u{b}",
        &["\u{31}", "\u{27}", "\u{b}"]), ("\u{31}\u{27}\u{308}\u{b}", &["\u{31}", "\u{27}\u{308}",
        "\u{b}"]), ("\u{31}\u{27}\u{3031}", &["\u{31}", "\u{27}", "\u{3031}"]),
        ("\u{31}\u{27}\u{308}\u{3031}", &["\u{31}", "\u{27}\u{308}", "\u{3031}"]),
        ("\u{31}\u{27}\u{41}", &["\u{31}", "\u{27}", "\u{41}"]), ("\u{31}\u{27}\u{308}\u{41}",
        &["\u{31}", "\u{27}\u{308}", "\u{41}"]), ("\u{31}\u{27}\u{3a}", &["\u{31}", "\u{27}",
        "\u{3a}"]), ("\u{31}\u{27}\u{308}\u{3a}", &["\u{31}", "\u{27}\u{308}", "\u{3a}"]),
        ("\u{31}\u{27}\u{2c}", &["\u{31}", "\u{27}", "\u{2c}"]), ("\u{31}\u{27}\u{308}\u{2c}",
        &["\u{31}", "\u{27}\u{308}", "\u{2c}"]), ("\u{31}\u{27}\u{2e}", &["\u{31}", "\u{27}",
        "\u{2e}"]), ("\u{31}\u{27}\u{308}\u{2e}", &["\u{31}", "\u{27}\u{308}", "\u{2e}"]),
        ("\u{31}\u{27}\u{30}", &["\u{31}\u{27}\u{30}"]), ("\u{31}\u{27}\u{308}\u{30}",
        &["\u{31}\u{27}\u{308}\u{30}"]), ("\u{31}\u{27}\u{5f}", &["\u{31}", "\u{27}", "\u{5f}"]),
        ("\u{31}\u{27}\u{308}\u{5f}", &["\u{31}", "\u{27}\u{308}", "\u{5f}"]),
        ("\u{31}\u{27}\u{1f1e6}", &["\u{31}", "\u{27}", "\u{1f1e6}"]),
        ("\u{31}\u{27}\u{308}\u{1f1e6}", &["\u{31}", "\u{27}\u{308}", "\u{1f1e6}"]),
        ("\u{31}\u{27}\u{5d0}", &["\u{31}", "\u{27}", "\u{5d0}"]), ("\u{31}\u{27}\u{308}\u{5d0}",
        &["\u{31}", "\u{27}\u{308}", "\u{5d0}"]), ("\u{31}\u{27}\u{22}", &["\u{31}", "\u{27}",
        "\u{22}"]), ("\u{31}\u{27}\u{308}\u{22}", &["\u{31}", "\u{27}\u{308}", "\u{22}"]),
        ("\u{31}\u{27}\u{27}", &["\u{31}", "\u{27}", "\u{27}"]), ("\u{31}\u{27}\u{308}\u{27}",
        &["\u{31}", "\u{27}\u{308}", "\u{27}"]), ("\u{31}\u{27}\u{261d}", &["\u{31}", "\u{27}",
        "\u{261d}"]), ("\u{31}\u{27}\u{308}\u{261d}", &["\u{31}", "\u{27}\u{308}", "\u{261d}"]),
        ("\u{31}\u{27}\u{1f3fb}", &["\u{31}", "\u{27}", "\u{1f3fb}"]),
        ("\u{31}\u{27}\u{308}\u{1f3fb}", &["\u{31}", "\u{27}\u{308}", "\u{1f3fb}"]),
        ("\u{31}\u{27}\u{2764}", &["\u{31}", "\u{27}", "\u{2764}"]), ("\u{31}\u{27}\u{308}\u{2764}",
        &["\u{31}", "\u{27}\u{308}", "\u{2764}"]), ("\u{31}\u{27}\u{1f466}", &["\u{31}", "\u{27}",
        "\u{1f466}"]), ("\u{31}\u{27}\u{308}\u{1f466}", &["\u{31}", "\u{27}\u{308}", "\u{1f466}"]),
        ("\u{31}\u{27}\u{ad}", &["\u{31}", "\u{27}\u{ad}"]), ("\u{31}\u{27}\u{308}\u{ad}",
        &["\u{31}", "\u{27}\u{308}\u{ad}"]), ("\u{31}\u{27}\u{300}", &["\u{31}", "\u{27}\u{300}"]),
        ("\u{31}\u{27}\u{308}\u{300}", &["\u{31}", "\u{27}\u{308}\u{300}"]),
        ("\u{31}\u{27}\u{200d}", &["\u{31}", "\u{27}\u{200d}"]), ("\u{31}\u{27}\u{308}\u{200d}",
        &["\u{31}", "\u{27}\u{308}\u{200d}"]), ("\u{31}\u{27}\u{61}\u{2060}", &["\u{31}", "\u{27}",
        "\u{61}\u{2060}"]), ("\u{31}\u{27}\u{308}\u{61}\u{2060}", &["\u{31}", "\u{27}\u{308}",
        "\u{61}\u{2060}"]), ("\u{31}\u{27}\u{61}\u{3a}", &["\u{31}", "\u{27}", "\u{61}", "\u{3a}"]),
        ("\u{31}\u{27}\u{308}\u{61}\u{3a}", &["\u{31}", "\u{27}\u{308}", "\u{61}", "\u{3a}"]),
        ("\u{31}\u{27}\u{61}\u{27}", &["\u{31}", "\u{27}", "\u{61}", "\u{27}"]),
        ("\u{31}\u{27}\u{308}\u{61}\u{27}", &["\u{31}", "\u{27}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{31}\u{27}\u{61}\u{27}\u{2060}", &["\u{31}", "\u{27}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{31}\u{27}\u{308}\u{61}\u{27}\u{2060}", &["\u{31}", "\u{27}\u{308}", "\u{61}",
        "\u{27}\u{2060}"]), ("\u{31}\u{27}\u{61}\u{2c}", &["\u{31}", "\u{27}", "\u{61}", "\u{2c}"]),
        ("\u{31}\u{27}\u{308}\u{61}\u{2c}", &["\u{31}", "\u{27}\u{308}", "\u{61}", "\u{2c}"]),
        ("\u{31}\u{27}\u{31}\u{3a}", &["\u{31}\u{27}\u{31}", "\u{3a}"]),
        ("\u{31}\u{27}\u{308}\u{31}\u{3a}", &["\u{31}\u{27}\u{308}\u{31}", "\u{3a}"]),
        ("\u{31}\u{27}\u{31}\u{27}", &["\u{31}\u{27}\u{31}", "\u{27}"]),
        ("\u{31}\u{27}\u{308}\u{31}\u{27}", &["\u{31}\u{27}\u{308}\u{31}", "\u{27}"]),
        ("\u{31}\u{27}\u{31}\u{2c}", &["\u{31}\u{27}\u{31}", "\u{2c}"]),
        ("\u{31}\u{27}\u{308}\u{31}\u{2c}", &["\u{31}\u{27}\u{308}\u{31}", "\u{2c}"]),
        ("\u{31}\u{27}\u{31}\u{2e}\u{2060}", &["\u{31}\u{27}\u{31}", "\u{2e}\u{2060}"]),
        ("\u{31}\u{27}\u{308}\u{31}\u{2e}\u{2060}", &["\u{31}\u{27}\u{308}\u{31}",
        "\u{2e}\u{2060}"]), ("\u{31}\u{2c}\u{1}", &["\u{31}", "\u{2c}", "\u{1}"]),
        ("\u{31}\u{2c}\u{308}\u{1}", &["\u{31}", "\u{2c}\u{308}", "\u{1}"]), ("\u{31}\u{2c}\u{d}",
        &["\u{31}", "\u{2c}", "\u{d}"]), ("\u{31}\u{2c}\u{308}\u{d}", &["\u{31}", "\u{2c}\u{308}",
        "\u{d}"]), ("\u{31}\u{2c}\u{a}", &["\u{31}", "\u{2c}", "\u{a}"]),
        ("\u{31}\u{2c}\u{308}\u{a}", &["\u{31}", "\u{2c}\u{308}", "\u{a}"]), ("\u{31}\u{2c}\u{b}",
        &["\u{31}", "\u{2c}", "\u{b}"]), ("\u{31}\u{2c}\u{308}\u{b}", &["\u{31}", "\u{2c}\u{308}",
        "\u{b}"]), ("\u{31}\u{2c}\u{3031}", &["\u{31}", "\u{2c}", "\u{3031}"]),
        ("\u{31}\u{2c}\u{308}\u{3031}", &["\u{31}", "\u{2c}\u{308}", "\u{3031}"]),
        ("\u{31}\u{2c}\u{41}", &["\u{31}", "\u{2c}", "\u{41}"]), ("\u{31}\u{2c}\u{308}\u{41}",
        &["\u{31}", "\u{2c}\u{308}", "\u{41}"]), ("\u{31}\u{2c}\u{3a}", &["\u{31}", "\u{2c}",
        "\u{3a}"]), ("\u{31}\u{2c}\u{308}\u{3a}", &["\u{31}", "\u{2c}\u{308}", "\u{3a}"]),
        ("\u{31}\u{2c}\u{2c}", &["\u{31}", "\u{2c}", "\u{2c}"]), ("\u{31}\u{2c}\u{308}\u{2c}",
        &["\u{31}", "\u{2c}\u{308}", "\u{2c}"]), ("\u{31}\u{2c}\u{2e}", &["\u{31}", "\u{2c}",
        "\u{2e}"]), ("\u{31}\u{2c}\u{308}\u{2e}", &["\u{31}", "\u{2c}\u{308}", "\u{2e}"]),
        ("\u{31}\u{2c}\u{30}", &["\u{31}\u{2c}\u{30}"]), ("\u{31}\u{2c}\u{308}\u{30}",
        &["\u{31}\u{2c}\u{308}\u{30}"]), ("\u{31}\u{2c}\u{5f}", &["\u{31}", "\u{2c}", "\u{5f}"]),
        ("\u{31}\u{2c}\u{308}\u{5f}", &["\u{31}", "\u{2c}\u{308}", "\u{5f}"]),
        ("\u{31}\u{2c}\u{1f1e6}", &["\u{31}", "\u{2c}", "\u{1f1e6}"]),
        ("\u{31}\u{2c}\u{308}\u{1f1e6}", &["\u{31}", "\u{2c}\u{308}", "\u{1f1e6}"]),
        ("\u{31}\u{2c}\u{5d0}", &["\u{31}", "\u{2c}", "\u{5d0}"]), ("\u{31}\u{2c}\u{308}\u{5d0}",
        &["\u{31}", "\u{2c}\u{308}", "\u{5d0}"]), ("\u{31}\u{2c}\u{22}", &["\u{31}", "\u{2c}",
        "\u{22}"]), ("\u{31}\u{2c}\u{308}\u{22}", &["\u{31}", "\u{2c}\u{308}", "\u{22}"]),
        ("\u{31}\u{2c}\u{27}", &["\u{31}", "\u{2c}", "\u{27}"]), ("\u{31}\u{2c}\u{308}\u{27}",
        &["\u{31}", "\u{2c}\u{308}", "\u{27}"]), ("\u{31}\u{2c}\u{261d}", &["\u{31}", "\u{2c}",
        "\u{261d}"]), ("\u{31}\u{2c}\u{308}\u{261d}", &["\u{31}", "\u{2c}\u{308}", "\u{261d}"]),
        ("\u{31}\u{2c}\u{1f3fb}", &["\u{31}", "\u{2c}", "\u{1f3fb}"]),
        ("\u{31}\u{2c}\u{308}\u{1f3fb}", &["\u{31}", "\u{2c}\u{308}", "\u{1f3fb}"]),
        ("\u{31}\u{2c}\u{2764}", &["\u{31}", "\u{2c}", "\u{2764}"]), ("\u{31}\u{2c}\u{308}\u{2764}",
        &["\u{31}", "\u{2c}\u{308}", "\u{2764}"]), ("\u{31}\u{2c}\u{1f466}", &["\u{31}", "\u{2c}",
        "\u{1f466}"]), ("\u{31}\u{2c}\u{308}\u{1f466}", &["\u{31}", "\u{2c}\u{308}", "\u{1f466}"]),
        ("\u{31}\u{2c}\u{ad}", &["\u{31}", "\u{2c}\u{ad}"]), ("\u{31}\u{2c}\u{308}\u{ad}",
        &["\u{31}", "\u{2c}\u{308}\u{ad}"]), ("\u{31}\u{2c}\u{300}", &["\u{31}", "\u{2c}\u{300}"]),
        ("\u{31}\u{2c}\u{308}\u{300}", &["\u{31}", "\u{2c}\u{308}\u{300}"]),
        ("\u{31}\u{2c}\u{200d}", &["\u{31}", "\u{2c}\u{200d}"]), ("\u{31}\u{2c}\u{308}\u{200d}",
        &["\u{31}", "\u{2c}\u{308}\u{200d}"]), ("\u{31}\u{2c}\u{61}\u{2060}", &["\u{31}", "\u{2c}",
        "\u{61}\u{2060}"]), ("\u{31}\u{2c}\u{308}\u{61}\u{2060}", &["\u{31}", "\u{2c}\u{308}",
        "\u{61}\u{2060}"]), ("\u{31}\u{2c}\u{61}\u{3a}", &["\u{31}", "\u{2c}", "\u{61}", "\u{3a}"]),
        ("\u{31}\u{2c}\u{308}\u{61}\u{3a}", &["\u{31}", "\u{2c}\u{308}", "\u{61}", "\u{3a}"]),
        ("\u{31}\u{2c}\u{61}\u{27}", &["\u{31}", "\u{2c}", "\u{61}", "\u{27}"]),
        ("\u{31}\u{2c}\u{308}\u{61}\u{27}", &["\u{31}", "\u{2c}\u{308}", "\u{61}", "\u{27}"]),
        ("\u{31}\u{2c}\u{61}\u{27}\u{2060}", &["\u{31}", "\u{2c}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{31}\u{2c}\u{308}\u{61}\u{27}\u{2060}", &["\u{31}", "\u{2c}\u{308}", "\u{61}",
        "\u{27}\u{2060}"]), ("\u{31}\u{2c}\u{61}\u{2c}", &["\u{31}", "\u{2c}", "\u{61}", "\u{2c}"]),
        ("\u{31}\u{2c}\u{308}\u{61}\u{2c}", &["\u{31}", "\u{2c}\u{308}", "\u{61}", "\u{2c}"]),
        ("\u{31}\u{2c}\u{31}\u{3a}", &["\u{31}\u{2c}\u{31}", "\u{3a}"]),
        ("\u{31}\u{2c}\u{308}\u{31}\u{3a}", &["\u{31}\u{2c}\u{308}\u{31}", "\u{3a}"]),
        ("\u{31}\u{2c}\u{31}\u{27}", &["\u{31}\u{2c}\u{31}", "\u{27}"]),
        ("\u{31}\u{2c}\u{308}\u{31}\u{27}", &["\u{31}\u{2c}\u{308}\u{31}", "\u{27}"]),
        ("\u{31}\u{2c}\u{31}\u{2c}", &["\u{31}\u{2c}\u{31}", "\u{2c}"]),
        ("\u{31}\u{2c}\u{308}\u{31}\u{2c}", &["\u{31}\u{2c}\u{308}\u{31}", "\u{2c}"]),
        ("\u{31}\u{2c}\u{31}\u{2e}\u{2060}", &["\u{31}\u{2c}\u{31}", "\u{2e}\u{2060}"]),
        ("\u{31}\u{2c}\u{308}\u{31}\u{2e}\u{2060}", &["\u{31}\u{2c}\u{308}\u{31}",
        "\u{2e}\u{2060}"]), ("\u{31}\u{2e}\u{2060}\u{1}", &["\u{31}", "\u{2e}\u{2060}", "\u{1}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{1}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{1}"]),
        ("\u{31}\u{2e}\u{2060}\u{d}", &["\u{31}", "\u{2e}\u{2060}", "\u{d}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{d}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{d}"]),
        ("\u{31}\u{2e}\u{2060}\u{a}", &["\u{31}", "\u{2e}\u{2060}", "\u{a}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{a}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{a}"]),
        ("\u{31}\u{2e}\u{2060}\u{b}", &["\u{31}", "\u{2e}\u{2060}", "\u{b}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{b}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{b}"]),
        ("\u{31}\u{2e}\u{2060}\u{3031}", &["\u{31}", "\u{2e}\u{2060}", "\u{3031}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{3031}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{3031}"]),
        ("\u{31}\u{2e}\u{2060}\u{41}", &["\u{31}", "\u{2e}\u{2060}", "\u{41}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{41}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{41}"]),
        ("\u{31}\u{2e}\u{2060}\u{3a}", &["\u{31}", "\u{2e}\u{2060}", "\u{3a}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{3a}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{3a}"]),
        ("\u{31}\u{2e}\u{2060}\u{2c}", &["\u{31}", "\u{2e}\u{2060}", "\u{2c}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{2c}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{2c}"]),
        ("\u{31}\u{2e}\u{2060}\u{2e}", &["\u{31}", "\u{2e}\u{2060}", "\u{2e}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{2e}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{2e}"]),
        ("\u{31}\u{2e}\u{2060}\u{30}", &["\u{31}\u{2e}\u{2060}\u{30}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{30}", &["\u{31}\u{2e}\u{2060}\u{308}\u{30}"]),
        ("\u{31}\u{2e}\u{2060}\u{5f}", &["\u{31}", "\u{2e}\u{2060}", "\u{5f}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{5f}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{5f}"]),
        ("\u{31}\u{2e}\u{2060}\u{1f1e6}", &["\u{31}", "\u{2e}\u{2060}", "\u{1f1e6}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{1f1e6}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{1f1e6}"]),
        ("\u{31}\u{2e}\u{2060}\u{5d0}", &["\u{31}", "\u{2e}\u{2060}", "\u{5d0}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{5d0}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{5d0}"]),
        ("\u{31}\u{2e}\u{2060}\u{22}", &["\u{31}", "\u{2e}\u{2060}", "\u{22}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{22}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{22}"]),
        ("\u{31}\u{2e}\u{2060}\u{27}", &["\u{31}", "\u{2e}\u{2060}", "\u{27}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{27}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{27}"]),
        ("\u{31}\u{2e}\u{2060}\u{261d}", &["\u{31}", "\u{2e}\u{2060}", "\u{261d}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{261d}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{261d}"]),
        ("\u{31}\u{2e}\u{2060}\u{1f3fb}", &["\u{31}", "\u{2e}\u{2060}", "\u{1f3fb}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{1f3fb}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{1f3fb}"]),
        ("\u{31}\u{2e}\u{2060}\u{2764}", &["\u{31}", "\u{2e}\u{2060}", "\u{2764}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{2764}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{2764}"]),
        ("\u{31}\u{2e}\u{2060}\u{1f466}", &["\u{31}", "\u{2e}\u{2060}", "\u{1f466}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{1f466}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{1f466}"]),
        ("\u{31}\u{2e}\u{2060}\u{ad}", &["\u{31}", "\u{2e}\u{2060}\u{ad}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{ad}", &["\u{31}", "\u{2e}\u{2060}\u{308}\u{ad}"]),
        ("\u{31}\u{2e}\u{2060}\u{300}", &["\u{31}", "\u{2e}\u{2060}\u{300}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{300}", &["\u{31}", "\u{2e}\u{2060}\u{308}\u{300}"]),
        ("\u{31}\u{2e}\u{2060}\u{200d}", &["\u{31}", "\u{2e}\u{2060}\u{200d}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{200d}", &["\u{31}", "\u{2e}\u{2060}\u{308}\u{200d}"]),
        ("\u{31}\u{2e}\u{2060}\u{61}\u{2060}", &["\u{31}", "\u{2e}\u{2060}", "\u{61}\u{2060}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{61}\u{2060}", &["\u{31}", "\u{2e}\u{2060}\u{308}",
        "\u{61}\u{2060}"]), ("\u{31}\u{2e}\u{2060}\u{61}\u{3a}", &["\u{31}", "\u{2e}\u{2060}",
        "\u{61}", "\u{3a}"]), ("\u{31}\u{2e}\u{2060}\u{308}\u{61}\u{3a}", &["\u{31}",
        "\u{2e}\u{2060}\u{308}", "\u{61}", "\u{3a}"]), ("\u{31}\u{2e}\u{2060}\u{61}\u{27}",
        &["\u{31}", "\u{2e}\u{2060}", "\u{61}", "\u{27}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{61}\u{27}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{61}",
        "\u{27}"]), ("\u{31}\u{2e}\u{2060}\u{61}\u{27}\u{2060}", &["\u{31}", "\u{2e}\u{2060}",
        "\u{61}", "\u{27}\u{2060}"]), ("\u{31}\u{2e}\u{2060}\u{308}\u{61}\u{27}\u{2060}",
        &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{61}", "\u{27}\u{2060}"]),
        ("\u{31}\u{2e}\u{2060}\u{61}\u{2c}", &["\u{31}", "\u{2e}\u{2060}", "\u{61}", "\u{2c}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{61}\u{2c}", &["\u{31}", "\u{2e}\u{2060}\u{308}", "\u{61}",
        "\u{2c}"]), ("\u{31}\u{2e}\u{2060}\u{31}\u{3a}", &["\u{31}\u{2e}\u{2060}\u{31}", "\u{3a}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{31}\u{3a}", &["\u{31}\u{2e}\u{2060}\u{308}\u{31}",
        "\u{3a}"]), ("\u{31}\u{2e}\u{2060}\u{31}\u{27}", &["\u{31}\u{2e}\u{2060}\u{31}", "\u{27}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{31}\u{27}", &["\u{31}\u{2e}\u{2060}\u{308}\u{31}",
        "\u{27}"]), ("\u{31}\u{2e}\u{2060}\u{31}\u{2c}", &["\u{31}\u{2e}\u{2060}\u{31}", "\u{2c}"]),
        ("\u{31}\u{2e}\u{2060}\u{308}\u{31}\u{2c}", &["\u{31}\u{2e}\u{2060}\u{308}\u{31}",
        "\u{2c}"]), ("\u{31}\u{2e}\u{2060}\u{31}\u{2e}\u{2060}", &["\u{31}\u{2e}\u{2060}\u{31}",
        "\u{2e}\u{2060}"]), ("\u{31}\u{2e}\u{2060}\u{308}\u{31}\u{2e}\u{2060}",
        &["\u{31}\u{2e}\u{2060}\u{308}\u{31}", "\u{2e}\u{2060}"]), ("\u{d}\u{a}\u{61}\u{a}\u{308}",
        &["\u{d}\u{a}", "\u{61}", "\u{a}", "\u{308}"]), ("\u{61}\u{308}", &["\u{61}\u{308}"]),
        ("\u{20}\u{200d}\u{646}", &["\u{20}\u{200d}", "\u{646}"]), ("\u{646}\u{200d}\u{20}",
        &["\u{646}\u{200d}", "\u{20}"]), ("\u{41}\u{41}\u{41}", &["\u{41}\u{41}\u{41}"]),
        ("\u{41}\u{3a}\u{41}", &["\u{41}\u{3a}\u{41}"]), ("\u{41}\u{3a}\u{3a}\u{41}", &["\u{41}",
        "\u{3a}", "\u{3a}", "\u{41}"]), ("\u{5d0}\u{27}", &["\u{5d0}\u{27}"]),
        ("\u{5d0}\u{22}\u{5d0}", &["\u{5d0}\u{22}\u{5d0}"]), ("\u{41}\u{30}\u{30}\u{41}",
        &["\u{41}\u{30}\u{30}\u{41}"]), ("\u{30}\u{2c}\u{30}", &["\u{30}\u{2c}\u{30}"]),
        ("\u{30}\u{2c}\u{2c}\u{30}", &["\u{30}", "\u{2c}", "\u{2c}", "\u{30}"]),
        ("\u{3031}\u{3031}", &["\u{3031}\u{3031}"]), ("\u{41}\u{5f}\u{30}\u{5f}\u{3031}\u{5f}",
        &["\u{41}\u{5f}\u{30}\u{5f}\u{3031}\u{5f}"]), ("\u{41}\u{5f}\u{5f}\u{41}",
        &["\u{41}\u{5f}\u{5f}\u{41}"]), ("\u{1f1e6}\u{1f1e7}\u{1f1e8}\u{62}",
        &["\u{1f1e6}\u{1f1e7}", "\u{1f1e8}", "\u{62}"]), ("\u{61}\u{1f1e6}\u{1f1e7}\u{1f1e8}\u{62}",
        &["\u{61}", "\u{1f1e6}\u{1f1e7}", "\u{1f1e8}", "\u{62}"]),
        ("\u{61}\u{1f1e6}\u{1f1e7}\u{200d}\u{1f1e8}\u{62}", &["\u{61}",
        "\u{1f1e6}\u{1f1e7}\u{200d}", "\u{1f1e8}", "\u{62}"]),
        ("\u{61}\u{1f1e6}\u{200d}\u{1f1e7}\u{1f1e8}\u{62}", &["\u{61}",
        "\u{1f1e6}\u{200d}\u{1f1e7}", "\u{1f1e8}", "\u{62}"]),
        ("\u{61}\u{1f1e6}\u{1f1e7}\u{1f1e8}\u{1f1e9}\u{62}", &["\u{61}", "\u{1f1e6}\u{1f1e7}",
        "\u{1f1e8}\u{1f1e9}", "\u{62}"]), ("\u{261d}\u{1f3fb}\u{261d}", &["\u{261d}\u{1f3fb}",
        "\u{261d}"]), ("\u{1f466}\u{1f3fb}", &["\u{1f466}\u{1f3fb}"]),
        ("\u{200d}\u{1f466}\u{1f3fb}", &["\u{200d}\u{1f466}\u{1f3fb}"]), ("\u{200d}\u{2764}",
        &["\u{200d}\u{2764}"]), ("\u{200d}\u{1f466}", &["\u{200d}\u{1f466}"]),
        ("\u{1f466}\u{1f466}", &["\u{1f466}", "\u{1f466}"]), ("\u{61}\u{308}\u{200d}\u{308}\u{62}",
        &["\u{61}\u{308}\u{200d}\u{308}\u{62}"]), ("\u{31}\u{3a}\u{3a}\u{31}", &["\u{31}", "\u{3a}",
        "\u{3a}", "\u{31}"]), ("\u{31}\u{5f}\u{31}\u{3a}\u{3a}\u{31}", &["\u{31}\u{5f}\u{31}",
        "\u{3a}", "\u{3a}", "\u{31}"]), ("\u{31}\u{5f}\u{61}\u{3a}\u{3a}\u{31}",
        &["\u{31}\u{5f}\u{61}", "\u{3a}", "\u{3a}", "\u{31}"]), ("\u{31}\u{3a}\u{3a}\u{61}",
        &["\u{31}", "\u{3a}", "\u{3a}", "\u{61}"]), ("\u{31}\u{5f}\u{31}\u{3a}\u{3a}\u{61}",
        &["\u{31}\u{5f}\u{31}", "\u{3a}", "\u{3a}", "\u{61}"]),
        ("\u{31}\u{5f}\u{61}\u{3a}\u{3a}\u{61}", &["\u{31}\u{5f}\u{61}", "\u{3a}", "\u{3a}",
        "\u{61}"]), ("\u{31}\u{3a}\u{2e}\u{31}", &["\u{31}", "\u{3a}", "\u{2e}", "\u{31}"]),
        ("\u{31}\u{5f}\u{31}\u{3a}\u{2e}\u{31}", &["\u{31}\u{5f}\u{31}", "\u{3a}", "\u{2e}",
        "\u{31}"]), ("\u{31}\u{5f}\u{61}\u{3a}\u{2e}\u{31}", &["\u{31}\u{5f}\u{61}", "\u{3a}",
        "\u{2e}", "\u{31}"]), ("\u{31}\u{3a}\u{2e}\u{61}", &["\u{31}", "\u{3a}", "\u{2e}",
        "\u{61}"]), ("\u{31}\u{5f}\u{31}\u{3a}\u{2e}\u{61}", &["\u{31}\u{5f}\u{31}", "\u{3a}",
        "\u{2e}", "\u{61}"]), ("\u{31}\u{5f}\u{61}\u{3a}\u{2e}\u{61}", &["\u{31}\u{5f}\u{61}",
        "\u{3a}", "\u{2e}", "\u{61}"]), ("\u{31}\u{3a}\u{2c}\u{31}", &["\u{31}", "\u{3a}", "\u{2c}",
        "\u{31}"]), ("\u{31}\u{5f}\u{31}\u{3a}\u{2c}\u{31}", &["\u{31}\u{5f}\u{31}", "\u{3a}",
        "\u{2c}", "\u{31}"]), ("\u{31}\u{5f}\u{61}\u{3a}\u{2c}\u{31}", &["\u{31}\u{5f}\u{61}",
        "\u{3a}", "\u{2c}", "\u{31}"]), ("\u{31}\u{3a}\u{2c}\u{61}", &["\u{31}", "\u{3a}", "\u{2c}",
        "\u{61}"]), ("\u{31}\u{5f}\u{31}\u{3a}\u{2c}\u{61}", &["\u{31}\u{5f}\u{31}", "\u{3a}",
        "\u{2c}", "\u{61}"]), ("\u{31}\u{5f}\u{61}\u{3a}\u{2c}\u{61}", &["\u{31}\u{5f}\u{61}",
        "\u{3a}", "\u{2c}", "\u{61}"]), ("\u{31}\u{2e}\u{3a}\u{31}", &["\u{31}", "\u{2e}", "\u{3a}",
        "\u{31}"]), ("\u{31}\u{5f}\u{31}\u{2e}\u{3a}\u{31}", &["\u{31}\u{5f}\u{31}", "\u{2e}",
        "\u{3a}", "\u{31}"]), ("\u{31}\u{5f}\u{61}\u{2e}\u{3a}\u{31}", &["\u{31}\u{5f}\u{61}",
        "\u{2e}", "\u{3a}", "\u{31}"]), ("\u{31}\u{2e}\u{3a}\u{61}", &["\u{31}", "\u{2e}", "\u{3a}",
        "\u{61}"]), ("\u{31}\u{5f}\u{31}\u{2e}\u{3a}\u{61}", &["\u{31}\u{5f}\u{31}", "\u{2e}",
        "\u{3a}", "\u{61}"]), ("\u{31}\u{5f}\u{61}\u{2e}\u{3a}\u{61}", &["\u{31}\u{5f}\u{61}",
        "\u{2e}", "\u{3a}", "\u{61}"]), ("\u{31}\u{2e}\u{2e}\u{31}", &["\u{31}", "\u{2e}", "\u{2e}",
        "\u{31}"]), ("\u{31}\u{5f}\u{31}\u{2e}\u{2e}\u{31}", &["\u{31}\u{5f}\u{31}", "\u{2e}",
        "\u{2e}", "\u{31}"]), ("\u{31}\u{5f}\u{61}\u{2e}\u{2e}\u{31}", &["\u{31}\u{5f}\u{61}",
        "\u{2e}", "\u{2e}", "\u{31}"]), ("\u{31}\u{2e}\u{2e}\u{61}", &["\u{31}", "\u{2e}", "\u{2e}",
        "\u{61}"]), ("\u{31}\u{5f}\u{31}\u{2e}\u{2e}\u{61}", &["\u{31}\u{5f}\u{31}", "\u{2e}",
        "\u{2e}", "\u{61}"]), ("\u{31}\u{5f}\u{61}\u{2e}\u{2e}\u{61}", &["\u{31}\u{5f}\u{61}",
        "\u{2e}", "\u{2e}", "\u{61}"]), ("\u{31}\u{2e}\u{2c}\u{31}", &["\u{31}", "\u{2e}", "\u{2c}",
        "\u{31}"]), ("\u{31}\u{5f}\u{31}\u{2e}\u{2c}\u{31}", &["\u{31}\u{5f}\u{31}", "\u{2e}",
        "\u{2c}", "\u{31}"]), ("\u{31}\u{5f}\u{61}\u{2e}\u{2c}\u{31}", &["\u{31}\u{5f}\u{61}",
        "\u{2e}", "\u{2c}", "\u{31}"]), ("\u{31}\u{2e}\u{2c}\u{61}", &["\u{31}", "\u{2e}", "\u{2c}",
        "\u{61}"]), ("\u{31}\u{5f}\u{31}\u{2e}\u{2c}\u{61}", &["\u{31}\u{5f}\u{31}", "\u{2e}",
        "\u{2c}", "\u{61}"]), ("\u{31}\u{5f}\u{61}\u{2e}\u{2c}\u{61}", &["\u{31}\u{5f}\u{61}",
        "\u{2e}", "\u{2c}", "\u{61}"]), ("\u{31}\u{2c}\u{3a}\u{31}", &["\u{31}", "\u{2c}", "\u{3a}",
        "\u{31}"]), ("\u{31}\u{5f}\u{31}\u{2c}\u{3a}\u{31}", &["\u{31}\u{5f}\u{31}", "\u{2c}",
        "\u{3a}", "\u{31}"]), ("\u{31}\u{5f}\u{61}\u{2c}\u{3a}\u{31}", &["\u{31}\u{5f}\u{61}",
        "\u{2c}", "\u{3a}", "\u{31}"]), ("\u{31}\u{2c}\u{3a}\u{61}", &["\u{31}", "\u{2c}", "\u{3a}",
        "\u{61}"]), ("\u{31}\u{5f}\u{31}\u{2c}\u{3a}\u{61}", &["\u{31}\u{5f}\u{31}", "\u{2c}",
        "\u{3a}", "\u{61}"]), ("\u{31}\u{5f}\u{61}\u{2c}\u{3a}\u{61}", &["\u{31}\u{5f}\u{61}",
        "\u{2c}", "\u{3a}", "\u{61}"]), ("\u{31}\u{2c}\u{2e}\u{31}", &["\u{31}", "\u{2c}", "\u{2e}",
        "\u{31}"]), ("\u{31}\u{5f}\u{31}\u{2c}\u{2e}\u{31}", &["\u{31}\u{5f}\u{31}", "\u{2c}",
        "\u{2e}", "\u{31}"]), ("\u{31}\u{5f}\u{61}\u{2c}\u{2e}\u{31}", &["\u{31}\u{5f}\u{61}",
        "\u{2c}", "\u{2e}", "\u{31}"]), ("\u{31}\u{2c}\u{2e}\u{61}", &["\u{31}", "\u{2c}", "\u{2e}",
        "\u{61}"]), ("\u{31}\u{5f}\u{31}\u{2c}\u{2e}\u{61}", &["\u{31}\u{5f}\u{31}", "\u{2c}",
        "\u{2e}", "\u{61}"]), ("\u{31}\u{5f}\u{61}\u{2c}\u{2e}\u{61}", &["\u{31}\u{5f}\u{61}",
        "\u{2c}", "\u{2e}", "\u{61}"]), ("\u{31}\u{2c}\u{2c}\u{31}", &["\u{31}", "\u{2c}", "\u{2c}",
        "\u{31}"]), ("\u{31}\u{5f}\u{31}\u{2c}\u{2c}\u{31}", &["\u{31}\u{5f}\u{31}", "\u{2c}",
        "\u{2c}", "\u{31}"]), ("\u{31}\u{5f}\u{61}\u{2c}\u{2c}\u{31}", &["\u{31}\u{5f}\u{61}",
        "\u{2c}", "\u{2c}", "\u{31}"]), ("\u{31}\u{2c}\u{2c}\u{61}", &["\u{31}", "\u{2c}", "\u{2c}",
        "\u{61}"]), ("\u{31}\u{5f}\u{31}\u{2c}\u{2c}\u{61}", &["\u{31}\u{5f}\u{31}", "\u{2c}",
        "\u{2c}", "\u{61}"]), ("\u{31}\u{5f}\u{61}\u{2c}\u{2c}\u{61}", &["\u{31}\u{5f}\u{61}",
        "\u{2c}", "\u{2c}", "\u{61}"]), ("\u{61}\u{3a}\u{3a}\u{31}", &["\u{61}", "\u{3a}", "\u{3a}",
        "\u{31}"]), ("\u{61}\u{5f}\u{31}\u{3a}\u{3a}\u{31}", &["\u{61}\u{5f}\u{31}", "\u{3a}",
        "\u{3a}", "\u{31}"]), ("\u{61}\u{5f}\u{61}\u{3a}\u{3a}\u{31}", &["\u{61}\u{5f}\u{61}",
        "\u{3a}", "\u{3a}", "\u{31}"]), ("\u{61}\u{3a}\u{3a}\u{61}", &["\u{61}", "\u{3a}", "\u{3a}",
        "\u{61}"]), ("\u{61}\u{5f}\u{31}\u{3a}\u{3a}\u{61}", &["\u{61}\u{5f}\u{31}", "\u{3a}",
        "\u{3a}", "\u{61}"]), ("\u{61}\u{5f}\u{61}\u{3a}\u{3a}\u{61}", &["\u{61}\u{5f}\u{61}",
        "\u{3a}", "\u{3a}", "\u{61}"]), ("\u{61}\u{3a}\u{2e}\u{31}", &["\u{61}", "\u{3a}", "\u{2e}",
        "\u{31}"]), ("\u{61}\u{5f}\u{31}\u{3a}\u{2e}\u{31}", &["\u{61}\u{5f}\u{31}", "\u{3a}",
        "\u{2e}", "\u{31}"]), ("\u{61}\u{5f}\u{61}\u{3a}\u{2e}\u{31}", &["\u{61}\u{5f}\u{61}",
        "\u{3a}", "\u{2e}", "\u{31}"]), ("\u{61}\u{3a}\u{2e}\u{61}", &["\u{61}", "\u{3a}", "\u{2e}",
        "\u{61}"]), ("\u{61}\u{5f}\u{31}\u{3a}\u{2e}\u{61}", &["\u{61}\u{5f}\u{31}", "\u{3a}",
        "\u{2e}", "\u{61}"]), ("\u{61}\u{5f}\u{61}\u{3a}\u{2e}\u{61}", &["\u{61}\u{5f}\u{61}",
        "\u{3a}", "\u{2e}", "\u{61}"]), ("\u{61}\u{3a}\u{2c}\u{31}", &["\u{61}", "\u{3a}", "\u{2c}",
        "\u{31}"]), ("\u{61}\u{5f}\u{31}\u{3a}\u{2c}\u{31}", &["\u{61}\u{5f}\u{31}", "\u{3a}",
        "\u{2c}", "\u{31}"]), ("\u{61}\u{5f}\u{61}\u{3a}\u{2c}\u{31}", &["\u{61}\u{5f}\u{61}",
        "\u{3a}", "\u{2c}", "\u{31}"]), ("\u{61}\u{3a}\u{2c}\u{61}", &["\u{61}", "\u{3a}", "\u{2c}",
        "\u{61}"]), ("\u{61}\u{5f}\u{31}\u{3a}\u{2c}\u{61}", &["\u{61}\u{5f}\u{31}", "\u{3a}",
        "\u{2c}", "\u{61}"]), ("\u{61}\u{5f}\u{61}\u{3a}\u{2c}\u{61}", &["\u{61}\u{5f}\u{61}",
        "\u{3a}", "\u{2c}", "\u{61}"]), ("\u{61}\u{2e}\u{3a}\u{31}", &["\u{61}", "\u{2e}", "\u{3a}",
        "\u{31}"]), ("\u{61}\u{5f}\u{31}\u{2e}\u{3a}\u{31}", &["\u{61}\u{5f}\u{31}", "\u{2e}",
        "\u{3a}", "\u{31}"]), ("\u{61}\u{5f}\u{61}\u{2e}\u{3a}\u{31}", &["\u{61}\u{5f}\u{61}",
        "\u{2e}", "\u{3a}", "\u{31}"]), ("\u{61}\u{2e}\u{3a}\u{61}", &["\u{61}", "\u{2e}", "\u{3a}",
        "\u{61}"]), ("\u{61}\u{5f}\u{31}\u{2e}\u{3a}\u{61}", &["\u{61}\u{5f}\u{31}", "\u{2e}",
        "\u{3a}", "\u{61}"]), ("\u{61}\u{5f}\u{61}\u{2e}\u{3a}\u{61}", &["\u{61}\u{5f}\u{61}",
        "\u{2e}", "\u{3a}", "\u{61}"]), ("\u{61}\u{2e}\u{2e}\u{31}", &["\u{61}", "\u{2e}", "\u{2e}",
        "\u{31}"]), ("\u{61}\u{5f}\u{31}\u{2e}\u{2e}\u{31}", &["\u{61}\u{5f}\u{31}", "\u{2e}",
        "\u{2e}", "\u{31}"]), ("\u{61}\u{5f}\u{61}\u{2e}\u{2e}\u{31}", &["\u{61}\u{5f}\u{61}",
        "\u{2e}", "\u{2e}", "\u{31}"]), ("\u{61}\u{2e}\u{2e}\u{61}", &["\u{61}", "\u{2e}", "\u{2e}",
        "\u{61}"]), ("\u{61}\u{5f}\u{31}\u{2e}\u{2e}\u{61}", &["\u{61}\u{5f}\u{31}", "\u{2e}",
        "\u{2e}", "\u{61}"]), ("\u{61}\u{5f}\u{61}\u{2e}\u{2e}\u{61}", &["\u{61}\u{5f}\u{61}",
        "\u{2e}", "\u{2e}", "\u{61}"]), ("\u{61}\u{2e}\u{2c}\u{31}", &["\u{61}", "\u{2e}", "\u{2c}",
        "\u{31}"]), ("\u{61}\u{5f}\u{31}\u{2e}\u{2c}\u{31}", &["\u{61}\u{5f}\u{31}", "\u{2e}",
        "\u{2c}", "\u{31}"]), ("\u{61}\u{5f}\u{61}\u{2e}\u{2c}\u{31}", &["\u{61}\u{5f}\u{61}",
        "\u{2e}", "\u{2c}", "\u{31}"]), ("\u{61}\u{2e}\u{2c}\u{61}", &["\u{61}", "\u{2e}", "\u{2c}",
        "\u{61}"]), ("\u{61}\u{5f}\u{31}\u{2e}\u{2c}\u{61}", &["\u{61}\u{5f}\u{31}", "\u{2e}",
        "\u{2c}", "\u{61}"]), ("\u{61}\u{5f}\u{61}\u{2e}\u{2c}\u{61}", &["\u{61}\u{5f}\u{61}",
        "\u{2e}", "\u{2c}", "\u{61}"]), ("\u{61}\u{2c}\u{3a}\u{31}", &["\u{61}", "\u{2c}", "\u{3a}",
        "\u{31}"]), ("\u{61}\u{5f}\u{31}\u{2c}\u{3a}\u{31}", &["\u{61}\u{5f}\u{31}", "\u{2c}",
        "\u{3a}", "\u{31}"]), ("\u{61}\u{5f}\u{61}\u{2c}\u{3a}\u{31}", &["\u{61}\u{5f}\u{61}",
        "\u{2c}", "\u{3a}", "\u{31}"]), ("\u{61}\u{2c}\u{3a}\u{61}", &["\u{61}", "\u{2c}", "\u{3a}",
        "\u{61}"]), ("\u{61}\u{5f}\u{31}\u{2c}\u{3a}\u{61}", &["\u{61}\u{5f}\u{31}", "\u{2c}",
        "\u{3a}", "\u{61}"]), ("\u{61}\u{5f}\u{61}\u{2c}\u{3a}\u{61}", &["\u{61}\u{5f}\u{61}",
        "\u{2c}", "\u{3a}", "\u{61}"]), ("\u{61}\u{2c}\u{2e}\u{31}", &["\u{61}", "\u{2c}", "\u{2e}",
        "\u{31}"]), ("\u{61}\u{5f}\u{31}\u{2c}\u{2e}\u{31}", &["\u{61}\u{5f}\u{31}", "\u{2c}",
        "\u{2e}", "\u{31}"]), ("\u{61}\u{5f}\u{61}\u{2c}\u{2e}\u{31}", &["\u{61}\u{5f}\u{61}",
        "\u{2c}", "\u{2e}", "\u{31}"]), ("\u{61}\u{2c}\u{2e}\u{61}", &["\u{61}", "\u{2c}", "\u{2e}",
        "\u{61}"]), ("\u{61}\u{5f}\u{31}\u{2c}\u{2e}\u{61}", &["\u{61}\u{5f}\u{31}", "\u{2c}",
        "\u{2e}", "\u{61}"]), ("\u{61}\u{5f}\u{61}\u{2c}\u{2e}\u{61}", &["\u{61}\u{5f}\u{61}",
        "\u{2c}", "\u{2e}", "\u{61}"]), ("\u{61}\u{2c}\u{2c}\u{31}", &["\u{61}", "\u{2c}", "\u{2c}",
        "\u{31}"]), ("\u{61}\u{5f}\u{31}\u{2c}\u{2c}\u{31}", &["\u{61}\u{5f}\u{31}", "\u{2c}",
        "\u{2c}", "\u{31}"]), ("\u{61}\u{5f}\u{61}\u{2c}\u{2c}\u{31}", &["\u{61}\u{5f}\u{61}",
        "\u{2c}", "\u{2c}", "\u{31}"]), ("\u{61}\u{2c}\u{2c}\u{61}", &["\u{61}", "\u{2c}", "\u{2c}",
        "\u{61}"]), ("\u{61}\u{5f}\u{31}\u{2c}\u{2c}\u{61}", &["\u{61}\u{5f}\u{31}", "\u{2c}",
        "\u{2c}", "\u{61}"]), ("\u{61}\u{5f}\u{61}\u{2c}\u{2c}\u{61}", &["\u{61}\u{5f}\u{61}",
        "\u{2c}", "\u{2c}", "\u{61}"])
    ];

    // official Unicode test data
    // http://www.unicode.org/Public/UNIDATA/auxiliary/SentenceBreakTest.txt
    pub const TEST_SENTENCE: &'static [(&'static str, &'static [&'static str])] = &[
        ("\u{1}\u{1}", &["\u{1}\u{1}"]), ("\u{1}\u{308}\u{1}", &["\u{1}\u{308}\u{1}"]),
        ("\u{1}\u{d}", &["\u{1}\u{d}"]), ("\u{1}\u{308}\u{d}", &["\u{1}\u{308}\u{d}"]),
        ("\u{1}\u{a}", &["\u{1}\u{a}"]), ("\u{1}\u{308}\u{a}", &["\u{1}\u{308}\u{a}"]),
        ("\u{1}\u{85}", &["\u{1}\u{85}"]), ("\u{1}\u{308}\u{85}", &["\u{1}\u{308}\u{85}"]),
        ("\u{1}\u{9}", &["\u{1}\u{9}"]), ("\u{1}\u{308}\u{9}", &["\u{1}\u{308}\u{9}"]),
        ("\u{1}\u{61}", &["\u{1}\u{61}"]), ("\u{1}\u{308}\u{61}", &["\u{1}\u{308}\u{61}"]),
        ("\u{1}\u{41}", &["\u{1}\u{41}"]), ("\u{1}\u{308}\u{41}", &["\u{1}\u{308}\u{41}"]),
        ("\u{1}\u{1bb}", &["\u{1}\u{1bb}"]), ("\u{1}\u{308}\u{1bb}", &["\u{1}\u{308}\u{1bb}"]),
        ("\u{1}\u{30}", &["\u{1}\u{30}"]), ("\u{1}\u{308}\u{30}", &["\u{1}\u{308}\u{30}"]),
        ("\u{1}\u{2e}", &["\u{1}\u{2e}"]), ("\u{1}\u{308}\u{2e}", &["\u{1}\u{308}\u{2e}"]),
        ("\u{1}\u{21}", &["\u{1}\u{21}"]), ("\u{1}\u{308}\u{21}", &["\u{1}\u{308}\u{21}"]),
        ("\u{1}\u{22}", &["\u{1}\u{22}"]), ("\u{1}\u{308}\u{22}", &["\u{1}\u{308}\u{22}"]),
        ("\u{1}\u{2c}", &["\u{1}\u{2c}"]), ("\u{1}\u{308}\u{2c}", &["\u{1}\u{308}\u{2c}"]),
        ("\u{1}\u{ad}", &["\u{1}\u{ad}"]), ("\u{1}\u{308}\u{ad}", &["\u{1}\u{308}\u{ad}"]),
        ("\u{1}\u{300}", &["\u{1}\u{300}"]), ("\u{1}\u{308}\u{300}", &["\u{1}\u{308}\u{300}"]),
        ("\u{d}\u{1}", &["\u{d}", "\u{1}"]), ("\u{d}\u{308}\u{1}", &["\u{d}", "\u{308}\u{1}"]),
        ("\u{d}\u{d}", &["\u{d}", "\u{d}"]), ("\u{d}\u{308}\u{d}", &["\u{d}", "\u{308}\u{d}"]),
        ("\u{d}\u{a}", &["\u{d}\u{a}"]), ("\u{d}\u{308}\u{a}", &["\u{d}", "\u{308}\u{a}"]),
        ("\u{d}\u{85}", &["\u{d}", "\u{85}"]), ("\u{d}\u{308}\u{85}", &["\u{d}", "\u{308}\u{85}"]),
        ("\u{d}\u{9}", &["\u{d}", "\u{9}"]), ("\u{d}\u{308}\u{9}", &["\u{d}", "\u{308}\u{9}"]),
        ("\u{d}\u{61}", &["\u{d}", "\u{61}"]), ("\u{d}\u{308}\u{61}", &["\u{d}", "\u{308}\u{61}"]),
        ("\u{d}\u{41}", &["\u{d}", "\u{41}"]), ("\u{d}\u{308}\u{41}", &["\u{d}", "\u{308}\u{41}"]),
        ("\u{d}\u{1bb}", &["\u{d}", "\u{1bb}"]), ("\u{d}\u{308}\u{1bb}", &["\u{d}",
        "\u{308}\u{1bb}"]), ("\u{d}\u{30}", &["\u{d}", "\u{30}"]), ("\u{d}\u{308}\u{30}", &["\u{d}",
        "\u{308}\u{30}"]), ("\u{d}\u{2e}", &["\u{d}", "\u{2e}"]), ("\u{d}\u{308}\u{2e}", &["\u{d}",
        "\u{308}\u{2e}"]), ("\u{d}\u{21}", &["\u{d}", "\u{21}"]), ("\u{d}\u{308}\u{21}", &["\u{d}",
        "\u{308}\u{21}"]), ("\u{d}\u{22}", &["\u{d}", "\u{22}"]), ("\u{d}\u{308}\u{22}", &["\u{d}",
        "\u{308}\u{22}"]), ("\u{d}\u{2c}", &["\u{d}", "\u{2c}"]), ("\u{d}\u{308}\u{2c}", &["\u{d}",
        "\u{308}\u{2c}"]), ("\u{d}\u{ad}", &["\u{d}", "\u{ad}"]), ("\u{d}\u{308}\u{ad}", &["\u{d}",
        "\u{308}\u{ad}"]), ("\u{d}\u{300}", &["\u{d}", "\u{300}"]), ("\u{d}\u{308}\u{300}",
        &["\u{d}", "\u{308}\u{300}"]), ("\u{a}\u{1}", &["\u{a}", "\u{1}"]), ("\u{a}\u{308}\u{1}",
        &["\u{a}", "\u{308}\u{1}"]), ("\u{a}\u{d}", &["\u{a}", "\u{d}"]), ("\u{a}\u{308}\u{d}",
        &["\u{a}", "\u{308}\u{d}"]), ("\u{a}\u{a}", &["\u{a}", "\u{a}"]), ("\u{a}\u{308}\u{a}",
        &["\u{a}", "\u{308}\u{a}"]), ("\u{a}\u{85}", &["\u{a}", "\u{85}"]), ("\u{a}\u{308}\u{85}",
        &["\u{a}", "\u{308}\u{85}"]), ("\u{a}\u{9}", &["\u{a}", "\u{9}"]), ("\u{a}\u{308}\u{9}",
        &["\u{a}", "\u{308}\u{9}"]), ("\u{a}\u{61}", &["\u{a}", "\u{61}"]), ("\u{a}\u{308}\u{61}",
        &["\u{a}", "\u{308}\u{61}"]), ("\u{a}\u{41}", &["\u{a}", "\u{41}"]), ("\u{a}\u{308}\u{41}",
        &["\u{a}", "\u{308}\u{41}"]), ("\u{a}\u{1bb}", &["\u{a}", "\u{1bb}"]),
        ("\u{a}\u{308}\u{1bb}", &["\u{a}", "\u{308}\u{1bb}"]), ("\u{a}\u{30}", &["\u{a}",
        "\u{30}"]), ("\u{a}\u{308}\u{30}", &["\u{a}", "\u{308}\u{30}"]), ("\u{a}\u{2e}", &["\u{a}",
        "\u{2e}"]), ("\u{a}\u{308}\u{2e}", &["\u{a}", "\u{308}\u{2e}"]), ("\u{a}\u{21}", &["\u{a}",
        "\u{21}"]), ("\u{a}\u{308}\u{21}", &["\u{a}", "\u{308}\u{21}"]), ("\u{a}\u{22}", &["\u{a}",
        "\u{22}"]), ("\u{a}\u{308}\u{22}", &["\u{a}", "\u{308}\u{22}"]), ("\u{a}\u{2c}", &["\u{a}",
        "\u{2c}"]), ("\u{a}\u{308}\u{2c}", &["\u{a}", "\u{308}\u{2c}"]), ("\u{a}\u{ad}", &["\u{a}",
        "\u{ad}"]), ("\u{a}\u{308}\u{ad}", &["\u{a}", "\u{308}\u{ad}"]), ("\u{a}\u{300}", &["\u{a}",
        "\u{300}"]), ("\u{a}\u{308}\u{300}", &["\u{a}", "\u{308}\u{300}"]), ("\u{85}\u{1}",
        &["\u{85}", "\u{1}"]), ("\u{85}\u{308}\u{1}", &["\u{85}", "\u{308}\u{1}"]), ("\u{85}\u{d}",
        &["\u{85}", "\u{d}"]), ("\u{85}\u{308}\u{d}", &["\u{85}", "\u{308}\u{d}"]), ("\u{85}\u{a}",
        &["\u{85}", "\u{a}"]), ("\u{85}\u{308}\u{a}", &["\u{85}", "\u{308}\u{a}"]), ("\u{85}\u{85}",
        &["\u{85}", "\u{85}"]), ("\u{85}\u{308}\u{85}", &["\u{85}", "\u{308}\u{85}"]),
        ("\u{85}\u{9}", &["\u{85}", "\u{9}"]), ("\u{85}\u{308}\u{9}", &["\u{85}", "\u{308}\u{9}"]),
        ("\u{85}\u{61}", &["\u{85}", "\u{61}"]), ("\u{85}\u{308}\u{61}", &["\u{85}",
        "\u{308}\u{61}"]), ("\u{85}\u{41}", &["\u{85}", "\u{41}"]), ("\u{85}\u{308}\u{41}",
        &["\u{85}", "\u{308}\u{41}"]), ("\u{85}\u{1bb}", &["\u{85}", "\u{1bb}"]),
        ("\u{85}\u{308}\u{1bb}", &["\u{85}", "\u{308}\u{1bb}"]), ("\u{85}\u{30}", &["\u{85}",
        "\u{30}"]), ("\u{85}\u{308}\u{30}", &["\u{85}", "\u{308}\u{30}"]), ("\u{85}\u{2e}",
        &["\u{85}", "\u{2e}"]), ("\u{85}\u{308}\u{2e}", &["\u{85}", "\u{308}\u{2e}"]),
        ("\u{85}\u{21}", &["\u{85}", "\u{21}"]), ("\u{85}\u{308}\u{21}", &["\u{85}",
        "\u{308}\u{21}"]), ("\u{85}\u{22}", &["\u{85}", "\u{22}"]), ("\u{85}\u{308}\u{22}",
        &["\u{85}", "\u{308}\u{22}"]), ("\u{85}\u{2c}", &["\u{85}", "\u{2c}"]),
        ("\u{85}\u{308}\u{2c}", &["\u{85}", "\u{308}\u{2c}"]), ("\u{85}\u{ad}", &["\u{85}",
        "\u{ad}"]), ("\u{85}\u{308}\u{ad}", &["\u{85}", "\u{308}\u{ad}"]), ("\u{85}\u{300}",
        &["\u{85}", "\u{300}"]), ("\u{85}\u{308}\u{300}", &["\u{85}", "\u{308}\u{300}"]),
        ("\u{9}\u{1}", &["\u{9}\u{1}"]), ("\u{9}\u{308}\u{1}", &["\u{9}\u{308}\u{1}"]),
        ("\u{9}\u{d}", &["\u{9}\u{d}"]), ("\u{9}\u{308}\u{d}", &["\u{9}\u{308}\u{d}"]),
        ("\u{9}\u{a}", &["\u{9}\u{a}"]), ("\u{9}\u{308}\u{a}", &["\u{9}\u{308}\u{a}"]),
        ("\u{9}\u{85}", &["\u{9}\u{85}"]), ("\u{9}\u{308}\u{85}", &["\u{9}\u{308}\u{85}"]),
        ("\u{9}\u{9}", &["\u{9}\u{9}"]), ("\u{9}\u{308}\u{9}", &["\u{9}\u{308}\u{9}"]),
        ("\u{9}\u{61}", &["\u{9}\u{61}"]), ("\u{9}\u{308}\u{61}", &["\u{9}\u{308}\u{61}"]),
        ("\u{9}\u{41}", &["\u{9}\u{41}"]), ("\u{9}\u{308}\u{41}", &["\u{9}\u{308}\u{41}"]),
        ("\u{9}\u{1bb}", &["\u{9}\u{1bb}"]), ("\u{9}\u{308}\u{1bb}", &["\u{9}\u{308}\u{1bb}"]),
        ("\u{9}\u{30}", &["\u{9}\u{30}"]), ("\u{9}\u{308}\u{30}", &["\u{9}\u{308}\u{30}"]),
        ("\u{9}\u{2e}", &["\u{9}\u{2e}"]), ("\u{9}\u{308}\u{2e}", &["\u{9}\u{308}\u{2e}"]),
        ("\u{9}\u{21}", &["\u{9}\u{21}"]), ("\u{9}\u{308}\u{21}", &["\u{9}\u{308}\u{21}"]),
        ("\u{9}\u{22}", &["\u{9}\u{22}"]), ("\u{9}\u{308}\u{22}", &["\u{9}\u{308}\u{22}"]),
        ("\u{9}\u{2c}", &["\u{9}\u{2c}"]), ("\u{9}\u{308}\u{2c}", &["\u{9}\u{308}\u{2c}"]),
        ("\u{9}\u{ad}", &["\u{9}\u{ad}"]), ("\u{9}\u{308}\u{ad}", &["\u{9}\u{308}\u{ad}"]),
        ("\u{9}\u{300}", &["\u{9}\u{300}"]), ("\u{9}\u{308}\u{300}", &["\u{9}\u{308}\u{300}"]),
        ("\u{61}\u{1}", &["\u{61}\u{1}"]), ("\u{61}\u{308}\u{1}", &["\u{61}\u{308}\u{1}"]),
        ("\u{61}\u{d}", &["\u{61}\u{d}"]), ("\u{61}\u{308}\u{d}", &["\u{61}\u{308}\u{d}"]),
        ("\u{61}\u{a}", &["\u{61}\u{a}"]), ("\u{61}\u{308}\u{a}", &["\u{61}\u{308}\u{a}"]),
        ("\u{61}\u{85}", &["\u{61}\u{85}"]), ("\u{61}\u{308}\u{85}", &["\u{61}\u{308}\u{85}"]),
        ("\u{61}\u{9}", &["\u{61}\u{9}"]), ("\u{61}\u{308}\u{9}", &["\u{61}\u{308}\u{9}"]),
        ("\u{61}\u{61}", &["\u{61}\u{61}"]), ("\u{61}\u{308}\u{61}", &["\u{61}\u{308}\u{61}"]),
        ("\u{61}\u{41}", &["\u{61}\u{41}"]), ("\u{61}\u{308}\u{41}", &["\u{61}\u{308}\u{41}"]),
        ("\u{61}\u{1bb}", &["\u{61}\u{1bb}"]), ("\u{61}\u{308}\u{1bb}", &["\u{61}\u{308}\u{1bb}"]),
        ("\u{61}\u{30}", &["\u{61}\u{30}"]), ("\u{61}\u{308}\u{30}", &["\u{61}\u{308}\u{30}"]),
        ("\u{61}\u{2e}", &["\u{61}\u{2e}"]), ("\u{61}\u{308}\u{2e}", &["\u{61}\u{308}\u{2e}"]),
        ("\u{61}\u{21}", &["\u{61}\u{21}"]), ("\u{61}\u{308}\u{21}", &["\u{61}\u{308}\u{21}"]),
        ("\u{61}\u{22}", &["\u{61}\u{22}"]), ("\u{61}\u{308}\u{22}", &["\u{61}\u{308}\u{22}"]),
        ("\u{61}\u{2c}", &["\u{61}\u{2c}"]), ("\u{61}\u{308}\u{2c}", &["\u{61}\u{308}\u{2c}"]),
        ("\u{61}\u{ad}", &["\u{61}\u{ad}"]), ("\u{61}\u{308}\u{ad}", &["\u{61}\u{308}\u{ad}"]),
        ("\u{61}\u{300}", &["\u{61}\u{300}"]), ("\u{61}\u{308}\u{300}", &["\u{61}\u{308}\u{300}"]),
        ("\u{41}\u{1}", &["\u{41}\u{1}"]), ("\u{41}\u{308}\u{1}", &["\u{41}\u{308}\u{1}"]),
        ("\u{41}\u{d}", &["\u{41}\u{d}"]), ("\u{41}\u{308}\u{d}", &["\u{41}\u{308}\u{d}"]),
        ("\u{41}\u{a}", &["\u{41}\u{a}"]), ("\u{41}\u{308}\u{a}", &["\u{41}\u{308}\u{a}"]),
        ("\u{41}\u{85}", &["\u{41}\u{85}"]), ("\u{41}\u{308}\u{85}", &["\u{41}\u{308}\u{85}"]),
        ("\u{41}\u{9}", &["\u{41}\u{9}"]), ("\u{41}\u{308}\u{9}", &["\u{41}\u{308}\u{9}"]),
        ("\u{41}\u{61}", &["\u{41}\u{61}"]), ("\u{41}\u{308}\u{61}", &["\u{41}\u{308}\u{61}"]),
        ("\u{41}\u{41}", &["\u{41}\u{41}"]), ("\u{41}\u{308}\u{41}", &["\u{41}\u{308}\u{41}"]),
        ("\u{41}\u{1bb}", &["\u{41}\u{1bb}"]), ("\u{41}\u{308}\u{1bb}", &["\u{41}\u{308}\u{1bb}"]),
        ("\u{41}\u{30}", &["\u{41}\u{30}"]), ("\u{41}\u{308}\u{30}", &["\u{41}\u{308}\u{30}"]),
        ("\u{41}\u{2e}", &["\u{41}\u{2e}"]), ("\u{41}\u{308}\u{2e}", &["\u{41}\u{308}\u{2e}"]),
        ("\u{41}\u{21}", &["\u{41}\u{21}"]), ("\u{41}\u{308}\u{21}", &["\u{41}\u{308}\u{21}"]),
        ("\u{41}\u{22}", &["\u{41}\u{22}"]), ("\u{41}\u{308}\u{22}", &["\u{41}\u{308}\u{22}"]),
        ("\u{41}\u{2c}", &["\u{41}\u{2c}"]), ("\u{41}\u{308}\u{2c}", &["\u{41}\u{308}\u{2c}"]),
        ("\u{41}\u{ad}", &["\u{41}\u{ad}"]), ("\u{41}\u{308}\u{ad}", &["\u{41}\u{308}\u{ad}"]),
        ("\u{41}\u{300}", &["\u{41}\u{300}"]), ("\u{41}\u{308}\u{300}", &["\u{41}\u{308}\u{300}"]),
        ("\u{1bb}\u{1}", &["\u{1bb}\u{1}"]), ("\u{1bb}\u{308}\u{1}", &["\u{1bb}\u{308}\u{1}"]),
        ("\u{1bb}\u{d}", &["\u{1bb}\u{d}"]), ("\u{1bb}\u{308}\u{d}", &["\u{1bb}\u{308}\u{d}"]),
        ("\u{1bb}\u{a}", &["\u{1bb}\u{a}"]), ("\u{1bb}\u{308}\u{a}", &["\u{1bb}\u{308}\u{a}"]),
        ("\u{1bb}\u{85}", &["\u{1bb}\u{85}"]), ("\u{1bb}\u{308}\u{85}", &["\u{1bb}\u{308}\u{85}"]),
        ("\u{1bb}\u{9}", &["\u{1bb}\u{9}"]), ("\u{1bb}\u{308}\u{9}", &["\u{1bb}\u{308}\u{9}"]),
        ("\u{1bb}\u{61}", &["\u{1bb}\u{61}"]), ("\u{1bb}\u{308}\u{61}", &["\u{1bb}\u{308}\u{61}"]),
        ("\u{1bb}\u{41}", &["\u{1bb}\u{41}"]), ("\u{1bb}\u{308}\u{41}", &["\u{1bb}\u{308}\u{41}"]),
        ("\u{1bb}\u{1bb}", &["\u{1bb}\u{1bb}"]), ("\u{1bb}\u{308}\u{1bb}",
        &["\u{1bb}\u{308}\u{1bb}"]), ("\u{1bb}\u{30}", &["\u{1bb}\u{30}"]), ("\u{1bb}\u{308}\u{30}",
        &["\u{1bb}\u{308}\u{30}"]), ("\u{1bb}\u{2e}", &["\u{1bb}\u{2e}"]), ("\u{1bb}\u{308}\u{2e}",
        &["\u{1bb}\u{308}\u{2e}"]), ("\u{1bb}\u{21}", &["\u{1bb}\u{21}"]), ("\u{1bb}\u{308}\u{21}",
        &["\u{1bb}\u{308}\u{21}"]), ("\u{1bb}\u{22}", &["\u{1bb}\u{22}"]), ("\u{1bb}\u{308}\u{22}",
        &["\u{1bb}\u{308}\u{22}"]), ("\u{1bb}\u{2c}", &["\u{1bb}\u{2c}"]), ("\u{1bb}\u{308}\u{2c}",
        &["\u{1bb}\u{308}\u{2c}"]), ("\u{1bb}\u{ad}", &["\u{1bb}\u{ad}"]), ("\u{1bb}\u{308}\u{ad}",
        &["\u{1bb}\u{308}\u{ad}"]), ("\u{1bb}\u{300}", &["\u{1bb}\u{300}"]),
        ("\u{1bb}\u{308}\u{300}", &["\u{1bb}\u{308}\u{300}"]), ("\u{30}\u{1}", &["\u{30}\u{1}"]),
        ("\u{30}\u{308}\u{1}", &["\u{30}\u{308}\u{1}"]), ("\u{30}\u{d}", &["\u{30}\u{d}"]),
        ("\u{30}\u{308}\u{d}", &["\u{30}\u{308}\u{d}"]), ("\u{30}\u{a}", &["\u{30}\u{a}"]),
        ("\u{30}\u{308}\u{a}", &["\u{30}\u{308}\u{a}"]), ("\u{30}\u{85}", &["\u{30}\u{85}"]),
        ("\u{30}\u{308}\u{85}", &["\u{30}\u{308}\u{85}"]), ("\u{30}\u{9}", &["\u{30}\u{9}"]),
        ("\u{30}\u{308}\u{9}", &["\u{30}\u{308}\u{9}"]), ("\u{30}\u{61}", &["\u{30}\u{61}"]),
        ("\u{30}\u{308}\u{61}", &["\u{30}\u{308}\u{61}"]), ("\u{30}\u{41}", &["\u{30}\u{41}"]),
        ("\u{30}\u{308}\u{41}", &["\u{30}\u{308}\u{41}"]), ("\u{30}\u{1bb}", &["\u{30}\u{1bb}"]),
        ("\u{30}\u{308}\u{1bb}", &["\u{30}\u{308}\u{1bb}"]), ("\u{30}\u{30}", &["\u{30}\u{30}"]),
        ("\u{30}\u{308}\u{30}", &["\u{30}\u{308}\u{30}"]), ("\u{30}\u{2e}", &["\u{30}\u{2e}"]),
        ("\u{30}\u{308}\u{2e}", &["\u{30}\u{308}\u{2e}"]), ("\u{30}\u{21}", &["\u{30}\u{21}"]),
        ("\u{30}\u{308}\u{21}", &["\u{30}\u{308}\u{21}"]), ("\u{30}\u{22}", &["\u{30}\u{22}"]),
        ("\u{30}\u{308}\u{22}", &["\u{30}\u{308}\u{22}"]), ("\u{30}\u{2c}", &["\u{30}\u{2c}"]),
        ("\u{30}\u{308}\u{2c}", &["\u{30}\u{308}\u{2c}"]), ("\u{30}\u{ad}", &["\u{30}\u{ad}"]),
        ("\u{30}\u{308}\u{ad}", &["\u{30}\u{308}\u{ad}"]), ("\u{30}\u{300}", &["\u{30}\u{300}"]),
        ("\u{30}\u{308}\u{300}", &["\u{30}\u{308}\u{300}"]), ("\u{2e}\u{1}", &["\u{2e}", "\u{1}"]),
        ("\u{2e}\u{308}\u{1}", &["\u{2e}\u{308}", "\u{1}"]), ("\u{2e}\u{d}", &["\u{2e}\u{d}"]),
        ("\u{2e}\u{308}\u{d}", &["\u{2e}\u{308}\u{d}"]), ("\u{2e}\u{a}", &["\u{2e}\u{a}"]),
        ("\u{2e}\u{308}\u{a}", &["\u{2e}\u{308}\u{a}"]), ("\u{2e}\u{85}", &["\u{2e}\u{85}"]),
        ("\u{2e}\u{308}\u{85}", &["\u{2e}\u{308}\u{85}"]), ("\u{2e}\u{9}", &["\u{2e}\u{9}"]),
        ("\u{2e}\u{308}\u{9}", &["\u{2e}\u{308}\u{9}"]), ("\u{2e}\u{61}", &["\u{2e}\u{61}"]),
        ("\u{2e}\u{308}\u{61}", &["\u{2e}\u{308}\u{61}"]), ("\u{2e}\u{41}", &["\u{2e}", "\u{41}"]),
        ("\u{2e}\u{308}\u{41}", &["\u{2e}\u{308}", "\u{41}"]), ("\u{2e}\u{1bb}", &["\u{2e}",
        "\u{1bb}"]), ("\u{2e}\u{308}\u{1bb}", &["\u{2e}\u{308}", "\u{1bb}"]), ("\u{2e}\u{30}",
        &["\u{2e}\u{30}"]), ("\u{2e}\u{308}\u{30}", &["\u{2e}\u{308}\u{30}"]), ("\u{2e}\u{2e}",
        &["\u{2e}\u{2e}"]), ("\u{2e}\u{308}\u{2e}", &["\u{2e}\u{308}\u{2e}"]), ("\u{2e}\u{21}",
        &["\u{2e}\u{21}"]), ("\u{2e}\u{308}\u{21}", &["\u{2e}\u{308}\u{21}"]), ("\u{2e}\u{22}",
        &["\u{2e}\u{22}"]), ("\u{2e}\u{308}\u{22}", &["\u{2e}\u{308}\u{22}"]), ("\u{2e}\u{2c}",
        &["\u{2e}\u{2c}"]), ("\u{2e}\u{308}\u{2c}", &["\u{2e}\u{308}\u{2c}"]), ("\u{2e}\u{ad}",
        &["\u{2e}\u{ad}"]), ("\u{2e}\u{308}\u{ad}", &["\u{2e}\u{308}\u{ad}"]), ("\u{2e}\u{300}",
        &["\u{2e}\u{300}"]), ("\u{2e}\u{308}\u{300}", &["\u{2e}\u{308}\u{300}"]), ("\u{21}\u{1}",
        &["\u{21}", "\u{1}"]), ("\u{21}\u{308}\u{1}", &["\u{21}\u{308}", "\u{1}"]), ("\u{21}\u{d}",
        &["\u{21}\u{d}"]), ("\u{21}\u{308}\u{d}", &["\u{21}\u{308}\u{d}"]), ("\u{21}\u{a}",
        &["\u{21}\u{a}"]), ("\u{21}\u{308}\u{a}", &["\u{21}\u{308}\u{a}"]), ("\u{21}\u{85}",
        &["\u{21}\u{85}"]), ("\u{21}\u{308}\u{85}", &["\u{21}\u{308}\u{85}"]), ("\u{21}\u{9}",
        &["\u{21}\u{9}"]), ("\u{21}\u{308}\u{9}", &["\u{21}\u{308}\u{9}"]), ("\u{21}\u{61}",
        &["\u{21}", "\u{61}"]), ("\u{21}\u{308}\u{61}", &["\u{21}\u{308}", "\u{61}"]),
        ("\u{21}\u{41}", &["\u{21}", "\u{41}"]), ("\u{21}\u{308}\u{41}", &["\u{21}\u{308}",
        "\u{41}"]), ("\u{21}\u{1bb}", &["\u{21}", "\u{1bb}"]), ("\u{21}\u{308}\u{1bb}",
        &["\u{21}\u{308}", "\u{1bb}"]), ("\u{21}\u{30}", &["\u{21}", "\u{30}"]),
        ("\u{21}\u{308}\u{30}", &["\u{21}\u{308}", "\u{30}"]), ("\u{21}\u{2e}", &["\u{21}\u{2e}"]),
        ("\u{21}\u{308}\u{2e}", &["\u{21}\u{308}\u{2e}"]), ("\u{21}\u{21}", &["\u{21}\u{21}"]),
        ("\u{21}\u{308}\u{21}", &["\u{21}\u{308}\u{21}"]), ("\u{21}\u{22}", &["\u{21}\u{22}"]),
        ("\u{21}\u{308}\u{22}", &["\u{21}\u{308}\u{22}"]), ("\u{21}\u{2c}", &["\u{21}\u{2c}"]),
        ("\u{21}\u{308}\u{2c}", &["\u{21}\u{308}\u{2c}"]), ("\u{21}\u{ad}", &["\u{21}\u{ad}"]),
        ("\u{21}\u{308}\u{ad}", &["\u{21}\u{308}\u{ad}"]), ("\u{21}\u{300}", &["\u{21}\u{300}"]),
        ("\u{21}\u{308}\u{300}", &["\u{21}\u{308}\u{300}"]), ("\u{22}\u{1}", &["\u{22}\u{1}"]),
        ("\u{22}\u{308}\u{1}", &["\u{22}\u{308}\u{1}"]), ("\u{22}\u{d}", &["\u{22}\u{d}"]),
        ("\u{22}\u{308}\u{d}", &["\u{22}\u{308}\u{d}"]), ("\u{22}\u{a}", &["\u{22}\u{a}"]),
        ("\u{22}\u{308}\u{a}", &["\u{22}\u{308}\u{a}"]), ("\u{22}\u{85}", &["\u{22}\u{85}"]),
        ("\u{22}\u{308}\u{85}", &["\u{22}\u{308}\u{85}"]), ("\u{22}\u{9}", &["\u{22}\u{9}"]),
        ("\u{22}\u{308}\u{9}", &["\u{22}\u{308}\u{9}"]), ("\u{22}\u{61}", &["\u{22}\u{61}"]),
        ("\u{22}\u{308}\u{61}", &["\u{22}\u{308}\u{61}"]), ("\u{22}\u{41}", &["\u{22}\u{41}"]),
        ("\u{22}\u{308}\u{41}", &["\u{22}\u{308}\u{41}"]), ("\u{22}\u{1bb}", &["\u{22}\u{1bb}"]),
        ("\u{22}\u{308}\u{1bb}", &["\u{22}\u{308}\u{1bb}"]), ("\u{22}\u{30}", &["\u{22}\u{30}"]),
        ("\u{22}\u{308}\u{30}", &["\u{22}\u{308}\u{30}"]), ("\u{22}\u{2e}", &["\u{22}\u{2e}"]),
        ("\u{22}\u{308}\u{2e}", &["\u{22}\u{308}\u{2e}"]), ("\u{22}\u{21}", &["\u{22}\u{21}"]),
        ("\u{22}\u{308}\u{21}", &["\u{22}\u{308}\u{21}"]), ("\u{22}\u{22}", &["\u{22}\u{22}"]),
        ("\u{22}\u{308}\u{22}", &["\u{22}\u{308}\u{22}"]), ("\u{22}\u{2c}", &["\u{22}\u{2c}"]),
        ("\u{22}\u{308}\u{2c}", &["\u{22}\u{308}\u{2c}"]), ("\u{22}\u{ad}", &["\u{22}\u{ad}"]),
        ("\u{22}\u{308}\u{ad}", &["\u{22}\u{308}\u{ad}"]), ("\u{22}\u{300}", &["\u{22}\u{300}"]),
        ("\u{22}\u{308}\u{300}", &["\u{22}\u{308}\u{300}"]), ("\u{2c}\u{1}", &["\u{2c}\u{1}"]),
        ("\u{2c}\u{308}\u{1}", &["\u{2c}\u{308}\u{1}"]), ("\u{2c}\u{d}", &["\u{2c}\u{d}"]),
        ("\u{2c}\u{308}\u{d}", &["\u{2c}\u{308}\u{d}"]), ("\u{2c}\u{a}", &["\u{2c}\u{a}"]),
        ("\u{2c}\u{308}\u{a}", &["\u{2c}\u{308}\u{a}"]), ("\u{2c}\u{85}", &["\u{2c}\u{85}"]),
        ("\u{2c}\u{308}\u{85}", &["\u{2c}\u{308}\u{85}"]), ("\u{2c}\u{9}", &["\u{2c}\u{9}"]),
        ("\u{2c}\u{308}\u{9}", &["\u{2c}\u{308}\u{9}"]), ("\u{2c}\u{61}", &["\u{2c}\u{61}"]),
        ("\u{2c}\u{308}\u{61}", &["\u{2c}\u{308}\u{61}"]), ("\u{2c}\u{41}", &["\u{2c}\u{41}"]),
        ("\u{2c}\u{308}\u{41}", &["\u{2c}\u{308}\u{41}"]), ("\u{2c}\u{1bb}", &["\u{2c}\u{1bb}"]),
        ("\u{2c}\u{308}\u{1bb}", &["\u{2c}\u{308}\u{1bb}"]), ("\u{2c}\u{30}", &["\u{2c}\u{30}"]),
        ("\u{2c}\u{308}\u{30}", &["\u{2c}\u{308}\u{30}"]), ("\u{2c}\u{2e}", &["\u{2c}\u{2e}"]),
        ("\u{2c}\u{308}\u{2e}", &["\u{2c}\u{308}\u{2e}"]), ("\u{2c}\u{21}", &["\u{2c}\u{21}"]),
        ("\u{2c}\u{308}\u{21}", &["\u{2c}\u{308}\u{21}"]), ("\u{2c}\u{22}", &["\u{2c}\u{22}"]),
        ("\u{2c}\u{308}\u{22}", &["\u{2c}\u{308}\u{22}"]), ("\u{2c}\u{2c}", &["\u{2c}\u{2c}"]),
        ("\u{2c}\u{308}\u{2c}", &["\u{2c}\u{308}\u{2c}"]), ("\u{2c}\u{ad}", &["\u{2c}\u{ad}"]),
        ("\u{2c}\u{308}\u{ad}", &["\u{2c}\u{308}\u{ad}"]), ("\u{2c}\u{300}", &["\u{2c}\u{300}"]),
        ("\u{2c}\u{308}\u{300}", &["\u{2c}\u{308}\u{300}"]), ("\u{ad}\u{1}", &["\u{ad}\u{1}"]),
        ("\u{ad}\u{308}\u{1}", &["\u{ad}\u{308}\u{1}"]), ("\u{ad}\u{d}", &["\u{ad}\u{d}"]),
        ("\u{ad}\u{308}\u{d}", &["\u{ad}\u{308}\u{d}"]), ("\u{ad}\u{a}", &["\u{ad}\u{a}"]),
        ("\u{ad}\u{308}\u{a}", &["\u{ad}\u{308}\u{a}"]), ("\u{ad}\u{85}", &["\u{ad}\u{85}"]),
        ("\u{ad}\u{308}\u{85}", &["\u{ad}\u{308}\u{85}"]), ("\u{ad}\u{9}", &["\u{ad}\u{9}"]),
        ("\u{ad}\u{308}\u{9}", &["\u{ad}\u{308}\u{9}"]), ("\u{ad}\u{61}", &["\u{ad}\u{61}"]),
        ("\u{ad}\u{308}\u{61}", &["\u{ad}\u{308}\u{61}"]), ("\u{ad}\u{41}", &["\u{ad}\u{41}"]),
        ("\u{ad}\u{308}\u{41}", &["\u{ad}\u{308}\u{41}"]), ("\u{ad}\u{1bb}", &["\u{ad}\u{1bb}"]),
        ("\u{ad}\u{308}\u{1bb}", &["\u{ad}\u{308}\u{1bb}"]), ("\u{ad}\u{30}", &["\u{ad}\u{30}"]),
        ("\u{ad}\u{308}\u{30}", &["\u{ad}\u{308}\u{30}"]), ("\u{ad}\u{2e}", &["\u{ad}\u{2e}"]),
        ("\u{ad}\u{308}\u{2e}", &["\u{ad}\u{308}\u{2e}"]), ("\u{ad}\u{21}", &["\u{ad}\u{21}"]),
        ("\u{ad}\u{308}\u{21}", &["\u{ad}\u{308}\u{21}"]), ("\u{ad}\u{22}", &["\u{ad}\u{22}"]),
        ("\u{ad}\u{308}\u{22}", &["\u{ad}\u{308}\u{22}"]), ("\u{ad}\u{2c}", &["\u{ad}\u{2c}"]),
        ("\u{ad}\u{308}\u{2c}", &["\u{ad}\u{308}\u{2c}"]), ("\u{ad}\u{ad}", &["\u{ad}\u{ad}"]),
        ("\u{ad}\u{308}\u{ad}", &["\u{ad}\u{308}\u{ad}"]), ("\u{ad}\u{300}", &["\u{ad}\u{300}"]),
        ("\u{ad}\u{308}\u{300}", &["\u{ad}\u{308}\u{300}"]), ("\u{300}\u{1}", &["\u{300}\u{1}"]),
        ("\u{300}\u{308}\u{1}", &["\u{300}\u{308}\u{1}"]), ("\u{300}\u{d}", &["\u{300}\u{d}"]),
        ("\u{300}\u{308}\u{d}", &["\u{300}\u{308}\u{d}"]), ("\u{300}\u{a}", &["\u{300}\u{a}"]),
        ("\u{300}\u{308}\u{a}", &["\u{300}\u{308}\u{a}"]), ("\u{300}\u{85}", &["\u{300}\u{85}"]),
        ("\u{300}\u{308}\u{85}", &["\u{300}\u{308}\u{85}"]), ("\u{300}\u{9}", &["\u{300}\u{9}"]),
        ("\u{300}\u{308}\u{9}", &["\u{300}\u{308}\u{9}"]), ("\u{300}\u{61}", &["\u{300}\u{61}"]),
        ("\u{300}\u{308}\u{61}", &["\u{300}\u{308}\u{61}"]), ("\u{300}\u{41}", &["\u{300}\u{41}"]),
        ("\u{300}\u{308}\u{41}", &["\u{300}\u{308}\u{41}"]), ("\u{300}\u{1bb}",
        &["\u{300}\u{1bb}"]), ("\u{300}\u{308}\u{1bb}", &["\u{300}\u{308}\u{1bb}"]),
        ("\u{300}\u{30}", &["\u{300}\u{30}"]), ("\u{300}\u{308}\u{30}", &["\u{300}\u{308}\u{30}"]),
        ("\u{300}\u{2e}", &["\u{300}\u{2e}"]), ("\u{300}\u{308}\u{2e}", &["\u{300}\u{308}\u{2e}"]),
        ("\u{300}\u{21}", &["\u{300}\u{21}"]), ("\u{300}\u{308}\u{21}", &["\u{300}\u{308}\u{21}"]),
        ("\u{300}\u{22}", &["\u{300}\u{22}"]), ("\u{300}\u{308}\u{22}", &["\u{300}\u{308}\u{22}"]),
        ("\u{300}\u{2c}", &["\u{300}\u{2c}"]), ("\u{300}\u{308}\u{2c}", &["\u{300}\u{308}\u{2c}"]),
        ("\u{300}\u{ad}", &["\u{300}\u{ad}"]), ("\u{300}\u{308}\u{ad}", &["\u{300}\u{308}\u{ad}"]),
        ("\u{300}\u{300}", &["\u{300}\u{300}"]), ("\u{300}\u{308}\u{300}",
        &["\u{300}\u{308}\u{300}"]), ("\u{d}\u{a}\u{61}\u{a}\u{308}", &["\u{d}\u{a}", "\u{61}\u{a}",
        "\u{308}"]), ("\u{61}\u{308}", &["\u{61}\u{308}"]), ("\u{20}\u{200d}\u{646}",
        &["\u{20}\u{200d}\u{646}"]), ("\u{646}\u{200d}\u{20}", &["\u{646}\u{200d}\u{20}"]),
        ("\u{28}\u{22}\u{47}\u{6f}\u{2e}\u{22}\u{29}\u{20}\u{28}\u{48}\u{65}\u{20}\u{64}\u{69}\u{64}\u{2e}\u{29}",
        &["\u{28}\u{22}\u{47}\u{6f}\u{2e}\u{22}\u{29}\u{20}",
        "\u{28}\u{48}\u{65}\u{20}\u{64}\u{69}\u{64}\u{2e}\u{29}"]),
        ("\u{28}\u{201c}\u{47}\u{6f}\u{3f}\u{201d}\u{29}\u{20}\u{28}\u{48}\u{65}\u{20}\u{64}\u{69}\u{64}\u{2e}\u{29}",
        &["\u{28}\u{201c}\u{47}\u{6f}\u{3f}\u{201d}\u{29}\u{20}",
        "\u{28}\u{48}\u{65}\u{20}\u{64}\u{69}\u{64}\u{2e}\u{29}"]),
        ("\u{55}\u{2e}\u{53}\u{2e}\u{41}\u{300}\u{2e}\u{20}\u{69}\u{73}",
        &["\u{55}\u{2e}\u{53}\u{2e}\u{41}\u{300}\u{2e}\u{20}\u{69}\u{73}"]),
        ("\u{55}\u{2e}\u{53}\u{2e}\u{41}\u{300}\u{3f}\u{20}\u{48}\u{65}",
        &["\u{55}\u{2e}\u{53}\u{2e}\u{41}\u{300}\u{3f}\u{20}", "\u{48}\u{65}"]),
        ("\u{55}\u{2e}\u{53}\u{2e}\u{41}\u{300}\u{2e}",
        &["\u{55}\u{2e}\u{53}\u{2e}\u{41}\u{300}\u{2e}"]), ("\u{33}\u{2e}\u{34}",
        &["\u{33}\u{2e}\u{34}"]), ("\u{63}\u{2e}\u{64}", &["\u{63}\u{2e}\u{64}"]),
        ("\u{43}\u{2e}\u{64}", &["\u{43}\u{2e}\u{64}"]), ("\u{63}\u{2e}\u{44}",
        &["\u{63}\u{2e}\u{44}"]), ("\u{43}\u{2e}\u{44}", &["\u{43}\u{2e}\u{44}"]),
        ("\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{a0}\u{74}\u{68}\u{65}",
        &["\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{a0}\u{74}\u{68}\u{65}"]),
        ("\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{a0}\u{54}\u{68}\u{65}",
        &["\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{a0}", "\u{54}\u{68}\u{65}"]),
        ("\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{a0}\u{2018}\u{28}\u{74}\u{68}\u{65}",
        &["\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{a0}\u{2018}\u{28}\u{74}\u{68}\u{65}"]),
        ("\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{a0}\u{2018}\u{28}\u{54}\u{68}\u{65}",
        &["\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{a0}", "\u{2018}\u{28}\u{54}\u{68}\u{65}"]),
        ("\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{a0}\u{308}\u{74}\u{68}\u{65}",
        &["\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{a0}\u{308}\u{74}\u{68}\u{65}"]),
        ("\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{a0}\u{308}\u{54}\u{68}\u{65}",
        &["\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{a0}\u{308}", "\u{54}\u{68}\u{65}"]),
        ("\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{308}\u{54}\u{68}\u{65}",
        &["\u{65}\u{74}\u{63}\u{2e}\u{29}\u{2019}\u{308}", "\u{54}\u{68}\u{65}"]),
        ("\u{65}\u{74}\u{63}\u{2e}\u{29}\u{a}\u{308}\u{54}\u{68}\u{65}",
        &["\u{65}\u{74}\u{63}\u{2e}\u{29}\u{a}", "\u{308}\u{54}\u{68}\u{65}"]),
        ("\u{74}\u{68}\u{65}\u{20}\u{72}\u{65}\u{73}\u{70}\u{2e}\u{20}\u{6c}\u{65}\u{61}\u{64}\u{65}\u{72}\u{73}\u{20}\u{61}\u{72}\u{65}",
        &["\u{74}\u{68}\u{65}\u{20}\u{72}\u{65}\u{73}\u{70}\u{2e}\u{20}\u{6c}\u{65}\u{61}\u{64}\u{65}\u{72}\u{73}\u{20}\u{61}\u{72}\u{65}"]),
        ("\u{5b57}\u{2e}\u{5b57}", &["\u{5b57}\u{2e}", "\u{5b57}"]),
        ("\u{65}\u{74}\u{63}\u{2e}\u{5b83}", &["\u{65}\u{74}\u{63}\u{2e}", "\u{5b83}"]),
        ("\u{65}\u{74}\u{63}\u{2e}\u{3002}", &["\u{65}\u{74}\u{63}\u{2e}\u{3002}"]),
        ("\u{5b57}\u{3002}\u{5b83}", &["\u{5b57}\u{3002}", "\u{5b83}"]), ("\u{21}\u{20}\u{20}",
        &["\u{21}\u{20}\u{20}"]),
        ("\u{2060}\u{28}\u{2060}\u{22}\u{2060}\u{47}\u{2060}\u{6f}\u{2060}\u{2e}\u{2060}\u{22}\u{2060}\u{29}\u{2060}\u{20}\u{2060}\u{28}\u{2060}\u{48}\u{2060}\u{65}\u{2060}\u{20}\u{2060}\u{64}\u{2060}\u{69}\u{2060}\u{64}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2060}",
        &["\u{2060}\u{28}\u{2060}\u{22}\u{2060}\u{47}\u{2060}\u{6f}\u{2060}\u{2e}\u{2060}\u{22}\u{2060}\u{29}\u{2060}\u{20}\u{2060}",
        "\u{28}\u{2060}\u{48}\u{2060}\u{65}\u{2060}\u{20}\u{2060}\u{64}\u{2060}\u{69}\u{2060}\u{64}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2060}"]),
        ("\u{2060}\u{28}\u{2060}\u{201c}\u{2060}\u{47}\u{2060}\u{6f}\u{2060}\u{3f}\u{2060}\u{201d}\u{2060}\u{29}\u{2060}\u{20}\u{2060}\u{28}\u{2060}\u{48}\u{2060}\u{65}\u{2060}\u{20}\u{2060}\u{64}\u{2060}\u{69}\u{2060}\u{64}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2060}",
        &["\u{2060}\u{28}\u{2060}\u{201c}\u{2060}\u{47}\u{2060}\u{6f}\u{2060}\u{3f}\u{2060}\u{201d}\u{2060}\u{29}\u{2060}\u{20}\u{2060}",
        "\u{28}\u{2060}\u{48}\u{2060}\u{65}\u{2060}\u{20}\u{2060}\u{64}\u{2060}\u{69}\u{2060}\u{64}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2060}"]),
        ("\u{2060}\u{55}\u{2060}\u{2e}\u{2060}\u{53}\u{2060}\u{2e}\u{2060}\u{41}\u{2060}\u{300}\u{2e}\u{2060}\u{20}\u{2060}\u{69}\u{2060}\u{73}\u{2060}\u{2060}",
        &["\u{2060}\u{55}\u{2060}\u{2e}\u{2060}\u{53}\u{2060}\u{2e}\u{2060}\u{41}\u{2060}\u{300}\u{2e}\u{2060}\u{20}\u{2060}\u{69}\u{2060}\u{73}\u{2060}\u{2060}"]),
        ("\u{2060}\u{55}\u{2060}\u{2e}\u{2060}\u{53}\u{2060}\u{2e}\u{2060}\u{41}\u{2060}\u{300}\u{3f}\u{2060}\u{20}\u{2060}\u{48}\u{2060}\u{65}\u{2060}\u{2060}",
        &["\u{2060}\u{55}\u{2060}\u{2e}\u{2060}\u{53}\u{2060}\u{2e}\u{2060}\u{41}\u{2060}\u{300}\u{3f}\u{2060}\u{20}\u{2060}",
        "\u{48}\u{2060}\u{65}\u{2060}\u{2060}"]),
        ("\u{2060}\u{55}\u{2060}\u{2e}\u{2060}\u{53}\u{2060}\u{2e}\u{2060}\u{41}\u{2060}\u{300}\u{2e}\u{2060}\u{2060}",
        &["\u{2060}\u{55}\u{2060}\u{2e}\u{2060}\u{53}\u{2060}\u{2e}\u{2060}\u{41}\u{2060}\u{300}\u{2e}\u{2060}\u{2060}"]),
        ("\u{2060}\u{33}\u{2060}\u{2e}\u{2060}\u{34}\u{2060}\u{2060}",
        &["\u{2060}\u{33}\u{2060}\u{2e}\u{2060}\u{34}\u{2060}\u{2060}"]),
        ("\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{64}\u{2060}\u{2060}",
        &["\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{64}\u{2060}\u{2060}"]),
        ("\u{2060}\u{43}\u{2060}\u{2e}\u{2060}\u{64}\u{2060}\u{2060}",
        &["\u{2060}\u{43}\u{2060}\u{2e}\u{2060}\u{64}\u{2060}\u{2060}"]),
        ("\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{44}\u{2060}\u{2060}",
        &["\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{44}\u{2060}\u{2060}"]),
        ("\u{2060}\u{43}\u{2060}\u{2e}\u{2060}\u{44}\u{2060}\u{2060}",
        &["\u{2060}\u{43}\u{2060}\u{2e}\u{2060}\u{44}\u{2060}\u{2060}"]),
        ("\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{a0}\u{2060}\u{74}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}",
        &["\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{a0}\u{2060}\u{74}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}"]),
        ("\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{a0}\u{2060}\u{54}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}",
        &["\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{a0}\u{2060}",
        "\u{54}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}"]),
        ("\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{a0}\u{2060}\u{2018}\u{2060}\u{28}\u{2060}\u{74}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}",
        &["\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{a0}\u{2060}\u{2018}\u{2060}\u{28}\u{2060}\u{74}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}"]),
        ("\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{a0}\u{2060}\u{2018}\u{2060}\u{28}\u{2060}\u{54}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}",
        &["\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{a0}\u{2060}",
        "\u{2018}\u{2060}\u{28}\u{2060}\u{54}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}"]),
        ("\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{a0}\u{2060}\u{308}\u{74}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}",
        &["\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{a0}\u{2060}\u{308}\u{74}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}"]),
        ("\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{a0}\u{2060}\u{308}\u{54}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}",
        &["\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{a0}\u{2060}\u{308}",
        "\u{54}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}"]),
        ("\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{308}\u{54}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}",
        &["\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{2019}\u{2060}\u{308}",
        "\u{54}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}"]),
        ("\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{a}\u{2060}\u{308}\u{2060}\u{54}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}",
        &["\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{29}\u{2060}\u{a}",
        "\u{2060}\u{308}\u{2060}\u{54}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{2060}"]),
        ("\u{2060}\u{74}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{20}\u{2060}\u{72}\u{2060}\u{65}\u{2060}\u{73}\u{2060}\u{70}\u{2060}\u{2e}\u{2060}\u{20}\u{2060}\u{6c}\u{2060}\u{65}\u{2060}\u{61}\u{2060}\u{64}\u{2060}\u{65}\u{2060}\u{72}\u{2060}\u{73}\u{2060}\u{20}\u{2060}\u{61}\u{2060}\u{72}\u{2060}\u{65}\u{2060}\u{2060}",
        &["\u{2060}\u{74}\u{2060}\u{68}\u{2060}\u{65}\u{2060}\u{20}\u{2060}\u{72}\u{2060}\u{65}\u{2060}\u{73}\u{2060}\u{70}\u{2060}\u{2e}\u{2060}\u{20}\u{2060}\u{6c}\u{2060}\u{65}\u{2060}\u{61}\u{2060}\u{64}\u{2060}\u{65}\u{2060}\u{72}\u{2060}\u{73}\u{2060}\u{20}\u{2060}\u{61}\u{2060}\u{72}\u{2060}\u{65}\u{2060}\u{2060}"]),
        ("\u{2060}\u{5b57}\u{2060}\u{2e}\u{2060}\u{5b57}\u{2060}\u{2060}",
        &["\u{2060}\u{5b57}\u{2060}\u{2e}\u{2060}", "\u{5b57}\u{2060}\u{2060}"]),
        ("\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{5b83}\u{2060}\u{2060}",
        &["\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}",
        "\u{5b83}\u{2060}\u{2060}"]),
        ("\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{3002}\u{2060}\u{2060}",
        &["\u{2060}\u{65}\u{2060}\u{74}\u{2060}\u{63}\u{2060}\u{2e}\u{2060}\u{3002}\u{2060}\u{2060}"]),
        ("\u{2060}\u{5b57}\u{2060}\u{3002}\u{2060}\u{5b83}\u{2060}\u{2060}",
        &["\u{2060}\u{5b57}\u{2060}\u{3002}\u{2060}", "\u{5b83}\u{2060}\u{2060}"]),
        ("\u{2060}\u{21}\u{2060}\u{20}\u{2060}\u{20}\u{2060}\u{2060}",
        &["\u{2060}\u{21}\u{2060}\u{20}\u{2060}\u{20}\u{2060}\u{2060}"])
    ];

