/// Available AEAD algorithms.
#[derive(Debug, PartialEq, Eq, Copy, Clone, FromPrimitive)]
#[repr(u8)]
pub enum AeadAlgorithm {
    /// None
    None = 0,
    Eax = 1,
    Ocb = 2,
}

impl Default for AeadAlgorithm {
    fn default() -> Self {
        AeadAlgorithm::None
    }
}
