// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/cloud/aiplatform/v1beta1/schema/dataset_metadata.proto

package schema

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The metadata of Datasets that contain Image DataItems.
type ImageDatasetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Points to a YAML file stored on Google Cloud Storage describing payload of
	// the Image DataItems that belong to this Dataset.
	DataItemSchemaUri string `protobuf:"bytes,1,opt,name=data_item_schema_uri,json=dataItemSchemaUri,proto3" json:"data_item_schema_uri,omitempty"`
	// Google Cloud Storage Bucket name that contains the blob data of this
	// Dataset.
	GcsBucket string `protobuf:"bytes,2,opt,name=gcs_bucket,json=gcsBucket,proto3" json:"gcs_bucket,omitempty"`
}

func (x *ImageDatasetMetadata) Reset() {
	*x = ImageDatasetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageDatasetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageDatasetMetadata) ProtoMessage() {}

func (x *ImageDatasetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageDatasetMetadata.ProtoReflect.Descriptor instead.
func (*ImageDatasetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *ImageDatasetMetadata) GetDataItemSchemaUri() string {
	if x != nil {
		return x.DataItemSchemaUri
	}
	return ""
}

func (x *ImageDatasetMetadata) GetGcsBucket() string {
	if x != nil {
		return x.GcsBucket
	}
	return ""
}

// The metadata of Datasets that contain Text DataItems.
type TextDatasetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Points to a YAML file stored on Google Cloud Storage describing payload of
	// the Text DataItems that belong to this Dataset.
	DataItemSchemaUri string `protobuf:"bytes,1,opt,name=data_item_schema_uri,json=dataItemSchemaUri,proto3" json:"data_item_schema_uri,omitempty"`
	// Google Cloud Storage Bucket name that contains the blob data of this
	// Dataset.
	GcsBucket string `protobuf:"bytes,2,opt,name=gcs_bucket,json=gcsBucket,proto3" json:"gcs_bucket,omitempty"`
}

func (x *TextDatasetMetadata) Reset() {
	*x = TextDatasetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextDatasetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextDatasetMetadata) ProtoMessage() {}

func (x *TextDatasetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextDatasetMetadata.ProtoReflect.Descriptor instead.
func (*TextDatasetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescGZIP(), []int{1}
}

func (x *TextDatasetMetadata) GetDataItemSchemaUri() string {
	if x != nil {
		return x.DataItemSchemaUri
	}
	return ""
}

func (x *TextDatasetMetadata) GetGcsBucket() string {
	if x != nil {
		return x.GcsBucket
	}
	return ""
}

// The metadata of Datasets that contain Video DataItems.
type VideoDatasetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Points to a YAML file stored on Google Cloud Storage describing payload of
	// the Video DataItems that belong to this Dataset.
	DataItemSchemaUri string `protobuf:"bytes,1,opt,name=data_item_schema_uri,json=dataItemSchemaUri,proto3" json:"data_item_schema_uri,omitempty"`
	// Google Cloud Storage Bucket name that contains the blob data of this
	// Dataset.
	GcsBucket string `protobuf:"bytes,2,opt,name=gcs_bucket,json=gcsBucket,proto3" json:"gcs_bucket,omitempty"`
}

func (x *VideoDatasetMetadata) Reset() {
	*x = VideoDatasetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoDatasetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoDatasetMetadata) ProtoMessage() {}

func (x *VideoDatasetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoDatasetMetadata.ProtoReflect.Descriptor instead.
func (*VideoDatasetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescGZIP(), []int{2}
}

func (x *VideoDatasetMetadata) GetDataItemSchemaUri() string {
	if x != nil {
		return x.DataItemSchemaUri
	}
	return ""
}

func (x *VideoDatasetMetadata) GetGcsBucket() string {
	if x != nil {
		return x.GcsBucket
	}
	return ""
}

// The metadata of Datasets that contain tables data.
type TablesDatasetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	InputConfig *TablesDatasetMetadata_InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
}

func (x *TablesDatasetMetadata) Reset() {
	*x = TablesDatasetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TablesDatasetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TablesDatasetMetadata) ProtoMessage() {}

func (x *TablesDatasetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TablesDatasetMetadata.ProtoReflect.Descriptor instead.
func (*TablesDatasetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescGZIP(), []int{3}
}

func (x *TablesDatasetMetadata) GetInputConfig() *TablesDatasetMetadata_InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

// The metadata of Datasets that contain time series data.
type TimeSeriesDatasetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	InputConfig *TimeSeriesDatasetMetadata_InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// The column name of the time series identifier column that identifies the
	// time series.
	TimeSeriesIdentifierColumn string `protobuf:"bytes,2,opt,name=time_series_identifier_column,json=timeSeriesIdentifierColumn,proto3" json:"time_series_identifier_column,omitempty"`
	// The column name of the time column that identifies time order in the time
	// series.
	TimeColumn string `protobuf:"bytes,3,opt,name=time_column,json=timeColumn,proto3" json:"time_column,omitempty"`
}

func (x *TimeSeriesDatasetMetadata) Reset() {
	*x = TimeSeriesDatasetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSeriesDatasetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeriesDatasetMetadata) ProtoMessage() {}

func (x *TimeSeriesDatasetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSeriesDatasetMetadata.ProtoReflect.Descriptor instead.
func (*TimeSeriesDatasetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescGZIP(), []int{4}
}

func (x *TimeSeriesDatasetMetadata) GetInputConfig() *TimeSeriesDatasetMetadata_InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *TimeSeriesDatasetMetadata) GetTimeSeriesIdentifierColumn() string {
	if x != nil {
		return x.TimeSeriesIdentifierColumn
	}
	return ""
}

func (x *TimeSeriesDatasetMetadata) GetTimeColumn() string {
	if x != nil {
		return x.TimeColumn
	}
	return ""
}

// The tables Dataset's data source. The Dataset doesn't store the data
// directly, but only pointer(s) to its data.
type TablesDatasetMetadata_InputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//	*TablesDatasetMetadata_InputConfig_GcsSource
	//	*TablesDatasetMetadata_InputConfig_BigquerySource
	Source isTablesDatasetMetadata_InputConfig_Source `protobuf_oneof:"source"`
}

func (x *TablesDatasetMetadata_InputConfig) Reset() {
	*x = TablesDatasetMetadata_InputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TablesDatasetMetadata_InputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TablesDatasetMetadata_InputConfig) ProtoMessage() {}

func (x *TablesDatasetMetadata_InputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TablesDatasetMetadata_InputConfig.ProtoReflect.Descriptor instead.
func (*TablesDatasetMetadata_InputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescGZIP(), []int{3, 0}
}

func (m *TablesDatasetMetadata_InputConfig) GetSource() isTablesDatasetMetadata_InputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *TablesDatasetMetadata_InputConfig) GetGcsSource() *TablesDatasetMetadata_GcsSource {
	if x, ok := x.GetSource().(*TablesDatasetMetadata_InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *TablesDatasetMetadata_InputConfig) GetBigquerySource() *TablesDatasetMetadata_BigQuerySource {
	if x, ok := x.GetSource().(*TablesDatasetMetadata_InputConfig_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

type isTablesDatasetMetadata_InputConfig_Source interface {
	isTablesDatasetMetadata_InputConfig_Source()
}

type TablesDatasetMetadata_InputConfig_GcsSource struct {
	GcsSource *TablesDatasetMetadata_GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type TablesDatasetMetadata_InputConfig_BigquerySource struct {
	BigquerySource *TablesDatasetMetadata_BigQuerySource `protobuf:"bytes,2,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*TablesDatasetMetadata_InputConfig_GcsSource) isTablesDatasetMetadata_InputConfig_Source() {}

func (*TablesDatasetMetadata_InputConfig_BigquerySource) isTablesDatasetMetadata_InputConfig_Source() {
}

type TablesDatasetMetadata_GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Storage URI of one or more files. Only CSV files are supported.
	// The first line of the CSV file is used as the header.
	// If there are multiple files, the header is the first line of
	// the lexicographically first file, the other files must either
	// contain the exact same header or omit the header.
	Uri []string `protobuf:"bytes,1,rep,name=uri,proto3" json:"uri,omitempty"`
}

func (x *TablesDatasetMetadata_GcsSource) Reset() {
	*x = TablesDatasetMetadata_GcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TablesDatasetMetadata_GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TablesDatasetMetadata_GcsSource) ProtoMessage() {}

func (x *TablesDatasetMetadata_GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TablesDatasetMetadata_GcsSource.ProtoReflect.Descriptor instead.
func (*TablesDatasetMetadata_GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescGZIP(), []int{3, 1}
}

func (x *TablesDatasetMetadata_GcsSource) GetUri() []string {
	if x != nil {
		return x.Uri
	}
	return nil
}

type TablesDatasetMetadata_BigQuerySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of a BigQuery table.
	// e.g. bq://projectId.bqDatasetId.bqTableId
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *TablesDatasetMetadata_BigQuerySource) Reset() {
	*x = TablesDatasetMetadata_BigQuerySource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TablesDatasetMetadata_BigQuerySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TablesDatasetMetadata_BigQuerySource) ProtoMessage() {}

func (x *TablesDatasetMetadata_BigQuerySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TablesDatasetMetadata_BigQuerySource.ProtoReflect.Descriptor instead.
func (*TablesDatasetMetadata_BigQuerySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescGZIP(), []int{3, 2}
}

func (x *TablesDatasetMetadata_BigQuerySource) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// The time series Dataset's data source. The Dataset doesn't store the data
// directly, but only pointer(s) to its data.
type TimeSeriesDatasetMetadata_InputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//	*TimeSeriesDatasetMetadata_InputConfig_GcsSource
	//	*TimeSeriesDatasetMetadata_InputConfig_BigquerySource
	Source isTimeSeriesDatasetMetadata_InputConfig_Source `protobuf_oneof:"source"`
}

func (x *TimeSeriesDatasetMetadata_InputConfig) Reset() {
	*x = TimeSeriesDatasetMetadata_InputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSeriesDatasetMetadata_InputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeriesDatasetMetadata_InputConfig) ProtoMessage() {}

func (x *TimeSeriesDatasetMetadata_InputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSeriesDatasetMetadata_InputConfig.ProtoReflect.Descriptor instead.
func (*TimeSeriesDatasetMetadata_InputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescGZIP(), []int{4, 0}
}

func (m *TimeSeriesDatasetMetadata_InputConfig) GetSource() isTimeSeriesDatasetMetadata_InputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *TimeSeriesDatasetMetadata_InputConfig) GetGcsSource() *TimeSeriesDatasetMetadata_GcsSource {
	if x, ok := x.GetSource().(*TimeSeriesDatasetMetadata_InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *TimeSeriesDatasetMetadata_InputConfig) GetBigquerySource() *TimeSeriesDatasetMetadata_BigQuerySource {
	if x, ok := x.GetSource().(*TimeSeriesDatasetMetadata_InputConfig_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

type isTimeSeriesDatasetMetadata_InputConfig_Source interface {
	isTimeSeriesDatasetMetadata_InputConfig_Source()
}

type TimeSeriesDatasetMetadata_InputConfig_GcsSource struct {
	GcsSource *TimeSeriesDatasetMetadata_GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type TimeSeriesDatasetMetadata_InputConfig_BigquerySource struct {
	BigquerySource *TimeSeriesDatasetMetadata_BigQuerySource `protobuf:"bytes,2,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*TimeSeriesDatasetMetadata_InputConfig_GcsSource) isTimeSeriesDatasetMetadata_InputConfig_Source() {
}

func (*TimeSeriesDatasetMetadata_InputConfig_BigquerySource) isTimeSeriesDatasetMetadata_InputConfig_Source() {
}

type TimeSeriesDatasetMetadata_GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Storage URI of one or more files. Only CSV files are supported.
	// The first line of the CSV file is used as the header.
	// If there are multiple files, the header is the first line of
	// the lexicographically first file, the other files must either
	// contain the exact same header or omit the header.
	Uri []string `protobuf:"bytes,1,rep,name=uri,proto3" json:"uri,omitempty"`
}

func (x *TimeSeriesDatasetMetadata_GcsSource) Reset() {
	*x = TimeSeriesDatasetMetadata_GcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSeriesDatasetMetadata_GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeriesDatasetMetadata_GcsSource) ProtoMessage() {}

func (x *TimeSeriesDatasetMetadata_GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSeriesDatasetMetadata_GcsSource.ProtoReflect.Descriptor instead.
func (*TimeSeriesDatasetMetadata_GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescGZIP(), []int{4, 1}
}

func (x *TimeSeriesDatasetMetadata_GcsSource) GetUri() []string {
	if x != nil {
		return x.Uri
	}
	return nil
}

type TimeSeriesDatasetMetadata_BigQuerySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of a BigQuery table.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *TimeSeriesDatasetMetadata_BigQuerySource) Reset() {
	*x = TimeSeriesDatasetMetadata_BigQuerySource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSeriesDatasetMetadata_BigQuerySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeriesDatasetMetadata_BigQuerySource) ProtoMessage() {}

func (x *TimeSeriesDatasetMetadata_BigQuerySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSeriesDatasetMetadata_BigQuerySource.ProtoReflect.Descriptor instead.
func (*TimeSeriesDatasetMetadata_BigQuerySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescGZIP(), []int{4, 2}
}

func (x *TimeSeriesDatasetMetadata_BigQuerySource) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x66, 0x0a, 0x14, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a,
	0x14, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x64, 0x61, 0x74,
	0x61, 0x49, 0x74, 0x65, 0x6d, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x55, 0x72, 0x69, 0x12, 0x1d,
	0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x67, 0x63, 0x73, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x22, 0x65, 0x0a,
	0x13, 0x54, 0x65, 0x78, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65,
	0x6d, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x55, 0x72, 0x69, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x63, 0x73, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x22, 0x66, 0x0a, 0x14, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x14,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61,
	0x49, 0x74, 0x65, 0x6d, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x55, 0x72, 0x69, 0x12, 0x1d, 0x0a,
	0x0a, 0x67, 0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x67, 0x63, 0x73, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x22, 0xc5, 0x03, 0x0a,
	0x15, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x6c, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x1a, 0xfa, 0x01, 0x0a, 0x0b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x68, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x77,
	0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x1a, 0x1d, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x1a, 0x22, 0x0a, 0x0e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x75, 0x72, 0x69, 0x22, 0xb9, 0x04, 0x0a, 0x19, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x70, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x41, 0x0a, 0x1d, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a, 0x74, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x69,
	0x6d, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x1a, 0x82, 0x02, 0x0a, 0x0b, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6c, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x7b, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x1d, 0x0a,
	0x09, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72,
	0x69, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x1a, 0x22, 0x0a, 0x0e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x42, 0x92, 0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42,
	0x14, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x3b, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_goTypes = []interface{}{
	(*ImageDatasetMetadata)(nil),                     // 0: google.cloud.aiplatform.v1beta1.schema.ImageDatasetMetadata
	(*TextDatasetMetadata)(nil),                      // 1: google.cloud.aiplatform.v1beta1.schema.TextDatasetMetadata
	(*VideoDatasetMetadata)(nil),                     // 2: google.cloud.aiplatform.v1beta1.schema.VideoDatasetMetadata
	(*TablesDatasetMetadata)(nil),                    // 3: google.cloud.aiplatform.v1beta1.schema.TablesDatasetMetadata
	(*TimeSeriesDatasetMetadata)(nil),                // 4: google.cloud.aiplatform.v1beta1.schema.TimeSeriesDatasetMetadata
	(*TablesDatasetMetadata_InputConfig)(nil),        // 5: google.cloud.aiplatform.v1beta1.schema.TablesDatasetMetadata.InputConfig
	(*TablesDatasetMetadata_GcsSource)(nil),          // 6: google.cloud.aiplatform.v1beta1.schema.TablesDatasetMetadata.GcsSource
	(*TablesDatasetMetadata_BigQuerySource)(nil),     // 7: google.cloud.aiplatform.v1beta1.schema.TablesDatasetMetadata.BigQuerySource
	(*TimeSeriesDatasetMetadata_InputConfig)(nil),    // 8: google.cloud.aiplatform.v1beta1.schema.TimeSeriesDatasetMetadata.InputConfig
	(*TimeSeriesDatasetMetadata_GcsSource)(nil),      // 9: google.cloud.aiplatform.v1beta1.schema.TimeSeriesDatasetMetadata.GcsSource
	(*TimeSeriesDatasetMetadata_BigQuerySource)(nil), // 10: google.cloud.aiplatform.v1beta1.schema.TimeSeriesDatasetMetadata.BigQuerySource
}
var file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_depIdxs = []int32{
	5,  // 0: google.cloud.aiplatform.v1beta1.schema.TablesDatasetMetadata.input_config:type_name -> google.cloud.aiplatform.v1beta1.schema.TablesDatasetMetadata.InputConfig
	8,  // 1: google.cloud.aiplatform.v1beta1.schema.TimeSeriesDatasetMetadata.input_config:type_name -> google.cloud.aiplatform.v1beta1.schema.TimeSeriesDatasetMetadata.InputConfig
	6,  // 2: google.cloud.aiplatform.v1beta1.schema.TablesDatasetMetadata.InputConfig.gcs_source:type_name -> google.cloud.aiplatform.v1beta1.schema.TablesDatasetMetadata.GcsSource
	7,  // 3: google.cloud.aiplatform.v1beta1.schema.TablesDatasetMetadata.InputConfig.bigquery_source:type_name -> google.cloud.aiplatform.v1beta1.schema.TablesDatasetMetadata.BigQuerySource
	9,  // 4: google.cloud.aiplatform.v1beta1.schema.TimeSeriesDatasetMetadata.InputConfig.gcs_source:type_name -> google.cloud.aiplatform.v1beta1.schema.TimeSeriesDatasetMetadata.GcsSource
	10, // 5: google.cloud.aiplatform.v1beta1.schema.TimeSeriesDatasetMetadata.InputConfig.bigquery_source:type_name -> google.cloud.aiplatform.v1beta1.schema.TimeSeriesDatasetMetadata.BigQuerySource
	6,  // [6:6] is the sub-list for method output_type
	6,  // [6:6] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_init() }
func file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageDatasetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextDatasetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoDatasetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TablesDatasetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSeriesDatasetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TablesDatasetMetadata_InputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TablesDatasetMetadata_GcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TablesDatasetMetadata_BigQuerySource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSeriesDatasetMetadata_InputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSeriesDatasetMetadata_GcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSeriesDatasetMetadata_BigQuerySource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*TablesDatasetMetadata_InputConfig_GcsSource)(nil),
		(*TablesDatasetMetadata_InputConfig_BigquerySource)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*TimeSeriesDatasetMetadata_InputConfig_GcsSource)(nil),
		(*TimeSeriesDatasetMetadata_InputConfig_BigquerySource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto = out.File
	file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_schema_dataset_metadata_proto_depIdxs = nil
}
