// DO NOT EDIT: This file is autogenerated via the builtin command.

package naiveBayesClassifier

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   89,
				},
				File:   "naiveBayesClassifier.flux",
				Source: "package naiveBayesClassifier\n\nimport \"system\"\n\nnaiveBayes = (tables=<-, myClass, myField, myMeasurement) => {\n \ntraining_data = tables\n  |> range(start:2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z) //data for 3 days \n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n  |> group()\n  //|> yield(name: \"trainingData\")\n\ntest_data = tables\n  |> range(start:2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z) //data for 1 day\n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n  |> group()\n  //|> yield(name: \"test data\")\n\n//data preparation \nr = training_data\n\t|> group(columns: [\"_field\"])\n\t|> count()\n\t|> tableFind(fn: (key) =>\n\t\t(key._field == myField))\nr2 = getRecord(table: r, idx: 0)\ntotal_count = r2._value\nP_Class_k = training_data\n\t|> group(columns: [myClass, \"_field\"])\n\t|> count()\n\t|> map(fn: (r) =>\n\t\t({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))\n\t|> group()\n\n//one table for each class, where r.p_k == P(Class_k)\nP_value_x = training_data\n\t|> group(columns: [\"_value\", \"_field\"])\n\t|> count(column: myClass)\n\t|> map(fn: (r) =>\n\t\t({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))\n\n// one table for each value, where r.p_x == P(value_x)\nP_k_x = training_data\n\t|> group(columns: [\"_field\",\"_value\", myClass])\n\t|> reduce(fn: (r, accumulator) =>\n\t\t({sum: 1.0 + accumulator.sum}), identity: {sum: 0.0})\n\t|> group()\n\n// one table for each value and Class pair, where r.p_k_x == P(value_x | Class_k)\nP_k_x_class = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t  |> limit(n: 1)\n\n\t  |> map(fn: (r) =>\n\t\t  ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])\n    |> rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})\n\nP_k_x_class_Drop = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t|> limit(n: 1)\n\n\t|> map(fn: (r) =>\n\t\t({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n\n//added P(value_x) to table\n//calculated probabilities for training data \nProbability_table = join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")\n\t|> map(fn: (r) =>\n\t\t({r with Probability: r.P_x_k * r.p_k / r.p_x}))\n\t\n \t//|> yield(name: \"final\")\n\n//predictions for test data computed \npredictOverall = (tables=<-) => {\n  r = tables\n    |> keep(columns: [\"_value\", \"Animal_name\",\"_field\"])\n\n  output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n  return output \n}\n\nreturn test_data |> predictOverall() \n\n}",
				Start: ast.Position{
					Column: 1,
					Line:   5,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   89,
					},
					File:   "naiveBayesClassifier.flux",
					Source: "naiveBayes = (tables=<-, myClass, myField, myMeasurement) => {\n \ntraining_data = tables\n  |> range(start:2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z) //data for 3 days \n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n  |> group()\n  //|> yield(name: \"trainingData\")\n\ntest_data = tables\n  |> range(start:2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z) //data for 1 day\n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n  |> group()\n  //|> yield(name: \"test data\")\n\n//data preparation \nr = training_data\n\t|> group(columns: [\"_field\"])\n\t|> count()\n\t|> tableFind(fn: (key) =>\n\t\t(key._field == myField))\nr2 = getRecord(table: r, idx: 0)\ntotal_count = r2._value\nP_Class_k = training_data\n\t|> group(columns: [myClass, \"_field\"])\n\t|> count()\n\t|> map(fn: (r) =>\n\t\t({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))\n\t|> group()\n\n//one table for each class, where r.p_k == P(Class_k)\nP_value_x = training_data\n\t|> group(columns: [\"_value\", \"_field\"])\n\t|> count(column: myClass)\n\t|> map(fn: (r) =>\n\t\t({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))\n\n// one table for each value, where r.p_x == P(value_x)\nP_k_x = training_data\n\t|> group(columns: [\"_field\",\"_value\", myClass])\n\t|> reduce(fn: (r, accumulator) =>\n\t\t({sum: 1.0 + accumulator.sum}), identity: {sum: 0.0})\n\t|> group()\n\n// one table for each value and Class pair, where r.p_k_x == P(value_x | Class_k)\nP_k_x_class = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t  |> limit(n: 1)\n\n\t  |> map(fn: (r) =>\n\t\t  ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])\n    |> rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})\n\nP_k_x_class_Drop = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t|> limit(n: 1)\n\n\t|> map(fn: (r) =>\n\t\t({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n\n//added P(value_x) to table\n//calculated probabilities for training data \nProbability_table = join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")\n\t|> map(fn: (r) =>\n\t\t({r with Probability: r.P_x_k * r.p_k / r.p_x}))\n\t\n \t//|> yield(name: \"final\")\n\n//predictions for test data computed \npredictOverall = (tables=<-) => {\n  r = tables\n    |> keep(columns: [\"_value\", \"Animal_name\",\"_field\"])\n\n  output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n  return output \n}\n\nreturn test_data |> predictOverall() \n\n}",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   9,
						},
						File:   "naiveBayesClassifier.flux",
						Source: "naiveBayes",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "naiveBayes",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   89,
						},
						File:   "naiveBayesClassifier.flux",
						Source: "(tables=<-, myClass, myField, myMeasurement) => {\n \ntraining_data = tables\n  |> range(start:2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z) //data for 3 days \n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n  |> group()\n  //|> yield(name: \"trainingData\")\n\ntest_data = tables\n  |> range(start:2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z) //data for 1 day\n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n  |> group()\n  //|> yield(name: \"test data\")\n\n//data preparation \nr = training_data\n\t|> group(columns: [\"_field\"])\n\t|> count()\n\t|> tableFind(fn: (key) =>\n\t\t(key._field == myField))\nr2 = getRecord(table: r, idx: 0)\ntotal_count = r2._value\nP_Class_k = training_data\n\t|> group(columns: [myClass, \"_field\"])\n\t|> count()\n\t|> map(fn: (r) =>\n\t\t({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))\n\t|> group()\n\n//one table for each class, where r.p_k == P(Class_k)\nP_value_x = training_data\n\t|> group(columns: [\"_value\", \"_field\"])\n\t|> count(column: myClass)\n\t|> map(fn: (r) =>\n\t\t({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))\n\n// one table for each value, where r.p_x == P(value_x)\nP_k_x = training_data\n\t|> group(columns: [\"_field\",\"_value\", myClass])\n\t|> reduce(fn: (r, accumulator) =>\n\t\t({sum: 1.0 + accumulator.sum}), identity: {sum: 0.0})\n\t|> group()\n\n// one table for each value and Class pair, where r.p_k_x == P(value_x | Class_k)\nP_k_x_class = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t  |> limit(n: 1)\n\n\t  |> map(fn: (r) =>\n\t\t  ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])\n    |> rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})\n\nP_k_x_class_Drop = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t|> limit(n: 1)\n\n\t|> map(fn: (r) =>\n\t\t({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n\n//added P(value_x) to table\n//calculated probabilities for training data \nProbability_table = join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")\n\t|> map(fn: (r) =>\n\t\t({r with Probability: r.P_x_k * r.p_k / r.p_x}))\n\t\n \t//|> yield(name: \"final\")\n\n//predictions for test data computed \npredictOverall = (tables=<-) => {\n  r = tables\n    |> keep(columns: [\"_value\", \"Animal_name\",\"_field\"])\n\n  output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n  return output \n}\n\nreturn test_data |> predictOverall() \n\n}",
						Start: ast.Position{
							Column: 14,
							Line:   9,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   89,
							},
							File:   "naiveBayesClassifier.flux",
							Source: "{\n \ntraining_data = tables\n  |> range(start:2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z) //data for 3 days \n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n  |> group()\n  //|> yield(name: \"trainingData\")\n\ntest_data = tables\n  |> range(start:2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z) //data for 1 day\n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n  |> group()\n  //|> yield(name: \"test data\")\n\n//data preparation \nr = training_data\n\t|> group(columns: [\"_field\"])\n\t|> count()\n\t|> tableFind(fn: (key) =>\n\t\t(key._field == myField))\nr2 = getRecord(table: r, idx: 0)\ntotal_count = r2._value\nP_Class_k = training_data\n\t|> group(columns: [myClass, \"_field\"])\n\t|> count()\n\t|> map(fn: (r) =>\n\t\t({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))\n\t|> group()\n\n//one table for each class, where r.p_k == P(Class_k)\nP_value_x = training_data\n\t|> group(columns: [\"_value\", \"_field\"])\n\t|> count(column: myClass)\n\t|> map(fn: (r) =>\n\t\t({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))\n\n// one table for each value, where r.p_x == P(value_x)\nP_k_x = training_data\n\t|> group(columns: [\"_field\",\"_value\", myClass])\n\t|> reduce(fn: (r, accumulator) =>\n\t\t({sum: 1.0 + accumulator.sum}), identity: {sum: 0.0})\n\t|> group()\n\n// one table for each value and Class pair, where r.p_k_x == P(value_x | Class_k)\nP_k_x_class = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t  |> limit(n: 1)\n\n\t  |> map(fn: (r) =>\n\t\t  ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])\n    |> rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})\n\nP_k_x_class_Drop = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t|> limit(n: 1)\n\n\t|> map(fn: (r) =>\n\t\t({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n\n//added P(value_x) to table\n//calculated probabilities for training data \nProbability_table = join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")\n\t|> map(fn: (r) =>\n\t\t({r with Probability: r.P_x_k * r.p_k / r.p_x}))\n\t\n \t//|> yield(name: \"final\")\n\n//predictions for test data computed \npredictOverall = (tables=<-) => {\n  r = tables\n    |> keep(columns: [\"_value\", \"Animal_name\",\"_field\"])\n\n  output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n  return output \n}\n\nreturn test_data |> predictOverall() \n\n}",
							Start: ast.Position{
								Column: 62,
								Line:   9,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   14,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "training_data = tables\n  |> range(start:2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z) //data for 3 days \n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n  |> group()",
								Start: ast.Position{
									Column: 1,
									Line:   11,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   11,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "training_data",
									Start: ast.Position{
										Column: 1,
										Line:   11,
									},
								},
							},
							Name: "training_data",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   11,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 17,
													Line:   11,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   12,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "tables\n  |> range(start:2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z)",
											Start: ast.Position{
												Column: 17,
												Line:   11,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   12,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "start:2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z",
													Start: ast.Position{
														Column: 12,
														Line:   12,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   12,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "start:2020-01-02T00:00:00Z",
														Start: ast.Position{
															Column: 12,
															Line:   12,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 17,
																Line:   12,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "start",
															Start: ast.Position{
																Column: 12,
																Line:   12,
															},
														},
													},
													Name: "start",
												},
												Separator: nil,
												Value: &ast.DateTimeLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   12,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "2020-01-02T00:00:00Z",
															Start: ast.Position{
																Column: 18,
																Line:   12,
															},
														},
													},
													Value: parser.MustParseTime("2020-01-02T00:00:00Z"),
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   12,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "stop: 2020-01-06T23:00:00Z",
														Start: ast.Position{
															Column: 40,
															Line:   12,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   12,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "stop",
															Start: ast.Position{
																Column: 40,
																Line:   12,
															},
														},
													},
													Name: "stop",
												},
												Separator: nil,
												Value: &ast.DateTimeLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   12,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "2020-01-06T23:00:00Z",
															Start: ast.Position{
																Column: 46,
																Line:   12,
															},
														},
													},
													Value: parser.MustParseTime("2020-01-06T23:00:00Z"),
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   12,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "range(start:2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z)",
												Start: ast.Position{
													Column: 6,
													Line:   12,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   12,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "range",
													Start: ast.Position{
														Column: 6,
														Line:   12,
													},
												},
											},
											Name: "range",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: []ast.Comment{ast.Comment{Text: "//data for 3 days \n"}},
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   13,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "tables\n  |> range(start:2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z) //data for 3 days \n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)",
										Start: ast.Position{
											Column: 17,
											Line:   11,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 85,
													Line:   13,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
												Start: ast.Position{
													Column: 13,
													Line:   13,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 85,
														Line:   13,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
													Start: ast.Position{
														Column: 13,
														Line:   13,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   13,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 13,
															Line:   13,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 85,
															Line:   13,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "(r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
														Start: ast.Position{
															Column: 17,
															Line:   13,
														},
													},
												},
												Body: &ast.LogicalExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 85,
																Line:   13,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
															Start: ast.Position{
																Column: 24,
																Line:   13,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   13,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r[\"_measurement\"] == myMeasurement",
																Start: ast.Position{
																	Column: 24,
																	Line:   13,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   13,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r[\"_measurement\"]",
																	Start: ast.Position{
																		Column: 24,
																		Line:   13,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   13,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 24,
																			Line:   13,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   13,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "\"_measurement\"",
																		Start: ast.Position{
																			Column: 26,
																			Line:   13,
																		},
																	},
																},
																Value: "_measurement",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   13,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "myMeasurement",
																	Start: ast.Position{
																		Column: 45,
																		Line:   13,
																	},
																},
															},
															Name: "myMeasurement",
														},
													},
													Operator: 1,
													Right: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 85,
																	Line:   13,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r[\"_field\"] == myField",
																Start: ast.Position{
																	Column: 63,
																	Line:   13,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   13,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r[\"_field\"]",
																	Start: ast.Position{
																		Column: 63,
																		Line:   13,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   13,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 63,
																			Line:   13,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 73,
																			Line:   13,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "\"_field\"",
																		Start: ast.Position{
																			Column: 65,
																			Line:   13,
																		},
																	},
																},
																Value: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 85,
																		Line:   13,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "myField",
																	Start: ast.Position{
																		Column: 78,
																		Line:   13,
																	},
																},
															},
															Name: "myField",
														},
													},
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   13,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 18,
																Line:   13,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   13,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 18,
																	Line:   13,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 86,
												Line:   13,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)",
											Start: ast.Position{
												Column: 6,
												Line:   13,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   13,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 6,
													Line:   13,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   14,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "tables\n  |> range(start:2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z) //data for 3 days \n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n  |> group()",
									Start: ast.Position{
										Column: 17,
										Line:   11,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   14,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "group()",
										Start: ast.Position{
											Column: 6,
											Line:   14,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   14,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "group",
											Start: ast.Position{
												Column: 6,
												Line:   14,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   20,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "test_data = tables\n  |> range(start:2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z) //data for 1 day\n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n  |> group()",
								Start: ast.Position{
									Column: 1,
									Line:   17,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "//|> yield(name: \"trainingData\")\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   17,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "test_data",
									Start: ast.Position{
										Column: 1,
										Line:   17,
									},
								},
							},
							Name: "test_data",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   17,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 13,
													Line:   17,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   18,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "tables\n  |> range(start:2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z)",
											Start: ast.Position{
												Column: 13,
												Line:   17,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   18,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "start:2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z",
													Start: ast.Position{
														Column: 12,
														Line:   18,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   18,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "start:2020-01-01T00:00:00Z",
														Start: ast.Position{
															Column: 12,
															Line:   18,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 17,
																Line:   18,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "start",
															Start: ast.Position{
																Column: 12,
																Line:   18,
															},
														},
													},
													Name: "start",
												},
												Separator: nil,
												Value: &ast.DateTimeLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   18,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "2020-01-01T00:00:00Z",
															Start: ast.Position{
																Column: 18,
																Line:   18,
															},
														},
													},
													Value: parser.MustParseTime("2020-01-01T00:00:00Z"),
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   18,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "stop: 2020-01-01T23:00:00Z",
														Start: ast.Position{
															Column: 40,
															Line:   18,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   18,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "stop",
															Start: ast.Position{
																Column: 40,
																Line:   18,
															},
														},
													},
													Name: "stop",
												},
												Separator: nil,
												Value: &ast.DateTimeLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   18,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "2020-01-01T23:00:00Z",
															Start: ast.Position{
																Column: 46,
																Line:   18,
															},
														},
													},
													Value: parser.MustParseTime("2020-01-01T23:00:00Z"),
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   18,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "range(start:2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z)",
												Start: ast.Position{
													Column: 6,
													Line:   18,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   18,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "range",
													Start: ast.Position{
														Column: 6,
														Line:   18,
													},
												},
											},
											Name: "range",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: []ast.Comment{ast.Comment{Text: "//data for 1 day\n"}},
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   19,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "tables\n  |> range(start:2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z) //data for 1 day\n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)",
										Start: ast.Position{
											Column: 13,
											Line:   17,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 85,
													Line:   19,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
												Start: ast.Position{
													Column: 13,
													Line:   19,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 85,
														Line:   19,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
													Start: ast.Position{
														Column: 13,
														Line:   19,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   19,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 13,
															Line:   19,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 85,
															Line:   19,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "(r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
														Start: ast.Position{
															Column: 17,
															Line:   19,
														},
													},
												},
												Body: &ast.LogicalExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 85,
																Line:   19,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
															Start: ast.Position{
																Column: 24,
																Line:   19,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   19,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r[\"_measurement\"] == myMeasurement",
																Start: ast.Position{
																	Column: 24,
																	Line:   19,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   19,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r[\"_measurement\"]",
																	Start: ast.Position{
																		Column: 24,
																		Line:   19,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   19,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 24,
																			Line:   19,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   19,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "\"_measurement\"",
																		Start: ast.Position{
																			Column: 26,
																			Line:   19,
																		},
																	},
																},
																Value: "_measurement",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   19,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "myMeasurement",
																	Start: ast.Position{
																		Column: 45,
																		Line:   19,
																	},
																},
															},
															Name: "myMeasurement",
														},
													},
													Operator: 1,
													Right: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 85,
																	Line:   19,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r[\"_field\"] == myField",
																Start: ast.Position{
																	Column: 63,
																	Line:   19,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   19,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r[\"_field\"]",
																	Start: ast.Position{
																		Column: 63,
																		Line:   19,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   19,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 63,
																			Line:   19,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 73,
																			Line:   19,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "\"_field\"",
																		Start: ast.Position{
																			Column: 65,
																			Line:   19,
																		},
																	},
																},
																Value: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 85,
																		Line:   19,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "myField",
																	Start: ast.Position{
																		Column: 78,
																		Line:   19,
																	},
																},
															},
															Name: "myField",
														},
													},
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   19,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 18,
																Line:   19,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   19,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 18,
																	Line:   19,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 86,
												Line:   19,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)",
											Start: ast.Position{
												Column: 6,
												Line:   19,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   19,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 6,
													Line:   19,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   20,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "tables\n  |> range(start:2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z) //data for 1 day\n  |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n  |> group()",
									Start: ast.Position{
										Column: 13,
										Line:   17,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   20,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "group()",
										Start: ast.Position{
											Column: 6,
											Line:   20,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   20,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "group",
											Start: ast.Position{
												Column: 6,
												Line:   20,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   28,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "r = training_data\n\t|> group(columns: [\"_field\"])\n\t|> count()\n\t|> tableFind(fn: (key) =>\n\t\t(key._field == myField))",
								Start: ast.Position{
									Column: 1,
									Line:   24,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "//|> yield(name: \"test data\")\n"}, ast.Comment{Text: "//data preparation \n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   24,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "r",
									Start: ast.Position{
										Column: 1,
										Line:   24,
									},
								},
							},
							Name: "r",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   24,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "training_data",
												Start: ast.Position{
													Column: 5,
													Line:   24,
												},
											},
										},
										Name: "training_data",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   25,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "training_data\n\t|> group(columns: [\"_field\"])",
											Start: ast.Position{
												Column: 5,
												Line:   24,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   25,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "columns: [\"_field\"]",
													Start: ast.Position{
														Column: 11,
														Line:   25,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   25,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [\"_field\"]",
														Start: ast.Position{
															Column: 11,
															Line:   25,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   25,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 11,
																Line:   25,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   25,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "[\"_field\"]",
															Start: ast.Position{
																Column: 20,
																Line:   25,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   25,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_field\"",
																Start: ast.Position{
																	Column: 21,
																	Line:   25,
																},
															},
														},
														Value: "_field",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   25,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "group(columns: [\"_field\"])",
												Start: ast.Position{
													Column: 5,
													Line:   25,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   25,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "group",
													Start: ast.Position{
														Column: 5,
														Line:   25,
													},
												},
											},
											Name: "group",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   26,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "training_data\n\t|> group(columns: [\"_field\"])\n\t|> count()",
										Start: ast.Position{
											Column: 5,
											Line:   24,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   26,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "count()",
											Start: ast.Position{
												Column: 5,
												Line:   26,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   26,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "count",
												Start: ast.Position{
													Column: 5,
													Line:   26,
												},
											},
										},
										Name: "count",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   28,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "training_data\n\t|> group(columns: [\"_field\"])\n\t|> count()\n\t|> tableFind(fn: (key) =>\n\t\t(key._field == myField))",
									Start: ast.Position{
										Column: 5,
										Line:   24,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   28,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "fn: (key) =>\n\t\t(key._field == myField)",
											Start: ast.Position{
												Column: 15,
												Line:   27,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   28,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (key) =>\n\t\t(key._field == myField)",
												Start: ast.Position{
													Column: 15,
													Line:   27,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   27,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 15,
														Line:   27,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   28,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "(key) =>\n\t\t(key._field == myField)",
													Start: ast.Position{
														Column: 19,
														Line:   27,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   28,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "(key._field == myField)",
														Start: ast.Position{
															Column: 3,
															Line:   28,
														},
													},
												},
												Expression: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   28,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "key._field == myField",
															Start: ast.Position{
																Column: 4,
																Line:   28,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   28,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "key._field",
																Start: ast.Position{
																	Column: 4,
																	Line:   28,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 7,
																		Line:   28,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "key",
																	Start: ast.Position{
																		Column: 4,
																		Line:   28,
																	},
																},
															},
															Name: "key",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 14,
																		Line:   28,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "_field",
																	Start: ast.Position{
																		Column: 8,
																		Line:   28,
																	},
																},
															},
															Name: "_field",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   28,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "myField",
																Start: ast.Position{
																	Column: 18,
																	Line:   28,
																},
															},
														},
														Name: "myField",
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   27,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "key",
														Start: ast.Position{
															Column: 20,
															Line:   27,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   27,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "key",
															Start: ast.Position{
																Column: 20,
																Line:   27,
															},
														},
													},
													Name: "key",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   28,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "tableFind(fn: (key) =>\n\t\t(key._field == myField))",
										Start: ast.Position{
											Column: 5,
											Line:   27,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   27,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "tableFind",
											Start: ast.Position{
												Column: 5,
												Line:   27,
											},
										},
									},
									Name: "tableFind",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   29,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "r2 = getRecord(table: r, idx: 0)",
								Start: ast.Position{
									Column: 1,
									Line:   29,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   29,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "r2",
									Start: ast.Position{
										Column: 1,
										Line:   29,
									},
								},
							},
							Name: "r2",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   29,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "table: r, idx: 0",
										Start: ast.Position{
											Column: 16,
											Line:   29,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   29,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "table: r",
											Start: ast.Position{
												Column: 16,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   29,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "table",
												Start: ast.Position{
													Column: 16,
													Line:   29,
												},
											},
										},
										Name: "table",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   29,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "r",
												Start: ast.Position{
													Column: 23,
													Line:   29,
												},
											},
										},
										Name: "r",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   29,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "idx: 0",
											Start: ast.Position{
												Column: 26,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   29,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "idx",
												Start: ast.Position{
													Column: 26,
													Line:   29,
												},
											},
										},
										Name: "idx",
									},
									Separator: nil,
									Value: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   29,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "0",
												Start: ast.Position{
													Column: 31,
													Line:   29,
												},
											},
										},
										Value: int64(0),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   29,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "getRecord(table: r, idx: 0)",
									Start: ast.Position{
										Column: 6,
										Line:   29,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   29,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "getRecord",
										Start: ast.Position{
											Column: 6,
											Line:   29,
										},
									},
								},
								Name: "getRecord",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   30,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "total_count = r2._value",
								Start: ast.Position{
									Column: 1,
									Line:   30,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   30,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "total_count",
									Start: ast.Position{
										Column: 1,
										Line:   30,
									},
								},
							},
							Name: "total_count",
						},
						Init: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   30,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "r2._value",
									Start: ast.Position{
										Column: 15,
										Line:   30,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   30,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "r2",
										Start: ast.Position{
											Column: 15,
											Line:   30,
										},
									},
								},
								Name: "r2",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   30,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "_value",
										Start: ast.Position{
											Column: 18,
											Line:   30,
										},
									},
								},
								Name: "_value",
							},
							Rbrack: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   36,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "P_Class_k = training_data\n\t|> group(columns: [myClass, \"_field\"])\n\t|> count()\n\t|> map(fn: (r) =>\n\t\t({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))\n\t|> group()",
								Start: ast.Position{
									Column: 1,
									Line:   31,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   31,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "P_Class_k",
									Start: ast.Position{
										Column: 1,
										Line:   31,
									},
								},
							},
							Name: "P_Class_k",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   31,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "training_data",
													Start: ast.Position{
														Column: 13,
														Line:   31,
													},
												},
											},
											Name: "training_data",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   32,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "training_data\n\t|> group(columns: [myClass, \"_field\"])",
												Start: ast.Position{
													Column: 13,
													Line:   31,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   32,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [myClass, \"_field\"]",
														Start: ast.Position{
															Column: 11,
															Line:   32,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   32,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns: [myClass, \"_field\"]",
															Start: ast.Position{
																Column: 11,
																Line:   32,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   32,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 11,
																	Line:   32,
																},
															},
														},
														Name: "columns",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   32,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "[myClass, \"_field\"]",
																Start: ast.Position{
																	Column: 20,
																	Line:   32,
																},
															},
														},
														Elements: []ast.Expression{&ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 28,
																		Line:   32,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "myClass",
																	Start: ast.Position{
																		Column: 21,
																		Line:   32,
																	},
																},
															},
															Name: "myClass",
														}, &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   32,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"_field\"",
																	Start: ast.Position{
																		Column: 30,
																		Line:   32,
																	},
																},
															},
															Value: "_field",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   32,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "group(columns: [myClass, \"_field\"])",
													Start: ast.Position{
														Column: 5,
														Line:   32,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   32,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "group",
														Start: ast.Position{
															Column: 5,
															Line:   32,
														},
													},
												},
												Name: "group",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   33,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "training_data\n\t|> group(columns: [myClass, \"_field\"])\n\t|> count()",
											Start: ast.Position{
												Column: 13,
												Line:   31,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   33,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "count()",
												Start: ast.Position{
													Column: 5,
													Line:   33,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   33,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "count",
													Start: ast.Position{
														Column: 5,
														Line:   33,
													},
												},
											},
											Name: "count",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 79,
											Line:   35,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "training_data\n\t|> group(columns: [myClass, \"_field\"])\n\t|> count()\n\t|> map(fn: (r) =>\n\t\t({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))",
										Start: ast.Position{
											Column: 13,
											Line:   31,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   35,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r) =>\n\t\t({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count})",
												Start: ast.Position{
													Column: 9,
													Line:   34,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   35,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn: (r) =>\n\t\t({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count})",
													Start: ast.Position{
														Column: 9,
														Line:   34,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   34,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 9,
															Line:   34,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   35,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "(r) =>\n\t\t({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count})",
														Start: ast.Position{
															Column: 13,
															Line:   34,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 78,
																Line:   35,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count})",
															Start: ast.Position{
																Column: 3,
																Line:   35,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   35,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "{r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}",
																Start: ast.Position{
																	Column: 4,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 59,
																		Line:   35,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "p_k: float(v: r._value) / float(v: total_count)",
																	Start: ast.Position{
																		Column: 12,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 15,
																			Line:   35,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "p_k",
																		Start: ast.Position{
																			Column: 12,
																			Line:   35,
																		},
																	},
																},
																Name: "p_k",
															},
															Separator: nil,
															Value: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   35,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "float(v: r._value) / float(v: total_count)",
																		Start: ast.Position{
																			Column: 17,
																			Line:   35,
																		},
																	},
																},
																Left: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   35,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 23,
																					Line:   35,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 34,
																						Line:   35,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "v: r._value",
																					Start: ast.Position{
																						Column: 23,
																						Line:   35,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 24,
																							Line:   35,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 23,
																							Line:   35,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 34,
																							Line:   35,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 26,
																							Line:   35,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 27,
																								Line:   35,
																							},
																							File:   "naiveBayesClassifier.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 26,
																								Line:   35,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 34,
																								Line:   35,
																							},
																							File:   "naiveBayesClassifier.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 28,
																								Line:   35,
																							},
																						},
																					},
																					Name: "_value",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 35,
																				Line:   35,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "float(v: r._value)",
																			Start: ast.Position{
																				Column: 17,
																				Line:   35,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 22,
																					Line:   35,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "float",
																				Start: ast.Position{
																					Column: 17,
																					Line:   35,
																				},
																			},
																		},
																		Name: "float",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
																Operator: 2,
																Right: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   35,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "v: total_count",
																				Start: ast.Position{
																					Column: 44,
																					Line:   35,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 58,
																						Line:   35,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "v: total_count",
																					Start: ast.Position{
																						Column: 44,
																						Line:   35,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 45,
																							Line:   35,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 44,
																							Line:   35,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 58,
																							Line:   35,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "total_count",
																						Start: ast.Position{
																							Column: 47,
																							Line:   35,
																						},
																					},
																				},
																				Name: "total_count",
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   35,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "float(v: total_count)",
																			Start: ast.Position{
																				Column: 38,
																				Line:   35,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 43,
																					Line:   35,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "float",
																				Start: ast.Position{
																					Column: 38,
																					Line:   35,
																				},
																			},
																		},
																		Name: "float",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 76,
																		Line:   35,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "tc: total_count",
																	Start: ast.Position{
																		Column: 61,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 63,
																			Line:   35,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "tc",
																		Start: ast.Position{
																			Column: 61,
																			Line:   35,
																		},
																	},
																},
																Name: "tc",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   35,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "total_count",
																		Start: ast.Position{
																			Column: 65,
																			Line:   35,
																		},
																	},
																},
																Name: "total_count",
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 6,
																		Line:   35,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 5,
																		Line:   35,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   34,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   34,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 15,
																	Line:   34,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 14,
																	Line:   34,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   35,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "map(fn: (r) =>\n\t\t({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))",
											Start: ast.Position{
												Column: 5,
												Line:   34,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 8,
													Line:   34,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "map",
												Start: ast.Position{
													Column: 5,
													Line:   34,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   36,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "training_data\n\t|> group(columns: [myClass, \"_field\"])\n\t|> count()\n\t|> map(fn: (r) =>\n\t\t({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))\n\t|> group()",
									Start: ast.Position{
										Column: 13,
										Line:   31,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   36,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "group()",
										Start: ast.Position{
											Column: 5,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   36,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "group",
											Start: ast.Position{
												Column: 5,
												Line:   36,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   43,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "P_value_x = training_data\n\t|> group(columns: [\"_value\", \"_field\"])\n\t|> count(column: myClass)\n\t|> map(fn: (r) =>\n\t\t({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))",
								Start: ast.Position{
									Column: 1,
									Line:   39,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "//one table for each class, where r.p_k == P(Class_k)\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   39,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "P_value_x",
									Start: ast.Position{
										Column: 1,
										Line:   39,
									},
								},
							},
							Name: "P_value_x",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   39,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "training_data",
												Start: ast.Position{
													Column: 13,
													Line:   39,
												},
											},
										},
										Name: "training_data",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   40,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "training_data\n\t|> group(columns: [\"_value\", \"_field\"])",
											Start: ast.Position{
												Column: 13,
												Line:   39,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   40,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "columns: [\"_value\", \"_field\"]",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   40,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [\"_value\", \"_field\"]",
														Start: ast.Position{
															Column: 11,
															Line:   40,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   40,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 11,
																Line:   40,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   40,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "[\"_value\", \"_field\"]",
															Start: ast.Position{
																Column: 20,
																Line:   40,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   40,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_value\"",
																Start: ast.Position{
																	Column: 21,
																	Line:   40,
																},
															},
														},
														Value: "_value",
													}, &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   40,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_field\"",
																Start: ast.Position{
																	Column: 31,
																	Line:   40,
																},
															},
														},
														Value: "_field",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   40,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "group(columns: [\"_value\", \"_field\"])",
												Start: ast.Position{
													Column: 5,
													Line:   40,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   40,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "group",
													Start: ast.Position{
														Column: 5,
														Line:   40,
													},
												},
											},
											Name: "group",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   41,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "training_data\n\t|> group(columns: [\"_value\", \"_field\"])\n\t|> count(column: myClass)",
										Start: ast.Position{
											Column: 13,
											Line:   39,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   41,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "column: myClass",
												Start: ast.Position{
													Column: 11,
													Line:   41,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   41,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "column: myClass",
													Start: ast.Position{
														Column: 11,
														Line:   41,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   41,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "column",
														Start: ast.Position{
															Column: 11,
															Line:   41,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   41,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "myClass",
														Start: ast.Position{
															Column: 19,
															Line:   41,
														},
													},
												},
												Name: "myClass",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   41,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "count(column: myClass)",
											Start: ast.Position{
												Column: 5,
												Line:   41,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   41,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "count",
												Start: ast.Position{
													Column: 5,
													Line:   41,
												},
											},
										},
										Name: "count",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   43,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "training_data\n\t|> group(columns: [\"_value\", \"_field\"])\n\t|> count(column: myClass)\n\t|> map(fn: (r) =>\n\t\t({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))",
									Start: ast.Position{
										Column: 13,
										Line:   39,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   43,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "fn: (r) =>\n\t\t({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count})",
											Start: ast.Position{
												Column: 9,
												Line:   42,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   43,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r) =>\n\t\t({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count})",
												Start: ast.Position{
													Column: 9,
													Line:   42,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   42,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   42,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   43,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "(r) =>\n\t\t({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count})",
													Start: ast.Position{
														Column: 13,
														Line:   42,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   43,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count})",
														Start: ast.Position{
															Column: 3,
															Line:   43,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 79,
																Line:   43,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "{r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}",
															Start: ast.Position{
																Column: 4,
																Line:   43,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   43,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "p_x: float(v: r.airborne) / float(v: total_count)",
																Start: ast.Position{
																	Column: 12,
																	Line:   43,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 15,
																		Line:   43,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "p_x",
																	Start: ast.Position{
																		Column: 12,
																		Line:   43,
																	},
																},
															},
															Name: "p_x",
														},
														Separator: nil,
														Value: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 61,
																		Line:   43,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "float(v: r.airborne) / float(v: total_count)",
																	Start: ast.Position{
																		Column: 17,
																		Line:   43,
																	},
																},
															},
															Left: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   43,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "v: r.airborne",
																			Start: ast.Position{
																				Column: 23,
																				Line:   43,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 36,
																					Line:   43,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "v: r.airborne",
																				Start: ast.Position{
																					Column: 23,
																					Line:   43,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 24,
																						Line:   43,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 23,
																						Line:   43,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 36,
																						Line:   43,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "r.airborne",
																					Start: ast.Position{
																						Column: 26,
																						Line:   43,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 27,
																							Line:   43,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 26,
																							Line:   43,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 36,
																							Line:   43,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "airborne",
																						Start: ast.Position{
																							Column: 28,
																							Line:   43,
																						},
																					},
																				},
																				Name: "airborne",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   43,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "float(v: r.airborne)",
																		Start: ast.Position{
																			Column: 17,
																			Line:   43,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 22,
																				Line:   43,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "float",
																			Start: ast.Position{
																				Column: 17,
																				Line:   43,
																			},
																		},
																	},
																	Name: "float",
																},
																Lparen: nil,
																Rparen: nil,
															},
															Operator: 2,
															Right: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   43,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "v: total_count",
																			Start: ast.Position{
																				Column: 46,
																				Line:   43,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 60,
																					Line:   43,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "v: total_count",
																				Start: ast.Position{
																					Column: 46,
																					Line:   43,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   43,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 46,
																						Line:   43,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 60,
																						Line:   43,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "total_count",
																					Start: ast.Position{
																						Column: 49,
																						Line:   43,
																					},
																				},
																			},
																			Name: "total_count",
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   43,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "float(v: total_count)",
																		Start: ast.Position{
																			Column: 40,
																			Line:   43,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   43,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "float",
																			Start: ast.Position{
																				Column: 40,
																				Line:   43,
																			},
																		},
																	},
																	Name: "float",
																},
																Lparen: nil,
																Rparen: nil,
															},
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 78,
																	Line:   43,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "tc: total_count",
																Start: ast.Position{
																	Column: 63,
																	Line:   43,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   43,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "tc",
																	Start: ast.Position{
																		Column: 63,
																		Line:   43,
																	},
																},
															},
															Name: "tc",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 78,
																		Line:   43,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "total_count",
																	Start: ast.Position{
																		Column: 67,
																		Line:   43,
																	},
																},
															},
															Name: "total_count",
														},
													}},
													Rbrace: nil,
													With: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 6,
																	Line:   43,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 5,
																	Line:   43,
																},
															},
														},
														Name: "r",
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   42,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   42,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   42,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   42,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   43,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "map(fn: (r) =>\n\t\t({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))",
										Start: ast.Position{
											Column: 5,
											Line:   42,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   42,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "map",
											Start: ast.Position{
												Column: 5,
												Line:   42,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   50,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "P_k_x = training_data\n\t|> group(columns: [\"_field\",\"_value\", myClass])\n\t|> reduce(fn: (r, accumulator) =>\n\t\t({sum: 1.0 + accumulator.sum}), identity: {sum: 0.0})\n\t|> group()",
								Start: ast.Position{
									Column: 1,
									Line:   46,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// one table for each value, where r.p_x == P(value_x)\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   46,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "P_k_x",
									Start: ast.Position{
										Column: 1,
										Line:   46,
									},
								},
							},
							Name: "P_k_x",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   46,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "training_data",
												Start: ast.Position{
													Column: 9,
													Line:   46,
												},
											},
										},
										Name: "training_data",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   47,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "training_data\n\t|> group(columns: [\"_field\",\"_value\", myClass])",
											Start: ast.Position{
												Column: 9,
												Line:   46,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   47,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "columns: [\"_field\",\"_value\", myClass]",
													Start: ast.Position{
														Column: 11,
														Line:   47,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   47,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [\"_field\",\"_value\", myClass]",
														Start: ast.Position{
															Column: 11,
															Line:   47,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   47,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 11,
																Line:   47,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   47,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "[\"_field\",\"_value\", myClass]",
															Start: ast.Position{
																Column: 20,
																Line:   47,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   47,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_field\"",
																Start: ast.Position{
																	Column: 21,
																	Line:   47,
																},
															},
														},
														Value: "_field",
													}, &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   47,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_value\"",
																Start: ast.Position{
																	Column: 30,
																	Line:   47,
																},
															},
														},
														Value: "_value",
													}, &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   47,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "myClass",
																Start: ast.Position{
																	Column: 40,
																	Line:   47,
																},
															},
														},
														Name: "myClass",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   47,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "group(columns: [\"_field\",\"_value\", myClass])",
												Start: ast.Position{
													Column: 5,
													Line:   47,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   47,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "group",
													Start: ast.Position{
														Column: 5,
														Line:   47,
													},
												},
											},
											Name: "group",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   49,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "training_data\n\t|> group(columns: [\"_field\",\"_value\", myClass])\n\t|> reduce(fn: (r, accumulator) =>\n\t\t({sum: 1.0 + accumulator.sum}), identity: {sum: 0.0})",
										Start: ast.Position{
											Column: 9,
											Line:   46,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   49,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r, accumulator) =>\n\t\t({sum: 1.0 + accumulator.sum}), identity: {sum: 0.0}",
												Start: ast.Position{
													Column: 12,
													Line:   48,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   49,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn: (r, accumulator) =>\n\t\t({sum: 1.0 + accumulator.sum})",
													Start: ast.Position{
														Column: 12,
														Line:   48,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   48,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 12,
															Line:   48,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   49,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "(r, accumulator) =>\n\t\t({sum: 1.0 + accumulator.sum})",
														Start: ast.Position{
															Column: 16,
															Line:   48,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   49,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "({sum: 1.0 + accumulator.sum})",
															Start: ast.Position{
																Column: 3,
																Line:   49,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 32,
																	Line:   49,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "{sum: 1.0 + accumulator.sum}",
																Start: ast.Position{
																	Column: 4,
																	Line:   49,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   49,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "sum: 1.0 + accumulator.sum",
																	Start: ast.Position{
																		Column: 5,
																		Line:   49,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 8,
																			Line:   49,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "sum",
																		Start: ast.Position{
																			Column: 5,
																			Line:   49,
																		},
																	},
																},
																Name: "sum",
															},
															Separator: nil,
															Value: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   49,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "1.0 + accumulator.sum",
																		Start: ast.Position{
																			Column: 10,
																			Line:   49,
																		},
																	},
																},
																Left: &ast.FloatLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 13,
																				Line:   49,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "1.0",
																			Start: ast.Position{
																				Column: 10,
																				Line:   49,
																			},
																		},
																	},
																	Value: 1.0,
																},
																Operator: 5,
																Right: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 31,
																				Line:   49,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "accumulator.sum",
																			Start: ast.Position{
																				Column: 16,
																				Line:   49,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 27,
																					Line:   49,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "accumulator",
																				Start: ast.Position{
																					Column: 16,
																					Line:   49,
																				},
																			},
																		},
																		Name: "accumulator",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 31,
																					Line:   49,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "sum",
																				Start: ast.Position{
																					Column: 28,
																					Line:   49,
																				},
																			},
																		},
																		Name: "sum",
																	},
																	Rbrack: nil,
																},
															},
														}},
														Rbrace: nil,
														With:   nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   48,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 17,
																Line:   48,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   48,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   48,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   48,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "accumulator",
															Start: ast.Position{
																Column: 20,
																Line:   48,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   48,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "accumulator",
																Start: ast.Position{
																	Column: 20,
																	Line:   48,
																},
															},
														},
														Name: "accumulator",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   49,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "identity: {sum: 0.0}",
													Start: ast.Position{
														Column: 35,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   49,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "identity",
														Start: ast.Position{
															Column: 35,
															Line:   49,
														},
													},
												},
												Name: "identity",
											},
											Separator: nil,
											Value: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   49,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "{sum: 0.0}",
														Start: ast.Position{
															Column: 45,
															Line:   49,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   49,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "sum: 0.0",
															Start: ast.Position{
																Column: 46,
																Line:   49,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   49,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "sum",
																Start: ast.Position{
																	Column: 46,
																	Line:   49,
																},
															},
														},
														Name: "sum",
													},
													Separator: nil,
													Value: &ast.FloatLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   49,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "0.0",
																Start: ast.Position{
																	Column: 51,
																	Line:   49,
																},
															},
														},
														Value: 0.0,
													},
												}},
												Rbrace: nil,
												With:   nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   49,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "reduce(fn: (r, accumulator) =>\n\t\t({sum: 1.0 + accumulator.sum}), identity: {sum: 0.0})",
											Start: ast.Position{
												Column: 5,
												Line:   48,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   48,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "reduce",
												Start: ast.Position{
													Column: 5,
													Line:   48,
												},
											},
										},
										Name: "reduce",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   50,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "training_data\n\t|> group(columns: [\"_field\",\"_value\", myClass])\n\t|> reduce(fn: (r, accumulator) =>\n\t\t({sum: 1.0 + accumulator.sum}), identity: {sum: 0.0})\n\t|> group()",
									Start: ast.Position{
										Column: 9,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   50,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "group()",
										Start: ast.Position{
											Column: 5,
											Line:   50,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   50,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "group",
											Start: ast.Position{
												Column: 5,
												Line:   50,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   60,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "P_k_x_class = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t  |> limit(n: 1)\n\n\t  |> map(fn: (r) =>\n\t\t  ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])\n    |> rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})",
								Start: ast.Position{
									Column: 1,
									Line:   53,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// one table for each value and Class pair, where r.p_k_x == P(value_x | Class_k)\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   53,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "P_k_x_class",
									Start: ast.Position{
										Column: 1,
										Line:   53,
									},
								},
							},
							Name: "P_k_x_class",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 96,
																Line:   53,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\"",
															Start: ast.Position{
																Column: 20,
																Line:   53,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 64,
																	Line:   53,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}",
																Start: ast.Position{
																	Column: 20,
																	Line:   53,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   53,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "tables",
																	Start: ast.Position{
																		Column: 20,
																		Line:   53,
																	},
																},
															},
															Name: "tables",
														},
														Separator: nil,
														Value: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   53,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "{P_k_x: P_k_x, P_Class_k: P_Class_k}",
																	Start: ast.Position{
																		Column: 28,
																		Line:   53,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 41,
																			Line:   53,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_k_x: P_k_x",
																		Start: ast.Position{
																			Column: 29,
																			Line:   53,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   53,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "P_k_x",
																			Start: ast.Position{
																				Column: 29,
																				Line:   53,
																			},
																		},
																	},
																	Name: "P_k_x",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 41,
																				Line:   53,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "P_k_x",
																			Start: ast.Position{
																				Column: 36,
																				Line:   53,
																			},
																		},
																	},
																	Name: "P_k_x",
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 63,
																			Line:   53,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_Class_k: P_Class_k",
																		Start: ast.Position{
																			Column: 43,
																			Line:   53,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 52,
																				Line:   53,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "P_Class_k",
																			Start: ast.Position{
																				Column: 43,
																				Line:   53,
																			},
																		},
																	},
																	Name: "P_Class_k",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 63,
																				Line:   53,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "P_Class_k",
																			Start: ast.Position{
																				Column: 54,
																				Line:   53,
																			},
																		},
																	},
																	Name: "P_Class_k",
																},
															}},
															Rbrace: nil,
															With:   nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 79,
																	Line:   53,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "on: [myClass]",
																Start: ast.Position{
																	Column: 66,
																	Line:   53,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   53,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "on",
																	Start: ast.Position{
																		Column: 66,
																		Line:   53,
																	},
																},
															},
															Name: "on",
														},
														Separator: nil,
														Value: &ast.ArrayExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 79,
																		Line:   53,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "[myClass]",
																	Start: ast.Position{
																		Column: 70,
																		Line:   53,
																	},
																},
															},
															Elements: []ast.Expression{&ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 78,
																			Line:   53,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "myClass",
																		Start: ast.Position{
																			Column: 71,
																			Line:   53,
																		},
																	},
																},
																Name: "myClass",
															}},
															Lbrack: nil,
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 96,
																	Line:   53,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "method: \"inner\"",
																Start: ast.Position{
																	Column: 81,
																	Line:   53,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 87,
																		Line:   53,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "method",
																	Start: ast.Position{
																		Column: 81,
																		Line:   53,
																	},
																},
															},
															Name: "method",
														},
														Separator: nil,
														Value: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 96,
																		Line:   53,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"inner\"",
																	Start: ast.Position{
																		Column: 89,
																		Line:   53,
																	},
																},
															},
															Value: "inner",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 97,
															Line:   53,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")",
														Start: ast.Position{
															Column: 15,
															Line:   53,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   53,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "join",
															Start: ast.Position{
																Column: 15,
																Line:   53,
															},
														},
													},
													Name: "join",
												},
												Lparen: nil,
												Rparen: nil,
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   54,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> group(columns: [myClass, \"_value_P_k_x\"])",
													Start: ast.Position{
														Column: 15,
														Line:   53,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   54,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns: [myClass, \"_value_P_k_x\"]",
															Start: ast.Position{
																Column: 14,
																Line:   54,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   54,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "columns: [myClass, \"_value_P_k_x\"]",
																Start: ast.Position{
																	Column: 14,
																	Line:   54,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   54,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "columns",
																	Start: ast.Position{
																		Column: 14,
																		Line:   54,
																	},
																},
															},
															Name: "columns",
														},
														Separator: nil,
														Value: &ast.ArrayExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   54,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "[myClass, \"_value_P_k_x\"]",
																	Start: ast.Position{
																		Column: 23,
																		Line:   54,
																	},
																},
															},
															Elements: []ast.Expression{&ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   54,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "myClass",
																		Start: ast.Position{
																			Column: 24,
																			Line:   54,
																		},
																	},
																},
																Name: "myClass",
															}, &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 47,
																			Line:   54,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "\"_value_P_k_x\"",
																		Start: ast.Position{
																			Column: 33,
																			Line:   54,
																		},
																	},
																},
																Value: "_value_P_k_x",
															}},
															Lbrack: nil,
															Rbrack: nil,
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   54,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "group(columns: [myClass, \"_value_P_k_x\"])",
														Start: ast.Position{
															Column: 8,
															Line:   54,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 13,
																Line:   54,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "group",
															Start: ast.Position{
																Column: 8,
																Line:   54,
															},
														},
													},
													Name: "group",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   55,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t  |> limit(n: 1)",
												Start: ast.Position{
													Column: 15,
													Line:   53,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   55,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "n: 1",
														Start: ast.Position{
															Column: 13,
															Line:   55,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 17,
																Line:   55,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "n: 1",
															Start: ast.Position{
																Column: 13,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   55,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "n",
																Start: ast.Position{
																	Column: 13,
																	Line:   55,
																},
															},
														},
														Name: "n",
													},
													Separator: nil,
													Value: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   55,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "1",
																Start: ast.Position{
																	Column: 16,
																	Line:   55,
																},
															},
														},
														Value: int64(1),
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   55,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "limit(n: 1)",
													Start: ast.Position{
														Column: 7,
														Line:   55,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 12,
															Line:   55,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "limit",
														Start: ast.Position{
															Column: 7,
															Line:   55,
														},
													},
												},
												Name: "limit",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 60,
												Line:   58,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t  |> limit(n: 1)\n\n\t  |> map(fn: (r) =>\n\t\t  ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))",
											Start: ast.Position{
												Column: 15,
												Line:   53,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   58,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn: (r) =>\n\t\t  ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
													Start: ast.Position{
														Column: 11,
														Line:   57,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   58,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "fn: (r) =>\n\t\t  ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
														Start: ast.Position{
															Column: 11,
															Line:   57,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 13,
																Line:   57,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 11,
																Line:   57,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   58,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "(r) =>\n\t\t  ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
															Start: ast.Position{
																Column: 15,
																Line:   57,
															},
														},
													},
													Body: &ast.ParenExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   58,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
																Start: ast.Position{
																	Column: 5,
																	Line:   58,
																},
															},
														},
														Expression: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   58,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "{r with P_x_k: r.sum / float(v: r._value_P_Class_k)}",
																	Start: ast.Position{
																		Column: 6,
																		Line:   58,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   58,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_x_k: r.sum / float(v: r._value_P_Class_k)",
																		Start: ast.Position{
																			Column: 14,
																			Line:   58,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 19,
																				Line:   58,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "P_x_k",
																			Start: ast.Position{
																				Column: 14,
																				Line:   58,
																			},
																		},
																	},
																	Name: "P_x_k",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 57,
																				Line:   58,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "r.sum / float(v: r._value_P_Class_k)",
																			Start: ast.Position{
																				Column: 21,
																				Line:   58,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 26,
																					Line:   58,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "r.sum",
																				Start: ast.Position{
																					Column: 21,
																					Line:   58,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   58,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 21,
																						Line:   58,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 26,
																						Line:   58,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "sum",
																					Start: ast.Position{
																						Column: 23,
																						Line:   58,
																					},
																				},
																			},
																			Name: "sum",
																		},
																		Rbrack: nil,
																	},
																	Operator: 2,
																	Right: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 56,
																						Line:   58,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "v: r._value_P_Class_k",
																					Start: ast.Position{
																						Column: 35,
																						Line:   58,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 56,
																							Line:   58,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "v: r._value_P_Class_k",
																						Start: ast.Position{
																							Column: 35,
																							Line:   58,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 36,
																								Line:   58,
																							},
																							File:   "naiveBayesClassifier.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 35,
																								Line:   58,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.MemberExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 56,
																								Line:   58,
																							},
																							File:   "naiveBayesClassifier.flux",
																							Source: "r._value_P_Class_k",
																							Start: ast.Position{
																								Column: 38,
																								Line:   58,
																							},
																						},
																					},
																					Lbrack: nil,
																					Object: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 39,
																									Line:   58,
																								},
																								File:   "naiveBayesClassifier.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 38,
																									Line:   58,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Property: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 56,
																									Line:   58,
																								},
																								File:   "naiveBayesClassifier.flux",
																								Source: "_value_P_Class_k",
																								Start: ast.Position{
																									Column: 40,
																									Line:   58,
																								},
																							},
																						},
																						Name: "_value_P_Class_k",
																					},
																					Rbrack: nil,
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 57,
																					Line:   58,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "float(v: r._value_P_Class_k)",
																				Start: ast.Position{
																					Column: 29,
																					Line:   58,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 34,
																						Line:   58,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "float",
																					Start: ast.Position{
																						Column: 29,
																						Line:   58,
																					},
																				},
																			},
																			Name: "float",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																},
															}},
															Rbrace: nil,
															With: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 8,
																			Line:   58,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 7,
																			Line:   58,
																		},
																	},
																},
																Name: "r",
															},
														},
														Lparen: nil,
														Rparen: nil,
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   57,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 16,
																	Line:   57,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 17,
																		Line:   57,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 16,
																		Line:   57,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   58,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "map(fn: (r) =>\n\t\t  ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))",
												Start: ast.Position{
													Column: 7,
													Line:   57,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   57,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "map",
													Start: ast.Position{
														Column: 7,
														Line:   57,
													},
												},
											},
											Name: "map",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   59,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t  |> limit(n: 1)\n\n\t  |> map(fn: (r) =>\n\t\t  ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])",
										Start: ast.Position{
											Column: 15,
											Line:   53,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   59,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"]",
												Start: ast.Position{
													Column: 13,
													Line:   59,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   59,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"]",
													Start: ast.Position{
														Column: 13,
														Line:   59,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   59,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 13,
															Line:   59,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   59,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "[\"_field_P_Class_k\", \"_value_P_Class_k\"]",
														Start: ast.Position{
															Column: 22,
															Line:   59,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   59,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "\"_field_P_Class_k\"",
															Start: ast.Position{
																Column: 23,
																Line:   59,
															},
														},
													},
													Value: "_field_P_Class_k",
												}, &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   59,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "\"_value_P_Class_k\"",
															Start: ast.Position{
																Column: 43,
																Line:   59,
															},
														},
													},
													Value: "_value_P_Class_k",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   59,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])",
											Start: ast.Position{
												Column: 8,
												Line:   59,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   59,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 8,
													Line:   59,
												},
											},
										},
										Name: "drop",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 73,
										Line:   60,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t  |> limit(n: 1)\n\n\t  |> map(fn: (r) =>\n\t\t  ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])\n    |> rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})",
									Start: ast.Position{
										Column: 15,
										Line:   53,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   60,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"}",
											Start: ast.Position{
												Column: 15,
												Line:   60,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   60,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"}",
												Start: ast.Position{
													Column: 15,
													Line:   60,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   60,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 15,
														Line:   60,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   60,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "{_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"}",
													Start: ast.Position{
														Column: 24,
														Line:   60,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   60,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "_field_P_k_x: \"_field\"",
														Start: ast.Position{
															Column: 25,
															Line:   60,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   60,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "_field_P_k_x",
															Start: ast.Position{
																Column: 25,
																Line:   60,
															},
														},
													},
													Name: "_field_P_k_x",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   60,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "\"_field\"",
															Start: ast.Position{
																Column: 39,
																Line:   60,
															},
														},
													},
													Value: "_field",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   60,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "_value_P_k_x: \"_value\"",
														Start: ast.Position{
															Column: 49,
															Line:   60,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   60,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "_value_P_k_x",
															Start: ast.Position{
																Column: 49,
																Line:   60,
															},
														},
													},
													Name: "_value_P_k_x",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 71,
																Line:   60,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "\"_value\"",
															Start: ast.Position{
																Column: 63,
																Line:   60,
															},
														},
													},
													Value: "_value",
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   60,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})",
										Start: ast.Position{
											Column: 8,
											Line:   60,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   60,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "rename",
											Start: ast.Position{
												Column: 8,
												Line:   60,
											},
										},
									},
									Name: "rename",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   68,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "P_k_x_class_Drop = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t|> limit(n: 1)\n\n\t|> map(fn: (r) =>\n\t\t({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))",
								Start: ast.Position{
									Column: 1,
									Line:   62,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   62,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "P_k_x_class_Drop",
									Start: ast.Position{
										Column: 1,
										Line:   62,
									},
								},
							},
							Name: "P_k_x_class_Drop",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 101,
															Line:   62,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\"",
														Start: ast.Position{
															Column: 25,
															Line:   62,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   62,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}",
															Start: ast.Position{
																Column: 25,
																Line:   62,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   62,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "tables",
																Start: ast.Position{
																	Column: 25,
																	Line:   62,
																},
															},
														},
														Name: "tables",
													},
													Separator: nil,
													Value: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   62,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "{P_k_x: P_k_x, P_Class_k: P_Class_k}",
																Start: ast.Position{
																	Column: 33,
																	Line:   62,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   62,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "P_k_x: P_k_x",
																	Start: ast.Position{
																		Column: 34,
																		Line:   62,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 39,
																			Line:   62,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_k_x",
																		Start: ast.Position{
																			Column: 34,
																			Line:   62,
																		},
																	},
																},
																Name: "P_k_x",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   62,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_k_x",
																		Start: ast.Position{
																			Column: 41,
																			Line:   62,
																		},
																	},
																},
																Name: "P_k_x",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   62,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "P_Class_k: P_Class_k",
																	Start: ast.Position{
																		Column: 48,
																		Line:   62,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   62,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_Class_k",
																		Start: ast.Position{
																			Column: 48,
																			Line:   62,
																		},
																	},
																},
																Name: "P_Class_k",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 68,
																			Line:   62,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_Class_k",
																		Start: ast.Position{
																			Column: 59,
																			Line:   62,
																		},
																	},
																},
																Name: "P_Class_k",
															},
														}},
														Rbrace: nil,
														With:   nil,
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 84,
																Line:   62,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "on: [myClass]",
															Start: ast.Position{
																Column: 71,
																Line:   62,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 73,
																	Line:   62,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "on",
																Start: ast.Position{
																	Column: 71,
																	Line:   62,
																},
															},
														},
														Name: "on",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 84,
																	Line:   62,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "[myClass]",
																Start: ast.Position{
																	Column: 75,
																	Line:   62,
																},
															},
														},
														Elements: []ast.Expression{&ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 83,
																		Line:   62,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "myClass",
																	Start: ast.Position{
																		Column: 76,
																		Line:   62,
																	},
																},
															},
															Name: "myClass",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 101,
																Line:   62,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "method: \"inner\"",
															Start: ast.Position{
																Column: 86,
																Line:   62,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 92,
																	Line:   62,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "method",
																Start: ast.Position{
																	Column: 86,
																	Line:   62,
																},
															},
														},
														Name: "method",
													},
													Separator: nil,
													Value: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 101,
																	Line:   62,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"inner\"",
																Start: ast.Position{
																	Column: 94,
																	Line:   62,
																},
															},
														},
														Value: "inner",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 102,
														Line:   62,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")",
													Start: ast.Position{
														Column: 20,
														Line:   62,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   62,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "join",
														Start: ast.Position{
															Column: 20,
															Line:   62,
														},
													},
												},
												Name: "join",
											},
											Lparen: nil,
											Rparen: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   63,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])",
												Start: ast.Position{
													Column: 20,
													Line:   62,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   63,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"]",
														Start: ast.Position{
															Column: 13,
															Line:   63,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 78,
																Line:   63,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"]",
															Start: ast.Position{
																Column: 13,
																Line:   63,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   63,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 13,
																	Line:   63,
																},
															},
														},
														Name: "columns",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 78,
																	Line:   63,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "[\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"]",
																Start: ast.Position{
																	Column: 22,
																	Line:   63,
																},
															},
														},
														Elements: []ast.Expression{&ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   63,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"_field_P_Class_k\"",
																	Start: ast.Position{
																		Column: 23,
																		Line:   63,
																	},
																},
															},
															Value: "_field_P_Class_k",
														}, &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 61,
																		Line:   63,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"_value_P_Class_k\"",
																	Start: ast.Position{
																		Column: 43,
																		Line:   63,
																	},
																},
															},
															Value: "_value_P_Class_k",
														}, &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   63,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"_field_P_k_x\"",
																	Start: ast.Position{
																		Column: 63,
																		Line:   63,
																	},
																},
															},
															Value: "_field_P_k_x",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   63,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])",
													Start: ast.Position{
														Column: 8,
														Line:   63,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 12,
															Line:   63,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "drop",
														Start: ast.Position{
															Column: 8,
															Line:   63,
														},
													},
												},
												Name: "drop",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   64,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n    |> group(columns: [myClass, \"_value_P_k_x\"])",
											Start: ast.Position{
												Column: 20,
												Line:   62,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   64,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "columns: [myClass, \"_value_P_k_x\"]",
													Start: ast.Position{
														Column: 14,
														Line:   64,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   64,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [myClass, \"_value_P_k_x\"]",
														Start: ast.Position{
															Column: 14,
															Line:   64,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   64,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 14,
																Line:   64,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   64,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "[myClass, \"_value_P_k_x\"]",
															Start: ast.Position{
																Column: 23,
																Line:   64,
															},
														},
													},
													Elements: []ast.Expression{&ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   64,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "myClass",
																Start: ast.Position{
																	Column: 24,
																	Line:   64,
																},
															},
														},
														Name: "myClass",
													}, &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   64,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_value_P_k_x\"",
																Start: ast.Position{
																	Column: 33,
																	Line:   64,
																},
															},
														},
														Value: "_value_P_k_x",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   64,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "group(columns: [myClass, \"_value_P_k_x\"])",
												Start: ast.Position{
													Column: 8,
													Line:   64,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   64,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "group",
													Start: ast.Position{
														Column: 8,
														Line:   64,
													},
												},
											},
											Name: "group",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   65,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t|> limit(n: 1)",
										Start: ast.Position{
											Column: 20,
											Line:   62,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   65,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "n: 1",
												Start: ast.Position{
													Column: 11,
													Line:   65,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   65,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "n: 1",
													Start: ast.Position{
														Column: 11,
														Line:   65,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 12,
															Line:   65,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "n",
														Start: ast.Position{
															Column: 11,
															Line:   65,
														},
													},
												},
												Name: "n",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   65,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "1",
														Start: ast.Position{
															Column: 14,
															Line:   65,
														},
													},
												},
												Value: int64(1),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   65,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "limit(n: 1)",
											Start: ast.Position{
												Column: 5,
												Line:   65,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   65,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "limit",
												Start: ast.Position{
													Column: 5,
													Line:   65,
												},
											},
										},
										Name: "limit",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   68,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n    |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n    |> group(columns: [myClass, \"_value_P_k_x\"])\n\t|> limit(n: 1)\n\n\t|> map(fn: (r) =>\n\t\t({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))",
									Start: ast.Position{
										Column: 20,
										Line:   62,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   68,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "fn: (r) =>\n\t\t({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
											Start: ast.Position{
												Column: 9,
												Line:   67,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   68,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r) =>\n\t\t({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
												Start: ast.Position{
													Column: 9,
													Line:   67,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   67,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   67,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   68,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "(r) =>\n\t\t({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
													Start: ast.Position{
														Column: 13,
														Line:   67,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   68,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
														Start: ast.Position{
															Column: 3,
															Line:   68,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   68,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "{r with P_x_k: r.sum / float(v: r._value_P_Class_k)}",
															Start: ast.Position{
																Column: 4,
																Line:   68,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   68,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "P_x_k: r.sum / float(v: r._value_P_Class_k)",
																Start: ast.Position{
																	Column: 12,
																	Line:   68,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 17,
																		Line:   68,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "P_x_k",
																	Start: ast.Position{
																		Column: 12,
																		Line:   68,
																	},
																},
															},
															Name: "P_x_k",
														},
														Separator: nil,
														Value: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   68,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r.sum / float(v: r._value_P_Class_k)",
																	Start: ast.Position{
																		Column: 19,
																		Line:   68,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   68,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r.sum",
																		Start: ast.Position{
																			Column: 19,
																			Line:   68,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 20,
																				Line:   68,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 19,
																				Line:   68,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   68,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "sum",
																			Start: ast.Position{
																				Column: 21,
																				Line:   68,
																			},
																		},
																	},
																	Name: "sum",
																},
																Rbrack: nil,
															},
															Operator: 2,
															Right: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 54,
																				Line:   68,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "v: r._value_P_Class_k",
																			Start: ast.Position{
																				Column: 33,
																				Line:   68,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 54,
																					Line:   68,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "v: r._value_P_Class_k",
																				Start: ast.Position{
																					Column: 33,
																					Line:   68,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 34,
																						Line:   68,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 33,
																						Line:   68,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 54,
																						Line:   68,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "r._value_P_Class_k",
																					Start: ast.Position{
																						Column: 36,
																						Line:   68,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 37,
																							Line:   68,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 36,
																							Line:   68,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 54,
																							Line:   68,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "_value_P_Class_k",
																						Start: ast.Position{
																							Column: 38,
																							Line:   68,
																						},
																					},
																				},
																				Name: "_value_P_Class_k",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   68,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "float(v: r._value_P_Class_k)",
																		Start: ast.Position{
																			Column: 27,
																			Line:   68,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 32,
																				Line:   68,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "float",
																			Start: ast.Position{
																				Column: 27,
																				Line:   68,
																			},
																		},
																	},
																	Name: "float",
																},
																Lparen: nil,
																Rparen: nil,
															},
														},
													}},
													Rbrace: nil,
													With: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 6,
																	Line:   68,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 5,
																	Line:   68,
																},
															},
														},
														Name: "r",
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   67,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   67,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   67,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   67,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   68,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "map(fn: (r) =>\n\t\t({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))",
										Start: ast.Position{
											Column: 5,
											Line:   67,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   67,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "map",
											Start: ast.Position{
												Column: 5,
												Line:   67,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   74,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "Probability_table = join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")\n\t|> map(fn: (r) =>\n\t\t({r with Probability: r.P_x_k * r.p_k / r.p_x}))",
								Start: ast.Position{
									Column: 1,
									Line:   72,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "//added P(value_x) to table\n"}, ast.Comment{Text: "//calculated probabilities for training data \n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   72,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "Probability_table",
									Start: ast.Position{
										Column: 1,
										Line:   72,
									},
								},
							},
							Name: "Probability_table",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 125,
												Line:   72,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\"",
											Start: ast.Position{
												Column: 26,
												Line:   72,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   72,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}",
												Start: ast.Position{
													Column: 26,
													Line:   72,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   72,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 26,
														Line:   72,
													},
												},
											},
											Name: "tables",
										},
										Separator: nil,
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   72,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "{P_k_x_class: P_k_x_class, P_value_x: P_value_x}",
													Start: ast.Position{
														Column: 34,
														Line:   72,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   72,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "P_k_x_class: P_k_x_class",
														Start: ast.Position{
															Column: 35,
															Line:   72,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   72,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "P_k_x_class",
															Start: ast.Position{
																Column: 35,
																Line:   72,
															},
														},
													},
													Name: "P_k_x_class",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   72,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "P_k_x_class",
															Start: ast.Position{
																Column: 48,
																Line:   72,
															},
														},
													},
													Name: "P_k_x_class",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 81,
															Line:   72,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "P_value_x: P_value_x",
														Start: ast.Position{
															Column: 61,
															Line:   72,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 70,
																Line:   72,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "P_value_x",
															Start: ast.Position{
																Column: 61,
																Line:   72,
															},
														},
													},
													Name: "P_value_x",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 81,
																Line:   72,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "P_value_x",
															Start: ast.Position{
																Column: 72,
																Line:   72,
															},
														},
													},
													Name: "P_value_x",
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 108,
													Line:   72,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "on: [\"_value\", \"_field\"]",
												Start: ast.Position{
													Column: 84,
													Line:   72,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   72,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "on",
													Start: ast.Position{
														Column: 84,
														Line:   72,
													},
												},
											},
											Name: "on",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   72,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "[\"_value\", \"_field\"]",
													Start: ast.Position{
														Column: 88,
														Line:   72,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 97,
															Line:   72,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "\"_value\"",
														Start: ast.Position{
															Column: 89,
															Line:   72,
														},
													},
												},
												Value: "_value",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   72,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "\"_field\"",
														Start: ast.Position{
															Column: 99,
															Line:   72,
														},
													},
												},
												Value: "_field",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 125,
													Line:   72,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "method: \"inner\"",
												Start: ast.Position{
													Column: 110,
													Line:   72,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 116,
														Line:   72,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "method",
													Start: ast.Position{
														Column: 110,
														Line:   72,
													},
												},
											},
											Name: "method",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 125,
														Line:   72,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "\"inner\"",
													Start: ast.Position{
														Column: 118,
														Line:   72,
													},
												},
											},
											Value: "inner",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 126,
											Line:   72,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")",
										Start: ast.Position{
											Column: 21,
											Line:   72,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   72,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "join",
											Start: ast.Position{
												Column: 21,
												Line:   72,
											},
										},
									},
									Name: "join",
								},
								Lparen: nil,
								Rparen: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   74,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")\n\t|> map(fn: (r) =>\n\t\t({r with Probability: r.P_x_k * r.p_k / r.p_x}))",
									Start: ast.Position{
										Column: 21,
										Line:   72,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   74,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "fn: (r) =>\n\t\t({r with Probability: r.P_x_k * r.p_k / r.p_x})",
											Start: ast.Position{
												Column: 9,
												Line:   73,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   74,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r) =>\n\t\t({r with Probability: r.P_x_k * r.p_k / r.p_x})",
												Start: ast.Position{
													Column: 9,
													Line:   73,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   73,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   73,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   74,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "(r) =>\n\t\t({r with Probability: r.P_x_k * r.p_k / r.p_x})",
													Start: ast.Position{
														Column: 13,
														Line:   73,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   74,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "({r with Probability: r.P_x_k * r.p_k / r.p_x})",
														Start: ast.Position{
															Column: 3,
															Line:   74,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   74,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "{r with Probability: r.P_x_k * r.p_k / r.p_x}",
															Start: ast.Position{
																Column: 4,
																Line:   74,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   74,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "Probability: r.P_x_k * r.p_k / r.p_x",
																Start: ast.Position{
																	Column: 12,
																	Line:   74,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 23,
																		Line:   74,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "Probability",
																	Start: ast.Position{
																		Column: 12,
																		Line:   74,
																	},
																},
															},
															Name: "Probability",
														},
														Separator: nil,
														Value: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   74,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r.P_x_k * r.p_k / r.p_x",
																	Start: ast.Position{
																		Column: 25,
																		Line:   74,
																	},
																},
															},
															Left: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   74,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r.P_x_k * r.p_k",
																		Start: ast.Position{
																			Column: 25,
																			Line:   74,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 32,
																				Line:   74,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "r.P_x_k",
																			Start: ast.Position{
																				Column: 25,
																				Line:   74,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 26,
																					Line:   74,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 25,
																					Line:   74,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 32,
																					Line:   74,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "P_x_k",
																				Start: ast.Position{
																					Column: 27,
																					Line:   74,
																				},
																			},
																		},
																		Name: "P_x_k",
																	},
																	Rbrack: nil,
																},
																Operator: 1,
																Right: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   74,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "r.p_k",
																			Start: ast.Position{
																				Column: 35,
																				Line:   74,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 36,
																					Line:   74,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 35,
																					Line:   74,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 40,
																					Line:   74,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "p_k",
																				Start: ast.Position{
																					Column: 37,
																					Line:   74,
																				},
																			},
																		},
																		Name: "p_k",
																	},
																	Rbrack: nil,
																},
															},
															Operator: 2,
															Right: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   74,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r.p_x",
																		Start: ast.Position{
																			Column: 43,
																			Line:   74,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 44,
																				Line:   74,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 43,
																				Line:   74,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   74,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "p_x",
																			Start: ast.Position{
																				Column: 45,
																				Line:   74,
																			},
																		},
																	},
																	Name: "p_x",
																},
																Rbrack: nil,
															},
														},
													}},
													Rbrace: nil,
													With: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 6,
																	Line:   74,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 5,
																	Line:   74,
																},
															},
														},
														Name: "r",
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   73,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   73,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   73,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   73,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   74,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "map(fn: (r) =>\n\t\t({r with Probability: r.P_x_k * r.p_k / r.p_x}))",
										Start: ast.Position{
											Column: 5,
											Line:   73,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   73,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "map",
											Start: ast.Position{
												Column: 5,
												Line:   73,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 2,
									Line:   85,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "predictOverall = (tables=<-) => {\n  r = tables\n    |> keep(columns: [\"_value\", \"Animal_name\",\"_field\"])\n\n  output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n  return output \n}",
								Start: ast.Position{
									Column: 1,
									Line:   79,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "//|> yield(name: \"final\")\n"}, ast.Comment{Text: "//predictions for test data computed \n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   79,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "predictOverall",
									Start: ast.Position{
										Column: 1,
										Line:   79,
									},
								},
							},
							Name: "predictOverall",
						},
						Init: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   85,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "(tables=<-) => {\n  r = tables\n    |> keep(columns: [\"_value\", \"Animal_name\",\"_field\"])\n\n  output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n  return output \n}",
									Start: ast.Position{
										Column: 18,
										Line:   79,
									},
								},
							},
							Body: &ast.Block{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 2,
											Line:   85,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "{\n  r = tables\n    |> keep(columns: [\"_value\", \"Animal_name\",\"_field\"])\n\n  output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n  return output \n}",
										Start: ast.Position{
											Column: 33,
											Line:   79,
										},
									},
								},
								Body: []ast.Statement{&ast.VariableAssignment{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   81,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "r = tables\n    |> keep(columns: [\"_value\", \"Animal_name\",\"_field\"])",
											Start: ast.Position{
												Column: 3,
												Line:   80,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 4,
													Line:   80,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "r",
												Start: ast.Position{
													Column: 3,
													Line:   80,
												},
											},
										},
										Name: "r",
									},
									Init: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   80,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 7,
														Line:   80,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   81,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "tables\n    |> keep(columns: [\"_value\", \"Animal_name\",\"_field\"])",
												Start: ast.Position{
													Column: 7,
													Line:   80,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   81,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [\"_value\", \"Animal_name\",\"_field\"]",
														Start: ast.Position{
															Column: 13,
															Line:   81,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   81,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns: [\"_value\", \"Animal_name\",\"_field\"]",
															Start: ast.Position{
																Column: 13,
																Line:   81,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   81,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 13,
																	Line:   81,
																},
															},
														},
														Name: "columns",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   81,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "[\"_value\", \"Animal_name\",\"_field\"]",
																Start: ast.Position{
																	Column: 22,
																	Line:   81,
																},
															},
														},
														Elements: []ast.Expression{&ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   81,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"_value\"",
																	Start: ast.Position{
																		Column: 23,
																		Line:   81,
																	},
																},
															},
															Value: "_value",
														}, &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   81,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"Animal_name\"",
																	Start: ast.Position{
																		Column: 33,
																		Line:   81,
																	},
																},
															},
															Value: "Animal_name",
														}, &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   81,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"_field\"",
																	Start: ast.Position{
																		Column: 47,
																		Line:   81,
																	},
																},
															},
															Value: "_field",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   81,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "keep(columns: [\"_value\", \"Animal_name\",\"_field\"])",
													Start: ast.Position{
														Column: 8,
														Line:   81,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 12,
															Line:   81,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "keep",
														Start: ast.Position{
															Column: 8,
															Line:   81,
														},
													},
												},
												Name: "keep",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
								}, &ast.VariableAssignment{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 103,
												Line:   83,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")",
											Start: ast.Position{
												Column: 3,
												Line:   83,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 9,
													Line:   83,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "output",
												Start: ast.Position{
													Column: 3,
													Line:   83,
												},
											},
										},
										Name: "output",
									},
									Init: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 102,
														Line:   83,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\"",
													Start: ast.Position{
														Column: 17,
														Line:   83,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   83,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "tables: {Probability_table: Probability_table, r: r}",
														Start: ast.Position{
															Column: 17,
															Line:   83,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   83,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "tables",
															Start: ast.Position{
																Column: 17,
																Line:   83,
															},
														},
													},
													Name: "tables",
												},
												Separator: nil,
												Value: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   83,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "{Probability_table: Probability_table, r: r}",
															Start: ast.Position{
																Column: 25,
																Line:   83,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   83,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "Probability_table: Probability_table",
																Start: ast.Position{
																	Column: 26,
																	Line:   83,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   83,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "Probability_table",
																	Start: ast.Position{
																		Column: 26,
																		Line:   83,
																	},
																},
															},
															Name: "Probability_table",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 62,
																		Line:   83,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "Probability_table",
																	Start: ast.Position{
																		Column: 45,
																		Line:   83,
																	},
																},
															},
															Name: "Probability_table",
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   83,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r: r",
																Start: ast.Position{
																	Column: 64,
																	Line:   83,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   83,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 64,
																		Line:   83,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   83,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 67,
																		Line:   83,
																	},
																},
															},
															Name: "r",
														},
													}},
													Rbrace: nil,
													With:   nil,
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 85,
															Line:   83,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "on: [\"_value\"]",
														Start: ast.Position{
															Column: 71,
															Line:   83,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   83,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "on",
															Start: ast.Position{
																Column: 71,
																Line:   83,
															},
														},
													},
													Name: "on",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 85,
																Line:   83,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "[\"_value\"]",
															Start: ast.Position{
																Column: 75,
																Line:   83,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 84,
																	Line:   83,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_value\"",
																Start: ast.Position{
																	Column: 76,
																	Line:   83,
																},
															},
														},
														Value: "_value",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 102,
															Line:   83,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "method: \"inner\"",
														Start: ast.Position{
															Column: 87,
															Line:   83,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 93,
																Line:   83,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "method",
															Start: ast.Position{
																Column: 87,
																Line:   83,
															},
														},
													},
													Name: "method",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 102,
																Line:   83,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "\"inner\"",
															Start: ast.Position{
																Column: 95,
																Line:   83,
															},
														},
													},
													Value: "inner",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 103,
													Line:   83,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")",
												Start: ast.Position{
													Column: 12,
													Line:   83,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   83,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "join",
													Start: ast.Position{
														Column: 12,
														Line:   83,
													},
												},
											},
											Name: "join",
										},
										Lparen: nil,
										Rparen: nil,
									},
								}, &ast.ReturnStatement{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   84,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "output",
												Start: ast.Position{
													Column: 10,
													Line:   84,
												},
											},
										},
										Name: "output",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   84,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "return output",
											Start: ast.Position{
												Column: 3,
												Line:   84,
											},
										},
									},
								}},
								Lbrace: nil,
								Rbrace: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   79,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "tables=<-",
										Start: ast.Position{
											Column: 19,
											Line:   79,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   79,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 19,
												Line:   79,
											},
										},
									},
									Name: "tables",
								},
								Separator: nil,
								Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   79,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "<-",
										Start: ast.Position{
											Column: 26,
											Line:   79,
										},
									},
								}},
							}},
							Rparan: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   87,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "test_data",
										Start: ast.Position{
											Column: 8,
											Line:   87,
										},
									},
								},
								Name: "test_data",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   87,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "test_data |> predictOverall()",
									Start: ast.Position{
										Column: 8,
										Line:   87,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   87,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "predictOverall()",
										Start: ast.Position{
											Column: 21,
											Line:   87,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   87,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "predictOverall",
											Start: ast.Position{
												Column: 21,
												Line:   87,
											},
										},
									},
									Name: "predictOverall",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   87,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "return test_data |> predictOverall()",
								Start: ast.Position{
									Column: 1,
									Line:   87,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   9,
							},
							File:   "naiveBayesClassifier.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   9,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   9,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   9,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   9,
							},
							File:   "naiveBayesClassifier.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   9,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   9,
							},
							File:   "naiveBayesClassifier.flux",
							Source: "myClass",
							Start: ast.Position{
								Column: 26,
								Line:   9,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   9,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "myClass",
								Start: ast.Position{
									Column: 26,
									Line:   9,
								},
							},
						},
						Name: "myClass",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   9,
							},
							File:   "naiveBayesClassifier.flux",
							Source: "myField",
							Start: ast.Position{
								Column: 35,
								Line:   9,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   9,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "myField",
								Start: ast.Position{
									Column: 35,
									Line:   9,
								},
							},
						},
						Name: "myField",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   9,
							},
							File:   "naiveBayesClassifier.flux",
							Source: "myMeasurement",
							Start: ast.Position{
								Column: 44,
								Line:   9,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   9,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "myMeasurement",
								Start: ast.Position{
									Column: 44,
									Line:   9,
								},
							},
						},
						Name: "myMeasurement",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   7,
					},
					File:   "naiveBayesClassifier.flux",
					Source: "import \"system\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   7,
						},
						File:   "naiveBayesClassifier.flux",
						Source: "\"system\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "system",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "naiveBayesClassifier.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "//Final working code as of August 11, 2020\n"}, ast.Comment{Text: "//Currently supports single field classification and binary data sets \n"}, ast.Comment{Text: "//Please ensure Ruby is installed\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   5,
					},
					File:   "naiveBayesClassifier.flux",
					Source: "package naiveBayesClassifier",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   5,
						},
						File:   "naiveBayesClassifier.flux",
						Source: "naiveBayesClassifier",
						Start: ast.Position{
							Column: 9,
							Line:   5,
						},
					},
				},
				Name: "naiveBayesClassifier",
			},
		},
	}},
	Package: "naiveBayesClassifier",
	Path:    "contrib/RohanSreerama5/naiveBayesClassifier",
}
