// DO NOT EDIT: This file is autogenerated via the builtin command.

package geo

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 30,
					Line:   218,
				},
				File:   "geo.flux",
				Source: "package geo\n\nimport \"experimental\"\nimport \"influxdata/influxdb/v1\"\n\n// Units\noption units = {\n  distance: \"km\"\n}\n\n//\n// Builtin GIS functions\n//\n\n// Returns boolean whether the region contains specified geometry.\nbuiltin stContains : (region: A, geometry: B, units: {distance: string}) => bool where A: Record, B: Record\n\n// Returns distance from given region to specified geometry.\nbuiltin stDistance : (region: A, geometry: B, units: {distance: string}) => float where A: Record, B: Record\n\n// Returns length of a curve.\nbuiltin stLength : (geometry: A, units: {distance: string}) => float where A: Record\n\n//\n// Flux GIS ST functions\n//\n\nST_Contains = (region, geometry, units=units) =>\n  stContains(region: region, geometry: geometry, units: units)\n\nST_Distance = (region, geometry, units=units) =>\n  stDistance(region: region, geometry: geometry, units: units)\n\nST_DWithin = (region, geometry, distance, units=units) =>\n  stDistance(region: region, geometry: geometry, units: units) <= distance\n\nST_Intersects = (region, geometry, units=units) =>\n  stDistance(region: region, geometry: geometry, units: units) <= 0.0\n\nST_Length = (geometry, units=units) =>\n  stLength(geometry: geometry, units: units)\n\n// Non-standard\nST_LineString = (tables=<-) =>\n  tables\n    |> reduce(fn: (r, accumulator) => ({\n        __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n        __count: accumulator.__count + 1\n      }), identity: {\n        __linestring: \"\",\n        __count: 0\n      }\n    )\n    |> drop(columns: [\"__count\"])\n    |> rename(columns: {__linestring: \"st_linestring\"})\n\n//\n// None of the following builtin functions are intended to be used by end users.\n//\n\n// Calculates grid (set of cell ID tokens) for given region and according to options.\nbuiltin getGrid : (region: T, ?minSize: int, ?maxSize: int, ?level: int, ?maxLevel: int, units: {distance: string}) => {level: int , set: [string]} where T: Record\n\n// Returns level of specified cell ID token.\nbuiltin getLevel : (token: string) => int\n\n// Returns cell ID token for given cell or lat/lon point at specified level.\nbuiltin s2CellIDToken : (?token: string, ?point: {lat: float , lon: float}, level: int) => string\n\n// Returns lat/lon coordinates of given cell ID token.\nbuiltin s2CellLatLon : (token: string) => {lat: float , lon: float}\n\n//\n// Flux functions\n//\n\n// Gets level of cell ID tag `s2cellID` from the first record from the first table in the stream.\n_detectLevel = (tables=<-) => {\n  _r0 =\n    tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)\n      |> getRecord(idx: 0)\n  _level =\n    if exists _r0 then\n      getLevel(token: _r0.s2_cell_id)\n    else\n       666\n  return _level\n}\n\n//\n// Convenience functions\n//\n\n// Pivots values to row-wise sets.\ntoRows = (tables=<-) =>\n  tables\n    |> v1.fieldsAsCols()\n\n// Shapes data to meet the requirements of the geo package.\n// Renames fields containing latitude and longitude values to lat and lon.\n// Pivots values to row-wise sets.\n// Generates an s2_cell_id tag for each reach using lat and lon values.\n// Adds the s2_cell_id column to the group key.\nshapeData = (tables=<-, latField, lonField, level) =>\n  tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )\n    |> toRows()\n    |> map(fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })\n    )\n    |> experimental.group(\n      columns: [\"s2_cell_id\"],\n      mode: \"extend\"\n    )\n\n//\n// Filtering functions\n//\n\n// Filters records by a box, a circle or a polygon area using S2 cell ID tag.\n// It is a coarse filter, as the grid always overlays the region, the result will likely contain records\n// with lat/lon outside the specified region.\ngridFilter = (tables=<-, region, minSize=24, maxSize=-1, level=-1, s2cellIDLevel=-1, units=units) => {\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _grid = getGrid(region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel, units: units)\n  return\n    tables\n      |> filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )\n}\n\n// Filters records by specified region.\n// It is an exact filter and must be used after `toRows()` because it requires `lat` and `lon` columns in input row sets.\nstrictFilter = (tables=<-, region) =>\n  tables\n    |> filter(fn: (r) =>\n      ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})\n    )\n\n// Two-phase filtering by specified region.\n// Checks to see if data is already pivoted and contains a lat column.\n// Returns pivoted data.\nfilterRows = (tables=<-, region, minSize=24, maxSize=-1, level=-1, s2cellIDLevel=-1, strict=true) => {\n  _columns =\n    tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )\n      |> getColumn(column: \"_value\")\n  _rows =\n    if contains(value: \"lat\", set: _columns) then\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n    else\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows()\n  _result =\n    if strict then\n      _rows\n        |> strictFilter(region)\n    else\n      _rows\n  return _result\n}\n\n//\n// Grouping functions\n//\n// intended to be used row-wise sets (i.e after `toRows()`)\n\n// Groups data by area of size specified by level. Result is grouped by `newColumn`.\n// Grouping levels: https://s2geometry.io/resources/s2cell_statistics.html\ngroupByArea = (tables=<-, newColumn, level, s2cellIDLevel=-1) => {\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _prepared =\n    if level == _s2cellIDLevel then\n      tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n      tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })\n  return\n    _prepared\n      |> group(columns: [newColumn])\n}\n\n// Groups rows into tracks.\nasTracks = (tables=<-, groupBy=[\"id\",\"tid\"], orderBy=[\"_time\"]) =>\n  tables\n    |> group(columns: groupBy)\n    |> sort(columns: orderBy)",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   10,
						},
						File:   "geo.flux",
						Source: "units = {\n  distance: \"km\"\n}",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   8,
							},
							File:   "geo.flux",
							Source: "units",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "units",
				},
				Init: &ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   10,
							},
							File:   "geo.flux",
							Source: "{\n  distance: \"km\"\n}",
							Start: ast.Position{
								Column: 16,
								Line:   8,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   9,
								},
								File:   "geo.flux",
								Source: "distance: \"km\"",
								Start: ast.Position{
									Column: 3,
									Line:   9,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   9,
									},
									File:   "geo.flux",
									Source: "distance",
									Start: ast.Position{
										Column: 3,
										Line:   9,
									},
								},
							},
							Name: "distance",
						},
						Separator: nil,
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   9,
									},
									File:   "geo.flux",
									Source: "\"km\"",
									Start: ast.Position{
										Column: 13,
										Line:   9,
									},
								},
							},
							Value: "km",
						},
					}},
					Rbrace: nil,
					With:   nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Units\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   10,
					},
					File:   "geo.flux",
					Source: "option units = {\n  distance: \"km\"\n}",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Builtin GIS functions\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Returns boolean whether the region contains specified geometry.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   17,
					},
					File:   "geo.flux",
					Source: "builtin stContains",
					Start: ast.Position{
						Column: 1,
						Line:   17,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   17,
						},
						File:   "geo.flux",
						Source: "stContains",
						Start: ast.Position{
							Column: 9,
							Line:   17,
						},
					},
				},
				Name: "stContains",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 108,
							Line:   17,
						},
						File:   "geo.flux",
						Source: "(region: A, geometry: B, units: {distance: string}) => bool where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   17,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   17,
							},
							File:   "geo.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 88,
								Line:   17,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 91,
									Line:   17,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "A",
								Start: ast.Position{
									Column: 88,
									Line:   17,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 108,
								Line:   17,
							},
							File:   "geo.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 99,
								Line:   17,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 102,
									Line:   17,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "B",
								Start: ast.Position{
									Column: 99,
									Line:   17,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   17,
							},
							File:   "geo.flux",
							Source: "(region: A, geometry: B, units: {distance: string}) => bool",
							Start: ast.Position{
								Column: 22,
								Line:   17,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "region: A",
								Start: ast.Position{
									Column: 23,
									Line:   17,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "region",
									Start: ast.Position{
										Column: 23,
										Line:   17,
									},
								},
							},
							Name: "region",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "A",
									Start: ast.Position{
										Column: 31,
										Line:   17,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   17,
										},
										File:   "geo.flux",
										Source: "A",
										Start: ast.Position{
											Column: 31,
											Line:   17,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "geometry: B",
								Start: ast.Position{
									Column: 34,
									Line:   17,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "geometry",
									Start: ast.Position{
										Column: 34,
										Line:   17,
									},
								},
							},
							Name: "geometry",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "B",
									Start: ast.Position{
										Column: 44,
										Line:   17,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   17,
										},
										File:   "geo.flux",
										Source: "B",
										Start: ast.Position{
											Column: 44,
											Line:   17,
										},
									},
								},
								Name: "B",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "units: {distance: string}",
								Start: ast.Position{
									Column: 47,
									Line:   17,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "units",
									Start: ast.Position{
										Column: 47,
										Line:   17,
									},
								},
							},
							Name: "units",
						},
						Ty: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "{distance: string}",
									Start: ast.Position{
										Column: 54,
										Line:   17,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   17,
										},
										File:   "geo.flux",
										Source: "distance: string",
										Start: ast.Position{
											Column: 55,
											Line:   17,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   17,
											},
											File:   "geo.flux",
											Source: "distance",
											Start: ast.Position{
												Column: 55,
												Line:   17,
											},
										},
									},
									Name: "distance",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   17,
											},
											File:   "geo.flux",
											Source: "string",
											Start: ast.Position{
												Column: 65,
												Line:   17,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   17,
												},
												File:   "geo.flux",
												Source: "string",
												Start: ast.Position{
													Column: 65,
													Line:   17,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Tvar: nil,
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 77,
									Line:   17,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 77,
										Line:   17,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Returns distance from given region to specified geometry.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   20,
					},
					File:   "geo.flux",
					Source: "builtin stDistance",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   20,
						},
						File:   "geo.flux",
						Source: "stDistance",
						Start: ast.Position{
							Column: 9,
							Line:   20,
						},
					},
				},
				Name: "stDistance",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 109,
							Line:   20,
						},
						File:   "geo.flux",
						Source: "(region: A, geometry: B, units: {distance: string}) => float where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   20,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 98,
								Line:   20,
							},
							File:   "geo.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 89,
								Line:   20,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 98,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 92,
									Line:   20,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "A",
								Start: ast.Position{
									Column: 89,
									Line:   20,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 109,
								Line:   20,
							},
							File:   "geo.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 100,
								Line:   20,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 109,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 103,
									Line:   20,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "B",
								Start: ast.Position{
									Column: 100,
									Line:   20,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   20,
							},
							File:   "geo.flux",
							Source: "(region: A, geometry: B, units: {distance: string}) => float",
							Start: ast.Position{
								Column: 22,
								Line:   20,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "region: A",
								Start: ast.Position{
									Column: 23,
									Line:   20,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "region",
									Start: ast.Position{
										Column: 23,
										Line:   20,
									},
								},
							},
							Name: "region",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "A",
									Start: ast.Position{
										Column: 31,
										Line:   20,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   20,
										},
										File:   "geo.flux",
										Source: "A",
										Start: ast.Position{
											Column: 31,
											Line:   20,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "geometry: B",
								Start: ast.Position{
									Column: 34,
									Line:   20,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "geometry",
									Start: ast.Position{
										Column: 34,
										Line:   20,
									},
								},
							},
							Name: "geometry",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "B",
									Start: ast.Position{
										Column: 44,
										Line:   20,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   20,
										},
										File:   "geo.flux",
										Source: "B",
										Start: ast.Position{
											Column: 44,
											Line:   20,
										},
									},
								},
								Name: "B",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "units: {distance: string}",
								Start: ast.Position{
									Column: 47,
									Line:   20,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "units",
									Start: ast.Position{
										Column: 47,
										Line:   20,
									},
								},
							},
							Name: "units",
						},
						Ty: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "{distance: string}",
									Start: ast.Position{
										Column: 54,
										Line:   20,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   20,
										},
										File:   "geo.flux",
										Source: "distance: string",
										Start: ast.Position{
											Column: 55,
											Line:   20,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   20,
											},
											File:   "geo.flux",
											Source: "distance",
											Start: ast.Position{
												Column: 55,
												Line:   20,
											},
										},
									},
									Name: "distance",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   20,
											},
											File:   "geo.flux",
											Source: "string",
											Start: ast.Position{
												Column: 65,
												Line:   20,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   20,
												},
												File:   "geo.flux",
												Source: "string",
												Start: ast.Position{
													Column: 65,
													Line:   20,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Tvar: nil,
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "float",
								Start: ast.Position{
									Column: 77,
									Line:   20,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 82,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "float",
									Start: ast.Position{
										Column: 77,
										Line:   20,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Returns length of a curve.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   23,
					},
					File:   "geo.flux",
					Source: "builtin stLength",
					Start: ast.Position{
						Column: 1,
						Line:   23,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   23,
						},
						File:   "geo.flux",
						Source: "stLength",
						Start: ast.Position{
							Column: 9,
							Line:   23,
						},
					},
				},
				Name: "stLength",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   23,
						},
						File:   "geo.flux",
						Source: "(geometry: A, units: {distance: string}) => float where A: Record",
						Start: ast.Position{
							Column: 20,
							Line:   23,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   23,
							},
							File:   "geo.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 76,
								Line:   23,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   23,
								},
								File:   "geo.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 79,
									Line:   23,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   23,
								},
								File:   "geo.flux",
								Source: "A",
								Start: ast.Position{
									Column: 76,
									Line:   23,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 69,
								Line:   23,
							},
							File:   "geo.flux",
							Source: "(geometry: A, units: {distance: string}) => float",
							Start: ast.Position{
								Column: 20,
								Line:   23,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   23,
								},
								File:   "geo.flux",
								Source: "geometry: A",
								Start: ast.Position{
									Column: 21,
									Line:   23,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   23,
									},
									File:   "geo.flux",
									Source: "geometry",
									Start: ast.Position{
										Column: 21,
										Line:   23,
									},
								},
							},
							Name: "geometry",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   23,
									},
									File:   "geo.flux",
									Source: "A",
									Start: ast.Position{
										Column: 31,
										Line:   23,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   23,
										},
										File:   "geo.flux",
										Source: "A",
										Start: ast.Position{
											Column: 31,
											Line:   23,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   23,
								},
								File:   "geo.flux",
								Source: "units: {distance: string}",
								Start: ast.Position{
									Column: 34,
									Line:   23,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   23,
									},
									File:   "geo.flux",
									Source: "units",
									Start: ast.Position{
										Column: 34,
										Line:   23,
									},
								},
							},
							Name: "units",
						},
						Ty: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   23,
									},
									File:   "geo.flux",
									Source: "{distance: string}",
									Start: ast.Position{
										Column: 41,
										Line:   23,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   23,
										},
										File:   "geo.flux",
										Source: "distance: string",
										Start: ast.Position{
											Column: 42,
											Line:   23,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   23,
											},
											File:   "geo.flux",
											Source: "distance",
											Start: ast.Position{
												Column: 42,
												Line:   23,
											},
										},
									},
									Name: "distance",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   23,
											},
											File:   "geo.flux",
											Source: "string",
											Start: ast.Position{
												Column: 52,
												Line:   23,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   23,
												},
												File:   "geo.flux",
												Source: "string",
												Start: ast.Position{
													Column: 52,
													Line:   23,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Tvar: nil,
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   23,
								},
								File:   "geo.flux",
								Source: "float",
								Start: ast.Position{
									Column: 64,
									Line:   23,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   23,
									},
									File:   "geo.flux",
									Source: "float",
									Start: ast.Position{
										Column: 64,
										Line:   23,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 63,
						Line:   30,
					},
					File:   "geo.flux",
					Source: "ST_Contains = (region, geometry, units=units) =>\n  stContains(region: region, geometry: geometry, units: units)",
					Start: ast.Position{
						Column: 1,
						Line:   29,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Flux GIS ST functions\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   29,
						},
						File:   "geo.flux",
						Source: "ST_Contains",
						Start: ast.Position{
							Column: 1,
							Line:   29,
						},
					},
				},
				Name: "ST_Contains",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 63,
							Line:   30,
						},
						File:   "geo.flux",
						Source: "(region, geometry, units=units) =>\n  stContains(region: region, geometry: geometry, units: units)",
						Start: ast.Position{
							Column: 15,
							Line:   29,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   30,
								},
								File:   "geo.flux",
								Source: "region: region, geometry: geometry, units: units",
								Start: ast.Position{
									Column: 14,
									Line:   30,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   30,
									},
									File:   "geo.flux",
									Source: "region: region",
									Start: ast.Position{
										Column: 14,
										Line:   30,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   30,
										},
										File:   "geo.flux",
										Source: "region",
										Start: ast.Position{
											Column: 14,
											Line:   30,
										},
									},
								},
								Name: "region",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   30,
										},
										File:   "geo.flux",
										Source: "region",
										Start: ast.Position{
											Column: 22,
											Line:   30,
										},
									},
								},
								Name: "region",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   30,
									},
									File:   "geo.flux",
									Source: "geometry: geometry",
									Start: ast.Position{
										Column: 30,
										Line:   30,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   30,
										},
										File:   "geo.flux",
										Source: "geometry",
										Start: ast.Position{
											Column: 30,
											Line:   30,
										},
									},
								},
								Name: "geometry",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   30,
										},
										File:   "geo.flux",
										Source: "geometry",
										Start: ast.Position{
											Column: 40,
											Line:   30,
										},
									},
								},
								Name: "geometry",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   30,
									},
									File:   "geo.flux",
									Source: "units: units",
									Start: ast.Position{
										Column: 50,
										Line:   30,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   30,
										},
										File:   "geo.flux",
										Source: "units",
										Start: ast.Position{
											Column: 50,
											Line:   30,
										},
									},
								},
								Name: "units",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   30,
										},
										File:   "geo.flux",
										Source: "units",
										Start: ast.Position{
											Column: 57,
											Line:   30,
										},
									},
								},
								Name: "units",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 63,
								Line:   30,
							},
							File:   "geo.flux",
							Source: "stContains(region: region, geometry: geometry, units: units)",
							Start: ast.Position{
								Column: 3,
								Line:   30,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   30,
								},
								File:   "geo.flux",
								Source: "stContains",
								Start: ast.Position{
									Column: 3,
									Line:   30,
								},
							},
						},
						Name: "stContains",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   29,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 16,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   29,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 16,
									Line:   29,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   29,
							},
							File:   "geo.flux",
							Source: "geometry",
							Start: ast.Position{
								Column: 24,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   29,
								},
								File:   "geo.flux",
								Source: "geometry",
								Start: ast.Position{
									Column: 24,
									Line:   29,
								},
							},
						},
						Name: "geometry",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   29,
							},
							File:   "geo.flux",
							Source: "units=units",
							Start: ast.Position{
								Column: 34,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   29,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 34,
									Line:   29,
								},
							},
						},
						Name: "units",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   29,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 40,
									Line:   29,
								},
							},
						},
						Name: "units",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 63,
						Line:   33,
					},
					File:   "geo.flux",
					Source: "ST_Distance = (region, geometry, units=units) =>\n  stDistance(region: region, geometry: geometry, units: units)",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   32,
						},
						File:   "geo.flux",
						Source: "ST_Distance",
						Start: ast.Position{
							Column: 1,
							Line:   32,
						},
					},
				},
				Name: "ST_Distance",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 63,
							Line:   33,
						},
						File:   "geo.flux",
						Source: "(region, geometry, units=units) =>\n  stDistance(region: region, geometry: geometry, units: units)",
						Start: ast.Position{
							Column: 15,
							Line:   32,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   33,
								},
								File:   "geo.flux",
								Source: "region: region, geometry: geometry, units: units",
								Start: ast.Position{
									Column: 14,
									Line:   33,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   33,
									},
									File:   "geo.flux",
									Source: "region: region",
									Start: ast.Position{
										Column: 14,
										Line:   33,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   33,
										},
										File:   "geo.flux",
										Source: "region",
										Start: ast.Position{
											Column: 14,
											Line:   33,
										},
									},
								},
								Name: "region",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   33,
										},
										File:   "geo.flux",
										Source: "region",
										Start: ast.Position{
											Column: 22,
											Line:   33,
										},
									},
								},
								Name: "region",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   33,
									},
									File:   "geo.flux",
									Source: "geometry: geometry",
									Start: ast.Position{
										Column: 30,
										Line:   33,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   33,
										},
										File:   "geo.flux",
										Source: "geometry",
										Start: ast.Position{
											Column: 30,
											Line:   33,
										},
									},
								},
								Name: "geometry",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   33,
										},
										File:   "geo.flux",
										Source: "geometry",
										Start: ast.Position{
											Column: 40,
											Line:   33,
										},
									},
								},
								Name: "geometry",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   33,
									},
									File:   "geo.flux",
									Source: "units: units",
									Start: ast.Position{
										Column: 50,
										Line:   33,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   33,
										},
										File:   "geo.flux",
										Source: "units",
										Start: ast.Position{
											Column: 50,
											Line:   33,
										},
									},
								},
								Name: "units",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   33,
										},
										File:   "geo.flux",
										Source: "units",
										Start: ast.Position{
											Column: 57,
											Line:   33,
										},
									},
								},
								Name: "units",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 63,
								Line:   33,
							},
							File:   "geo.flux",
							Source: "stDistance(region: region, geometry: geometry, units: units)",
							Start: ast.Position{
								Column: 3,
								Line:   33,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   33,
								},
								File:   "geo.flux",
								Source: "stDistance",
								Start: ast.Position{
									Column: 3,
									Line:   33,
								},
							},
						},
						Name: "stDistance",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   32,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 16,
								Line:   32,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   32,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 16,
									Line:   32,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   32,
							},
							File:   "geo.flux",
							Source: "geometry",
							Start: ast.Position{
								Column: 24,
								Line:   32,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   32,
								},
								File:   "geo.flux",
								Source: "geometry",
								Start: ast.Position{
									Column: 24,
									Line:   32,
								},
							},
						},
						Name: "geometry",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   32,
							},
							File:   "geo.flux",
							Source: "units=units",
							Start: ast.Position{
								Column: 34,
								Line:   32,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   32,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 34,
									Line:   32,
								},
							},
						},
						Name: "units",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   32,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 40,
									Line:   32,
								},
							},
						},
						Name: "units",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 75,
						Line:   36,
					},
					File:   "geo.flux",
					Source: "ST_DWithin = (region, geometry, distance, units=units) =>\n  stDistance(region: region, geometry: geometry, units: units) <= distance",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   35,
						},
						File:   "geo.flux",
						Source: "ST_DWithin",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "ST_DWithin",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 75,
							Line:   36,
						},
						File:   "geo.flux",
						Source: "(region, geometry, distance, units=units) =>\n  stDistance(region: region, geometry: geometry, units: units) <= distance",
						Start: ast.Position{
							Column: 14,
							Line:   35,
						},
					},
				},
				Body: &ast.BinaryExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 75,
								Line:   36,
							},
							File:   "geo.flux",
							Source: "stDistance(region: region, geometry: geometry, units: units) <= distance",
							Start: ast.Position{
								Column: 3,
								Line:   36,
							},
						},
					},
					Left: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   36,
									},
									File:   "geo.flux",
									Source: "region: region, geometry: geometry, units: units",
									Start: ast.Position{
										Column: 14,
										Line:   36,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   36,
										},
										File:   "geo.flux",
										Source: "region: region",
										Start: ast.Position{
											Column: 14,
											Line:   36,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   36,
											},
											File:   "geo.flux",
											Source: "region",
											Start: ast.Position{
												Column: 14,
												Line:   36,
											},
										},
									},
									Name: "region",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   36,
											},
											File:   "geo.flux",
											Source: "region",
											Start: ast.Position{
												Column: 22,
												Line:   36,
											},
										},
									},
									Name: "region",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   36,
										},
										File:   "geo.flux",
										Source: "geometry: geometry",
										Start: ast.Position{
											Column: 30,
											Line:   36,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   36,
											},
											File:   "geo.flux",
											Source: "geometry",
											Start: ast.Position{
												Column: 30,
												Line:   36,
											},
										},
									},
									Name: "geometry",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   36,
											},
											File:   "geo.flux",
											Source: "geometry",
											Start: ast.Position{
												Column: 40,
												Line:   36,
											},
										},
									},
									Name: "geometry",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   36,
										},
										File:   "geo.flux",
										Source: "units: units",
										Start: ast.Position{
											Column: 50,
											Line:   36,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   36,
											},
											File:   "geo.flux",
											Source: "units",
											Start: ast.Position{
												Column: 50,
												Line:   36,
											},
										},
									},
									Name: "units",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 62,
												Line:   36,
											},
											File:   "geo.flux",
											Source: "units",
											Start: ast.Position{
												Column: 57,
												Line:   36,
											},
										},
									},
									Name: "units",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   36,
								},
								File:   "geo.flux",
								Source: "stDistance(region: region, geometry: geometry, units: units)",
								Start: ast.Position{
									Column: 3,
									Line:   36,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   36,
									},
									File:   "geo.flux",
									Source: "stDistance",
									Start: ast.Position{
										Column: 3,
										Line:   36,
									},
								},
							},
							Name: "stDistance",
						},
						Lparen: nil,
						Rparen: nil,
					},
					Operator: 7,
					Right: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   36,
								},
								File:   "geo.flux",
								Source: "distance",
								Start: ast.Position{
									Column: 67,
									Line:   36,
								},
							},
						},
						Name: "distance",
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   35,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 15,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   35,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 15,
									Line:   35,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   35,
							},
							File:   "geo.flux",
							Source: "geometry",
							Start: ast.Position{
								Column: 23,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   35,
								},
								File:   "geo.flux",
								Source: "geometry",
								Start: ast.Position{
									Column: 23,
									Line:   35,
								},
							},
						},
						Name: "geometry",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   35,
							},
							File:   "geo.flux",
							Source: "distance",
							Start: ast.Position{
								Column: 33,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   35,
								},
								File:   "geo.flux",
								Source: "distance",
								Start: ast.Position{
									Column: 33,
									Line:   35,
								},
							},
						},
						Name: "distance",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   35,
							},
							File:   "geo.flux",
							Source: "units=units",
							Start: ast.Position{
								Column: 43,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   35,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 43,
									Line:   35,
								},
							},
						},
						Name: "units",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   35,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 49,
									Line:   35,
								},
							},
						},
						Name: "units",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 70,
						Line:   39,
					},
					File:   "geo.flux",
					Source: "ST_Intersects = (region, geometry, units=units) =>\n  stDistance(region: region, geometry: geometry, units: units) <= 0.0",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   38,
						},
						File:   "geo.flux",
						Source: "ST_Intersects",
						Start: ast.Position{
							Column: 1,
							Line:   38,
						},
					},
				},
				Name: "ST_Intersects",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   39,
						},
						File:   "geo.flux",
						Source: "(region, geometry, units=units) =>\n  stDistance(region: region, geometry: geometry, units: units) <= 0.0",
						Start: ast.Position{
							Column: 17,
							Line:   38,
						},
					},
				},
				Body: &ast.BinaryExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   39,
							},
							File:   "geo.flux",
							Source: "stDistance(region: region, geometry: geometry, units: units) <= 0.0",
							Start: ast.Position{
								Column: 3,
								Line:   39,
							},
						},
					},
					Left: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   39,
									},
									File:   "geo.flux",
									Source: "region: region, geometry: geometry, units: units",
									Start: ast.Position{
										Column: 14,
										Line:   39,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   39,
										},
										File:   "geo.flux",
										Source: "region: region",
										Start: ast.Position{
											Column: 14,
											Line:   39,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   39,
											},
											File:   "geo.flux",
											Source: "region",
											Start: ast.Position{
												Column: 14,
												Line:   39,
											},
										},
									},
									Name: "region",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   39,
											},
											File:   "geo.flux",
											Source: "region",
											Start: ast.Position{
												Column: 22,
												Line:   39,
											},
										},
									},
									Name: "region",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   39,
										},
										File:   "geo.flux",
										Source: "geometry: geometry",
										Start: ast.Position{
											Column: 30,
											Line:   39,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   39,
											},
											File:   "geo.flux",
											Source: "geometry",
											Start: ast.Position{
												Column: 30,
												Line:   39,
											},
										},
									},
									Name: "geometry",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   39,
											},
											File:   "geo.flux",
											Source: "geometry",
											Start: ast.Position{
												Column: 40,
												Line:   39,
											},
										},
									},
									Name: "geometry",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   39,
										},
										File:   "geo.flux",
										Source: "units: units",
										Start: ast.Position{
											Column: 50,
											Line:   39,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   39,
											},
											File:   "geo.flux",
											Source: "units",
											Start: ast.Position{
												Column: 50,
												Line:   39,
											},
										},
									},
									Name: "units",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 62,
												Line:   39,
											},
											File:   "geo.flux",
											Source: "units",
											Start: ast.Position{
												Column: 57,
												Line:   39,
											},
										},
									},
									Name: "units",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   39,
								},
								File:   "geo.flux",
								Source: "stDistance(region: region, geometry: geometry, units: units)",
								Start: ast.Position{
									Column: 3,
									Line:   39,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   39,
									},
									File:   "geo.flux",
									Source: "stDistance",
									Start: ast.Position{
										Column: 3,
										Line:   39,
									},
								},
							},
							Name: "stDistance",
						},
						Lparen: nil,
						Rparen: nil,
					},
					Operator: 7,
					Right: &ast.FloatLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   39,
								},
								File:   "geo.flux",
								Source: "0.0",
								Start: ast.Position{
									Column: 67,
									Line:   39,
								},
							},
						},
						Value: 0.0,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   38,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 18,
								Line:   38,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   38,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 18,
									Line:   38,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   38,
							},
							File:   "geo.flux",
							Source: "geometry",
							Start: ast.Position{
								Column: 26,
								Line:   38,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   38,
								},
								File:   "geo.flux",
								Source: "geometry",
								Start: ast.Position{
									Column: 26,
									Line:   38,
								},
							},
						},
						Name: "geometry",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   38,
							},
							File:   "geo.flux",
							Source: "units=units",
							Start: ast.Position{
								Column: 36,
								Line:   38,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   38,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 36,
									Line:   38,
								},
							},
						},
						Name: "units",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   38,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 42,
									Line:   38,
								},
							},
						},
						Name: "units",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 45,
						Line:   42,
					},
					File:   "geo.flux",
					Source: "ST_Length = (geometry, units=units) =>\n  stLength(geometry: geometry, units: units)",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   41,
						},
						File:   "geo.flux",
						Source: "ST_Length",
						Start: ast.Position{
							Column: 1,
							Line:   41,
						},
					},
				},
				Name: "ST_Length",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   42,
						},
						File:   "geo.flux",
						Source: "(geometry, units=units) =>\n  stLength(geometry: geometry, units: units)",
						Start: ast.Position{
							Column: 13,
							Line:   41,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   42,
								},
								File:   "geo.flux",
								Source: "geometry: geometry, units: units",
								Start: ast.Position{
									Column: 12,
									Line:   42,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   42,
									},
									File:   "geo.flux",
									Source: "geometry: geometry",
									Start: ast.Position{
										Column: 12,
										Line:   42,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   42,
										},
										File:   "geo.flux",
										Source: "geometry",
										Start: ast.Position{
											Column: 12,
											Line:   42,
										},
									},
								},
								Name: "geometry",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   42,
										},
										File:   "geo.flux",
										Source: "geometry",
										Start: ast.Position{
											Column: 22,
											Line:   42,
										},
									},
								},
								Name: "geometry",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   42,
									},
									File:   "geo.flux",
									Source: "units: units",
									Start: ast.Position{
										Column: 32,
										Line:   42,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   42,
										},
										File:   "geo.flux",
										Source: "units",
										Start: ast.Position{
											Column: 32,
											Line:   42,
										},
									},
								},
								Name: "units",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   42,
										},
										File:   "geo.flux",
										Source: "units",
										Start: ast.Position{
											Column: 39,
											Line:   42,
										},
									},
								},
								Name: "units",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   42,
							},
							File:   "geo.flux",
							Source: "stLength(geometry: geometry, units: units)",
							Start: ast.Position{
								Column: 3,
								Line:   42,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   42,
								},
								File:   "geo.flux",
								Source: "stLength",
								Start: ast.Position{
									Column: 3,
									Line:   42,
								},
							},
						},
						Name: "stLength",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   41,
							},
							File:   "geo.flux",
							Source: "geometry",
							Start: ast.Position{
								Column: 14,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   41,
								},
								File:   "geo.flux",
								Source: "geometry",
								Start: ast.Position{
									Column: 14,
									Line:   41,
								},
							},
						},
						Name: "geometry",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   41,
							},
							File:   "geo.flux",
							Source: "units=units",
							Start: ast.Position{
								Column: 24,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   41,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 24,
									Line:   41,
								},
							},
						},
						Name: "units",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   41,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 30,
									Line:   41,
								},
							},
						},
						Name: "units",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 56,
						Line:   56,
					},
					File:   "geo.flux",
					Source: "ST_LineString = (tables=<-) =>\n  tables\n    |> reduce(fn: (r, accumulator) => ({\n        __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n        __count: accumulator.__count + 1\n      }), identity: {\n        __linestring: \"\",\n        __count: 0\n      }\n    )\n    |> drop(columns: [\"__count\"])\n    |> rename(columns: {__linestring: \"st_linestring\"})",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Non-standard\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   45,
						},
						File:   "geo.flux",
						Source: "ST_LineString",
						Start: ast.Position{
							Column: 1,
							Line:   45,
						},
					},
				},
				Name: "ST_LineString",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 56,
							Line:   56,
						},
						File:   "geo.flux",
						Source: "(tables=<-) =>\n  tables\n    |> reduce(fn: (r, accumulator) => ({\n        __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n        __count: accumulator.__count + 1\n      }), identity: {\n        __linestring: \"\",\n        __count: 0\n      }\n    )\n    |> drop(columns: [\"__count\"])\n    |> rename(columns: {__linestring: \"st_linestring\"})",
						Start: ast.Position{
							Column: 17,
							Line:   45,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   46,
										},
										File:   "geo.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 3,
											Line:   46,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   54,
									},
									File:   "geo.flux",
									Source: "tables\n    |> reduce(fn: (r, accumulator) => ({\n        __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n        __count: accumulator.__count + 1\n      }), identity: {\n        __linestring: \"\",\n        __count: 0\n      }\n    )",
									Start: ast.Position{
										Column: 3,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   53,
											},
											File:   "geo.flux",
											Source: "fn: (r, accumulator) => ({\n        __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n        __count: accumulator.__count + 1\n      }), identity: {\n        __linestring: \"\",\n        __count: 0\n      }",
											Start: ast.Position{
												Column: 15,
												Line:   47,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 9,
													Line:   50,
												},
												File:   "geo.flux",
												Source: "fn: (r, accumulator) => ({\n        __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n        __count: accumulator.__count + 1\n      })",
												Start: ast.Position{
													Column: 15,
													Line:   47,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   47,
													},
													File:   "geo.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 15,
														Line:   47,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 9,
														Line:   50,
													},
													File:   "geo.flux",
													Source: "(r, accumulator) => ({\n        __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n        __count: accumulator.__count + 1\n      })",
													Start: ast.Position{
														Column: 19,
														Line:   47,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 9,
															Line:   50,
														},
														File:   "geo.flux",
														Source: "({\n        __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n        __count: accumulator.__count + 1\n      })",
														Start: ast.Position{
															Column: 39,
															Line:   47,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 8,
																Line:   50,
															},
															File:   "geo.flux",
															Source: "{\n        __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n        __count: accumulator.__count + 1\n      }",
															Start: ast.Position{
																Column: 40,
																Line:   47,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 140,
																	Line:   48,
																},
																File:   "geo.flux",
																Source: "__linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat)",
																Start: ast.Position{
																	Column: 9,
																	Line:   48,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   48,
																	},
																	File:   "geo.flux",
																	Source: "__linestring",
																	Start: ast.Position{
																		Column: 9,
																		Line:   48,
																	},
																},
															},
															Name: "__linestring",
														},
														Separator: nil,
														Value: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 140,
																		Line:   48,
																	},
																	File:   "geo.flux",
																	Source: "accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat)",
																	Start: ast.Position{
																		Column: 23,
																		Line:   48,
																	},
																},
															},
															Left: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 121,
																			Line:   48,
																		},
																		File:   "geo.flux",
																		Source: "accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \"",
																		Start: ast.Position{
																			Column: 23,
																			Line:   48,
																		},
																	},
																},
																Left: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 115,
																				Line:   48,
																			},
																			File:   "geo.flux",
																			Source: "accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon)",
																			Start: ast.Position{
																				Column: 23,
																				Line:   48,
																			},
																		},
																	},
																	Left: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 96,
																					Line:   48,
																				},
																				File:   "geo.flux",
																				Source: "accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\")",
																				Start: ast.Position{
																					Column: 23,
																					Line:   48,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   48,
																					},
																					File:   "geo.flux",
																					Source: "accumulator.__linestring",
																					Start: ast.Position{
																						Column: 23,
																						Line:   48,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 34,
																							Line:   48,
																						},
																						File:   "geo.flux",
																						Source: "accumulator",
																						Start: ast.Position{
																							Column: 23,
																							Line:   48,
																						},
																					},
																				},
																				Name: "accumulator",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 47,
																							Line:   48,
																						},
																						File:   "geo.flux",
																						Source: "__linestring",
																						Start: ast.Position{
																							Column: 35,
																							Line:   48,
																						},
																					},
																				},
																				Name: "__linestring",
																			},
																			Rbrack: nil,
																		},
																		Operator: 5,
																		Right: &ast.ParenExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 96,
																						Line:   48,
																					},
																					File:   "geo.flux",
																					Source: "(if accumulator.__count > 0 then \", \" else \"\")",
																					Start: ast.Position{
																						Column: 50,
																						Line:   48,
																					},
																				},
																			},
																			Expression: &ast.ConditionalExpression{
																				Alternate: &ast.StringLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 95,
																								Line:   48,
																							},
																							File:   "geo.flux",
																							Source: "\"\"",
																							Start: ast.Position{
																								Column: 93,
																								Line:   48,
																							},
																						},
																					},
																					Value: "",
																				},
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 95,
																							Line:   48,
																						},
																						File:   "geo.flux",
																						Source: "if accumulator.__count > 0 then \", \" else \"\"",
																						Start: ast.Position{
																							Column: 51,
																							Line:   48,
																						},
																					},
																				},
																				Consequent: &ast.StringLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 87,
																								Line:   48,
																							},
																							File:   "geo.flux",
																							Source: "\", \"",
																							Start: ast.Position{
																								Column: 83,
																								Line:   48,
																							},
																						},
																					},
																					Value: ", ",
																				},
																				Test: &ast.BinaryExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 77,
																								Line:   48,
																							},
																							File:   "geo.flux",
																							Source: "accumulator.__count > 0",
																							Start: ast.Position{
																								Column: 54,
																								Line:   48,
																							},
																						},
																					},
																					Left: &ast.MemberExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 73,
																									Line:   48,
																								},
																								File:   "geo.flux",
																								Source: "accumulator.__count",
																								Start: ast.Position{
																									Column: 54,
																									Line:   48,
																								},
																							},
																						},
																						Lbrack: nil,
																						Object: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 65,
																										Line:   48,
																									},
																									File:   "geo.flux",
																									Source: "accumulator",
																									Start: ast.Position{
																										Column: 54,
																										Line:   48,
																									},
																								},
																							},
																							Name: "accumulator",
																						},
																						Property: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 73,
																										Line:   48,
																									},
																									File:   "geo.flux",
																									Source: "__count",
																									Start: ast.Position{
																										Column: 66,
																										Line:   48,
																									},
																								},
																							},
																							Name: "__count",
																						},
																						Rbrack: nil,
																					},
																					Operator: 10,
																					Right: &ast.IntegerLiteral{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 77,
																									Line:   48,
																								},
																								File:   "geo.flux",
																								Source: "0",
																								Start: ast.Position{
																									Column: 76,
																									Line:   48,
																								},
																							},
																						},
																						Value: int64(0),
																					},
																				},
																				Tk_else: nil,
																				Tk_if:   nil,
																				Tk_then: nil,
																			},
																			Lparen: nil,
																			Rparen: nil,
																		},
																	},
																	Operator: 5,
																	Right: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 114,
																						Line:   48,
																					},
																					File:   "geo.flux",
																					Source: "v: r.lon",
																					Start: ast.Position{
																						Column: 106,
																						Line:   48,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 114,
																							Line:   48,
																						},
																						File:   "geo.flux",
																						Source: "v: r.lon",
																						Start: ast.Position{
																							Column: 106,
																							Line:   48,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 107,
																								Line:   48,
																							},
																							File:   "geo.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 106,
																								Line:   48,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.MemberExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 114,
																								Line:   48,
																							},
																							File:   "geo.flux",
																							Source: "r.lon",
																							Start: ast.Position{
																								Column: 109,
																								Line:   48,
																							},
																						},
																					},
																					Lbrack: nil,
																					Object: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 110,
																									Line:   48,
																								},
																								File:   "geo.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 109,
																									Line:   48,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Property: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 114,
																									Line:   48,
																								},
																								File:   "geo.flux",
																								Source: "lon",
																								Start: ast.Position{
																									Column: 111,
																									Line:   48,
																								},
																							},
																						},
																						Name: "lon",
																					},
																					Rbrack: nil,
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 115,
																					Line:   48,
																				},
																				File:   "geo.flux",
																				Source: "string(v: r.lon)",
																				Start: ast.Position{
																					Column: 99,
																					Line:   48,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 105,
																						Line:   48,
																					},
																					File:   "geo.flux",
																					Source: "string",
																					Start: ast.Position{
																						Column: 99,
																						Line:   48,
																					},
																				},
																			},
																			Name: "string",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																},
																Operator: 5,
																Right: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 121,
																				Line:   48,
																			},
																			File:   "geo.flux",
																			Source: "\" \"",
																			Start: ast.Position{
																				Column: 118,
																				Line:   48,
																			},
																		},
																	},
																	Value: " ",
																},
															},
															Operator: 5,
															Right: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 139,
																				Line:   48,
																			},
																			File:   "geo.flux",
																			Source: "v: r.lat",
																			Start: ast.Position{
																				Column: 131,
																				Line:   48,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 139,
																					Line:   48,
																				},
																				File:   "geo.flux",
																				Source: "v: r.lat",
																				Start: ast.Position{
																					Column: 131,
																					Line:   48,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 132,
																						Line:   48,
																					},
																					File:   "geo.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 131,
																						Line:   48,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 139,
																						Line:   48,
																					},
																					File:   "geo.flux",
																					Source: "r.lat",
																					Start: ast.Position{
																						Column: 134,
																						Line:   48,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 135,
																							Line:   48,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 134,
																							Line:   48,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 139,
																							Line:   48,
																						},
																						File:   "geo.flux",
																						Source: "lat",
																						Start: ast.Position{
																							Column: 136,
																							Line:   48,
																						},
																					},
																				},
																				Name: "lat",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 140,
																			Line:   48,
																		},
																		File:   "geo.flux",
																		Source: "string(v: r.lat)",
																		Start: ast.Position{
																			Column: 124,
																			Line:   48,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 130,
																				Line:   48,
																			},
																			File:   "geo.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 124,
																				Line:   48,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   49,
																},
																File:   "geo.flux",
																Source: "__count: accumulator.__count + 1",
																Start: ast.Position{
																	Column: 9,
																	Line:   49,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   49,
																	},
																	File:   "geo.flux",
																	Source: "__count",
																	Start: ast.Position{
																		Column: 9,
																		Line:   49,
																	},
																},
															},
															Name: "__count",
														},
														Separator: nil,
														Value: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   49,
																	},
																	File:   "geo.flux",
																	Source: "accumulator.__count + 1",
																	Start: ast.Position{
																		Column: 18,
																		Line:   49,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   49,
																		},
																		File:   "geo.flux",
																		Source: "accumulator.__count",
																		Start: ast.Position{
																			Column: 18,
																			Line:   49,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   49,
																			},
																			File:   "geo.flux",
																			Source: "accumulator",
																			Start: ast.Position{
																				Column: 18,
																				Line:   49,
																			},
																		},
																	},
																	Name: "accumulator",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 37,
																				Line:   49,
																			},
																			File:   "geo.flux",
																			Source: "__count",
																			Start: ast.Position{
																				Column: 30,
																				Line:   49,
																			},
																		},
																	},
																	Name: "__count",
																},
																Rbrack: nil,
															},
															Operator: 5,
															Right: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 41,
																			Line:   49,
																		},
																		File:   "geo.flux",
																		Source: "1",
																		Start: ast.Position{
																			Column: 40,
																			Line:   49,
																		},
																	},
																},
																Value: int64(1),
															},
														},
													}},
													Rbrace: nil,
													With:   nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   47,
														},
														File:   "geo.flux",
														Source: "r",
														Start: ast.Position{
															Column: 20,
															Line:   47,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   47,
															},
															File:   "geo.flux",
															Source: "r",
															Start: ast.Position{
																Column: 20,
																Line:   47,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   47,
														},
														File:   "geo.flux",
														Source: "accumulator",
														Start: ast.Position{
															Column: 23,
															Line:   47,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   47,
															},
															File:   "geo.flux",
															Source: "accumulator",
															Start: ast.Position{
																Column: 23,
																Line:   47,
															},
														},
													},
													Name: "accumulator",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 8,
													Line:   53,
												},
												File:   "geo.flux",
												Source: "identity: {\n        __linestring: \"\",\n        __count: 0\n      }",
												Start: ast.Position{
													Column: 11,
													Line:   50,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   50,
													},
													File:   "geo.flux",
													Source: "identity",
													Start: ast.Position{
														Column: 11,
														Line:   50,
													},
												},
											},
											Name: "identity",
										},
										Separator: nil,
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 8,
														Line:   53,
													},
													File:   "geo.flux",
													Source: "{\n        __linestring: \"\",\n        __count: 0\n      }",
													Start: ast.Position{
														Column: 21,
														Line:   50,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   51,
														},
														File:   "geo.flux",
														Source: "__linestring: \"\"",
														Start: ast.Position{
															Column: 9,
															Line:   51,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   51,
															},
															File:   "geo.flux",
															Source: "__linestring",
															Start: ast.Position{
																Column: 9,
																Line:   51,
															},
														},
													},
													Name: "__linestring",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   51,
															},
															File:   "geo.flux",
															Source: "\"\"",
															Start: ast.Position{
																Column: 23,
																Line:   51,
															},
														},
													},
													Value: "",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   52,
														},
														File:   "geo.flux",
														Source: "__count: 0",
														Start: ast.Position{
															Column: 9,
															Line:   52,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   52,
															},
															File:   "geo.flux",
															Source: "__count",
															Start: ast.Position{
																Column: 9,
																Line:   52,
															},
														},
													},
													Name: "__count",
												},
												Separator: nil,
												Value: &ast.IntegerLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   52,
															},
															File:   "geo.flux",
															Source: "0",
															Start: ast.Position{
																Column: 18,
																Line:   52,
															},
														},
													},
													Value: int64(0),
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   54,
										},
										File:   "geo.flux",
										Source: "reduce(fn: (r, accumulator) => ({\n        __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n        __count: accumulator.__count + 1\n      }), identity: {\n        __linestring: \"\",\n        __count: 0\n      }\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   47,
											},
											File:   "geo.flux",
											Source: "reduce",
											Start: ast.Position{
												Column: 8,
												Line:   47,
											},
										},
									},
									Name: "reduce",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   55,
								},
								File:   "geo.flux",
								Source: "tables\n    |> reduce(fn: (r, accumulator) => ({\n        __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n        __count: accumulator.__count + 1\n      }), identity: {\n        __linestring: \"\",\n        __count: 0\n      }\n    )\n    |> drop(columns: [\"__count\"])",
								Start: ast.Position{
									Column: 3,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   55,
										},
										File:   "geo.flux",
										Source: "columns: [\"__count\"]",
										Start: ast.Position{
											Column: 13,
											Line:   55,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   55,
											},
											File:   "geo.flux",
											Source: "columns: [\"__count\"]",
											Start: ast.Position{
												Column: 13,
												Line:   55,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   55,
												},
												File:   "geo.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   55,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   55,
												},
												File:   "geo.flux",
												Source: "[\"__count\"]",
												Start: ast.Position{
													Column: 22,
													Line:   55,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   55,
													},
													File:   "geo.flux",
													Source: "\"__count\"",
													Start: ast.Position{
														Column: 23,
														Line:   55,
													},
												},
											},
											Value: "__count",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   55,
									},
									File:   "geo.flux",
									Source: "drop(columns: [\"__count\"])",
									Start: ast.Position{
										Column: 8,
										Line:   55,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   55,
										},
										File:   "geo.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   55,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   56,
							},
							File:   "geo.flux",
							Source: "tables\n    |> reduce(fn: (r, accumulator) => ({\n        __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n        __count: accumulator.__count + 1\n      }), identity: {\n        __linestring: \"\",\n        __count: 0\n      }\n    )\n    |> drop(columns: [\"__count\"])\n    |> rename(columns: {__linestring: \"st_linestring\"})",
							Start: ast.Position{
								Column: 3,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   56,
									},
									File:   "geo.flux",
									Source: "columns: {__linestring: \"st_linestring\"}",
									Start: ast.Position{
										Column: 15,
										Line:   56,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   56,
										},
										File:   "geo.flux",
										Source: "columns: {__linestring: \"st_linestring\"}",
										Start: ast.Position{
											Column: 15,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   56,
											},
											File:   "geo.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 15,
												Line:   56,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   56,
											},
											File:   "geo.flux",
											Source: "{__linestring: \"st_linestring\"}",
											Start: ast.Position{
												Column: 24,
												Line:   56,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   56,
												},
												File:   "geo.flux",
												Source: "__linestring: \"st_linestring\"",
												Start: ast.Position{
													Column: 25,
													Line:   56,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   56,
													},
													File:   "geo.flux",
													Source: "__linestring",
													Start: ast.Position{
														Column: 25,
														Line:   56,
													},
												},
											},
											Name: "__linestring",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   56,
													},
													File:   "geo.flux",
													Source: "\"st_linestring\"",
													Start: ast.Position{
														Column: 39,
														Line:   56,
													},
												},
											},
											Value: "st_linestring",
										},
									}},
									Rbrace: nil,
									With:   nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   56,
								},
								File:   "geo.flux",
								Source: "rename(columns: {__linestring: \"st_linestring\"})",
								Start: ast.Position{
									Column: 8,
									Line:   56,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   56,
									},
									File:   "geo.flux",
									Source: "rename",
									Start: ast.Position{
										Column: 8,
										Line:   56,
									},
								},
							},
							Name: "rename",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   45,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 18,
								Line:   45,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   45,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 18,
									Line:   45,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   45,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   45,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// None of the following builtin functions are intended to be used by end users.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Calculates grid (set of cell ID tokens) for given region and according to options.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   63,
					},
					File:   "geo.flux",
					Source: "builtin getGrid",
					Start: ast.Position{
						Column: 1,
						Line:   63,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   63,
						},
						File:   "geo.flux",
						Source: "getGrid",
						Start: ast.Position{
							Column: 9,
							Line:   63,
						},
					},
				},
				Name: "getGrid",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 164,
							Line:   63,
						},
						File:   "geo.flux",
						Source: "(region: T, ?minSize: int, ?maxSize: int, ?level: int, ?maxLevel: int, units: {distance: string}) => {level: int , set: [string]} where T: Record",
						Start: ast.Position{
							Column: 19,
							Line:   63,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 164,
								Line:   63,
							},
							File:   "geo.flux",
							Source: "T: Record",
							Start: ast.Position{
								Column: 155,
								Line:   63,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 164,
									Line:   63,
								},
								File:   "geo.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 158,
									Line:   63,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 156,
									Line:   63,
								},
								File:   "geo.flux",
								Source: "T",
								Start: ast.Position{
									Column: 155,
									Line:   63,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 148,
								Line:   63,
							},
							File:   "geo.flux",
							Source: "(region: T, ?minSize: int, ?maxSize: int, ?level: int, ?maxLevel: int, units: {distance: string}) => {level: int , set: [string]}",
							Start: ast.Position{
								Column: 19,
								Line:   63,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   63,
								},
								File:   "geo.flux",
								Source: "region: T",
								Start: ast.Position{
									Column: 20,
									Line:   63,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "region",
									Start: ast.Position{
										Column: 20,
										Line:   63,
									},
								},
							},
							Name: "region",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "T",
									Start: ast.Position{
										Column: 28,
										Line:   63,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   63,
										},
										File:   "geo.flux",
										Source: "T",
										Start: ast.Position{
											Column: 28,
											Line:   63,
										},
									},
								},
								Name: "T",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   63,
								},
								File:   "geo.flux",
								Source: "?minSize: int",
								Start: ast.Position{
									Column: 31,
									Line:   63,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "minSize",
									Start: ast.Position{
										Column: 32,
										Line:   63,
									},
								},
							},
							Name: "minSize",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "int",
									Start: ast.Position{
										Column: 41,
										Line:   63,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   63,
										},
										File:   "geo.flux",
										Source: "int",
										Start: ast.Position{
											Column: 41,
											Line:   63,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   63,
								},
								File:   "geo.flux",
								Source: "?maxSize: int",
								Start: ast.Position{
									Column: 46,
									Line:   63,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "maxSize",
									Start: ast.Position{
										Column: 47,
										Line:   63,
									},
								},
							},
							Name: "maxSize",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "int",
									Start: ast.Position{
										Column: 56,
										Line:   63,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   63,
										},
										File:   "geo.flux",
										Source: "int",
										Start: ast.Position{
											Column: 56,
											Line:   63,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   63,
								},
								File:   "geo.flux",
								Source: "?level: int",
								Start: ast.Position{
									Column: 61,
									Line:   63,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "level",
									Start: ast.Position{
										Column: 62,
										Line:   63,
									},
								},
							},
							Name: "level",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "int",
									Start: ast.Position{
										Column: 69,
										Line:   63,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   63,
										},
										File:   "geo.flux",
										Source: "int",
										Start: ast.Position{
											Column: 69,
											Line:   63,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 88,
									Line:   63,
								},
								File:   "geo.flux",
								Source: "?maxLevel: int",
								Start: ast.Position{
									Column: 74,
									Line:   63,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "maxLevel",
									Start: ast.Position{
										Column: 75,
										Line:   63,
									},
								},
							},
							Name: "maxLevel",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "int",
									Start: ast.Position{
										Column: 85,
										Line:   63,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   63,
										},
										File:   "geo.flux",
										Source: "int",
										Start: ast.Position{
											Column: 85,
											Line:   63,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   63,
								},
								File:   "geo.flux",
								Source: "units: {distance: string}",
								Start: ast.Position{
									Column: 90,
									Line:   63,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 95,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "units",
									Start: ast.Position{
										Column: 90,
										Line:   63,
									},
								},
							},
							Name: "units",
						},
						Ty: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 115,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "{distance: string}",
									Start: ast.Position{
										Column: 97,
										Line:   63,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 114,
											Line:   63,
										},
										File:   "geo.flux",
										Source: "distance: string",
										Start: ast.Position{
											Column: 98,
											Line:   63,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 106,
												Line:   63,
											},
											File:   "geo.flux",
											Source: "distance",
											Start: ast.Position{
												Column: 98,
												Line:   63,
											},
										},
									},
									Name: "distance",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 114,
												Line:   63,
											},
											File:   "geo.flux",
											Source: "string",
											Start: ast.Position{
												Column: 108,
												Line:   63,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 114,
													Line:   63,
												},
												File:   "geo.flux",
												Source: "string",
												Start: ast.Position{
													Column: 108,
													Line:   63,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Tvar: nil,
						},
					}},
					Return: &ast.RecordType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 148,
									Line:   63,
								},
								File:   "geo.flux",
								Source: "{level: int , set: [string]}",
								Start: ast.Position{
									Column: 120,
									Line:   63,
								},
							},
						},
						Properties: []*ast.PropertyType{&ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 131,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "level: int",
									Start: ast.Position{
										Column: 121,
										Line:   63,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 126,
											Line:   63,
										},
										File:   "geo.flux",
										Source: "level",
										Start: ast.Position{
											Column: 121,
											Line:   63,
										},
									},
								},
								Name: "level",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 131,
											Line:   63,
										},
										File:   "geo.flux",
										Source: "int",
										Start: ast.Position{
											Column: 128,
											Line:   63,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 131,
												Line:   63,
											},
											File:   "geo.flux",
											Source: "int",
											Start: ast.Position{
												Column: 128,
												Line:   63,
											},
										},
									},
									Name: "int",
								},
							},
						}, &ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 147,
										Line:   63,
									},
									File:   "geo.flux",
									Source: "set: [string]",
									Start: ast.Position{
										Column: 134,
										Line:   63,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 137,
											Line:   63,
										},
										File:   "geo.flux",
										Source: "set",
										Start: ast.Position{
											Column: 134,
											Line:   63,
										},
									},
								},
								Name: "set",
							},
							Ty: &ast.ArrayType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 147,
											Line:   63,
										},
										File:   "geo.flux",
										Source: "[string]",
										Start: ast.Position{
											Column: 139,
											Line:   63,
										},
									},
								},
								ElementType: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 146,
												Line:   63,
											},
											File:   "geo.flux",
											Source: "string",
											Start: ast.Position{
												Column: 140,
												Line:   63,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 146,
													Line:   63,
												},
												File:   "geo.flux",
												Source: "string",
												Start: ast.Position{
													Column: 140,
													Line:   63,
												},
											},
										},
										Name: "string",
									},
								},
							},
						}},
						Tvar: nil,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Returns level of specified cell ID token.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   66,
					},
					File:   "geo.flux",
					Source: "builtin getLevel",
					Start: ast.Position{
						Column: 1,
						Line:   66,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   66,
						},
						File:   "geo.flux",
						Source: "getLevel",
						Start: ast.Position{
							Column: 9,
							Line:   66,
						},
					},
				},
				Name: "getLevel",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   66,
						},
						File:   "geo.flux",
						Source: "(token: string) => int",
						Start: ast.Position{
							Column: 20,
							Line:   66,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   66,
							},
							File:   "geo.flux",
							Source: "(token: string) => int",
							Start: ast.Position{
								Column: 20,
								Line:   66,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   66,
								},
								File:   "geo.flux",
								Source: "token: string",
								Start: ast.Position{
									Column: 21,
									Line:   66,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   66,
									},
									File:   "geo.flux",
									Source: "token",
									Start: ast.Position{
										Column: 21,
										Line:   66,
									},
								},
							},
							Name: "token",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   66,
									},
									File:   "geo.flux",
									Source: "string",
									Start: ast.Position{
										Column: 28,
										Line:   66,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   66,
										},
										File:   "geo.flux",
										Source: "string",
										Start: ast.Position{
											Column: 28,
											Line:   66,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   66,
								},
								File:   "geo.flux",
								Source: "int",
								Start: ast.Position{
									Column: 39,
									Line:   66,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   66,
									},
									File:   "geo.flux",
									Source: "int",
									Start: ast.Position{
										Column: 39,
										Line:   66,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Returns cell ID token for given cell or lat/lon point at specified level.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   69,
					},
					File:   "geo.flux",
					Source: "builtin s2CellIDToken",
					Start: ast.Position{
						Column: 1,
						Line:   69,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   69,
						},
						File:   "geo.flux",
						Source: "s2CellIDToken",
						Start: ast.Position{
							Column: 9,
							Line:   69,
						},
					},
				},
				Name: "s2CellIDToken",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 98,
							Line:   69,
						},
						File:   "geo.flux",
						Source: "(?token: string, ?point: {lat: float , lon: float}, level: int) => string",
						Start: ast.Position{
							Column: 25,
							Line:   69,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 98,
								Line:   69,
							},
							File:   "geo.flux",
							Source: "(?token: string, ?point: {lat: float , lon: float}, level: int) => string",
							Start: ast.Position{
								Column: 25,
								Line:   69,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   69,
								},
								File:   "geo.flux",
								Source: "?token: string",
								Start: ast.Position{
									Column: 26,
									Line:   69,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   69,
									},
									File:   "geo.flux",
									Source: "token",
									Start: ast.Position{
										Column: 27,
										Line:   69,
									},
								},
							},
							Name: "token",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   69,
									},
									File:   "geo.flux",
									Source: "string",
									Start: ast.Position{
										Column: 34,
										Line:   69,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   69,
										},
										File:   "geo.flux",
										Source: "string",
										Start: ast.Position{
											Column: 34,
											Line:   69,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   69,
								},
								File:   "geo.flux",
								Source: "?point: {lat: float , lon: float}",
								Start: ast.Position{
									Column: 42,
									Line:   69,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   69,
									},
									File:   "geo.flux",
									Source: "point",
									Start: ast.Position{
										Column: 43,
										Line:   69,
									},
								},
							},
							Name: "point",
						},
						Ty: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   69,
									},
									File:   "geo.flux",
									Source: "{lat: float , lon: float}",
									Start: ast.Position{
										Column: 50,
										Line:   69,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   69,
										},
										File:   "geo.flux",
										Source: "lat: float",
										Start: ast.Position{
											Column: 51,
											Line:   69,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   69,
											},
											File:   "geo.flux",
											Source: "lat",
											Start: ast.Position{
												Column: 51,
												Line:   69,
											},
										},
									},
									Name: "lat",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   69,
											},
											File:   "geo.flux",
											Source: "float",
											Start: ast.Position{
												Column: 56,
												Line:   69,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   69,
												},
												File:   "geo.flux",
												Source: "float",
												Start: ast.Position{
													Column: 56,
													Line:   69,
												},
											},
										},
										Name: "float",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   69,
										},
										File:   "geo.flux",
										Source: "lon: float",
										Start: ast.Position{
											Column: 64,
											Line:   69,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   69,
											},
											File:   "geo.flux",
											Source: "lon",
											Start: ast.Position{
												Column: 64,
												Line:   69,
											},
										},
									},
									Name: "lon",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   69,
											},
											File:   "geo.flux",
											Source: "float",
											Start: ast.Position{
												Column: 69,
												Line:   69,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   69,
												},
												File:   "geo.flux",
												Source: "float",
												Start: ast.Position{
													Column: 69,
													Line:   69,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: nil,
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   69,
								},
								File:   "geo.flux",
								Source: "level: int",
								Start: ast.Position{
									Column: 77,
									Line:   69,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 82,
										Line:   69,
									},
									File:   "geo.flux",
									Source: "level",
									Start: ast.Position{
										Column: 77,
										Line:   69,
									},
								},
							},
							Name: "level",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 87,
										Line:   69,
									},
									File:   "geo.flux",
									Source: "int",
									Start: ast.Position{
										Column: 84,
										Line:   69,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 87,
											Line:   69,
										},
										File:   "geo.flux",
										Source: "int",
										Start: ast.Position{
											Column: 84,
											Line:   69,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 98,
									Line:   69,
								},
								File:   "geo.flux",
								Source: "string",
								Start: ast.Position{
									Column: 92,
									Line:   69,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 98,
										Line:   69,
									},
									File:   "geo.flux",
									Source: "string",
									Start: ast.Position{
										Column: 92,
										Line:   69,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Returns lat/lon coordinates of given cell ID token.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   72,
					},
					File:   "geo.flux",
					Source: "builtin s2CellLatLon",
					Start: ast.Position{
						Column: 1,
						Line:   72,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   72,
						},
						File:   "geo.flux",
						Source: "s2CellLatLon",
						Start: ast.Position{
							Column: 9,
							Line:   72,
						},
					},
				},
				Name: "s2CellLatLon",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   72,
						},
						File:   "geo.flux",
						Source: "(token: string) => {lat: float , lon: float}",
						Start: ast.Position{
							Column: 24,
							Line:   72,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   72,
							},
							File:   "geo.flux",
							Source: "(token: string) => {lat: float , lon: float}",
							Start: ast.Position{
								Column: 24,
								Line:   72,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   72,
								},
								File:   "geo.flux",
								Source: "token: string",
								Start: ast.Position{
									Column: 25,
									Line:   72,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   72,
									},
									File:   "geo.flux",
									Source: "token",
									Start: ast.Position{
										Column: 25,
										Line:   72,
									},
								},
							},
							Name: "token",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   72,
									},
									File:   "geo.flux",
									Source: "string",
									Start: ast.Position{
										Column: 32,
										Line:   72,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   72,
										},
										File:   "geo.flux",
										Source: "string",
										Start: ast.Position{
											Column: 32,
											Line:   72,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.RecordType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   72,
								},
								File:   "geo.flux",
								Source: "{lat: float , lon: float}",
								Start: ast.Position{
									Column: 43,
									Line:   72,
								},
							},
						},
						Properties: []*ast.PropertyType{&ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   72,
									},
									File:   "geo.flux",
									Source: "lat: float",
									Start: ast.Position{
										Column: 44,
										Line:   72,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   72,
										},
										File:   "geo.flux",
										Source: "lat",
										Start: ast.Position{
											Column: 44,
											Line:   72,
										},
									},
								},
								Name: "lat",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   72,
										},
										File:   "geo.flux",
										Source: "float",
										Start: ast.Position{
											Column: 49,
											Line:   72,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   72,
											},
											File:   "geo.flux",
											Source: "float",
											Start: ast.Position{
												Column: 49,
												Line:   72,
											},
										},
									},
									Name: "float",
								},
							},
						}, &ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   72,
									},
									File:   "geo.flux",
									Source: "lon: float",
									Start: ast.Position{
										Column: 57,
										Line:   72,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   72,
										},
										File:   "geo.flux",
										Source: "lon",
										Start: ast.Position{
											Column: 57,
											Line:   72,
										},
									},
								},
								Name: "lon",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   72,
										},
										File:   "geo.flux",
										Source: "float",
										Start: ast.Position{
											Column: 62,
											Line:   72,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   72,
											},
											File:   "geo.flux",
											Source: "float",
											Start: ast.Position{
												Column: 62,
												Line:   72,
											},
										},
									},
									Name: "float",
								},
							},
						}},
						Tvar: nil,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   90,
					},
					File:   "geo.flux",
					Source: "_detectLevel = (tables=<-) => {\n  _r0 =\n    tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)\n      |> getRecord(idx: 0)\n  _level =\n    if exists _r0 then\n      getLevel(token: _r0.s2_cell_id)\n    else\n       666\n  return _level\n}",
					Start: ast.Position{
						Column: 1,
						Line:   79,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Flux functions\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Gets level of cell ID tag `s2cellID` from the first record from the first table in the stream.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   79,
						},
						File:   "geo.flux",
						Source: "_detectLevel",
						Start: ast.Position{
							Column: 1,
							Line:   79,
						},
					},
				},
				Name: "_detectLevel",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   90,
						},
						File:   "geo.flux",
						Source: "(tables=<-) => {\n  _r0 =\n    tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)\n      |> getRecord(idx: 0)\n  _level =\n    if exists _r0 then\n      getLevel(token: _r0.s2_cell_id)\n    else\n       666\n  return _level\n}",
						Start: ast.Position{
							Column: 16,
							Line:   79,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   90,
							},
							File:   "geo.flux",
							Source: "{\n  _r0 =\n    tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)\n      |> getRecord(idx: 0)\n  _level =\n    if exists _r0 then\n      getLevel(token: _r0.s2_cell_id)\n    else\n       666\n  return _level\n}",
							Start: ast.Position{
								Column: 31,
								Line:   79,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   83,
								},
								File:   "geo.flux",
								Source: "_r0 =\n    tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)\n      |> getRecord(idx: 0)",
								Start: ast.Position{
									Column: 3,
									Line:   80,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   80,
									},
									File:   "geo.flux",
									Source: "_r0",
									Start: ast.Position{
										Column: 3,
										Line:   80,
									},
								},
							},
							Name: "_r0",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   81,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 5,
												Line:   81,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   82,
										},
										File:   "geo.flux",
										Source: "tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)",
										Start: ast.Position{
											Column: 5,
											Line:   81,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   82,
												},
												File:   "geo.flux",
												Source: "fn: (key) => exists key.s2_cell_id",
												Start: ast.Position{
													Column: 20,
													Line:   82,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   82,
													},
													File:   "geo.flux",
													Source: "fn: (key) => exists key.s2_cell_id",
													Start: ast.Position{
														Column: 20,
														Line:   82,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   82,
														},
														File:   "geo.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 20,
															Line:   82,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   82,
														},
														File:   "geo.flux",
														Source: "(key) => exists key.s2_cell_id",
														Start: ast.Position{
															Column: 24,
															Line:   82,
														},
													},
												},
												Body: &ast.UnaryExpression{
													Argument: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   82,
																},
																File:   "geo.flux",
																Source: "key.s2_cell_id",
																Start: ast.Position{
																	Column: 40,
																	Line:   82,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   82,
																	},
																	File:   "geo.flux",
																	Source: "key",
																	Start: ast.Position{
																		Column: 40,
																		Line:   82,
																	},
																},
															},
															Name: "key",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   82,
																	},
																	File:   "geo.flux",
																	Source: "s2_cell_id",
																	Start: ast.Position{
																		Column: 44,
																		Line:   82,
																	},
																},
															},
															Name: "s2_cell_id",
														},
														Rbrack: nil,
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   82,
															},
															File:   "geo.flux",
															Source: "exists key.s2_cell_id",
															Start: ast.Position{
																Column: 33,
																Line:   82,
															},
														},
													},
													Operator: 14,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   82,
															},
															File:   "geo.flux",
															Source: "key",
															Start: ast.Position{
																Column: 25,
																Line:   82,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 28,
																	Line:   82,
																},
																File:   "geo.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 25,
																	Line:   82,
																},
															},
														},
														Name: "key",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   82,
											},
											File:   "geo.flux",
											Source: "tableFind(fn: (key) => exists key.s2_cell_id)",
											Start: ast.Position{
												Column: 10,
												Line:   82,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   82,
												},
												File:   "geo.flux",
												Source: "tableFind",
												Start: ast.Position{
													Column: 10,
													Line:   82,
												},
											},
										},
										Name: "tableFind",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   83,
									},
									File:   "geo.flux",
									Source: "tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)\n      |> getRecord(idx: 0)",
									Start: ast.Position{
										Column: 5,
										Line:   81,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   83,
											},
											File:   "geo.flux",
											Source: "idx: 0",
											Start: ast.Position{
												Column: 20,
												Line:   83,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   83,
												},
												File:   "geo.flux",
												Source: "idx: 0",
												Start: ast.Position{
													Column: 20,
													Line:   83,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   83,
													},
													File:   "geo.flux",
													Source: "idx",
													Start: ast.Position{
														Column: 20,
														Line:   83,
													},
												},
											},
											Name: "idx",
										},
										Separator: nil,
										Value: &ast.IntegerLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   83,
													},
													File:   "geo.flux",
													Source: "0",
													Start: ast.Position{
														Column: 25,
														Line:   83,
													},
												},
											},
											Value: int64(0),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   83,
										},
										File:   "geo.flux",
										Source: "getRecord(idx: 0)",
										Start: ast.Position{
											Column: 10,
											Line:   83,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   83,
											},
											File:   "geo.flux",
											Source: "getRecord",
											Start: ast.Position{
												Column: 10,
												Line:   83,
											},
										},
									},
									Name: "getRecord",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   88,
								},
								File:   "geo.flux",
								Source: "_level =\n    if exists _r0 then\n      getLevel(token: _r0.s2_cell_id)\n    else\n       666",
								Start: ast.Position{
									Column: 3,
									Line:   84,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   84,
									},
									File:   "geo.flux",
									Source: "_level",
									Start: ast.Position{
										Column: 3,
										Line:   84,
									},
								},
							},
							Name: "_level",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.IntegerLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   88,
										},
										File:   "geo.flux",
										Source: "666",
										Start: ast.Position{
											Column: 8,
											Line:   88,
										},
									},
								},
								Value: int64(666),
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   88,
									},
									File:   "geo.flux",
									Source: "if exists _r0 then\n      getLevel(token: _r0.s2_cell_id)\n    else\n       666",
									Start: ast.Position{
										Column: 5,
										Line:   85,
									},
								},
							},
							Consequent: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   86,
											},
											File:   "geo.flux",
											Source: "token: _r0.s2_cell_id",
											Start: ast.Position{
												Column: 16,
												Line:   86,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   86,
												},
												File:   "geo.flux",
												Source: "token: _r0.s2_cell_id",
												Start: ast.Position{
													Column: 16,
													Line:   86,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   86,
													},
													File:   "geo.flux",
													Source: "token",
													Start: ast.Position{
														Column: 16,
														Line:   86,
													},
												},
											},
											Name: "token",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   86,
													},
													File:   "geo.flux",
													Source: "_r0.s2_cell_id",
													Start: ast.Position{
														Column: 23,
														Line:   86,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   86,
														},
														File:   "geo.flux",
														Source: "_r0",
														Start: ast.Position{
															Column: 23,
															Line:   86,
														},
													},
												},
												Name: "_r0",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   86,
														},
														File:   "geo.flux",
														Source: "s2_cell_id",
														Start: ast.Position{
															Column: 27,
															Line:   86,
														},
													},
												},
												Name: "s2_cell_id",
											},
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   86,
										},
										File:   "geo.flux",
										Source: "getLevel(token: _r0.s2_cell_id)",
										Start: ast.Position{
											Column: 7,
											Line:   86,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   86,
											},
											File:   "geo.flux",
											Source: "getLevel",
											Start: ast.Position{
												Column: 7,
												Line:   86,
											},
										},
									},
									Name: "getLevel",
								},
								Lparen: nil,
								Rparen: nil,
							},
							Test: &ast.UnaryExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   85,
											},
											File:   "geo.flux",
											Source: "_r0",
											Start: ast.Position{
												Column: 15,
												Line:   85,
											},
										},
									},
									Name: "_r0",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   85,
										},
										File:   "geo.flux",
										Source: "exists _r0",
										Start: ast.Position{
											Column: 8,
											Line:   85,
										},
									},
								},
								Operator: 14,
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   89,
									},
									File:   "geo.flux",
									Source: "_level",
									Start: ast.Position{
										Column: 10,
										Line:   89,
									},
								},
							},
							Name: "_level",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   89,
								},
								File:   "geo.flux",
								Source: "return _level",
								Start: ast.Position{
									Column: 3,
									Line:   89,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   79,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   79,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   79,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   79,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   79,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   79,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   99,
					},
					File:   "geo.flux",
					Source: "toRows = (tables=<-) =>\n  tables\n    |> v1.fieldsAsCols()",
					Start: ast.Position{
						Column: 1,
						Line:   97,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Convenience functions\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Pivots values to row-wise sets.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   97,
						},
						File:   "geo.flux",
						Source: "toRows",
						Start: ast.Position{
							Column: 1,
							Line:   97,
						},
					},
				},
				Name: "toRows",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   99,
						},
						File:   "geo.flux",
						Source: "(tables=<-) =>\n  tables\n    |> v1.fieldsAsCols()",
						Start: ast.Position{
							Column: 10,
							Line:   97,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   98,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 3,
									Line:   98,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   99,
							},
							File:   "geo.flux",
							Source: "tables\n    |> v1.fieldsAsCols()",
							Start: ast.Position{
								Column: 3,
								Line:   98,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   99,
								},
								File:   "geo.flux",
								Source: "v1.fieldsAsCols()",
								Start: ast.Position{
									Column: 8,
									Line:   99,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   99,
									},
									File:   "geo.flux",
									Source: "v1.fieldsAsCols",
									Start: ast.Position{
										Column: 8,
										Line:   99,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   99,
										},
										File:   "geo.flux",
										Source: "v1",
										Start: ast.Position{
											Column: 8,
											Line:   99,
										},
									},
								},
								Name: "v1",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   99,
										},
										File:   "geo.flux",
										Source: "fieldsAsCols",
										Start: ast.Position{
											Column: 11,
											Line:   99,
										},
									},
								},
								Name: "fieldsAsCols",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   97,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 11,
								Line:   97,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   97,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 11,
									Line:   97,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   97,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 18,
								Line:   97,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   123,
					},
					File:   "geo.flux",
					Source: "shapeData = (tables=<-, latField, lonField, level) =>\n  tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )\n    |> toRows()\n    |> map(fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })\n    )\n    |> experimental.group(\n      columns: [\"s2_cell_id\"],\n      mode: \"extend\"\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   106,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Shapes data to meet the requirements of the geo package.\n"}, ast.Comment{Text: "// Renames fields containing latitude and longitude values to lat and lon.\n"}, ast.Comment{Text: "// Pivots values to row-wise sets.\n"}, ast.Comment{Text: "// Generates an s2_cell_id tag for each reach using lat and lon values.\n"}, ast.Comment{Text: "// Adds the s2_cell_id column to the group key.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   106,
						},
						File:   "geo.flux",
						Source: "shapeData",
						Start: ast.Position{
							Column: 1,
							Line:   106,
						},
					},
				},
				Name: "shapeData",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   123,
						},
						File:   "geo.flux",
						Source: "(tables=<-, latField, lonField, level) =>\n  tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )\n    |> toRows()\n    |> map(fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })\n    )\n    |> experimental.group(\n      columns: [\"s2_cell_id\"],\n      mode: \"extend\"\n    )",
						Start: ast.Position{
							Column: 13,
							Line:   106,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   107,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 3,
												Line:   107,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   114,
										},
										File:   "geo.flux",
										Source: "tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )",
										Start: ast.Position{
											Column: 3,
											Line:   107,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 9,
													Line:   113,
												},
												File:   "geo.flux",
												Source: "fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })",
												Start: ast.Position{
													Column: 12,
													Line:   108,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 9,
														Line:   113,
													},
													File:   "geo.flux",
													Source: "fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })",
													Start: ast.Position{
														Column: 12,
														Line:   108,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   108,
														},
														File:   "geo.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 12,
															Line:   108,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 9,
															Line:   113,
														},
														File:   "geo.flux",
														Source: "(r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })",
														Start: ast.Position{
															Column: 16,
															Line:   108,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 9,
																Line:   113,
															},
															File:   "geo.flux",
															Source: "({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })",
															Start: ast.Position{
																Column: 23,
																Line:   108,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 8,
																	Line:   113,
																},
																File:   "geo.flux",
																Source: "{ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      }",
																Start: ast.Position{
																	Column: 24,
																	Line:   108,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   112,
																	},
																	File:   "geo.flux",
																	Source: "_field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field",
																	Start: ast.Position{
																		Column: 9,
																		Line:   109,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 15,
																			Line:   109,
																		},
																		File:   "geo.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 9,
																			Line:   109,
																		},
																	},
																},
																Name: "_field",
															},
															Separator: nil,
															Value: &ast.ConditionalExpression{
																Alternate: &ast.ConditionalExpression{
																	Alternate: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   112,
																				},
																				File:   "geo.flux",
																				Source: "r._field",
																				Start: ast.Position{
																					Column: 16,
																					Line:   112,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 17,
																						Line:   112,
																					},
																					File:   "geo.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 16,
																						Line:   112,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 24,
																						Line:   112,
																					},
																					File:   "geo.flux",
																					Source: "_field",
																					Start: ast.Position{
																						Column: 18,
																						Line:   112,
																					},
																				},
																			},
																			Name: "_field",
																		},
																		Rbrack: nil,
																	},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   112,
																			},
																			File:   "geo.flux",
																			Source: "if r._field == lonField then \"lon\"\n          else r._field",
																			Start: ast.Position{
																				Column: 16,
																				Line:   111,
																			},
																		},
																	},
																	Consequent: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 50,
																					Line:   111,
																				},
																				File:   "geo.flux",
																				Source: "\"lon\"",
																				Start: ast.Position{
																					Column: 45,
																					Line:   111,
																				},
																			},
																		},
																		Value: "lon",
																	},
																	Test: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 39,
																					Line:   111,
																				},
																				File:   "geo.flux",
																				Source: "r._field == lonField",
																				Start: ast.Position{
																					Column: 19,
																					Line:   111,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 27,
																						Line:   111,
																					},
																					File:   "geo.flux",
																					Source: "r._field",
																					Start: ast.Position{
																						Column: 19,
																						Line:   111,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 20,
																							Line:   111,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 19,
																							Line:   111,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 27,
																							Line:   111,
																						},
																						File:   "geo.flux",
																						Source: "_field",
																						Start: ast.Position{
																							Column: 21,
																							Line:   111,
																						},
																					},
																				},
																				Name: "_field",
																			},
																			Rbrack: nil,
																		},
																		Operator: 17,
																		Right: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 39,
																						Line:   111,
																					},
																					File:   "geo.flux",
																					Source: "lonField",
																					Start: ast.Position{
																						Column: 31,
																						Line:   111,
																					},
																				},
																			},
																			Name: "lonField",
																		},
																	},
																	Tk_else: nil,
																	Tk_if:   nil,
																	Tk_then: nil,
																},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   112,
																		},
																		File:   "geo.flux",
																		Source: "if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field",
																		Start: ast.Position{
																			Column: 11,
																			Line:   110,
																		},
																	},
																},
																Consequent: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   110,
																			},
																			File:   "geo.flux",
																			Source: "\"lat\"",
																			Start: ast.Position{
																				Column: 40,
																				Line:   110,
																			},
																		},
																	},
																	Value: "lat",
																},
																Test: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   110,
																			},
																			File:   "geo.flux",
																			Source: "r._field == latField",
																			Start: ast.Position{
																				Column: 14,
																				Line:   110,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 22,
																					Line:   110,
																				},
																				File:   "geo.flux",
																				Source: "r._field",
																				Start: ast.Position{
																					Column: 14,
																					Line:   110,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 15,
																						Line:   110,
																					},
																					File:   "geo.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 14,
																						Line:   110,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   110,
																					},
																					File:   "geo.flux",
																					Source: "_field",
																					Start: ast.Position{
																						Column: 16,
																						Line:   110,
																					},
																				},
																			},
																			Name: "_field",
																		},
																		Rbrack: nil,
																	},
																	Operator: 17,
																	Right: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   110,
																				},
																				File:   "geo.flux",
																				Source: "latField",
																				Start: ast.Position{
																					Column: 26,
																					Line:   110,
																				},
																			},
																		},
																		Name: "latField",
																	},
																},
																Tk_else: nil,
																Tk_if:   nil,
																Tk_then: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   108,
																	},
																	File:   "geo.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 26,
																		Line:   108,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   108,
															},
															File:   "geo.flux",
															Source: "r",
															Start: ast.Position{
																Column: 17,
																Line:   108,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   108,
																},
																File:   "geo.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   108,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   114,
											},
											File:   "geo.flux",
											Source: "map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )",
											Start: ast.Position{
												Column: 8,
												Line:   108,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   108,
												},
												File:   "geo.flux",
												Source: "map",
												Start: ast.Position{
													Column: 8,
													Line:   108,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   115,
									},
									File:   "geo.flux",
									Source: "tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )\n    |> toRows()",
									Start: ast.Position{
										Column: 3,
										Line:   107,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   115,
										},
										File:   "geo.flux",
										Source: "toRows()",
										Start: ast.Position{
											Column: 8,
											Line:   115,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   115,
											},
											File:   "geo.flux",
											Source: "toRows",
											Start: ast.Position{
												Column: 8,
												Line:   115,
											},
										},
									},
									Name: "toRows",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   119,
								},
								File:   "geo.flux",
								Source: "tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )\n    |> toRows()\n    |> map(fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })\n    )",
								Start: ast.Position{
									Column: 3,
									Line:   107,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   118,
										},
										File:   "geo.flux",
										Source: "fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })",
										Start: ast.Position{
											Column: 12,
											Line:   116,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   118,
											},
											File:   "geo.flux",
											Source: "fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })",
											Start: ast.Position{
												Column: 12,
												Line:   116,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   116,
												},
												File:   "geo.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 12,
													Line:   116,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 9,
													Line:   118,
												},
												File:   "geo.flux",
												Source: "(r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })",
												Start: ast.Position{
													Column: 16,
													Line:   116,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 9,
														Line:   118,
													},
													File:   "geo.flux",
													Source: "({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })",
													Start: ast.Position{
														Column: 23,
														Line:   116,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 8,
															Line:   118,
														},
														File:   "geo.flux",
														Source: "{ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      }",
														Start: ast.Position{
															Column: 24,
															Line:   116,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 81,
																Line:   117,
															},
															File:   "geo.flux",
															Source: "s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)",
															Start: ast.Position{
																Column: 9,
																Line:   117,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   117,
																},
																File:   "geo.flux",
																Source: "s2_cell_id",
																Start: ast.Position{
																	Column: 9,
																	Line:   117,
																},
															},
														},
														Name: "s2_cell_id",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 80,
																		Line:   117,
																	},
																	File:   "geo.flux",
																	Source: "point: {lat: r.lat, lon: r.lon}, level: level",
																	Start: ast.Position{
																		Column: 35,
																		Line:   117,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 66,
																			Line:   117,
																		},
																		File:   "geo.flux",
																		Source: "point: {lat: r.lat, lon: r.lon}",
																		Start: ast.Position{
																			Column: 35,
																			Line:   117,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   117,
																			},
																			File:   "geo.flux",
																			Source: "point",
																			Start: ast.Position{
																				Column: 35,
																				Line:   117,
																			},
																		},
																	},
																	Name: "point",
																},
																Separator: nil,
																Value: &ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   117,
																			},
																			File:   "geo.flux",
																			Source: "{lat: r.lat, lon: r.lon}",
																			Start: ast.Position{
																				Column: 42,
																				Line:   117,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 53,
																					Line:   117,
																				},
																				File:   "geo.flux",
																				Source: "lat: r.lat",
																				Start: ast.Position{
																					Column: 43,
																					Line:   117,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 46,
																						Line:   117,
																					},
																					File:   "geo.flux",
																					Source: "lat",
																					Start: ast.Position{
																						Column: 43,
																						Line:   117,
																					},
																				},
																			},
																			Name: "lat",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 53,
																						Line:   117,
																					},
																					File:   "geo.flux",
																					Source: "r.lat",
																					Start: ast.Position{
																						Column: 48,
																						Line:   117,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 49,
																							Line:   117,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 48,
																							Line:   117,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 53,
																							Line:   117,
																						},
																						File:   "geo.flux",
																						Source: "lat",
																						Start: ast.Position{
																							Column: 50,
																							Line:   117,
																						},
																					},
																				},
																				Name: "lat",
																			},
																			Rbrack: nil,
																		},
																	}, &ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 65,
																					Line:   117,
																				},
																				File:   "geo.flux",
																				Source: "lon: r.lon",
																				Start: ast.Position{
																					Column: 55,
																					Line:   117,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 58,
																						Line:   117,
																					},
																					File:   "geo.flux",
																					Source: "lon",
																					Start: ast.Position{
																						Column: 55,
																						Line:   117,
																					},
																				},
																			},
																			Name: "lon",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 65,
																						Line:   117,
																					},
																					File:   "geo.flux",
																					Source: "r.lon",
																					Start: ast.Position{
																						Column: 60,
																						Line:   117,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 61,
																							Line:   117,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 60,
																							Line:   117,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 65,
																							Line:   117,
																						},
																						File:   "geo.flux",
																						Source: "lon",
																						Start: ast.Position{
																							Column: 62,
																							Line:   117,
																						},
																					},
																				},
																				Name: "lon",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 80,
																			Line:   117,
																		},
																		File:   "geo.flux",
																		Source: "level: level",
																		Start: ast.Position{
																			Column: 68,
																			Line:   117,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 73,
																				Line:   117,
																			},
																			File:   "geo.flux",
																			Source: "level",
																			Start: ast.Position{
																				Column: 68,
																				Line:   117,
																			},
																		},
																	},
																	Name: "level",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 80,
																				Line:   117,
																			},
																			File:   "geo.flux",
																			Source: "level",
																			Start: ast.Position{
																				Column: 75,
																				Line:   117,
																			},
																		},
																	},
																	Name: "level",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 81,
																	Line:   117,
																},
																File:   "geo.flux",
																Source: "s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)",
																Start: ast.Position{
																	Column: 21,
																	Line:   117,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   117,
																	},
																	File:   "geo.flux",
																	Source: "s2CellIDToken",
																	Start: ast.Position{
																		Column: 21,
																		Line:   117,
																	},
																},
															},
															Name: "s2CellIDToken",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   116,
															},
															File:   "geo.flux",
															Source: "r",
															Start: ast.Position{
																Column: 26,
																Line:   116,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   116,
													},
													File:   "geo.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   116,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   116,
														},
														File:   "geo.flux",
														Source: "r",
														Start: ast.Position{
															Column: 17,
															Line:   116,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   119,
									},
									File:   "geo.flux",
									Source: "map(fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })\n    )",
									Start: ast.Position{
										Column: 8,
										Line:   116,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   116,
										},
										File:   "geo.flux",
										Source: "map",
										Start: ast.Position{
											Column: 8,
											Line:   116,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   123,
							},
							File:   "geo.flux",
							Source: "tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )\n    |> toRows()\n    |> map(fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })\n    )\n    |> experimental.group(\n      columns: [\"s2_cell_id\"],\n      mode: \"extend\"\n    )",
							Start: ast.Position{
								Column: 3,
								Line:   107,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   122,
									},
									File:   "geo.flux",
									Source: "columns: [\"s2_cell_id\"],\n      mode: \"extend\"",
									Start: ast.Position{
										Column: 7,
										Line:   121,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   121,
										},
										File:   "geo.flux",
										Source: "columns: [\"s2_cell_id\"]",
										Start: ast.Position{
											Column: 7,
											Line:   121,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   121,
											},
											File:   "geo.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 7,
												Line:   121,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   121,
											},
											File:   "geo.flux",
											Source: "[\"s2_cell_id\"]",
											Start: ast.Position{
												Column: 16,
												Line:   121,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   121,
												},
												File:   "geo.flux",
												Source: "\"s2_cell_id\"",
												Start: ast.Position{
													Column: 17,
													Line:   121,
												},
											},
										},
										Value: "s2_cell_id",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   122,
										},
										File:   "geo.flux",
										Source: "mode: \"extend\"",
										Start: ast.Position{
											Column: 7,
											Line:   122,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   122,
											},
											File:   "geo.flux",
											Source: "mode",
											Start: ast.Position{
												Column: 7,
												Line:   122,
											},
										},
									},
									Name: "mode",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   122,
											},
											File:   "geo.flux",
											Source: "\"extend\"",
											Start: ast.Position{
												Column: 13,
												Line:   122,
											},
										},
									},
									Value: "extend",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   123,
								},
								File:   "geo.flux",
								Source: "experimental.group(\n      columns: [\"s2_cell_id\"],\n      mode: \"extend\"\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   120,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   120,
									},
									File:   "geo.flux",
									Source: "experimental.group",
									Start: ast.Position{
										Column: 8,
										Line:   120,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   120,
										},
										File:   "geo.flux",
										Source: "experimental",
										Start: ast.Position{
											Column: 8,
											Line:   120,
										},
									},
								},
								Name: "experimental",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   120,
										},
										File:   "geo.flux",
										Source: "group",
										Start: ast.Position{
											Column: 21,
											Line:   120,
										},
									},
								},
								Name: "group",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   106,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 14,
								Line:   106,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   106,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 14,
									Line:   106,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   106,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 21,
								Line:   106,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   106,
							},
							File:   "geo.flux",
							Source: "latField",
							Start: ast.Position{
								Column: 25,
								Line:   106,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   106,
								},
								File:   "geo.flux",
								Source: "latField",
								Start: ast.Position{
									Column: 25,
									Line:   106,
								},
							},
						},
						Name: "latField",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   106,
							},
							File:   "geo.flux",
							Source: "lonField",
							Start: ast.Position{
								Column: 35,
								Line:   106,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   106,
								},
								File:   "geo.flux",
								Source: "lonField",
								Start: ast.Position{
									Column: 35,
									Line:   106,
								},
							},
						},
						Name: "lonField",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   106,
							},
							File:   "geo.flux",
							Source: "level",
							Start: ast.Position{
								Column: 45,
								Line:   106,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   106,
								},
								File:   "geo.flux",
								Source: "level",
								Start: ast.Position{
									Column: 45,
									Line:   106,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   148,
					},
					File:   "geo.flux",
					Source: "gridFilter = (tables=<-, region, minSize=24, maxSize=-1, level=-1, s2cellIDLevel=-1, units=units) => {\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _grid = getGrid(region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel, units: units)\n  return\n    tables\n      |> filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )\n}",
					Start: ast.Position{
						Column: 1,
						Line:   132,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Filtering functions\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Filters records by a box, a circle or a polygon area using S2 cell ID tag.\n"}, ast.Comment{Text: "// It is a coarse filter, as the grid always overlays the region, the result will likely contain records\n"}, ast.Comment{Text: "// with lat/lon outside the specified region.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   132,
						},
						File:   "geo.flux",
						Source: "gridFilter",
						Start: ast.Position{
							Column: 1,
							Line:   132,
						},
					},
				},
				Name: "gridFilter",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   148,
						},
						File:   "geo.flux",
						Source: "(tables=<-, region, minSize=24, maxSize=-1, level=-1, s2cellIDLevel=-1, units=units) => {\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _grid = getGrid(region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel, units: units)\n  return\n    tables\n      |> filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )\n}",
						Start: ast.Position{
							Column: 14,
							Line:   132,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   148,
							},
							File:   "geo.flux",
							Source: "{\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _grid = getGrid(region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel, units: units)\n  return\n    tables\n      |> filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )\n}",
							Start: ast.Position{
								Column: 102,
								Line:   132,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   138,
								},
								File:   "geo.flux",
								Source: "_s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel",
								Start: ast.Position{
									Column: 3,
									Line:   133,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   133,
									},
									File:   "geo.flux",
									Source: "_s2cellIDLevel",
									Start: ast.Position{
										Column: 3,
										Line:   133,
									},
								},
							},
							Name: "_s2cellIDLevel",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   138,
										},
										File:   "geo.flux",
										Source: "s2cellIDLevel",
										Start: ast.Position{
											Column: 7,
											Line:   138,
										},
									},
								},
								Name: "s2cellIDLevel",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   138,
									},
									File:   "geo.flux",
									Source: "if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel",
									Start: ast.Position{
										Column: 5,
										Line:   134,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   135,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 7,
												Line:   135,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   136,
										},
										File:   "geo.flux",
										Source: "tables\n        |> _detectLevel()",
										Start: ast.Position{
											Column: 7,
											Line:   135,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   136,
											},
											File:   "geo.flux",
											Source: "_detectLevel()",
											Start: ast.Position{
												Column: 12,
												Line:   136,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   136,
												},
												File:   "geo.flux",
												Source: "_detectLevel",
												Start: ast.Position{
													Column: 12,
													Line:   136,
												},
											},
										},
										Name: "_detectLevel",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   134,
										},
										File:   "geo.flux",
										Source: "s2cellIDLevel == -1",
										Start: ast.Position{
											Column: 8,
											Line:   134,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   134,
											},
											File:   "geo.flux",
											Source: "s2cellIDLevel",
											Start: ast.Position{
												Column: 8,
												Line:   134,
											},
										},
									},
									Name: "s2cellIDLevel",
								},
								Operator: 17,
								Right: &ast.UnaryExpression{
									Argument: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   134,
												},
												File:   "geo.flux",
												Source: "1",
												Start: ast.Position{
													Column: 26,
													Line:   134,
												},
											},
										},
										Value: int64(1),
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   134,
											},
											File:   "geo.flux",
											Source: "-1",
											Start: ast.Position{
												Column: 25,
												Line:   134,
											},
										},
									},
									Operator: 6,
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   139,
								},
								File:   "geo.flux",
								Source: "_grid = getGrid(region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel, units: units)",
								Start: ast.Position{
									Column: 3,
									Line:   139,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   139,
									},
									File:   "geo.flux",
									Source: "_grid",
									Start: ast.Position{
										Column: 3,
										Line:   139,
									},
								},
							},
							Name: "_grid",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 123,
											Line:   139,
										},
										File:   "geo.flux",
										Source: "region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel, units: units",
										Start: ast.Position{
											Column: 19,
											Line:   139,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   139,
											},
											File:   "geo.flux",
											Source: "region: region",
											Start: ast.Position{
												Column: 19,
												Line:   139,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "region",
												Start: ast.Position{
													Column: 19,
													Line:   139,
												},
											},
										},
										Name: "region",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "region",
												Start: ast.Position{
													Column: 27,
													Line:   139,
												},
											},
										},
										Name: "region",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   139,
											},
											File:   "geo.flux",
											Source: "minSize: minSize",
											Start: ast.Position{
												Column: 35,
												Line:   139,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "minSize",
												Start: ast.Position{
													Column: 35,
													Line:   139,
												},
											},
										},
										Name: "minSize",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "minSize",
												Start: ast.Position{
													Column: 44,
													Line:   139,
												},
											},
										},
										Name: "minSize",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   139,
											},
											File:   "geo.flux",
											Source: "maxSize: maxSize",
											Start: ast.Position{
												Column: 53,
												Line:   139,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "maxSize",
												Start: ast.Position{
													Column: 53,
													Line:   139,
												},
											},
										},
										Name: "maxSize",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "maxSize",
												Start: ast.Position{
													Column: 62,
													Line:   139,
												},
											},
										},
										Name: "maxSize",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   139,
											},
											File:   "geo.flux",
											Source: "level: level",
											Start: ast.Position{
												Column: 71,
												Line:   139,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "level",
												Start: ast.Position{
													Column: 71,
													Line:   139,
												},
											},
										},
										Name: "level",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 83,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "level",
												Start: ast.Position{
													Column: 78,
													Line:   139,
												},
											},
										},
										Name: "level",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   139,
											},
											File:   "geo.flux",
											Source: "maxLevel: _s2cellIDLevel",
											Start: ast.Position{
												Column: 85,
												Line:   139,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 93,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "maxLevel",
												Start: ast.Position{
													Column: 85,
													Line:   139,
												},
											},
										},
										Name: "maxLevel",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 109,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "_s2cellIDLevel",
												Start: ast.Position{
													Column: 95,
													Line:   139,
												},
											},
										},
										Name: "_s2cellIDLevel",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 123,
												Line:   139,
											},
											File:   "geo.flux",
											Source: "units: units",
											Start: ast.Position{
												Column: 111,
												Line:   139,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 116,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "units",
												Start: ast.Position{
													Column: 111,
													Line:   139,
												},
											},
										},
										Name: "units",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 123,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "units",
												Start: ast.Position{
													Column: 118,
													Line:   139,
												},
											},
										},
										Name: "units",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 124,
										Line:   139,
									},
									File:   "geo.flux",
									Source: "getGrid(region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel, units: units)",
									Start: ast.Position{
										Column: 11,
										Line:   139,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   139,
										},
										File:   "geo.flux",
										Source: "getGrid",
										Start: ast.Position{
											Column: 11,
											Line:   139,
										},
									},
								},
								Name: "getGrid",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   141,
										},
										File:   "geo.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 5,
											Line:   141,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   147,
									},
									File:   "geo.flux",
									Source: "tables\n      |> filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )",
									Start: ast.Position{
										Column: 5,
										Line:   141,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   146,
											},
											File:   "geo.flux",
											Source: "fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
											Start: ast.Position{
												Column: 17,
												Line:   142,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 98,
													Line:   146,
												},
												File:   "geo.flux",
												Source: "fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
												Start: ast.Position{
													Column: 17,
													Line:   142,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   142,
													},
													File:   "geo.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 17,
														Line:   142,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 98,
														Line:   146,
													},
													File:   "geo.flux",
													Source: "(r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
													Start: ast.Position{
														Column: 21,
														Line:   142,
													},
												},
											},
											Body: &ast.ConditionalExpression{
												Alternate: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 97,
																	Line:   146,
																},
																File:   "geo.flux",
																Source: "value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set",
																Start: ast.Position{
																	Column: 20,
																	Line:   146,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 81,
																		Line:   146,
																	},
																	File:   "geo.flux",
																	Source: "value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level)",
																	Start: ast.Position{
																		Column: 20,
																		Line:   146,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   146,
																		},
																		File:   "geo.flux",
																		Source: "value",
																		Start: ast.Position{
																			Column: 20,
																			Line:   146,
																		},
																	},
																},
																Name: "value",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 80,
																				Line:   146,
																			},
																			File:   "geo.flux",
																			Source: "token: r.s2_cell_id, level: _grid.level",
																			Start: ast.Position{
																				Column: 41,
																				Line:   146,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 60,
																					Line:   146,
																				},
																				File:   "geo.flux",
																				Source: "token: r.s2_cell_id",
																				Start: ast.Position{
																					Column: 41,
																					Line:   146,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 46,
																						Line:   146,
																					},
																					File:   "geo.flux",
																					Source: "token",
																					Start: ast.Position{
																						Column: 41,
																						Line:   146,
																					},
																				},
																			},
																			Name: "token",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 60,
																						Line:   146,
																					},
																					File:   "geo.flux",
																					Source: "r.s2_cell_id",
																					Start: ast.Position{
																						Column: 48,
																						Line:   146,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 49,
																							Line:   146,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 48,
																							Line:   146,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 60,
																							Line:   146,
																						},
																						File:   "geo.flux",
																						Source: "s2_cell_id",
																						Start: ast.Position{
																							Column: 50,
																							Line:   146,
																						},
																					},
																				},
																				Name: "s2_cell_id",
																			},
																			Rbrack: nil,
																		},
																	}, &ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 80,
																					Line:   146,
																				},
																				File:   "geo.flux",
																				Source: "level: _grid.level",
																				Start: ast.Position{
																					Column: 62,
																					Line:   146,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 67,
																						Line:   146,
																					},
																					File:   "geo.flux",
																					Source: "level",
																					Start: ast.Position{
																						Column: 62,
																						Line:   146,
																					},
																				},
																			},
																			Name: "level",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 80,
																						Line:   146,
																					},
																					File:   "geo.flux",
																					Source: "_grid.level",
																					Start: ast.Position{
																						Column: 69,
																						Line:   146,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 74,
																							Line:   146,
																						},
																						File:   "geo.flux",
																						Source: "_grid",
																						Start: ast.Position{
																							Column: 69,
																							Line:   146,
																						},
																					},
																				},
																				Name: "_grid",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 80,
																							Line:   146,
																						},
																						File:   "geo.flux",
																						Source: "level",
																						Start: ast.Position{
																							Column: 75,
																							Line:   146,
																						},
																					},
																				},
																				Name: "level",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   146,
																		},
																		File:   "geo.flux",
																		Source: "s2CellIDToken(token: r.s2_cell_id, level: _grid.level)",
																		Start: ast.Position{
																			Column: 27,
																			Line:   146,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   146,
																			},
																			File:   "geo.flux",
																			Source: "s2CellIDToken",
																			Start: ast.Position{
																				Column: 27,
																				Line:   146,
																			},
																		},
																	},
																	Name: "s2CellIDToken",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 97,
																		Line:   146,
																	},
																	File:   "geo.flux",
																	Source: "set: _grid.set",
																	Start: ast.Position{
																		Column: 83,
																		Line:   146,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 86,
																			Line:   146,
																		},
																		File:   "geo.flux",
																		Source: "set",
																		Start: ast.Position{
																			Column: 83,
																			Line:   146,
																		},
																	},
																},
																Name: "set",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 97,
																			Line:   146,
																		},
																		File:   "geo.flux",
																		Source: "_grid.set",
																		Start: ast.Position{
																			Column: 88,
																			Line:   146,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 93,
																				Line:   146,
																			},
																			File:   "geo.flux",
																			Source: "_grid",
																			Start: ast.Position{
																				Column: 88,
																				Line:   146,
																			},
																		},
																	},
																	Name: "_grid",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 97,
																				Line:   146,
																			},
																			File:   "geo.flux",
																			Source: "set",
																			Start: ast.Position{
																				Column: 94,
																				Line:   146,
																			},
																		},
																	},
																	Name: "set",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 98,
																Line:   146,
															},
															File:   "geo.flux",
															Source: "contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
															Start: ast.Position{
																Column: 11,
																Line:   146,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   146,
																},
																File:   "geo.flux",
																Source: "contains",
																Start: ast.Position{
																	Column: 11,
																	Line:   146,
																},
															},
														},
														Name: "contains",
													},
													Lparen: nil,
													Rparen: nil,
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 98,
															Line:   146,
														},
														File:   "geo.flux",
														Source: "if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
														Start: ast.Position{
															Column: 9,
															Line:   143,
														},
													},
												},
												Consequent: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   144,
																},
																File:   "geo.flux",
																Source: "value: r.s2_cell_id, set: _grid.set",
																Start: ast.Position{
																	Column: 20,
																	Line:   144,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   144,
																	},
																	File:   "geo.flux",
																	Source: "value: r.s2_cell_id",
																	Start: ast.Position{
																		Column: 20,
																		Line:   144,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   144,
																		},
																		File:   "geo.flux",
																		Source: "value",
																		Start: ast.Position{
																			Column: 20,
																			Line:   144,
																		},
																	},
																},
																Name: "value",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 39,
																			Line:   144,
																		},
																		File:   "geo.flux",
																		Source: "r.s2_cell_id",
																		Start: ast.Position{
																			Column: 27,
																			Line:   144,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   144,
																			},
																			File:   "geo.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 27,
																				Line:   144,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 39,
																				Line:   144,
																			},
																			File:   "geo.flux",
																			Source: "s2_cell_id",
																			Start: ast.Position{
																				Column: 29,
																				Line:   144,
																			},
																		},
																	},
																	Name: "s2_cell_id",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   144,
																	},
																	File:   "geo.flux",
																	Source: "set: _grid.set",
																	Start: ast.Position{
																		Column: 41,
																		Line:   144,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   144,
																		},
																		File:   "geo.flux",
																		Source: "set",
																		Start: ast.Position{
																			Column: 41,
																			Line:   144,
																		},
																	},
																},
																Name: "set",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   144,
																		},
																		File:   "geo.flux",
																		Source: "_grid.set",
																		Start: ast.Position{
																			Column: 46,
																			Line:   144,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   144,
																			},
																			File:   "geo.flux",
																			Source: "_grid",
																			Start: ast.Position{
																				Column: 46,
																				Line:   144,
																			},
																		},
																	},
																	Name: "_grid",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   144,
																			},
																			File:   "geo.flux",
																			Source: "set",
																			Start: ast.Position{
																				Column: 52,
																				Line:   144,
																			},
																		},
																	},
																	Name: "set",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   144,
															},
															File:   "geo.flux",
															Source: "contains(value: r.s2_cell_id, set: _grid.set)",
															Start: ast.Position{
																Column: 11,
																Line:   144,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   144,
																},
																File:   "geo.flux",
																Source: "contains",
																Start: ast.Position{
																	Column: 11,
																	Line:   144,
																},
															},
														},
														Name: "contains",
													},
													Lparen: nil,
													Rparen: nil,
												},
												Test: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   143,
															},
															File:   "geo.flux",
															Source: "_grid.level == _s2cellIDLevel",
															Start: ast.Position{
																Column: 12,
																Line:   143,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   143,
																},
																File:   "geo.flux",
																Source: "_grid.level",
																Start: ast.Position{
																	Column: 12,
																	Line:   143,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 17,
																		Line:   143,
																	},
																	File:   "geo.flux",
																	Source: "_grid",
																	Start: ast.Position{
																		Column: 12,
																		Line:   143,
																	},
																},
															},
															Name: "_grid",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 23,
																		Line:   143,
																	},
																	File:   "geo.flux",
																	Source: "level",
																	Start: ast.Position{
																		Column: 18,
																		Line:   143,
																	},
																},
															},
															Name: "level",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   143,
																},
																File:   "geo.flux",
																Source: "_s2cellIDLevel",
																Start: ast.Position{
																	Column: 27,
																	Line:   143,
																},
															},
														},
														Name: "_s2cellIDLevel",
													},
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   142,
														},
														File:   "geo.flux",
														Source: "r",
														Start: ast.Position{
															Column: 22,
															Line:   142,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   142,
															},
															File:   "geo.flux",
															Source: "r",
															Start: ast.Position{
																Column: 22,
																Line:   142,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   147,
										},
										File:   "geo.flux",
										Source: "filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )",
										Start: ast.Position{
											Column: 10,
											Line:   142,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   142,
											},
											File:   "geo.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 10,
												Line:   142,
											},
										},
									},
									Name: "filter",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 8,
									Line:   147,
								},
								File:   "geo.flux",
								Source: "return\n    tables\n      |> filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )",
								Start: ast.Position{
									Column: 3,
									Line:   140,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   132,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   132,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   132,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   132,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   132,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   132,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 26,
								Line:   132,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 26,
									Line:   132,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   132,
							},
							File:   "geo.flux",
							Source: "minSize=24",
							Start: ast.Position{
								Column: 34,
								Line:   132,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "minSize",
								Start: ast.Position{
									Column: 34,
									Line:   132,
								},
							},
						},
						Name: "minSize",
					},
					Separator: nil,
					Value: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "24",
								Start: ast.Position{
									Column: 42,
									Line:   132,
								},
							},
						},
						Value: int64(24),
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   132,
							},
							File:   "geo.flux",
							Source: "maxSize=-1",
							Start: ast.Position{
								Column: 46,
								Line:   132,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "maxSize",
								Start: ast.Position{
									Column: 46,
									Line:   132,
								},
							},
						},
						Name: "maxSize",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   132,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 55,
										Line:   132,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 54,
									Line:   132,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   132,
							},
							File:   "geo.flux",
							Source: "level=-1",
							Start: ast.Position{
								Column: 58,
								Line:   132,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "level",
								Start: ast.Position{
									Column: 58,
									Line:   132,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   132,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 65,
										Line:   132,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 64,
									Line:   132,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   132,
							},
							File:   "geo.flux",
							Source: "s2cellIDLevel=-1",
							Start: ast.Position{
								Column: 68,
								Line:   132,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "s2cellIDLevel",
								Start: ast.Position{
									Column: 68,
									Line:   132,
								},
							},
						},
						Name: "s2cellIDLevel",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   132,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 83,
										Line:   132,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 82,
									Line:   132,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   132,
							},
							File:   "geo.flux",
							Source: "units=units",
							Start: ast.Position{
								Column: 86,
								Line:   132,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 86,
									Line:   132,
								},
							},
						},
						Name: "units",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 92,
									Line:   132,
								},
							},
						},
						Name: "units",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   156,
					},
					File:   "geo.flux",
					Source: "strictFilter = (tables=<-, region) =>\n  tables\n    |> filter(fn: (r) =>\n      ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   152,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Filters records by specified region.\n"}, ast.Comment{Text: "// It is an exact filter and must be used after `toRows()` because it requires `lat` and `lon` columns in input row sets.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   152,
						},
						File:   "geo.flux",
						Source: "strictFilter",
						Start: ast.Position{
							Column: 1,
							Line:   152,
						},
					},
				},
				Name: "strictFilter",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   156,
						},
						File:   "geo.flux",
						Source: "(tables=<-, region) =>\n  tables\n    |> filter(fn: (r) =>\n      ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})\n    )",
						Start: ast.Position{
							Column: 16,
							Line:   152,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   153,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 3,
									Line:   153,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   156,
							},
							File:   "geo.flux",
							Source: "tables\n    |> filter(fn: (r) =>\n      ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})\n    )",
							Start: ast.Position{
								Column: 3,
								Line:   153,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   155,
									},
									File:   "geo.flux",
									Source: "fn: (r) =>\n      ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})",
									Start: ast.Position{
										Column: 15,
										Line:   154,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   155,
										},
										File:   "geo.flux",
										Source: "fn: (r) =>\n      ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})",
										Start: ast.Position{
											Column: 15,
											Line:   154,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   154,
											},
											File:   "geo.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 15,
												Line:   154,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   155,
											},
											File:   "geo.flux",
											Source: "(r) =>\n      ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})",
											Start: ast.Position{
												Column: 19,
												Line:   154,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   155,
													},
													File:   "geo.flux",
													Source: "region: region, geometry: {lat: r.lat, lon: r.lon}",
													Start: ast.Position{
														Column: 19,
														Line:   155,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   155,
														},
														File:   "geo.flux",
														Source: "region: region",
														Start: ast.Position{
															Column: 19,
															Line:   155,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   155,
															},
															File:   "geo.flux",
															Source: "region",
															Start: ast.Position{
																Column: 19,
																Line:   155,
															},
														},
													},
													Name: "region",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   155,
															},
															File:   "geo.flux",
															Source: "region",
															Start: ast.Position{
																Column: 27,
																Line:   155,
															},
														},
													},
													Name: "region",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   155,
														},
														File:   "geo.flux",
														Source: "geometry: {lat: r.lat, lon: r.lon}",
														Start: ast.Position{
															Column: 35,
															Line:   155,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 43,
																Line:   155,
															},
															File:   "geo.flux",
															Source: "geometry",
															Start: ast.Position{
																Column: 35,
																Line:   155,
															},
														},
													},
													Name: "geometry",
												},
												Separator: nil,
												Value: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   155,
															},
															File:   "geo.flux",
															Source: "{lat: r.lat, lon: r.lon}",
															Start: ast.Position{
																Column: 45,
																Line:   155,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   155,
																},
																File:   "geo.flux",
																Source: "lat: r.lat",
																Start: ast.Position{
																	Column: 46,
																	Line:   155,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   155,
																	},
																	File:   "geo.flux",
																	Source: "lat",
																	Start: ast.Position{
																		Column: 46,
																		Line:   155,
																	},
																},
															},
															Name: "lat",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   155,
																	},
																	File:   "geo.flux",
																	Source: "r.lat",
																	Start: ast.Position{
																		Column: 51,
																		Line:   155,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 52,
																			Line:   155,
																		},
																		File:   "geo.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 51,
																			Line:   155,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   155,
																		},
																		File:   "geo.flux",
																		Source: "lat",
																		Start: ast.Position{
																			Column: 53,
																			Line:   155,
																		},
																	},
																},
																Name: "lat",
															},
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   155,
																},
																File:   "geo.flux",
																Source: "lon: r.lon",
																Start: ast.Position{
																	Column: 58,
																	Line:   155,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 61,
																		Line:   155,
																	},
																	File:   "geo.flux",
																	Source: "lon",
																	Start: ast.Position{
																		Column: 58,
																		Line:   155,
																	},
																},
															},
															Name: "lon",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   155,
																	},
																	File:   "geo.flux",
																	Source: "r.lon",
																	Start: ast.Position{
																		Column: 63,
																		Line:   155,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   155,
																		},
																		File:   "geo.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 63,
																			Line:   155,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 68,
																			Line:   155,
																		},
																		File:   "geo.flux",
																		Source: "lon",
																		Start: ast.Position{
																			Column: 65,
																			Line:   155,
																		},
																	},
																},
																Name: "lon",
															},
															Rbrack: nil,
														},
													}},
													Rbrace: nil,
													With:   nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   155,
												},
												File:   "geo.flux",
												Source: "ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})",
												Start: ast.Position{
													Column: 7,
													Line:   155,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   155,
													},
													File:   "geo.flux",
													Source: "ST_Contains",
													Start: ast.Position{
														Column: 7,
														Line:   155,
													},
												},
											},
											Name: "ST_Contains",
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   154,
												},
												File:   "geo.flux",
												Source: "r",
												Start: ast.Position{
													Column: 20,
													Line:   154,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   154,
													},
													File:   "geo.flux",
													Source: "r",
													Start: ast.Position{
														Column: 20,
														Line:   154,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   156,
								},
								File:   "geo.flux",
								Source: "filter(fn: (r) =>\n      ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   154,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   154,
									},
									File:   "geo.flux",
									Source: "filter",
									Start: ast.Position{
										Column: 8,
										Line:   154,
									},
								},
							},
							Name: "filter",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   152,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   152,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   152,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   152,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   152,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   152,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   152,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 28,
								Line:   152,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   152,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 28,
									Line:   152,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   182,
					},
					File:   "geo.flux",
					Source: "filterRows = (tables=<-, region, minSize=24, maxSize=-1, level=-1, s2cellIDLevel=-1, strict=true) => {\n  _columns =\n    tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )\n      |> getColumn(column: \"_value\")\n  _rows =\n    if contains(value: \"lat\", set: _columns) then\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n    else\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows()\n  _result =\n    if strict then\n      _rows\n        |> strictFilter(region)\n    else\n      _rows\n  return _result\n}",
					Start: ast.Position{
						Column: 1,
						Line:   161,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Two-phase filtering by specified region.\n"}, ast.Comment{Text: "// Checks to see if data is already pivoted and contains a lat column.\n"}, ast.Comment{Text: "// Returns pivoted data.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   161,
						},
						File:   "geo.flux",
						Source: "filterRows",
						Start: ast.Position{
							Column: 1,
							Line:   161,
						},
					},
				},
				Name: "filterRows",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   182,
						},
						File:   "geo.flux",
						Source: "(tables=<-, region, minSize=24, maxSize=-1, level=-1, s2cellIDLevel=-1, strict=true) => {\n  _columns =\n    tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )\n      |> getColumn(column: \"_value\")\n  _rows =\n    if contains(value: \"lat\", set: _columns) then\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n    else\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows()\n  _result =\n    if strict then\n      _rows\n        |> strictFilter(region)\n    else\n      _rows\n  return _result\n}",
						Start: ast.Position{
							Column: 14,
							Line:   161,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   182,
							},
							File:   "geo.flux",
							Source: "{\n  _columns =\n    tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )\n      |> getColumn(column: \"_value\")\n  _rows =\n    if contains(value: \"lat\", set: _columns) then\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n    else\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows()\n  _result =\n    if strict then\n      _rows\n        |> strictFilter(region)\n    else\n      _rows\n  return _result\n}",
							Start: ast.Position{
								Column: 102,
								Line:   161,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   166,
								},
								File:   "geo.flux",
								Source: "_columns =\n    tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )\n      |> getColumn(column: \"_value\")",
								Start: ast.Position{
									Column: 3,
									Line:   162,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   162,
									},
									File:   "geo.flux",
									Source: "_columns",
									Start: ast.Position{
										Column: 3,
										Line:   162,
									},
								},
							},
							Name: "_columns",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   163,
												},
												File:   "geo.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 5,
													Line:   163,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   164,
											},
											File:   "geo.flux",
											Source: "tables\n      |> columns(column: \"_value\")",
											Start: ast.Position{
												Column: 5,
												Line:   163,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   164,
													},
													File:   "geo.flux",
													Source: "column: \"_value\"",
													Start: ast.Position{
														Column: 18,
														Line:   164,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   164,
														},
														File:   "geo.flux",
														Source: "column: \"_value\"",
														Start: ast.Position{
															Column: 18,
															Line:   164,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   164,
															},
															File:   "geo.flux",
															Source: "column",
															Start: ast.Position{
																Column: 18,
																Line:   164,
															},
														},
													},
													Name: "column",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   164,
															},
															File:   "geo.flux",
															Source: "\"_value\"",
															Start: ast.Position{
																Column: 26,
																Line:   164,
															},
														},
													},
													Value: "_value",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   164,
												},
												File:   "geo.flux",
												Source: "columns(column: \"_value\")",
												Start: ast.Position{
													Column: 10,
													Line:   164,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   164,
													},
													File:   "geo.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 10,
														Line:   164,
													},
												},
											},
											Name: "columns",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   165,
										},
										File:   "geo.flux",
										Source: "tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )",
										Start: ast.Position{
											Column: 5,
											Line:   163,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   165,
												},
												File:   "geo.flux",
												Source: "fn: (key) => true",
												Start: ast.Position{
													Column: 20,
													Line:   165,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   165,
													},
													File:   "geo.flux",
													Source: "fn: (key) => true",
													Start: ast.Position{
														Column: 20,
														Line:   165,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   165,
														},
														File:   "geo.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 20,
															Line:   165,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   165,
														},
														File:   "geo.flux",
														Source: "(key) => true",
														Start: ast.Position{
															Column: 24,
															Line:   165,
														},
													},
												},
												Body: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   165,
															},
															File:   "geo.flux",
															Source: "true",
															Start: ast.Position{
																Column: 33,
																Line:   165,
															},
														},
													},
													Name: "true",
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   165,
															},
															File:   "geo.flux",
															Source: "key",
															Start: ast.Position{
																Column: 25,
																Line:   165,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 28,
																	Line:   165,
																},
																File:   "geo.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 25,
																	Line:   165,
																},
															},
														},
														Name: "key",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   165,
											},
											File:   "geo.flux",
											Source: "tableFind(fn: (key) => true )",
											Start: ast.Position{
												Column: 10,
												Line:   165,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   165,
												},
												File:   "geo.flux",
												Source: "tableFind",
												Start: ast.Position{
													Column: 10,
													Line:   165,
												},
											},
										},
										Name: "tableFind",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   166,
									},
									File:   "geo.flux",
									Source: "tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )\n      |> getColumn(column: \"_value\")",
									Start: ast.Position{
										Column: 5,
										Line:   163,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   166,
											},
											File:   "geo.flux",
											Source: "column: \"_value\"",
											Start: ast.Position{
												Column: 20,
												Line:   166,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   166,
												},
												File:   "geo.flux",
												Source: "column: \"_value\"",
												Start: ast.Position{
													Column: 20,
													Line:   166,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   166,
													},
													File:   "geo.flux",
													Source: "column",
													Start: ast.Position{
														Column: 20,
														Line:   166,
													},
												},
											},
											Name: "column",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   166,
													},
													File:   "geo.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 28,
														Line:   166,
													},
												},
											},
											Value: "_value",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   166,
										},
										File:   "geo.flux",
										Source: "getColumn(column: \"_value\")",
										Start: ast.Position{
											Column: 10,
											Line:   166,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   166,
											},
											File:   "geo.flux",
											Source: "getColumn",
											Start: ast.Position{
												Column: 10,
												Line:   166,
											},
										},
									},
									Name: "getColumn",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   174,
								},
								File:   "geo.flux",
								Source: "_rows =\n    if contains(value: \"lat\", set: _columns) then\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n    else\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows()",
								Start: ast.Position{
									Column: 3,
									Line:   167,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   167,
									},
									File:   "geo.flux",
									Source: "_rows",
									Start: ast.Position{
										Column: 3,
										Line:   167,
									},
								},
							},
							Name: "_rows",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   172,
												},
												File:   "geo.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 7,
													Line:   172,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 118,
												Line:   173,
											},
											File:   "geo.flux",
											Source: "tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)",
											Start: ast.Position{
												Column: 7,
												Line:   172,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 117,
														Line:   173,
													},
													File:   "geo.flux",
													Source: "region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel",
													Start: ast.Position{
														Column: 23,
														Line:   173,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   173,
														},
														File:   "geo.flux",
														Source: "region: region",
														Start: ast.Position{
															Column: 23,
															Line:   173,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   173,
															},
															File:   "geo.flux",
															Source: "region",
															Start: ast.Position{
																Column: 23,
																Line:   173,
															},
														},
													},
													Name: "region",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   173,
															},
															File:   "geo.flux",
															Source: "region",
															Start: ast.Position{
																Column: 31,
																Line:   173,
															},
														},
													},
													Name: "region",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   173,
														},
														File:   "geo.flux",
														Source: "minSize: minSize",
														Start: ast.Position{
															Column: 39,
															Line:   173,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   173,
															},
															File:   "geo.flux",
															Source: "minSize",
															Start: ast.Position{
																Column: 39,
																Line:   173,
															},
														},
													},
													Name: "minSize",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   173,
															},
															File:   "geo.flux",
															Source: "minSize",
															Start: ast.Position{
																Column: 48,
																Line:   173,
															},
														},
													},
													Name: "minSize",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   173,
														},
														File:   "geo.flux",
														Source: "maxSize: maxSize",
														Start: ast.Position{
															Column: 57,
															Line:   173,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 64,
																Line:   173,
															},
															File:   "geo.flux",
															Source: "maxSize",
															Start: ast.Position{
																Column: 57,
																Line:   173,
															},
														},
													},
													Name: "maxSize",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   173,
															},
															File:   "geo.flux",
															Source: "maxSize",
															Start: ast.Position{
																Column: 66,
																Line:   173,
															},
														},
													},
													Name: "maxSize",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   173,
														},
														File:   "geo.flux",
														Source: "level: level",
														Start: ast.Position{
															Column: 75,
															Line:   173,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 80,
																Line:   173,
															},
															File:   "geo.flux",
															Source: "level",
															Start: ast.Position{
																Column: 75,
																Line:   173,
															},
														},
													},
													Name: "level",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 87,
																Line:   173,
															},
															File:   "geo.flux",
															Source: "level",
															Start: ast.Position{
																Column: 82,
																Line:   173,
															},
														},
													},
													Name: "level",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 117,
															Line:   173,
														},
														File:   "geo.flux",
														Source: "s2cellIDLevel: s2cellIDLevel",
														Start: ast.Position{
															Column: 89,
															Line:   173,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 102,
																Line:   173,
															},
															File:   "geo.flux",
															Source: "s2cellIDLevel",
															Start: ast.Position{
																Column: 89,
																Line:   173,
															},
														},
													},
													Name: "s2cellIDLevel",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 117,
																Line:   173,
															},
															File:   "geo.flux",
															Source: "s2cellIDLevel",
															Start: ast.Position{
																Column: 104,
																Line:   173,
															},
														},
													},
													Name: "s2cellIDLevel",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 118,
													Line:   173,
												},
												File:   "geo.flux",
												Source: "gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)",
												Start: ast.Position{
													Column: 12,
													Line:   173,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   173,
													},
													File:   "geo.flux",
													Source: "gridFilter",
													Start: ast.Position{
														Column: 12,
														Line:   173,
													},
												},
											},
											Name: "gridFilter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   174,
										},
										File:   "geo.flux",
										Source: "tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows()",
										Start: ast.Position{
											Column: 7,
											Line:   172,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   174,
											},
											File:   "geo.flux",
											Source: "toRows()",
											Start: ast.Position{
												Column: 12,
												Line:   174,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   174,
												},
												File:   "geo.flux",
												Source: "toRows",
												Start: ast.Position{
													Column: 12,
													Line:   174,
												},
											},
										},
										Name: "toRows",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   174,
									},
									File:   "geo.flux",
									Source: "if contains(value: \"lat\", set: _columns) then\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n    else\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows()",
									Start: ast.Position{
										Column: 5,
										Line:   168,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   169,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 7,
												Line:   169,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 118,
											Line:   170,
										},
										File:   "geo.flux",
										Source: "tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)",
										Start: ast.Position{
											Column: 7,
											Line:   169,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 117,
													Line:   170,
												},
												File:   "geo.flux",
												Source: "region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel",
												Start: ast.Position{
													Column: 23,
													Line:   170,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   170,
													},
													File:   "geo.flux",
													Source: "region: region",
													Start: ast.Position{
														Column: 23,
														Line:   170,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   170,
														},
														File:   "geo.flux",
														Source: "region",
														Start: ast.Position{
															Column: 23,
															Line:   170,
														},
													},
												},
												Name: "region",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   170,
														},
														File:   "geo.flux",
														Source: "region",
														Start: ast.Position{
															Column: 31,
															Line:   170,
														},
													},
												},
												Name: "region",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   170,
													},
													File:   "geo.flux",
													Source: "minSize: minSize",
													Start: ast.Position{
														Column: 39,
														Line:   170,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   170,
														},
														File:   "geo.flux",
														Source: "minSize",
														Start: ast.Position{
															Column: 39,
															Line:   170,
														},
													},
												},
												Name: "minSize",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   170,
														},
														File:   "geo.flux",
														Source: "minSize",
														Start: ast.Position{
															Column: 48,
															Line:   170,
														},
													},
												},
												Name: "minSize",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   170,
													},
													File:   "geo.flux",
													Source: "maxSize: maxSize",
													Start: ast.Position{
														Column: 57,
														Line:   170,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   170,
														},
														File:   "geo.flux",
														Source: "maxSize",
														Start: ast.Position{
															Column: 57,
															Line:   170,
														},
													},
												},
												Name: "maxSize",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   170,
														},
														File:   "geo.flux",
														Source: "maxSize",
														Start: ast.Position{
															Column: 66,
															Line:   170,
														},
													},
												},
												Name: "maxSize",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   170,
													},
													File:   "geo.flux",
													Source: "level: level",
													Start: ast.Position{
														Column: 75,
														Line:   170,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   170,
														},
														File:   "geo.flux",
														Source: "level",
														Start: ast.Position{
															Column: 75,
															Line:   170,
														},
													},
												},
												Name: "level",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   170,
														},
														File:   "geo.flux",
														Source: "level",
														Start: ast.Position{
															Column: 82,
															Line:   170,
														},
													},
												},
												Name: "level",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 117,
														Line:   170,
													},
													File:   "geo.flux",
													Source: "s2cellIDLevel: s2cellIDLevel",
													Start: ast.Position{
														Column: 89,
														Line:   170,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 102,
															Line:   170,
														},
														File:   "geo.flux",
														Source: "s2cellIDLevel",
														Start: ast.Position{
															Column: 89,
															Line:   170,
														},
													},
												},
												Name: "s2cellIDLevel",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 117,
															Line:   170,
														},
														File:   "geo.flux",
														Source: "s2cellIDLevel",
														Start: ast.Position{
															Column: 104,
															Line:   170,
														},
													},
												},
												Name: "s2cellIDLevel",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 118,
												Line:   170,
											},
											File:   "geo.flux",
											Source: "gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)",
											Start: ast.Position{
												Column: 12,
												Line:   170,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   170,
												},
												File:   "geo.flux",
												Source: "gridFilter",
												Start: ast.Position{
													Column: 12,
													Line:   170,
												},
											},
										},
										Name: "gridFilter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   168,
											},
											File:   "geo.flux",
											Source: "value: \"lat\", set: _columns",
											Start: ast.Position{
												Column: 17,
												Line:   168,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   168,
												},
												File:   "geo.flux",
												Source: "value: \"lat\"",
												Start: ast.Position{
													Column: 17,
													Line:   168,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   168,
													},
													File:   "geo.flux",
													Source: "value",
													Start: ast.Position{
														Column: 17,
														Line:   168,
													},
												},
											},
											Name: "value",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   168,
													},
													File:   "geo.flux",
													Source: "\"lat\"",
													Start: ast.Position{
														Column: 24,
														Line:   168,
													},
												},
											},
											Value: "lat",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   168,
												},
												File:   "geo.flux",
												Source: "set: _columns",
												Start: ast.Position{
													Column: 31,
													Line:   168,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   168,
													},
													File:   "geo.flux",
													Source: "set",
													Start: ast.Position{
														Column: 31,
														Line:   168,
													},
												},
											},
											Name: "set",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   168,
													},
													File:   "geo.flux",
													Source: "_columns",
													Start: ast.Position{
														Column: 36,
														Line:   168,
													},
												},
											},
											Name: "_columns",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   168,
										},
										File:   "geo.flux",
										Source: "contains(value: \"lat\", set: _columns)",
										Start: ast.Position{
											Column: 8,
											Line:   168,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   168,
											},
											File:   "geo.flux",
											Source: "contains",
											Start: ast.Position{
												Column: 8,
												Line:   168,
											},
										},
									},
									Name: "contains",
								},
								Lparen: nil,
								Rparen: nil,
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   180,
								},
								File:   "geo.flux",
								Source: "_result =\n    if strict then\n      _rows\n        |> strictFilter(region)\n    else\n      _rows",
								Start: ast.Position{
									Column: 3,
									Line:   175,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   175,
									},
									File:   "geo.flux",
									Source: "_result",
									Start: ast.Position{
										Column: 3,
										Line:   175,
									},
								},
							},
							Name: "_result",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   180,
										},
										File:   "geo.flux",
										Source: "_rows",
										Start: ast.Position{
											Column: 7,
											Line:   180,
										},
									},
								},
								Name: "_rows",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   180,
									},
									File:   "geo.flux",
									Source: "if strict then\n      _rows\n        |> strictFilter(region)\n    else\n      _rows",
									Start: ast.Position{
										Column: 5,
										Line:   176,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   177,
											},
											File:   "geo.flux",
											Source: "_rows",
											Start: ast.Position{
												Column: 7,
												Line:   177,
											},
										},
									},
									Name: "_rows",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   178,
										},
										File:   "geo.flux",
										Source: "_rows\n        |> strictFilter(region)",
										Start: ast.Position{
											Column: 7,
											Line:   177,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   178,
												},
												File:   "geo.flux",
												Source: "region",
												Start: ast.Position{
													Column: 25,
													Line:   178,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   178,
													},
													File:   "geo.flux",
													Source: "region",
													Start: ast.Position{
														Column: 25,
														Line:   178,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   178,
														},
														File:   "geo.flux",
														Source: "region",
														Start: ast.Position{
															Column: 25,
															Line:   178,
														},
													},
												},
												Name: "region",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   178,
											},
											File:   "geo.flux",
											Source: "strictFilter(region)",
											Start: ast.Position{
												Column: 12,
												Line:   178,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   178,
												},
												File:   "geo.flux",
												Source: "strictFilter",
												Start: ast.Position{
													Column: 12,
													Line:   178,
												},
											},
										},
										Name: "strictFilter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   176,
										},
										File:   "geo.flux",
										Source: "strict",
										Start: ast.Position{
											Column: 8,
											Line:   176,
										},
									},
								},
								Name: "strict",
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   181,
									},
									File:   "geo.flux",
									Source: "_result",
									Start: ast.Position{
										Column: 10,
										Line:   181,
									},
								},
							},
							Name: "_result",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   181,
								},
								File:   "geo.flux",
								Source: "return _result",
								Start: ast.Position{
									Column: 3,
									Line:   181,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   161,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   161,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   161,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   161,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   161,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   161,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   161,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 26,
								Line:   161,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   161,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 26,
									Line:   161,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   161,
							},
							File:   "geo.flux",
							Source: "minSize=24",
							Start: ast.Position{
								Column: 34,
								Line:   161,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   161,
								},
								File:   "geo.flux",
								Source: "minSize",
								Start: ast.Position{
									Column: 34,
									Line:   161,
								},
							},
						},
						Name: "minSize",
					},
					Separator: nil,
					Value: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   161,
								},
								File:   "geo.flux",
								Source: "24",
								Start: ast.Position{
									Column: 42,
									Line:   161,
								},
							},
						},
						Value: int64(24),
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   161,
							},
							File:   "geo.flux",
							Source: "maxSize=-1",
							Start: ast.Position{
								Column: 46,
								Line:   161,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   161,
								},
								File:   "geo.flux",
								Source: "maxSize",
								Start: ast.Position{
									Column: 46,
									Line:   161,
								},
							},
						},
						Name: "maxSize",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   161,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 55,
										Line:   161,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   161,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 54,
									Line:   161,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   161,
							},
							File:   "geo.flux",
							Source: "level=-1",
							Start: ast.Position{
								Column: 58,
								Line:   161,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   161,
								},
								File:   "geo.flux",
								Source: "level",
								Start: ast.Position{
									Column: 58,
									Line:   161,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   161,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 65,
										Line:   161,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   161,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 64,
									Line:   161,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   161,
							},
							File:   "geo.flux",
							Source: "s2cellIDLevel=-1",
							Start: ast.Position{
								Column: 68,
								Line:   161,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   161,
								},
								File:   "geo.flux",
								Source: "s2cellIDLevel",
								Start: ast.Position{
									Column: 68,
									Line:   161,
								},
							},
						},
						Name: "s2cellIDLevel",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   161,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 83,
										Line:   161,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   161,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 82,
									Line:   161,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   161,
							},
							File:   "geo.flux",
							Source: "strict=true",
							Start: ast.Position{
								Column: 86,
								Line:   161,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   161,
								},
								File:   "geo.flux",
								Source: "strict",
								Start: ast.Position{
									Column: 86,
									Line:   161,
								},
							},
						},
						Name: "strict",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   161,
								},
								File:   "geo.flux",
								Source: "true",
								Start: ast.Position{
									Column: 93,
									Line:   161,
								},
							},
						},
						Name: "true",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   212,
					},
					File:   "geo.flux",
					Source: "groupByArea = (tables=<-, newColumn, level, s2cellIDLevel=-1) => {\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _prepared =\n    if level == _s2cellIDLevel then\n      tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n      tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })\n  return\n    _prepared\n      |> group(columns: [newColumn])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   191,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Grouping functions\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// intended to be used row-wise sets (i.e after `toRows()`)\n"}, ast.Comment{Text: "// Groups data by area of size specified by level. Result is grouped by `newColumn`.\n"}, ast.Comment{Text: "// Grouping levels: https://s2geometry.io/resources/s2cell_statistics.html\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   191,
						},
						File:   "geo.flux",
						Source: "groupByArea",
						Start: ast.Position{
							Column: 1,
							Line:   191,
						},
					},
				},
				Name: "groupByArea",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   212,
						},
						File:   "geo.flux",
						Source: "(tables=<-, newColumn, level, s2cellIDLevel=-1) => {\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _prepared =\n    if level == _s2cellIDLevel then\n      tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n      tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })\n  return\n    _prepared\n      |> group(columns: [newColumn])\n}",
						Start: ast.Position{
							Column: 15,
							Line:   191,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   212,
							},
							File:   "geo.flux",
							Source: "{\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _prepared =\n    if level == _s2cellIDLevel then\n      tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n      tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })\n  return\n    _prepared\n      |> group(columns: [newColumn])\n}",
							Start: ast.Position{
								Column: 66,
								Line:   191,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   197,
								},
								File:   "geo.flux",
								Source: "_s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel",
								Start: ast.Position{
									Column: 3,
									Line:   192,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   192,
									},
									File:   "geo.flux",
									Source: "_s2cellIDLevel",
									Start: ast.Position{
										Column: 3,
										Line:   192,
									},
								},
							},
							Name: "_s2cellIDLevel",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   197,
										},
										File:   "geo.flux",
										Source: "s2cellIDLevel",
										Start: ast.Position{
											Column: 7,
											Line:   197,
										},
									},
								},
								Name: "s2cellIDLevel",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   197,
									},
									File:   "geo.flux",
									Source: "if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel",
									Start: ast.Position{
										Column: 5,
										Line:   193,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   194,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 7,
												Line:   194,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   195,
										},
										File:   "geo.flux",
										Source: "tables\n        |> _detectLevel()",
										Start: ast.Position{
											Column: 7,
											Line:   194,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   195,
											},
											File:   "geo.flux",
											Source: "_detectLevel()",
											Start: ast.Position{
												Column: 12,
												Line:   195,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   195,
												},
												File:   "geo.flux",
												Source: "_detectLevel",
												Start: ast.Position{
													Column: 12,
													Line:   195,
												},
											},
										},
										Name: "_detectLevel",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   193,
										},
										File:   "geo.flux",
										Source: "s2cellIDLevel == -1",
										Start: ast.Position{
											Column: 8,
											Line:   193,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   193,
											},
											File:   "geo.flux",
											Source: "s2cellIDLevel",
											Start: ast.Position{
												Column: 8,
												Line:   193,
											},
										},
									},
									Name: "s2cellIDLevel",
								},
								Operator: 17,
								Right: &ast.UnaryExpression{
									Argument: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   193,
												},
												File:   "geo.flux",
												Source: "1",
												Start: ast.Position{
													Column: 26,
													Line:   193,
												},
											},
										},
										Value: int64(1),
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   193,
											},
											File:   "geo.flux",
											Source: "-1",
											Start: ast.Position{
												Column: 25,
												Line:   193,
											},
										},
									},
									Operator: 6,
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   208,
								},
								File:   "geo.flux",
								Source: "_prepared =\n    if level == _s2cellIDLevel then\n      tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n      tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })",
								Start: ast.Position{
									Column: 3,
									Line:   198,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   198,
									},
									File:   "geo.flux",
									Source: "_prepared",
									Start: ast.Position{
										Column: 3,
										Line:   198,
									},
								},
							},
							Name: "_prepared",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   203,
												},
												File:   "geo.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 7,
													Line:   203,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   207,
											},
											File:   "geo.flux",
											Source: "tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))",
											Start: ast.Position{
												Column: 7,
												Line:   203,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   207,
													},
													File:   "geo.flux",
													Source: "fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           })",
													Start: ast.Position{
														Column: 16,
														Line:   204,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   207,
														},
														File:   "geo.flux",
														Source: "fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           })",
														Start: ast.Position{
															Column: 16,
															Line:   204,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   204,
															},
															File:   "geo.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 16,
																Line:   204,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   207,
															},
															File:   "geo.flux",
															Source: "(r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           })",
															Start: ast.Position{
																Column: 20,
																Line:   204,
															},
														},
													},
													Body: &ast.ParenExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   207,
																},
																File:   "geo.flux",
																Source: "({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           })",
																Start: ast.Position{
																	Column: 27,
																	Line:   204,
																},
															},
														},
														Expression: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 13,
																		Line:   207,
																	},
																	File:   "geo.flux",
																	Source: "{\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }",
																	Start: ast.Position{
																		Column: 28,
																		Line:   204,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 93,
																			Line:   206,
																		},
																		File:   "geo.flux",
																		Source: "_s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)",
																		Start: ast.Position{
																			Column: 16,
																			Line:   206,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 31,
																				Line:   206,
																			},
																			File:   "geo.flux",
																			Source: "_s2_cell_id_xxx",
																			Start: ast.Position{
																				Column: 16,
																				Line:   206,
																			},
																		},
																	},
																	Name: "_s2_cell_id_xxx",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 92,
																					Line:   206,
																				},
																				File:   "geo.flux",
																				Source: "point: {lat: r.lat, lon: r.lon}, level: level",
																				Start: ast.Position{
																					Column: 47,
																					Line:   206,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 78,
																						Line:   206,
																					},
																					File:   "geo.flux",
																					Source: "point: {lat: r.lat, lon: r.lon}",
																					Start: ast.Position{
																						Column: 47,
																						Line:   206,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 52,
																							Line:   206,
																						},
																						File:   "geo.flux",
																						Source: "point",
																						Start: ast.Position{
																							Column: 47,
																							Line:   206,
																						},
																					},
																				},
																				Name: "point",
																			},
																			Separator: nil,
																			Value: &ast.ObjectExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 78,
																							Line:   206,
																						},
																						File:   "geo.flux",
																						Source: "{lat: r.lat, lon: r.lon}",
																						Start: ast.Position{
																							Column: 54,
																							Line:   206,
																						},
																					},
																				},
																				Lbrace: nil,
																				Properties: []*ast.Property{&ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 65,
																								Line:   206,
																							},
																							File:   "geo.flux",
																							Source: "lat: r.lat",
																							Start: ast.Position{
																								Column: 55,
																								Line:   206,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 58,
																									Line:   206,
																								},
																								File:   "geo.flux",
																								Source: "lat",
																								Start: ast.Position{
																									Column: 55,
																									Line:   206,
																								},
																							},
																						},
																						Name: "lat",
																					},
																					Separator: nil,
																					Value: &ast.MemberExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 65,
																									Line:   206,
																								},
																								File:   "geo.flux",
																								Source: "r.lat",
																								Start: ast.Position{
																									Column: 60,
																									Line:   206,
																								},
																							},
																						},
																						Lbrack: nil,
																						Object: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 61,
																										Line:   206,
																									},
																									File:   "geo.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 60,
																										Line:   206,
																									},
																								},
																							},
																							Name: "r",
																						},
																						Property: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 65,
																										Line:   206,
																									},
																									File:   "geo.flux",
																									Source: "lat",
																									Start: ast.Position{
																										Column: 62,
																										Line:   206,
																									},
																								},
																							},
																							Name: "lat",
																						},
																						Rbrack: nil,
																					},
																				}, &ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 77,
																								Line:   206,
																							},
																							File:   "geo.flux",
																							Source: "lon: r.lon",
																							Start: ast.Position{
																								Column: 67,
																								Line:   206,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 70,
																									Line:   206,
																								},
																								File:   "geo.flux",
																								Source: "lon",
																								Start: ast.Position{
																									Column: 67,
																									Line:   206,
																								},
																							},
																						},
																						Name: "lon",
																					},
																					Separator: nil,
																					Value: &ast.MemberExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 77,
																									Line:   206,
																								},
																								File:   "geo.flux",
																								Source: "r.lon",
																								Start: ast.Position{
																									Column: 72,
																									Line:   206,
																								},
																							},
																						},
																						Lbrack: nil,
																						Object: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 73,
																										Line:   206,
																									},
																									File:   "geo.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 72,
																										Line:   206,
																									},
																								},
																							},
																							Name: "r",
																						},
																						Property: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 77,
																										Line:   206,
																									},
																									File:   "geo.flux",
																									Source: "lon",
																									Start: ast.Position{
																										Column: 74,
																										Line:   206,
																									},
																								},
																							},
																							Name: "lon",
																						},
																						Rbrack: nil,
																					},
																				}},
																				Rbrace: nil,
																				With:   nil,
																			},
																		}, &ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 92,
																						Line:   206,
																					},
																					File:   "geo.flux",
																					Source: "level: level",
																					Start: ast.Position{
																						Column: 80,
																						Line:   206,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 85,
																							Line:   206,
																						},
																						File:   "geo.flux",
																						Source: "level",
																						Start: ast.Position{
																							Column: 80,
																							Line:   206,
																						},
																					},
																				},
																				Name: "level",
																			},
																			Separator: nil,
																			Value: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 92,
																							Line:   206,
																						},
																						File:   "geo.flux",
																						Source: "level",
																						Start: ast.Position{
																							Column: 87,
																							Line:   206,
																						},
																					},
																				},
																				Name: "level",
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 93,
																				Line:   206,
																			},
																			File:   "geo.flux",
																			Source: "s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)",
																			Start: ast.Position{
																				Column: 33,
																				Line:   206,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 46,
																					Line:   206,
																				},
																				File:   "geo.flux",
																				Source: "s2CellIDToken",
																				Start: ast.Position{
																					Column: 33,
																					Line:   206,
																				},
																			},
																		},
																		Name: "s2CellIDToken",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 15,
																			Line:   205,
																		},
																		File:   "geo.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 14,
																			Line:   205,
																		},
																	},
																},
																Name: "r",
															},
														},
														Lparen: nil,
														Rparen: nil,
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   204,
																},
																File:   "geo.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   204,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   204,
																	},
																	File:   "geo.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   204,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   207,
												},
												File:   "geo.flux",
												Source: "map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))",
												Start: ast.Position{
													Column: 12,
													Line:   204,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   204,
													},
													File:   "geo.flux",
													Source: "map",
													Start: ast.Position{
														Column: 12,
														Line:   204,
													},
												},
											},
											Name: "map",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   208,
										},
										File:   "geo.flux",
										Source: "tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })",
										Start: ast.Position{
											Column: 7,
											Line:   203,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   208,
												},
												File:   "geo.flux",
												Source: "columns: { _s2_cell_id_xxx: newColumn }",
												Start: ast.Position{
													Column: 19,
													Line:   208,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   208,
													},
													File:   "geo.flux",
													Source: "columns: { _s2_cell_id_xxx: newColumn }",
													Start: ast.Position{
														Column: 19,
														Line:   208,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   208,
														},
														File:   "geo.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 19,
															Line:   208,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   208,
														},
														File:   "geo.flux",
														Source: "{ _s2_cell_id_xxx: newColumn }",
														Start: ast.Position{
															Column: 28,
															Line:   208,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   208,
															},
															File:   "geo.flux",
															Source: "_s2_cell_id_xxx: newColumn",
															Start: ast.Position{
																Column: 30,
																Line:   208,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   208,
																},
																File:   "geo.flux",
																Source: "_s2_cell_id_xxx",
																Start: ast.Position{
																	Column: 30,
																	Line:   208,
																},
															},
														},
														Name: "_s2_cell_id_xxx",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   208,
																},
																File:   "geo.flux",
																Source: "newColumn",
																Start: ast.Position{
																	Column: 47,
																	Line:   208,
																},
															},
														},
														Name: "newColumn",
													},
												}},
												Rbrace: nil,
												With:   nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   208,
											},
											File:   "geo.flux",
											Source: "rename(columns: { _s2_cell_id_xxx: newColumn })",
											Start: ast.Position{
												Column: 12,
												Line:   208,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   208,
												},
												File:   "geo.flux",
												Source: "rename",
												Start: ast.Position{
													Column: 12,
													Line:   208,
												},
											},
										},
										Name: "rename",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   208,
									},
									File:   "geo.flux",
									Source: "if level == _s2cellIDLevel then\n      tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n      tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })",
									Start: ast.Position{
										Column: 5,
										Line:   199,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   200,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 7,
												Line:   200,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   201,
										},
										File:   "geo.flux",
										Source: "tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)",
										Start: ast.Position{
											Column: 7,
											Line:   200,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   201,
												},
												File:   "geo.flux",
												Source: "column: \"s2_cell_id\", as: newColumn",
												Start: ast.Position{
													Column: 19,
													Line:   201,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   201,
													},
													File:   "geo.flux",
													Source: "column: \"s2_cell_id\"",
													Start: ast.Position{
														Column: 19,
														Line:   201,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   201,
														},
														File:   "geo.flux",
														Source: "column",
														Start: ast.Position{
															Column: 19,
															Line:   201,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   201,
														},
														File:   "geo.flux",
														Source: "\"s2_cell_id\"",
														Start: ast.Position{
															Column: 27,
															Line:   201,
														},
													},
												},
												Value: "s2_cell_id",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   201,
													},
													File:   "geo.flux",
													Source: "as: newColumn",
													Start: ast.Position{
														Column: 41,
														Line:   201,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   201,
														},
														File:   "geo.flux",
														Source: "as",
														Start: ast.Position{
															Column: 41,
															Line:   201,
														},
													},
												},
												Name: "as",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   201,
														},
														File:   "geo.flux",
														Source: "newColumn",
														Start: ast.Position{
															Column: 45,
															Line:   201,
														},
													},
												},
												Name: "newColumn",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   201,
											},
											File:   "geo.flux",
											Source: "duplicate(column: \"s2_cell_id\", as: newColumn)",
											Start: ast.Position{
												Column: 9,
												Line:   201,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   201,
												},
												File:   "geo.flux",
												Source: "duplicate",
												Start: ast.Position{
													Column: 9,
													Line:   201,
												},
											},
										},
										Name: "duplicate",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   199,
										},
										File:   "geo.flux",
										Source: "level == _s2cellIDLevel",
										Start: ast.Position{
											Column: 8,
											Line:   199,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   199,
											},
											File:   "geo.flux",
											Source: "level",
											Start: ast.Position{
												Column: 8,
												Line:   199,
											},
										},
									},
									Name: "level",
								},
								Operator: 17,
								Right: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   199,
											},
											File:   "geo.flux",
											Source: "_s2cellIDLevel",
											Start: ast.Position{
												Column: 17,
												Line:   199,
											},
										},
									},
									Name: "_s2cellIDLevel",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   210,
										},
										File:   "geo.flux",
										Source: "_prepared",
										Start: ast.Position{
											Column: 5,
											Line:   210,
										},
									},
								},
								Name: "_prepared",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   211,
									},
									File:   "geo.flux",
									Source: "_prepared\n      |> group(columns: [newColumn])",
									Start: ast.Position{
										Column: 5,
										Line:   210,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   211,
											},
											File:   "geo.flux",
											Source: "columns: [newColumn]",
											Start: ast.Position{
												Column: 16,
												Line:   211,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   211,
												},
												File:   "geo.flux",
												Source: "columns: [newColumn]",
												Start: ast.Position{
													Column: 16,
													Line:   211,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   211,
													},
													File:   "geo.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 16,
														Line:   211,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   211,
													},
													File:   "geo.flux",
													Source: "[newColumn]",
													Start: ast.Position{
														Column: 25,
														Line:   211,
													},
												},
											},
											Elements: []ast.Expression{&ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   211,
														},
														File:   "geo.flux",
														Source: "newColumn",
														Start: ast.Position{
															Column: 26,
															Line:   211,
														},
													},
												},
												Name: "newColumn",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   211,
										},
										File:   "geo.flux",
										Source: "group(columns: [newColumn])",
										Start: ast.Position{
											Column: 10,
											Line:   211,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   211,
											},
											File:   "geo.flux",
											Source: "group",
											Start: ast.Position{
												Column: 10,
												Line:   211,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   211,
								},
								File:   "geo.flux",
								Source: "return\n    _prepared\n      |> group(columns: [newColumn])",
								Start: ast.Position{
									Column: 3,
									Line:   209,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   191,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 16,
								Line:   191,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   191,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 16,
									Line:   191,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   191,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   191,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   191,
							},
							File:   "geo.flux",
							Source: "newColumn",
							Start: ast.Position{
								Column: 27,
								Line:   191,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   191,
								},
								File:   "geo.flux",
								Source: "newColumn",
								Start: ast.Position{
									Column: 27,
									Line:   191,
								},
							},
						},
						Name: "newColumn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   191,
							},
							File:   "geo.flux",
							Source: "level",
							Start: ast.Position{
								Column: 38,
								Line:   191,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   191,
								},
								File:   "geo.flux",
								Source: "level",
								Start: ast.Position{
									Column: 38,
									Line:   191,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   191,
							},
							File:   "geo.flux",
							Source: "s2cellIDLevel=-1",
							Start: ast.Position{
								Column: 45,
								Line:   191,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   191,
								},
								File:   "geo.flux",
								Source: "s2cellIDLevel",
								Start: ast.Position{
									Column: 45,
									Line:   191,
								},
							},
						},
						Name: "s2cellIDLevel",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   191,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 60,
										Line:   191,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   191,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 59,
									Line:   191,
								},
							},
						},
						Operator: 6,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   218,
					},
					File:   "geo.flux",
					Source: "asTracks = (tables=<-, groupBy=[\"id\",\"tid\"], orderBy=[\"_time\"]) =>\n  tables\n    |> group(columns: groupBy)\n    |> sort(columns: orderBy)",
					Start: ast.Position{
						Column: 1,
						Line:   215,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Groups rows into tracks.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   215,
						},
						File:   "geo.flux",
						Source: "asTracks",
						Start: ast.Position{
							Column: 1,
							Line:   215,
						},
					},
				},
				Name: "asTracks",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   218,
						},
						File:   "geo.flux",
						Source: "(tables=<-, groupBy=[\"id\",\"tid\"], orderBy=[\"_time\"]) =>\n  tables\n    |> group(columns: groupBy)\n    |> sort(columns: orderBy)",
						Start: ast.Position{
							Column: 12,
							Line:   215,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   216,
									},
									File:   "geo.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 3,
										Line:   216,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   217,
								},
								File:   "geo.flux",
								Source: "tables\n    |> group(columns: groupBy)",
								Start: ast.Position{
									Column: 3,
									Line:   216,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   217,
										},
										File:   "geo.flux",
										Source: "columns: groupBy",
										Start: ast.Position{
											Column: 14,
											Line:   217,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   217,
											},
											File:   "geo.flux",
											Source: "columns: groupBy",
											Start: ast.Position{
												Column: 14,
												Line:   217,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   217,
												},
												File:   "geo.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 14,
													Line:   217,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   217,
												},
												File:   "geo.flux",
												Source: "groupBy",
												Start: ast.Position{
													Column: 23,
													Line:   217,
												},
											},
										},
										Name: "groupBy",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   217,
									},
									File:   "geo.flux",
									Source: "group(columns: groupBy)",
									Start: ast.Position{
										Column: 8,
										Line:   217,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   217,
										},
										File:   "geo.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   217,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   218,
							},
							File:   "geo.flux",
							Source: "tables\n    |> group(columns: groupBy)\n    |> sort(columns: orderBy)",
							Start: ast.Position{
								Column: 3,
								Line:   216,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   218,
									},
									File:   "geo.flux",
									Source: "columns: orderBy",
									Start: ast.Position{
										Column: 13,
										Line:   218,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   218,
										},
										File:   "geo.flux",
										Source: "columns: orderBy",
										Start: ast.Position{
											Column: 13,
											Line:   218,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   218,
											},
											File:   "geo.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   218,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   218,
											},
											File:   "geo.flux",
											Source: "orderBy",
											Start: ast.Position{
												Column: 22,
												Line:   218,
											},
										},
									},
									Name: "orderBy",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   218,
								},
								File:   "geo.flux",
								Source: "sort(columns: orderBy)",
								Start: ast.Position{
									Column: 8,
									Line:   218,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   218,
									},
									File:   "geo.flux",
									Source: "sort",
									Start: ast.Position{
										Column: 8,
										Line:   218,
									},
								},
							},
							Name: "sort",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   215,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 13,
								Line:   215,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   215,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 13,
									Line:   215,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   215,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 20,
								Line:   215,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   215,
							},
							File:   "geo.flux",
							Source: "groupBy=[\"id\",\"tid\"]",
							Start: ast.Position{
								Column: 24,
								Line:   215,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   215,
								},
								File:   "geo.flux",
								Source: "groupBy",
								Start: ast.Position{
									Column: 24,
									Line:   215,
								},
							},
						},
						Name: "groupBy",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   215,
								},
								File:   "geo.flux",
								Source: "[\"id\",\"tid\"]",
								Start: ast.Position{
									Column: 32,
									Line:   215,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   215,
									},
									File:   "geo.flux",
									Source: "\"id\"",
									Start: ast.Position{
										Column: 33,
										Line:   215,
									},
								},
							},
							Value: "id",
						}, &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   215,
									},
									File:   "geo.flux",
									Source: "\"tid\"",
									Start: ast.Position{
										Column: 38,
										Line:   215,
									},
								},
							},
							Value: "tid",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 63,
								Line:   215,
							},
							File:   "geo.flux",
							Source: "orderBy=[\"_time\"]",
							Start: ast.Position{
								Column: 46,
								Line:   215,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   215,
								},
								File:   "geo.flux",
								Source: "orderBy",
								Start: ast.Position{
									Column: 46,
									Line:   215,
								},
							},
						},
						Name: "orderBy",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   215,
								},
								File:   "geo.flux",
								Source: "[\"_time\"]",
								Start: ast.Position{
									Column: 54,
									Line:   215,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   215,
									},
									File:   "geo.flux",
									Source: "\"_time\"",
									Start: ast.Position{
										Column: 55,
										Line:   215,
									},
								},
							},
							Value: "_time",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   4,
					},
					File:   "geo.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   4,
						},
						File:   "geo.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "experimental",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   5,
					},
					File:   "geo.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   5,
						},
						File:   "geo.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "geo.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Provides functions for geographic location filtering and grouping based on S2 cells.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   2,
					},
					File:   "geo.flux",
					Source: "package geo",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   2,
						},
						File:   "geo.flux",
						Source: "geo",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "geo",
			},
		},
	}},
	Package: "geo",
	Path:    "experimental/geo",
}
