// DO NOT EDIT: This file is autogenerated via the builtin command.

package json

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 93,
					Line:   42,
				},
				File:   "json_test.flux",
				Source: "package json_test\n\n\nimport \"experimental/json\"\nimport \"testing\"\n\noption now = () =>\n\t(2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_field,_measurement,_value\n,,0,2018-05-22T19:53:26Z,json,m,\\\"{\\\"\\\"a\\\"\\\":1,\\\"\\\"b\\\"\\\":2,\\\"\\\"c\\\"\\\":3}\\\"\n,,0,2018-05-22T19:53:36Z,json,m,\\\"{\\\"\\\"a\\\"\\\":2,\\\"\\\"b\\\"\\\":4,\\\"\\\"c\\\"\\\":6}\\\"\n,,0,2018-05-22T19:53:46Z,json,m,\\\"{\\\"\\\"a\\\"\\\":3,\\\"\\\"b\\\"\\\":5,\\\"\\\"c\\\"\\\":7}\\\"\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,double,double,double\n#group,false,false,false,false,false,false\n#default,_result,,,,,\n,result,table,_time,a,b,c\n,,0,2018-05-22T19:53:26Z,1,2,3\n,,0,2018-05-22T19:53:36Z,2,4,6\n,,0,2018-05-22T19:53:46Z,3,5,7\n\"\n_json = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => {\n\t\t\tdata = json.parse(data: bytes(v: r._value))\n\t\t\treturn {\n\t\t\t\t_time: r._time,\n\t\t\t\ta: data.a,\n\t\t\t\tb: data.b,\n\t\t\t\tc: data.c,\n\t\t\t}\n\t\t}))\n\ntest parse = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: _json})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   8,
						},
						File:   "json_test.flux",
						Source: "now = () =>\n\t(2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "json_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   8,
							},
							File:   "json_test.flux",
							Source: "() =>\n\t(2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   8,
								},
								File:   "json_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 2,
									Line:   8,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   8,
									},
									File:   "json_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 3,
										Line:   8,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   8,
					},
					File:   "json_test.flux",
					Source: "option now = () =>\n\t(2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "json_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_field,_measurement,_value\n,,0,2018-05-22T19:53:26Z,json,m,\\\"{\\\"\\\"a\\\"\\\":1,\\\"\\\"b\\\"\\\":2,\\\"\\\"c\\\"\\\":3}\\\"\n,,0,2018-05-22T19:53:36Z,json,m,\\\"{\\\"\\\"a\\\"\\\":2,\\\"\\\"b\\\"\\\":4,\\\"\\\"c\\\"\\\":6}\\\"\n,,0,2018-05-22T19:53:46Z,json,m,\\\"{\\\"\\\"a\\\"\\\":3,\\\"\\\"b\\\"\\\":5,\\\"\\\"c\\\"\\\":7}\\\"\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   10,
						},
						File:   "json_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "json_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_field,_measurement,_value\n,,0,2018-05-22T19:53:26Z,json,m,\\\"{\\\"\\\"a\\\"\\\":1,\\\"\\\"b\\\"\\\":2,\\\"\\\"c\\\"\\\":3}\\\"\n,,0,2018-05-22T19:53:36Z,json,m,\\\"{\\\"\\\"a\\\"\\\":2,\\\"\\\"b\\\"\\\":4,\\\"\\\"c\\\"\\\":6}\\\"\n,,0,2018-05-22T19:53:46Z,json,m,\\\"{\\\"\\\"a\\\"\\\":3,\\\"\\\"b\\\"\\\":5,\\\"\\\"c\\\"\\\":7}\\\"\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_field,_measurement,_value\n,,0,2018-05-22T19:53:26Z,json,m,\"{\"\"a\"\":1,\"\"b\"\":2,\"\"c\"\":3}\"\n,,0,2018-05-22T19:53:36Z,json,m,\"{\"\"a\"\":2,\"\"b\"\":4,\"\"c\"\":6}\"\n,,0,2018-05-22T19:53:46Z,json,m,\"{\"\"a\"\":3,\"\"b\"\":5,\"\"c\"\":7}\"\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   27,
					},
					File:   "json_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,double,double,double\n#group,false,false,false,false,false,false\n#default,_result,,,,,\n,result,table,_time,a,b,c\n,,0,2018-05-22T19:53:26Z,1,2,3\n,,0,2018-05-22T19:53:36Z,2,4,6\n,,0,2018-05-22T19:53:46Z,3,5,7\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   19,
						},
						File:   "json_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   19,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   27,
						},
						File:   "json_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,double,double\n#group,false,false,false,false,false,false\n#default,_result,,,,,\n,result,table,_time,a,b,c\n,,0,2018-05-22T19:53:26Z,1,2,3\n,,0,2018-05-22T19:53:36Z,2,4,6\n,,0,2018-05-22T19:53:46Z,3,5,7\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   19,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,double,double\n#group,false,false,false,false,false,false\n#default,_result,,,,,\n,result,table,_time,a,b,c\n,,0,2018-05-22T19:53:26Z,1,2,3\n,,0,2018-05-22T19:53:36Z,2,4,6\n,,0,2018-05-22T19:53:46Z,3,5,7\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   39,
					},
					File:   "json_test.flux",
					Source: "_json = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => {\n\t\t\tdata = json.parse(data: bytes(v: r._value))\n\t\t\treturn {\n\t\t\t\t_time: r._time,\n\t\t\t\ta: data.a,\n\t\t\t\tb: data.b,\n\t\t\t\tc: data.c,\n\t\t\t}\n\t\t}))",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   28,
						},
						File:   "json_test.flux",
						Source: "_json",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "_json",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   39,
						},
						File:   "json_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => {\n\t\t\tdata = json.parse(data: bytes(v: r._value))\n\t\t\treturn {\n\t\t\t\t_time: r._time,\n\t\t\t\ta: data.a,\n\t\t\t\tb: data.b,\n\t\t\t\tc: data.c,\n\t\t\t}\n\t\t}))",
						Start: ast.Position{
							Column: 9,
							Line:   28,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   39,
							},
							File:   "json_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => {\n\t\t\tdata = json.parse(data: bytes(v: r._value))\n\t\t\treturn {\n\t\t\t\t_time: r._time,\n\t\t\t\ta: data.a,\n\t\t\t\tb: data.b,\n\t\t\t\tc: data.c,\n\t\t\t}\n\t\t}))",
							Start: ast.Position{
								Column: 2,
								Line:   29,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   29,
										},
										File:   "json_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   29,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   30,
									},
									File:   "json_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   29,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   30,
											},
											File:   "json_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   30,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   30,
												},
												File:   "json_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   30,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   30,
													},
													File:   "json_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   30,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   30,
													},
													File:   "json_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   30,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   30,
										},
										File:   "json_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   30,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   30,
											},
											File:   "json_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   30,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 5,
									Line:   39,
								},
								File:   "json_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => {\n\t\t\tdata = json.parse(data: bytes(v: r._value))\n\t\t\treturn {\n\t\t\t\t_time: r._time,\n\t\t\t\ta: data.a,\n\t\t\t\tb: data.b,\n\t\t\t\tc: data.c,\n\t\t\t}\n\t\t})",
								Start: ast.Position{
									Column: 3,
									Line:   29,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 4,
											Line:   39,
										},
										File:   "json_test.flux",
										Source: "fn: (r) => {\n\t\t\tdata = json.parse(data: bytes(v: r._value))\n\t\t\treturn {\n\t\t\t\t_time: r._time,\n\t\t\t\ta: data.a,\n\t\t\t\tb: data.b,\n\t\t\t\tc: data.c,\n\t\t\t}\n\t\t}",
										Start: ast.Position{
											Column: 10,
											Line:   31,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   39,
											},
											File:   "json_test.flux",
											Source: "fn: (r) => {\n\t\t\tdata = json.parse(data: bytes(v: r._value))\n\t\t\treturn {\n\t\t\t\t_time: r._time,\n\t\t\t\ta: data.a,\n\t\t\t\tb: data.b,\n\t\t\t\tc: data.c,\n\t\t\t}\n\t\t}",
											Start: ast.Position{
												Column: 10,
												Line:   31,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   31,
												},
												File:   "json_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   31,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 4,
													Line:   39,
												},
												File:   "json_test.flux",
												Source: "(r) => {\n\t\t\tdata = json.parse(data: bytes(v: r._value))\n\t\t\treturn {\n\t\t\t\t_time: r._time,\n\t\t\t\ta: data.a,\n\t\t\t\tb: data.b,\n\t\t\t\tc: data.c,\n\t\t\t}\n\t\t}",
												Start: ast.Position{
													Column: 14,
													Line:   31,
												},
											},
										},
										Body: &ast.Block{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 4,
														Line:   39,
													},
													File:   "json_test.flux",
													Source: "{\n\t\t\tdata = json.parse(data: bytes(v: r._value))\n\t\t\treturn {\n\t\t\t\t_time: r._time,\n\t\t\t\ta: data.a,\n\t\t\t\tb: data.b,\n\t\t\t\tc: data.c,\n\t\t\t}\n\t\t}",
													Start: ast.Position{
														Column: 21,
														Line:   31,
													},
												},
											},
											Body: []ast.Statement{&ast.VariableAssignment{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   32,
														},
														File:   "json_test.flux",
														Source: "data = json.parse(data: bytes(v: r._value))",
														Start: ast.Position{
															Column: 4,
															Line:   32,
														},
													},
												},
												ID: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 8,
																Line:   32,
															},
															File:   "json_test.flux",
															Source: "data",
															Start: ast.Position{
																Column: 4,
																Line:   32,
															},
														},
													},
													Name: "data",
												},
												Init: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   32,
																},
																File:   "json_test.flux",
																Source: "data: bytes(v: r._value)",
																Start: ast.Position{
																	Column: 22,
																	Line:   32,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   32,
																	},
																	File:   "json_test.flux",
																	Source: "data: bytes(v: r._value)",
																	Start: ast.Position{
																		Column: 22,
																		Line:   32,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   32,
																		},
																		File:   "json_test.flux",
																		Source: "data",
																		Start: ast.Position{
																			Column: 22,
																			Line:   32,
																		},
																	},
																},
																Name: "data",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   32,
																			},
																			File:   "json_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 34,
																				Line:   32,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 45,
																					Line:   32,
																				},
																				File:   "json_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 34,
																					Line:   32,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 35,
																						Line:   32,
																					},
																					File:   "json_test.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 34,
																						Line:   32,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 45,
																						Line:   32,
																					},
																					File:   "json_test.flux",
																					Source: "r._value",
																					Start: ast.Position{
																						Column: 37,
																						Line:   32,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 38,
																							Line:   32,
																						},
																						File:   "json_test.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 37,
																							Line:   32,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 45,
																							Line:   32,
																						},
																						File:   "json_test.flux",
																						Source: "_value",
																						Start: ast.Position{
																							Column: 39,
																							Line:   32,
																						},
																					},
																				},
																				Name: "_value",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   32,
																		},
																		File:   "json_test.flux",
																		Source: "bytes(v: r._value)",
																		Start: ast.Position{
																			Column: 28,
																			Line:   32,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   32,
																			},
																			File:   "json_test.flux",
																			Source: "bytes",
																			Start: ast.Position{
																				Column: 28,
																				Line:   32,
																			},
																		},
																	},
																	Name: "bytes",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   32,
															},
															File:   "json_test.flux",
															Source: "json.parse(data: bytes(v: r._value))",
															Start: ast.Position{
																Column: 11,
																Line:   32,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   32,
																},
																File:   "json_test.flux",
																Source: "json.parse",
																Start: ast.Position{
																	Column: 11,
																	Line:   32,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 15,
																		Line:   32,
																	},
																	File:   "json_test.flux",
																	Source: "json",
																	Start: ast.Position{
																		Column: 11,
																		Line:   32,
																	},
																},
															},
															Name: "json",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   32,
																	},
																	File:   "json_test.flux",
																	Source: "parse",
																	Start: ast.Position{
																		Column: 16,
																		Line:   32,
																	},
																},
															},
															Name: "parse",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}, &ast.ReturnStatement{
												Argument: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 5,
																Line:   38,
															},
															File:   "json_test.flux",
															Source: "{\n\t\t\t\t_time: r._time,\n\t\t\t\ta: data.a,\n\t\t\t\tb: data.b,\n\t\t\t\tc: data.c,\n\t\t\t}",
															Start: ast.Position{
																Column: 11,
																Line:   33,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   34,
																},
																File:   "json_test.flux",
																Source: "_time: r._time",
																Start: ast.Position{
																	Column: 5,
																	Line:   34,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 10,
																		Line:   34,
																	},
																	File:   "json_test.flux",
																	Source: "_time",
																	Start: ast.Position{
																		Column: 5,
																		Line:   34,
																	},
																},
															},
															Name: "_time",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 19,
																		Line:   34,
																	},
																	File:   "json_test.flux",
																	Source: "r._time",
																	Start: ast.Position{
																		Column: 12,
																		Line:   34,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 13,
																			Line:   34,
																		},
																		File:   "json_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 12,
																			Line:   34,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 19,
																			Line:   34,
																		},
																		File:   "json_test.flux",
																		Source: "_time",
																		Start: ast.Position{
																			Column: 14,
																			Line:   34,
																		},
																	},
																},
																Name: "_time",
															},
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   35,
																},
																File:   "json_test.flux",
																Source: "a: data.a",
																Start: ast.Position{
																	Column: 5,
																	Line:   35,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 6,
																		Line:   35,
																	},
																	File:   "json_test.flux",
																	Source: "a",
																	Start: ast.Position{
																		Column: 5,
																		Line:   35,
																	},
																},
															},
															Name: "a",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 14,
																		Line:   35,
																	},
																	File:   "json_test.flux",
																	Source: "data.a",
																	Start: ast.Position{
																		Column: 8,
																		Line:   35,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 12,
																			Line:   35,
																		},
																		File:   "json_test.flux",
																		Source: "data",
																		Start: ast.Position{
																			Column: 8,
																			Line:   35,
																		},
																	},
																},
																Name: "data",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 14,
																			Line:   35,
																		},
																		File:   "json_test.flux",
																		Source: "a",
																		Start: ast.Position{
																			Column: 13,
																			Line:   35,
																		},
																	},
																},
																Name: "a",
															},
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   36,
																},
																File:   "json_test.flux",
																Source: "b: data.b",
																Start: ast.Position{
																	Column: 5,
																	Line:   36,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 6,
																		Line:   36,
																	},
																	File:   "json_test.flux",
																	Source: "b",
																	Start: ast.Position{
																		Column: 5,
																		Line:   36,
																	},
																},
															},
															Name: "b",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 14,
																		Line:   36,
																	},
																	File:   "json_test.flux",
																	Source: "data.b",
																	Start: ast.Position{
																		Column: 8,
																		Line:   36,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 12,
																			Line:   36,
																		},
																		File:   "json_test.flux",
																		Source: "data",
																		Start: ast.Position{
																			Column: 8,
																			Line:   36,
																		},
																	},
																},
																Name: "data",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 14,
																			Line:   36,
																		},
																		File:   "json_test.flux",
																		Source: "b",
																		Start: ast.Position{
																			Column: 13,
																			Line:   36,
																		},
																	},
																},
																Name: "b",
															},
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   37,
																},
																File:   "json_test.flux",
																Source: "c: data.c",
																Start: ast.Position{
																	Column: 5,
																	Line:   37,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 6,
																		Line:   37,
																	},
																	File:   "json_test.flux",
																	Source: "c",
																	Start: ast.Position{
																		Column: 5,
																		Line:   37,
																	},
																},
															},
															Name: "c",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 14,
																		Line:   37,
																	},
																	File:   "json_test.flux",
																	Source: "data.c",
																	Start: ast.Position{
																		Column: 8,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 12,
																			Line:   37,
																		},
																		File:   "json_test.flux",
																		Source: "data",
																		Start: ast.Position{
																			Column: 8,
																			Line:   37,
																		},
																	},
																},
																Name: "data",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 14,
																			Line:   37,
																		},
																		File:   "json_test.flux",
																		Source: "c",
																		Start: ast.Position{
																			Column: 13,
																			Line:   37,
																		},
																	},
																},
																Name: "c",
															},
															Rbrack: nil,
														},
													}},
													Rbrace: nil,
													With:   nil,
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 5,
															Line:   38,
														},
														File:   "json_test.flux",
														Source: "return {\n\t\t\t\t_time: r._time,\n\t\t\t\ta: data.a,\n\t\t\t\tb: data.b,\n\t\t\t\tc: data.c,\n\t\t\t}",
														Start: ast.Position{
															Column: 4,
															Line:   33,
														},
													},
												},
											}},
											Lbrace: nil,
											Rbrace: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   31,
													},
													File:   "json_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   31,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   31,
														},
														File:   "json_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   31,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 5,
										Line:   39,
									},
									File:   "json_test.flux",
									Source: "map(fn: (r) => {\n\t\t\tdata = json.parse(data: bytes(v: r._value))\n\t\t\treturn {\n\t\t\t\t_time: r._time,\n\t\t\t\ta: data.a,\n\t\t\t\tb: data.b,\n\t\t\t\tc: data.c,\n\t\t\t}\n\t\t})",
									Start: ast.Position{
										Column: 6,
										Line:   31,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   31,
										},
										File:   "json_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   31,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   28,
							},
							File:   "json_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 10,
								Line:   28,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   28,
								},
								File:   "json_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 10,
									Line:   28,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   28,
							},
							File:   "json_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   28,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 93,
							Line:   42,
						},
						File:   "json_test.flux",
						Source: "parse = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: _json})",
						Start: ast.Position{
							Column: 6,
							Line:   41,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   41,
							},
							File:   "json_test.flux",
							Source: "parse",
							Start: ast.Position{
								Column: 6,
								Line:   41,
							},
						},
					},
					Name: "parse",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 93,
								Line:   42,
							},
							File:   "json_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: _json})",
							Start: ast.Position{
								Column: 14,
								Line:   41,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 93,
									Line:   42,
								},
								File:   "json_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: _json})",
								Start: ast.Position{
									Column: 2,
									Line:   42,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 92,
										Line:   42,
									},
									File:   "json_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: _json}",
									Start: ast.Position{
										Column: 3,
										Line:   42,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   42,
										},
										File:   "json_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   42,
											},
											File:   "json_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   42,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   42,
												},
												File:   "json_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   42,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   42,
													},
													File:   "json_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   42,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   42,
														},
														File:   "json_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   42,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   42,
														},
														File:   "json_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   42,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   42,
											},
											File:   "json_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   42,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   42,
												},
												File:   "json_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   42,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   42,
													},
													File:   "json_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   42,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   42,
													},
													File:   "json_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   42,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   42,
										},
										File:   "json_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   42,
											},
											File:   "json_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   42,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   42,
												},
												File:   "json_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   42,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   42,
													},
													File:   "json_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   42,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   42,
														},
														File:   "json_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   42,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   42,
														},
														File:   "json_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   42,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   42,
											},
											File:   "json_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   42,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   42,
												},
												File:   "json_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   42,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   42,
													},
													File:   "json_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   42,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   42,
													},
													File:   "json_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   42,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 91,
											Line:   42,
										},
										File:   "json_test.flux",
										Source: "fn: _json",
										Start: ast.Position{
											Column: 82,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   42,
											},
											File:   "json_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   42,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 91,
												Line:   42,
											},
											File:   "json_test.flux",
											Source: "_json",
											Start: ast.Position{
												Column: 86,
												Line:   42,
											},
										},
									},
									Name: "_json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 93,
						Line:   42,
					},
					File:   "json_test.flux",
					Source: "test parse = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: _json})",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 27,
						Line:   4,
					},
					File:   "json_test.flux",
					Source: "import \"experimental/json\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 27,
							Line:   4,
						},
						File:   "json_test.flux",
						Source: "\"experimental/json\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "experimental/json",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "json_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "json_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "json_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "json_test.flux",
					Source: "package json_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "json_test.flux",
						Source: "json_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "json_test",
			},
		},
	}},
	Package: "json_test",
	Path:    "experimental/json",
}}
