// DO NOT EDIT: This file is autogenerated via the builtin command.

package oee

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 89,
					Line:   35,
				},
				File:   "apq_test.flux",
				Source: "package oee_test\n\nimport \"experimental/oee\"\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#group,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,string,long,long\n#default,_result,,,,,\n,result,table,_time,state,partCount,badCount\n,,0,2021-03-22T00:00:00Z,running,1200,10\n,,0,2021-03-22T01:00:00Z,running,1300,11\n,,0,2021-03-22T02:00:00Z,stopped,1400,11\n,,0,2021-03-22T03:00:00Z,running,1400,11\n,,0,2021-03-22T03:30:00Z,running,1440,14\n\"\n\noutData = \"\n#group,false,false,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,double,double,double,double,long\n#default,_result,,,,,,,\n,result,table,_time,availability,oee,performance,quality,runningTime\n,,0,2021-03-22T04:00:00Z,0.375,0.24583333333333332,0.6666666666666666,0.9833333333333333,10800000000000\n\"\n\nt_APQ = (table=<-) =>\n  table\n    |> range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)\n    |> oee.APQ(runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)\n    |> drop(columns: [\"_start\", \"_stop\"])\n\ntest _APQ = () =>\n\t({input: testing.loadMem(csv: inData), want: testing.loadMem(csv: outData), fn: t_APQ})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "apq_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "apq_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "apq_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "apq_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "apq_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "apq_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "apq_test.flux",
					Source: "inData = \"\n#group,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,string,long,long\n#default,_result,,,,,\n,result,table,_time,state,partCount,badCount\n,,0,2021-03-22T00:00:00Z,running,1200,10\n,,0,2021-03-22T01:00:00Z,running,1300,11\n,,0,2021-03-22T02:00:00Z,stopped,1400,11\n,,0,2021-03-22T03:00:00Z,running,1400,11\n,,0,2021-03-22T03:30:00Z,running,1440,14\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "apq_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "apq_test.flux",
						Source: "\"\n#group,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,string,long,long\n#default,_result,,,,,\n,result,table,_time,state,partCount,badCount\n,,0,2021-03-22T00:00:00Z,running,1200,10\n,,0,2021-03-22T01:00:00Z,running,1300,11\n,,0,2021-03-22T02:00:00Z,stopped,1400,11\n,,0,2021-03-22T03:00:00Z,running,1400,11\n,,0,2021-03-22T03:30:00Z,running,1440,14\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#group,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,string,long,long\n#default,_result,,,,,\n,result,table,_time,state,partCount,badCount\n,,0,2021-03-22T00:00:00Z,running,1200,10\n,,0,2021-03-22T01:00:00Z,running,1300,11\n,,0,2021-03-22T02:00:00Z,stopped,1400,11\n,,0,2021-03-22T03:00:00Z,running,1400,11\n,,0,2021-03-22T03:30:00Z,running,1440,14\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   26,
					},
					File:   "apq_test.flux",
					Source: "outData = \"\n#group,false,false,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,double,double,double,double,long\n#default,_result,,,,,,,\n,result,table,_time,availability,oee,performance,quality,runningTime\n,,0,2021-03-22T04:00:00Z,0.375,0.24583333333333332,0.6666666666666666,0.9833333333333333,10800000000000\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   20,
						},
						File:   "apq_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   26,
						},
						File:   "apq_test.flux",
						Source: "\"\n#group,false,false,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,double,double,double,double,long\n#default,_result,,,,,,,\n,result,table,_time,availability,oee,performance,quality,runningTime\n,,0,2021-03-22T04:00:00Z,0.375,0.24583333333333332,0.6666666666666666,0.9833333333333333,10800000000000\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   20,
						},
					},
				},
				Value: "\n#group,false,false,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,double,double,double,double,long\n#default,_result,,,,,,,\n,result,table,_time,availability,oee,performance,quality,runningTime\n,,0,2021-03-22T04:00:00Z,0.375,0.24583333333333332,0.6666666666666666,0.9833333333333333,10800000000000\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   32,
					},
					File:   "apq_test.flux",
					Source: "t_APQ = (table=<-) =>\n  table\n    |> range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)\n    |> oee.APQ(runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)\n    |> drop(columns: [\"_start\", \"_stop\"])",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   28,
						},
						File:   "apq_test.flux",
						Source: "t_APQ",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "t_APQ",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   32,
						},
						File:   "apq_test.flux",
						Source: "(table=<-) =>\n  table\n    |> range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)\n    |> oee.APQ(runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)\n    |> drop(columns: [\"_start\", \"_stop\"])",
						Start: ast.Position{
							Column: 9,
							Line:   28,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   29,
										},
										File:   "apq_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   29,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   30,
									},
									File:   "apq_test.flux",
									Source: "table\n    |> range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   29,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   30,
											},
											File:   "apq_test.flux",
											Source: "start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   30,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   30,
												},
												File:   "apq_test.flux",
												Source: "start: 2021-03-22T00:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   30,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   30,
													},
													File:   "apq_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   30,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   30,
													},
													File:   "apq_test.flux",
													Source: "2021-03-22T00:00:00Z",
													Start: ast.Position{
														Column: 21,
														Line:   30,
													},
												},
											},
											Value: parser.MustParseTime("2021-03-22T00:00:00Z"),
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   30,
												},
												File:   "apq_test.flux",
												Source: "stop: 2021-03-22T04:00:00Z",
												Start: ast.Position{
													Column: 43,
													Line:   30,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   30,
													},
													File:   "apq_test.flux",
													Source: "stop",
													Start: ast.Position{
														Column: 43,
														Line:   30,
													},
												},
											},
											Name: "stop",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   30,
													},
													File:   "apq_test.flux",
													Source: "2021-03-22T04:00:00Z",
													Start: ast.Position{
														Column: 49,
														Line:   30,
													},
												},
											},
											Value: parser.MustParseTime("2021-03-22T04:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   30,
										},
										File:   "apq_test.flux",
										Source: "range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)",
										Start: ast.Position{
											Column: 8,
											Line:   30,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   30,
											},
											File:   "apq_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   30,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   31,
								},
								File:   "apq_test.flux",
								Source: "table\n    |> range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)\n    |> oee.APQ(runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)",
								Start: ast.Position{
									Column: 3,
									Line:   29,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   31,
										},
										File:   "apq_test.flux",
										Source: "runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s",
										Start: ast.Position{
											Column: 16,
											Line:   31,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   31,
											},
											File:   "apq_test.flux",
											Source: "runningState: \"running\"",
											Start: ast.Position{
												Column: 16,
												Line:   31,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   31,
												},
												File:   "apq_test.flux",
												Source: "runningState",
												Start: ast.Position{
													Column: 16,
													Line:   31,
												},
											},
										},
										Name: "runningState",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   31,
												},
												File:   "apq_test.flux",
												Source: "\"running\"",
												Start: ast.Position{
													Column: 30,
													Line:   31,
												},
											},
										},
										Value: "running",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   31,
											},
											File:   "apq_test.flux",
											Source: "plannedTime: 8h",
											Start: ast.Position{
												Column: 41,
												Line:   31,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   31,
												},
												File:   "apq_test.flux",
												Source: "plannedTime",
												Start: ast.Position{
													Column: 41,
													Line:   31,
												},
											},
										},
										Name: "plannedTime",
									},
									Separator: nil,
									Value: &ast.DurationLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   31,
												},
												File:   "apq_test.flux",
												Source: "8h",
												Start: ast.Position{
													Column: 54,
													Line:   31,
												},
											},
										},
										Values: []ast.Duration{ast.Duration{
											Magnitude: int64(8),
											Unit:      "h",
										}},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   31,
											},
											File:   "apq_test.flux",
											Source: "idealCycleTime: 30s",
											Start: ast.Position{
												Column: 58,
												Line:   31,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   31,
												},
												File:   "apq_test.flux",
												Source: "idealCycleTime",
												Start: ast.Position{
													Column: 58,
													Line:   31,
												},
											},
										},
										Name: "idealCycleTime",
									},
									Separator: nil,
									Value: &ast.DurationLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 77,
													Line:   31,
												},
												File:   "apq_test.flux",
												Source: "30s",
												Start: ast.Position{
													Column: 74,
													Line:   31,
												},
											},
										},
										Values: []ast.Duration{ast.Duration{
											Magnitude: int64(30),
											Unit:      "s",
										}},
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   31,
									},
									File:   "apq_test.flux",
									Source: "oee.APQ(runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)",
									Start: ast.Position{
										Column: 8,
										Line:   31,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   31,
										},
										File:   "apq_test.flux",
										Source: "oee.APQ",
										Start: ast.Position{
											Column: 8,
											Line:   31,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   31,
											},
											File:   "apq_test.flux",
											Source: "oee",
											Start: ast.Position{
												Column: 8,
												Line:   31,
											},
										},
									},
									Name: "oee",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   31,
											},
											File:   "apq_test.flux",
											Source: "APQ",
											Start: ast.Position{
												Column: 12,
												Line:   31,
											},
										},
									},
									Name: "APQ",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   32,
							},
							File:   "apq_test.flux",
							Source: "table\n    |> range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)\n    |> oee.APQ(runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)\n    |> drop(columns: [\"_start\", \"_stop\"])",
							Start: ast.Position{
								Column: 3,
								Line:   29,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   32,
									},
									File:   "apq_test.flux",
									Source: "columns: [\"_start\", \"_stop\"]",
									Start: ast.Position{
										Column: 13,
										Line:   32,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   32,
										},
										File:   "apq_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 13,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   32,
											},
											File:   "apq_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   32,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   32,
											},
											File:   "apq_test.flux",
											Source: "[\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 22,
												Line:   32,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   32,
												},
												File:   "apq_test.flux",
												Source: "\"_start\"",
												Start: ast.Position{
													Column: 23,
													Line:   32,
												},
											},
										},
										Value: "_start",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   32,
												},
												File:   "apq_test.flux",
												Source: "\"_stop\"",
												Start: ast.Position{
													Column: 33,
													Line:   32,
												},
											},
										},
										Value: "_stop",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   32,
								},
								File:   "apq_test.flux",
								Source: "drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 8,
									Line:   32,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   32,
									},
									File:   "apq_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   32,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   28,
							},
							File:   "apq_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 10,
								Line:   28,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   28,
								},
								File:   "apq_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 10,
									Line:   28,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   28,
							},
							File:   "apq_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   28,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 89,
							Line:   35,
						},
						File:   "apq_test.flux",
						Source: "_APQ = () =>\n\t({input: testing.loadMem(csv: inData), want: testing.loadMem(csv: outData), fn: t_APQ})",
						Start: ast.Position{
							Column: 6,
							Line:   34,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   34,
							},
							File:   "apq_test.flux",
							Source: "_APQ",
							Start: ast.Position{
								Column: 6,
								Line:   34,
							},
						},
					},
					Name: "_APQ",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   35,
							},
							File:   "apq_test.flux",
							Source: "() =>\n\t({input: testing.loadMem(csv: inData), want: testing.loadMem(csv: outData), fn: t_APQ})",
							Start: ast.Position{
								Column: 13,
								Line:   34,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   35,
								},
								File:   "apq_test.flux",
								Source: "({input: testing.loadMem(csv: inData), want: testing.loadMem(csv: outData), fn: t_APQ})",
								Start: ast.Position{
									Column: 2,
									Line:   35,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   35,
									},
									File:   "apq_test.flux",
									Source: "{input: testing.loadMem(csv: inData), want: testing.loadMem(csv: outData), fn: t_APQ}",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   35,
										},
										File:   "apq_test.flux",
										Source: "input: testing.loadMem(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   35,
											},
											File:   "apq_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   35,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   35,
												},
												File:   "apq_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 27,
													Line:   35,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   35,
													},
													File:   "apq_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 27,
														Line:   35,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   35,
														},
														File:   "apq_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   35,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   35,
														},
														File:   "apq_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   35,
											},
											File:   "apq_test.flux",
											Source: "testing.loadMem(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   35,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   35,
												},
												File:   "apq_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   35,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "apq_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   35,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   35,
													},
													File:   "apq_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   35,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 76,
											Line:   35,
										},
										File:   "apq_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 41,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   35,
											},
											File:   "apq_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 41,
												Line:   35,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 75,
													Line:   35,
												},
												File:   "apq_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 63,
													Line:   35,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 75,
														Line:   35,
													},
													File:   "apq_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 63,
														Line:   35,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   35,
														},
														File:   "apq_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 63,
															Line:   35,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 75,
															Line:   35,
														},
														File:   "apq_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 68,
															Line:   35,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   35,
											},
											File:   "apq_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 47,
												Line:   35,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   35,
												},
												File:   "apq_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 47,
													Line:   35,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   35,
													},
													File:   "apq_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 47,
														Line:   35,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   35,
													},
													File:   "apq_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 55,
														Line:   35,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 87,
											Line:   35,
										},
										File:   "apq_test.flux",
										Source: "fn: t_APQ",
										Start: ast.Position{
											Column: 78,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   35,
											},
											File:   "apq_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 78,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 87,
												Line:   35,
											},
											File:   "apq_test.flux",
											Source: "t_APQ",
											Start: ast.Position{
												Column: 82,
												Line:   35,
											},
										},
									},
									Name: "t_APQ",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 89,
						Line:   35,
					},
					File:   "apq_test.flux",
					Source: "test _APQ = () =>\n\t({input: testing.loadMem(csv: inData), want: testing.loadMem(csv: outData), fn: t_APQ})",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 26,
						Line:   3,
					},
					File:   "apq_test.flux",
					Source: "import \"experimental/oee\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   3,
						},
						File:   "apq_test.flux",
						Source: "\"experimental/oee\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "experimental/oee",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "apq_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "apq_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "apq_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   1,
					},
					File:   "apq_test.flux",
					Source: "package oee_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   1,
						},
						File:   "apq_test.flux",
						Source: "oee_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "oee_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 96,
					Line:   64,
				},
				File:   "computeapq_test.flux",
				Source: "package oee_test\n\nimport \"experimental/oee\"\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\n// not used\ninData = \"\n#group,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,string,long,long\n#default,_result,,,,,\n,result,table,_time,state,partCount,badCount\n\"\n\nproductionData = \"\n#group,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,string\n#default,_result,,,\n,result,table,_time,state\n,,0,2021-03-22T00:00:00Z,running\n,,0,2021-03-22T01:00:00Z,running\n,,0,2021-03-22T02:00:00Z,stopped\n,,0,2021-03-22T03:00:00Z,running\n\"\n\npartData = \"\n#group,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,long,long\n#default,_result,,,,\n,result,table,_time,partCount,badCount\n,,0,2021-03-22T00:00:00Z,1200,10\n,,0,2021-03-22T00:15:00Z,1225,10\n,,0,2021-03-22T00:30:00Z,1250,11\n,,0,2021-03-22T00:45:00Z,1275,11\n,,0,2021-03-22T01:00:00Z,1300,11\n,,0,2021-03-22T01:15:00Z,1310,11\n,,0,2021-03-22T01:30:00Z,1340,11\n,,0,2021-03-22T01:45:00Z,1380,11\n,,0,2021-03-22T02:00:00Z,1400,11\n,,0,2021-03-22T03:15:00Z,1425,12\n,,0,2021-03-22T03:30:00Z,1440,14\n\"\n\noutData = \"\n#group,false,false,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,double,double,double,double,long\n#default,_result,,,,,,,\n,result,table,_time,availability,oee,performance,quality,runningTime\n,,0,2021-03-22T04:00:00Z,0.375,0.24583333333333332,0.6666666666666666,0.9833333333333333,10800000000000\n\"\n\nproductionEvents = testing.loadMem(csv: productionData)\n  |> range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)\npartEvents = testing.loadMem(csv: partData)\n  |> range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)\n\nt_computeAPQ = (table=<-) => {\n  return oee.computeAPQ(productionEvents: productionEvents, partEvents: partEvents, runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)\n    |> drop(columns: [\"_start\", \"_stop\"])\n}\n\ntest _computeAPQ = () =>\n\t({input: testing.loadMem(csv: inData), want: testing.loadMem(csv: outData), fn: t_computeAPQ})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "computeapq_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "computeapq_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "computeapq_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "computeapq_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "computeapq_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "computeapq_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   14,
					},
					File:   "computeapq_test.flux",
					Source: "inData = \"\n#group,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,string,long,long\n#default,_result,,,,,\n,result,table,_time,state,partCount,badCount\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// not used\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "computeapq_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   14,
						},
						File:   "computeapq_test.flux",
						Source: "\"\n#group,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,string,long,long\n#default,_result,,,,,\n,result,table,_time,state,partCount,badCount\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#group,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,string,long,long\n#default,_result,,,,,\n,result,table,_time,state,partCount,badCount\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   25,
					},
					File:   "computeapq_test.flux",
					Source: "productionData = \"\n#group,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,string\n#default,_result,,,\n,result,table,_time,state\n,,0,2021-03-22T00:00:00Z,running\n,,0,2021-03-22T01:00:00Z,running\n,,0,2021-03-22T02:00:00Z,stopped\n,,0,2021-03-22T03:00:00Z,running\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   16,
						},
						File:   "computeapq_test.flux",
						Source: "productionData",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "productionData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   25,
						},
						File:   "computeapq_test.flux",
						Source: "\"\n#group,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,string\n#default,_result,,,\n,result,table,_time,state\n,,0,2021-03-22T00:00:00Z,running\n,,0,2021-03-22T01:00:00Z,running\n,,0,2021-03-22T02:00:00Z,stopped\n,,0,2021-03-22T03:00:00Z,running\n\"",
						Start: ast.Position{
							Column: 18,
							Line:   16,
						},
					},
				},
				Value: "\n#group,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,string\n#default,_result,,,\n,result,table,_time,state\n,,0,2021-03-22T00:00:00Z,running\n,,0,2021-03-22T01:00:00Z,running\n,,0,2021-03-22T02:00:00Z,stopped\n,,0,2021-03-22T03:00:00Z,running\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   43,
					},
					File:   "computeapq_test.flux",
					Source: "partData = \"\n#group,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,long,long\n#default,_result,,,,\n,result,table,_time,partCount,badCount\n,,0,2021-03-22T00:00:00Z,1200,10\n,,0,2021-03-22T00:15:00Z,1225,10\n,,0,2021-03-22T00:30:00Z,1250,11\n,,0,2021-03-22T00:45:00Z,1275,11\n,,0,2021-03-22T01:00:00Z,1300,11\n,,0,2021-03-22T01:15:00Z,1310,11\n,,0,2021-03-22T01:30:00Z,1340,11\n,,0,2021-03-22T01:45:00Z,1380,11\n,,0,2021-03-22T02:00:00Z,1400,11\n,,0,2021-03-22T03:15:00Z,1425,12\n,,0,2021-03-22T03:30:00Z,1440,14\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   27,
						},
						File:   "computeapq_test.flux",
						Source: "partData",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "partData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   43,
						},
						File:   "computeapq_test.flux",
						Source: "\"\n#group,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,long,long\n#default,_result,,,,\n,result,table,_time,partCount,badCount\n,,0,2021-03-22T00:00:00Z,1200,10\n,,0,2021-03-22T00:15:00Z,1225,10\n,,0,2021-03-22T00:30:00Z,1250,11\n,,0,2021-03-22T00:45:00Z,1275,11\n,,0,2021-03-22T01:00:00Z,1300,11\n,,0,2021-03-22T01:15:00Z,1310,11\n,,0,2021-03-22T01:30:00Z,1340,11\n,,0,2021-03-22T01:45:00Z,1380,11\n,,0,2021-03-22T02:00:00Z,1400,11\n,,0,2021-03-22T03:15:00Z,1425,12\n,,0,2021-03-22T03:30:00Z,1440,14\n\"",
						Start: ast.Position{
							Column: 12,
							Line:   27,
						},
					},
				},
				Value: "\n#group,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,long,long\n#default,_result,,,,\n,result,table,_time,partCount,badCount\n,,0,2021-03-22T00:00:00Z,1200,10\n,,0,2021-03-22T00:15:00Z,1225,10\n,,0,2021-03-22T00:30:00Z,1250,11\n,,0,2021-03-22T00:45:00Z,1275,11\n,,0,2021-03-22T01:00:00Z,1300,11\n,,0,2021-03-22T01:15:00Z,1310,11\n,,0,2021-03-22T01:30:00Z,1340,11\n,,0,2021-03-22T01:45:00Z,1380,11\n,,0,2021-03-22T02:00:00Z,1400,11\n,,0,2021-03-22T03:15:00Z,1425,12\n,,0,2021-03-22T03:30:00Z,1440,14\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   51,
					},
					File:   "computeapq_test.flux",
					Source: "outData = \"\n#group,false,false,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,double,double,double,double,long\n#default,_result,,,,,,,\n,result,table,_time,availability,oee,performance,quality,runningTime\n,,0,2021-03-22T04:00:00Z,0.375,0.24583333333333332,0.6666666666666666,0.9833333333333333,10800000000000\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   45,
						},
						File:   "computeapq_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   45,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   51,
						},
						File:   "computeapq_test.flux",
						Source: "\"\n#group,false,false,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,double,double,double,double,long\n#default,_result,,,,,,,\n,result,table,_time,availability,oee,performance,quality,runningTime\n,,0,2021-03-22T04:00:00Z,0.375,0.24583333333333332,0.6666666666666666,0.9833333333333333,10800000000000\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   45,
						},
					},
				},
				Value: "\n#group,false,false,false,false,false,false,false,false\n#datatype,string,long,dateTime:RFC3339,double,double,double,double,long\n#default,_result,,,,,,,\n,result,table,_time,availability,oee,performance,quality,runningTime\n,,0,2021-03-22T04:00:00Z,0.375,0.24583333333333332,0.6666666666666666,0.9833333333333333,10800000000000\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 68,
						Line:   54,
					},
					File:   "computeapq_test.flux",
					Source: "productionEvents = testing.loadMem(csv: productionData)\n  |> range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   53,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   53,
						},
						File:   "computeapq_test.flux",
						Source: "productionEvents",
						Start: ast.Position{
							Column: 1,
							Line:   53,
						},
					},
				},
				Name: "productionEvents",
			},
			Init: &ast.PipeExpression{
				Argument: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   53,
								},
								File:   "computeapq_test.flux",
								Source: "csv: productionData",
								Start: ast.Position{
									Column: 36,
									Line:   53,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   53,
									},
									File:   "computeapq_test.flux",
									Source: "csv: productionData",
									Start: ast.Position{
										Column: 36,
										Line:   53,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   53,
										},
										File:   "computeapq_test.flux",
										Source: "csv",
										Start: ast.Position{
											Column: 36,
											Line:   53,
										},
									},
								},
								Name: "csv",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   53,
										},
										File:   "computeapq_test.flux",
										Source: "productionData",
										Start: ast.Position{
											Column: 41,
											Line:   53,
										},
									},
								},
								Name: "productionData",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   53,
							},
							File:   "computeapq_test.flux",
							Source: "testing.loadMem(csv: productionData)",
							Start: ast.Position{
								Column: 20,
								Line:   53,
							},
						},
					},
					Callee: &ast.MemberExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   53,
								},
								File:   "computeapq_test.flux",
								Source: "testing.loadMem",
								Start: ast.Position{
									Column: 20,
									Line:   53,
								},
							},
						},
						Lbrack: nil,
						Object: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   53,
									},
									File:   "computeapq_test.flux",
									Source: "testing",
									Start: ast.Position{
										Column: 20,
										Line:   53,
									},
								},
							},
							Name: "testing",
						},
						Property: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   53,
									},
									File:   "computeapq_test.flux",
									Source: "loadMem",
									Start: ast.Position{
										Column: 28,
										Line:   53,
									},
								},
							},
							Name: "loadMem",
						},
						Rbrack: nil,
					},
					Lparen: nil,
					Rparen: nil,
				},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   54,
						},
						File:   "computeapq_test.flux",
						Source: "testing.loadMem(csv: productionData)\n  |> range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)",
						Start: ast.Position{
							Column: 20,
							Line:   53,
						},
					},
				},
				Call: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   54,
								},
								File:   "computeapq_test.flux",
								Source: "start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z",
								Start: ast.Position{
									Column: 12,
									Line:   54,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   54,
									},
									File:   "computeapq_test.flux",
									Source: "start: 2021-03-22T00:00:00Z",
									Start: ast.Position{
										Column: 12,
										Line:   54,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   54,
										},
										File:   "computeapq_test.flux",
										Source: "start",
										Start: ast.Position{
											Column: 12,
											Line:   54,
										},
									},
								},
								Name: "start",
							},
							Separator: nil,
							Value: &ast.DateTimeLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   54,
										},
										File:   "computeapq_test.flux",
										Source: "2021-03-22T00:00:00Z",
										Start: ast.Position{
											Column: 19,
											Line:   54,
										},
									},
								},
								Value: parser.MustParseTime("2021-03-22T00:00:00Z"),
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   54,
									},
									File:   "computeapq_test.flux",
									Source: "stop: 2021-03-22T04:00:00Z",
									Start: ast.Position{
										Column: 41,
										Line:   54,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   54,
										},
										File:   "computeapq_test.flux",
										Source: "stop",
										Start: ast.Position{
											Column: 41,
											Line:   54,
										},
									},
								},
								Name: "stop",
							},
							Separator: nil,
							Value: &ast.DateTimeLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   54,
										},
										File:   "computeapq_test.flux",
										Source: "2021-03-22T04:00:00Z",
										Start: ast.Position{
											Column: 47,
											Line:   54,
										},
									},
								},
								Value: parser.MustParseTime("2021-03-22T04:00:00Z"),
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   54,
							},
							File:   "computeapq_test.flux",
							Source: "range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)",
							Start: ast.Position{
								Column: 6,
								Line:   54,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   54,
								},
								File:   "computeapq_test.flux",
								Source: "range",
								Start: ast.Position{
									Column: 6,
									Line:   54,
								},
							},
						},
						Name: "range",
					},
					Lparen: nil,
					Rparen: nil,
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 68,
						Line:   56,
					},
					File:   "computeapq_test.flux",
					Source: "partEvents = testing.loadMem(csv: partData)\n  |> range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   55,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   55,
						},
						File:   "computeapq_test.flux",
						Source: "partEvents",
						Start: ast.Position{
							Column: 1,
							Line:   55,
						},
					},
				},
				Name: "partEvents",
			},
			Init: &ast.PipeExpression{
				Argument: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   55,
								},
								File:   "computeapq_test.flux",
								Source: "csv: partData",
								Start: ast.Position{
									Column: 30,
									Line:   55,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   55,
									},
									File:   "computeapq_test.flux",
									Source: "csv: partData",
									Start: ast.Position{
										Column: 30,
										Line:   55,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   55,
										},
										File:   "computeapq_test.flux",
										Source: "csv",
										Start: ast.Position{
											Column: 30,
											Line:   55,
										},
									},
								},
								Name: "csv",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   55,
										},
										File:   "computeapq_test.flux",
										Source: "partData",
										Start: ast.Position{
											Column: 35,
											Line:   55,
										},
									},
								},
								Name: "partData",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   55,
							},
							File:   "computeapq_test.flux",
							Source: "testing.loadMem(csv: partData)",
							Start: ast.Position{
								Column: 14,
								Line:   55,
							},
						},
					},
					Callee: &ast.MemberExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   55,
								},
								File:   "computeapq_test.flux",
								Source: "testing.loadMem",
								Start: ast.Position{
									Column: 14,
									Line:   55,
								},
							},
						},
						Lbrack: nil,
						Object: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   55,
									},
									File:   "computeapq_test.flux",
									Source: "testing",
									Start: ast.Position{
										Column: 14,
										Line:   55,
									},
								},
							},
							Name: "testing",
						},
						Property: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   55,
									},
									File:   "computeapq_test.flux",
									Source: "loadMem",
									Start: ast.Position{
										Column: 22,
										Line:   55,
									},
								},
							},
							Name: "loadMem",
						},
						Rbrack: nil,
					},
					Lparen: nil,
					Rparen: nil,
				},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   56,
						},
						File:   "computeapq_test.flux",
						Source: "testing.loadMem(csv: partData)\n  |> range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)",
						Start: ast.Position{
							Column: 14,
							Line:   55,
						},
					},
				},
				Call: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   56,
								},
								File:   "computeapq_test.flux",
								Source: "start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z",
								Start: ast.Position{
									Column: 12,
									Line:   56,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   56,
									},
									File:   "computeapq_test.flux",
									Source: "start: 2021-03-22T00:00:00Z",
									Start: ast.Position{
										Column: 12,
										Line:   56,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   56,
										},
										File:   "computeapq_test.flux",
										Source: "start",
										Start: ast.Position{
											Column: 12,
											Line:   56,
										},
									},
								},
								Name: "start",
							},
							Separator: nil,
							Value: &ast.DateTimeLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   56,
										},
										File:   "computeapq_test.flux",
										Source: "2021-03-22T00:00:00Z",
										Start: ast.Position{
											Column: 19,
											Line:   56,
										},
									},
								},
								Value: parser.MustParseTime("2021-03-22T00:00:00Z"),
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   56,
									},
									File:   "computeapq_test.flux",
									Source: "stop: 2021-03-22T04:00:00Z",
									Start: ast.Position{
										Column: 41,
										Line:   56,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   56,
										},
										File:   "computeapq_test.flux",
										Source: "stop",
										Start: ast.Position{
											Column: 41,
											Line:   56,
										},
									},
								},
								Name: "stop",
							},
							Separator: nil,
							Value: &ast.DateTimeLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   56,
										},
										File:   "computeapq_test.flux",
										Source: "2021-03-22T04:00:00Z",
										Start: ast.Position{
											Column: 47,
											Line:   56,
										},
									},
								},
								Value: parser.MustParseTime("2021-03-22T04:00:00Z"),
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   56,
							},
							File:   "computeapq_test.flux",
							Source: "range(start: 2021-03-22T00:00:00Z, stop: 2021-03-22T04:00:00Z)",
							Start: ast.Position{
								Column: 6,
								Line:   56,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   56,
								},
								File:   "computeapq_test.flux",
								Source: "range",
								Start: ast.Position{
									Column: 6,
									Line:   56,
								},
							},
						},
						Name: "range",
					},
					Lparen: nil,
					Rparen: nil,
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   61,
					},
					File:   "computeapq_test.flux",
					Source: "t_computeAPQ = (table=<-) => {\n  return oee.computeAPQ(productionEvents: productionEvents, partEvents: partEvents, runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)\n    |> drop(columns: [\"_start\", \"_stop\"])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   58,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   58,
						},
						File:   "computeapq_test.flux",
						Source: "t_computeAPQ",
						Start: ast.Position{
							Column: 1,
							Line:   58,
						},
					},
				},
				Name: "t_computeAPQ",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   61,
						},
						File:   "computeapq_test.flux",
						Source: "(table=<-) => {\n  return oee.computeAPQ(productionEvents: productionEvents, partEvents: partEvents, runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)\n    |> drop(columns: [\"_start\", \"_stop\"])\n}",
						Start: ast.Position{
							Column: 16,
							Line:   58,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   61,
							},
							File:   "computeapq_test.flux",
							Source: "{\n  return oee.computeAPQ(productionEvents: productionEvents, partEvents: partEvents, runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)\n    |> drop(columns: [\"_start\", \"_stop\"])\n}",
							Start: ast.Position{
								Column: 30,
								Line:   58,
							},
						},
					},
					Body: []ast.Statement{&ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 146,
												Line:   59,
											},
											File:   "computeapq_test.flux",
											Source: "productionEvents: productionEvents, partEvents: partEvents, runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s",
											Start: ast.Position{
												Column: 25,
												Line:   59,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   59,
												},
												File:   "computeapq_test.flux",
												Source: "productionEvents: productionEvents",
												Start: ast.Position{
													Column: 25,
													Line:   59,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   59,
													},
													File:   "computeapq_test.flux",
													Source: "productionEvents",
													Start: ast.Position{
														Column: 25,
														Line:   59,
													},
												},
											},
											Name: "productionEvents",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   59,
													},
													File:   "computeapq_test.flux",
													Source: "productionEvents",
													Start: ast.Position{
														Column: 43,
														Line:   59,
													},
												},
											},
											Name: "productionEvents",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 83,
													Line:   59,
												},
												File:   "computeapq_test.flux",
												Source: "partEvents: partEvents",
												Start: ast.Position{
													Column: 61,
													Line:   59,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   59,
													},
													File:   "computeapq_test.flux",
													Source: "partEvents",
													Start: ast.Position{
														Column: 61,
														Line:   59,
													},
												},
											},
											Name: "partEvents",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 83,
														Line:   59,
													},
													File:   "computeapq_test.flux",
													Source: "partEvents",
													Start: ast.Position{
														Column: 73,
														Line:   59,
													},
												},
											},
											Name: "partEvents",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 108,
													Line:   59,
												},
												File:   "computeapq_test.flux",
												Source: "runningState: \"running\"",
												Start: ast.Position{
													Column: 85,
													Line:   59,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 97,
														Line:   59,
													},
													File:   "computeapq_test.flux",
													Source: "runningState",
													Start: ast.Position{
														Column: 85,
														Line:   59,
													},
												},
											},
											Name: "runningState",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   59,
													},
													File:   "computeapq_test.flux",
													Source: "\"running\"",
													Start: ast.Position{
														Column: 99,
														Line:   59,
													},
												},
											},
											Value: "running",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 125,
													Line:   59,
												},
												File:   "computeapq_test.flux",
												Source: "plannedTime: 8h",
												Start: ast.Position{
													Column: 110,
													Line:   59,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 121,
														Line:   59,
													},
													File:   "computeapq_test.flux",
													Source: "plannedTime",
													Start: ast.Position{
														Column: 110,
														Line:   59,
													},
												},
											},
											Name: "plannedTime",
										},
										Separator: nil,
										Value: &ast.DurationLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 125,
														Line:   59,
													},
													File:   "computeapq_test.flux",
													Source: "8h",
													Start: ast.Position{
														Column: 123,
														Line:   59,
													},
												},
											},
											Values: []ast.Duration{ast.Duration{
												Magnitude: int64(8),
												Unit:      "h",
											}},
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 146,
													Line:   59,
												},
												File:   "computeapq_test.flux",
												Source: "idealCycleTime: 30s",
												Start: ast.Position{
													Column: 127,
													Line:   59,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 141,
														Line:   59,
													},
													File:   "computeapq_test.flux",
													Source: "idealCycleTime",
													Start: ast.Position{
														Column: 127,
														Line:   59,
													},
												},
											},
											Name: "idealCycleTime",
										},
										Separator: nil,
										Value: &ast.DurationLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 146,
														Line:   59,
													},
													File:   "computeapq_test.flux",
													Source: "30s",
													Start: ast.Position{
														Column: 143,
														Line:   59,
													},
												},
											},
											Values: []ast.Duration{ast.Duration{
												Magnitude: int64(30),
												Unit:      "s",
											}},
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 147,
											Line:   59,
										},
										File:   "computeapq_test.flux",
										Source: "oee.computeAPQ(productionEvents: productionEvents, partEvents: partEvents, runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)",
										Start: ast.Position{
											Column: 10,
											Line:   59,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   59,
											},
											File:   "computeapq_test.flux",
											Source: "oee.computeAPQ",
											Start: ast.Position{
												Column: 10,
												Line:   59,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   59,
												},
												File:   "computeapq_test.flux",
												Source: "oee",
												Start: ast.Position{
													Column: 10,
													Line:   59,
												},
											},
										},
										Name: "oee",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   59,
												},
												File:   "computeapq_test.flux",
												Source: "computeAPQ",
												Start: ast.Position{
													Column: 14,
													Line:   59,
												},
											},
										},
										Name: "computeAPQ",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   60,
									},
									File:   "computeapq_test.flux",
									Source: "oee.computeAPQ(productionEvents: productionEvents, partEvents: partEvents, runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)\n    |> drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 10,
										Line:   59,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   60,
											},
											File:   "computeapq_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 13,
												Line:   60,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   60,
												},
												File:   "computeapq_test.flux",
												Source: "columns: [\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 13,
													Line:   60,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   60,
													},
													File:   "computeapq_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 13,
														Line:   60,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   60,
													},
													File:   "computeapq_test.flux",
													Source: "[\"_start\", \"_stop\"]",
													Start: ast.Position{
														Column: 22,
														Line:   60,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   60,
														},
														File:   "computeapq_test.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 23,
															Line:   60,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   60,
														},
														File:   "computeapq_test.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 33,
															Line:   60,
														},
													},
												},
												Value: "_stop",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   60,
										},
										File:   "computeapq_test.flux",
										Source: "drop(columns: [\"_start\", \"_stop\"])",
										Start: ast.Position{
											Column: 8,
											Line:   60,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   60,
											},
											File:   "computeapq_test.flux",
											Source: "drop",
											Start: ast.Position{
												Column: 8,
												Line:   60,
											},
										},
									},
									Name: "drop",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   60,
								},
								File:   "computeapq_test.flux",
								Source: "return oee.computeAPQ(productionEvents: productionEvents, partEvents: partEvents, runningState: \"running\", plannedTime: 8h, idealCycleTime: 30s)\n    |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 3,
									Line:   59,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   58,
							},
							File:   "computeapq_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 17,
								Line:   58,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   58,
								},
								File:   "computeapq_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 17,
									Line:   58,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   58,
							},
							File:   "computeapq_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   58,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 96,
							Line:   64,
						},
						File:   "computeapq_test.flux",
						Source: "_computeAPQ = () =>\n\t({input: testing.loadMem(csv: inData), want: testing.loadMem(csv: outData), fn: t_computeAPQ})",
						Start: ast.Position{
							Column: 6,
							Line:   63,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   63,
							},
							File:   "computeapq_test.flux",
							Source: "_computeAPQ",
							Start: ast.Position{
								Column: 6,
								Line:   63,
							},
						},
					},
					Name: "_computeAPQ",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 96,
								Line:   64,
							},
							File:   "computeapq_test.flux",
							Source: "() =>\n\t({input: testing.loadMem(csv: inData), want: testing.loadMem(csv: outData), fn: t_computeAPQ})",
							Start: ast.Position{
								Column: 20,
								Line:   63,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 96,
									Line:   64,
								},
								File:   "computeapq_test.flux",
								Source: "({input: testing.loadMem(csv: inData), want: testing.loadMem(csv: outData), fn: t_computeAPQ})",
								Start: ast.Position{
									Column: 2,
									Line:   64,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 95,
										Line:   64,
									},
									File:   "computeapq_test.flux",
									Source: "{input: testing.loadMem(csv: inData), want: testing.loadMem(csv: outData), fn: t_computeAPQ}",
									Start: ast.Position{
										Column: 3,
										Line:   64,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   64,
										},
										File:   "computeapq_test.flux",
										Source: "input: testing.loadMem(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   64,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   64,
											},
											File:   "computeapq_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   64,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   64,
												},
												File:   "computeapq_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 27,
													Line:   64,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   64,
													},
													File:   "computeapq_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 27,
														Line:   64,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   64,
														},
														File:   "computeapq_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   64,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   64,
														},
														File:   "computeapq_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 32,
															Line:   64,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   64,
											},
											File:   "computeapq_test.flux",
											Source: "testing.loadMem(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   64,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   64,
												},
												File:   "computeapq_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   64,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   64,
													},
													File:   "computeapq_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   64,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   64,
													},
													File:   "computeapq_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   64,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 76,
											Line:   64,
										},
										File:   "computeapq_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 41,
											Line:   64,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   64,
											},
											File:   "computeapq_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 41,
												Line:   64,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 75,
													Line:   64,
												},
												File:   "computeapq_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 63,
													Line:   64,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 75,
														Line:   64,
													},
													File:   "computeapq_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 63,
														Line:   64,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   64,
														},
														File:   "computeapq_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 63,
															Line:   64,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 75,
															Line:   64,
														},
														File:   "computeapq_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 68,
															Line:   64,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   64,
											},
											File:   "computeapq_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 47,
												Line:   64,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   64,
												},
												File:   "computeapq_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 47,
													Line:   64,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   64,
													},
													File:   "computeapq_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 47,
														Line:   64,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   64,
													},
													File:   "computeapq_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 55,
														Line:   64,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 94,
											Line:   64,
										},
										File:   "computeapq_test.flux",
										Source: "fn: t_computeAPQ",
										Start: ast.Position{
											Column: 78,
											Line:   64,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   64,
											},
											File:   "computeapq_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 78,
												Line:   64,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 94,
												Line:   64,
											},
											File:   "computeapq_test.flux",
											Source: "t_computeAPQ",
											Start: ast.Position{
												Column: 82,
												Line:   64,
											},
										},
									},
									Name: "t_computeAPQ",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 96,
						Line:   64,
					},
					File:   "computeapq_test.flux",
					Source: "test _computeAPQ = () =>\n\t({input: testing.loadMem(csv: inData), want: testing.loadMem(csv: outData), fn: t_computeAPQ})",
					Start: ast.Position{
						Column: 1,
						Line:   63,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 26,
						Line:   3,
					},
					File:   "computeapq_test.flux",
					Source: "import \"experimental/oee\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   3,
						},
						File:   "computeapq_test.flux",
						Source: "\"experimental/oee\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "experimental/oee",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "computeapq_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "computeapq_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "computeapq_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   1,
					},
					File:   "computeapq_test.flux",
					Source: "package oee_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   1,
						},
						File:   "computeapq_test.flux",
						Source: "oee_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "oee_test",
			},
		},
	}},
	Package: "oee_test",
	Path:    "experimental/oee",
}}
