// DO NOT EDIT: This file is autogenerated via the builtin command.

package pagerduty

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 15,
					Line:   105,
				},
				File:   "pagerduty.flux",
				Source: "package pagerduty\n\nimport \"http\"\nimport \"json\"\nimport \"strings\"\n\n// `dedupKey` - adds a newline concatinated value of the sorted group key that is then sha256-hashed and hex-encoded to a column with the key `_pagerdutyDedupKey`.\nbuiltin dedupKey : (<-tables: [A]) => [{A with _pagerdutyDedupKey: string }]\n\noption defaultURL = \"https://events.pagerduty.com/v2/enqueue\"\n\n\n// severity levels on status objects can be one of the following: ok,info,warn,crit,unknown\n// but pagerduty only accepts critical, error, warning or info.\n// severityFromLevel turns a level from the status object into a pagerduty severity\nseverityFromLevel = (level) => {\n    lvl = strings.toLower(v:level)\n    sev = if lvl == \"warn\" then \"warning\" \n        else if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"\n    return sev\n}\n\n// `actionFromLevel` converts a monitoring level to an action; \"ok\" becomes \"resolve\" everything else converts to \"trigger\".\nactionFromLevel = (level)=> if strings.toLower(v:level) == \"ok\" then \"resolve\" else \"trigger\"\n\n// `sendEvent` sends an event to PagerDuty, the description of some of these parameters taken from the pagerduty documentation at https://v2.developer.pagerduty.com/docs/send-an-event-events-api-v2\n// `pagerdutyURL` - sring - URL of the pagerduty endpoint.  Defaults to: `option defaultURL = \"https://events.pagerduty.com/v2/enqueue\"`\n// `routingKey` - string - routingKey.\n// `client` - string - name of the client sending the alert.\n// `clientURL` - string - url of the client sending the alert.\n// `dedupkey` - string - a per alert ID. It acts as deduplication key, that allows you to ack or change the severity of previous messages. Supports a maximum of 255 characters.\n// `class` - string - The class/type of the event, for example ping failure or cpu load.\n// `group` - string - Logical grouping of components of a service, for example app-stack.\n// `severity` - string - The perceived severity of the status the event is describing with respect to the affected system. This can be critical, error, warning or info.\n// `eventAction` - string - The type of event to send to PagerDuty (ex. trigger, resolve, acknowledge)\n// `source` - string - The unique location of the affected system, preferably a hostname or FQDN.\n// `summary` - string - A brief text summary of the event, used to generate the summaries/titles of any associated alerts. The maximum permitted length of this property is 1024 characters.\n// `timestamp` - string - The time at which the emitting tool detected or generated the event, in RFC 3339 nano format.\nsendEvent = (pagerdutyURL=defaultURL,\n    routingKey,\n    client,\n    clientURL,\n    dedupKey,\n    class,\n    group,\n    severity,\n    eventAction,\n    source,\n    summary,\n    timestamp) => {\n\n    payload = {\n            summary: summary,\n            timestamp: timestamp,\n            source: source,\n            severity: severity,\n            group: group,\n            class: class,\n    }\n    data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }\n\n    headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n    return http.post(headers: headers, url: pagerdutyURL, data: enc)\n}\n\n// `endpoint` creates the endpoint for the PagerDuty external service.\n// `url` - string - URL of the Pagerduty endpoint. Defaults to: \"https://events.pagerduty.com/v2/enqueue\".\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` parameter must be a function that returns an object with `routingKey`, `client`, `client_url`, `class`, `group`, `severity`, `eventAction`, `source`, `summary`, and `timestamp` as defined in the sendEvent function.\n// Note that while sendEvent accepts a dedup key, endpoint gets the dedupkey from the groupkey of the input table instead of it being handled by the `mapFn`.\nendpoint = (url=defaultURL) =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> dedupKey()\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// `dedupKey` - adds a newline concatinated value of the sorted group key that is then sha256-hashed and hex-encoded to a column with the key `_pagerdutyDedupKey`.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   8,
					},
					File:   "pagerduty.flux",
					Source: "builtin dedupKey",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   8,
						},
						File:   "pagerduty.flux",
						Source: "dedupKey",
						Start: ast.Position{
							Column: 9,
							Line:   8,
						},
					},
				},
				Name: "dedupKey",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 77,
							Line:   8,
						},
						File:   "pagerduty.flux",
						Source: "(<-tables: [A]) => [{A with _pagerdutyDedupKey: string }]",
						Start: ast.Position{
							Column: 20,
							Line:   8,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 77,
								Line:   8,
							},
							File:   "pagerduty.flux",
							Source: "(<-tables: [A]) => [{A with _pagerdutyDedupKey: string }]",
							Start: ast.Position{
								Column: 20,
								Line:   8,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   8,
								},
								File:   "pagerduty.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 21,
									Line:   8,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   8,
									},
									File:   "pagerduty.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   8,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   8,
									},
									File:   "pagerduty.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 31,
										Line:   8,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   8,
										},
										File:   "pagerduty.flux",
										Source: "A",
										Start: ast.Position{
											Column: 32,
											Line:   8,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   8,
											},
											File:   "pagerduty.flux",
											Source: "A",
											Start: ast.Position{
												Column: 32,
												Line:   8,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   8,
								},
								File:   "pagerduty.flux",
								Source: "[{A with _pagerdutyDedupKey: string }]",
								Start: ast.Position{
									Column: 39,
									Line:   8,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 76,
										Line:   8,
									},
									File:   "pagerduty.flux",
									Source: "{A with _pagerdutyDedupKey: string }",
									Start: ast.Position{
										Column: 40,
										Line:   8,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   8,
										},
										File:   "pagerduty.flux",
										Source: "_pagerdutyDedupKey: string",
										Start: ast.Position{
											Column: 48,
											Line:   8,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   8,
											},
											File:   "pagerduty.flux",
											Source: "_pagerdutyDedupKey",
											Start: ast.Position{
												Column: 48,
												Line:   8,
											},
										},
									},
									Name: "_pagerdutyDedupKey",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   8,
											},
											File:   "pagerduty.flux",
											Source: "string",
											Start: ast.Position{
												Column: 68,
												Line:   8,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   8,
												},
												File:   "pagerduty.flux",
												Source: "string",
												Start: ast.Position{
													Column: 68,
													Line:   8,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   8,
										},
										File:   "pagerduty.flux",
										Source: "A",
										Start: ast.Position{
											Column: 41,
											Line:   8,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 62,
							Line:   10,
						},
						File:   "pagerduty.flux",
						Source: "defaultURL = \"https://events.pagerduty.com/v2/enqueue\"",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   10,
							},
							File:   "pagerduty.flux",
							Source: "defaultURL",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Name: "defaultURL",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 62,
								Line:   10,
							},
							File:   "pagerduty.flux",
							Source: "\"https://events.pagerduty.com/v2/enqueue\"",
							Start: ast.Position{
								Column: 21,
								Line:   10,
							},
						},
					},
					Value: "https://events.pagerduty.com/v2/enqueue",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 62,
						Line:   10,
					},
					File:   "pagerduty.flux",
					Source: "option defaultURL = \"https://events.pagerduty.com/v2/enqueue\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "pagerduty.flux",
					Source: "severityFromLevel = (level) => {\n    lvl = strings.toLower(v:level)\n    sev = if lvl == \"warn\" then \"warning\" \n        else if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"\n    return sev\n}",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// severity levels on status objects can be one of the following: ok,info,warn,crit,unknown\n"}, ast.Comment{Text: "// but pagerduty only accepts critical, error, warning or info.\n"}, ast.Comment{Text: "// severityFromLevel turns a level from the status object into a pagerduty severity\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   16,
						},
						File:   "pagerduty.flux",
						Source: "severityFromLevel",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "severityFromLevel",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "pagerduty.flux",
						Source: "(level) => {\n    lvl = strings.toLower(v:level)\n    sev = if lvl == \"warn\" then \"warning\" \n        else if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"\n    return sev\n}",
						Start: ast.Position{
							Column: 21,
							Line:   16,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   24,
							},
							File:   "pagerduty.flux",
							Source: "{\n    lvl = strings.toLower(v:level)\n    sev = if lvl == \"warn\" then \"warning\" \n        else if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"\n    return sev\n}",
							Start: ast.Position{
								Column: 32,
								Line:   16,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   17,
								},
								File:   "pagerduty.flux",
								Source: "lvl = strings.toLower(v:level)",
								Start: ast.Position{
									Column: 5,
									Line:   17,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   17,
									},
									File:   "pagerduty.flux",
									Source: "lvl",
									Start: ast.Position{
										Column: 5,
										Line:   17,
									},
								},
							},
							Name: "lvl",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   17,
										},
										File:   "pagerduty.flux",
										Source: "v:level",
										Start: ast.Position{
											Column: 27,
											Line:   17,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   17,
											},
											File:   "pagerduty.flux",
											Source: "v:level",
											Start: ast.Position{
												Column: 27,
												Line:   17,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   17,
												},
												File:   "pagerduty.flux",
												Source: "v",
												Start: ast.Position{
													Column: 27,
													Line:   17,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   17,
												},
												File:   "pagerduty.flux",
												Source: "level",
												Start: ast.Position{
													Column: 29,
													Line:   17,
												},
											},
										},
										Name: "level",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   17,
									},
									File:   "pagerduty.flux",
									Source: "strings.toLower(v:level)",
									Start: ast.Position{
										Column: 11,
										Line:   17,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   17,
										},
										File:   "pagerduty.flux",
										Source: "strings.toLower",
										Start: ast.Position{
											Column: 11,
											Line:   17,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   17,
											},
											File:   "pagerduty.flux",
											Source: "strings",
											Start: ast.Position{
												Column: 11,
												Line:   17,
											},
										},
									},
									Name: "strings",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   17,
											},
											File:   "pagerduty.flux",
											Source: "toLower",
											Start: ast.Position{
												Column: 19,
												Line:   17,
											},
										},
									},
									Name: "toLower",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   22,
								},
								File:   "pagerduty.flux",
								Source: "sev = if lvl == \"warn\" then \"warning\" \n        else if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"",
								Start: ast.Position{
									Column: 5,
									Line:   18,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   18,
									},
									File:   "pagerduty.flux",
									Source: "sev",
									Start: ast.Position{
										Column: 5,
										Line:   18,
									},
								},
							},
							Name: "sev",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.ConditionalExpression{
								Alternate: &ast.ConditionalExpression{
									Alternate: &ast.ConditionalExpression{
										Alternate: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   22,
													},
													File:   "pagerduty.flux",
													Source: "\"error\"",
													Start: ast.Position{
														Column: 14,
														Line:   22,
													},
												},
											},
											Value: "error",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   22,
												},
												File:   "pagerduty.flux",
												Source: "if lvl == \"ok\" then \"info\" \n        else \"error\"",
												Start: ast.Position{
													Column: 14,
													Line:   21,
												},
											},
										},
										Consequent: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   21,
													},
													File:   "pagerduty.flux",
													Source: "\"info\"",
													Start: ast.Position{
														Column: 34,
														Line:   21,
													},
												},
											},
											Value: "info",
										},
										Test: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   21,
													},
													File:   "pagerduty.flux",
													Source: "lvl == \"ok\"",
													Start: ast.Position{
														Column: 17,
														Line:   21,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   21,
														},
														File:   "pagerduty.flux",
														Source: "lvl",
														Start: ast.Position{
															Column: 17,
															Line:   21,
														},
													},
												},
												Name: "lvl",
											},
											Operator: 17,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   21,
														},
														File:   "pagerduty.flux",
														Source: "\"ok\"",
														Start: ast.Position{
															Column: 24,
															Line:   21,
														},
													},
												},
												Value: "ok",
											},
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   22,
											},
											File:   "pagerduty.flux",
											Source: "if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"",
											Start: ast.Position{
												Column: 14,
												Line:   20,
											},
										},
									},
									Consequent: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   20,
												},
												File:   "pagerduty.flux",
												Source: "\"info\"",
												Start: ast.Position{
													Column: 36,
													Line:   20,
												},
											},
										},
										Value: "info",
									},
									Test: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   20,
												},
												File:   "pagerduty.flux",
												Source: "lvl == \"info\"",
												Start: ast.Position{
													Column: 17,
													Line:   20,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   20,
													},
													File:   "pagerduty.flux",
													Source: "lvl",
													Start: ast.Position{
														Column: 17,
														Line:   20,
													},
												},
											},
											Name: "lvl",
										},
										Operator: 17,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   20,
													},
													File:   "pagerduty.flux",
													Source: "\"info\"",
													Start: ast.Position{
														Column: 24,
														Line:   20,
													},
												},
											},
											Value: "info",
										},
									},
									Tk_else: nil,
									Tk_if:   nil,
									Tk_then: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   22,
										},
										File:   "pagerduty.flux",
										Source: "if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"",
										Start: ast.Position{
											Column: 14,
											Line:   19,
										},
									},
								},
								Consequent: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   19,
											},
											File:   "pagerduty.flux",
											Source: "\"critical\"",
											Start: ast.Position{
												Column: 36,
												Line:   19,
											},
										},
									},
									Value: "critical",
								},
								Test: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   19,
											},
											File:   "pagerduty.flux",
											Source: "lvl == \"crit\"",
											Start: ast.Position{
												Column: 17,
												Line:   19,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   19,
												},
												File:   "pagerduty.flux",
												Source: "lvl",
												Start: ast.Position{
													Column: 17,
													Line:   19,
												},
											},
										},
										Name: "lvl",
									},
									Operator: 17,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   19,
												},
												File:   "pagerduty.flux",
												Source: "\"crit\"",
												Start: ast.Position{
													Column: 24,
													Line:   19,
												},
											},
										},
										Value: "crit",
									},
								},
								Tk_else: nil,
								Tk_if:   nil,
								Tk_then: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   22,
									},
									File:   "pagerduty.flux",
									Source: "if lvl == \"warn\" then \"warning\" \n        else if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"",
									Start: ast.Position{
										Column: 11,
										Line:   18,
									},
								},
							},
							Consequent: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   18,
										},
										File:   "pagerduty.flux",
										Source: "\"warning\"",
										Start: ast.Position{
											Column: 33,
											Line:   18,
										},
									},
								},
								Value: "warning",
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   18,
										},
										File:   "pagerduty.flux",
										Source: "lvl == \"warn\"",
										Start: ast.Position{
											Column: 14,
											Line:   18,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   18,
											},
											File:   "pagerduty.flux",
											Source: "lvl",
											Start: ast.Position{
												Column: 14,
												Line:   18,
											},
										},
									},
									Name: "lvl",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   18,
											},
											File:   "pagerduty.flux",
											Source: "\"warn\"",
											Start: ast.Position{
												Column: 21,
												Line:   18,
											},
										},
									},
									Value: "warn",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   23,
									},
									File:   "pagerduty.flux",
									Source: "sev",
									Start: ast.Position{
										Column: 12,
										Line:   23,
									},
								},
							},
							Name: "sev",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   23,
								},
								File:   "pagerduty.flux",
								Source: "return sev",
								Start: ast.Position{
									Column: 5,
									Line:   23,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   16,
							},
							File:   "pagerduty.flux",
							Source: "level",
							Start: ast.Position{
								Column: 22,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   16,
								},
								File:   "pagerduty.flux",
								Source: "level",
								Start: ast.Position{
									Column: 22,
									Line:   16,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 94,
						Line:   27,
					},
					File:   "pagerduty.flux",
					Source: "actionFromLevel = (level)=> if strings.toLower(v:level) == \"ok\" then \"resolve\" else \"trigger\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `actionFromLevel` converts a monitoring level to an action; \"ok\" becomes \"resolve\" everything else converts to \"trigger\".\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   27,
						},
						File:   "pagerduty.flux",
						Source: "actionFromLevel",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "actionFromLevel",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 94,
							Line:   27,
						},
						File:   "pagerduty.flux",
						Source: "(level)=> if strings.toLower(v:level) == \"ok\" then \"resolve\" else \"trigger\"",
						Start: ast.Position{
							Column: 19,
							Line:   27,
						},
					},
				},
				Body: &ast.ConditionalExpression{
					Alternate: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   27,
								},
								File:   "pagerduty.flux",
								Source: "\"trigger\"",
								Start: ast.Position{
									Column: 85,
									Line:   27,
								},
							},
						},
						Value: "trigger",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 94,
								Line:   27,
							},
							File:   "pagerduty.flux",
							Source: "if strings.toLower(v:level) == \"ok\" then \"resolve\" else \"trigger\"",
							Start: ast.Position{
								Column: 29,
								Line:   27,
							},
						},
					},
					Consequent: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   27,
								},
								File:   "pagerduty.flux",
								Source: "\"resolve\"",
								Start: ast.Position{
									Column: 70,
									Line:   27,
								},
							},
						},
						Value: "resolve",
					},
					Test: &ast.BinaryExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   27,
								},
								File:   "pagerduty.flux",
								Source: "strings.toLower(v:level) == \"ok\"",
								Start: ast.Position{
									Column: 32,
									Line:   27,
								},
							},
						},
						Left: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   27,
										},
										File:   "pagerduty.flux",
										Source: "v:level",
										Start: ast.Position{
											Column: 48,
											Line:   27,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   27,
											},
											File:   "pagerduty.flux",
											Source: "v:level",
											Start: ast.Position{
												Column: 48,
												Line:   27,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   27,
												},
												File:   "pagerduty.flux",
												Source: "v",
												Start: ast.Position{
													Column: 48,
													Line:   27,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   27,
												},
												File:   "pagerduty.flux",
												Source: "level",
												Start: ast.Position{
													Column: 50,
													Line:   27,
												},
											},
										},
										Name: "level",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   27,
									},
									File:   "pagerduty.flux",
									Source: "strings.toLower(v:level)",
									Start: ast.Position{
										Column: 32,
										Line:   27,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   27,
										},
										File:   "pagerduty.flux",
										Source: "strings.toLower",
										Start: ast.Position{
											Column: 32,
											Line:   27,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   27,
											},
											File:   "pagerduty.flux",
											Source: "strings",
											Start: ast.Position{
												Column: 32,
												Line:   27,
											},
										},
									},
									Name: "strings",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   27,
											},
											File:   "pagerduty.flux",
											Source: "toLower",
											Start: ast.Position{
												Column: 40,
												Line:   27,
											},
										},
									},
									Name: "toLower",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						Operator: 17,
						Right: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   27,
									},
									File:   "pagerduty.flux",
									Source: "\"ok\"",
									Start: ast.Position{
										Column: 60,
										Line:   27,
									},
								},
							},
							Value: "ok",
						},
					},
					Tk_else: nil,
					Tk_if:   nil,
					Tk_then: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   27,
							},
							File:   "pagerduty.flux",
							Source: "level",
							Start: ast.Position{
								Column: 20,
								Line:   27,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   27,
								},
								File:   "pagerduty.flux",
								Source: "level",
								Start: ast.Position{
									Column: 20,
									Line:   27,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   78,
					},
					File:   "pagerduty.flux",
					Source: "sendEvent = (pagerdutyURL=defaultURL,\n    routingKey,\n    client,\n    clientURL,\n    dedupKey,\n    class,\n    group,\n    severity,\n    eventAction,\n    source,\n    summary,\n    timestamp) => {\n\n    payload = {\n            summary: summary,\n            timestamp: timestamp,\n            source: source,\n            severity: severity,\n            group: group,\n            class: class,\n    }\n    data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }\n\n    headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n    return http.post(headers: headers, url: pagerdutyURL, data: enc)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `sendEvent` sends an event to PagerDuty, the description of some of these parameters taken from the pagerduty documentation at https://v2.developer.pagerduty.com/docs/send-an-event-events-api-v2\n"}, ast.Comment{Text: "// `pagerdutyURL` - sring - URL of the pagerduty endpoint.  Defaults to: `option defaultURL = \"https://events.pagerduty.com/v2/enqueue\"`\n"}, ast.Comment{Text: "// `routingKey` - string - routingKey.\n"}, ast.Comment{Text: "// `client` - string - name of the client sending the alert.\n"}, ast.Comment{Text: "// `clientURL` - string - url of the client sending the alert.\n"}, ast.Comment{Text: "// `dedupkey` - string - a per alert ID. It acts as deduplication key, that allows you to ack or change the severity of previous messages. Supports a maximum of 255 characters.\n"}, ast.Comment{Text: "// `class` - string - The class/type of the event, for example ping failure or cpu load.\n"}, ast.Comment{Text: "// `group` - string - Logical grouping of components of a service, for example app-stack.\n"}, ast.Comment{Text: "// `severity` - string - The perceived severity of the status the event is describing with respect to the affected system. This can be critical, error, warning or info.\n"}, ast.Comment{Text: "// `eventAction` - string - The type of event to send to PagerDuty (ex. trigger, resolve, acknowledge)\n"}, ast.Comment{Text: "// `source` - string - The unique location of the affected system, preferably a hostname or FQDN.\n"}, ast.Comment{Text: "// `summary` - string - A brief text summary of the event, used to generate the summaries/titles of any associated alerts. The maximum permitted length of this property is 1024 characters.\n"}, ast.Comment{Text: "// `timestamp` - string - The time at which the emitting tool detected or generated the event, in RFC 3339 nano format.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   42,
						},
						File:   "pagerduty.flux",
						Source: "sendEvent",
						Start: ast.Position{
							Column: 1,
							Line:   42,
						},
					},
				},
				Name: "sendEvent",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   78,
						},
						File:   "pagerduty.flux",
						Source: "(pagerdutyURL=defaultURL,\n    routingKey,\n    client,\n    clientURL,\n    dedupKey,\n    class,\n    group,\n    severity,\n    eventAction,\n    source,\n    summary,\n    timestamp) => {\n\n    payload = {\n            summary: summary,\n            timestamp: timestamp,\n            source: source,\n            severity: severity,\n            group: group,\n            class: class,\n    }\n    data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }\n\n    headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n    return http.post(headers: headers, url: pagerdutyURL, data: enc)\n}",
						Start: ast.Position{
							Column: 13,
							Line:   42,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   78,
							},
							File:   "pagerduty.flux",
							Source: "{\n\n    payload = {\n            summary: summary,\n            timestamp: timestamp,\n            source: source,\n            severity: severity,\n            group: group,\n            class: class,\n    }\n    data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }\n\n    headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n    return http.post(headers: headers, url: pagerdutyURL, data: enc)\n}",
							Start: ast.Position{
								Column: 19,
								Line:   53,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   62,
								},
								File:   "pagerduty.flux",
								Source: "payload = {\n            summary: summary,\n            timestamp: timestamp,\n            source: source,\n            severity: severity,\n            group: group,\n            class: class,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   55,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   55,
									},
									File:   "pagerduty.flux",
									Source: "payload",
									Start: ast.Position{
										Column: 5,
										Line:   55,
									},
								},
							},
							Name: "payload",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   62,
									},
									File:   "pagerduty.flux",
									Source: "{\n            summary: summary,\n            timestamp: timestamp,\n            source: source,\n            severity: severity,\n            group: group,\n            class: class,\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   55,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   56,
										},
										File:   "pagerduty.flux",
										Source: "summary: summary",
										Start: ast.Position{
											Column: 13,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   56,
											},
											File:   "pagerduty.flux",
											Source: "summary",
											Start: ast.Position{
												Column: 13,
												Line:   56,
											},
										},
									},
									Name: "summary",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   56,
											},
											File:   "pagerduty.flux",
											Source: "summary",
											Start: ast.Position{
												Column: 22,
												Line:   56,
											},
										},
									},
									Name: "summary",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   57,
										},
										File:   "pagerduty.flux",
										Source: "timestamp: timestamp",
										Start: ast.Position{
											Column: 13,
											Line:   57,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   57,
											},
											File:   "pagerduty.flux",
											Source: "timestamp",
											Start: ast.Position{
												Column: 13,
												Line:   57,
											},
										},
									},
									Name: "timestamp",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   57,
											},
											File:   "pagerduty.flux",
											Source: "timestamp",
											Start: ast.Position{
												Column: 24,
												Line:   57,
											},
										},
									},
									Name: "timestamp",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   58,
										},
										File:   "pagerduty.flux",
										Source: "source: source",
										Start: ast.Position{
											Column: 13,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   58,
											},
											File:   "pagerduty.flux",
											Source: "source",
											Start: ast.Position{
												Column: 13,
												Line:   58,
											},
										},
									},
									Name: "source",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   58,
											},
											File:   "pagerduty.flux",
											Source: "source",
											Start: ast.Position{
												Column: 21,
												Line:   58,
											},
										},
									},
									Name: "source",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   59,
										},
										File:   "pagerduty.flux",
										Source: "severity: severity",
										Start: ast.Position{
											Column: 13,
											Line:   59,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   59,
											},
											File:   "pagerduty.flux",
											Source: "severity",
											Start: ast.Position{
												Column: 13,
												Line:   59,
											},
										},
									},
									Name: "severity",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   59,
											},
											File:   "pagerduty.flux",
											Source: "severity",
											Start: ast.Position{
												Column: 23,
												Line:   59,
											},
										},
									},
									Name: "severity",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   60,
										},
										File:   "pagerduty.flux",
										Source: "group: group",
										Start: ast.Position{
											Column: 13,
											Line:   60,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   60,
											},
											File:   "pagerduty.flux",
											Source: "group",
											Start: ast.Position{
												Column: 13,
												Line:   60,
											},
										},
									},
									Name: "group",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   60,
											},
											File:   "pagerduty.flux",
											Source: "group",
											Start: ast.Position{
												Column: 20,
												Line:   60,
											},
										},
									},
									Name: "group",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   61,
										},
										File:   "pagerduty.flux",
										Source: "class: class",
										Start: ast.Position{
											Column: 13,
											Line:   61,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   61,
											},
											File:   "pagerduty.flux",
											Source: "class",
											Start: ast.Position{
												Column: 13,
												Line:   61,
											},
										},
									},
									Name: "class",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   61,
											},
											File:   "pagerduty.flux",
											Source: "class",
											Start: ast.Position{
												Column: 20,
												Line:   61,
											},
										},
									},
									Name: "class",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   70,
								},
								File:   "pagerduty.flux",
								Source: "data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   63,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   63,
									},
									File:   "pagerduty.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   63,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   70,
									},
									File:   "pagerduty.flux",
									Source: "{\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   63,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   64,
										},
										File:   "pagerduty.flux",
										Source: "payload: payload",
										Start: ast.Position{
											Column: 9,
											Line:   64,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   64,
											},
											File:   "pagerduty.flux",
											Source: "payload",
											Start: ast.Position{
												Column: 9,
												Line:   64,
											},
										},
									},
									Name: "payload",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   64,
											},
											File:   "pagerduty.flux",
											Source: "payload",
											Start: ast.Position{
												Column: 18,
												Line:   64,
											},
										},
									},
									Name: "payload",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   65,
										},
										File:   "pagerduty.flux",
										Source: "routing_key: routingKey",
										Start: ast.Position{
											Column: 9,
											Line:   65,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   65,
											},
											File:   "pagerduty.flux",
											Source: "routing_key",
											Start: ast.Position{
												Column: 9,
												Line:   65,
											},
										},
									},
									Name: "routing_key",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   65,
											},
											File:   "pagerduty.flux",
											Source: "routingKey",
											Start: ast.Position{
												Column: 22,
												Line:   65,
											},
										},
									},
									Name: "routingKey",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   66,
										},
										File:   "pagerduty.flux",
										Source: "dedup_key: dedupKey",
										Start: ast.Position{
											Column: 9,
											Line:   66,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   66,
											},
											File:   "pagerduty.flux",
											Source: "dedup_key",
											Start: ast.Position{
												Column: 9,
												Line:   66,
											},
										},
									},
									Name: "dedup_key",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   66,
											},
											File:   "pagerduty.flux",
											Source: "dedupKey",
											Start: ast.Position{
												Column: 20,
												Line:   66,
											},
										},
									},
									Name: "dedupKey",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   67,
										},
										File:   "pagerduty.flux",
										Source: "event_action: eventAction",
										Start: ast.Position{
											Column: 9,
											Line:   67,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   67,
											},
											File:   "pagerduty.flux",
											Source: "event_action",
											Start: ast.Position{
												Column: 9,
												Line:   67,
											},
										},
									},
									Name: "event_action",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   67,
											},
											File:   "pagerduty.flux",
											Source: "eventAction",
											Start: ast.Position{
												Column: 23,
												Line:   67,
											},
										},
									},
									Name: "eventAction",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   68,
										},
										File:   "pagerduty.flux",
										Source: "client: client",
										Start: ast.Position{
											Column: 9,
											Line:   68,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   68,
											},
											File:   "pagerduty.flux",
											Source: "client",
											Start: ast.Position{
												Column: 9,
												Line:   68,
											},
										},
									},
									Name: "client",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   68,
											},
											File:   "pagerduty.flux",
											Source: "client",
											Start: ast.Position{
												Column: 17,
												Line:   68,
											},
										},
									},
									Name: "client",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   69,
										},
										File:   "pagerduty.flux",
										Source: "client_url: clientURL",
										Start: ast.Position{
											Column: 9,
											Line:   69,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   69,
											},
											File:   "pagerduty.flux",
											Source: "client_url",
											Start: ast.Position{
												Column: 9,
												Line:   69,
											},
										},
									},
									Name: "client_url",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   69,
											},
											File:   "pagerduty.flux",
											Source: "clientURL",
											Start: ast.Position{
												Column: 21,
												Line:   69,
											},
										},
									},
									Name: "clientURL",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   75,
								},
								File:   "pagerduty.flux",
								Source: "headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   72,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   72,
									},
									File:   "pagerduty.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   72,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   75,
									},
									File:   "pagerduty.flux",
									Source: "{\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   72,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   73,
										},
										File:   "pagerduty.flux",
										Source: "\"Accept\": \"application/vnd.pagerduty+json;version=2\"",
										Start: ast.Position{
											Column: 9,
											Line:   73,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   73,
											},
											File:   "pagerduty.flux",
											Source: "\"Accept\"",
											Start: ast.Position{
												Column: 9,
												Line:   73,
											},
										},
									},
									Value: "Accept",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   73,
											},
											File:   "pagerduty.flux",
											Source: "\"application/vnd.pagerduty+json;version=2\"",
											Start: ast.Position{
												Column: 19,
												Line:   73,
											},
										},
									},
									Value: "application/vnd.pagerduty+json;version=2",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   74,
										},
										File:   "pagerduty.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 9,
											Line:   74,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   74,
											},
											File:   "pagerduty.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   74,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   74,
											},
											File:   "pagerduty.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 25,
												Line:   74,
											},
										},
									},
									Value: "application/json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   76,
								},
								File:   "pagerduty.flux",
								Source: "enc = json.encode(v: data)",
								Start: ast.Position{
									Column: 5,
									Line:   76,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   76,
									},
									File:   "pagerduty.flux",
									Source: "enc",
									Start: ast.Position{
										Column: 5,
										Line:   76,
									},
								},
							},
							Name: "enc",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   76,
										},
										File:   "pagerduty.flux",
										Source: "v: data",
										Start: ast.Position{
											Column: 23,
											Line:   76,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   76,
											},
											File:   "pagerduty.flux",
											Source: "v: data",
											Start: ast.Position{
												Column: 23,
												Line:   76,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   76,
												},
												File:   "pagerduty.flux",
												Source: "v",
												Start: ast.Position{
													Column: 23,
													Line:   76,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   76,
												},
												File:   "pagerduty.flux",
												Source: "data",
												Start: ast.Position{
													Column: 26,
													Line:   76,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   76,
									},
									File:   "pagerduty.flux",
									Source: "json.encode(v: data)",
									Start: ast.Position{
										Column: 11,
										Line:   76,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   76,
										},
										File:   "pagerduty.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 11,
											Line:   76,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   76,
											},
											File:   "pagerduty.flux",
											Source: "json",
											Start: ast.Position{
												Column: 11,
												Line:   76,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   76,
											},
											File:   "pagerduty.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 16,
												Line:   76,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   77,
										},
										File:   "pagerduty.flux",
										Source: "headers: headers, url: pagerdutyURL, data: enc",
										Start: ast.Position{
											Column: 22,
											Line:   77,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   77,
											},
											File:   "pagerduty.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   77,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   77,
												},
												File:   "pagerduty.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   77,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   77,
												},
												File:   "pagerduty.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   77,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   77,
											},
											File:   "pagerduty.flux",
											Source: "url: pagerdutyURL",
											Start: ast.Position{
												Column: 40,
												Line:   77,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   77,
												},
												File:   "pagerduty.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   77,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   77,
												},
												File:   "pagerduty.flux",
												Source: "pagerdutyURL",
												Start: ast.Position{
													Column: 45,
													Line:   77,
												},
											},
										},
										Name: "pagerdutyURL",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   77,
											},
											File:   "pagerduty.flux",
											Source: "data: enc",
											Start: ast.Position{
												Column: 59,
												Line:   77,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   77,
												},
												File:   "pagerduty.flux",
												Source: "data",
												Start: ast.Position{
													Column: 59,
													Line:   77,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   77,
												},
												File:   "pagerduty.flux",
												Source: "enc",
												Start: ast.Position{
													Column: 65,
													Line:   77,
												},
											},
										},
										Name: "enc",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   77,
									},
									File:   "pagerduty.flux",
									Source: "http.post(headers: headers, url: pagerdutyURL, data: enc)",
									Start: ast.Position{
										Column: 12,
										Line:   77,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   77,
										},
										File:   "pagerduty.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   77,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   77,
											},
											File:   "pagerduty.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   77,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   77,
											},
											File:   "pagerduty.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   77,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   77,
								},
								File:   "pagerduty.flux",
								Source: "return http.post(headers: headers, url: pagerdutyURL, data: enc)",
								Start: ast.Position{
									Column: 5,
									Line:   77,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   42,
							},
							File:   "pagerduty.flux",
							Source: "pagerdutyURL=defaultURL",
							Start: ast.Position{
								Column: 14,
								Line:   42,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   42,
								},
								File:   "pagerduty.flux",
								Source: "pagerdutyURL",
								Start: ast.Position{
									Column: 14,
									Line:   42,
								},
							},
						},
						Name: "pagerdutyURL",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   42,
								},
								File:   "pagerduty.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 27,
									Line:   42,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   43,
							},
							File:   "pagerduty.flux",
							Source: "routingKey",
							Start: ast.Position{
								Column: 5,
								Line:   43,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   43,
								},
								File:   "pagerduty.flux",
								Source: "routingKey",
								Start: ast.Position{
									Column: 5,
									Line:   43,
								},
							},
						},
						Name: "routingKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   44,
							},
							File:   "pagerduty.flux",
							Source: "client",
							Start: ast.Position{
								Column: 5,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   44,
								},
								File:   "pagerduty.flux",
								Source: "client",
								Start: ast.Position{
									Column: 5,
									Line:   44,
								},
							},
						},
						Name: "client",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   45,
							},
							File:   "pagerduty.flux",
							Source: "clientURL",
							Start: ast.Position{
								Column: 5,
								Line:   45,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   45,
								},
								File:   "pagerduty.flux",
								Source: "clientURL",
								Start: ast.Position{
									Column: 5,
									Line:   45,
								},
							},
						},
						Name: "clientURL",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   46,
							},
							File:   "pagerduty.flux",
							Source: "dedupKey",
							Start: ast.Position{
								Column: 5,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   46,
								},
								File:   "pagerduty.flux",
								Source: "dedupKey",
								Start: ast.Position{
									Column: 5,
									Line:   46,
								},
							},
						},
						Name: "dedupKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   47,
							},
							File:   "pagerduty.flux",
							Source: "class",
							Start: ast.Position{
								Column: 5,
								Line:   47,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   47,
								},
								File:   "pagerduty.flux",
								Source: "class",
								Start: ast.Position{
									Column: 5,
									Line:   47,
								},
							},
						},
						Name: "class",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   48,
							},
							File:   "pagerduty.flux",
							Source: "group",
							Start: ast.Position{
								Column: 5,
								Line:   48,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   48,
								},
								File:   "pagerduty.flux",
								Source: "group",
								Start: ast.Position{
									Column: 5,
									Line:   48,
								},
							},
						},
						Name: "group",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   49,
							},
							File:   "pagerduty.flux",
							Source: "severity",
							Start: ast.Position{
								Column: 5,
								Line:   49,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   49,
								},
								File:   "pagerduty.flux",
								Source: "severity",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
						Name: "severity",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   50,
							},
							File:   "pagerduty.flux",
							Source: "eventAction",
							Start: ast.Position{
								Column: 5,
								Line:   50,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   50,
								},
								File:   "pagerduty.flux",
								Source: "eventAction",
								Start: ast.Position{
									Column: 5,
									Line:   50,
								},
							},
						},
						Name: "eventAction",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   51,
							},
							File:   "pagerduty.flux",
							Source: "source",
							Start: ast.Position{
								Column: 5,
								Line:   51,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   51,
								},
								File:   "pagerduty.flux",
								Source: "source",
								Start: ast.Position{
									Column: 5,
									Line:   51,
								},
							},
						},
						Name: "source",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   52,
							},
							File:   "pagerduty.flux",
							Source: "summary",
							Start: ast.Position{
								Column: 5,
								Line:   52,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   52,
								},
								File:   "pagerduty.flux",
								Source: "summary",
								Start: ast.Position{
									Column: 5,
									Line:   52,
								},
							},
						},
						Name: "summary",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   53,
							},
							File:   "pagerduty.flux",
							Source: "timestamp",
							Start: ast.Position{
								Column: 5,
								Line:   53,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   53,
								},
								File:   "pagerduty.flux",
								Source: "timestamp",
								Start: ast.Position{
									Column: 5,
									Line:   53,
								},
							},
						},
						Name: "timestamp",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   105,
					},
					File:   "pagerduty.flux",
					Source: "endpoint = (url=defaultURL) =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> dedupKey()\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
					Start: ast.Position{
						Column: 1,
						Line:   85,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `endpoint` creates the endpoint for the PagerDuty external service.\n"}, ast.Comment{Text: "// `url` - string - URL of the Pagerduty endpoint. Defaults to: \"https://events.pagerduty.com/v2/enqueue\".\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` parameter must be a function that returns an object with `routingKey`, `client`, `client_url`, `class`, `group`, `severity`, `eventAction`, `source`, `summary`, and `timestamp` as defined in the sendEvent function.\n"}, ast.Comment{Text: "// Note that while sendEvent accepts a dedup key, endpoint gets the dedupkey from the groupkey of the input table instead of it being handled by the `mapFn`.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   85,
						},
						File:   "pagerduty.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   85,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   105,
						},
						File:   "pagerduty.flux",
						Source: "(url=defaultURL) =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> dedupKey()\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
						Start: ast.Position{
							Column: 12,
							Line:   85,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   105,
							},
							File:   "pagerduty.flux",
							Source: "(mapFn) =>\n        (tables=<-) => tables\n            |> dedupKey()\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
							Start: ast.Position{
								Column: 5,
								Line:   86,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   105,
								},
								File:   "pagerduty.flux",
								Source: "(tables=<-) => tables\n            |> dedupKey()\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
								Start: ast.Position{
									Column: 9,
									Line:   87,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   87,
											},
											File:   "pagerduty.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 24,
												Line:   87,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   88,
										},
										File:   "pagerduty.flux",
										Source: "tables\n            |> dedupKey()",
										Start: ast.Position{
											Column: 24,
											Line:   87,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   88,
											},
											File:   "pagerduty.flux",
											Source: "dedupKey()",
											Start: ast.Position{
												Column: 16,
												Line:   88,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   88,
												},
												File:   "pagerduty.flux",
												Source: "dedupKey",
												Start: ast.Position{
													Column: 16,
													Line:   88,
												},
											},
										},
										Name: "dedupKey",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   105,
									},
									File:   "pagerduty.flux",
									Source: "tables\n            |> dedupKey()\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
									Start: ast.Position{
										Column: 24,
										Line:   87,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   105,
											},
											File:   "pagerduty.flux",
											Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            }",
											Start: ast.Position{
												Column: 20,
												Line:   89,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   105,
												},
												File:   "pagerduty.flux",
												Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            }",
												Start: ast.Position{
													Column: 20,
													Line:   89,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   89,
													},
													File:   "pagerduty.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 20,
														Line:   89,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   105,
													},
													File:   "pagerduty.flux",
													Source: "(r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            }",
													Start: ast.Position{
														Column: 24,
														Line:   89,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   105,
														},
														File:   "pagerduty.flux",
														Source: "{\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            }",
														Start: ast.Position{
															Column: 31,
															Line:   89,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   90,
															},
															File:   "pagerduty.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 17,
																Line:   90,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   90,
																},
																File:   "pagerduty.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 17,
																	Line:   90,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   90,
																	},
																	File:   "pagerduty.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   90,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   90,
																		},
																		File:   "pagerduty.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 29,
																			Line:   90,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   90,
																			},
																			File:   "pagerduty.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 29,
																				Line:   90,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   90,
																			},
																			File:   "pagerduty.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 32,
																				Line:   90,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   90,
																},
																File:   "pagerduty.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 23,
																	Line:   90,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 28,
																		Line:   90,
																	},
																	File:   "pagerduty.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 23,
																		Line:   90,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   104,
																},
																File:   "pagerduty.flux",
																Source: "{r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}",
																Start: ast.Position{
																	Column: 24,
																	Line:   92,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   104,
																	},
																	File:   "pagerduty.flux",
																	Source: "_sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))",
																	Start: ast.Position{
																		Column: 32,
																		Line:   92,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   92,
																		},
																		File:   "pagerduty.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 32,
																			Line:   92,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 25,
																				Line:   104,
																			},
																			File:   "pagerduty.flux",
																			Source: "v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100)",
																			Start: ast.Position{
																				Column: 46,
																				Line:   92,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 25,
																					Line:   104,
																				},
																				File:   "pagerduty.flux",
																				Source: "v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100)",
																				Start: ast.Position{
																					Column: 46,
																					Line:   92,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   92,
																					},
																					File:   "pagerduty.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 46,
																						Line:   92,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 25,
																						Line:   104,
																					},
																					File:   "pagerduty.flux",
																					Source: "2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100)",
																					Start: ast.Position{
																						Column: 49,
																						Line:   92,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 50,
																							Line:   92,
																						},
																						File:   "pagerduty.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 49,
																							Line:   92,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.ParenExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   104,
																						},
																						File:   "pagerduty.flux",
																						Source: "(sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100)",
																						Start: ast.Position{
																							Column: 54,
																							Line:   92,
																						},
																					},
																				},
																				Expression: &ast.BinaryExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 24,
																								Line:   104,
																							},
																							File:   "pagerduty.flux",
																							Source: "sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100",
																							Start: ast.Position{
																								Column: 55,
																								Line:   92,
																							},
																						},
																					},
																					Left: &ast.CallExpression{
																						Arguments: []ast.Expression{&ast.ObjectExpression{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   103,
																									},
																									File:   "pagerduty.flux",
																									Source: "pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp",
																									Start: ast.Position{
																										Column: 65,
																										Line:   92,
																									},
																								},
																							},
																							Lbrace: nil,
																							Properties: []*ast.Property{&ast.Property{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 82,
																											Line:   92,
																										},
																										File:   "pagerduty.flux",
																										Source: "pagerdutyURL: url",
																										Start: ast.Position{
																											Column: 65,
																											Line:   92,
																										},
																									},
																								},
																								Comma: nil,
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 77,
																												Line:   92,
																											},
																											File:   "pagerduty.flux",
																											Source: "pagerdutyURL",
																											Start: ast.Position{
																												Column: 65,
																												Line:   92,
																											},
																										},
																									},
																									Name: "pagerdutyURL",
																								},
																								Separator: nil,
																								Value: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 82,
																												Line:   92,
																											},
																											File:   "pagerduty.flux",
																											Source: "url",
																											Start: ast.Position{
																												Column: 79,
																												Line:   92,
																											},
																										},
																									},
																									Name: "url",
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 47,
																											Line:   93,
																										},
																										File:   "pagerduty.flux",
																										Source: "routingKey: obj.routingKey",
																										Start: ast.Position{
																											Column: 21,
																											Line:   93,
																										},
																									},
																								},
																								Comma: nil,
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 31,
																												Line:   93,
																											},
																											File:   "pagerduty.flux",
																											Source: "routingKey",
																											Start: ast.Position{
																												Column: 21,
																												Line:   93,
																											},
																										},
																									},
																									Name: "routingKey",
																								},
																								Separator: nil,
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 47,
																												Line:   93,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.routingKey",
																											Start: ast.Position{
																												Column: 33,
																												Line:   93,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 36,
																													Line:   93,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 33,
																													Line:   93,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 47,
																													Line:   93,
																												},
																												File:   "pagerduty.flux",
																												Source: "routingKey",
																												Start: ast.Position{
																													Column: 37,
																													Line:   93,
																												},
																											},
																										},
																										Name: "routingKey",
																									},
																									Rbrack: nil,
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   94,
																										},
																										File:   "pagerduty.flux",
																										Source: "client: obj.client",
																										Start: ast.Position{
																											Column: 21,
																											Line:   94,
																										},
																									},
																								},
																								Comma: nil,
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 27,
																												Line:   94,
																											},
																											File:   "pagerduty.flux",
																											Source: "client",
																											Start: ast.Position{
																												Column: 21,
																												Line:   94,
																											},
																										},
																									},
																									Name: "client",
																								},
																								Separator: nil,
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   94,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.client",
																											Start: ast.Position{
																												Column: 29,
																												Line:   94,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 32,
																													Line:   94,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 29,
																													Line:   94,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 39,
																													Line:   94,
																												},
																												File:   "pagerduty.flux",
																												Source: "client",
																												Start: ast.Position{
																													Column: 33,
																													Line:   94,
																												},
																											},
																										},
																										Name: "client",
																									},
																									Rbrack: nil,
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   95,
																										},
																										File:   "pagerduty.flux",
																										Source: "clientURL: obj.clientURL",
																										Start: ast.Position{
																											Column: 21,
																											Line:   95,
																										},
																									},
																								},
																								Comma: nil,
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 30,
																												Line:   95,
																											},
																											File:   "pagerduty.flux",
																											Source: "clientURL",
																											Start: ast.Position{
																												Column: 21,
																												Line:   95,
																											},
																										},
																									},
																									Name: "clientURL",
																								},
																								Separator: nil,
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   95,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.clientURL",
																											Start: ast.Position{
																												Column: 32,
																												Line:   95,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 35,
																													Line:   95,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 32,
																													Line:   95,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 45,
																													Line:   95,
																												},
																												File:   "pagerduty.flux",
																												Source: "clientURL",
																												Start: ast.Position{
																													Column: 36,
																													Line:   95,
																												},
																											},
																										},
																										Name: "clientURL",
																									},
																									Rbrack: nil,
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 51,
																											Line:   96,
																										},
																										File:   "pagerduty.flux",
																										Source: "dedupKey: r._pagerdutyDedupKey",
																										Start: ast.Position{
																											Column: 21,
																											Line:   96,
																										},
																									},
																								},
																								Comma: nil,
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 29,
																												Line:   96,
																											},
																											File:   "pagerduty.flux",
																											Source: "dedupKey",
																											Start: ast.Position{
																												Column: 21,
																												Line:   96,
																											},
																										},
																									},
																									Name: "dedupKey",
																								},
																								Separator: nil,
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 51,
																												Line:   96,
																											},
																											File:   "pagerduty.flux",
																											Source: "r._pagerdutyDedupKey",
																											Start: ast.Position{
																												Column: 31,
																												Line:   96,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 32,
																													Line:   96,
																												},
																												File:   "pagerduty.flux",
																												Source: "r",
																												Start: ast.Position{
																													Column: 31,
																													Line:   96,
																												},
																											},
																										},
																										Name: "r",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 51,
																													Line:   96,
																												},
																												File:   "pagerduty.flux",
																												Source: "_pagerdutyDedupKey",
																												Start: ast.Position{
																													Column: 33,
																													Line:   96,
																												},
																											},
																										},
																										Name: "_pagerdutyDedupKey",
																									},
																									Rbrack: nil,
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   97,
																										},
																										File:   "pagerduty.flux",
																										Source: "class: obj.class",
																										Start: ast.Position{
																											Column: 21,
																											Line:   97,
																										},
																									},
																								},
																								Comma: nil,
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 26,
																												Line:   97,
																											},
																											File:   "pagerduty.flux",
																											Source: "class",
																											Start: ast.Position{
																												Column: 21,
																												Line:   97,
																											},
																										},
																									},
																									Name: "class",
																								},
																								Separator: nil,
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   97,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.class",
																											Start: ast.Position{
																												Column: 28,
																												Line:   97,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 31,
																													Line:   97,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 28,
																													Line:   97,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 37,
																													Line:   97,
																												},
																												File:   "pagerduty.flux",
																												Source: "class",
																												Start: ast.Position{
																													Column: 32,
																													Line:   97,
																												},
																											},
																										},
																										Name: "class",
																									},
																									Rbrack: nil,
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   98,
																										},
																										File:   "pagerduty.flux",
																										Source: "group: obj.group",
																										Start: ast.Position{
																											Column: 21,
																											Line:   98,
																										},
																									},
																								},
																								Comma: nil,
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 26,
																												Line:   98,
																											},
																											File:   "pagerduty.flux",
																											Source: "group",
																											Start: ast.Position{
																												Column: 21,
																												Line:   98,
																											},
																										},
																									},
																									Name: "group",
																								},
																								Separator: nil,
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   98,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.group",
																											Start: ast.Position{
																												Column: 28,
																												Line:   98,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 31,
																													Line:   98,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 28,
																													Line:   98,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 37,
																													Line:   98,
																												},
																												File:   "pagerduty.flux",
																												Source: "group",
																												Start: ast.Position{
																													Column: 32,
																													Line:   98,
																												},
																											},
																										},
																										Name: "group",
																									},
																									Rbrack: nil,
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   99,
																										},
																										File:   "pagerduty.flux",
																										Source: "severity: obj.severity",
																										Start: ast.Position{
																											Column: 21,
																											Line:   99,
																										},
																									},
																								},
																								Comma: nil,
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 29,
																												Line:   99,
																											},
																											File:   "pagerduty.flux",
																											Source: "severity",
																											Start: ast.Position{
																												Column: 21,
																												Line:   99,
																											},
																										},
																									},
																									Name: "severity",
																								},
																								Separator: nil,
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 43,
																												Line:   99,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.severity",
																											Start: ast.Position{
																												Column: 31,
																												Line:   99,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 34,
																													Line:   99,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 31,
																													Line:   99,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 43,
																													Line:   99,
																												},
																												File:   "pagerduty.flux",
																												Source: "severity",
																												Start: ast.Position{
																													Column: 35,
																													Line:   99,
																												},
																											},
																										},
																										Name: "severity",
																									},
																									Rbrack: nil,
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 49,
																											Line:   100,
																										},
																										File:   "pagerduty.flux",
																										Source: "eventAction: obj.eventAction",
																										Start: ast.Position{
																											Column: 21,
																											Line:   100,
																										},
																									},
																								},
																								Comma: nil,
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 32,
																												Line:   100,
																											},
																											File:   "pagerduty.flux",
																											Source: "eventAction",
																											Start: ast.Position{
																												Column: 21,
																												Line:   100,
																											},
																										},
																									},
																									Name: "eventAction",
																								},
																								Separator: nil,
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 49,
																												Line:   100,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.eventAction",
																											Start: ast.Position{
																												Column: 34,
																												Line:   100,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 37,
																													Line:   100,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 34,
																													Line:   100,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 49,
																													Line:   100,
																												},
																												File:   "pagerduty.flux",
																												Source: "eventAction",
																												Start: ast.Position{
																													Column: 38,
																													Line:   100,
																												},
																											},
																										},
																										Name: "eventAction",
																									},
																									Rbrack: nil,
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   101,
																										},
																										File:   "pagerduty.flux",
																										Source: "source: obj.source",
																										Start: ast.Position{
																											Column: 21,
																											Line:   101,
																										},
																									},
																								},
																								Comma: nil,
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 27,
																												Line:   101,
																											},
																											File:   "pagerduty.flux",
																											Source: "source",
																											Start: ast.Position{
																												Column: 21,
																												Line:   101,
																											},
																										},
																									},
																									Name: "source",
																								},
																								Separator: nil,
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   101,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.source",
																											Start: ast.Position{
																												Column: 29,
																												Line:   101,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 32,
																													Line:   101,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 29,
																													Line:   101,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 39,
																													Line:   101,
																												},
																												File:   "pagerduty.flux",
																												Source: "source",
																												Start: ast.Position{
																													Column: 33,
																													Line:   101,
																												},
																											},
																										},
																										Name: "source",
																									},
																									Rbrack: nil,
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   102,
																										},
																										File:   "pagerduty.flux",
																										Source: "summary: obj.summary",
																										Start: ast.Position{
																											Column: 21,
																											Line:   102,
																										},
																									},
																								},
																								Comma: nil,
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 28,
																												Line:   102,
																											},
																											File:   "pagerduty.flux",
																											Source: "summary",
																											Start: ast.Position{
																												Column: 21,
																												Line:   102,
																											},
																										},
																									},
																									Name: "summary",
																								},
																								Separator: nil,
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   102,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.summary",
																											Start: ast.Position{
																												Column: 30,
																												Line:   102,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 33,
																													Line:   102,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 30,
																													Line:   102,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 41,
																													Line:   102,
																												},
																												File:   "pagerduty.flux",
																												Source: "summary",
																												Start: ast.Position{
																													Column: 34,
																													Line:   102,
																												},
																											},
																										},
																										Name: "summary",
																									},
																									Rbrack: nil,
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   103,
																										},
																										File:   "pagerduty.flux",
																										Source: "timestamp: obj.timestamp",
																										Start: ast.Position{
																											Column: 21,
																											Line:   103,
																										},
																									},
																								},
																								Comma: nil,
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 30,
																												Line:   103,
																											},
																											File:   "pagerduty.flux",
																											Source: "timestamp",
																											Start: ast.Position{
																												Column: 21,
																												Line:   103,
																											},
																										},
																									},
																									Name: "timestamp",
																								},
																								Separator: nil,
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   103,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.timestamp",
																											Start: ast.Position{
																												Column: 32,
																												Line:   103,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 35,
																													Line:   103,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 32,
																													Line:   103,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 45,
																													Line:   103,
																												},
																												File:   "pagerduty.flux",
																												Source: "timestamp",
																												Start: ast.Position{
																													Column: 36,
																													Line:   103,
																												},
																											},
																										},
																										Name: "timestamp",
																									},
																									Rbrack: nil,
																								},
																							}},
																							Rbrace: nil,
																							With:   nil,
																						}},
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 18,
																									Line:   104,
																								},
																								File:   "pagerduty.flux",
																								Source: "sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                )",
																								Start: ast.Position{
																									Column: 55,
																									Line:   92,
																								},
																							},
																						},
																						Callee: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 64,
																										Line:   92,
																									},
																									File:   "pagerduty.flux",
																									Source: "sendEvent",
																									Start: ast.Position{
																										Column: 55,
																										Line:   92,
																									},
																								},
																							},
																							Name: "sendEvent",
																						},
																						Lparen: nil,
																						Rparen: nil,
																					},
																					Operator: 2,
																					Right: &ast.IntegerLiteral{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 24,
																									Line:   104,
																								},
																								File:   "pagerduty.flux",
																								Source: "100",
																								Start: ast.Position{
																									Column: 21,
																									Line:   104,
																								},
																							},
																						},
																						Value: int64(100),
																					},
																				},
																				Lparen: nil,
																				Rparen: nil,
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   104,
																		},
																		File:   "pagerduty.flux",
																		Source: "string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))",
																		Start: ast.Position{
																			Column: 39,
																			Line:   92,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   92,
																			},
																			File:   "pagerduty.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 39,
																				Line:   92,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   92,
																	},
																	File:   "pagerduty.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   92,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   104,
															},
															File:   "pagerduty.flux",
															Source: "return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}",
															Start: ast.Position{
																Column: 17,
																Line:   92,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   89,
														},
														File:   "pagerduty.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   89,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   89,
															},
															File:   "pagerduty.flux",
															Source: "r",
															Start: ast.Position{
																Column: 25,
																Line:   89,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   105,
										},
										File:   "pagerduty.flux",
										Source: "map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
										Start: ast.Position{
											Column: 16,
											Line:   89,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   89,
											},
											File:   "pagerduty.flux",
											Source: "map",
											Start: ast.Position{
												Column: 16,
												Line:   89,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   87,
									},
									File:   "pagerduty.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 10,
										Line:   87,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   87,
										},
										File:   "pagerduty.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 10,
											Line:   87,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   87,
									},
									File:   "pagerduty.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 17,
										Line:   87,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   86,
								},
								File:   "pagerduty.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 6,
									Line:   86,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   86,
									},
									File:   "pagerduty.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 6,
										Line:   86,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   85,
							},
							File:   "pagerduty.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   85,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   85,
								},
								File:   "pagerduty.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   85,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   85,
								},
								File:   "pagerduty.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   85,
								},
							},
						},
						Name: "defaultURL",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   3,
					},
					File:   "pagerduty.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   3,
						},
						File:   "pagerduty.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "pagerduty.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "pagerduty.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "json",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "pagerduty.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "pagerduty.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "pagerduty.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "pagerduty.flux",
					Source: "package pagerduty",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "pagerduty.flux",
						Source: "pagerduty",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pagerduty",
			},
		},
	}},
	Package: "pagerduty",
	Path:    "pagerduty",
}
