// DO NOT EDIT: This file is autogenerated via the builtin command.

package pushbullet

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   79,
				},
				File:   "pushbullet.flux",
				Source: "package pushbullet\n\n\nimport \"http\"\nimport \"json\"\n\noption defaultURL = \"https://api.pushbullet.com/v2/pushes\"\n\n// `pushData` sends a push notification using PushBullet's APIs.\n// `url` - string - URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n// `token` - string - the api token string.  Defaults to: \"\".\n// `data` - object - The data to send to the endpoint. It will be encoded in JSON and sent to PushBullet's endpoint.\n// For how to structure data, see https://docs.pushbullet.com/#create-push.\npushData = (url=defaultURL, token=\"\", data) => {\n    headers = {\n        \"Access-Token\": token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url, data: enc)\n}\n\n// `pushNote` sends a push notification of type `note` using PushBullet's APIs.\n// `url` - string - URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n// `token` - string - the api token string.  Defaults to: \"\".\n// `title` - string - The title of the notification.\n// `text` - string - The text to display in the notification.\npushNote = (url=defaultURL, token=\"\", title, text) => {\n    data = {\n        type: \"note\",\n        title: title,\n        body: text,\n    }\n\n    return pushData(token: token, url: url, data: data)\n}\n\n// `genericEndpoint` does not work for now for a bug in type inference in the compiler.\n//    `genericEndpoint` creates the endpoint for the PushBullet external service.\n//    `url` - string - URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n//    `token` - string - token for the PushBullet endpoint.\n//    The returned factory function accepts a `mapFn` parameter.\n//    The `mapFn` must return an object that will be used as payload as defined in `pushData` function arguments.\n// genericEndpoint = (url=defaultURL, token=\"\") =>\n//     (mapFn) =>\n//         (tables=<-) => tables\n//             |> map(fn: (r) => {\n//                 obj = mapFn(r: r)\n//                 return {r with _sent: string(v: 2 == pushData(\n//                   url: url,\n//                   token: token,\n//                   data: obj,\n//                 ) / 100)}\n//             })\n// `endpoint` creates the endpoint for the PushBullet external service.\n// It will push notifications of type `note`.\n// If you want to push something else, see `genericEndpoint`.\n// `url` - string - URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n// `token` - string - token for the PushBullet endpoint.\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with `title` and `text` fields as defined in the `pushNote` function arguments.\nendpoint = (url=defaultURL, token=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 59,
							Line:   7,
						},
						File:   "pushbullet.flux",
						Source: "defaultURL = \"https://api.pushbullet.com/v2/pushes\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   7,
							},
							File:   "pushbullet.flux",
							Source: "defaultURL",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "defaultURL",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   7,
							},
							File:   "pushbullet.flux",
							Source: "\"https://api.pushbullet.com/v2/pushes\"",
							Start: ast.Position{
								Column: 21,
								Line:   7,
							},
						},
					},
					Value: "https://api.pushbullet.com/v2/pushes",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 59,
						Line:   7,
					},
					File:   "pushbullet.flux",
					Source: "option defaultURL = \"https://api.pushbullet.com/v2/pushes\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   22,
					},
					File:   "pushbullet.flux",
					Source: "pushData = (url=defaultURL, token=\"\", data) => {\n    headers = {\n        \"Access-Token\": token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url, data: enc)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `pushData` sends a push notification using PushBullet's APIs.\n"}, ast.Comment{Text: "// `url` - string - URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n"}, ast.Comment{Text: "// `token` - string - the api token string.  Defaults to: \"\".\n"}, ast.Comment{Text: "// `data` - object - The data to send to the endpoint. It will be encoded in JSON and sent to PushBullet's endpoint.\n"}, ast.Comment{Text: "// For how to structure data, see https://docs.pushbullet.com/#create-push.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   14,
						},
						File:   "pushbullet.flux",
						Source: "pushData",
						Start: ast.Position{
							Column: 1,
							Line:   14,
						},
					},
				},
				Name: "pushData",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   22,
						},
						File:   "pushbullet.flux",
						Source: "(url=defaultURL, token=\"\", data) => {\n    headers = {\n        \"Access-Token\": token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url, data: enc)\n}",
						Start: ast.Position{
							Column: 12,
							Line:   14,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   22,
							},
							File:   "pushbullet.flux",
							Source: "{\n    headers = {\n        \"Access-Token\": token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url, data: enc)\n}",
							Start: ast.Position{
								Column: 48,
								Line:   14,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   18,
								},
								File:   "pushbullet.flux",
								Source: "headers = {\n        \"Access-Token\": token,\n        \"Content-Type\": \"application/json\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   15,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   15,
									},
									File:   "pushbullet.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   15,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   18,
									},
									File:   "pushbullet.flux",
									Source: "{\n        \"Access-Token\": token,\n        \"Content-Type\": \"application/json\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   15,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   16,
										},
										File:   "pushbullet.flux",
										Source: "\"Access-Token\": token",
										Start: ast.Position{
											Column: 9,
											Line:   16,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   16,
											},
											File:   "pushbullet.flux",
											Source: "\"Access-Token\"",
											Start: ast.Position{
												Column: 9,
												Line:   16,
											},
										},
									},
									Value: "Access-Token",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   16,
											},
											File:   "pushbullet.flux",
											Source: "token",
											Start: ast.Position{
												Column: 25,
												Line:   16,
											},
										},
									},
									Name: "token",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   17,
										},
										File:   "pushbullet.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 9,
											Line:   17,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   17,
											},
											File:   "pushbullet.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   17,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   17,
											},
											File:   "pushbullet.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 25,
												Line:   17,
											},
										},
									},
									Value: "application/json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   19,
								},
								File:   "pushbullet.flux",
								Source: "enc = json.encode(v: data)",
								Start: ast.Position{
									Column: 5,
									Line:   19,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   19,
									},
									File:   "pushbullet.flux",
									Source: "enc",
									Start: ast.Position{
										Column: 5,
										Line:   19,
									},
								},
							},
							Name: "enc",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   19,
										},
										File:   "pushbullet.flux",
										Source: "v: data",
										Start: ast.Position{
											Column: 23,
											Line:   19,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   19,
											},
											File:   "pushbullet.flux",
											Source: "v: data",
											Start: ast.Position{
												Column: 23,
												Line:   19,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   19,
												},
												File:   "pushbullet.flux",
												Source: "v",
												Start: ast.Position{
													Column: 23,
													Line:   19,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   19,
												},
												File:   "pushbullet.flux",
												Source: "data",
												Start: ast.Position{
													Column: 26,
													Line:   19,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   19,
									},
									File:   "pushbullet.flux",
									Source: "json.encode(v: data)",
									Start: ast.Position{
										Column: 11,
										Line:   19,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   19,
										},
										File:   "pushbullet.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 11,
											Line:   19,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   19,
											},
											File:   "pushbullet.flux",
											Source: "json",
											Start: ast.Position{
												Column: 11,
												Line:   19,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   19,
											},
											File:   "pushbullet.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 16,
												Line:   19,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   21,
										},
										File:   "pushbullet.flux",
										Source: "headers: headers, url: url, data: enc",
										Start: ast.Position{
											Column: 22,
											Line:   21,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   21,
											},
											File:   "pushbullet.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   21,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   21,
												},
												File:   "pushbullet.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   21,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   21,
												},
												File:   "pushbullet.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   21,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   21,
											},
											File:   "pushbullet.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 40,
												Line:   21,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   21,
												},
												File:   "pushbullet.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   21,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   21,
												},
												File:   "pushbullet.flux",
												Source: "url",
												Start: ast.Position{
													Column: 45,
													Line:   21,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   21,
											},
											File:   "pushbullet.flux",
											Source: "data: enc",
											Start: ast.Position{
												Column: 50,
												Line:   21,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   21,
												},
												File:   "pushbullet.flux",
												Source: "data",
												Start: ast.Position{
													Column: 50,
													Line:   21,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   21,
												},
												File:   "pushbullet.flux",
												Source: "enc",
												Start: ast.Position{
													Column: 56,
													Line:   21,
												},
											},
										},
										Name: "enc",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   21,
									},
									File:   "pushbullet.flux",
									Source: "http.post(headers: headers, url: url, data: enc)",
									Start: ast.Position{
										Column: 12,
										Line:   21,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   21,
										},
										File:   "pushbullet.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   21,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   21,
											},
											File:   "pushbullet.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   21,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   21,
											},
											File:   "pushbullet.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   21,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   21,
								},
								File:   "pushbullet.flux",
								Source: "return http.post(headers: headers, url: url, data: enc)",
								Start: ast.Position{
									Column: 5,
									Line:   21,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   14,
							},
							File:   "pushbullet.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   14,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   14,
								},
								File:   "pushbullet.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   14,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   14,
								},
								File:   "pushbullet.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   14,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   14,
							},
							File:   "pushbullet.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 29,
								Line:   14,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   14,
								},
								File:   "pushbullet.flux",
								Source: "token",
								Start: ast.Position{
									Column: 29,
									Line:   14,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   14,
								},
								File:   "pushbullet.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 35,
									Line:   14,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   14,
							},
							File:   "pushbullet.flux",
							Source: "data",
							Start: ast.Position{
								Column: 39,
								Line:   14,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   14,
								},
								File:   "pushbullet.flux",
								Source: "data",
								Start: ast.Position{
									Column: 39,
									Line:   14,
								},
							},
						},
						Name: "data",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   37,
					},
					File:   "pushbullet.flux",
					Source: "pushNote = (url=defaultURL, token=\"\", title, text) => {\n    data = {\n        type: \"note\",\n        title: title,\n        body: text,\n    }\n\n    return pushData(token: token, url: url, data: data)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   29,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `pushNote` sends a push notification of type `note` using PushBullet's APIs.\n"}, ast.Comment{Text: "// `url` - string - URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n"}, ast.Comment{Text: "// `token` - string - the api token string.  Defaults to: \"\".\n"}, ast.Comment{Text: "// `title` - string - The title of the notification.\n"}, ast.Comment{Text: "// `text` - string - The text to display in the notification.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   29,
						},
						File:   "pushbullet.flux",
						Source: "pushNote",
						Start: ast.Position{
							Column: 1,
							Line:   29,
						},
					},
				},
				Name: "pushNote",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   37,
						},
						File:   "pushbullet.flux",
						Source: "(url=defaultURL, token=\"\", title, text) => {\n    data = {\n        type: \"note\",\n        title: title,\n        body: text,\n    }\n\n    return pushData(token: token, url: url, data: data)\n}",
						Start: ast.Position{
							Column: 12,
							Line:   29,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   37,
							},
							File:   "pushbullet.flux",
							Source: "{\n    data = {\n        type: \"note\",\n        title: title,\n        body: text,\n    }\n\n    return pushData(token: token, url: url, data: data)\n}",
							Start: ast.Position{
								Column: 55,
								Line:   29,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   34,
								},
								File:   "pushbullet.flux",
								Source: "data = {\n        type: \"note\",\n        title: title,\n        body: text,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   30,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   30,
									},
									File:   "pushbullet.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   30,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   34,
									},
									File:   "pushbullet.flux",
									Source: "{\n        type: \"note\",\n        title: title,\n        body: text,\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   30,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   31,
										},
										File:   "pushbullet.flux",
										Source: "type: \"note\"",
										Start: ast.Position{
											Column: 9,
											Line:   31,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   31,
											},
											File:   "pushbullet.flux",
											Source: "type",
											Start: ast.Position{
												Column: 9,
												Line:   31,
											},
										},
									},
									Name: "type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   31,
											},
											File:   "pushbullet.flux",
											Source: "\"note\"",
											Start: ast.Position{
												Column: 15,
												Line:   31,
											},
										},
									},
									Value: "note",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   32,
										},
										File:   "pushbullet.flux",
										Source: "title: title",
										Start: ast.Position{
											Column: 9,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   32,
											},
											File:   "pushbullet.flux",
											Source: "title",
											Start: ast.Position{
												Column: 9,
												Line:   32,
											},
										},
									},
									Name: "title",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   32,
											},
											File:   "pushbullet.flux",
											Source: "title",
											Start: ast.Position{
												Column: 16,
												Line:   32,
											},
										},
									},
									Name: "title",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   33,
										},
										File:   "pushbullet.flux",
										Source: "body: text",
										Start: ast.Position{
											Column: 9,
											Line:   33,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   33,
											},
											File:   "pushbullet.flux",
											Source: "body",
											Start: ast.Position{
												Column: 9,
												Line:   33,
											},
										},
									},
									Name: "body",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   33,
											},
											File:   "pushbullet.flux",
											Source: "text",
											Start: ast.Position{
												Column: 15,
												Line:   33,
											},
										},
									},
									Name: "text",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   36,
										},
										File:   "pushbullet.flux",
										Source: "token: token, url: url, data: data",
										Start: ast.Position{
											Column: 21,
											Line:   36,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   36,
											},
											File:   "pushbullet.flux",
											Source: "token: token",
											Start: ast.Position{
												Column: 21,
												Line:   36,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   36,
												},
												File:   "pushbullet.flux",
												Source: "token",
												Start: ast.Position{
													Column: 21,
													Line:   36,
												},
											},
										},
										Name: "token",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   36,
												},
												File:   "pushbullet.flux",
												Source: "token",
												Start: ast.Position{
													Column: 28,
													Line:   36,
												},
											},
										},
										Name: "token",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   36,
											},
											File:   "pushbullet.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 35,
												Line:   36,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   36,
												},
												File:   "pushbullet.flux",
												Source: "url",
												Start: ast.Position{
													Column: 35,
													Line:   36,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   36,
												},
												File:   "pushbullet.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   36,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   36,
											},
											File:   "pushbullet.flux",
											Source: "data: data",
											Start: ast.Position{
												Column: 45,
												Line:   36,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   36,
												},
												File:   "pushbullet.flux",
												Source: "data",
												Start: ast.Position{
													Column: 45,
													Line:   36,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   36,
												},
												File:   "pushbullet.flux",
												Source: "data",
												Start: ast.Position{
													Column: 51,
													Line:   36,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   36,
									},
									File:   "pushbullet.flux",
									Source: "pushData(token: token, url: url, data: data)",
									Start: ast.Position{
										Column: 12,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   36,
										},
										File:   "pushbullet.flux",
										Source: "pushData",
										Start: ast.Position{
											Column: 12,
											Line:   36,
										},
									},
								},
								Name: "pushData",
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   36,
								},
								File:   "pushbullet.flux",
								Source: "return pushData(token: token, url: url, data: data)",
								Start: ast.Position{
									Column: 5,
									Line:   36,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   29,
							},
							File:   "pushbullet.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   29,
								},
								File:   "pushbullet.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   29,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   29,
								},
								File:   "pushbullet.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   29,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   29,
							},
							File:   "pushbullet.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 29,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   29,
								},
								File:   "pushbullet.flux",
								Source: "token",
								Start: ast.Position{
									Column: 29,
									Line:   29,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   29,
								},
								File:   "pushbullet.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 35,
									Line:   29,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   29,
							},
							File:   "pushbullet.flux",
							Source: "title",
							Start: ast.Position{
								Column: 39,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   29,
								},
								File:   "pushbullet.flux",
								Source: "title",
								Start: ast.Position{
									Column: 39,
									Line:   29,
								},
							},
						},
						Name: "title",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   29,
							},
							File:   "pushbullet.flux",
							Source: "text",
							Start: ast.Position{
								Column: 46,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   29,
								},
								File:   "pushbullet.flux",
								Source: "text",
								Start: ast.Position{
									Column: 46,
									Line:   29,
								},
							},
						},
						Name: "text",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   79,
					},
					File:   "pushbullet.flux",
					Source: "endpoint = (url=defaultURL, token=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   63,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `genericEndpoint` does not work for now for a bug in type inference in the compiler.\n"}, ast.Comment{Text: "//    `genericEndpoint` creates the endpoint for the PushBullet external service.\n"}, ast.Comment{Text: "//    `url` - string - URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n"}, ast.Comment{Text: "//    `token` - string - token for the PushBullet endpoint.\n"}, ast.Comment{Text: "//    The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "//    The `mapFn` must return an object that will be used as payload as defined in `pushData` function arguments.\n"}, ast.Comment{Text: "// genericEndpoint = (url=defaultURL, token=\"\") =>\n"}, ast.Comment{Text: "//     (mapFn) =>\n"}, ast.Comment{Text: "//         (tables=<-) => tables\n"}, ast.Comment{Text: "//             |> map(fn: (r) => {\n"}, ast.Comment{Text: "//                 obj = mapFn(r: r)\n"}, ast.Comment{Text: "//                 return {r with _sent: string(v: 2 == pushData(\n"}, ast.Comment{Text: "//                   url: url,\n"}, ast.Comment{Text: "//                   token: token,\n"}, ast.Comment{Text: "//                   data: obj,\n"}, ast.Comment{Text: "//                 ) / 100)}\n"}, ast.Comment{Text: "//             })\n"}, ast.Comment{Text: "// `endpoint` creates the endpoint for the PushBullet external service.\n"}, ast.Comment{Text: "// It will push notifications of type `note`.\n"}, ast.Comment{Text: "// If you want to push something else, see `genericEndpoint`.\n"}, ast.Comment{Text: "// `url` - string - URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n"}, ast.Comment{Text: "// `token` - string - token for the PushBullet endpoint.\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return an object with `title` and `text` fields as defined in the `pushNote` function arguments.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   63,
						},
						File:   "pushbullet.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   63,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   79,
						},
						File:   "pushbullet.flux",
						Source: "(url=defaultURL, token=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   63,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   79,
							},
							File:   "pushbullet.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 42,
								Line:   63,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   79,
								},
								File:   "pushbullet.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 53,
									Line:   63,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   63,
										},
										File:   "pushbullet.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 68,
											Line:   63,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   79,
									},
									File:   "pushbullet.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 68,
										Line:   63,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   78,
											},
											File:   "pushbullet.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   65,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   78,
												},
												File:   "pushbullet.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   65,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   65,
													},
													File:   "pushbullet.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   65,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   78,
													},
													File:   "pushbullet.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   65,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   78,
														},
														File:   "pushbullet.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   65,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   66,
															},
															File:   "pushbullet.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   66,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   66,
																},
																File:   "pushbullet.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   66,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   66,
																	},
																	File:   "pushbullet.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   66,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   66,
																		},
																		File:   "pushbullet.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   66,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   66,
																			},
																			File:   "pushbullet.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   66,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   66,
																			},
																			File:   "pushbullet.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   66,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   66,
																},
																File:   "pushbullet.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   66,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   66,
																	},
																	File:   "pushbullet.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   66,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   77,
																},
																File:   "pushbullet.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   68,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   76,
																	},
																	File:   "pushbullet.flux",
																	Source: "_sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   69,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   69,
																		},
																		File:   "pushbullet.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   69,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   75,
																			},
																			File:   "pushbullet.flux",
																			Source: "v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   70,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   75,
																				},
																				File:   "pushbullet.flux",
																				Source: "v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   70,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   70,
																					},
																					File:   "pushbullet.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   70,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   75,
																					},
																					File:   "pushbullet.flux",
																					Source: "2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   70,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   70,
																						},
																						File:   "pushbullet.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   70,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   75,
																						},
																						File:   "pushbullet.flux",
																						Source: "pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   70,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 39,
																									Line:   74,
																								},
																								File:   "pushbullet.flux",
																								Source: "url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text",
																								Start: ast.Position{
																									Column: 25,
																									Line:   71,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   71,
																									},
																									File:   "pushbullet.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   71,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   71,
																										},
																										File:   "pushbullet.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 25,
																											Line:   71,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   71,
																										},
																										File:   "pushbullet.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 30,
																											Line:   71,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 37,
																										Line:   72,
																									},
																									File:   "pushbullet.flux",
																									Source: "token: token",
																									Start: ast.Position{
																										Column: 25,
																										Line:   72,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   72,
																										},
																										File:   "pushbullet.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 25,
																											Line:   72,
																										},
																									},
																								},
																								Name: "token",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   72,
																										},
																										File:   "pushbullet.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 32,
																											Line:   72,
																										},
																									},
																								},
																								Name: "token",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   73,
																									},
																									File:   "pushbullet.flux",
																									Source: "title: obj.title",
																									Start: ast.Position{
																										Column: 25,
																										Line:   73,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   73,
																										},
																										File:   "pushbullet.flux",
																										Source: "title",
																										Start: ast.Position{
																											Column: 25,
																											Line:   73,
																										},
																									},
																								},
																								Name: "title",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   73,
																										},
																										File:   "pushbullet.flux",
																										Source: "obj.title",
																										Start: ast.Position{
																											Column: 32,
																											Line:   73,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   73,
																											},
																											File:   "pushbullet.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   73,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   73,
																											},
																											File:   "pushbullet.flux",
																											Source: "title",
																											Start: ast.Position{
																												Column: 36,
																												Line:   73,
																											},
																										},
																									},
																									Name: "title",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   74,
																									},
																									File:   "pushbullet.flux",
																									Source: "text: obj.text",
																									Start: ast.Position{
																										Column: 25,
																										Line:   74,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   74,
																										},
																										File:   "pushbullet.flux",
																										Source: "text",
																										Start: ast.Position{
																											Column: 25,
																											Line:   74,
																										},
																									},
																								},
																								Name: "text",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   74,
																										},
																										File:   "pushbullet.flux",
																										Source: "obj.text",
																										Start: ast.Position{
																											Column: 31,
																											Line:   74,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 34,
																												Line:   74,
																											},
																											File:   "pushbullet.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 31,
																												Line:   74,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   74,
																											},
																											File:   "pushbullet.flux",
																											Source: "text",
																											Start: ast.Position{
																												Column: 35,
																												Line:   74,
																											},
																										},
																									},
																									Name: "text",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   75,
																							},
																							File:   "pushbullet.flux",
																							Source: "pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   70,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 37,
																									Line:   70,
																								},
																								File:   "pushbullet.flux",
																								Source: "pushNote",
																								Start: ast.Position{
																									Column: 29,
																									Line:   70,
																								},
																							},
																						},
																						Name: "pushNote",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   75,
																							},
																							File:   "pushbullet.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   75,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   76,
																		},
																		File:   "pushbullet.flux",
																		Source: "string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   69,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   69,
																			},
																			File:   "pushbullet.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   69,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   68,
																	},
																	File:   "pushbullet.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   68,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   77,
															},
															File:   "pushbullet.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   68,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   65,
														},
														File:   "pushbullet.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   65,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   65,
															},
															File:   "pushbullet.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   65,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   79,
										},
										File:   "pushbullet.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   64,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   64,
											},
											File:   "pushbullet.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   64,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   63,
									},
									File:   "pushbullet.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 54,
										Line:   63,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   63,
										},
										File:   "pushbullet.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 54,
											Line:   63,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   63,
									},
									File:   "pushbullet.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 61,
										Line:   63,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   63,
								},
								File:   "pushbullet.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 43,
									Line:   63,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   63,
									},
									File:   "pushbullet.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 43,
										Line:   63,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   63,
							},
							File:   "pushbullet.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   63,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   63,
								},
								File:   "pushbullet.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   63,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   63,
								},
								File:   "pushbullet.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   63,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   63,
							},
							File:   "pushbullet.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 29,
								Line:   63,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   63,
								},
								File:   "pushbullet.flux",
								Source: "token",
								Start: ast.Position{
									Column: 29,
									Line:   63,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   63,
								},
								File:   "pushbullet.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 35,
									Line:   63,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "pushbullet.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "pushbullet.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "pushbullet.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "pushbullet.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "pushbullet.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   1,
					},
					File:   "pushbullet.flux",
					Source: "package pushbullet",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   1,
						},
						File:   "pushbullet.flux",
						Source: "pushbullet",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pushbullet",
			},
		},
	}},
	Package: "pushbullet",
	Path:    "pushbullet",
}
