package costmanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// AlertsClient is the client for the Alerts methods of the Costmanagement service.
type AlertsClient struct {
	BaseClient
}

// NewAlertsClient creates an instance of the AlertsClient client.
func NewAlertsClient(subscriptionID string) AlertsClient {
	return NewAlertsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewAlertsClientWithBaseURI creates an instance of the AlertsClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewAlertsClientWithBaseURI(baseURI string, subscriptionID string) AlertsClient {
	return AlertsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// GetAlertByManagementGroups gets an alert for Management Groups by alert ID.
// Parameters:
// managementGroupID - management Group ID
// alertID - alert ID.
func (client AlertsClient) GetAlertByManagementGroups(ctx context.Context, managementGroupID string, alertID string) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.GetAlertByManagementGroups")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAlertByManagementGroupsPreparer(ctx, managementGroupID, alertID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetAlertByManagementGroups", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAlertByManagementGroupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetAlertByManagementGroups", resp, "Failure sending request")
		return
	}

	result, err = client.GetAlertByManagementGroupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetAlertByManagementGroups", resp, "Failure responding to request")
	}

	return
}

// GetAlertByManagementGroupsPreparer prepares the GetAlertByManagementGroups request.
func (client AlertsClient) GetAlertByManagementGroupsPreparer(ctx context.Context, managementGroupID string, alertID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertId":           autorest.Encode("path", alertID),
		"managementGroupId": autorest.Encode("path", managementGroupID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.CostManagement/alerts/{alertId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAlertByManagementGroupsSender sends the GetAlertByManagementGroups request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) GetAlertByManagementGroupsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAlertByManagementGroupsResponder handles the response to the GetAlertByManagementGroups request. The method always
// closes the http.Response Body.
func (client AlertsClient) GetAlertByManagementGroupsResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByAccount gets the alert for an account by alert ID.
// Parameters:
// billingAccountID - billingAccount ID
// enrollmentAccountID - enrollment Account Id
// alertID - alert ID.
func (client AlertsClient) GetByAccount(ctx context.Context, billingAccountID string, enrollmentAccountID string, alertID string) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.GetByAccount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByAccountPreparer(ctx, billingAccountID, enrollmentAccountID, alertID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetByAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetByAccount", resp, "Failure sending request")
		return
	}

	result, err = client.GetByAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetByAccount", resp, "Failure responding to request")
	}

	return
}

// GetByAccountPreparer prepares the GetByAccount request.
func (client AlertsClient) GetByAccountPreparer(ctx context.Context, billingAccountID string, enrollmentAccountID string, alertID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertId":             autorest.Encode("path", alertID),
		"billingAccountId":    autorest.Encode("path", billingAccountID),
		"enrollmentAccountId": autorest.Encode("path", enrollmentAccountID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}/providers/Microsoft.CostManagement/alerts/{alertId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByAccountSender sends the GetByAccount request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) GetByAccountSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetByAccountResponder handles the response to the GetByAccount request. The method always
// closes the http.Response Body.
func (client AlertsClient) GetByAccountResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByDepartment gets the alert for a department by alert ID.
// Parameters:
// billingAccountID - billingAccount ID
// departmentID - department ID
// alertID - alert ID.
func (client AlertsClient) GetByDepartment(ctx context.Context, billingAccountID string, departmentID string, alertID string) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.GetByDepartment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByDepartmentPreparer(ctx, billingAccountID, departmentID, alertID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetByDepartment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByDepartmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetByDepartment", resp, "Failure sending request")
		return
	}

	result, err = client.GetByDepartmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetByDepartment", resp, "Failure responding to request")
	}

	return
}

// GetByDepartmentPreparer prepares the GetByDepartment request.
func (client AlertsClient) GetByDepartmentPreparer(ctx context.Context, billingAccountID string, departmentID string, alertID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertId":          autorest.Encode("path", alertID),
		"billingAccountId": autorest.Encode("path", billingAccountID),
		"departmentId":     autorest.Encode("path", departmentID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}/providers/Microsoft.CostManagement/alerts/{alertId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByDepartmentSender sends the GetByDepartment request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) GetByDepartmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetByDepartmentResponder handles the response to the GetByDepartment request. The method always
// closes the http.Response Body.
func (client AlertsClient) GetByDepartmentResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByEnrollment gets the alert for an enrollment by alert ID.
// Parameters:
// billingAccountID - billingAccount ID
// alertID - alert ID.
func (client AlertsClient) GetByEnrollment(ctx context.Context, billingAccountID string, alertID string) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.GetByEnrollment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByEnrollmentPreparer(ctx, billingAccountID, alertID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetByEnrollment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByEnrollmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetByEnrollment", resp, "Failure sending request")
		return
	}

	result, err = client.GetByEnrollmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetByEnrollment", resp, "Failure responding to request")
	}

	return
}

// GetByEnrollmentPreparer prepares the GetByEnrollment request.
func (client AlertsClient) GetByEnrollmentPreparer(ctx context.Context, billingAccountID string, alertID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertId":          autorest.Encode("path", alertID),
		"billingAccountId": autorest.Encode("path", billingAccountID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/alerts/{alertId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByEnrollmentSender sends the GetByEnrollment request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) GetByEnrollmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetByEnrollmentResponder handles the response to the GetByEnrollment request. The method always
// closes the http.Response Body.
func (client AlertsClient) GetByEnrollmentResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByResourceGroupName gets the alert for a resource group under a subscription by alert ID.
// Parameters:
// resourceGroupName - azure Resource Group Name.
// alertID - alert ID.
func (client AlertsClient) GetByResourceGroupName(ctx context.Context, resourceGroupName string, alertID string) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.GetByResourceGroupName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByResourceGroupNamePreparer(ctx, resourceGroupName, alertID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetByResourceGroupName", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByResourceGroupNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetByResourceGroupName", resp, "Failure sending request")
		return
	}

	result, err = client.GetByResourceGroupNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetByResourceGroupName", resp, "Failure responding to request")
	}

	return
}

// GetByResourceGroupNamePreparer prepares the GetByResourceGroupName request.
func (client AlertsClient) GetByResourceGroupNamePreparer(ctx context.Context, resourceGroupName string, alertID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertId":           autorest.Encode("path", alertID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CostManagement/alerts/{alertId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByResourceGroupNameSender sends the GetByResourceGroupName request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) GetByResourceGroupNameSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetByResourceGroupNameResponder handles the response to the GetByResourceGroupName request. The method always
// closes the http.Response Body.
func (client AlertsClient) GetByResourceGroupNameResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBySubscription gets the alert for a subscription by alert ID.
// Parameters:
// alertID - alert ID.
func (client AlertsClient) GetBySubscription(ctx context.Context, alertID string) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.GetBySubscription")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetBySubscriptionPreparer(ctx, alertID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetBySubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetBySubscription", resp, "Failure sending request")
		return
	}

	result, err = client.GetBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "GetBySubscription", resp, "Failure responding to request")
	}

	return
}

// GetBySubscriptionPreparer prepares the GetBySubscription request.
func (client AlertsClient) GetBySubscriptionPreparer(ctx context.Context, alertID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertId":        autorest.Encode("path", alertID),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CostManagement/alerts/{alertId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetBySubscriptionSender sends the GetBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) GetBySubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetBySubscriptionResponder handles the response to the GetBySubscription request. The method always
// closes the http.Response Body.
func (client AlertsClient) GetBySubscriptionResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List list all alerts for a subscription.
// Parameters:
// filter - may be used to filter alerts by properties/definition/type, properties/definition/category,
// properties/definition/criteria, properties/costEntityId, properties/creationTime, properties/closeTime,
// properties/status, properties/source. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
// skiptoken - skiptoken is only used if a previous operation returned a partial result. If a previous response
// contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
// specifies a starting point to use for subsequent calls.
// top - may be used to limit the number of results to the most recent N alerts.
func (client AlertsClient) List(ctx context.Context, filter string, skiptoken string, top *int32) (result AlertListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.List")
		defer func() {
			sc := -1
			if result.alr.Response.Response != nil {
				sc = result.alr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMaximum, Rule: int64(1000), Chain: nil},
					{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("costmanagement.AlertsClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, filter, skiptoken, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.alr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "List", resp, "Failure sending request")
		return
	}

	result.alr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "List", resp, "Failure responding to request")
	}
	if result.alr.hasNextLink() && result.alr.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListPreparer prepares the List request.
func (client AlertsClient) ListPreparer(ctx context.Context, filter string, skiptoken string, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CostManagement/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AlertsClient) ListResponder(resp *http.Response) (result AlertListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client AlertsClient) listNextResults(ctx context.Context, lastResults AlertListResult) (result AlertListResult, err error) {
	req, err := lastResults.alertListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client AlertsClient) ListComplete(ctx context.Context, filter string, skiptoken string, top *int32) (result AlertListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, filter, skiptoken, top)
	return
}

// ListByAccount list all alerts for an account.
// Parameters:
// billingAccountID - billingAccount ID
// enrollmentAccountID - enrollment Account Id
// filter - may be used to filter alerts by properties/definition/type, properties/definition/category,
// properties/definition/criteria, properties/costEntityId, properties/creationTime, properties/closeTime,
// properties/status, properties/source. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
// skiptoken - skiptoken is only used if a previous operation returned a partial result. If a previous response
// contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
// specifies a starting point to use for subsequent calls.
// top - may be used to limit the number of results to the most recent N alerts.
func (client AlertsClient) ListByAccount(ctx context.Context, billingAccountID string, enrollmentAccountID string, filter string, skiptoken string, top *int32) (result AlertListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListByAccount")
		defer func() {
			sc := -1
			if result.alr.Response.Response != nil {
				sc = result.alr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMaximum, Rule: int64(1000), Chain: nil},
					{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("costmanagement.AlertsClient", "ListByAccount", err.Error())
	}

	result.fn = client.listByAccountNextResults
	req, err := client.ListByAccountPreparer(ctx, billingAccountID, enrollmentAccountID, filter, skiptoken, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByAccountSender(req)
	if err != nil {
		result.alr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByAccount", resp, "Failure sending request")
		return
	}

	result.alr, err = client.ListByAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByAccount", resp, "Failure responding to request")
	}
	if result.alr.hasNextLink() && result.alr.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListByAccountPreparer prepares the ListByAccount request.
func (client AlertsClient) ListByAccountPreparer(ctx context.Context, billingAccountID string, enrollmentAccountID string, filter string, skiptoken string, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId":    autorest.Encode("path", billingAccountID),
		"enrollmentAccountId": autorest.Encode("path", enrollmentAccountID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}/providers/Microsoft.CostManagement/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByAccountSender sends the ListByAccount request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) ListByAccountSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListByAccountResponder handles the response to the ListByAccount request. The method always
// closes the http.Response Body.
func (client AlertsClient) ListByAccountResponder(resp *http.Response) (result AlertListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByAccountNextResults retrieves the next set of results, if any.
func (client AlertsClient) listByAccountNextResults(ctx context.Context, lastResults AlertListResult) (result AlertListResult, err error) {
	req, err := lastResults.alertListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByAccountNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByAccountNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByAccountNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByAccountComplete enumerates all values, automatically crossing page boundaries as required.
func (client AlertsClient) ListByAccountComplete(ctx context.Context, billingAccountID string, enrollmentAccountID string, filter string, skiptoken string, top *int32) (result AlertListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListByAccount")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByAccount(ctx, billingAccountID, enrollmentAccountID, filter, skiptoken, top)
	return
}

// ListByDepartment list all alerts for a department.
// Parameters:
// billingAccountID - billingAccount ID
// departmentID - department ID
// filter - may be used to filter alerts by properties/definition/type, properties/definition/category,
// properties/definition/criteria, properties/costEntityId, properties/creationTime, properties/closeTime,
// properties/status, properties/source. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
// skiptoken - skiptoken is only used if a previous operation returned a partial result. If a previous response
// contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
// specifies a starting point to use for subsequent calls.
// top - may be used to limit the number of results to the most recent N alerts.
func (client AlertsClient) ListByDepartment(ctx context.Context, billingAccountID string, departmentID string, filter string, skiptoken string, top *int32) (result AlertListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListByDepartment")
		defer func() {
			sc := -1
			if result.alr.Response.Response != nil {
				sc = result.alr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMaximum, Rule: int64(1000), Chain: nil},
					{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("costmanagement.AlertsClient", "ListByDepartment", err.Error())
	}

	result.fn = client.listByDepartmentNextResults
	req, err := client.ListByDepartmentPreparer(ctx, billingAccountID, departmentID, filter, skiptoken, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByDepartment", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByDepartmentSender(req)
	if err != nil {
		result.alr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByDepartment", resp, "Failure sending request")
		return
	}

	result.alr, err = client.ListByDepartmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByDepartment", resp, "Failure responding to request")
	}
	if result.alr.hasNextLink() && result.alr.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListByDepartmentPreparer prepares the ListByDepartment request.
func (client AlertsClient) ListByDepartmentPreparer(ctx context.Context, billingAccountID string, departmentID string, filter string, skiptoken string, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
		"departmentId":     autorest.Encode("path", departmentID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}/providers/Microsoft.CostManagement/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByDepartmentSender sends the ListByDepartment request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) ListByDepartmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListByDepartmentResponder handles the response to the ListByDepartment request. The method always
// closes the http.Response Body.
func (client AlertsClient) ListByDepartmentResponder(resp *http.Response) (result AlertListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByDepartmentNextResults retrieves the next set of results, if any.
func (client AlertsClient) listByDepartmentNextResults(ctx context.Context, lastResults AlertListResult) (result AlertListResult, err error) {
	req, err := lastResults.alertListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByDepartmentNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByDepartmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByDepartmentNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByDepartmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByDepartmentNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByDepartmentComplete enumerates all values, automatically crossing page boundaries as required.
func (client AlertsClient) ListByDepartmentComplete(ctx context.Context, billingAccountID string, departmentID string, filter string, skiptoken string, top *int32) (result AlertListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListByDepartment")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByDepartment(ctx, billingAccountID, departmentID, filter, skiptoken, top)
	return
}

// ListByEnrollment list all alerts for an enrollment.
// Parameters:
// billingAccountID - billingAccount ID
// filter - may be used to filter alerts by properties/definition/type, properties/definition/category,
// properties/definition/criteria, properties/costEntityId, properties/creationTime, properties/closeTime,
// properties/status, properties/source. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
// skiptoken - skiptoken is only used if a previous operation returned a partial result. If a previous response
// contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
// specifies a starting point to use for subsequent calls.
// top - may be used to limit the number of results to the most recent N alerts.
func (client AlertsClient) ListByEnrollment(ctx context.Context, billingAccountID string, filter string, skiptoken string, top *int32) (result AlertListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListByEnrollment")
		defer func() {
			sc := -1
			if result.alr.Response.Response != nil {
				sc = result.alr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMaximum, Rule: int64(1000), Chain: nil},
					{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("costmanagement.AlertsClient", "ListByEnrollment", err.Error())
	}

	result.fn = client.listByEnrollmentNextResults
	req, err := client.ListByEnrollmentPreparer(ctx, billingAccountID, filter, skiptoken, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByEnrollment", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByEnrollmentSender(req)
	if err != nil {
		result.alr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByEnrollment", resp, "Failure sending request")
		return
	}

	result.alr, err = client.ListByEnrollmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByEnrollment", resp, "Failure responding to request")
	}
	if result.alr.hasNextLink() && result.alr.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListByEnrollmentPreparer prepares the ListByEnrollment request.
func (client AlertsClient) ListByEnrollmentPreparer(ctx context.Context, billingAccountID string, filter string, skiptoken string, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByEnrollmentSender sends the ListByEnrollment request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) ListByEnrollmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListByEnrollmentResponder handles the response to the ListByEnrollment request. The method always
// closes the http.Response Body.
func (client AlertsClient) ListByEnrollmentResponder(resp *http.Response) (result AlertListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByEnrollmentNextResults retrieves the next set of results, if any.
func (client AlertsClient) listByEnrollmentNextResults(ctx context.Context, lastResults AlertListResult) (result AlertListResult, err error) {
	req, err := lastResults.alertListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByEnrollmentNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByEnrollmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByEnrollmentNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByEnrollmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByEnrollmentNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByEnrollmentComplete enumerates all values, automatically crossing page boundaries as required.
func (client AlertsClient) ListByEnrollmentComplete(ctx context.Context, billingAccountID string, filter string, skiptoken string, top *int32) (result AlertListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListByEnrollment")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByEnrollment(ctx, billingAccountID, filter, skiptoken, top)
	return
}

// ListByManagementGroups list all alerts for Management Groups.
// Parameters:
// managementGroupID - management Group ID
// filter - may be used to filter alerts by properties/definition/type, properties/definition/category,
// properties/definition/criteria, properties/costEntityId, properties/creationTime, properties/closeTime,
// properties/status, properties/source. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
// skiptoken - skiptoken is only used if a previous operation returned a partial result. If a previous response
// contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
// specifies a starting point to use for subsequent calls.
// top - may be used to limit the number of results to the most recent N alerts.
func (client AlertsClient) ListByManagementGroups(ctx context.Context, managementGroupID string, filter string, skiptoken string, top *int32) (result AlertListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListByManagementGroups")
		defer func() {
			sc := -1
			if result.alr.Response.Response != nil {
				sc = result.alr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMaximum, Rule: int64(1000), Chain: nil},
					{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("costmanagement.AlertsClient", "ListByManagementGroups", err.Error())
	}

	result.fn = client.listByManagementGroupsNextResults
	req, err := client.ListByManagementGroupsPreparer(ctx, managementGroupID, filter, skiptoken, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByManagementGroups", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByManagementGroupsSender(req)
	if err != nil {
		result.alr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByManagementGroups", resp, "Failure sending request")
		return
	}

	result.alr, err = client.ListByManagementGroupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByManagementGroups", resp, "Failure responding to request")
	}
	if result.alr.hasNextLink() && result.alr.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListByManagementGroupsPreparer prepares the ListByManagementGroups request.
func (client AlertsClient) ListByManagementGroupsPreparer(ctx context.Context, managementGroupID string, filter string, skiptoken string, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId": autorest.Encode("path", managementGroupID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.CostManagement/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByManagementGroupsSender sends the ListByManagementGroups request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) ListByManagementGroupsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListByManagementGroupsResponder handles the response to the ListByManagementGroups request. The method always
// closes the http.Response Body.
func (client AlertsClient) ListByManagementGroupsResponder(resp *http.Response) (result AlertListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByManagementGroupsNextResults retrieves the next set of results, if any.
func (client AlertsClient) listByManagementGroupsNextResults(ctx context.Context, lastResults AlertListResult) (result AlertListResult, err error) {
	req, err := lastResults.alertListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByManagementGroupsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByManagementGroupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByManagementGroupsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByManagementGroupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByManagementGroupsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByManagementGroupsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AlertsClient) ListByManagementGroupsComplete(ctx context.Context, managementGroupID string, filter string, skiptoken string, top *int32) (result AlertListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListByManagementGroups")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByManagementGroups(ctx, managementGroupID, filter, skiptoken, top)
	return
}

// ListByResourceGroupName list all alerts for a resource group under a subscription.
// Parameters:
// resourceGroupName - azure Resource Group Name.
// filter - may be used to filter alerts by properties/definition/type, properties/definition/category,
// properties/definition/criteria, properties/costEntityId, properties/creationTime, properties/closeTime,
// properties/status, properties/source. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
// skiptoken - skiptoken is only used if a previous operation returned a partial result. If a previous response
// contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
// specifies a starting point to use for subsequent calls.
// top - may be used to limit the number of results to the most recent N alerts.
func (client AlertsClient) ListByResourceGroupName(ctx context.Context, resourceGroupName string, filter string, skiptoken string, top *int32) (result AlertListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListByResourceGroupName")
		defer func() {
			sc := -1
			if result.alr.Response.Response != nil {
				sc = result.alr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMaximum, Rule: int64(1000), Chain: nil},
					{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("costmanagement.AlertsClient", "ListByResourceGroupName", err.Error())
	}

	result.fn = client.listByResourceGroupNameNextResults
	req, err := client.ListByResourceGroupNamePreparer(ctx, resourceGroupName, filter, skiptoken, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByResourceGroupName", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupNameSender(req)
	if err != nil {
		result.alr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByResourceGroupName", resp, "Failure sending request")
		return
	}

	result.alr, err = client.ListByResourceGroupNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "ListByResourceGroupName", resp, "Failure responding to request")
	}
	if result.alr.hasNextLink() && result.alr.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListByResourceGroupNamePreparer prepares the ListByResourceGroupName request.
func (client AlertsClient) ListByResourceGroupNamePreparer(ctx context.Context, resourceGroupName string, filter string, skiptoken string, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CostManagement/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupNameSender sends the ListByResourceGroupName request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) ListByResourceGroupNameSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupNameResponder handles the response to the ListByResourceGroupName request. The method always
// closes the http.Response Body.
func (client AlertsClient) ListByResourceGroupNameResponder(resp *http.Response) (result AlertListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNameNextResults retrieves the next set of results, if any.
func (client AlertsClient) listByResourceGroupNameNextResults(ctx context.Context, lastResults AlertListResult) (result AlertListResult, err error) {
	req, err := lastResults.alertListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByResourceGroupNameNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByResourceGroupNameNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "listByResourceGroupNameNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupNameComplete enumerates all values, automatically crossing page boundaries as required.
func (client AlertsClient) ListByResourceGroupNameComplete(ctx context.Context, resourceGroupName string, filter string, skiptoken string, top *int32) (result AlertListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListByResourceGroupName")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroupName(ctx, resourceGroupName, filter, skiptoken, top)
	return
}

// UpdateBillingAccountAlertStatus update alerts status for billing account.
// Parameters:
// billingAccountID - billingAccount ID
// alertID - alert ID.
// parameters - parameters supplied to the update alerts status operation.
func (client AlertsClient) UpdateBillingAccountAlertStatus(ctx context.Context, billingAccountID string, alertID string, parameters Alert) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.UpdateBillingAccountAlertStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateBillingAccountAlertStatusPreparer(ctx, billingAccountID, alertID, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateBillingAccountAlertStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateBillingAccountAlertStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateBillingAccountAlertStatus", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateBillingAccountAlertStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateBillingAccountAlertStatus", resp, "Failure responding to request")
	}

	return
}

// UpdateBillingAccountAlertStatusPreparer prepares the UpdateBillingAccountAlertStatus request.
func (client AlertsClient) UpdateBillingAccountAlertStatusPreparer(ctx context.Context, billingAccountID string, alertID string, parameters Alert) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertId":          autorest.Encode("path", alertID),
		"billingAccountId": autorest.Encode("path", billingAccountID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/alerts/{alertId}/updateStatus", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateBillingAccountAlertStatusSender sends the UpdateBillingAccountAlertStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) UpdateBillingAccountAlertStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateBillingAccountAlertStatusResponder handles the response to the UpdateBillingAccountAlertStatus request. The method always
// closes the http.Response Body.
func (client AlertsClient) UpdateBillingAccountAlertStatusResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateDepartmentsAlertStatus update alerts status for a department.
// Parameters:
// billingAccountID - billingAccount ID
// departmentID - department ID
// alertID - alert ID.
// parameters - parameters supplied to the update alerts status operation.
func (client AlertsClient) UpdateDepartmentsAlertStatus(ctx context.Context, billingAccountID string, departmentID string, alertID string, parameters Alert) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.UpdateDepartmentsAlertStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateDepartmentsAlertStatusPreparer(ctx, billingAccountID, departmentID, alertID, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateDepartmentsAlertStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateDepartmentsAlertStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateDepartmentsAlertStatus", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateDepartmentsAlertStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateDepartmentsAlertStatus", resp, "Failure responding to request")
	}

	return
}

// UpdateDepartmentsAlertStatusPreparer prepares the UpdateDepartmentsAlertStatus request.
func (client AlertsClient) UpdateDepartmentsAlertStatusPreparer(ctx context.Context, billingAccountID string, departmentID string, alertID string, parameters Alert) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertId":          autorest.Encode("path", alertID),
		"billingAccountId": autorest.Encode("path", billingAccountID),
		"departmentId":     autorest.Encode("path", departmentID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}/providers/Microsoft.CostManagement/alerts/{alertId}/updateStatus", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateDepartmentsAlertStatusSender sends the UpdateDepartmentsAlertStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) UpdateDepartmentsAlertStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateDepartmentsAlertStatusResponder handles the response to the UpdateDepartmentsAlertStatus request. The method always
// closes the http.Response Body.
func (client AlertsClient) UpdateDepartmentsAlertStatusResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateEnrollmentAccountAlertStatus update alerts status for an enrollment account.
// Parameters:
// billingAccountID - billingAccount ID
// enrollmentAccountID - enrollment Account Id
// alertID - alert ID.
// parameters - parameters supplied to the update alerts status operation.
func (client AlertsClient) UpdateEnrollmentAccountAlertStatus(ctx context.Context, billingAccountID string, enrollmentAccountID string, alertID string, parameters Alert) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.UpdateEnrollmentAccountAlertStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateEnrollmentAccountAlertStatusPreparer(ctx, billingAccountID, enrollmentAccountID, alertID, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateEnrollmentAccountAlertStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateEnrollmentAccountAlertStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateEnrollmentAccountAlertStatus", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateEnrollmentAccountAlertStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateEnrollmentAccountAlertStatus", resp, "Failure responding to request")
	}

	return
}

// UpdateEnrollmentAccountAlertStatusPreparer prepares the UpdateEnrollmentAccountAlertStatus request.
func (client AlertsClient) UpdateEnrollmentAccountAlertStatusPreparer(ctx context.Context, billingAccountID string, enrollmentAccountID string, alertID string, parameters Alert) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertId":             autorest.Encode("path", alertID),
		"billingAccountId":    autorest.Encode("path", billingAccountID),
		"enrollmentAccountId": autorest.Encode("path", enrollmentAccountID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}/providers/Microsoft.CostManagement/alerts/{alertId}/updateStatus", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateEnrollmentAccountAlertStatusSender sends the UpdateEnrollmentAccountAlertStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) UpdateEnrollmentAccountAlertStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateEnrollmentAccountAlertStatusResponder handles the response to the UpdateEnrollmentAccountAlertStatus request. The method always
// closes the http.Response Body.
func (client AlertsClient) UpdateEnrollmentAccountAlertStatusResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateManagementGroupAlertStatus update alerts status for management group.
// Parameters:
// managementGroupID - management Group ID
// alertID - alert ID.
// parameters - parameters supplied to the update alerts status operation.
func (client AlertsClient) UpdateManagementGroupAlertStatus(ctx context.Context, managementGroupID string, alertID string, parameters Alert) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.UpdateManagementGroupAlertStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateManagementGroupAlertStatusPreparer(ctx, managementGroupID, alertID, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateManagementGroupAlertStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateManagementGroupAlertStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateManagementGroupAlertStatus", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateManagementGroupAlertStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateManagementGroupAlertStatus", resp, "Failure responding to request")
	}

	return
}

// UpdateManagementGroupAlertStatusPreparer prepares the UpdateManagementGroupAlertStatus request.
func (client AlertsClient) UpdateManagementGroupAlertStatusPreparer(ctx context.Context, managementGroupID string, alertID string, parameters Alert) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertId":           autorest.Encode("path", alertID),
		"managementGroupId": autorest.Encode("path", managementGroupID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.CostManagement/alerts/{alertId}/UpdateStatus", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateManagementGroupAlertStatusSender sends the UpdateManagementGroupAlertStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) UpdateManagementGroupAlertStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateManagementGroupAlertStatusResponder handles the response to the UpdateManagementGroupAlertStatus request. The method always
// closes the http.Response Body.
func (client AlertsClient) UpdateManagementGroupAlertStatusResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateResourceGroupNameAlertStatus update alerts status for a resource group under a subscription.
// Parameters:
// resourceGroupName - azure Resource Group Name.
// alertID - alert ID.
// parameters - parameters supplied to the update alerts status operation.
func (client AlertsClient) UpdateResourceGroupNameAlertStatus(ctx context.Context, resourceGroupName string, alertID string, parameters Alert) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.UpdateResourceGroupNameAlertStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateResourceGroupNameAlertStatusPreparer(ctx, resourceGroupName, alertID, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateResourceGroupNameAlertStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateResourceGroupNameAlertStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateResourceGroupNameAlertStatus", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResourceGroupNameAlertStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateResourceGroupNameAlertStatus", resp, "Failure responding to request")
	}

	return
}

// UpdateResourceGroupNameAlertStatusPreparer prepares the UpdateResourceGroupNameAlertStatus request.
func (client AlertsClient) UpdateResourceGroupNameAlertStatusPreparer(ctx context.Context, resourceGroupName string, alertID string, parameters Alert) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertId":           autorest.Encode("path", alertID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CostManagement/alerts/{alertId}/updateStatus", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateResourceGroupNameAlertStatusSender sends the UpdateResourceGroupNameAlertStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) UpdateResourceGroupNameAlertStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResourceGroupNameAlertStatusResponder handles the response to the UpdateResourceGroupNameAlertStatus request. The method always
// closes the http.Response Body.
func (client AlertsClient) UpdateResourceGroupNameAlertStatusResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSubscriptionAlertStatus update alerts status for a subscription.
// Parameters:
// alertID - alert ID.
// parameters - parameters supplied to the update alerts status operation.
func (client AlertsClient) UpdateSubscriptionAlertStatus(ctx context.Context, alertID string, parameters Alert) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.UpdateSubscriptionAlertStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSubscriptionAlertStatusPreparer(ctx, alertID, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateSubscriptionAlertStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSubscriptionAlertStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateSubscriptionAlertStatus", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSubscriptionAlertStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.AlertsClient", "UpdateSubscriptionAlertStatus", resp, "Failure responding to request")
	}

	return
}

// UpdateSubscriptionAlertStatusPreparer prepares the UpdateSubscriptionAlertStatus request.
func (client AlertsClient) UpdateSubscriptionAlertStatusPreparer(ctx context.Context, alertID string, parameters Alert) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertId":        autorest.Encode("path", alertID),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CostManagement/alerts/{alertId}/updateStatus", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSubscriptionAlertStatusSender sends the UpdateSubscriptionAlertStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) UpdateSubscriptionAlertStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSubscriptionAlertStatusResponder handles the response to the UpdateSubscriptionAlertStatus request. The method always
// closes the http.Response Body.
func (client AlertsClient) UpdateSubscriptionAlertStatusResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
