package datadog

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// LiftrResourceCategories enumerates the values for liftr resource categories.
type LiftrResourceCategories string

const (
	// MonitorLogs ...
	MonitorLogs LiftrResourceCategories = "MonitorLogs"
	// Unknown ...
	Unknown LiftrResourceCategories = "Unknown"
)

// PossibleLiftrResourceCategoriesValues returns an array of possible values for the LiftrResourceCategories const type.
func PossibleLiftrResourceCategoriesValues() []LiftrResourceCategories {
	return []LiftrResourceCategories{MonitorLogs, Unknown}
}

// ManagedIdentityTypes enumerates the values for managed identity types.
type ManagedIdentityTypes string

const (
	// SystemAssigned ...
	SystemAssigned ManagedIdentityTypes = "SystemAssigned"
	// UserAssigned ...
	UserAssigned ManagedIdentityTypes = "UserAssigned"
)

// PossibleManagedIdentityTypesValues returns an array of possible values for the ManagedIdentityTypes const type.
func PossibleManagedIdentityTypesValues() []ManagedIdentityTypes {
	return []ManagedIdentityTypes{SystemAssigned, UserAssigned}
}

// MarketplaceSubscriptionStatus enumerates the values for marketplace subscription status.
type MarketplaceSubscriptionStatus string

const (
	// Active ...
	Active MarketplaceSubscriptionStatus = "Active"
	// Suspended ...
	Suspended MarketplaceSubscriptionStatus = "Suspended"
)

// PossibleMarketplaceSubscriptionStatusValues returns an array of possible values for the MarketplaceSubscriptionStatus const type.
func PossibleMarketplaceSubscriptionStatusValues() []MarketplaceSubscriptionStatus {
	return []MarketplaceSubscriptionStatus{Active, Suspended}
}

// MonitoringStatus enumerates the values for monitoring status.
type MonitoringStatus string

const (
	// Disabled ...
	Disabled MonitoringStatus = "Disabled"
	// Enabled ...
	Enabled MonitoringStatus = "Enabled"
)

// PossibleMonitoringStatusValues returns an array of possible values for the MonitoringStatus const type.
func PossibleMonitoringStatusValues() []MonitoringStatus {
	return []MonitoringStatus{Disabled, Enabled}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Accepted ...
	Accepted ProvisioningState = "Accepted"
	// Canceled ...
	Canceled ProvisioningState = "Canceled"
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleted ...
	Deleted ProvisioningState = "Deleted"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// NotSpecified ...
	NotSpecified ProvisioningState = "NotSpecified"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Accepted, Canceled, Creating, Deleted, Deleting, Failed, NotSpecified, Succeeded, Updating}
}

// SingleSignOnStates enumerates the values for single sign on states.
type SingleSignOnStates string

const (
	// Disable ...
	Disable SingleSignOnStates = "Disable"
	// Enable ...
	Enable SingleSignOnStates = "Enable"
	// Existing ...
	Existing SingleSignOnStates = "Existing"
	// Initial ...
	Initial SingleSignOnStates = "Initial"
)

// PossibleSingleSignOnStatesValues returns an array of possible values for the SingleSignOnStates const type.
func PossibleSingleSignOnStatesValues() []SingleSignOnStates {
	return []SingleSignOnStates{Disable, Enable, Existing, Initial}
}

// TagAction enumerates the values for tag action.
type TagAction string

const (
	// Exclude ...
	Exclude TagAction = "Exclude"
	// Include ...
	Include TagAction = "Include"
)

// PossibleTagActionValues returns an array of possible values for the TagAction const type.
func PossibleTagActionValues() []TagAction {
	return []TagAction{Exclude, Include}
}
