// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package xray

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchGetTraces = "BatchGetTraces"

// BatchGetTracesRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetTraces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetTraces for more information on using the BatchGetTraces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetTracesRequest method.
//    req, resp := client.BatchGetTracesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/BatchGetTraces
func (c *XRay) BatchGetTracesRequest(input *BatchGetTracesInput) (req *request.Request, output *BatchGetTracesOutput) {
	op := &request.Operation{
		Name:       opBatchGetTraces,
		HTTPMethod: "POST",
		HTTPPath:   "/Traces",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &BatchGetTracesInput{}
	}

	output = &BatchGetTracesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetTraces API operation for AWS X-Ray.
//
// Retrieves a list of traces specified by ID. Each trace is a collection of
// segment documents that originates from a single request. Use GetTraceSummaries
// to get a list of trace IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation BatchGetTraces for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/BatchGetTraces
func (c *XRay) BatchGetTraces(input *BatchGetTracesInput) (*BatchGetTracesOutput, error) {
	req, out := c.BatchGetTracesRequest(input)
	return out, req.Send()
}

// BatchGetTracesWithContext is the same as BatchGetTraces with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetTraces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) BatchGetTracesWithContext(ctx aws.Context, input *BatchGetTracesInput, opts ...request.Option) (*BatchGetTracesOutput, error) {
	req, out := c.BatchGetTracesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// BatchGetTracesPages iterates over the pages of a BatchGetTraces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See BatchGetTraces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a BatchGetTraces operation.
//    pageNum := 0
//    err := client.BatchGetTracesPages(params,
//        func(page *xray.BatchGetTracesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *XRay) BatchGetTracesPages(input *BatchGetTracesInput, fn func(*BatchGetTracesOutput, bool) bool) error {
	return c.BatchGetTracesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// BatchGetTracesPagesWithContext same as BatchGetTracesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) BatchGetTracesPagesWithContext(ctx aws.Context, input *BatchGetTracesInput, fn func(*BatchGetTracesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *BatchGetTracesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.BatchGetTracesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*BatchGetTracesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/CreateGroup
func (c *XRay) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateGroup",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for AWS X-Ray.
//
// Creates a group resource with a name and a filter expression.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation CreateGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/CreateGroup
func (c *XRay) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSamplingRule = "CreateSamplingRule"

// CreateSamplingRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateSamplingRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSamplingRule for more information on using the CreateSamplingRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSamplingRuleRequest method.
//    req, resp := client.CreateSamplingRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/CreateSamplingRule
func (c *XRay) CreateSamplingRuleRequest(input *CreateSamplingRuleInput) (req *request.Request, output *CreateSamplingRuleOutput) {
	op := &request.Operation{
		Name:       opCreateSamplingRule,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateSamplingRule",
	}

	if input == nil {
		input = &CreateSamplingRuleInput{}
	}

	output = &CreateSamplingRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSamplingRule API operation for AWS X-Ray.
//
// Creates a rule to control sampling behavior for instrumented applications.
// Services retrieve rules with GetSamplingRules, and evaluate each rule in
// ascending order of priority for each request. If a rule matches, the service
// records a trace, borrowing it from the reservoir size. After 10 seconds,
// the service reports back to X-Ray with GetSamplingTargets to get updated
// versions of each in-use rule. The updated rule contains a trace quota that
// the service can use instead of borrowing from the reservoir.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation CreateSamplingRule for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
//   * RuleLimitExceededException
//   You have reached the maximum number of sampling rules.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/CreateSamplingRule
func (c *XRay) CreateSamplingRule(input *CreateSamplingRuleInput) (*CreateSamplingRuleOutput, error) {
	req, out := c.CreateSamplingRuleRequest(input)
	return out, req.Send()
}

// CreateSamplingRuleWithContext is the same as CreateSamplingRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSamplingRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) CreateSamplingRuleWithContext(ctx aws.Context, input *CreateSamplingRuleInput, opts ...request.Option) (*CreateSamplingRuleOutput, error) {
	req, out := c.CreateSamplingRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/DeleteGroup
func (c *XRay) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteGroup",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGroup API operation for AWS X-Ray.
//
// Deletes a group resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/DeleteGroup
func (c *XRay) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSamplingRule = "DeleteSamplingRule"

// DeleteSamplingRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSamplingRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSamplingRule for more information on using the DeleteSamplingRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSamplingRuleRequest method.
//    req, resp := client.DeleteSamplingRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/DeleteSamplingRule
func (c *XRay) DeleteSamplingRuleRequest(input *DeleteSamplingRuleInput) (req *request.Request, output *DeleteSamplingRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteSamplingRule,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteSamplingRule",
	}

	if input == nil {
		input = &DeleteSamplingRuleInput{}
	}

	output = &DeleteSamplingRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSamplingRule API operation for AWS X-Ray.
//
// Deletes a sampling rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation DeleteSamplingRule for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/DeleteSamplingRule
func (c *XRay) DeleteSamplingRule(input *DeleteSamplingRuleInput) (*DeleteSamplingRuleOutput, error) {
	req, out := c.DeleteSamplingRuleRequest(input)
	return out, req.Send()
}

// DeleteSamplingRuleWithContext is the same as DeleteSamplingRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSamplingRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) DeleteSamplingRuleWithContext(ctx aws.Context, input *DeleteSamplingRuleInput, opts ...request.Option) (*DeleteSamplingRuleOutput, error) {
	req, out := c.DeleteSamplingRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEncryptionConfig = "GetEncryptionConfig"

// GetEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEncryptionConfig for more information on using the GetEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEncryptionConfigRequest method.
//    req, resp := client.GetEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetEncryptionConfig
func (c *XRay) GetEncryptionConfigRequest(input *GetEncryptionConfigInput) (req *request.Request, output *GetEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opGetEncryptionConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/EncryptionConfig",
	}

	if input == nil {
		input = &GetEncryptionConfigInput{}
	}

	output = &GetEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEncryptionConfig API operation for AWS X-Ray.
//
// Retrieves the current encryption configuration for X-Ray data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetEncryptionConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetEncryptionConfig
func (c *XRay) GetEncryptionConfig(input *GetEncryptionConfigInput) (*GetEncryptionConfigOutput, error) {
	req, out := c.GetEncryptionConfigRequest(input)
	return out, req.Send()
}

// GetEncryptionConfigWithContext is the same as GetEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetEncryptionConfigWithContext(ctx aws.Context, input *GetEncryptionConfigInput, opts ...request.Option) (*GetEncryptionConfigOutput, error) {
	req, out := c.GetEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroup = "GetGroup"

// GetGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroup for more information on using the GetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupRequest method.
//    req, resp := client.GetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetGroup
func (c *XRay) GetGroupRequest(input *GetGroupInput) (req *request.Request, output *GetGroupOutput) {
	op := &request.Operation{
		Name:       opGetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/GetGroup",
	}

	if input == nil {
		input = &GetGroupInput{}
	}

	output = &GetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroup API operation for AWS X-Ray.
//
// Retrieves group resource details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetGroup
func (c *XRay) GetGroup(input *GetGroupInput) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	return out, req.Send()
}

// GetGroupWithContext is the same as GetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetGroupWithContext(ctx aws.Context, input *GetGroupInput, opts ...request.Option) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroups = "GetGroups"

// GetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the GetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroups for more information on using the GetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupsRequest method.
//    req, resp := client.GetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetGroups
func (c *XRay) GetGroupsRequest(input *GetGroupsInput) (req *request.Request, output *GetGroupsOutput) {
	op := &request.Operation{
		Name:       opGetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/Groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetGroupsInput{}
	}

	output = &GetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroups API operation for AWS X-Ray.
//
// Retrieves all active group details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetGroups for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetGroups
func (c *XRay) GetGroups(input *GetGroupsInput) (*GetGroupsOutput, error) {
	req, out := c.GetGroupsRequest(input)
	return out, req.Send()
}

// GetGroupsWithContext is the same as GetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetGroupsWithContext(ctx aws.Context, input *GetGroupsInput, opts ...request.Option) (*GetGroupsOutput, error) {
	req, out := c.GetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetGroupsPages iterates over the pages of a GetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetGroups operation.
//    pageNum := 0
//    err := client.GetGroupsPages(params,
//        func(page *xray.GetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *XRay) GetGroupsPages(input *GetGroupsInput, fn func(*GetGroupsOutput, bool) bool) error {
	return c.GetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetGroupsPagesWithContext same as GetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetGroupsPagesWithContext(ctx aws.Context, input *GetGroupsInput, fn func(*GetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSamplingRules = "GetSamplingRules"

// GetSamplingRulesRequest generates a "aws/request.Request" representing the
// client's request for the GetSamplingRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSamplingRules for more information on using the GetSamplingRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSamplingRulesRequest method.
//    req, resp := client.GetSamplingRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingRules
func (c *XRay) GetSamplingRulesRequest(input *GetSamplingRulesInput) (req *request.Request, output *GetSamplingRulesOutput) {
	op := &request.Operation{
		Name:       opGetSamplingRules,
		HTTPMethod: "POST",
		HTTPPath:   "/GetSamplingRules",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSamplingRulesInput{}
	}

	output = &GetSamplingRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSamplingRules API operation for AWS X-Ray.
//
// Retrieves all sampling rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetSamplingRules for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingRules
func (c *XRay) GetSamplingRules(input *GetSamplingRulesInput) (*GetSamplingRulesOutput, error) {
	req, out := c.GetSamplingRulesRequest(input)
	return out, req.Send()
}

// GetSamplingRulesWithContext is the same as GetSamplingRules with the addition of
// the ability to pass a context and additional request options.
//
// See GetSamplingRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetSamplingRulesWithContext(ctx aws.Context, input *GetSamplingRulesInput, opts ...request.Option) (*GetSamplingRulesOutput, error) {
	req, out := c.GetSamplingRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetSamplingRulesPages iterates over the pages of a GetSamplingRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetSamplingRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetSamplingRules operation.
//    pageNum := 0
//    err := client.GetSamplingRulesPages(params,
//        func(page *xray.GetSamplingRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *XRay) GetSamplingRulesPages(input *GetSamplingRulesInput, fn func(*GetSamplingRulesOutput, bool) bool) error {
	return c.GetSamplingRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetSamplingRulesPagesWithContext same as GetSamplingRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetSamplingRulesPagesWithContext(ctx aws.Context, input *GetSamplingRulesInput, fn func(*GetSamplingRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetSamplingRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSamplingRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetSamplingRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSamplingStatisticSummaries = "GetSamplingStatisticSummaries"

// GetSamplingStatisticSummariesRequest generates a "aws/request.Request" representing the
// client's request for the GetSamplingStatisticSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSamplingStatisticSummaries for more information on using the GetSamplingStatisticSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSamplingStatisticSummariesRequest method.
//    req, resp := client.GetSamplingStatisticSummariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingStatisticSummaries
func (c *XRay) GetSamplingStatisticSummariesRequest(input *GetSamplingStatisticSummariesInput) (req *request.Request, output *GetSamplingStatisticSummariesOutput) {
	op := &request.Operation{
		Name:       opGetSamplingStatisticSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/SamplingStatisticSummaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSamplingStatisticSummariesInput{}
	}

	output = &GetSamplingStatisticSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSamplingStatisticSummaries API operation for AWS X-Ray.
//
// Retrieves information about recent sampling results for all sampling rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetSamplingStatisticSummaries for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingStatisticSummaries
func (c *XRay) GetSamplingStatisticSummaries(input *GetSamplingStatisticSummariesInput) (*GetSamplingStatisticSummariesOutput, error) {
	req, out := c.GetSamplingStatisticSummariesRequest(input)
	return out, req.Send()
}

// GetSamplingStatisticSummariesWithContext is the same as GetSamplingStatisticSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See GetSamplingStatisticSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetSamplingStatisticSummariesWithContext(ctx aws.Context, input *GetSamplingStatisticSummariesInput, opts ...request.Option) (*GetSamplingStatisticSummariesOutput, error) {
	req, out := c.GetSamplingStatisticSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetSamplingStatisticSummariesPages iterates over the pages of a GetSamplingStatisticSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetSamplingStatisticSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetSamplingStatisticSummaries operation.
//    pageNum := 0
//    err := client.GetSamplingStatisticSummariesPages(params,
//        func(page *xray.GetSamplingStatisticSummariesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *XRay) GetSamplingStatisticSummariesPages(input *GetSamplingStatisticSummariesInput, fn func(*GetSamplingStatisticSummariesOutput, bool) bool) error {
	return c.GetSamplingStatisticSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetSamplingStatisticSummariesPagesWithContext same as GetSamplingStatisticSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetSamplingStatisticSummariesPagesWithContext(ctx aws.Context, input *GetSamplingStatisticSummariesInput, fn func(*GetSamplingStatisticSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetSamplingStatisticSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSamplingStatisticSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetSamplingStatisticSummariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSamplingTargets = "GetSamplingTargets"

// GetSamplingTargetsRequest generates a "aws/request.Request" representing the
// client's request for the GetSamplingTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSamplingTargets for more information on using the GetSamplingTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSamplingTargetsRequest method.
//    req, resp := client.GetSamplingTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingTargets
func (c *XRay) GetSamplingTargetsRequest(input *GetSamplingTargetsInput) (req *request.Request, output *GetSamplingTargetsOutput) {
	op := &request.Operation{
		Name:       opGetSamplingTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/SamplingTargets",
	}

	if input == nil {
		input = &GetSamplingTargetsInput{}
	}

	output = &GetSamplingTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSamplingTargets API operation for AWS X-Ray.
//
// Requests a sampling quota for rules that the service is using to sample requests.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetSamplingTargets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingTargets
func (c *XRay) GetSamplingTargets(input *GetSamplingTargetsInput) (*GetSamplingTargetsOutput, error) {
	req, out := c.GetSamplingTargetsRequest(input)
	return out, req.Send()
}

// GetSamplingTargetsWithContext is the same as GetSamplingTargets with the addition of
// the ability to pass a context and additional request options.
//
// See GetSamplingTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetSamplingTargetsWithContext(ctx aws.Context, input *GetSamplingTargetsInput, opts ...request.Option) (*GetSamplingTargetsOutput, error) {
	req, out := c.GetSamplingTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceGraph = "GetServiceGraph"

// GetServiceGraphRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceGraph operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceGraph for more information on using the GetServiceGraph
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceGraphRequest method.
//    req, resp := client.GetServiceGraphRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetServiceGraph
func (c *XRay) GetServiceGraphRequest(input *GetServiceGraphInput) (req *request.Request, output *GetServiceGraphOutput) {
	op := &request.Operation{
		Name:       opGetServiceGraph,
		HTTPMethod: "POST",
		HTTPPath:   "/ServiceGraph",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetServiceGraphInput{}
	}

	output = &GetServiceGraphOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceGraph API operation for AWS X-Ray.
//
// Retrieves a document that describes services that process incoming requests,
// and downstream services that they call as a result. Root services process
// incoming requests and make calls to downstream services. Root services are
// applications that use the AWS X-Ray SDK (https://docs.aws.amazon.com/xray/index.html).
// Downstream services can be other applications, AWS resources, HTTP web APIs,
// or SQL databases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetServiceGraph for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetServiceGraph
func (c *XRay) GetServiceGraph(input *GetServiceGraphInput) (*GetServiceGraphOutput, error) {
	req, out := c.GetServiceGraphRequest(input)
	return out, req.Send()
}

// GetServiceGraphWithContext is the same as GetServiceGraph with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceGraph for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetServiceGraphWithContext(ctx aws.Context, input *GetServiceGraphInput, opts ...request.Option) (*GetServiceGraphOutput, error) {
	req, out := c.GetServiceGraphRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetServiceGraphPages iterates over the pages of a GetServiceGraph operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetServiceGraph method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetServiceGraph operation.
//    pageNum := 0
//    err := client.GetServiceGraphPages(params,
//        func(page *xray.GetServiceGraphOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *XRay) GetServiceGraphPages(input *GetServiceGraphInput, fn func(*GetServiceGraphOutput, bool) bool) error {
	return c.GetServiceGraphPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetServiceGraphPagesWithContext same as GetServiceGraphPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetServiceGraphPagesWithContext(ctx aws.Context, input *GetServiceGraphInput, fn func(*GetServiceGraphOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetServiceGraphInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetServiceGraphRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetServiceGraphOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTimeSeriesServiceStatistics = "GetTimeSeriesServiceStatistics"

// GetTimeSeriesServiceStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetTimeSeriesServiceStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTimeSeriesServiceStatistics for more information on using the GetTimeSeriesServiceStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTimeSeriesServiceStatisticsRequest method.
//    req, resp := client.GetTimeSeriesServiceStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTimeSeriesServiceStatistics
func (c *XRay) GetTimeSeriesServiceStatisticsRequest(input *GetTimeSeriesServiceStatisticsInput) (req *request.Request, output *GetTimeSeriesServiceStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetTimeSeriesServiceStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/TimeSeriesServiceStatistics",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTimeSeriesServiceStatisticsInput{}
	}

	output = &GetTimeSeriesServiceStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTimeSeriesServiceStatistics API operation for AWS X-Ray.
//
// Get an aggregation of service statistics defined by a specific time range.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetTimeSeriesServiceStatistics for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTimeSeriesServiceStatistics
func (c *XRay) GetTimeSeriesServiceStatistics(input *GetTimeSeriesServiceStatisticsInput) (*GetTimeSeriesServiceStatisticsOutput, error) {
	req, out := c.GetTimeSeriesServiceStatisticsRequest(input)
	return out, req.Send()
}

// GetTimeSeriesServiceStatisticsWithContext is the same as GetTimeSeriesServiceStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetTimeSeriesServiceStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetTimeSeriesServiceStatisticsWithContext(ctx aws.Context, input *GetTimeSeriesServiceStatisticsInput, opts ...request.Option) (*GetTimeSeriesServiceStatisticsOutput, error) {
	req, out := c.GetTimeSeriesServiceStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTimeSeriesServiceStatisticsPages iterates over the pages of a GetTimeSeriesServiceStatistics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTimeSeriesServiceStatistics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTimeSeriesServiceStatistics operation.
//    pageNum := 0
//    err := client.GetTimeSeriesServiceStatisticsPages(params,
//        func(page *xray.GetTimeSeriesServiceStatisticsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *XRay) GetTimeSeriesServiceStatisticsPages(input *GetTimeSeriesServiceStatisticsInput, fn func(*GetTimeSeriesServiceStatisticsOutput, bool) bool) error {
	return c.GetTimeSeriesServiceStatisticsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTimeSeriesServiceStatisticsPagesWithContext same as GetTimeSeriesServiceStatisticsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetTimeSeriesServiceStatisticsPagesWithContext(ctx aws.Context, input *GetTimeSeriesServiceStatisticsInput, fn func(*GetTimeSeriesServiceStatisticsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTimeSeriesServiceStatisticsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTimeSeriesServiceStatisticsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetTimeSeriesServiceStatisticsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTraceGraph = "GetTraceGraph"

// GetTraceGraphRequest generates a "aws/request.Request" representing the
// client's request for the GetTraceGraph operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTraceGraph for more information on using the GetTraceGraph
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTraceGraphRequest method.
//    req, resp := client.GetTraceGraphRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceGraph
func (c *XRay) GetTraceGraphRequest(input *GetTraceGraphInput) (req *request.Request, output *GetTraceGraphOutput) {
	op := &request.Operation{
		Name:       opGetTraceGraph,
		HTTPMethod: "POST",
		HTTPPath:   "/TraceGraph",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTraceGraphInput{}
	}

	output = &GetTraceGraphOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTraceGraph API operation for AWS X-Ray.
//
// Retrieves a service graph for one or more specific trace IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetTraceGraph for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceGraph
func (c *XRay) GetTraceGraph(input *GetTraceGraphInput) (*GetTraceGraphOutput, error) {
	req, out := c.GetTraceGraphRequest(input)
	return out, req.Send()
}

// GetTraceGraphWithContext is the same as GetTraceGraph with the addition of
// the ability to pass a context and additional request options.
//
// See GetTraceGraph for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetTraceGraphWithContext(ctx aws.Context, input *GetTraceGraphInput, opts ...request.Option) (*GetTraceGraphOutput, error) {
	req, out := c.GetTraceGraphRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTraceGraphPages iterates over the pages of a GetTraceGraph operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTraceGraph method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTraceGraph operation.
//    pageNum := 0
//    err := client.GetTraceGraphPages(params,
//        func(page *xray.GetTraceGraphOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *XRay) GetTraceGraphPages(input *GetTraceGraphInput, fn func(*GetTraceGraphOutput, bool) bool) error {
	return c.GetTraceGraphPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTraceGraphPagesWithContext same as GetTraceGraphPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetTraceGraphPagesWithContext(ctx aws.Context, input *GetTraceGraphInput, fn func(*GetTraceGraphOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTraceGraphInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTraceGraphRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetTraceGraphOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTraceSummaries = "GetTraceSummaries"

// GetTraceSummariesRequest generates a "aws/request.Request" representing the
// client's request for the GetTraceSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTraceSummaries for more information on using the GetTraceSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTraceSummariesRequest method.
//    req, resp := client.GetTraceSummariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceSummaries
func (c *XRay) GetTraceSummariesRequest(input *GetTraceSummariesInput) (req *request.Request, output *GetTraceSummariesOutput) {
	op := &request.Operation{
		Name:       opGetTraceSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/TraceSummaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTraceSummariesInput{}
	}

	output = &GetTraceSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTraceSummaries API operation for AWS X-Ray.
//
// Retrieves IDs and annotations for traces available for a specified time frame
// using an optional filter. To get the full traces, pass the trace IDs to BatchGetTraces.
//
// A filter expression can target traced requests that hit specific service
// nodes or edges, have errors, or come from a known user. For example, the
// following filter expression targets traces that pass through api.example.com:
//
// service("api.example.com")
//
// This filter expression finds traces that have an annotation named account
// with the value 12345:
//
// annotation.account = "12345"
//
// For a full list of indexed fields and keywords that you can use in filter
// expressions, see Using Filter Expressions (https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html)
// in the AWS X-Ray Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetTraceSummaries for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceSummaries
func (c *XRay) GetTraceSummaries(input *GetTraceSummariesInput) (*GetTraceSummariesOutput, error) {
	req, out := c.GetTraceSummariesRequest(input)
	return out, req.Send()
}

// GetTraceSummariesWithContext is the same as GetTraceSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See GetTraceSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetTraceSummariesWithContext(ctx aws.Context, input *GetTraceSummariesInput, opts ...request.Option) (*GetTraceSummariesOutput, error) {
	req, out := c.GetTraceSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTraceSummariesPages iterates over the pages of a GetTraceSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTraceSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTraceSummaries operation.
//    pageNum := 0
//    err := client.GetTraceSummariesPages(params,
//        func(page *xray.GetTraceSummariesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *XRay) GetTraceSummariesPages(input *GetTraceSummariesInput, fn func(*GetTraceSummariesOutput, bool) bool) error {
	return c.GetTraceSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTraceSummariesPagesWithContext same as GetTraceSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetTraceSummariesPagesWithContext(ctx aws.Context, input *GetTraceSummariesInput, fn func(*GetTraceSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTraceSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTraceSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetTraceSummariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/ListTagsForResource
func (c *XRay) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/ListTagsForResource",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS X-Ray.
//
// Returns a list of tags that are applied to the specified AWS X-Ray group
// or sampling rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
//   * ResourceNotFoundException
//   The resource was not found. Verify that the name or Amazon Resource Name
//   (ARN) of the resource is correct.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/ListTagsForResource
func (c *XRay) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEncryptionConfig = "PutEncryptionConfig"

// PutEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the PutEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEncryptionConfig for more information on using the PutEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEncryptionConfigRequest method.
//    req, resp := client.PutEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutEncryptionConfig
func (c *XRay) PutEncryptionConfigRequest(input *PutEncryptionConfigInput) (req *request.Request, output *PutEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opPutEncryptionConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/PutEncryptionConfig",
	}

	if input == nil {
		input = &PutEncryptionConfigInput{}
	}

	output = &PutEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEncryptionConfig API operation for AWS X-Ray.
//
// Updates the encryption configuration for X-Ray data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation PutEncryptionConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutEncryptionConfig
func (c *XRay) PutEncryptionConfig(input *PutEncryptionConfigInput) (*PutEncryptionConfigOutput, error) {
	req, out := c.PutEncryptionConfigRequest(input)
	return out, req.Send()
}

// PutEncryptionConfigWithContext is the same as PutEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See PutEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) PutEncryptionConfigWithContext(ctx aws.Context, input *PutEncryptionConfigInput, opts ...request.Option) (*PutEncryptionConfigOutput, error) {
	req, out := c.PutEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutTelemetryRecords = "PutTelemetryRecords"

// PutTelemetryRecordsRequest generates a "aws/request.Request" representing the
// client's request for the PutTelemetryRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutTelemetryRecords for more information on using the PutTelemetryRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutTelemetryRecordsRequest method.
//    req, resp := client.PutTelemetryRecordsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTelemetryRecords
func (c *XRay) PutTelemetryRecordsRequest(input *PutTelemetryRecordsInput) (req *request.Request, output *PutTelemetryRecordsOutput) {
	op := &request.Operation{
		Name:       opPutTelemetryRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/TelemetryRecords",
	}

	if input == nil {
		input = &PutTelemetryRecordsInput{}
	}

	output = &PutTelemetryRecordsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutTelemetryRecords API operation for AWS X-Ray.
//
// Used by the AWS X-Ray daemon to upload telemetry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation PutTelemetryRecords for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTelemetryRecords
func (c *XRay) PutTelemetryRecords(input *PutTelemetryRecordsInput) (*PutTelemetryRecordsOutput, error) {
	req, out := c.PutTelemetryRecordsRequest(input)
	return out, req.Send()
}

// PutTelemetryRecordsWithContext is the same as PutTelemetryRecords with the addition of
// the ability to pass a context and additional request options.
//
// See PutTelemetryRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) PutTelemetryRecordsWithContext(ctx aws.Context, input *PutTelemetryRecordsInput, opts ...request.Option) (*PutTelemetryRecordsOutput, error) {
	req, out := c.PutTelemetryRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutTraceSegments = "PutTraceSegments"

// PutTraceSegmentsRequest generates a "aws/request.Request" representing the
// client's request for the PutTraceSegments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutTraceSegments for more information on using the PutTraceSegments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutTraceSegmentsRequest method.
//    req, resp := client.PutTraceSegmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTraceSegments
func (c *XRay) PutTraceSegmentsRequest(input *PutTraceSegmentsInput) (req *request.Request, output *PutTraceSegmentsOutput) {
	op := &request.Operation{
		Name:       opPutTraceSegments,
		HTTPMethod: "POST",
		HTTPPath:   "/TraceSegments",
	}

	if input == nil {
		input = &PutTraceSegmentsInput{}
	}

	output = &PutTraceSegmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutTraceSegments API operation for AWS X-Ray.
//
// Uploads segment documents to AWS X-Ray. The X-Ray SDK (https://docs.aws.amazon.com/xray/index.html)
// generates segment documents and sends them to the X-Ray daemon, which uploads
// them in batches. A segment document can be a completed segment, an in-progress
// segment, or an array of subsegments.
//
// Segments must include the following fields. For the full segment document
// schema, see AWS X-Ray Segment Documents (https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html)
// in the AWS X-Ray Developer Guide.
//
// Required segment document fields
//
//    * name - The name of the service that handled the request.
//
//    * id - A 64-bit identifier for the segment, unique among segments in the
//    same trace, in 16 hexadecimal digits.
//
//    * trace_id - A unique identifier that connects all segments and subsegments
//    originating from a single client request.
//
//    * start_time - Time the segment or subsegment was created, in floating
//    point seconds in epoch time, accurate to milliseconds. For example, 1480615200.010
//    or 1.480615200010E9.
//
//    * end_time - Time the segment or subsegment was closed. For example, 1480615200.090
//    or 1.480615200090E9. Specify either an end_time or in_progress.
//
//    * in_progress - Set to true instead of specifying an end_time to record
//    that a segment has been started, but is not complete. Send an in-progress
//    segment when your application receives a request that will take a long
//    time to serve, to trace that the request was received. When the response
//    is sent, send the complete segment to overwrite the in-progress segment.
//
// A trace_id consists of three numbers separated by hyphens. For example, 1-58406520-a006649127e371903a2de979.
// This includes:
//
// Trace ID Format
//
//    * The version number, for instance, 1.
//
//    * The time of the original request, in Unix epoch time, in 8 hexadecimal
//    digits. For example, 10:00AM December 2nd, 2016 PST in epoch time is 1480615200
//    seconds, or 58406520 in hexadecimal.
//
//    * A 96-bit identifier for the trace, globally unique, in 24 hexadecimal
//    digits.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation PutTraceSegments for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTraceSegments
func (c *XRay) PutTraceSegments(input *PutTraceSegmentsInput) (*PutTraceSegmentsOutput, error) {
	req, out := c.PutTraceSegmentsRequest(input)
	return out, req.Send()
}

// PutTraceSegmentsWithContext is the same as PutTraceSegments with the addition of
// the ability to pass a context and additional request options.
//
// See PutTraceSegments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) PutTraceSegmentsWithContext(ctx aws.Context, input *PutTraceSegmentsInput, opts ...request.Option) (*PutTraceSegmentsOutput, error) {
	req, out := c.PutTraceSegmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/TagResource
func (c *XRay) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/TagResource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS X-Ray.
//
// Applies tags to an existing AWS X-Ray group or sampling rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
//   * ResourceNotFoundException
//   The resource was not found. Verify that the name or Amazon Resource Name
//   (ARN) of the resource is correct.
//
//   * TooManyTagsException
//   You have exceeded the maximum number of tags you can apply to this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/TagResource
func (c *XRay) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UntagResource
func (c *XRay) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/UntagResource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS X-Ray.
//
// Removes tags from an AWS X-Ray group or sampling rule. You cannot edit or
// delete system tags (those with an aws: prefix).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
//   * ResourceNotFoundException
//   The resource was not found. Verify that the name or Amazon Resource Name
//   (ARN) of the resource is correct.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UntagResource
func (c *XRay) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupRequest method.
//    req, resp := client.UpdateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UpdateGroup
func (c *XRay) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateGroup",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroup API operation for AWS X-Ray.
//
// Updates a group resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UpdateGroup
func (c *XRay) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSamplingRule = "UpdateSamplingRule"

// UpdateSamplingRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSamplingRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSamplingRule for more information on using the UpdateSamplingRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSamplingRuleRequest method.
//    req, resp := client.UpdateSamplingRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UpdateSamplingRule
func (c *XRay) UpdateSamplingRuleRequest(input *UpdateSamplingRuleInput) (req *request.Request, output *UpdateSamplingRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateSamplingRule,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateSamplingRule",
	}

	if input == nil {
		input = &UpdateSamplingRuleInput{}
	}

	output = &UpdateSamplingRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSamplingRule API operation for AWS X-Ray.
//
// Modifies a sampling rule's configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation UpdateSamplingRule for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is missing required parameters or has invalid parameters.
//
//   * ThrottledException
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UpdateSamplingRule
func (c *XRay) UpdateSamplingRule(input *UpdateSamplingRuleInput) (*UpdateSamplingRuleOutput, error) {
	req, out := c.UpdateSamplingRuleRequest(input)
	return out, req.Send()
}

// UpdateSamplingRuleWithContext is the same as UpdateSamplingRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSamplingRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) UpdateSamplingRuleWithContext(ctx aws.Context, input *UpdateSamplingRuleInput, opts ...request.Option) (*UpdateSamplingRuleOutput, error) {
	req, out := c.UpdateSamplingRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An alias for an edge.
type Alias struct {
	_ struct{} `type:"structure"`

	// The canonical name of the alias.
	Name *string `type:"string"`

	// A list of names for the alias, including the canonical name.
	Names []*string `type:"list"`

	// The type of the alias.
	Type *string `type:"string"`
}

// String returns the string representation
func (s Alias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alias) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Alias) SetName(v string) *Alias {
	s.Name = &v
	return s
}

// SetNames sets the Names field's value.
func (s *Alias) SetNames(v []*string) *Alias {
	s.Names = v
	return s
}

// SetType sets the Type field's value.
func (s *Alias) SetType(v string) *Alias {
	s.Type = &v
	return s
}

// Value of a segment annotation. Has one of three value types: Number, Boolean,
// or String.
type AnnotationValue struct {
	_ struct{} `type:"structure"`

	// Value for a Boolean annotation.
	BooleanValue *bool `type:"boolean"`

	// Value for a Number annotation.
	NumberValue *float64 `type:"double"`

	// Value for a String annotation.
	StringValue *string `type:"string"`
}

// String returns the string representation
func (s AnnotationValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnnotationValue) GoString() string {
	return s.String()
}

// SetBooleanValue sets the BooleanValue field's value.
func (s *AnnotationValue) SetBooleanValue(v bool) *AnnotationValue {
	s.BooleanValue = &v
	return s
}

// SetNumberValue sets the NumberValue field's value.
func (s *AnnotationValue) SetNumberValue(v float64) *AnnotationValue {
	s.NumberValue = &v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *AnnotationValue) SetStringValue(v string) *AnnotationValue {
	s.StringValue = &v
	return s
}

// A list of Availability Zones corresponding to the segments in a trace.
type AvailabilityZoneDetail struct {
	_ struct{} `type:"structure"`

	// The name of a corresponding Availability Zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZoneDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZoneDetail) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZoneDetail) SetName(v string) *AvailabilityZoneDetail {
	s.Name = &v
	return s
}

type BackendConnectionErrors struct {
	_ struct{} `type:"structure"`

	ConnectionRefusedCount *int64 `type:"integer"`

	HTTPCode4XXCount *int64 `type:"integer"`

	HTTPCode5XXCount *int64 `type:"integer"`

	OtherCount *int64 `type:"integer"`

	TimeoutCount *int64 `type:"integer"`

	UnknownHostCount *int64 `type:"integer"`
}

// String returns the string representation
func (s BackendConnectionErrors) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BackendConnectionErrors) GoString() string {
	return s.String()
}

// SetConnectionRefusedCount sets the ConnectionRefusedCount field's value.
func (s *BackendConnectionErrors) SetConnectionRefusedCount(v int64) *BackendConnectionErrors {
	s.ConnectionRefusedCount = &v
	return s
}

// SetHTTPCode4XXCount sets the HTTPCode4XXCount field's value.
func (s *BackendConnectionErrors) SetHTTPCode4XXCount(v int64) *BackendConnectionErrors {
	s.HTTPCode4XXCount = &v
	return s
}

// SetHTTPCode5XXCount sets the HTTPCode5XXCount field's value.
func (s *BackendConnectionErrors) SetHTTPCode5XXCount(v int64) *BackendConnectionErrors {
	s.HTTPCode5XXCount = &v
	return s
}

// SetOtherCount sets the OtherCount field's value.
func (s *BackendConnectionErrors) SetOtherCount(v int64) *BackendConnectionErrors {
	s.OtherCount = &v
	return s
}

// SetTimeoutCount sets the TimeoutCount field's value.
func (s *BackendConnectionErrors) SetTimeoutCount(v int64) *BackendConnectionErrors {
	s.TimeoutCount = &v
	return s
}

// SetUnknownHostCount sets the UnknownHostCount field's value.
func (s *BackendConnectionErrors) SetUnknownHostCount(v int64) *BackendConnectionErrors {
	s.UnknownHostCount = &v
	return s
}

type BatchGetTracesInput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `type:"string"`

	// Specify the trace IDs of requests for which to retrieve segments.
	//
	// TraceIds is a required field
	TraceIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetTracesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetTracesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetTracesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetTracesInput"}
	if s.TraceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("TraceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *BatchGetTracesInput) SetNextToken(v string) *BatchGetTracesInput {
	s.NextToken = &v
	return s
}

// SetTraceIds sets the TraceIds field's value.
func (s *BatchGetTracesInput) SetTraceIds(v []*string) *BatchGetTracesInput {
	s.TraceIds = v
	return s
}

type BatchGetTracesOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `type:"string"`

	// Full traces for the specified requests.
	Traces []*Trace `type:"list"`

	// Trace IDs of requests that haven't been processed.
	UnprocessedTraceIds []*string `type:"list"`
}

// String returns the string representation
func (s BatchGetTracesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetTracesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *BatchGetTracesOutput) SetNextToken(v string) *BatchGetTracesOutput {
	s.NextToken = &v
	return s
}

// SetTraces sets the Traces field's value.
func (s *BatchGetTracesOutput) SetTraces(v []*Trace) *BatchGetTracesOutput {
	s.Traces = v
	return s
}

// SetUnprocessedTraceIds sets the UnprocessedTraceIds field's value.
func (s *BatchGetTracesOutput) SetUnprocessedTraceIds(v []*string) *BatchGetTracesOutput {
	s.UnprocessedTraceIds = v
	return s
}

type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// The filter expression defining criteria by which to group traces.
	FilterExpression *string `type:"string"`

	// The case-sensitive name of the new group. Default is a reserved name and
	// names must be unique.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The structure containing configurations related to insights.
	//
	//    * The InsightsEnabled boolean can be set to true to enable insights for
	//    the new group or false to disable insights for the new group.
	//
	//    * The NotifcationsEnabled boolean can be set to true to enable insights
	//    notifications for the new group. Notifications may only be enabled on
	//    a group with InsightsEnabled set to true.
	InsightsConfiguration *InsightsConfiguration `type:"structure"`

	// A map that contains one or more tag keys and tag values to attach to an X-Ray
	// group. For more information about ways to use tags, see Tagging AWS resources
	// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the AWS
	// General Reference.
	//
	// The following restrictions apply to tags:
	//
	//    * Maximum number of user-applied tags per resource: 50
	//
	//    * Maximum tag key length: 128 Unicode characters
	//
	//    * Maximum tag value length: 256 Unicode characters
	//
	//    * Valid values for key and value: a-z, A-Z, 0-9, space, and the following
	//    characters: _ . : / = + - and @
	//
	//    * Tag keys and values are case sensitive.
	//
	//    * Don't use aws: as a prefix for keys; it's reserved for AWS use.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *CreateGroupInput) SetFilterExpression(v string) *CreateGroupInput {
	s.FilterExpression = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupInput) SetGroupName(v string) *CreateGroupInput {
	s.GroupName = &v
	return s
}

// SetInsightsConfiguration sets the InsightsConfiguration field's value.
func (s *CreateGroupInput) SetInsightsConfiguration(v *InsightsConfiguration) *CreateGroupInput {
	s.InsightsConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGroupInput) SetTags(v []*Tag) *CreateGroupInput {
	s.Tags = v
	return s
}

type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The group that was created. Contains the name of the group that was created,
	// the Amazon Resource Name (ARN) of the group that was generated based on the
	// group name, the filter expression, and the insight configuration that was
	// assigned to the group.
	Group *Group `type:"structure"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *CreateGroupOutput) SetGroup(v *Group) *CreateGroupOutput {
	s.Group = v
	return s
}

type CreateSamplingRuleInput struct {
	_ struct{} `type:"structure"`

	// The rule definition.
	//
	// SamplingRule is a required field
	SamplingRule *SamplingRule `type:"structure" required:"true"`

	// A map that contains one or more tag keys and tag values to attach to an X-Ray
	// sampling rule. For more information about ways to use tags, see Tagging AWS
	// resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the AWS General Reference.
	//
	// The following restrictions apply to tags:
	//
	//    * Maximum number of user-applied tags per resource: 50
	//
	//    * Maximum tag key length: 128 Unicode characters
	//
	//    * Maximum tag value length: 256 Unicode characters
	//
	//    * Valid values for key and value: a-z, A-Z, 0-9, space, and the following
	//    characters: _ . : / = + - and @
	//
	//    * Tag keys and values are case sensitive.
	//
	//    * Don't use aws: as a prefix for keys; it's reserved for AWS use.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateSamplingRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSamplingRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSamplingRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSamplingRuleInput"}
	if s.SamplingRule == nil {
		invalidParams.Add(request.NewErrParamRequired("SamplingRule"))
	}
	if s.SamplingRule != nil {
		if err := s.SamplingRule.Validate(); err != nil {
			invalidParams.AddNested("SamplingRule", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSamplingRule sets the SamplingRule field's value.
func (s *CreateSamplingRuleInput) SetSamplingRule(v *SamplingRule) *CreateSamplingRuleInput {
	s.SamplingRule = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSamplingRuleInput) SetTags(v []*Tag) *CreateSamplingRuleInput {
	s.Tags = v
	return s
}

type CreateSamplingRuleOutput struct {
	_ struct{} `type:"structure"`

	// The saved rule definition and metadata.
	SamplingRuleRecord *SamplingRuleRecord `type:"structure"`
}

// String returns the string representation
func (s CreateSamplingRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSamplingRuleOutput) GoString() string {
	return s.String()
}

// SetSamplingRuleRecord sets the SamplingRuleRecord field's value.
func (s *CreateSamplingRuleOutput) SetSamplingRuleRecord(v *SamplingRuleRecord) *CreateSamplingRuleOutput {
	s.SamplingRuleRecord = v
	return s
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the group that was generated on creation.
	GroupARN *string `min:"1" type:"string"`

	// The case-sensitive name of the group.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.GroupARN != nil && len(*s.GroupARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupARN", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupARN sets the GroupARN field's value.
func (s *DeleteGroupInput) SetGroupARN(v string) *DeleteGroupInput {
	s.GroupARN = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupInput) SetGroupName(v string) *DeleteGroupInput {
	s.GroupName = &v
	return s
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

type DeleteSamplingRuleInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the sampling rule. Specify a rule by either name or ARN, but not
	// both.
	RuleARN *string `type:"string"`

	// The name of the sampling rule. Specify a rule by either name or ARN, but
	// not both.
	RuleName *string `type:"string"`
}

// String returns the string representation
func (s DeleteSamplingRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSamplingRuleInput) GoString() string {
	return s.String()
}

// SetRuleARN sets the RuleARN field's value.
func (s *DeleteSamplingRuleInput) SetRuleARN(v string) *DeleteSamplingRuleInput {
	s.RuleARN = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *DeleteSamplingRuleInput) SetRuleName(v string) *DeleteSamplingRuleInput {
	s.RuleName = &v
	return s
}

type DeleteSamplingRuleOutput struct {
	_ struct{} `type:"structure"`

	// The deleted rule definition and metadata.
	SamplingRuleRecord *SamplingRuleRecord `type:"structure"`
}

// String returns the string representation
func (s DeleteSamplingRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSamplingRuleOutput) GoString() string {
	return s.String()
}

// SetSamplingRuleRecord sets the SamplingRuleRecord field's value.
func (s *DeleteSamplingRuleOutput) SetSamplingRuleRecord(v *SamplingRuleRecord) *DeleteSamplingRuleOutput {
	s.SamplingRuleRecord = v
	return s
}

// Information about a connection between two services.
type Edge struct {
	_ struct{} `type:"structure"`

	// Aliases for the edge.
	Aliases []*Alias `type:"list"`

	// The end time of the last segment on the edge.
	EndTime *time.Time `type:"timestamp"`

	// Identifier of the edge. Unique within a service map.
	ReferenceId *int64 `type:"integer"`

	// A histogram that maps the spread of client response times on an edge.
	ResponseTimeHistogram []*HistogramEntry `type:"list"`

	// The start time of the first segment on the edge.
	StartTime *time.Time `type:"timestamp"`

	// Response statistics for segments on the edge.
	SummaryStatistics *EdgeStatistics `type:"structure"`
}

// String returns the string representation
func (s Edge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Edge) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *Edge) SetAliases(v []*Alias) *Edge {
	s.Aliases = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Edge) SetEndTime(v time.Time) *Edge {
	s.EndTime = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *Edge) SetReferenceId(v int64) *Edge {
	s.ReferenceId = &v
	return s
}

// SetResponseTimeHistogram sets the ResponseTimeHistogram field's value.
func (s *Edge) SetResponseTimeHistogram(v []*HistogramEntry) *Edge {
	s.ResponseTimeHistogram = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Edge) SetStartTime(v time.Time) *Edge {
	s.StartTime = &v
	return s
}

// SetSummaryStatistics sets the SummaryStatistics field's value.
func (s *Edge) SetSummaryStatistics(v *EdgeStatistics) *Edge {
	s.SummaryStatistics = v
	return s
}

// Response statistics for an edge.
type EdgeStatistics struct {
	_ struct{} `type:"structure"`

	// Information about requests that failed with a 4xx Client Error status code.
	ErrorStatistics *ErrorStatistics `type:"structure"`

	// Information about requests that failed with a 5xx Server Error status code.
	FaultStatistics *FaultStatistics `type:"structure"`

	// The number of requests that completed with a 2xx Success status code.
	OkCount *int64 `type:"long"`

	// The total number of completed requests.
	TotalCount *int64 `type:"long"`

	// The aggregate response time of completed requests.
	TotalResponseTime *float64 `type:"double"`
}

// String returns the string representation
func (s EdgeStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EdgeStatistics) GoString() string {
	return s.String()
}

// SetErrorStatistics sets the ErrorStatistics field's value.
func (s *EdgeStatistics) SetErrorStatistics(v *ErrorStatistics) *EdgeStatistics {
	s.ErrorStatistics = v
	return s
}

// SetFaultStatistics sets the FaultStatistics field's value.
func (s *EdgeStatistics) SetFaultStatistics(v *FaultStatistics) *EdgeStatistics {
	s.FaultStatistics = v
	return s
}

// SetOkCount sets the OkCount field's value.
func (s *EdgeStatistics) SetOkCount(v int64) *EdgeStatistics {
	s.OkCount = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *EdgeStatistics) SetTotalCount(v int64) *EdgeStatistics {
	s.TotalCount = &v
	return s
}

// SetTotalResponseTime sets the TotalResponseTime field's value.
func (s *EdgeStatistics) SetTotalResponseTime(v float64) *EdgeStatistics {
	s.TotalResponseTime = &v
	return s
}

// A configuration document that specifies encryption configuration settings.
type EncryptionConfig struct {
	_ struct{} `type:"structure"`

	// The ID of the customer master key (CMK) used for encryption, if applicable.
	KeyId *string `type:"string"`

	// The encryption status. While the status is UPDATING, X-Ray may encrypt data
	// with a combination of the new and old settings.
	Status *string `type:"string" enum:"EncryptionStatus"`

	// The type of encryption. Set to KMS for encryption with CMKs. Set to NONE
	// for default encryption.
	Type *string `type:"string" enum:"EncryptionType"`
}

// String returns the string representation
func (s EncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionConfig) GoString() string {
	return s.String()
}

// SetKeyId sets the KeyId field's value.
func (s *EncryptionConfig) SetKeyId(v string) *EncryptionConfig {
	s.KeyId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EncryptionConfig) SetStatus(v string) *EncryptionConfig {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *EncryptionConfig) SetType(v string) *EncryptionConfig {
	s.Type = &v
	return s
}

// The root cause of a trace summary error.
type ErrorRootCause struct {
	_ struct{} `type:"structure"`

	// A flag that denotes that the root cause impacts the trace client.
	ClientImpacting *bool `type:"boolean"`

	// A list of services corresponding to an error. A service identifies a segment
	// and it contains a name, account ID, type, and inferred flag.
	Services []*ErrorRootCauseService `type:"list"`
}

// String returns the string representation
func (s ErrorRootCause) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorRootCause) GoString() string {
	return s.String()
}

// SetClientImpacting sets the ClientImpacting field's value.
func (s *ErrorRootCause) SetClientImpacting(v bool) *ErrorRootCause {
	s.ClientImpacting = &v
	return s
}

// SetServices sets the Services field's value.
func (s *ErrorRootCause) SetServices(v []*ErrorRootCauseService) *ErrorRootCause {
	s.Services = v
	return s
}

// A collection of segments and corresponding subsegments associated to a trace
// summary error.
type ErrorRootCauseEntity struct {
	_ struct{} `type:"structure"`

	// The types and messages of the exceptions.
	Exceptions []*RootCauseException `type:"list"`

	// The name of the entity.
	Name *string `type:"string"`

	// A flag that denotes a remote subsegment.
	Remote *bool `type:"boolean"`
}

// String returns the string representation
func (s ErrorRootCauseEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorRootCauseEntity) GoString() string {
	return s.String()
}

// SetExceptions sets the Exceptions field's value.
func (s *ErrorRootCauseEntity) SetExceptions(v []*RootCauseException) *ErrorRootCauseEntity {
	s.Exceptions = v
	return s
}

// SetName sets the Name field's value.
func (s *ErrorRootCauseEntity) SetName(v string) *ErrorRootCauseEntity {
	s.Name = &v
	return s
}

// SetRemote sets the Remote field's value.
func (s *ErrorRootCauseEntity) SetRemote(v bool) *ErrorRootCauseEntity {
	s.Remote = &v
	return s
}

// A collection of fields identifying the services in a trace summary error.
type ErrorRootCauseService struct {
	_ struct{} `type:"structure"`

	// The account ID associated to the service.
	AccountId *string `type:"string"`

	// The path of root cause entities found on the service.
	EntityPath []*ErrorRootCauseEntity `type:"list"`

	// A Boolean value indicating if the service is inferred from the trace.
	Inferred *bool `type:"boolean"`

	// The service name.
	Name *string `type:"string"`

	// A collection of associated service names.
	Names []*string `type:"list"`

	// The type associated to the service.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ErrorRootCauseService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorRootCauseService) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ErrorRootCauseService) SetAccountId(v string) *ErrorRootCauseService {
	s.AccountId = &v
	return s
}

// SetEntityPath sets the EntityPath field's value.
func (s *ErrorRootCauseService) SetEntityPath(v []*ErrorRootCauseEntity) *ErrorRootCauseService {
	s.EntityPath = v
	return s
}

// SetInferred sets the Inferred field's value.
func (s *ErrorRootCauseService) SetInferred(v bool) *ErrorRootCauseService {
	s.Inferred = &v
	return s
}

// SetName sets the Name field's value.
func (s *ErrorRootCauseService) SetName(v string) *ErrorRootCauseService {
	s.Name = &v
	return s
}

// SetNames sets the Names field's value.
func (s *ErrorRootCauseService) SetNames(v []*string) *ErrorRootCauseService {
	s.Names = v
	return s
}

// SetType sets the Type field's value.
func (s *ErrorRootCauseService) SetType(v string) *ErrorRootCauseService {
	s.Type = &v
	return s
}

// Information about requests that failed with a 4xx Client Error status code.
type ErrorStatistics struct {
	_ struct{} `type:"structure"`

	// The number of requests that failed with untracked 4xx Client Error status
	// codes.
	OtherCount *int64 `type:"long"`

	// The number of requests that failed with a 419 throttling status code.
	ThrottleCount *int64 `type:"long"`

	// The total number of requests that failed with a 4xx Client Error status code.
	TotalCount *int64 `type:"long"`
}

// String returns the string representation
func (s ErrorStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorStatistics) GoString() string {
	return s.String()
}

// SetOtherCount sets the OtherCount field's value.
func (s *ErrorStatistics) SetOtherCount(v int64) *ErrorStatistics {
	s.OtherCount = &v
	return s
}

// SetThrottleCount sets the ThrottleCount field's value.
func (s *ErrorStatistics) SetThrottleCount(v int64) *ErrorStatistics {
	s.ThrottleCount = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ErrorStatistics) SetTotalCount(v int64) *ErrorStatistics {
	s.TotalCount = &v
	return s
}

// The root cause information for a trace summary fault.
type FaultRootCause struct {
	_ struct{} `type:"structure"`

	// A flag that denotes that the root cause impacts the trace client.
	ClientImpacting *bool `type:"boolean"`

	// A list of corresponding services. A service identifies a segment and it contains
	// a name, account ID, type, and inferred flag.
	Services []*FaultRootCauseService `type:"list"`
}

// String returns the string representation
func (s FaultRootCause) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FaultRootCause) GoString() string {
	return s.String()
}

// SetClientImpacting sets the ClientImpacting field's value.
func (s *FaultRootCause) SetClientImpacting(v bool) *FaultRootCause {
	s.ClientImpacting = &v
	return s
}

// SetServices sets the Services field's value.
func (s *FaultRootCause) SetServices(v []*FaultRootCauseService) *FaultRootCause {
	s.Services = v
	return s
}

// A collection of segments and corresponding subsegments associated to a trace
// summary fault error.
type FaultRootCauseEntity struct {
	_ struct{} `type:"structure"`

	// The types and messages of the exceptions.
	Exceptions []*RootCauseException `type:"list"`

	// The name of the entity.
	Name *string `type:"string"`

	// A flag that denotes a remote subsegment.
	Remote *bool `type:"boolean"`
}

// String returns the string representation
func (s FaultRootCauseEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FaultRootCauseEntity) GoString() string {
	return s.String()
}

// SetExceptions sets the Exceptions field's value.
func (s *FaultRootCauseEntity) SetExceptions(v []*RootCauseException) *FaultRootCauseEntity {
	s.Exceptions = v
	return s
}

// SetName sets the Name field's value.
func (s *FaultRootCauseEntity) SetName(v string) *FaultRootCauseEntity {
	s.Name = &v
	return s
}

// SetRemote sets the Remote field's value.
func (s *FaultRootCauseEntity) SetRemote(v bool) *FaultRootCauseEntity {
	s.Remote = &v
	return s
}

// A collection of fields identifying the services in a trace summary fault.
type FaultRootCauseService struct {
	_ struct{} `type:"structure"`

	// The account ID associated to the service.
	AccountId *string `type:"string"`

	// The path of root cause entities found on the service.
	EntityPath []*FaultRootCauseEntity `type:"list"`

	// A Boolean value indicating if the service is inferred from the trace.
	Inferred *bool `type:"boolean"`

	// The service name.
	Name *string `type:"string"`

	// A collection of associated service names.
	Names []*string `type:"list"`

	// The type associated to the service.
	Type *string `type:"string"`
}

// String returns the string representation
func (s FaultRootCauseService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FaultRootCauseService) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *FaultRootCauseService) SetAccountId(v string) *FaultRootCauseService {
	s.AccountId = &v
	return s
}

// SetEntityPath sets the EntityPath field's value.
func (s *FaultRootCauseService) SetEntityPath(v []*FaultRootCauseEntity) *FaultRootCauseService {
	s.EntityPath = v
	return s
}

// SetInferred sets the Inferred field's value.
func (s *FaultRootCauseService) SetInferred(v bool) *FaultRootCauseService {
	s.Inferred = &v
	return s
}

// SetName sets the Name field's value.
func (s *FaultRootCauseService) SetName(v string) *FaultRootCauseService {
	s.Name = &v
	return s
}

// SetNames sets the Names field's value.
func (s *FaultRootCauseService) SetNames(v []*string) *FaultRootCauseService {
	s.Names = v
	return s
}

// SetType sets the Type field's value.
func (s *FaultRootCauseService) SetType(v string) *FaultRootCauseService {
	s.Type = &v
	return s
}

// Information about requests that failed with a 5xx Server Error status code.
type FaultStatistics struct {
	_ struct{} `type:"structure"`

	// The number of requests that failed with untracked 5xx Server Error status
	// codes.
	OtherCount *int64 `type:"long"`

	// The total number of requests that failed with a 5xx Server Error status code.
	TotalCount *int64 `type:"long"`
}

// String returns the string representation
func (s FaultStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FaultStatistics) GoString() string {
	return s.String()
}

// SetOtherCount sets the OtherCount field's value.
func (s *FaultStatistics) SetOtherCount(v int64) *FaultStatistics {
	s.OtherCount = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *FaultStatistics) SetTotalCount(v int64) *FaultStatistics {
	s.TotalCount = &v
	return s
}

type GetEncryptionConfigInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEncryptionConfigInput) GoString() string {
	return s.String()
}

type GetEncryptionConfigOutput struct {
	_ struct{} `type:"structure"`

	// The encryption configuration document.
	EncryptionConfig *EncryptionConfig `type:"structure"`
}

// String returns the string representation
func (s GetEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEncryptionConfigOutput) GoString() string {
	return s.String()
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *GetEncryptionConfigOutput) SetEncryptionConfig(v *EncryptionConfig) *GetEncryptionConfigOutput {
	s.EncryptionConfig = v
	return s
}

type GetGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the group that was generated on creation.
	GroupARN *string `min:"1" type:"string"`

	// The case-sensitive name of the group.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupInput"}
	if s.GroupARN != nil && len(*s.GroupARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupARN", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupARN sets the GroupARN field's value.
func (s *GetGroupInput) SetGroupARN(v string) *GetGroupInput {
	s.GroupARN = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GetGroupInput) SetGroupName(v string) *GetGroupInput {
	s.GroupName = &v
	return s
}

type GetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The group that was requested. Contains the name of the group, the ARN of
	// the group, the filter expression, and the insight configuration assigned
	// to the group.
	Group *Group `type:"structure"`
}

// String returns the string representation
func (s GetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *GetGroupOutput) SetGroup(v *Group) *GetGroupOutput {
	s.Group = v
	return s
}

type GetGroupsInput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *GetGroupsInput) SetNextToken(v string) *GetGroupsInput {
	s.NextToken = &v
	return s
}

type GetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The collection of all active groups.
	Groups []*GroupSummary `type:"list"`

	// Pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupsOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *GetGroupsOutput) SetGroups(v []*GroupSummary) *GetGroupsOutput {
	s.Groups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetGroupsOutput) SetNextToken(v string) *GetGroupsOutput {
	s.NextToken = &v
	return s
}

type GetSamplingRulesInput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetSamplingRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSamplingRulesInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetSamplingRulesInput) SetNextToken(v string) *GetSamplingRulesInput {
	s.NextToken = &v
	return s
}

type GetSamplingRulesOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `type:"string"`

	// Rule definitions and metadata.
	SamplingRuleRecords []*SamplingRuleRecord `type:"list"`
}

// String returns the string representation
func (s GetSamplingRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSamplingRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetSamplingRulesOutput) SetNextToken(v string) *GetSamplingRulesOutput {
	s.NextToken = &v
	return s
}

// SetSamplingRuleRecords sets the SamplingRuleRecords field's value.
func (s *GetSamplingRulesOutput) SetSamplingRuleRecords(v []*SamplingRuleRecord) *GetSamplingRulesOutput {
	s.SamplingRuleRecords = v
	return s
}

type GetSamplingStatisticSummariesInput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetSamplingStatisticSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSamplingStatisticSummariesInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetSamplingStatisticSummariesInput) SetNextToken(v string) *GetSamplingStatisticSummariesInput {
	s.NextToken = &v
	return s
}

type GetSamplingStatisticSummariesOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `type:"string"`

	// Information about the number of requests instrumented for each sampling rule.
	SamplingStatisticSummaries []*SamplingStatisticSummary `type:"list"`
}

// String returns the string representation
func (s GetSamplingStatisticSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSamplingStatisticSummariesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetSamplingStatisticSummariesOutput) SetNextToken(v string) *GetSamplingStatisticSummariesOutput {
	s.NextToken = &v
	return s
}

// SetSamplingStatisticSummaries sets the SamplingStatisticSummaries field's value.
func (s *GetSamplingStatisticSummariesOutput) SetSamplingStatisticSummaries(v []*SamplingStatisticSummary) *GetSamplingStatisticSummariesOutput {
	s.SamplingStatisticSummaries = v
	return s
}

type GetSamplingTargetsInput struct {
	_ struct{} `type:"structure"`

	// Information about rules that the service is using to sample requests.
	//
	// SamplingStatisticsDocuments is a required field
	SamplingStatisticsDocuments []*SamplingStatisticsDocument `type:"list" required:"true"`
}

// String returns the string representation
func (s GetSamplingTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSamplingTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSamplingTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSamplingTargetsInput"}
	if s.SamplingStatisticsDocuments == nil {
		invalidParams.Add(request.NewErrParamRequired("SamplingStatisticsDocuments"))
	}
	if s.SamplingStatisticsDocuments != nil {
		for i, v := range s.SamplingStatisticsDocuments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SamplingStatisticsDocuments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSamplingStatisticsDocuments sets the SamplingStatisticsDocuments field's value.
func (s *GetSamplingTargetsInput) SetSamplingStatisticsDocuments(v []*SamplingStatisticsDocument) *GetSamplingTargetsInput {
	s.SamplingStatisticsDocuments = v
	return s
}

type GetSamplingTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The last time a user changed the sampling rule configuration. If the sampling
	// rule configuration changed since the service last retrieved it, the service
	// should call GetSamplingRules to get the latest version.
	LastRuleModification *time.Time `type:"timestamp"`

	// Updated rules that the service should use to sample requests.
	SamplingTargetDocuments []*SamplingTargetDocument `type:"list"`

	// Information about SamplingStatisticsDocument that X-Ray could not process.
	UnprocessedStatistics []*UnprocessedStatistics `type:"list"`
}

// String returns the string representation
func (s GetSamplingTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSamplingTargetsOutput) GoString() string {
	return s.String()
}

// SetLastRuleModification sets the LastRuleModification field's value.
func (s *GetSamplingTargetsOutput) SetLastRuleModification(v time.Time) *GetSamplingTargetsOutput {
	s.LastRuleModification = &v
	return s
}

// SetSamplingTargetDocuments sets the SamplingTargetDocuments field's value.
func (s *GetSamplingTargetsOutput) SetSamplingTargetDocuments(v []*SamplingTargetDocument) *GetSamplingTargetsOutput {
	s.SamplingTargetDocuments = v
	return s
}

// SetUnprocessedStatistics sets the UnprocessedStatistics field's value.
func (s *GetSamplingTargetsOutput) SetUnprocessedStatistics(v []*UnprocessedStatistics) *GetSamplingTargetsOutput {
	s.UnprocessedStatistics = v
	return s
}

type GetServiceGraphInput struct {
	_ struct{} `type:"structure"`

	// The end of the timeframe for which to generate a graph.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of a group based on which you want to generate
	// a graph.
	GroupARN *string `min:"1" type:"string"`

	// The name of a group based on which you want to generate a graph.
	GroupName *string `min:"1" type:"string"`

	// Pagination token.
	NextToken *string `type:"string"`

	// The start of the time frame for which to generate a graph.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetServiceGraphInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceGraphInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceGraphInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceGraphInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.GroupARN != nil && len(*s.GroupARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupARN", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetServiceGraphInput) SetEndTime(v time.Time) *GetServiceGraphInput {
	s.EndTime = &v
	return s
}

// SetGroupARN sets the GroupARN field's value.
func (s *GetServiceGraphInput) SetGroupARN(v string) *GetServiceGraphInput {
	s.GroupARN = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GetServiceGraphInput) SetGroupName(v string) *GetServiceGraphInput {
	s.GroupName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetServiceGraphInput) SetNextToken(v string) *GetServiceGraphInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetServiceGraphInput) SetStartTime(v time.Time) *GetServiceGraphInput {
	s.StartTime = &v
	return s
}

type GetServiceGraphOutput struct {
	_ struct{} `type:"structure"`

	// A flag indicating whether the group's filter expression has been consistent,
	// or if the returned service graph may show traces from an older version of
	// the group's filter expression.
	ContainsOldGroupVersions *bool `type:"boolean"`

	// The end of the time frame for which the graph was generated.
	EndTime *time.Time `type:"timestamp"`

	// Pagination token.
	NextToken *string `type:"string"`

	// The services that have processed a traced request during the specified time
	// frame.
	Services []*Service `type:"list"`

	// The start of the time frame for which the graph was generated.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s GetServiceGraphOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceGraphOutput) GoString() string {
	return s.String()
}

// SetContainsOldGroupVersions sets the ContainsOldGroupVersions field's value.
func (s *GetServiceGraphOutput) SetContainsOldGroupVersions(v bool) *GetServiceGraphOutput {
	s.ContainsOldGroupVersions = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetServiceGraphOutput) SetEndTime(v time.Time) *GetServiceGraphOutput {
	s.EndTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetServiceGraphOutput) SetNextToken(v string) *GetServiceGraphOutput {
	s.NextToken = &v
	return s
}

// SetServices sets the Services field's value.
func (s *GetServiceGraphOutput) SetServices(v []*Service) *GetServiceGraphOutput {
	s.Services = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetServiceGraphOutput) SetStartTime(v time.Time) *GetServiceGraphOutput {
	s.StartTime = &v
	return s
}

type GetTimeSeriesServiceStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The end of the time frame for which to aggregate statistics.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// A filter expression defining entities that will be aggregated for statistics.
	// Supports ID, service, and edge functions. If no selector expression is specified,
	// edge statistics are returned.
	EntitySelectorExpression *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the group for which to pull statistics
	// from.
	GroupARN *string `min:"1" type:"string"`

	// The case-sensitive name of the group for which to pull statistics from.
	GroupName *string `min:"1" type:"string"`

	// Pagination token.
	NextToken *string `type:"string"`

	// Aggregation period in seconds.
	Period *int64 `type:"integer"`

	// The start of the time frame for which to aggregate statistics.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetTimeSeriesServiceStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTimeSeriesServiceStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTimeSeriesServiceStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTimeSeriesServiceStatisticsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.EntitySelectorExpression != nil && len(*s.EntitySelectorExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntitySelectorExpression", 1))
	}
	if s.GroupARN != nil && len(*s.GroupARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupARN", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetTimeSeriesServiceStatisticsInput) SetEndTime(v time.Time) *GetTimeSeriesServiceStatisticsInput {
	s.EndTime = &v
	return s
}

// SetEntitySelectorExpression sets the EntitySelectorExpression field's value.
func (s *GetTimeSeriesServiceStatisticsInput) SetEntitySelectorExpression(v string) *GetTimeSeriesServiceStatisticsInput {
	s.EntitySelectorExpression = &v
	return s
}

// SetGroupARN sets the GroupARN field's value.
func (s *GetTimeSeriesServiceStatisticsInput) SetGroupARN(v string) *GetTimeSeriesServiceStatisticsInput {
	s.GroupARN = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GetTimeSeriesServiceStatisticsInput) SetGroupName(v string) *GetTimeSeriesServiceStatisticsInput {
	s.GroupName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTimeSeriesServiceStatisticsInput) SetNextToken(v string) *GetTimeSeriesServiceStatisticsInput {
	s.NextToken = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetTimeSeriesServiceStatisticsInput) SetPeriod(v int64) *GetTimeSeriesServiceStatisticsInput {
	s.Period = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetTimeSeriesServiceStatisticsInput) SetStartTime(v time.Time) *GetTimeSeriesServiceStatisticsInput {
	s.StartTime = &v
	return s
}

type GetTimeSeriesServiceStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// A flag indicating whether or not a group's filter expression has been consistent,
	// or if a returned aggregation might show statistics from an older version
	// of the group's filter expression.
	ContainsOldGroupVersions *bool `type:"boolean"`

	// Pagination token.
	NextToken *string `type:"string"`

	// The collection of statistics.
	TimeSeriesServiceStatistics []*TimeSeriesServiceStatistics `type:"list"`
}

// String returns the string representation
func (s GetTimeSeriesServiceStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTimeSeriesServiceStatisticsOutput) GoString() string {
	return s.String()
}

// SetContainsOldGroupVersions sets the ContainsOldGroupVersions field's value.
func (s *GetTimeSeriesServiceStatisticsOutput) SetContainsOldGroupVersions(v bool) *GetTimeSeriesServiceStatisticsOutput {
	s.ContainsOldGroupVersions = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTimeSeriesServiceStatisticsOutput) SetNextToken(v string) *GetTimeSeriesServiceStatisticsOutput {
	s.NextToken = &v
	return s
}

// SetTimeSeriesServiceStatistics sets the TimeSeriesServiceStatistics field's value.
func (s *GetTimeSeriesServiceStatisticsOutput) SetTimeSeriesServiceStatistics(v []*TimeSeriesServiceStatistics) *GetTimeSeriesServiceStatisticsOutput {
	s.TimeSeriesServiceStatistics = v
	return s
}

type GetTraceGraphInput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `type:"string"`

	// Trace IDs of requests for which to generate a service graph.
	//
	// TraceIds is a required field
	TraceIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetTraceGraphInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTraceGraphInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTraceGraphInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTraceGraphInput"}
	if s.TraceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("TraceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *GetTraceGraphInput) SetNextToken(v string) *GetTraceGraphInput {
	s.NextToken = &v
	return s
}

// SetTraceIds sets the TraceIds field's value.
func (s *GetTraceGraphInput) SetTraceIds(v []*string) *GetTraceGraphInput {
	s.TraceIds = v
	return s
}

type GetTraceGraphOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `type:"string"`

	// The services that have processed one of the specified requests.
	Services []*Service `type:"list"`
}

// String returns the string representation
func (s GetTraceGraphOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTraceGraphOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetTraceGraphOutput) SetNextToken(v string) *GetTraceGraphOutput {
	s.NextToken = &v
	return s
}

// SetServices sets the Services field's value.
func (s *GetTraceGraphOutput) SetServices(v []*Service) *GetTraceGraphOutput {
	s.Services = v
	return s
}

type GetTraceSummariesInput struct {
	_ struct{} `type:"structure"`

	// The end of the time frame for which to retrieve traces.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// Specify a filter expression to retrieve trace summaries for services or requests
	// that meet certain requirements.
	FilterExpression *string `type:"string"`

	// Specify the pagination token returned by a previous request to retrieve the
	// next page of results.
	NextToken *string `type:"string"`

	// Set to true to get summaries for only a subset of available traces.
	Sampling *bool `type:"boolean"`

	// A parameter to indicate whether to enable sampling on trace summaries. Input
	// parameters are Name and Value.
	SamplingStrategy *SamplingStrategy `type:"structure"`

	// The start of the time frame for which to retrieve traces.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`

	// A parameter to indicate whether to query trace summaries by TraceId or Event
	// time.
	TimeRangeType *string `type:"string" enum:"TimeRangeType"`
}

// String returns the string representation
func (s GetTraceSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTraceSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTraceSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTraceSummariesInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetTraceSummariesInput) SetEndTime(v time.Time) *GetTraceSummariesInput {
	s.EndTime = &v
	return s
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *GetTraceSummariesInput) SetFilterExpression(v string) *GetTraceSummariesInput {
	s.FilterExpression = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTraceSummariesInput) SetNextToken(v string) *GetTraceSummariesInput {
	s.NextToken = &v
	return s
}

// SetSampling sets the Sampling field's value.
func (s *GetTraceSummariesInput) SetSampling(v bool) *GetTraceSummariesInput {
	s.Sampling = &v
	return s
}

// SetSamplingStrategy sets the SamplingStrategy field's value.
func (s *GetTraceSummariesInput) SetSamplingStrategy(v *SamplingStrategy) *GetTraceSummariesInput {
	s.SamplingStrategy = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetTraceSummariesInput) SetStartTime(v time.Time) *GetTraceSummariesInput {
	s.StartTime = &v
	return s
}

// SetTimeRangeType sets the TimeRangeType field's value.
func (s *GetTraceSummariesInput) SetTimeRangeType(v string) *GetTraceSummariesInput {
	s.TimeRangeType = &v
	return s
}

type GetTraceSummariesOutput struct {
	_ struct{} `type:"structure"`

	// The start time of this page of results.
	ApproximateTime *time.Time `type:"timestamp"`

	// If the requested time frame contained more than one page of results, you
	// can use this token to retrieve the next page. The first page contains the
	// most recent results, closest to the end of the time frame.
	NextToken *string `type:"string"`

	// Trace IDs and annotations for traces that were found in the specified time
	// frame.
	TraceSummaries []*TraceSummary `type:"list"`

	// The total number of traces processed, including traces that did not match
	// the specified filter expression.
	TracesProcessedCount *int64 `type:"long"`
}

// String returns the string representation
func (s GetTraceSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTraceSummariesOutput) GoString() string {
	return s.String()
}

// SetApproximateTime sets the ApproximateTime field's value.
func (s *GetTraceSummariesOutput) SetApproximateTime(v time.Time) *GetTraceSummariesOutput {
	s.ApproximateTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTraceSummariesOutput) SetNextToken(v string) *GetTraceSummariesOutput {
	s.NextToken = &v
	return s
}

// SetTraceSummaries sets the TraceSummaries field's value.
func (s *GetTraceSummariesOutput) SetTraceSummaries(v []*TraceSummary) *GetTraceSummariesOutput {
	s.TraceSummaries = v
	return s
}

// SetTracesProcessedCount sets the TracesProcessedCount field's value.
func (s *GetTraceSummariesOutput) SetTracesProcessedCount(v int64) *GetTraceSummariesOutput {
	s.TracesProcessedCount = &v
	return s
}

// Details and metadata for a group.
type Group struct {
	_ struct{} `type:"structure"`

	// The filter expression defining the parameters to include traces.
	FilterExpression *string `type:"string"`

	// The Amazon Resource Name (ARN) of the group generated based on the GroupName.
	GroupARN *string `type:"string"`

	// The unique case-sensitive name of the group.
	GroupName *string `type:"string"`

	// The structure containing configurations related to insights.
	//
	//    * The InsightsEnabled boolean can be set to true to enable insights for
	//    the group or false to disable insights for the group.
	//
	//    * The NotifcationsEnabled boolean can be set to true to enable insights
	//    notifications through Amazon EventBridge for the group.
	InsightsConfiguration *InsightsConfiguration `type:"structure"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *Group) SetFilterExpression(v string) *Group {
	s.FilterExpression = &v
	return s
}

// SetGroupARN sets the GroupARN field's value.
func (s *Group) SetGroupARN(v string) *Group {
	s.GroupARN = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *Group) SetGroupName(v string) *Group {
	s.GroupName = &v
	return s
}

// SetInsightsConfiguration sets the InsightsConfiguration field's value.
func (s *Group) SetInsightsConfiguration(v *InsightsConfiguration) *Group {
	s.InsightsConfiguration = v
	return s
}

// Details for a group without metadata.
type GroupSummary struct {
	_ struct{} `type:"structure"`

	// The filter expression defining the parameters to include traces.
	FilterExpression *string `type:"string"`

	// The ARN of the group generated based on the GroupName.
	GroupARN *string `type:"string"`

	// The unique case-sensitive name of the group.
	GroupName *string `type:"string"`

	// The structure containing configurations related to insights.
	//
	//    * The InsightsEnabled boolean can be set to true to enable insights for
	//    the group or false to disable insights for the group.
	//
	//    * The NotificationsEnabled boolean can be set to true to enable insights
	//    notifications. Notifications can only be enabled on a group with InsightsEnabled
	//    set to true.
	InsightsConfiguration *InsightsConfiguration `type:"structure"`
}

// String returns the string representation
func (s GroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupSummary) GoString() string {
	return s.String()
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *GroupSummary) SetFilterExpression(v string) *GroupSummary {
	s.FilterExpression = &v
	return s
}

// SetGroupARN sets the GroupARN field's value.
func (s *GroupSummary) SetGroupARN(v string) *GroupSummary {
	s.GroupARN = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GroupSummary) SetGroupName(v string) *GroupSummary {
	s.GroupName = &v
	return s
}

// SetInsightsConfiguration sets the InsightsConfiguration field's value.
func (s *GroupSummary) SetInsightsConfiguration(v *InsightsConfiguration) *GroupSummary {
	s.InsightsConfiguration = v
	return s
}

// An entry in a histogram for a statistic. A histogram maps the range of observed
// values on the X axis, and the prevalence of each value on the Y axis.
type HistogramEntry struct {
	_ struct{} `type:"structure"`

	// The prevalence of the entry.
	Count *int64 `type:"integer"`

	// The value of the entry.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s HistogramEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistogramEntry) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *HistogramEntry) SetCount(v int64) *HistogramEntry {
	s.Count = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HistogramEntry) SetValue(v float64) *HistogramEntry {
	s.Value = &v
	return s
}

// Information about an HTTP request.
type Http struct {
	_ struct{} `type:"structure"`

	// The IP address of the requestor.
	ClientIp *string `type:"string"`

	// The request method.
	HttpMethod *string `type:"string"`

	// The response status.
	HttpStatus *int64 `type:"integer"`

	// The request URL.
	HttpURL *string `type:"string"`

	// The request's user agent string.
	UserAgent *string `type:"string"`
}

// String returns the string representation
func (s Http) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Http) GoString() string {
	return s.String()
}

// SetClientIp sets the ClientIp field's value.
func (s *Http) SetClientIp(v string) *Http {
	s.ClientIp = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *Http) SetHttpMethod(v string) *Http {
	s.HttpMethod = &v
	return s
}

// SetHttpStatus sets the HttpStatus field's value.
func (s *Http) SetHttpStatus(v int64) *Http {
	s.HttpStatus = &v
	return s
}

// SetHttpURL sets the HttpURL field's value.
func (s *Http) SetHttpURL(v string) *Http {
	s.HttpURL = &v
	return s
}

// SetUserAgent sets the UserAgent field's value.
func (s *Http) SetUserAgent(v string) *Http {
	s.UserAgent = &v
	return s
}

// The structure containing configurations related to insights.
type InsightsConfiguration struct {
	_ struct{} `type:"structure"`

	// Set the InsightsEnabled value to true to enable insights or false to disable
	// insights.
	InsightsEnabled *bool `type:"boolean"`

	// Set the NotificationsEnabled value to true to enable insights notifications.
	// Notifications can only be enabled on a group with InsightsEnabled set to
	// true.
	NotificationsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s InsightsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightsConfiguration) GoString() string {
	return s.String()
}

// SetInsightsEnabled sets the InsightsEnabled field's value.
func (s *InsightsConfiguration) SetInsightsEnabled(v bool) *InsightsConfiguration {
	s.InsightsEnabled = &v
	return s
}

// SetNotificationsEnabled sets the NotificationsEnabled field's value.
func (s *InsightsConfiguration) SetNotificationsEnabled(v bool) *InsightsConfiguration {
	s.NotificationsEnabled = &v
	return s
}

// A list of EC2 instance IDs corresponding to the segments in a trace.
type InstanceIdDetail struct {
	_ struct{} `type:"structure"`

	// The ID of a corresponding EC2 instance.
	Id *string `type:"string"`
}

// String returns the string representation
func (s InstanceIdDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceIdDetail) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *InstanceIdDetail) SetId(v string) *InstanceIdDetail {
	s.Id = &v
	return s
}

// The request is missing required parameters or has invalid parameters.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// A pagination token. If multiple pages of results are returned, use the NextToken
	// value returned with the current page of results as the value of this parameter
	// to get the next page of results.
	NextToken *string `type:"string"`

	// The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token. If multiple pages of results are returned, use the NextToken
	// value returned with the current page of results to get the next page of results.
	NextToken *string `type:"string"`

	// A list of tags, as key and value pairs, that is associated with the specified
	// X-Ray group or sampling rule.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type PutEncryptionConfigInput struct {
	_ struct{} `type:"structure"`

	// An AWS KMS customer master key (CMK) in one of the following formats:
	//
	//    * Alias - The name of the key. For example, alias/MyKey.
	//
	//    * Key ID - The KMS key ID of the key. For example, ae4aa6d49-a4d8-9df9-a475-4ff6d7898456.
	//    AWS X-Ray does not support asymmetric CMKs.
	//
	//    * ARN - The full Amazon Resource Name of the key ID or alias. For example,
	//    arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456.
	//    Use this format to specify a key in a different account.
	//
	// Omit this key if you set Type to NONE.
	KeyId *string `min:"1" type:"string"`

	// The type of encryption. Set to KMS to use your own key for encryption. Set
	// to NONE for default encryption.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"EncryptionType"`
}

// String returns the string representation
func (s PutEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEncryptionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEncryptionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEncryptionConfigInput"}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *PutEncryptionConfigInput) SetKeyId(v string) *PutEncryptionConfigInput {
	s.KeyId = &v
	return s
}

// SetType sets the Type field's value.
func (s *PutEncryptionConfigInput) SetType(v string) *PutEncryptionConfigInput {
	s.Type = &v
	return s
}

type PutEncryptionConfigOutput struct {
	_ struct{} `type:"structure"`

	// The new encryption configuration.
	EncryptionConfig *EncryptionConfig `type:"structure"`
}

// String returns the string representation
func (s PutEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEncryptionConfigOutput) GoString() string {
	return s.String()
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *PutEncryptionConfigOutput) SetEncryptionConfig(v *EncryptionConfig) *PutEncryptionConfigOutput {
	s.EncryptionConfig = v
	return s
}

type PutTelemetryRecordsInput struct {
	_ struct{} `type:"structure"`

	EC2InstanceId *string `type:"string"`

	Hostname *string `type:"string"`

	ResourceARN *string `type:"string"`

	// TelemetryRecords is a required field
	TelemetryRecords []*TelemetryRecord `type:"list" required:"true"`
}

// String returns the string representation
func (s PutTelemetryRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTelemetryRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutTelemetryRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutTelemetryRecordsInput"}
	if s.TelemetryRecords == nil {
		invalidParams.Add(request.NewErrParamRequired("TelemetryRecords"))
	}
	if s.TelemetryRecords != nil {
		for i, v := range s.TelemetryRecords {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TelemetryRecords", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEC2InstanceId sets the EC2InstanceId field's value.
func (s *PutTelemetryRecordsInput) SetEC2InstanceId(v string) *PutTelemetryRecordsInput {
	s.EC2InstanceId = &v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *PutTelemetryRecordsInput) SetHostname(v string) *PutTelemetryRecordsInput {
	s.Hostname = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *PutTelemetryRecordsInput) SetResourceARN(v string) *PutTelemetryRecordsInput {
	s.ResourceARN = &v
	return s
}

// SetTelemetryRecords sets the TelemetryRecords field's value.
func (s *PutTelemetryRecordsInput) SetTelemetryRecords(v []*TelemetryRecord) *PutTelemetryRecordsInput {
	s.TelemetryRecords = v
	return s
}

type PutTelemetryRecordsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutTelemetryRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTelemetryRecordsOutput) GoString() string {
	return s.String()
}

type PutTraceSegmentsInput struct {
	_ struct{} `type:"structure"`

	// A string containing a JSON document defining one or more segments or subsegments.
	//
	// TraceSegmentDocuments is a required field
	TraceSegmentDocuments []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s PutTraceSegmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTraceSegmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutTraceSegmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutTraceSegmentsInput"}
	if s.TraceSegmentDocuments == nil {
		invalidParams.Add(request.NewErrParamRequired("TraceSegmentDocuments"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTraceSegmentDocuments sets the TraceSegmentDocuments field's value.
func (s *PutTraceSegmentsInput) SetTraceSegmentDocuments(v []*string) *PutTraceSegmentsInput {
	s.TraceSegmentDocuments = v
	return s
}

type PutTraceSegmentsOutput struct {
	_ struct{} `type:"structure"`

	// Segments that failed processing.
	UnprocessedTraceSegments []*UnprocessedTraceSegment `type:"list"`
}

// String returns the string representation
func (s PutTraceSegmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTraceSegmentsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedTraceSegments sets the UnprocessedTraceSegments field's value.
func (s *PutTraceSegmentsOutput) SetUnprocessedTraceSegments(v []*UnprocessedTraceSegment) *PutTraceSegmentsOutput {
	s.UnprocessedTraceSegments = v
	return s
}

// A list of resources ARNs corresponding to the segments in a trace.
type ResourceARNDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of a corresponding resource.
	ARN *string `type:"string"`
}

// String returns the string representation
func (s ResourceARNDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceARNDetail) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ResourceARNDetail) SetARN(v string) *ResourceARNDetail {
	s.ARN = &v
	return s
}

// The resource was not found. Verify that the name or Amazon Resource Name
// (ARN) of the resource is correct.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The root cause information for a response time warning.
type ResponseTimeRootCause struct {
	_ struct{} `type:"structure"`

	// A flag that denotes that the root cause impacts the trace client.
	ClientImpacting *bool `type:"boolean"`

	// A list of corresponding services. A service identifies a segment and contains
	// a name, account ID, type, and inferred flag.
	Services []*ResponseTimeRootCauseService `type:"list"`
}

// String returns the string representation
func (s ResponseTimeRootCause) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseTimeRootCause) GoString() string {
	return s.String()
}

// SetClientImpacting sets the ClientImpacting field's value.
func (s *ResponseTimeRootCause) SetClientImpacting(v bool) *ResponseTimeRootCause {
	s.ClientImpacting = &v
	return s
}

// SetServices sets the Services field's value.
func (s *ResponseTimeRootCause) SetServices(v []*ResponseTimeRootCauseService) *ResponseTimeRootCause {
	s.Services = v
	return s
}

// A collection of segments and corresponding subsegments associated to a response
// time warning.
type ResponseTimeRootCauseEntity struct {
	_ struct{} `type:"structure"`

	// The type and messages of the exceptions.
	Coverage *float64 `type:"double"`

	// The name of the entity.
	Name *string `type:"string"`

	// A flag that denotes a remote subsegment.
	Remote *bool `type:"boolean"`
}

// String returns the string representation
func (s ResponseTimeRootCauseEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseTimeRootCauseEntity) GoString() string {
	return s.String()
}

// SetCoverage sets the Coverage field's value.
func (s *ResponseTimeRootCauseEntity) SetCoverage(v float64) *ResponseTimeRootCauseEntity {
	s.Coverage = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResponseTimeRootCauseEntity) SetName(v string) *ResponseTimeRootCauseEntity {
	s.Name = &v
	return s
}

// SetRemote sets the Remote field's value.
func (s *ResponseTimeRootCauseEntity) SetRemote(v bool) *ResponseTimeRootCauseEntity {
	s.Remote = &v
	return s
}

// A collection of fields identifying the service in a response time warning.
type ResponseTimeRootCauseService struct {
	_ struct{} `type:"structure"`

	// The account ID associated to the service.
	AccountId *string `type:"string"`

	// The path of root cause entities found on the service.
	EntityPath []*ResponseTimeRootCauseEntity `type:"list"`

	// A Boolean value indicating if the service is inferred from the trace.
	Inferred *bool `type:"boolean"`

	// The service name.
	Name *string `type:"string"`

	// A collection of associated service names.
	Names []*string `type:"list"`

	// The type associated to the service.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ResponseTimeRootCauseService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseTimeRootCauseService) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ResponseTimeRootCauseService) SetAccountId(v string) *ResponseTimeRootCauseService {
	s.AccountId = &v
	return s
}

// SetEntityPath sets the EntityPath field's value.
func (s *ResponseTimeRootCauseService) SetEntityPath(v []*ResponseTimeRootCauseEntity) *ResponseTimeRootCauseService {
	s.EntityPath = v
	return s
}

// SetInferred sets the Inferred field's value.
func (s *ResponseTimeRootCauseService) SetInferred(v bool) *ResponseTimeRootCauseService {
	s.Inferred = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResponseTimeRootCauseService) SetName(v string) *ResponseTimeRootCauseService {
	s.Name = &v
	return s
}

// SetNames sets the Names field's value.
func (s *ResponseTimeRootCauseService) SetNames(v []*string) *ResponseTimeRootCauseService {
	s.Names = v
	return s
}

// SetType sets the Type field's value.
func (s *ResponseTimeRootCauseService) SetType(v string) *ResponseTimeRootCauseService {
	s.Type = &v
	return s
}

// The exception associated with a root cause.
type RootCauseException struct {
	_ struct{} `type:"structure"`

	// The message of the exception.
	Message *string `type:"string"`

	// The name of the exception.
	Name *string `type:"string"`
}

// String returns the string representation
func (s RootCauseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RootCauseException) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *RootCauseException) SetMessage(v string) *RootCauseException {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *RootCauseException) SetName(v string) *RootCauseException {
	s.Name = &v
	return s
}

// You have reached the maximum number of sampling rules.
type RuleLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s RuleLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleLimitExceededException) GoString() string {
	return s.String()
}

func newErrorRuleLimitExceededException(v protocol.ResponseMetadata) error {
	return &RuleLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RuleLimitExceededException) Code() string {
	return "RuleLimitExceededException"
}

// Message returns the exception's message.
func (s *RuleLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RuleLimitExceededException) OrigErr() error {
	return nil
}

func (s *RuleLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RuleLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RuleLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A sampling rule that services use to decide whether to instrument a request.
// Rule fields can match properties of the service, or properties of a request.
// The service can ignore rules that don't match its properties.
type SamplingRule struct {
	_ struct{} `type:"structure"`

	// Matches attributes derived from the request.
	Attributes map[string]*string `type:"map"`

	// The percentage of matching requests to instrument, after the reservoir is
	// exhausted.
	//
	// FixedRate is a required field
	FixedRate *float64 `type:"double" required:"true"`

	// Matches the HTTP method of a request.
	//
	// HTTPMethod is a required field
	HTTPMethod *string `type:"string" required:"true"`

	// Matches the hostname from a request URL.
	//
	// Host is a required field
	Host *string `type:"string" required:"true"`

	// The priority of the sampling rule.
	//
	// Priority is a required field
	Priority *int64 `min:"1" type:"integer" required:"true"`

	// A fixed number of matching requests to instrument per second, prior to applying
	// the fixed rate. The reservoir is not used directly by services, but applies
	// to all services using the rule collectively.
	//
	// ReservoirSize is a required field
	ReservoirSize *int64 `type:"integer" required:"true"`

	// Matches the ARN of the AWS resource on which the service runs.
	//
	// ResourceARN is a required field
	ResourceARN *string `type:"string" required:"true"`

	// The ARN of the sampling rule. Specify a rule by either name or ARN, but not
	// both.
	RuleARN *string `type:"string"`

	// The name of the sampling rule. Specify a rule by either name or ARN, but
	// not both.
	RuleName *string `min:"1" type:"string"`

	// Matches the name that the service uses to identify itself in segments.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`

	// Matches the origin that the service uses to identify its type in segments.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true"`

	// Matches the path from a request URL.
	//
	// URLPath is a required field
	URLPath *string `type:"string" required:"true"`

	// The version of the sampling rule format (1).
	//
	// Version is a required field
	Version *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s SamplingRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SamplingRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SamplingRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SamplingRule"}
	if s.FixedRate == nil {
		invalidParams.Add(request.NewErrParamRequired("FixedRate"))
	}
	if s.HTTPMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HTTPMethod"))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}
	if s.ReservoirSize == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservoirSize"))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}
	if s.URLPath == nil {
		invalidParams.Add(request.NewErrParamRequired("URLPath"))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *SamplingRule) SetAttributes(v map[string]*string) *SamplingRule {
	s.Attributes = v
	return s
}

// SetFixedRate sets the FixedRate field's value.
func (s *SamplingRule) SetFixedRate(v float64) *SamplingRule {
	s.FixedRate = &v
	return s
}

// SetHTTPMethod sets the HTTPMethod field's value.
func (s *SamplingRule) SetHTTPMethod(v string) *SamplingRule {
	s.HTTPMethod = &v
	return s
}

// SetHost sets the Host field's value.
func (s *SamplingRule) SetHost(v string) *SamplingRule {
	s.Host = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *SamplingRule) SetPriority(v int64) *SamplingRule {
	s.Priority = &v
	return s
}

// SetReservoirSize sets the ReservoirSize field's value.
func (s *SamplingRule) SetReservoirSize(v int64) *SamplingRule {
	s.ReservoirSize = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *SamplingRule) SetResourceARN(v string) *SamplingRule {
	s.ResourceARN = &v
	return s
}

// SetRuleARN sets the RuleARN field's value.
func (s *SamplingRule) SetRuleARN(v string) *SamplingRule {
	s.RuleARN = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *SamplingRule) SetRuleName(v string) *SamplingRule {
	s.RuleName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *SamplingRule) SetServiceName(v string) *SamplingRule {
	s.ServiceName = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *SamplingRule) SetServiceType(v string) *SamplingRule {
	s.ServiceType = &v
	return s
}

// SetURLPath sets the URLPath field's value.
func (s *SamplingRule) SetURLPath(v string) *SamplingRule {
	s.URLPath = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SamplingRule) SetVersion(v int64) *SamplingRule {
	s.Version = &v
	return s
}

// A SamplingRule and its metadata.
type SamplingRuleRecord struct {
	_ struct{} `type:"structure"`

	// When the rule was created.
	CreatedAt *time.Time `type:"timestamp"`

	// When the rule was last modified.
	ModifiedAt *time.Time `type:"timestamp"`

	// The sampling rule.
	SamplingRule *SamplingRule `type:"structure"`
}

// String returns the string representation
func (s SamplingRuleRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SamplingRuleRecord) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SamplingRuleRecord) SetCreatedAt(v time.Time) *SamplingRuleRecord {
	s.CreatedAt = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *SamplingRuleRecord) SetModifiedAt(v time.Time) *SamplingRuleRecord {
	s.ModifiedAt = &v
	return s
}

// SetSamplingRule sets the SamplingRule field's value.
func (s *SamplingRuleRecord) SetSamplingRule(v *SamplingRule) *SamplingRuleRecord {
	s.SamplingRule = v
	return s
}

// A document specifying changes to a sampling rule's configuration.
type SamplingRuleUpdate struct {
	_ struct{} `type:"structure"`

	// Matches attributes derived from the request.
	Attributes map[string]*string `type:"map"`

	// The percentage of matching requests to instrument, after the reservoir is
	// exhausted.
	FixedRate *float64 `type:"double"`

	// Matches the HTTP method of a request.
	HTTPMethod *string `type:"string"`

	// Matches the hostname from a request URL.
	Host *string `type:"string"`

	// The priority of the sampling rule.
	Priority *int64 `type:"integer"`

	// A fixed number of matching requests to instrument per second, prior to applying
	// the fixed rate. The reservoir is not used directly by services, but applies
	// to all services using the rule collectively.
	ReservoirSize *int64 `type:"integer"`

	// Matches the ARN of the AWS resource on which the service runs.
	ResourceARN *string `type:"string"`

	// The ARN of the sampling rule. Specify a rule by either name or ARN, but not
	// both.
	RuleARN *string `type:"string"`

	// The name of the sampling rule. Specify a rule by either name or ARN, but
	// not both.
	RuleName *string `min:"1" type:"string"`

	// Matches the name that the service uses to identify itself in segments.
	ServiceName *string `type:"string"`

	// Matches the origin that the service uses to identify its type in segments.
	ServiceType *string `type:"string"`

	// Matches the path from a request URL.
	URLPath *string `type:"string"`
}

// String returns the string representation
func (s SamplingRuleUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SamplingRuleUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SamplingRuleUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SamplingRuleUpdate"}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *SamplingRuleUpdate) SetAttributes(v map[string]*string) *SamplingRuleUpdate {
	s.Attributes = v
	return s
}

// SetFixedRate sets the FixedRate field's value.
func (s *SamplingRuleUpdate) SetFixedRate(v float64) *SamplingRuleUpdate {
	s.FixedRate = &v
	return s
}

// SetHTTPMethod sets the HTTPMethod field's value.
func (s *SamplingRuleUpdate) SetHTTPMethod(v string) *SamplingRuleUpdate {
	s.HTTPMethod = &v
	return s
}

// SetHost sets the Host field's value.
func (s *SamplingRuleUpdate) SetHost(v string) *SamplingRuleUpdate {
	s.Host = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *SamplingRuleUpdate) SetPriority(v int64) *SamplingRuleUpdate {
	s.Priority = &v
	return s
}

// SetReservoirSize sets the ReservoirSize field's value.
func (s *SamplingRuleUpdate) SetReservoirSize(v int64) *SamplingRuleUpdate {
	s.ReservoirSize = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *SamplingRuleUpdate) SetResourceARN(v string) *SamplingRuleUpdate {
	s.ResourceARN = &v
	return s
}

// SetRuleARN sets the RuleARN field's value.
func (s *SamplingRuleUpdate) SetRuleARN(v string) *SamplingRuleUpdate {
	s.RuleARN = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *SamplingRuleUpdate) SetRuleName(v string) *SamplingRuleUpdate {
	s.RuleName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *SamplingRuleUpdate) SetServiceName(v string) *SamplingRuleUpdate {
	s.ServiceName = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *SamplingRuleUpdate) SetServiceType(v string) *SamplingRuleUpdate {
	s.ServiceType = &v
	return s
}

// SetURLPath sets the URLPath field's value.
func (s *SamplingRuleUpdate) SetURLPath(v string) *SamplingRuleUpdate {
	s.URLPath = &v
	return s
}

// Aggregated request sampling data for a sampling rule across all services
// for a 10-second window.
type SamplingStatisticSummary struct {
	_ struct{} `type:"structure"`

	// The number of requests recorded with borrowed reservoir quota.
	BorrowCount *int64 `type:"integer"`

	// The number of requests that matched the rule.
	RequestCount *int64 `type:"integer"`

	// The name of the sampling rule.
	RuleName *string `type:"string"`

	// The number of requests recorded.
	SampledCount *int64 `type:"integer"`

	// The start time of the reporting window.
	Timestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s SamplingStatisticSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SamplingStatisticSummary) GoString() string {
	return s.String()
}

// SetBorrowCount sets the BorrowCount field's value.
func (s *SamplingStatisticSummary) SetBorrowCount(v int64) *SamplingStatisticSummary {
	s.BorrowCount = &v
	return s
}

// SetRequestCount sets the RequestCount field's value.
func (s *SamplingStatisticSummary) SetRequestCount(v int64) *SamplingStatisticSummary {
	s.RequestCount = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *SamplingStatisticSummary) SetRuleName(v string) *SamplingStatisticSummary {
	s.RuleName = &v
	return s
}

// SetSampledCount sets the SampledCount field's value.
func (s *SamplingStatisticSummary) SetSampledCount(v int64) *SamplingStatisticSummary {
	s.SampledCount = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *SamplingStatisticSummary) SetTimestamp(v time.Time) *SamplingStatisticSummary {
	s.Timestamp = &v
	return s
}

// Request sampling results for a single rule from a service. Results are for
// the last 10 seconds unless the service has been assigned a longer reporting
// interval after a previous call to GetSamplingTargets.
type SamplingStatisticsDocument struct {
	_ struct{} `type:"structure"`

	// The number of requests recorded with borrowed reservoir quota.
	BorrowCount *int64 `type:"integer"`

	// A unique identifier for the service in hexadecimal.
	//
	// ClientID is a required field
	ClientID *string `min:"24" type:"string" required:"true"`

	// The number of requests that matched the rule.
	//
	// RequestCount is a required field
	RequestCount *int64 `type:"integer" required:"true"`

	// The name of the sampling rule.
	//
	// RuleName is a required field
	RuleName *string `min:"1" type:"string" required:"true"`

	// The number of requests recorded.
	//
	// SampledCount is a required field
	SampledCount *int64 `type:"integer" required:"true"`

	// The current time.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s SamplingStatisticsDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SamplingStatisticsDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SamplingStatisticsDocument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SamplingStatisticsDocument"}
	if s.ClientID == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientID"))
	}
	if s.ClientID != nil && len(*s.ClientID) < 24 {
		invalidParams.Add(request.NewErrParamMinLen("ClientID", 24))
	}
	if s.RequestCount == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestCount"))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.SampledCount == nil {
		invalidParams.Add(request.NewErrParamRequired("SampledCount"))
	}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBorrowCount sets the BorrowCount field's value.
func (s *SamplingStatisticsDocument) SetBorrowCount(v int64) *SamplingStatisticsDocument {
	s.BorrowCount = &v
	return s
}

// SetClientID sets the ClientID field's value.
func (s *SamplingStatisticsDocument) SetClientID(v string) *SamplingStatisticsDocument {
	s.ClientID = &v
	return s
}

// SetRequestCount sets the RequestCount field's value.
func (s *SamplingStatisticsDocument) SetRequestCount(v int64) *SamplingStatisticsDocument {
	s.RequestCount = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *SamplingStatisticsDocument) SetRuleName(v string) *SamplingStatisticsDocument {
	s.RuleName = &v
	return s
}

// SetSampledCount sets the SampledCount field's value.
func (s *SamplingStatisticsDocument) SetSampledCount(v int64) *SamplingStatisticsDocument {
	s.SampledCount = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *SamplingStatisticsDocument) SetTimestamp(v time.Time) *SamplingStatisticsDocument {
	s.Timestamp = &v
	return s
}

// The name and value of a sampling rule to apply to a trace summary.
type SamplingStrategy struct {
	_ struct{} `type:"structure"`

	// The name of a sampling rule.
	Name *string `type:"string" enum:"SamplingStrategyName"`

	// The value of a sampling rule.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s SamplingStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SamplingStrategy) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SamplingStrategy) SetName(v string) *SamplingStrategy {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SamplingStrategy) SetValue(v float64) *SamplingStrategy {
	s.Value = &v
	return s
}

// Temporary changes to a sampling rule configuration. To meet the global sampling
// target for a rule, X-Ray calculates a new reservoir for each service based
// on the recent sampling results of all services that called GetSamplingTargets.
type SamplingTargetDocument struct {
	_ struct{} `type:"structure"`

	// The percentage of matching requests to instrument, after the reservoir is
	// exhausted.
	FixedRate *float64 `type:"double"`

	// The number of seconds for the service to wait before getting sampling targets
	// again.
	Interval *int64 `type:"integer"`

	// The number of requests per second that X-Ray allocated for this service.
	ReservoirQuota *int64 `type:"integer"`

	// When the reservoir quota expires.
	ReservoirQuotaTTL *time.Time `type:"timestamp"`

	// The name of the sampling rule.
	RuleName *string `type:"string"`
}

// String returns the string representation
func (s SamplingTargetDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SamplingTargetDocument) GoString() string {
	return s.String()
}

// SetFixedRate sets the FixedRate field's value.
func (s *SamplingTargetDocument) SetFixedRate(v float64) *SamplingTargetDocument {
	s.FixedRate = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *SamplingTargetDocument) SetInterval(v int64) *SamplingTargetDocument {
	s.Interval = &v
	return s
}

// SetReservoirQuota sets the ReservoirQuota field's value.
func (s *SamplingTargetDocument) SetReservoirQuota(v int64) *SamplingTargetDocument {
	s.ReservoirQuota = &v
	return s
}

// SetReservoirQuotaTTL sets the ReservoirQuotaTTL field's value.
func (s *SamplingTargetDocument) SetReservoirQuotaTTL(v time.Time) *SamplingTargetDocument {
	s.ReservoirQuotaTTL = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *SamplingTargetDocument) SetRuleName(v string) *SamplingTargetDocument {
	s.RuleName = &v
	return s
}

// A segment from a trace that has been ingested by the X-Ray service. The segment
// can be compiled from documents uploaded with PutTraceSegments, or an inferred
// segment for a downstream service, generated from a subsegment sent by the
// service that called it.
//
// For the full segment document schema, see AWS X-Ray Segment Documents (https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html)
// in the AWS X-Ray Developer Guide.
type Segment struct {
	_ struct{} `type:"structure"`

	// The segment document.
	Document *string `min:"1" type:"string"`

	// The segment's ID.
	Id *string `type:"string"`
}

// String returns the string representation
func (s Segment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Segment) GoString() string {
	return s.String()
}

// SetDocument sets the Document field's value.
func (s *Segment) SetDocument(v string) *Segment {
	s.Document = &v
	return s
}

// SetId sets the Id field's value.
func (s *Segment) SetId(v string) *Segment {
	s.Id = &v
	return s
}

// Information about an application that processed requests, users that made
// requests, or downstream services, resources, and applications that an application
// used.
type Service struct {
	_ struct{} `type:"structure"`

	// Identifier of the AWS account in which the service runs.
	AccountId *string `type:"string"`

	// A histogram that maps the spread of service durations.
	DurationHistogram []*HistogramEntry `type:"list"`

	// Connections to downstream services.
	Edges []*Edge `type:"list"`

	// The end time of the last segment that the service generated.
	EndTime *time.Time `type:"timestamp"`

	// The canonical name of the service.
	Name *string `type:"string"`

	// A list of names for the service, including the canonical name.
	Names []*string `type:"list"`

	// Identifier for the service. Unique within the service map.
	ReferenceId *int64 `type:"integer"`

	// A histogram that maps the spread of service response times.
	ResponseTimeHistogram []*HistogramEntry `type:"list"`

	// Indicates that the service was the first service to process a request.
	Root *bool `type:"boolean"`

	// The start time of the first segment that the service generated.
	StartTime *time.Time `type:"timestamp"`

	// The service's state.
	State *string `type:"string"`

	// Aggregated statistics for the service.
	SummaryStatistics *ServiceStatistics `type:"structure"`

	// The type of service.
	//
	//    * AWS Resource - The type of an AWS resource. For example, AWS::EC2::Instance
	//    for an application running on Amazon EC2 or AWS::DynamoDB::Table for an
	//    Amazon DynamoDB table that the application used.
	//
	//    * AWS Service - The type of an AWS service. For example, AWS::DynamoDB
	//    for downstream calls to Amazon DynamoDB that didn't target a specific
	//    table.
	//
	//    * client - Represents the clients that sent requests to a root service.
	//
	//    * remote - A downstream service of indeterminate type.
	Type *string `type:"string"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Service) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Service) SetAccountId(v string) *Service {
	s.AccountId = &v
	return s
}

// SetDurationHistogram sets the DurationHistogram field's value.
func (s *Service) SetDurationHistogram(v []*HistogramEntry) *Service {
	s.DurationHistogram = v
	return s
}

// SetEdges sets the Edges field's value.
func (s *Service) SetEdges(v []*Edge) *Service {
	s.Edges = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Service) SetEndTime(v time.Time) *Service {
	s.EndTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Service) SetName(v string) *Service {
	s.Name = &v
	return s
}

// SetNames sets the Names field's value.
func (s *Service) SetNames(v []*string) *Service {
	s.Names = v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *Service) SetReferenceId(v int64) *Service {
	s.ReferenceId = &v
	return s
}

// SetResponseTimeHistogram sets the ResponseTimeHistogram field's value.
func (s *Service) SetResponseTimeHistogram(v []*HistogramEntry) *Service {
	s.ResponseTimeHistogram = v
	return s
}

// SetRoot sets the Root field's value.
func (s *Service) SetRoot(v bool) *Service {
	s.Root = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Service) SetStartTime(v time.Time) *Service {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Service) SetState(v string) *Service {
	s.State = &v
	return s
}

// SetSummaryStatistics sets the SummaryStatistics field's value.
func (s *Service) SetSummaryStatistics(v *ServiceStatistics) *Service {
	s.SummaryStatistics = v
	return s
}

// SetType sets the Type field's value.
func (s *Service) SetType(v string) *Service {
	s.Type = &v
	return s
}

type ServiceId struct {
	_ struct{} `type:"structure"`

	AccountId *string `type:"string"`

	Name *string `type:"string"`

	Names []*string `type:"list"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s ServiceId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceId) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ServiceId) SetAccountId(v string) *ServiceId {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceId) SetName(v string) *ServiceId {
	s.Name = &v
	return s
}

// SetNames sets the Names field's value.
func (s *ServiceId) SetNames(v []*string) *ServiceId {
	s.Names = v
	return s
}

// SetType sets the Type field's value.
func (s *ServiceId) SetType(v string) *ServiceId {
	s.Type = &v
	return s
}

// Response statistics for a service.
type ServiceStatistics struct {
	_ struct{} `type:"structure"`

	// Information about requests that failed with a 4xx Client Error status code.
	ErrorStatistics *ErrorStatistics `type:"structure"`

	// Information about requests that failed with a 5xx Server Error status code.
	FaultStatistics *FaultStatistics `type:"structure"`

	// The number of requests that completed with a 2xx Success status code.
	OkCount *int64 `type:"long"`

	// The total number of completed requests.
	TotalCount *int64 `type:"long"`

	// The aggregate response time of completed requests.
	TotalResponseTime *float64 `type:"double"`
}

// String returns the string representation
func (s ServiceStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceStatistics) GoString() string {
	return s.String()
}

// SetErrorStatistics sets the ErrorStatistics field's value.
func (s *ServiceStatistics) SetErrorStatistics(v *ErrorStatistics) *ServiceStatistics {
	s.ErrorStatistics = v
	return s
}

// SetFaultStatistics sets the FaultStatistics field's value.
func (s *ServiceStatistics) SetFaultStatistics(v *FaultStatistics) *ServiceStatistics {
	s.FaultStatistics = v
	return s
}

// SetOkCount sets the OkCount field's value.
func (s *ServiceStatistics) SetOkCount(v int64) *ServiceStatistics {
	s.OkCount = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ServiceStatistics) SetTotalCount(v int64) *ServiceStatistics {
	s.TotalCount = &v
	return s
}

// SetTotalResponseTime sets the TotalResponseTime field's value.
func (s *ServiceStatistics) SetTotalResponseTime(v float64) *ServiceStatistics {
	s.TotalResponseTime = &v
	return s
}

// A map that contains tag keys and tag values to attach to an AWS X-Ray group
// or sampling rule. For more information about ways to use tags, see Tagging
// AWS resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// in the AWS General Reference.
//
// The following restrictions apply to tags:
//
//    * Maximum number of user-applied tags per resource: 50
//
//    * Tag keys and values are case sensitive.
//
//    * Don't use aws: as a prefix for keys; it's reserved for AWS use. You
//    cannot edit or delete system tags.
type Tag struct {
	_ struct{} `type:"structure"`

	// A tag key, such as Stage or Name. A tag key cannot be empty. The key can
	// be a maximum of 128 characters, and can contain only Unicode letters, numbers,
	// or separators, or the following special characters: + - = . _ : /
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// An optional tag value, such as Production or test-only. The value can be
	// a maximum of 255 characters, and contain only Unicode letters, numbers, or
	// separators, or the following special characters: + - = . _ : /
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A map that contains one or more tag keys and tag values to attach to an X-Ray
	// group or sampling rule. For more information about ways to use tags, see
	// Tagging AWS resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the AWS General Reference.
	//
	// The following restrictions apply to tags:
	//
	//    * Maximum number of user-applied tags per resource: 50
	//
	//    * Maximum tag key length: 128 Unicode characters
	//
	//    * Maximum tag value length: 256 Unicode characters
	//
	//    * Valid values for key and value: a-z, A-Z, 0-9, space, and the following
	//    characters: _ . : / = + - and @
	//
	//    * Tag keys and values are case sensitive.
	//
	//    * Don't use aws: as a prefix for keys; it's reserved for AWS use. You
	//    cannot edit or delete system tags.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TelemetryRecord struct {
	_ struct{} `type:"structure"`

	BackendConnectionErrors *BackendConnectionErrors `type:"structure"`

	SegmentsReceivedCount *int64 `type:"integer"`

	SegmentsRejectedCount *int64 `type:"integer"`

	SegmentsSentCount *int64 `type:"integer"`

	SegmentsSpilloverCount *int64 `type:"integer"`

	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s TelemetryRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TelemetryRecord) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TelemetryRecord) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TelemetryRecord"}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackendConnectionErrors sets the BackendConnectionErrors field's value.
func (s *TelemetryRecord) SetBackendConnectionErrors(v *BackendConnectionErrors) *TelemetryRecord {
	s.BackendConnectionErrors = v
	return s
}

// SetSegmentsReceivedCount sets the SegmentsReceivedCount field's value.
func (s *TelemetryRecord) SetSegmentsReceivedCount(v int64) *TelemetryRecord {
	s.SegmentsReceivedCount = &v
	return s
}

// SetSegmentsRejectedCount sets the SegmentsRejectedCount field's value.
func (s *TelemetryRecord) SetSegmentsRejectedCount(v int64) *TelemetryRecord {
	s.SegmentsRejectedCount = &v
	return s
}

// SetSegmentsSentCount sets the SegmentsSentCount field's value.
func (s *TelemetryRecord) SetSegmentsSentCount(v int64) *TelemetryRecord {
	s.SegmentsSentCount = &v
	return s
}

// SetSegmentsSpilloverCount sets the SegmentsSpilloverCount field's value.
func (s *TelemetryRecord) SetSegmentsSpilloverCount(v int64) *TelemetryRecord {
	s.SegmentsSpilloverCount = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *TelemetryRecord) SetTimestamp(v time.Time) *TelemetryRecord {
	s.Timestamp = &v
	return s
}

// The request exceeds the maximum number of requests per second.
type ThrottledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottledException) GoString() string {
	return s.String()
}

func newErrorThrottledException(v protocol.ResponseMetadata) error {
	return &ThrottledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottledException) Code() string {
	return "ThrottledException"
}

// Message returns the exception's message.
func (s *ThrottledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottledException) OrigErr() error {
	return nil
}

func (s *ThrottledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A list of TimeSeriesStatistic structures.
type TimeSeriesServiceStatistics struct {
	_ struct{} `type:"structure"`

	// Response statistics for an edge.
	EdgeSummaryStatistics *EdgeStatistics `type:"structure"`

	// The response time histogram for the selected entities.
	ResponseTimeHistogram []*HistogramEntry `type:"list"`

	// Response statistics for a service.
	ServiceSummaryStatistics *ServiceStatistics `type:"structure"`

	// Timestamp of the window for which statistics are aggregated.
	Timestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TimeSeriesServiceStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeSeriesServiceStatistics) GoString() string {
	return s.String()
}

// SetEdgeSummaryStatistics sets the EdgeSummaryStatistics field's value.
func (s *TimeSeriesServiceStatistics) SetEdgeSummaryStatistics(v *EdgeStatistics) *TimeSeriesServiceStatistics {
	s.EdgeSummaryStatistics = v
	return s
}

// SetResponseTimeHistogram sets the ResponseTimeHistogram field's value.
func (s *TimeSeriesServiceStatistics) SetResponseTimeHistogram(v []*HistogramEntry) *TimeSeriesServiceStatistics {
	s.ResponseTimeHistogram = v
	return s
}

// SetServiceSummaryStatistics sets the ServiceSummaryStatistics field's value.
func (s *TimeSeriesServiceStatistics) SetServiceSummaryStatistics(v *ServiceStatistics) *TimeSeriesServiceStatistics {
	s.ServiceSummaryStatistics = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *TimeSeriesServiceStatistics) SetTimestamp(v time.Time) *TimeSeriesServiceStatistics {
	s.Timestamp = &v
	return s
}

// You have exceeded the maximum number of tags you can apply to this resource.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A collection of segment documents with matching trace IDs.
type Trace struct {
	_ struct{} `type:"structure"`

	// The length of time in seconds between the start time of the root segment
	// and the end time of the last segment that completed.
	Duration *float64 `type:"double"`

	// The unique identifier for the request that generated the trace's segments
	// and subsegments.
	Id *string `min:"1" type:"string"`

	// LimitExceeded is set to true when the trace has exceeded one of the defined
	// quotas. For more information about quotas, see AWS X-Ray endpoints and quotas
	// (https://docs.aws.amazon.com/general/latest/gr/xray.html).
	LimitExceeded *bool `type:"boolean"`

	// Segment documents for the segments and subsegments that comprise the trace.
	Segments []*Segment `type:"list"`
}

// String returns the string representation
func (s Trace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Trace) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *Trace) SetDuration(v float64) *Trace {
	s.Duration = &v
	return s
}

// SetId sets the Id field's value.
func (s *Trace) SetId(v string) *Trace {
	s.Id = &v
	return s
}

// SetLimitExceeded sets the LimitExceeded field's value.
func (s *Trace) SetLimitExceeded(v bool) *Trace {
	s.LimitExceeded = &v
	return s
}

// SetSegments sets the Segments field's value.
func (s *Trace) SetSegments(v []*Segment) *Trace {
	s.Segments = v
	return s
}

// Metadata generated from the segment documents in a trace.
type TraceSummary struct {
	_ struct{} `type:"structure"`

	// Annotations from the trace's segment documents.
	Annotations map[string][]*ValueWithServiceIds `type:"map"`

	// A list of Availability Zones for any zone corresponding to the trace segments.
	AvailabilityZones []*AvailabilityZoneDetail `type:"list"`

	// The length of time in seconds between the start time of the root segment
	// and the end time of the last segment that completed.
	Duration *float64 `type:"double"`

	// The root of a trace.
	EntryPoint *ServiceId `type:"structure"`

	// A collection of ErrorRootCause structures corresponding to the trace segments.
	ErrorRootCauses []*ErrorRootCause `type:"list"`

	// A collection of FaultRootCause structures corresponding to the trace segments.
	FaultRootCauses []*FaultRootCause `type:"list"`

	// The root segment document has a 400 series error.
	HasError *bool `type:"boolean"`

	// The root segment document has a 500 series error.
	HasFault *bool `type:"boolean"`

	// One or more of the segment documents has a 429 throttling error.
	HasThrottle *bool `type:"boolean"`

	// Information about the HTTP request served by the trace.
	Http *Http `type:"structure"`

	// The unique identifier for the request that generated the trace's segments
	// and subsegments.
	Id *string `min:"1" type:"string"`

	// A list of EC2 instance IDs for any instance corresponding to the trace segments.
	InstanceIds []*InstanceIdDetail `type:"list"`

	// One or more of the segment documents is in progress.
	IsPartial *bool `type:"boolean"`

	// The matched time stamp of a defined event.
	MatchedEventTime *time.Time `type:"timestamp"`

	// A list of resource ARNs for any resource corresponding to the trace segments.
	ResourceARNs []*ResourceARNDetail `type:"list"`

	// The length of time in seconds between the start and end times of the root
	// segment. If the service performs work asynchronously, the response time measures
	// the time before the response is sent to the user, while the duration measures
	// the amount of time before the last traced activity completes.
	ResponseTime *float64 `type:"double"`

	// A collection of ResponseTimeRootCause structures corresponding to the trace
	// segments.
	ResponseTimeRootCauses []*ResponseTimeRootCause `type:"list"`

	// The revision number of a trace.
	Revision *int64 `type:"integer"`

	// Service IDs from the trace's segment documents.
	ServiceIds []*ServiceId `type:"list"`

	// Users from the trace's segment documents.
	Users []*TraceUser `type:"list"`
}

// String returns the string representation
func (s TraceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TraceSummary) GoString() string {
	return s.String()
}

// SetAnnotations sets the Annotations field's value.
func (s *TraceSummary) SetAnnotations(v map[string][]*ValueWithServiceIds) *TraceSummary {
	s.Annotations = v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *TraceSummary) SetAvailabilityZones(v []*AvailabilityZoneDetail) *TraceSummary {
	s.AvailabilityZones = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *TraceSummary) SetDuration(v float64) *TraceSummary {
	s.Duration = &v
	return s
}

// SetEntryPoint sets the EntryPoint field's value.
func (s *TraceSummary) SetEntryPoint(v *ServiceId) *TraceSummary {
	s.EntryPoint = v
	return s
}

// SetErrorRootCauses sets the ErrorRootCauses field's value.
func (s *TraceSummary) SetErrorRootCauses(v []*ErrorRootCause) *TraceSummary {
	s.ErrorRootCauses = v
	return s
}

// SetFaultRootCauses sets the FaultRootCauses field's value.
func (s *TraceSummary) SetFaultRootCauses(v []*FaultRootCause) *TraceSummary {
	s.FaultRootCauses = v
	return s
}

// SetHasError sets the HasError field's value.
func (s *TraceSummary) SetHasError(v bool) *TraceSummary {
	s.HasError = &v
	return s
}

// SetHasFault sets the HasFault field's value.
func (s *TraceSummary) SetHasFault(v bool) *TraceSummary {
	s.HasFault = &v
	return s
}

// SetHasThrottle sets the HasThrottle field's value.
func (s *TraceSummary) SetHasThrottle(v bool) *TraceSummary {
	s.HasThrottle = &v
	return s
}

// SetHttp sets the Http field's value.
func (s *TraceSummary) SetHttp(v *Http) *TraceSummary {
	s.Http = v
	return s
}

// SetId sets the Id field's value.
func (s *TraceSummary) SetId(v string) *TraceSummary {
	s.Id = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *TraceSummary) SetInstanceIds(v []*InstanceIdDetail) *TraceSummary {
	s.InstanceIds = v
	return s
}

// SetIsPartial sets the IsPartial field's value.
func (s *TraceSummary) SetIsPartial(v bool) *TraceSummary {
	s.IsPartial = &v
	return s
}

// SetMatchedEventTime sets the MatchedEventTime field's value.
func (s *TraceSummary) SetMatchedEventTime(v time.Time) *TraceSummary {
	s.MatchedEventTime = &v
	return s
}

// SetResourceARNs sets the ResourceARNs field's value.
func (s *TraceSummary) SetResourceARNs(v []*ResourceARNDetail) *TraceSummary {
	s.ResourceARNs = v
	return s
}

// SetResponseTime sets the ResponseTime field's value.
func (s *TraceSummary) SetResponseTime(v float64) *TraceSummary {
	s.ResponseTime = &v
	return s
}

// SetResponseTimeRootCauses sets the ResponseTimeRootCauses field's value.
func (s *TraceSummary) SetResponseTimeRootCauses(v []*ResponseTimeRootCause) *TraceSummary {
	s.ResponseTimeRootCauses = v
	return s
}

// SetRevision sets the Revision field's value.
func (s *TraceSummary) SetRevision(v int64) *TraceSummary {
	s.Revision = &v
	return s
}

// SetServiceIds sets the ServiceIds field's value.
func (s *TraceSummary) SetServiceIds(v []*ServiceId) *TraceSummary {
	s.ServiceIds = v
	return s
}

// SetUsers sets the Users field's value.
func (s *TraceSummary) SetUsers(v []*TraceUser) *TraceSummary {
	s.Users = v
	return s
}

// Information about a user recorded in segment documents.
type TraceUser struct {
	_ struct{} `type:"structure"`

	// Services that the user's request hit.
	ServiceIds []*ServiceId `type:"list"`

	// The user's name.
	UserName *string `type:"string"`
}

// String returns the string representation
func (s TraceUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TraceUser) GoString() string {
	return s.String()
}

// SetServiceIds sets the ServiceIds field's value.
func (s *TraceUser) SetServiceIds(v []*ServiceId) *TraceUser {
	s.ServiceIds = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *TraceUser) SetUserName(v string) *TraceUser {
	s.UserName = &v
	return s
}

// Sampling statistics from a call to GetSamplingTargets that X-Ray could not
// process.
type UnprocessedStatistics struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	Message *string `type:"string"`

	// The name of the sampling rule.
	RuleName *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedStatistics) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UnprocessedStatistics) SetErrorCode(v string) *UnprocessedStatistics {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *UnprocessedStatistics) SetMessage(v string) *UnprocessedStatistics {
	s.Message = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *UnprocessedStatistics) SetRuleName(v string) *UnprocessedStatistics {
	s.RuleName = &v
	return s
}

// Information about a segment that failed processing.
type UnprocessedTraceSegment struct {
	_ struct{} `type:"structure"`

	// The error that caused processing to fail.
	ErrorCode *string `type:"string"`

	// The segment's ID.
	Id *string `type:"string"`

	// The error message.
	Message *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedTraceSegment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedTraceSegment) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UnprocessedTraceSegment) SetErrorCode(v string) *UnprocessedTraceSegment {
	s.ErrorCode = &v
	return s
}

// SetId sets the Id field's value.
func (s *UnprocessedTraceSegment) SetId(v string) *UnprocessedTraceSegment {
	s.Id = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *UnprocessedTraceSegment) SetMessage(v string) *UnprocessedTraceSegment {
	s.Message = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// Keys for one or more tags that you want to remove from an X-Ray group or
	// sampling rule.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateGroupInput struct {
	_ struct{} `type:"structure"`

	// The updated filter expression defining criteria by which to group traces.
	FilterExpression *string `type:"string"`

	// The ARN that was generated upon creation.
	GroupARN *string `min:"1" type:"string"`

	// The case-sensitive name of the group.
	GroupName *string `min:"1" type:"string"`

	// The structure containing configurations related to insights.
	//
	//    * The InsightsEnabled boolean can be set to true to enable insights for
	//    the group or false to disable insights for the group.
	//
	//    * The NotifcationsEnabled boolean can be set to true to enable insights
	//    notifications for the group. Notifications can only be enabled on a group
	//    with InsightsEnabled set to true.
	InsightsConfiguration *InsightsConfiguration `type:"structure"`
}

// String returns the string representation
func (s UpdateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupInput"}
	if s.GroupARN != nil && len(*s.GroupARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupARN", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *UpdateGroupInput) SetFilterExpression(v string) *UpdateGroupInput {
	s.FilterExpression = &v
	return s
}

// SetGroupARN sets the GroupARN field's value.
func (s *UpdateGroupInput) SetGroupARN(v string) *UpdateGroupInput {
	s.GroupARN = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *UpdateGroupInput) SetGroupName(v string) *UpdateGroupInput {
	s.GroupName = &v
	return s
}

// SetInsightsConfiguration sets the InsightsConfiguration field's value.
func (s *UpdateGroupInput) SetInsightsConfiguration(v *InsightsConfiguration) *UpdateGroupInput {
	s.InsightsConfiguration = v
	return s
}

type UpdateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The group that was updated. Contains the name of the group that was updated,
	// the ARN of the group that was updated, the updated filter expression, and
	// the updated insight configuration assigned to the group.
	Group *Group `type:"structure"`
}

// String returns the string representation
func (s UpdateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *UpdateGroupOutput) SetGroup(v *Group) *UpdateGroupOutput {
	s.Group = v
	return s
}

type UpdateSamplingRuleInput struct {
	_ struct{} `type:"structure"`

	// The rule and fields to change.
	//
	// SamplingRuleUpdate is a required field
	SamplingRuleUpdate *SamplingRuleUpdate `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSamplingRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSamplingRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSamplingRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSamplingRuleInput"}
	if s.SamplingRuleUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("SamplingRuleUpdate"))
	}
	if s.SamplingRuleUpdate != nil {
		if err := s.SamplingRuleUpdate.Validate(); err != nil {
			invalidParams.AddNested("SamplingRuleUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSamplingRuleUpdate sets the SamplingRuleUpdate field's value.
func (s *UpdateSamplingRuleInput) SetSamplingRuleUpdate(v *SamplingRuleUpdate) *UpdateSamplingRuleInput {
	s.SamplingRuleUpdate = v
	return s
}

type UpdateSamplingRuleOutput struct {
	_ struct{} `type:"structure"`

	// The updated rule definition and metadata.
	SamplingRuleRecord *SamplingRuleRecord `type:"structure"`
}

// String returns the string representation
func (s UpdateSamplingRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSamplingRuleOutput) GoString() string {
	return s.String()
}

// SetSamplingRuleRecord sets the SamplingRuleRecord field's value.
func (s *UpdateSamplingRuleOutput) SetSamplingRuleRecord(v *SamplingRuleRecord) *UpdateSamplingRuleOutput {
	s.SamplingRuleRecord = v
	return s
}

// Information about a segment annotation.
type ValueWithServiceIds struct {
	_ struct{} `type:"structure"`

	// Values of the annotation.
	AnnotationValue *AnnotationValue `type:"structure"`

	// Services to which the annotation applies.
	ServiceIds []*ServiceId `type:"list"`
}

// String returns the string representation
func (s ValueWithServiceIds) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValueWithServiceIds) GoString() string {
	return s.String()
}

// SetAnnotationValue sets the AnnotationValue field's value.
func (s *ValueWithServiceIds) SetAnnotationValue(v *AnnotationValue) *ValueWithServiceIds {
	s.AnnotationValue = v
	return s
}

// SetServiceIds sets the ServiceIds field's value.
func (s *ValueWithServiceIds) SetServiceIds(v []*ServiceId) *ValueWithServiceIds {
	s.ServiceIds = v
	return s
}

const (
	// EncryptionStatusUpdating is a EncryptionStatus enum value
	EncryptionStatusUpdating = "UPDATING"

	// EncryptionStatusActive is a EncryptionStatus enum value
	EncryptionStatusActive = "ACTIVE"
)

// EncryptionStatus_Values returns all elements of the EncryptionStatus enum
func EncryptionStatus_Values() []string {
	return []string{
		EncryptionStatusUpdating,
		EncryptionStatusActive,
	}
}

const (
	// EncryptionTypeNone is a EncryptionType enum value
	EncryptionTypeNone = "NONE"

	// EncryptionTypeKms is a EncryptionType enum value
	EncryptionTypeKms = "KMS"
)

// EncryptionType_Values returns all elements of the EncryptionType enum
func EncryptionType_Values() []string {
	return []string{
		EncryptionTypeNone,
		EncryptionTypeKms,
	}
}

const (
	// SamplingStrategyNamePartialScan is a SamplingStrategyName enum value
	SamplingStrategyNamePartialScan = "PartialScan"

	// SamplingStrategyNameFixedRate is a SamplingStrategyName enum value
	SamplingStrategyNameFixedRate = "FixedRate"
)

// SamplingStrategyName_Values returns all elements of the SamplingStrategyName enum
func SamplingStrategyName_Values() []string {
	return []string{
		SamplingStrategyNamePartialScan,
		SamplingStrategyNameFixedRate,
	}
}

const (
	// TimeRangeTypeTraceId is a TimeRangeType enum value
	TimeRangeTypeTraceId = "TraceId"

	// TimeRangeTypeEvent is a TimeRangeType enum value
	TimeRangeTypeEvent = "Event"
)

// TimeRangeType_Values returns all elements of the TimeRangeType enum
func TimeRangeType_Values() []string {
	return []string{
		TimeRangeTypeTraceId,
		TimeRangeTypeEvent,
	}
}
