/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	sriovnetworkv1 "github.com/openshift/sriov-network-operator/pkg/apis/sriovnetwork/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSriovNetworkNodeStates implements SriovNetworkNodeStateInterface
type FakeSriovNetworkNodeStates struct {
	Fake *FakeSriovnetworkV1
	ns   string
}

var sriovnetworknodestatesResource = schema.GroupVersionResource{Group: "sriovnetwork.openshift.io", Version: "v1", Resource: "sriovnetworknodestates"}

var sriovnetworknodestatesKind = schema.GroupVersionKind{Group: "sriovnetwork.openshift.io", Version: "v1", Kind: "SriovNetworkNodeState"}

// Get takes name of the sriovNetworkNodeState, and returns the corresponding sriovNetworkNodeState object, and an error if there is any.
func (c *FakeSriovNetworkNodeStates) Get(name string, options v1.GetOptions) (result *sriovnetworkv1.SriovNetworkNodeState, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(sriovnetworknodestatesResource, c.ns, name), &sriovnetworkv1.SriovNetworkNodeState{})

	if obj == nil {
		return nil, err
	}
	return obj.(*sriovnetworkv1.SriovNetworkNodeState), err
}

// List takes label and field selectors, and returns the list of SriovNetworkNodeStates that match those selectors.
func (c *FakeSriovNetworkNodeStates) List(opts v1.ListOptions) (result *sriovnetworkv1.SriovNetworkNodeStateList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(sriovnetworknodestatesResource, sriovnetworknodestatesKind, c.ns, opts), &sriovnetworkv1.SriovNetworkNodeStateList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &sriovnetworkv1.SriovNetworkNodeStateList{ListMeta: obj.(*sriovnetworkv1.SriovNetworkNodeStateList).ListMeta}
	for _, item := range obj.(*sriovnetworkv1.SriovNetworkNodeStateList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested sriovNetworkNodeStates.
func (c *FakeSriovNetworkNodeStates) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(sriovnetworknodestatesResource, c.ns, opts))

}

// Create takes the representation of a sriovNetworkNodeState and creates it.  Returns the server's representation of the sriovNetworkNodeState, and an error, if there is any.
func (c *FakeSriovNetworkNodeStates) Create(sriovNetworkNodeState *sriovnetworkv1.SriovNetworkNodeState) (result *sriovnetworkv1.SriovNetworkNodeState, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(sriovnetworknodestatesResource, c.ns, sriovNetworkNodeState), &sriovnetworkv1.SriovNetworkNodeState{})

	if obj == nil {
		return nil, err
	}
	return obj.(*sriovnetworkv1.SriovNetworkNodeState), err
}

// Update takes the representation of a sriovNetworkNodeState and updates it. Returns the server's representation of the sriovNetworkNodeState, and an error, if there is any.
func (c *FakeSriovNetworkNodeStates) Update(sriovNetworkNodeState *sriovnetworkv1.SriovNetworkNodeState) (result *sriovnetworkv1.SriovNetworkNodeState, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(sriovnetworknodestatesResource, c.ns, sriovNetworkNodeState), &sriovnetworkv1.SriovNetworkNodeState{})

	if obj == nil {
		return nil, err
	}
	return obj.(*sriovnetworkv1.SriovNetworkNodeState), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeSriovNetworkNodeStates) UpdateStatus(sriovNetworkNodeState *sriovnetworkv1.SriovNetworkNodeState) (*sriovnetworkv1.SriovNetworkNodeState, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(sriovnetworknodestatesResource, "status", c.ns, sriovNetworkNodeState), &sriovnetworkv1.SriovNetworkNodeState{})

	if obj == nil {
		return nil, err
	}
	return obj.(*sriovnetworkv1.SriovNetworkNodeState), err
}

// Delete takes name of the sriovNetworkNodeState and deletes it. Returns an error if one occurs.
func (c *FakeSriovNetworkNodeStates) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(sriovnetworknodestatesResource, c.ns, name), &sriovnetworkv1.SriovNetworkNodeState{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSriovNetworkNodeStates) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(sriovnetworknodestatesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &sriovnetworkv1.SriovNetworkNodeStateList{})
	return err
}

// Patch applies the patch and returns the patched sriovNetworkNodeState.
func (c *FakeSriovNetworkNodeStates) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *sriovnetworkv1.SriovNetworkNodeState, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(sriovnetworknodestatesResource, c.ns, name, pt, data, subresources...), &sriovnetworkv1.SriovNetworkNodeState{})

	if obj == nil {
		return nil, err
	}
	return obj.(*sriovnetworkv1.SriovNetworkNodeState), err
}
