// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dataproc/v1beta2/clusters.proto

package dataproc

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The cluster state.
type ClusterStatus_State int32

const (
	// The cluster state is unknown.
	ClusterStatus_UNKNOWN ClusterStatus_State = 0
	// The cluster is being created and set up. It is not ready for use.
	ClusterStatus_CREATING ClusterStatus_State = 1
	// The cluster is currently running and healthy. It is ready for use.
	ClusterStatus_RUNNING ClusterStatus_State = 2
	// The cluster encountered an error. It is not ready for use.
	ClusterStatus_ERROR ClusterStatus_State = 3
	// The cluster is being deleted. It cannot be used.
	ClusterStatus_DELETING ClusterStatus_State = 4
	// The cluster is being updated. It continues to accept and process jobs.
	ClusterStatus_UPDATING ClusterStatus_State = 5
)

var ClusterStatus_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "DELETING",
	5: "UPDATING",
}

var ClusterStatus_State_value = map[string]int32{
	"UNKNOWN":  0,
	"CREATING": 1,
	"RUNNING":  2,
	"ERROR":    3,
	"DELETING": 4,
	"UPDATING": 5,
}

func (x ClusterStatus_State) String() string {
	return proto.EnumName(ClusterStatus_State_name, int32(x))
}

func (ClusterStatus_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{14, 0}
}

// The cluster substate.
type ClusterStatus_Substate int32

const (
	// The cluster substate is unknown.
	ClusterStatus_UNSPECIFIED ClusterStatus_Substate = 0
	// The cluster is known to be in an unhealthy state
	// (for example, critical daemons are not running or HDFS capacity is
	// exhausted).
	//
	// Applies to RUNNING state.
	ClusterStatus_UNHEALTHY ClusterStatus_Substate = 1
	// The agent-reported status is out of date (may occur if
	// Cloud Dataproc loses communication with Agent).
	//
	// Applies to RUNNING state.
	ClusterStatus_STALE_STATUS ClusterStatus_Substate = 2
)

var ClusterStatus_Substate_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "UNHEALTHY",
	2: "STALE_STATUS",
}

var ClusterStatus_Substate_value = map[string]int32{
	"UNSPECIFIED":  0,
	"UNHEALTHY":    1,
	"STALE_STATUS": 2,
}

func (x ClusterStatus_Substate) String() string {
	return proto.EnumName(ClusterStatus_Substate_name, int32(x))
}

func (ClusterStatus_Substate) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{14, 1}
}

// Indicates whether to consume capacity from an reservation or not.
type ReservationAffinity_Type int32

const (
	ReservationAffinity_TYPE_UNSPECIFIED ReservationAffinity_Type = 0
	// Do not consume from any allocated capacity.
	ReservationAffinity_NO_RESERVATION ReservationAffinity_Type = 1
	// Consume any reservation available.
	ReservationAffinity_ANY_RESERVATION ReservationAffinity_Type = 2
	// Must consume from a specific reservation. Must specify key value fields
	// for specifying the reservations.
	ReservationAffinity_SPECIFIC_RESERVATION ReservationAffinity_Type = 3
)

var ReservationAffinity_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "NO_RESERVATION",
	2: "ANY_RESERVATION",
	3: "SPECIFIC_RESERVATION",
}

var ReservationAffinity_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":     0,
	"NO_RESERVATION":       1,
	"ANY_RESERVATION":      2,
	"SPECIFIC_RESERVATION": 3,
}

func (x ReservationAffinity_Type) String() string {
	return proto.EnumName(ReservationAffinity_Type_name, int32(x))
}

func (ReservationAffinity_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{25, 0}
}

// Describes the identifying information, config, and status of
// a cluster of Compute Engine instances.
type Cluster struct {
	// Required. The Google Cloud Platform project ID that the cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The cluster name. Cluster names within a project must be
	// unique. Names of deleted clusters can be reused.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Required. The cluster config. Note that Cloud Dataproc may set
	// default values, and values may change when clusters are updated.
	Config *ClusterConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
	// Optional. The labels to associate with this cluster.
	// Label **keys** must contain 1 to 63 characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	// Label **values** may be empty, but, if present, must contain 1 to 63
	// characters, and must conform to [RFC
	// 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with a cluster.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Cluster status.
	Status *ClusterStatus `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
	// Output only. The previous cluster status.
	StatusHistory []*ClusterStatus `protobuf:"bytes,7,rep,name=status_history,json=statusHistory,proto3" json:"status_history,omitempty"`
	// Output only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc
	// generates this value when it creates the cluster.
	ClusterUuid string `protobuf:"bytes,6,opt,name=cluster_uuid,json=clusterUuid,proto3" json:"cluster_uuid,omitempty"`
	// Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
	//
	// **Beta Feature**: This report is available for testing purposes only. It
	// may be changed before final release.
	Metrics              *ClusterMetrics `protobuf:"bytes,9,opt,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{0}
}

func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Cluster) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetStatus() *ClusterStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Cluster) GetStatusHistory() []*ClusterStatus {
	if m != nil {
		return m.StatusHistory
	}
	return nil
}

func (m *Cluster) GetClusterUuid() string {
	if m != nil {
		return m.ClusterUuid
	}
	return ""
}

func (m *Cluster) GetMetrics() *ClusterMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// The cluster config.
type ClusterConfig struct {
	// Optional. A Google Cloud Storage bucket used to stage job
	// dependencies, config files, and job driver console output.
	// If you do not specify a staging bucket, Cloud
	// Dataproc will determine a Cloud Storage location (US,
	// ASIA, or EU) for your cluster's staging bucket according to the Google
	// Compute Engine zone where your cluster is deployed, and then create
	// and manage this project-level, per-location bucket (see
	// [Cloud Dataproc staging
	// bucket](/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
	ConfigBucket string `protobuf:"bytes,1,opt,name=config_bucket,json=configBucket,proto3" json:"config_bucket,omitempty"`
	// Optional. The shared Compute Engine config settings for
	// all instances in a cluster.
	GceClusterConfig *GceClusterConfig `protobuf:"bytes,8,opt,name=gce_cluster_config,json=gceClusterConfig,proto3" json:"gce_cluster_config,omitempty"`
	// Optional. The Compute Engine config settings for
	// the master instance in a cluster.
	MasterConfig *InstanceGroupConfig `protobuf:"bytes,9,opt,name=master_config,json=masterConfig,proto3" json:"master_config,omitempty"`
	// Optional. The Compute Engine config settings for
	// worker instances in a cluster.
	WorkerConfig *InstanceGroupConfig `protobuf:"bytes,10,opt,name=worker_config,json=workerConfig,proto3" json:"worker_config,omitempty"`
	// Optional. The Compute Engine config settings for
	// additional worker instances in a cluster.
	SecondaryWorkerConfig *InstanceGroupConfig `protobuf:"bytes,12,opt,name=secondary_worker_config,json=secondaryWorkerConfig,proto3" json:"secondary_worker_config,omitempty"`
	// Optional. The config settings for software inside the cluster.
	SoftwareConfig *SoftwareConfig `protobuf:"bytes,13,opt,name=software_config,json=softwareConfig,proto3" json:"software_config,omitempty"`
	// Optional. The config setting for auto delete cluster schedule.
	LifecycleConfig *LifecycleConfig `protobuf:"bytes,14,opt,name=lifecycle_config,json=lifecycleConfig,proto3" json:"lifecycle_config,omitempty"`
	// Optional. Commands to execute on each node after config is
	// completed. By default, executables are run on master and all worker nodes.
	// You can test a node's <code>role</code> metadata to run an executable on
	// a master or worker node, as shown below using `curl` (you can also use
	// `wget`):
	//
	//     ROLE=$(curl -H Metadata-Flavor:Google
	//     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
	//     if [[ "${ROLE}" == 'Master' ]]; then
	//       ... master specific actions ...
	//     else
	//       ... worker specific actions ...
	//     fi
	InitializationActions []*NodeInitializationAction `protobuf:"bytes,11,rep,name=initialization_actions,json=initializationActions,proto3" json:"initialization_actions,omitempty"`
	// Optional. Encryption settings for the cluster.
	EncryptionConfig *EncryptionConfig `protobuf:"bytes,15,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
	// Optional. Autoscaling config for the policy associated with the cluster.
	// Cluster does not autoscale if this field is unset.
	AutoscalingConfig *AutoscalingConfig `protobuf:"bytes,16,opt,name=autoscaling_config,json=autoscalingConfig,proto3" json:"autoscaling_config,omitempty"`
	// Optional. Port/endpoint configuration for this cluster
	EndpointConfig *EndpointConfig `protobuf:"bytes,17,opt,name=endpoint_config,json=endpointConfig,proto3" json:"endpoint_config,omitempty"`
	// Optional. Security related configuration.
	SecurityConfig       *SecurityConfig `protobuf:"bytes,18,opt,name=security_config,json=securityConfig,proto3" json:"security_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ClusterConfig) Reset()         { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()    {}
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{1}
}

func (m *ClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig.Unmarshal(m, b)
}
func (m *ClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig.Marshal(b, m, deterministic)
}
func (m *ClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig.Merge(m, src)
}
func (m *ClusterConfig) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig.Size(m)
}
func (m *ClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig proto.InternalMessageInfo

func (m *ClusterConfig) GetConfigBucket() string {
	if m != nil {
		return m.ConfigBucket
	}
	return ""
}

func (m *ClusterConfig) GetGceClusterConfig() *GceClusterConfig {
	if m != nil {
		return m.GceClusterConfig
	}
	return nil
}

func (m *ClusterConfig) GetMasterConfig() *InstanceGroupConfig {
	if m != nil {
		return m.MasterConfig
	}
	return nil
}

func (m *ClusterConfig) GetWorkerConfig() *InstanceGroupConfig {
	if m != nil {
		return m.WorkerConfig
	}
	return nil
}

func (m *ClusterConfig) GetSecondaryWorkerConfig() *InstanceGroupConfig {
	if m != nil {
		return m.SecondaryWorkerConfig
	}
	return nil
}

func (m *ClusterConfig) GetSoftwareConfig() *SoftwareConfig {
	if m != nil {
		return m.SoftwareConfig
	}
	return nil
}

func (m *ClusterConfig) GetLifecycleConfig() *LifecycleConfig {
	if m != nil {
		return m.LifecycleConfig
	}
	return nil
}

func (m *ClusterConfig) GetInitializationActions() []*NodeInitializationAction {
	if m != nil {
		return m.InitializationActions
	}
	return nil
}

func (m *ClusterConfig) GetEncryptionConfig() *EncryptionConfig {
	if m != nil {
		return m.EncryptionConfig
	}
	return nil
}

func (m *ClusterConfig) GetAutoscalingConfig() *AutoscalingConfig {
	if m != nil {
		return m.AutoscalingConfig
	}
	return nil
}

func (m *ClusterConfig) GetEndpointConfig() *EndpointConfig {
	if m != nil {
		return m.EndpointConfig
	}
	return nil
}

func (m *ClusterConfig) GetSecurityConfig() *SecurityConfig {
	if m != nil {
		return m.SecurityConfig
	}
	return nil
}

// Endpoint config for this cluster
type EndpointConfig struct {
	// Output only. The map of port descriptions to URLs. Will only be populated
	// if enable_http_port_access is true.
	HttpPorts map[string]string `protobuf:"bytes,1,rep,name=http_ports,json=httpPorts,proto3" json:"http_ports,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. If true, enable http access to specific ports on the cluster
	// from external sources. Defaults to false.
	EnableHttpPortAccess bool     `protobuf:"varint,2,opt,name=enable_http_port_access,json=enableHttpPortAccess,proto3" json:"enable_http_port_access,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EndpointConfig) Reset()         { *m = EndpointConfig{} }
func (m *EndpointConfig) String() string { return proto.CompactTextString(m) }
func (*EndpointConfig) ProtoMessage()    {}
func (*EndpointConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{2}
}

func (m *EndpointConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EndpointConfig.Unmarshal(m, b)
}
func (m *EndpointConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EndpointConfig.Marshal(b, m, deterministic)
}
func (m *EndpointConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EndpointConfig.Merge(m, src)
}
func (m *EndpointConfig) XXX_Size() int {
	return xxx_messageInfo_EndpointConfig.Size(m)
}
func (m *EndpointConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_EndpointConfig.DiscardUnknown(m)
}

var xxx_messageInfo_EndpointConfig proto.InternalMessageInfo

func (m *EndpointConfig) GetHttpPorts() map[string]string {
	if m != nil {
		return m.HttpPorts
	}
	return nil
}

func (m *EndpointConfig) GetEnableHttpPortAccess() bool {
	if m != nil {
		return m.EnableHttpPortAccess
	}
	return false
}

// Autoscaling Policy config associated with the cluster.
type AutoscalingConfig struct {
	// Optional. The autoscaling policy used by the cluster.
	//
	// Only resource names including projectid and location (region) are valid.
	// Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]`
	// * `projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]`
	//
	// Note that the policy must be in the same project and Cloud Dataproc region.
	PolicyUri            string   `protobuf:"bytes,1,opt,name=policy_uri,json=policyUri,proto3" json:"policy_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AutoscalingConfig) Reset()         { *m = AutoscalingConfig{} }
func (m *AutoscalingConfig) String() string { return proto.CompactTextString(m) }
func (*AutoscalingConfig) ProtoMessage()    {}
func (*AutoscalingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{3}
}

func (m *AutoscalingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoscalingConfig.Unmarshal(m, b)
}
func (m *AutoscalingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoscalingConfig.Marshal(b, m, deterministic)
}
func (m *AutoscalingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoscalingConfig.Merge(m, src)
}
func (m *AutoscalingConfig) XXX_Size() int {
	return xxx_messageInfo_AutoscalingConfig.Size(m)
}
func (m *AutoscalingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoscalingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AutoscalingConfig proto.InternalMessageInfo

func (m *AutoscalingConfig) GetPolicyUri() string {
	if m != nil {
		return m.PolicyUri
	}
	return ""
}

// Encryption settings for the cluster.
type EncryptionConfig struct {
	// Optional. The Cloud KMS key name to use for PD disk encryption for all
	// instances in the cluster.
	GcePdKmsKeyName      string   `protobuf:"bytes,1,opt,name=gce_pd_kms_key_name,json=gcePdKmsKeyName,proto3" json:"gce_pd_kms_key_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EncryptionConfig) Reset()         { *m = EncryptionConfig{} }
func (m *EncryptionConfig) String() string { return proto.CompactTextString(m) }
func (*EncryptionConfig) ProtoMessage()    {}
func (*EncryptionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{4}
}

func (m *EncryptionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EncryptionConfig.Unmarshal(m, b)
}
func (m *EncryptionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EncryptionConfig.Marshal(b, m, deterministic)
}
func (m *EncryptionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptionConfig.Merge(m, src)
}
func (m *EncryptionConfig) XXX_Size() int {
	return xxx_messageInfo_EncryptionConfig.Size(m)
}
func (m *EncryptionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptionConfig proto.InternalMessageInfo

func (m *EncryptionConfig) GetGcePdKmsKeyName() string {
	if m != nil {
		return m.GcePdKmsKeyName
	}
	return ""
}

// Common config settings for resources of Compute Engine cluster
// instances, applicable to all instances in the cluster.
type GceClusterConfig struct {
	// Optional. The zone where the Compute Engine cluster will be located.
	// On a create request, it is required in the "global" region. If omitted
	// in a non-global Cloud Dataproc region, the service will pick a zone in the
	// corresponding Compute Engine region. On a get request, zone will always be
	// present.
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`
	// * `projects/[project_id]/zones/[zone]`
	// * `us-central1-f`
	ZoneUri string `protobuf:"bytes,1,opt,name=zone_uri,json=zoneUri,proto3" json:"zone_uri,omitempty"`
	// Optional. The Compute Engine network to be used for machine
	// communications. Cannot be specified with subnetwork_uri. If neither
	// `network_uri` nor `subnetwork_uri` is specified, the "default" network of
	// the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
	// [Using Subnetworks](/compute/docs/subnetworks) for more information).
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default`
	// * `projects/[project_id]/regions/global/default`
	// * `default`
	NetworkUri string `protobuf:"bytes,2,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Optional. The Compute Engine subnetwork to be used for machine
	// communications. Cannot be specified with network_uri.
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0`
	// * `projects/[project_id]/regions/us-east1/subnetworks/sub0`
	// * `sub0`
	SubnetworkUri string `protobuf:"bytes,6,opt,name=subnetwork_uri,json=subnetworkUri,proto3" json:"subnetwork_uri,omitempty"`
	// Optional. If true, all instances in the cluster will only have internal IP
	// addresses. By default, clusters are not restricted to internal IP
	// addresses, and will have ephemeral external IP addresses assigned to each
	// instance. This `internal_ip_only` restriction can only be enabled for
	// subnetwork enabled networks, and all off-cluster dependencies must be
	// configured to be accessible without external IP addresses.
	InternalIpOnly bool `protobuf:"varint,7,opt,name=internal_ip_only,json=internalIpOnly,proto3" json:"internal_ip_only,omitempty"`
	// Optional. The service account of the instances. Defaults to the default
	// Compute Engine service account. Custom service accounts need
	// permissions equivalent to the following IAM roles:
	//
	// * roles/logging.logWriter
	// * roles/storage.objectAdmin
	//
	// (see
	// https://cloud.google.com/compute/docs/access/service-accounts#custom_service_accounts
	// for more information).
	// Example: `[account_id]@[project_id].iam.gserviceaccount.com`
	ServiceAccount string `protobuf:"bytes,8,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. The URIs of service account scopes to be included in
	// Compute Engine instances. The following base set of scopes is always
	// included:
	//
	// * https://www.googleapis.com/auth/cloud.useraccounts.readonly
	// * https://www.googleapis.com/auth/devstorage.read_write
	// * https://www.googleapis.com/auth/logging.write
	//
	// If no scopes are specified, the following defaults are also provided:
	//
	// * https://www.googleapis.com/auth/bigquery
	// * https://www.googleapis.com/auth/bigtable.admin.table
	// * https://www.googleapis.com/auth/bigtable.data
	// * https://www.googleapis.com/auth/devstorage.full_control
	ServiceAccountScopes []string `protobuf:"bytes,3,rep,name=service_account_scopes,json=serviceAccountScopes,proto3" json:"service_account_scopes,omitempty"`
	// The Compute Engine tags to add to all instances (see
	// [Tagging instances](/compute/docs/label-or-tag-resources#tags)).
	Tags []string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
	// The Compute Engine metadata entries to add to all instances (see
	// [Project and instance
	// metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Reservation Affinity for consuming Zonal reservation.
	ReservationAffinity  *ReservationAffinity `protobuf:"bytes,11,opt,name=reservation_affinity,json=reservationAffinity,proto3" json:"reservation_affinity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GceClusterConfig) Reset()         { *m = GceClusterConfig{} }
func (m *GceClusterConfig) String() string { return proto.CompactTextString(m) }
func (*GceClusterConfig) ProtoMessage()    {}
func (*GceClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{5}
}

func (m *GceClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GceClusterConfig.Unmarshal(m, b)
}
func (m *GceClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GceClusterConfig.Marshal(b, m, deterministic)
}
func (m *GceClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GceClusterConfig.Merge(m, src)
}
func (m *GceClusterConfig) XXX_Size() int {
	return xxx_messageInfo_GceClusterConfig.Size(m)
}
func (m *GceClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_GceClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_GceClusterConfig proto.InternalMessageInfo

func (m *GceClusterConfig) GetZoneUri() string {
	if m != nil {
		return m.ZoneUri
	}
	return ""
}

func (m *GceClusterConfig) GetNetworkUri() string {
	if m != nil {
		return m.NetworkUri
	}
	return ""
}

func (m *GceClusterConfig) GetSubnetworkUri() string {
	if m != nil {
		return m.SubnetworkUri
	}
	return ""
}

func (m *GceClusterConfig) GetInternalIpOnly() bool {
	if m != nil {
		return m.InternalIpOnly
	}
	return false
}

func (m *GceClusterConfig) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

func (m *GceClusterConfig) GetServiceAccountScopes() []string {
	if m != nil {
		return m.ServiceAccountScopes
	}
	return nil
}

func (m *GceClusterConfig) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *GceClusterConfig) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *GceClusterConfig) GetReservationAffinity() *ReservationAffinity {
	if m != nil {
		return m.ReservationAffinity
	}
	return nil
}

// The config settings for Compute Engine resources in
// an instance group, such as a master or worker group.
type InstanceGroupConfig struct {
	// Optional. The number of VM instances in the instance group.
	// For master instance groups, must be set to 1.
	NumInstances int32 `protobuf:"varint,1,opt,name=num_instances,json=numInstances,proto3" json:"num_instances,omitempty"`
	// Output only. The list of instance names. Cloud Dataproc derives the names
	// from `cluster_name`, `num_instances`, and the instance group.
	InstanceNames []string `protobuf:"bytes,2,rep,name=instance_names,json=instanceNames,proto3" json:"instance_names,omitempty"`
	// Optional. The Compute Engine image resource used for cluster
	// instances. It can be specified or may be inferred from
	// `SoftwareConfig.image_version`.
	ImageUri string `protobuf:"bytes,3,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// Optional. The Compute Engine machine type used for cluster instances.
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
	// * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
	// * `n1-standard-2`
	//
	// **Auto Zone Exception**: If you are using the Cloud Dataproc
	// [Auto Zone
	// Placement](/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
	// feature, you must use the short name of the machine type
	// resource, for example, `n1-standard-2`.
	MachineTypeUri string `protobuf:"bytes,4,opt,name=machine_type_uri,json=machineTypeUri,proto3" json:"machine_type_uri,omitempty"`
	// Optional. Disk option config settings.
	DiskConfig *DiskConfig `protobuf:"bytes,5,opt,name=disk_config,json=diskConfig,proto3" json:"disk_config,omitempty"`
	// Optional. Specifies that this instance group contains preemptible
	// instances.
	IsPreemptible bool `protobuf:"varint,6,opt,name=is_preemptible,json=isPreemptible,proto3" json:"is_preemptible,omitempty"`
	// Output only. The config for Compute Engine Instance Group
	// Manager that manages this group.
	// This is only used for preemptible instance groups.
	ManagedGroupConfig *ManagedGroupConfig `protobuf:"bytes,7,opt,name=managed_group_config,json=managedGroupConfig,proto3" json:"managed_group_config,omitempty"`
	// Optional. The Compute Engine accelerator configuration for these
	// instances.
	Accelerators []*AcceleratorConfig `protobuf:"bytes,8,rep,name=accelerators,proto3" json:"accelerators,omitempty"`
	// Specifies the minimum cpu platform for the Instance Group.
	// See [Cloud Dataproc&rarr;Minimum CPU Platform]
	// (/dataproc/docs/concepts/compute/dataproc-min-cpu).
	MinCpuPlatform       string   `protobuf:"bytes,9,opt,name=min_cpu_platform,json=minCpuPlatform,proto3" json:"min_cpu_platform,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceGroupConfig) Reset()         { *m = InstanceGroupConfig{} }
func (m *InstanceGroupConfig) String() string { return proto.CompactTextString(m) }
func (*InstanceGroupConfig) ProtoMessage()    {}
func (*InstanceGroupConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{6}
}

func (m *InstanceGroupConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstanceGroupConfig.Unmarshal(m, b)
}
func (m *InstanceGroupConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstanceGroupConfig.Marshal(b, m, deterministic)
}
func (m *InstanceGroupConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceGroupConfig.Merge(m, src)
}
func (m *InstanceGroupConfig) XXX_Size() int {
	return xxx_messageInfo_InstanceGroupConfig.Size(m)
}
func (m *InstanceGroupConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceGroupConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceGroupConfig proto.InternalMessageInfo

func (m *InstanceGroupConfig) GetNumInstances() int32 {
	if m != nil {
		return m.NumInstances
	}
	return 0
}

func (m *InstanceGroupConfig) GetInstanceNames() []string {
	if m != nil {
		return m.InstanceNames
	}
	return nil
}

func (m *InstanceGroupConfig) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

func (m *InstanceGroupConfig) GetMachineTypeUri() string {
	if m != nil {
		return m.MachineTypeUri
	}
	return ""
}

func (m *InstanceGroupConfig) GetDiskConfig() *DiskConfig {
	if m != nil {
		return m.DiskConfig
	}
	return nil
}

func (m *InstanceGroupConfig) GetIsPreemptible() bool {
	if m != nil {
		return m.IsPreemptible
	}
	return false
}

func (m *InstanceGroupConfig) GetManagedGroupConfig() *ManagedGroupConfig {
	if m != nil {
		return m.ManagedGroupConfig
	}
	return nil
}

func (m *InstanceGroupConfig) GetAccelerators() []*AcceleratorConfig {
	if m != nil {
		return m.Accelerators
	}
	return nil
}

func (m *InstanceGroupConfig) GetMinCpuPlatform() string {
	if m != nil {
		return m.MinCpuPlatform
	}
	return ""
}

// Specifies the resources used to actively manage an instance group.
type ManagedGroupConfig struct {
	// Output only. The name of the Instance Template used for the Managed
	// Instance Group.
	InstanceTemplateName string `protobuf:"bytes,1,opt,name=instance_template_name,json=instanceTemplateName,proto3" json:"instance_template_name,omitempty"`
	// Output only. The name of the Instance Group Manager for this group.
	InstanceGroupManagerName string   `protobuf:"bytes,2,opt,name=instance_group_manager_name,json=instanceGroupManagerName,proto3" json:"instance_group_manager_name,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *ManagedGroupConfig) Reset()         { *m = ManagedGroupConfig{} }
func (m *ManagedGroupConfig) String() string { return proto.CompactTextString(m) }
func (*ManagedGroupConfig) ProtoMessage()    {}
func (*ManagedGroupConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{7}
}

func (m *ManagedGroupConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManagedGroupConfig.Unmarshal(m, b)
}
func (m *ManagedGroupConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManagedGroupConfig.Marshal(b, m, deterministic)
}
func (m *ManagedGroupConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedGroupConfig.Merge(m, src)
}
func (m *ManagedGroupConfig) XXX_Size() int {
	return xxx_messageInfo_ManagedGroupConfig.Size(m)
}
func (m *ManagedGroupConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedGroupConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedGroupConfig proto.InternalMessageInfo

func (m *ManagedGroupConfig) GetInstanceTemplateName() string {
	if m != nil {
		return m.InstanceTemplateName
	}
	return ""
}

func (m *ManagedGroupConfig) GetInstanceGroupManagerName() string {
	if m != nil {
		return m.InstanceGroupManagerName
	}
	return ""
}

// Specifies the type and number of accelerator cards attached to the instances
// of an instance group (see [GPUs on Compute Engine](/compute/docs/gpus/)).
type AcceleratorConfig struct {
	// Full URL, partial URI, or short name of the accelerator type resource to
	// expose to this instance. See
	// [Compute Engine
	// AcceleratorTypes](/compute/docs/reference/beta/acceleratorTypes)
	//
	// Examples
	// * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80`
	// * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80`
	// * `nvidia-tesla-k80`
	//
	// **Auto Zone Exception**: If you are using the Cloud Dataproc
	// [Auto Zone
	// Placement](/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
	// feature, you must use the short name of the accelerator type
	// resource, for example, `nvidia-tesla-k80`.
	AcceleratorTypeUri string `protobuf:"bytes,1,opt,name=accelerator_type_uri,json=acceleratorTypeUri,proto3" json:"accelerator_type_uri,omitempty"`
	// The number of the accelerator cards of this type exposed to this instance.
	AcceleratorCount     int32    `protobuf:"varint,2,opt,name=accelerator_count,json=acceleratorCount,proto3" json:"accelerator_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AcceleratorConfig) Reset()         { *m = AcceleratorConfig{} }
func (m *AcceleratorConfig) String() string { return proto.CompactTextString(m) }
func (*AcceleratorConfig) ProtoMessage()    {}
func (*AcceleratorConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{8}
}

func (m *AcceleratorConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AcceleratorConfig.Unmarshal(m, b)
}
func (m *AcceleratorConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AcceleratorConfig.Marshal(b, m, deterministic)
}
func (m *AcceleratorConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AcceleratorConfig.Merge(m, src)
}
func (m *AcceleratorConfig) XXX_Size() int {
	return xxx_messageInfo_AcceleratorConfig.Size(m)
}
func (m *AcceleratorConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AcceleratorConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AcceleratorConfig proto.InternalMessageInfo

func (m *AcceleratorConfig) GetAcceleratorTypeUri() string {
	if m != nil {
		return m.AcceleratorTypeUri
	}
	return ""
}

func (m *AcceleratorConfig) GetAcceleratorCount() int32 {
	if m != nil {
		return m.AcceleratorCount
	}
	return 0
}

// Specifies the config of disk options for a group of VM instances.
type DiskConfig struct {
	// Optional. Type of the boot disk (default is "pd-standard").
	// Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or
	// "pd-standard" (Persistent Disk Hard Disk Drive).
	BootDiskType string `protobuf:"bytes,3,opt,name=boot_disk_type,json=bootDiskType,proto3" json:"boot_disk_type,omitempty"`
	// Optional. Size in GB of the boot disk (default is 500GB).
	BootDiskSizeGb int32 `protobuf:"varint,1,opt,name=boot_disk_size_gb,json=bootDiskSizeGb,proto3" json:"boot_disk_size_gb,omitempty"`
	// Number of attached SSDs, from 0 to 4 (default is 0).
	// If SSDs are not attached, the boot disk is used to store runtime logs and
	// [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data.
	// If one or more SSDs are attached, this runtime bulk
	// data is spread across them, and the boot disk contains only basic
	// config and installed binaries.
	NumLocalSsds         int32    `protobuf:"varint,2,opt,name=num_local_ssds,json=numLocalSsds,proto3" json:"num_local_ssds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DiskConfig) Reset()         { *m = DiskConfig{} }
func (m *DiskConfig) String() string { return proto.CompactTextString(m) }
func (*DiskConfig) ProtoMessage()    {}
func (*DiskConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{9}
}

func (m *DiskConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiskConfig.Unmarshal(m, b)
}
func (m *DiskConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiskConfig.Marshal(b, m, deterministic)
}
func (m *DiskConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiskConfig.Merge(m, src)
}
func (m *DiskConfig) XXX_Size() int {
	return xxx_messageInfo_DiskConfig.Size(m)
}
func (m *DiskConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_DiskConfig.DiscardUnknown(m)
}

var xxx_messageInfo_DiskConfig proto.InternalMessageInfo

func (m *DiskConfig) GetBootDiskType() string {
	if m != nil {
		return m.BootDiskType
	}
	return ""
}

func (m *DiskConfig) GetBootDiskSizeGb() int32 {
	if m != nil {
		return m.BootDiskSizeGb
	}
	return 0
}

func (m *DiskConfig) GetNumLocalSsds() int32 {
	if m != nil {
		return m.NumLocalSsds
	}
	return 0
}

// Specifies the cluster auto-delete schedule configuration.
type LifecycleConfig struct {
	// Optional. The duration to keep the cluster alive while idling.
	// Passing this threshold will cause the cluster to be
	// deleted. Valid range: **[10m, 14d]**.
	//
	// Example: **"10m"**, the minimum value, to delete the
	// cluster when it has had no jobs running for 10 minutes.
	IdleDeleteTtl *duration.Duration `protobuf:"bytes,1,opt,name=idle_delete_ttl,json=idleDeleteTtl,proto3" json:"idle_delete_ttl,omitempty"`
	// Either the exact time the cluster should be deleted at or
	// the cluster maximum age.
	//
	// Types that are valid to be assigned to Ttl:
	//	*LifecycleConfig_AutoDeleteTime
	//	*LifecycleConfig_AutoDeleteTtl
	Ttl isLifecycleConfig_Ttl `protobuf_oneof:"ttl"`
	// Output only. The time when cluster became idle (most recent job finished)
	// and became eligible for deletion due to idleness.
	IdleStartTime        *timestamp.Timestamp `protobuf:"bytes,4,opt,name=idle_start_time,json=idleStartTime,proto3" json:"idle_start_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *LifecycleConfig) Reset()         { *m = LifecycleConfig{} }
func (m *LifecycleConfig) String() string { return proto.CompactTextString(m) }
func (*LifecycleConfig) ProtoMessage()    {}
func (*LifecycleConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{10}
}

func (m *LifecycleConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LifecycleConfig.Unmarshal(m, b)
}
func (m *LifecycleConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LifecycleConfig.Marshal(b, m, deterministic)
}
func (m *LifecycleConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LifecycleConfig.Merge(m, src)
}
func (m *LifecycleConfig) XXX_Size() int {
	return xxx_messageInfo_LifecycleConfig.Size(m)
}
func (m *LifecycleConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LifecycleConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LifecycleConfig proto.InternalMessageInfo

func (m *LifecycleConfig) GetIdleDeleteTtl() *duration.Duration {
	if m != nil {
		return m.IdleDeleteTtl
	}
	return nil
}

type isLifecycleConfig_Ttl interface {
	isLifecycleConfig_Ttl()
}

type LifecycleConfig_AutoDeleteTime struct {
	AutoDeleteTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=auto_delete_time,json=autoDeleteTime,proto3,oneof"`
}

type LifecycleConfig_AutoDeleteTtl struct {
	AutoDeleteTtl *duration.Duration `protobuf:"bytes,3,opt,name=auto_delete_ttl,json=autoDeleteTtl,proto3,oneof"`
}

func (*LifecycleConfig_AutoDeleteTime) isLifecycleConfig_Ttl() {}

func (*LifecycleConfig_AutoDeleteTtl) isLifecycleConfig_Ttl() {}

func (m *LifecycleConfig) GetTtl() isLifecycleConfig_Ttl {
	if m != nil {
		return m.Ttl
	}
	return nil
}

func (m *LifecycleConfig) GetAutoDeleteTime() *timestamp.Timestamp {
	if x, ok := m.GetTtl().(*LifecycleConfig_AutoDeleteTime); ok {
		return x.AutoDeleteTime
	}
	return nil
}

func (m *LifecycleConfig) GetAutoDeleteTtl() *duration.Duration {
	if x, ok := m.GetTtl().(*LifecycleConfig_AutoDeleteTtl); ok {
		return x.AutoDeleteTtl
	}
	return nil
}

func (m *LifecycleConfig) GetIdleStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.IdleStartTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LifecycleConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LifecycleConfig_AutoDeleteTime)(nil),
		(*LifecycleConfig_AutoDeleteTtl)(nil),
	}
}

// Security related configuration, including encryption, Kerberos, etc.
type SecurityConfig struct {
	// Kerberos related configuration.
	KerberosConfig       *KerberosConfig `protobuf:"bytes,1,opt,name=kerberos_config,json=kerberosConfig,proto3" json:"kerberos_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *SecurityConfig) Reset()         { *m = SecurityConfig{} }
func (m *SecurityConfig) String() string { return proto.CompactTextString(m) }
func (*SecurityConfig) ProtoMessage()    {}
func (*SecurityConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{11}
}

func (m *SecurityConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityConfig.Unmarshal(m, b)
}
func (m *SecurityConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityConfig.Marshal(b, m, deterministic)
}
func (m *SecurityConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityConfig.Merge(m, src)
}
func (m *SecurityConfig) XXX_Size() int {
	return xxx_messageInfo_SecurityConfig.Size(m)
}
func (m *SecurityConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityConfig proto.InternalMessageInfo

func (m *SecurityConfig) GetKerberosConfig() *KerberosConfig {
	if m != nil {
		return m.KerberosConfig
	}
	return nil
}

// Specifies Kerberos related configuration.
type KerberosConfig struct {
	// Optional. Flag to indicate whether to Kerberize the cluster.
	EnableKerberos bool `protobuf:"varint,1,opt,name=enable_kerberos,json=enableKerberos,proto3" json:"enable_kerberos,omitempty"`
	// Required. The Cloud Storage URI of a KMS encrypted file containing the root
	// principal password.
	RootPrincipalPasswordUri string `protobuf:"bytes,2,opt,name=root_principal_password_uri,json=rootPrincipalPasswordUri,proto3" json:"root_principal_password_uri,omitempty"`
	// Required. The uri of the KMS key used to encrypt various sensitive
	// files.
	KmsKeyUri string `protobuf:"bytes,3,opt,name=kms_key_uri,json=kmsKeyUri,proto3" json:"kms_key_uri,omitempty"`
	// Optional. The Cloud Storage URI of the keystore file used for SSL
	// encryption. If not provided, Dataproc will provide a self-signed
	// certificate.
	KeystoreUri string `protobuf:"bytes,4,opt,name=keystore_uri,json=keystoreUri,proto3" json:"keystore_uri,omitempty"`
	// Optional. The Cloud Storage URI of the truststore file used for SSL
	// encryption. If not provided, Dataproc will provide a self-signed
	// certificate.
	TruststoreUri string `protobuf:"bytes,5,opt,name=truststore_uri,json=truststoreUri,proto3" json:"truststore_uri,omitempty"`
	// Optional. The Cloud Storage URI of a KMS encrypted file containing the
	// password to the user provided keystore. For the self-signed certificate,
	// this password is generated by Dataproc.
	KeystorePasswordUri string `protobuf:"bytes,6,opt,name=keystore_password_uri,json=keystorePasswordUri,proto3" json:"keystore_password_uri,omitempty"`
	// Optional. The Cloud Storage URI of a KMS encrypted file containing the
	// password to the user provided key. For the self-signed certificate, this
	// password is generated by Dataproc.
	KeyPasswordUri string `protobuf:"bytes,7,opt,name=key_password_uri,json=keyPasswordUri,proto3" json:"key_password_uri,omitempty"`
	// Optional. The Cloud Storage URI of a KMS encrypted file containing the
	// password to the user provided truststore. For the self-signed certificate,
	// this password is generated by Dataproc.
	TruststorePasswordUri string `protobuf:"bytes,8,opt,name=truststore_password_uri,json=truststorePasswordUri,proto3" json:"truststore_password_uri,omitempty"`
	// Optional. The remote realm the Dataproc on-cluster KDC will trust, should
	// the user enable cross realm trust.
	CrossRealmTrustRealm string `protobuf:"bytes,9,opt,name=cross_realm_trust_realm,json=crossRealmTrustRealm,proto3" json:"cross_realm_trust_realm,omitempty"`
	// Optional. The KDC (IP or hostname) for the remote trusted realm in a cross
	// realm trust relationship.
	CrossRealmTrustKdc string `protobuf:"bytes,10,opt,name=cross_realm_trust_kdc,json=crossRealmTrustKdc,proto3" json:"cross_realm_trust_kdc,omitempty"`
	// Optional. The admin server (IP or hostname) for the remote trusted realm in
	// a cross realm trust relationship.
	CrossRealmTrustAdminServer string `protobuf:"bytes,11,opt,name=cross_realm_trust_admin_server,json=crossRealmTrustAdminServer,proto3" json:"cross_realm_trust_admin_server,omitempty"`
	// Optional. The Cloud Storage URI of a KMS encrypted file containing the
	// shared password between the on-cluster Kerberos realm and the remote
	// trusted realm, in a cross realm trust relationship.
	CrossRealmTrustSharedPasswordUri string `protobuf:"bytes,12,opt,name=cross_realm_trust_shared_password_uri,json=crossRealmTrustSharedPasswordUri,proto3" json:"cross_realm_trust_shared_password_uri,omitempty"`
	// Optional. The Cloud Storage URI of a KMS encrypted file containing the
	// master key of the KDC database.
	KdcDbKeyUri string `protobuf:"bytes,13,opt,name=kdc_db_key_uri,json=kdcDbKeyUri,proto3" json:"kdc_db_key_uri,omitempty"`
	// Optional. The lifetime of the ticket granting ticket, in hours.
	// If not specified, or user specifies 0, then default value 10
	// will be used.
	TgtLifetimeHours int32 `protobuf:"varint,14,opt,name=tgt_lifetime_hours,json=tgtLifetimeHours,proto3" json:"tgt_lifetime_hours,omitempty"`
	// Optional. The name of the on-cluster Kerberos realm.
	// If not specified, the uppercased domain of hostnames will be the realm.
	Realm                string   `protobuf:"bytes,15,opt,name=realm,proto3" json:"realm,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KerberosConfig) Reset()         { *m = KerberosConfig{} }
func (m *KerberosConfig) String() string { return proto.CompactTextString(m) }
func (*KerberosConfig) ProtoMessage()    {}
func (*KerberosConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{12}
}

func (m *KerberosConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KerberosConfig.Unmarshal(m, b)
}
func (m *KerberosConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KerberosConfig.Marshal(b, m, deterministic)
}
func (m *KerberosConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KerberosConfig.Merge(m, src)
}
func (m *KerberosConfig) XXX_Size() int {
	return xxx_messageInfo_KerberosConfig.Size(m)
}
func (m *KerberosConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_KerberosConfig.DiscardUnknown(m)
}

var xxx_messageInfo_KerberosConfig proto.InternalMessageInfo

func (m *KerberosConfig) GetEnableKerberos() bool {
	if m != nil {
		return m.EnableKerberos
	}
	return false
}

func (m *KerberosConfig) GetRootPrincipalPasswordUri() string {
	if m != nil {
		return m.RootPrincipalPasswordUri
	}
	return ""
}

func (m *KerberosConfig) GetKmsKeyUri() string {
	if m != nil {
		return m.KmsKeyUri
	}
	return ""
}

func (m *KerberosConfig) GetKeystoreUri() string {
	if m != nil {
		return m.KeystoreUri
	}
	return ""
}

func (m *KerberosConfig) GetTruststoreUri() string {
	if m != nil {
		return m.TruststoreUri
	}
	return ""
}

func (m *KerberosConfig) GetKeystorePasswordUri() string {
	if m != nil {
		return m.KeystorePasswordUri
	}
	return ""
}

func (m *KerberosConfig) GetKeyPasswordUri() string {
	if m != nil {
		return m.KeyPasswordUri
	}
	return ""
}

func (m *KerberosConfig) GetTruststorePasswordUri() string {
	if m != nil {
		return m.TruststorePasswordUri
	}
	return ""
}

func (m *KerberosConfig) GetCrossRealmTrustRealm() string {
	if m != nil {
		return m.CrossRealmTrustRealm
	}
	return ""
}

func (m *KerberosConfig) GetCrossRealmTrustKdc() string {
	if m != nil {
		return m.CrossRealmTrustKdc
	}
	return ""
}

func (m *KerberosConfig) GetCrossRealmTrustAdminServer() string {
	if m != nil {
		return m.CrossRealmTrustAdminServer
	}
	return ""
}

func (m *KerberosConfig) GetCrossRealmTrustSharedPasswordUri() string {
	if m != nil {
		return m.CrossRealmTrustSharedPasswordUri
	}
	return ""
}

func (m *KerberosConfig) GetKdcDbKeyUri() string {
	if m != nil {
		return m.KdcDbKeyUri
	}
	return ""
}

func (m *KerberosConfig) GetTgtLifetimeHours() int32 {
	if m != nil {
		return m.TgtLifetimeHours
	}
	return 0
}

func (m *KerberosConfig) GetRealm() string {
	if m != nil {
		return m.Realm
	}
	return ""
}

// Specifies an executable to run on a fully configured node and a
// timeout period for executable completion.
type NodeInitializationAction struct {
	// Required. Cloud Storage URI of executable file.
	ExecutableFile string `protobuf:"bytes,1,opt,name=executable_file,json=executableFile,proto3" json:"executable_file,omitempty"`
	// Optional. Amount of time executable has to complete. Default is
	// 10 minutes. Cluster creation fails with an explanatory error message (the
	// name of the executable that caused the error and the exceeded timeout
	// period) if the executable is not completed at end of the timeout period.
	ExecutionTimeout     *duration.Duration `protobuf:"bytes,2,opt,name=execution_timeout,json=executionTimeout,proto3" json:"execution_timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *NodeInitializationAction) Reset()         { *m = NodeInitializationAction{} }
func (m *NodeInitializationAction) String() string { return proto.CompactTextString(m) }
func (*NodeInitializationAction) ProtoMessage()    {}
func (*NodeInitializationAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{13}
}

func (m *NodeInitializationAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeInitializationAction.Unmarshal(m, b)
}
func (m *NodeInitializationAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeInitializationAction.Marshal(b, m, deterministic)
}
func (m *NodeInitializationAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeInitializationAction.Merge(m, src)
}
func (m *NodeInitializationAction) XXX_Size() int {
	return xxx_messageInfo_NodeInitializationAction.Size(m)
}
func (m *NodeInitializationAction) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeInitializationAction.DiscardUnknown(m)
}

var xxx_messageInfo_NodeInitializationAction proto.InternalMessageInfo

func (m *NodeInitializationAction) GetExecutableFile() string {
	if m != nil {
		return m.ExecutableFile
	}
	return ""
}

func (m *NodeInitializationAction) GetExecutionTimeout() *duration.Duration {
	if m != nil {
		return m.ExecutionTimeout
	}
	return nil
}

// The status of a cluster and its instances.
type ClusterStatus struct {
	// Output only. The cluster's state.
	State ClusterStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataproc.v1beta2.ClusterStatus_State" json:"state,omitempty"`
	// Output only. Optional details of cluster's state.
	Detail string `protobuf:"bytes,2,opt,name=detail,proto3" json:"detail,omitempty"`
	// Output only. Time when this state was entered.
	StateStartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=state_start_time,json=stateStartTime,proto3" json:"state_start_time,omitempty"`
	// Output only. Additional state information that includes
	// status reported by the agent.
	Substate             ClusterStatus_Substate `protobuf:"varint,4,opt,name=substate,proto3,enum=google.cloud.dataproc.v1beta2.ClusterStatus_Substate" json:"substate,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ClusterStatus) Reset()         { *m = ClusterStatus{} }
func (m *ClusterStatus) String() string { return proto.CompactTextString(m) }
func (*ClusterStatus) ProtoMessage()    {}
func (*ClusterStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{14}
}

func (m *ClusterStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterStatus.Unmarshal(m, b)
}
func (m *ClusterStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterStatus.Marshal(b, m, deterministic)
}
func (m *ClusterStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterStatus.Merge(m, src)
}
func (m *ClusterStatus) XXX_Size() int {
	return xxx_messageInfo_ClusterStatus.Size(m)
}
func (m *ClusterStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterStatus proto.InternalMessageInfo

func (m *ClusterStatus) GetState() ClusterStatus_State {
	if m != nil {
		return m.State
	}
	return ClusterStatus_UNKNOWN
}

func (m *ClusterStatus) GetDetail() string {
	if m != nil {
		return m.Detail
	}
	return ""
}

func (m *ClusterStatus) GetStateStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StateStartTime
	}
	return nil
}

func (m *ClusterStatus) GetSubstate() ClusterStatus_Substate {
	if m != nil {
		return m.Substate
	}
	return ClusterStatus_UNSPECIFIED
}

// Specifies the selection and config of software inside the cluster.
type SoftwareConfig struct {
	// Optional. The version of software inside the cluster. It must be one of the
	// supported [Cloud Dataproc
	// Versions](/dataproc/docs/concepts/versioning/dataproc-versions#supported_cloud_dataproc_versions),
	// such as "1.2" (including a subminor version, such as "1.2.29"), or the
	// ["preview"
	// version](/dataproc/docs/concepts/versioning/dataproc-versions#other_versions).
	// If unspecified, it defaults to the latest Debian version.
	ImageVersion string `protobuf:"bytes,1,opt,name=image_version,json=imageVersion,proto3" json:"image_version,omitempty"`
	// Optional. The properties to set on daemon config files.
	//
	// Property keys are specified in `prefix:property` format, for example
	// `core:hadoop.tmp.dir`. The following are supported prefixes
	// and their mappings:
	//
	// * capacity-scheduler: `capacity-scheduler.xml`
	// * core:   `core-site.xml`
	// * distcp: `distcp-default.xml`
	// * hdfs:   `hdfs-site.xml`
	// * hive:   `hive-site.xml`
	// * mapred: `mapred-site.xml`
	// * pig:    `pig.properties`
	// * spark:  `spark-defaults.conf`
	// * yarn:   `yarn-site.xml`
	//
	// For more information, see
	// [Cluster properties](/dataproc/docs/concepts/cluster-properties).
	Properties map[string]string `protobuf:"bytes,2,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The set of optional components to activate on the cluster.
	OptionalComponents   []Component `protobuf:"varint,3,rep,packed,name=optional_components,json=optionalComponents,proto3,enum=google.cloud.dataproc.v1beta2.Component" json:"optional_components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SoftwareConfig) Reset()         { *m = SoftwareConfig{} }
func (m *SoftwareConfig) String() string { return proto.CompactTextString(m) }
func (*SoftwareConfig) ProtoMessage()    {}
func (*SoftwareConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{15}
}

func (m *SoftwareConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareConfig.Unmarshal(m, b)
}
func (m *SoftwareConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareConfig.Marshal(b, m, deterministic)
}
func (m *SoftwareConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareConfig.Merge(m, src)
}
func (m *SoftwareConfig) XXX_Size() int {
	return xxx_messageInfo_SoftwareConfig.Size(m)
}
func (m *SoftwareConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareConfig proto.InternalMessageInfo

func (m *SoftwareConfig) GetImageVersion() string {
	if m != nil {
		return m.ImageVersion
	}
	return ""
}

func (m *SoftwareConfig) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *SoftwareConfig) GetOptionalComponents() []Component {
	if m != nil {
		return m.OptionalComponents
	}
	return nil
}

// Contains cluster daemon metrics, such as HDFS and YARN stats.
//
// **Beta Feature**: This report is available for testing purposes only. It may
// be changed before final release.
type ClusterMetrics struct {
	// The HDFS metrics.
	HdfsMetrics map[string]int64 `protobuf:"bytes,1,rep,name=hdfs_metrics,json=hdfsMetrics,proto3" json:"hdfs_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// The YARN metrics.
	YarnMetrics          map[string]int64 `protobuf:"bytes,2,rep,name=yarn_metrics,json=yarnMetrics,proto3" json:"yarn_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ClusterMetrics) Reset()         { *m = ClusterMetrics{} }
func (m *ClusterMetrics) String() string { return proto.CompactTextString(m) }
func (*ClusterMetrics) ProtoMessage()    {}
func (*ClusterMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{16}
}

func (m *ClusterMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterMetrics.Unmarshal(m, b)
}
func (m *ClusterMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterMetrics.Marshal(b, m, deterministic)
}
func (m *ClusterMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterMetrics.Merge(m, src)
}
func (m *ClusterMetrics) XXX_Size() int {
	return xxx_messageInfo_ClusterMetrics.Size(m)
}
func (m *ClusterMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterMetrics proto.InternalMessageInfo

func (m *ClusterMetrics) GetHdfsMetrics() map[string]int64 {
	if m != nil {
		return m.HdfsMetrics
	}
	return nil
}

func (m *ClusterMetrics) GetYarnMetrics() map[string]int64 {
	if m != nil {
		return m.YarnMetrics
	}
	return nil
}

// A request to create a cluster.
type CreateClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The cluster to create.
	Cluster *Cluster `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Optional. A unique id used to identify the request. If the server
	// receives two [CreateClusterRequest][google.cloud.dataproc.v1beta2.CreateClusterRequest] requests  with the same
	// id, then the second request will be ignored and the
	// first [google.longrunning.Operation][google.longrunning.Operation] created and stored in the backend
	// is returned.
	//
	// It is recommended to always set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	RequestId            string   `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterRequest) Reset()         { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()    {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{17}
}

func (m *CreateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterRequest.Unmarshal(m, b)
}
func (m *CreateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterRequest.Marshal(b, m, deterministic)
}
func (m *CreateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterRequest.Merge(m, src)
}
func (m *CreateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClusterRequest.Size(m)
}
func (m *CreateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterRequest proto.InternalMessageInfo

func (m *CreateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *CreateClusterRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// A request to update a cluster.
type UpdateClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project the
	// cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,5,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Required. The changes to the cluster.
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Optional. Timeout for graceful YARN decomissioning. Graceful
	// decommissioning allows removing nodes from the cluster without
	// interrupting jobs in progress. Timeout specifies how long to wait for jobs
	// in progress to finish before forcefully removing nodes (and potentially
	// interrupting jobs). Default timeout is 0 (for forceful decommission), and
	// the maximum allowed timeout is 1 day.
	//
	// Only supported on Dataproc image versions 1.2 and higher.
	GracefulDecommissionTimeout *duration.Duration `protobuf:"bytes,6,opt,name=graceful_decommission_timeout,json=gracefulDecommissionTimeout,proto3" json:"graceful_decommission_timeout,omitempty"`
	// Required. Specifies the path, relative to `Cluster`, of
	// the field to update. For example, to change the number of workers
	// in a cluster to 5, the `update_mask` parameter would be
	// specified as `config.worker_config.num_instances`,
	// and the `PATCH` request body would specify the new value, as follows:
	//
	//     {
	//       "config":{
	//         "workerConfig":{
	//           "numInstances":"5"
	//         }
	//       }
	//     }
	//
	// Similarly, to change the number of preemptible workers in a cluster to 5,
	// the `update_mask` parameter would be
	// `config.secondary_worker_config.num_instances`, and the `PATCH` request
	// body would be set as follows:
	//
	//     {
	//       "config":{
	//         "secondaryWorkerConfig":{
	//           "numInstances":"5"
	//         }
	//       }
	//     }
	// <strong>Note:</strong> currently only the following fields can be updated:
	//
	// <table>
	// <tr>
	// <td><strong>Mask</strong></td><td><strong>Purpose</strong></td>
	// </tr>
	// <tr>
	// <td>labels</td><td>Updates labels</td>
	// </tr>
	// <tr>
	// <td>config.worker_config.num_instances</td><td>Resize primary worker
	// group</td>
	// </tr>
	// <tr>
	// <td>config.secondary_worker_config.num_instances</td><td>Resize secondary
	// worker group</td>
	// </tr>
	// <tr>
	// <td>config.lifecycle_config.auto_delete_ttl</td><td>Reset MAX TTL
	// duration</td>
	// </tr>
	// <tr>
	// <td>config.lifecycle_config.auto_delete_time</td><td>Update MAX TTL
	// deletion timestamp</td>
	// </tr>
	// <tr>
	// <td>config.lifecycle_config.idle_delete_ttl</td><td>Update Idle TTL
	// duration</td>
	// </tr>
	// <tr>
	// <td>config.autoscaling_config.policy_uri</td><td>Use, stop using, or change
	// autoscaling policies</td>
	// </tr>
	// </table>
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. A unique id used to identify the request. If the server
	// receives two [UpdateClusterRequest][google.cloud.dataproc.v1beta2.UpdateClusterRequest] requests  with the same
	// id, then the second request will be ignored and the
	// first [google.longrunning.Operation][google.longrunning.Operation] created and stored in the
	// backend is returned.
	//
	// It is recommended to always set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	RequestId            string   `protobuf:"bytes,7,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterRequest) Reset()         { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()    {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{18}
}

func (m *UpdateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterRequest.Unmarshal(m, b)
}
func (m *UpdateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterRequest.Marshal(b, m, deterministic)
}
func (m *UpdateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterRequest.Merge(m, src)
}
func (m *UpdateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterRequest.Size(m)
}
func (m *UpdateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterRequest proto.InternalMessageInfo

func (m *UpdateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *UpdateClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *UpdateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *UpdateClusterRequest) GetGracefulDecommissionTimeout() *duration.Duration {
	if m != nil {
		return m.GracefulDecommissionTimeout
	}
	return nil
}

func (m *UpdateClusterRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateClusterRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// A request to delete a cluster.
type DeleteClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Optional. Specifying the `cluster_uuid` means the RPC should fail
	// (with error NOT_FOUND) if cluster with specified UUID does not exist.
	ClusterUuid string `protobuf:"bytes,4,opt,name=cluster_uuid,json=clusterUuid,proto3" json:"cluster_uuid,omitempty"`
	// Optional. A unique id used to identify the request. If the server
	// receives two [DeleteClusterRequest][google.cloud.dataproc.v1beta2.DeleteClusterRequest] requests  with the same
	// id, then the second request will be ignored and the
	// first [google.longrunning.Operation][google.longrunning.Operation] created and stored in the
	// backend is returned.
	//
	// It is recommended to always set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	RequestId            string   `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterRequest) Reset()         { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()    {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{19}
}

func (m *DeleteClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterRequest.Unmarshal(m, b)
}
func (m *DeleteClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterRequest.Marshal(b, m, deterministic)
}
func (m *DeleteClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterRequest.Merge(m, src)
}
func (m *DeleteClusterRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterRequest.Size(m)
}
func (m *DeleteClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterRequest proto.InternalMessageInfo

func (m *DeleteClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *DeleteClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *DeleteClusterRequest) GetClusterUuid() string {
	if m != nil {
		return m.ClusterUuid
	}
	return ""
}

func (m *DeleteClusterRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// Request to get the resource representation for a cluster in a project.
type GetClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName          string   `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClusterRequest) Reset()         { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()    {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{20}
}

func (m *GetClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetClusterRequest.Unmarshal(m, b)
}
func (m *GetClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetClusterRequest.Marshal(b, m, deterministic)
}
func (m *GetClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClusterRequest.Merge(m, src)
}
func (m *GetClusterRequest) XXX_Size() int {
	return xxx_messageInfo_GetClusterRequest.Size(m)
}
func (m *GetClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClusterRequest proto.InternalMessageInfo

func (m *GetClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *GetClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

// A request to list the clusters in a project.
type ListClustersRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,4,opt,name=region,proto3" json:"region,omitempty"`
	// Optional.  A filter constraining the clusters to list. Filters are
	// case-sensitive and have the following syntax:
	//
	// field = value [AND [field = value]] ...
	//
	// where **field** is one of `status.state`, `clusterName`, or `labels.[KEY]`,
	// and `[KEY]` is a label key. **value** can be `*` to match all values.
	// `status.state` can be one of the following: `ACTIVE`, `INACTIVE`,
	// `CREATING`, `RUNNING`, `ERROR`, `DELETING`, or `UPDATING`. `ACTIVE`
	// contains the `CREATING`, `UPDATING`, and `RUNNING` states. `INACTIVE`
	// contains the `DELETING` and `ERROR` states.
	// `clusterName` is the name of the cluster provided at creation time.
	// Only the logical `AND` operator is supported; space-separated items are
	// treated as having an implicit `AND` operator.
	//
	// Example filter:
	//
	// status.state = ACTIVE AND clusterName = mycluster
	// AND labels.env = staging AND labels.starred = *
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The standard List page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The standard List page token.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersRequest) Reset()         { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()    {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{21}
}

func (m *ListClustersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersRequest.Unmarshal(m, b)
}
func (m *ListClustersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersRequest.Marshal(b, m, deterministic)
}
func (m *ListClustersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersRequest.Merge(m, src)
}
func (m *ListClustersRequest) XXX_Size() int {
	return xxx_messageInfo_ListClustersRequest.Size(m)
}
func (m *ListClustersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersRequest proto.InternalMessageInfo

func (m *ListClustersRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListClustersRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *ListClustersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListClustersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The list of all clusters in a project.
type ListClustersResponse struct {
	// Output only. The clusters in the project.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// Output only. This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// `page_token` in a subsequent <code>ListClustersRequest</code>.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersResponse) Reset()         { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()    {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{22}
}

func (m *ListClustersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersResponse.Unmarshal(m, b)
}
func (m *ListClustersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersResponse.Marshal(b, m, deterministic)
}
func (m *ListClustersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersResponse.Merge(m, src)
}
func (m *ListClustersResponse) XXX_Size() int {
	return xxx_messageInfo_ListClustersResponse.Size(m)
}
func (m *ListClustersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersResponse proto.InternalMessageInfo

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to collect cluster diagnostic information.
type DiagnoseClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName          string   `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DiagnoseClusterRequest) Reset()         { *m = DiagnoseClusterRequest{} }
func (m *DiagnoseClusterRequest) String() string { return proto.CompactTextString(m) }
func (*DiagnoseClusterRequest) ProtoMessage()    {}
func (*DiagnoseClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{23}
}

func (m *DiagnoseClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiagnoseClusterRequest.Unmarshal(m, b)
}
func (m *DiagnoseClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiagnoseClusterRequest.Marshal(b, m, deterministic)
}
func (m *DiagnoseClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiagnoseClusterRequest.Merge(m, src)
}
func (m *DiagnoseClusterRequest) XXX_Size() int {
	return xxx_messageInfo_DiagnoseClusterRequest.Size(m)
}
func (m *DiagnoseClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DiagnoseClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DiagnoseClusterRequest proto.InternalMessageInfo

func (m *DiagnoseClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DiagnoseClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *DiagnoseClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

// The location of diagnostic output.
type DiagnoseClusterResults struct {
	// Output only. The Cloud Storage URI of the diagnostic output.
	// The output report is a plain text file with a summary of collected
	// diagnostics.
	OutputUri            string   `protobuf:"bytes,1,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DiagnoseClusterResults) Reset()         { *m = DiagnoseClusterResults{} }
func (m *DiagnoseClusterResults) String() string { return proto.CompactTextString(m) }
func (*DiagnoseClusterResults) ProtoMessage()    {}
func (*DiagnoseClusterResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{24}
}

func (m *DiagnoseClusterResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiagnoseClusterResults.Unmarshal(m, b)
}
func (m *DiagnoseClusterResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiagnoseClusterResults.Marshal(b, m, deterministic)
}
func (m *DiagnoseClusterResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiagnoseClusterResults.Merge(m, src)
}
func (m *DiagnoseClusterResults) XXX_Size() int {
	return xxx_messageInfo_DiagnoseClusterResults.Size(m)
}
func (m *DiagnoseClusterResults) XXX_DiscardUnknown() {
	xxx_messageInfo_DiagnoseClusterResults.DiscardUnknown(m)
}

var xxx_messageInfo_DiagnoseClusterResults proto.InternalMessageInfo

func (m *DiagnoseClusterResults) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

// Reservation Affinity for consuming Zonal reservation.
type ReservationAffinity struct {
	// Optional. Type of reservation to consume
	ConsumeReservationType ReservationAffinity_Type `protobuf:"varint,1,opt,name=consume_reservation_type,json=consumeReservationType,proto3,enum=google.cloud.dataproc.v1beta2.ReservationAffinity_Type" json:"consume_reservation_type,omitempty"`
	// Optional. Corresponds to the label key of reservation resource.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. Corresponds to the label values of reservation resource.
	Values               []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReservationAffinity) Reset()         { *m = ReservationAffinity{} }
func (m *ReservationAffinity) String() string { return proto.CompactTextString(m) }
func (*ReservationAffinity) ProtoMessage()    {}
func (*ReservationAffinity) Descriptor() ([]byte, []int) {
	return fileDescriptor_abc993f8d220b626, []int{25}
}

func (m *ReservationAffinity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReservationAffinity.Unmarshal(m, b)
}
func (m *ReservationAffinity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReservationAffinity.Marshal(b, m, deterministic)
}
func (m *ReservationAffinity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReservationAffinity.Merge(m, src)
}
func (m *ReservationAffinity) XXX_Size() int {
	return xxx_messageInfo_ReservationAffinity.Size(m)
}
func (m *ReservationAffinity) XXX_DiscardUnknown() {
	xxx_messageInfo_ReservationAffinity.DiscardUnknown(m)
}

var xxx_messageInfo_ReservationAffinity proto.InternalMessageInfo

func (m *ReservationAffinity) GetConsumeReservationType() ReservationAffinity_Type {
	if m != nil {
		return m.ConsumeReservationType
	}
	return ReservationAffinity_TYPE_UNSPECIFIED
}

func (m *ReservationAffinity) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *ReservationAffinity) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.ClusterStatus_State", ClusterStatus_State_name, ClusterStatus_State_value)
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.ClusterStatus_Substate", ClusterStatus_Substate_name, ClusterStatus_Substate_value)
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.ReservationAffinity_Type", ReservationAffinity_Type_name, ReservationAffinity_Type_value)
	proto.RegisterType((*Cluster)(nil), "google.cloud.dataproc.v1beta2.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.Cluster.LabelsEntry")
	proto.RegisterType((*ClusterConfig)(nil), "google.cloud.dataproc.v1beta2.ClusterConfig")
	proto.RegisterType((*EndpointConfig)(nil), "google.cloud.dataproc.v1beta2.EndpointConfig")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.EndpointConfig.HttpPortsEntry")
	proto.RegisterType((*AutoscalingConfig)(nil), "google.cloud.dataproc.v1beta2.AutoscalingConfig")
	proto.RegisterType((*EncryptionConfig)(nil), "google.cloud.dataproc.v1beta2.EncryptionConfig")
	proto.RegisterType((*GceClusterConfig)(nil), "google.cloud.dataproc.v1beta2.GceClusterConfig")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.GceClusterConfig.MetadataEntry")
	proto.RegisterType((*InstanceGroupConfig)(nil), "google.cloud.dataproc.v1beta2.InstanceGroupConfig")
	proto.RegisterType((*ManagedGroupConfig)(nil), "google.cloud.dataproc.v1beta2.ManagedGroupConfig")
	proto.RegisterType((*AcceleratorConfig)(nil), "google.cloud.dataproc.v1beta2.AcceleratorConfig")
	proto.RegisterType((*DiskConfig)(nil), "google.cloud.dataproc.v1beta2.DiskConfig")
	proto.RegisterType((*LifecycleConfig)(nil), "google.cloud.dataproc.v1beta2.LifecycleConfig")
	proto.RegisterType((*SecurityConfig)(nil), "google.cloud.dataproc.v1beta2.SecurityConfig")
	proto.RegisterType((*KerberosConfig)(nil), "google.cloud.dataproc.v1beta2.KerberosConfig")
	proto.RegisterType((*NodeInitializationAction)(nil), "google.cloud.dataproc.v1beta2.NodeInitializationAction")
	proto.RegisterType((*ClusterStatus)(nil), "google.cloud.dataproc.v1beta2.ClusterStatus")
	proto.RegisterType((*SoftwareConfig)(nil), "google.cloud.dataproc.v1beta2.SoftwareConfig")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.SoftwareConfig.PropertiesEntry")
	proto.RegisterType((*ClusterMetrics)(nil), "google.cloud.dataproc.v1beta2.ClusterMetrics")
	proto.RegisterMapType((map[string]int64)(nil), "google.cloud.dataproc.v1beta2.ClusterMetrics.HdfsMetricsEntry")
	proto.RegisterMapType((map[string]int64)(nil), "google.cloud.dataproc.v1beta2.ClusterMetrics.YarnMetricsEntry")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.cloud.dataproc.v1beta2.CreateClusterRequest")
	proto.RegisterType((*UpdateClusterRequest)(nil), "google.cloud.dataproc.v1beta2.UpdateClusterRequest")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.cloud.dataproc.v1beta2.DeleteClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.cloud.dataproc.v1beta2.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.cloud.dataproc.v1beta2.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.cloud.dataproc.v1beta2.ListClustersResponse")
	proto.RegisterType((*DiagnoseClusterRequest)(nil), "google.cloud.dataproc.v1beta2.DiagnoseClusterRequest")
	proto.RegisterType((*DiagnoseClusterResults)(nil), "google.cloud.dataproc.v1beta2.DiagnoseClusterResults")
	proto.RegisterType((*ReservationAffinity)(nil), "google.cloud.dataproc.v1beta2.ReservationAffinity")
}

func init() {
	proto.RegisterFile("google/cloud/dataproc/v1beta2/clusters.proto", fileDescriptor_abc993f8d220b626)
}

var fileDescriptor_abc993f8d220b626 = []byte{
	// 3099 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x5a, 0xdd, 0x6f, 0x1b, 0xd7,
	0x95, 0x37, 0x49, 0x7d, 0xf1, 0x50, 0xa4, 0xa8, 0x2b, 0xd9, 0x66, 0xe4, 0x4d, 0x56, 0xcb, 0x64,
	0x03, 0xc5, 0xb1, 0xc9, 0x58, 0x41, 0xe2, 0xc4, 0x71, 0x82, 0xa5, 0x25, 0x5a, 0x12, 0x2c, 0x4b,
	0xc2, 0x88, 0x72, 0xd6, 0xbb, 0x8b, 0x9d, 0x1d, 0xce, 0x5c, 0x51, 0x13, 0xce, 0xd7, 0xce, 0xbd,
	0x63, 0x87, 0x76, 0xf3, 0xd0, 0x3e, 0xb7, 0x40, 0x8b, 0xa0, 0xff, 0x40, 0x9f, 0x8a, 0xe6, 0x35,
	0x28, 0xfa, 0xf1, 0x56, 0x14, 0x28, 0x90, 0xbe, 0x14, 0x2d, 0xda, 0x87, 0x3c, 0xf5, 0xa1, 0x40,
	0x1f, 0xda, 0xff, 0xa1, 0xc5, 0xfd, 0x98, 0x99, 0x3b, 0xa4, 0x6c, 0x52, 0xb6, 0x81, 0x3c, 0x69,
	0x78, 0x3e, 0x7e, 0xe7, 0xdc, 0x73, 0xcf, 0x9c, 0x73, 0xee, 0x1d, 0xc1, 0x95, 0x9e, 0xef, 0xf7,
	0x1c, 0xdc, 0x34, 0x1d, 0x3f, 0xb2, 0x9a, 0x96, 0x41, 0x8d, 0x20, 0xf4, 0xcd, 0xe6, 0x83, 0x6b,
	0x5d, 0x4c, 0x8d, 0xf5, 0xa6, 0xe9, 0x44, 0x84, 0xe2, 0x90, 0x34, 0x82, 0xd0, 0xa7, 0x3e, 0x7a,
	0x59, 0x48, 0x37, 0xb8, 0x74, 0x23, 0x96, 0x6e, 0x48, 0xe9, 0x95, 0x7f, 0x91, 0x60, 0x46, 0x60,
	0x37, 0x0d, 0xcf, 0xf3, 0xa9, 0x41, 0x6d, 0xdf, 0x93, 0xca, 0x2b, 0x17, 0x15, 0xae, 0xe9, 0xd8,
	0xd8, 0xa3, 0x92, 0xf1, 0xaf, 0x0a, 0xe3, 0xd8, 0xc6, 0x8e, 0xa5, 0x77, 0xf1, 0x89, 0xf1, 0xc0,
	0xf6, 0x43, 0x29, 0xd0, 0x78, 0xba, 0x93, 0x7e, 0x80, 0xc3, 0x8c, 0xa5, 0xcb, 0x4f, 0x97, 0x27,
	0x27, 0x46, 0x88, 0x2d, 0x29, 0xfb, 0xaa, 0x94, 0x75, 0x7c, 0xaf, 0x17, 0x46, 0x9e, 0x67, 0x7b,
	0xbd, 0x51, 0xc0, 0x57, 0xa4, 0x10, 0xff, 0xd5, 0x8d, 0x8e, 0x9b, 0x56, 0x24, 0x04, 0x24, 0x7f,
	0x75, 0x98, 0x2f, 0x96, 0xe1, 0x1a, 0xa4, 0x3f, 0xb4, 0xc6, 0x44, 0x82, 0xda, 0x2e, 0x26, 0xd4,
	0x70, 0x03, 0x21, 0x50, 0xff, 0xcd, 0x14, 0xcc, 0x6e, 0x88, 0x68, 0xa3, 0x3a, 0x40, 0x10, 0xfa,
	0x9f, 0x60, 0x93, 0xea, 0xb6, 0x55, 0xcb, 0xad, 0xe6, 0xd6, 0x8a, 0xb7, 0x0a, 0x7f, 0x6e, 0xe5,
	0xb5, 0xa2, 0x24, 0xef, 0x58, 0xe8, 0x75, 0x98, 0x97, 0x9b, 0xa3, 0x7b, 0x86, 0x8b, 0x6b, 0xf9,
	0x54, 0xaa, 0x24, 0x19, 0x7b, 0x86, 0x8b, 0xd1, 0x0e, 0xcc, 0x98, 0xbe, 0x77, 0x6c, 0xf7, 0x6a,
	0x85, 0xd5, 0xdc, 0x5a, 0x69, 0xfd, 0x4a, 0xe3, 0xa9, 0x7b, 0xd8, 0x90, 0x3e, 0x6c, 0x70, 0x1d,
	0x81, 0x27, 0x01, 0xd0, 0x3e, 0xcc, 0x38, 0x46, 0x17, 0x3b, 0xa4, 0x36, 0xb7, 0x5a, 0x58, 0x2b,
	0xad, 0xaf, 0x4f, 0x06, 0xd5, 0xd8, 0xe5, 0x4a, 0x6d, 0x8f, 0x86, 0x03, 0x06, 0x98, 0xd3, 0x24,
	0x0c, 0xf3, 0x8d, 0x50, 0x83, 0x46, 0xa4, 0x36, 0x75, 0x16, 0xdf, 0x0e, 0xb9, 0x0e, 0x83, 0x2a,
	0x68, 0x12, 0x00, 0xfd, 0x27, 0x54, 0xc4, 0x93, 0x7e, 0x62, 0x13, 0xea, 0x87, 0x83, 0xda, 0x2c,
	0xf7, 0xf1, 0x19, 0x20, 0xcb, 0x02, 0x68, 0x5b, 0xe0, 0xa8, 0x81, 0x8e, 0x22, 0xdb, 0xaa, 0xcd,
	0xc4, 0x81, 0x2e, 0x24, 0x81, 0x3e, 0x8a, 0x6c, 0x0b, 0xed, 0xc2, 0xac, 0x8b, 0x69, 0x68, 0x9b,
	0xa4, 0x56, 0xe4, 0xab, 0xb9, 0x3a, 0x99, 0xe9, 0xbb, 0x42, 0x49, 0x20, 0xc6, 0x10, 0x2b, 0xef,
	0x43, 0x49, 0x09, 0x1b, 0xaa, 0x42, 0xa1, 0x8f, 0x07, 0x22, 0x15, 0x34, 0xf6, 0x88, 0x96, 0x61,
	0xfa, 0x81, 0xe1, 0x44, 0x72, 0xe3, 0x35, 0xf1, 0xe3, 0x46, 0xfe, 0xbd, 0x5c, 0xfd, 0x1f, 0x73,
	0x50, 0xce, 0xec, 0x22, 0x5a, 0x83, 0xb2, 0xd8, 0x42, 0xbd, 0x1b, 0x99, 0x7d, 0x4c, 0xd3, 0x94,
	0xca, 0x69, 0xf3, 0x82, 0x73, 0x8b, 0x33, 0x50, 0x17, 0x50, 0xcf, 0xc4, 0x7a, 0xbc, 0x60, 0x99,
	0x39, 0x73, 0x7c, 0x3d, 0xcd, 0x31, 0xeb, 0xd9, 0x32, 0xf1, 0x48, 0xf2, 0xe4, 0xb4, 0x6a, 0x6f,
	0x88, 0x8c, 0xfe, 0x07, 0xca, 0xae, 0xa1, 0xc2, 0x8b, 0x70, 0x8d, 0xcb, 0xa6, 0x1d, 0x8f, 0x50,
	0xc3, 0x33, 0xf1, 0x56, 0xe8, 0x47, 0x81, 0x6a, 0x61, 0x5e, 0xa0, 0xa5, 0xe8, 0x0f, 0xfd, 0xb0,
	0x9f, 0xa2, 0xc3, 0x73, 0xa2, 0x0b, 0x34, 0x89, 0xee, 0xc3, 0x45, 0x82, 0x4d, 0xdf, 0xb3, 0x8c,
	0x70, 0xa0, 0x67, 0xed, 0xcc, 0x3f, 0x9f, 0x9d, 0xf3, 0x09, 0xee, 0xc7, 0xaa, 0xc1, 0xff, 0x86,
	0x05, 0xe2, 0x1f, 0xd3, 0x87, 0x46, 0x88, 0x63, 0x43, 0xe5, 0x89, 0xb2, 0xeb, 0x50, 0x6a, 0xa9,
	0x36, 0x2a, 0x24, 0x43, 0x44, 0xff, 0x0b, 0x55, 0xc7, 0x3e, 0xc6, 0xe6, 0xc0, 0x74, 0x12, 0xf4,
	0x0a, 0x47, 0x6f, 0x8c, 0x41, 0xdf, 0x8d, 0xd5, 0x54, 0xf8, 0x05, 0x27, 0x4b, 0x45, 0x04, 0x2e,
	0xd8, 0x9e, 0x4d, 0x6d, 0xc3, 0xb1, 0x1f, 0xf1, 0x72, 0xa9, 0x1b, 0x26, 0x2f, 0xab, 0xb5, 0x12,
	0x7f, 0x39, 0xaf, 0x8f, 0xb1, 0xb2, 0xe7, 0x5b, 0x78, 0x27, 0x03, 0xd0, 0xe2, 0xfa, 0x32, 0x62,
	0xf6, 0x29, 0x2c, 0x82, 0x0c, 0x58, 0xc4, 0x9e, 0x19, 0x0e, 0x02, 0x6e, 0x50, 0xae, 0x6a, 0x61,
	0xa2, 0x0c, 0x6e, 0x27, 0x7a, 0x99, 0x0c, 0xc6, 0x43, 0x64, 0x64, 0x01, 0x32, 0x22, 0xea, 0x13,
	0xd3, 0x70, 0x6c, 0xaf, 0x17, 0xdb, 0xa8, 0x72, 0x1b, 0x6f, 0x8d, 0xb1, 0xd1, 0x4a, 0x15, 0x55,
	0x23, 0x8b, 0xc6, 0x30, 0x9d, 0x6d, 0x3d, 0xf6, 0xac, 0xc0, 0xb7, 0x3d, 0x1a, 0x9b, 0x58, 0x9c,
	0x68, 0xeb, 0xdb, 0x52, 0x2b, 0xb3, 0xf5, 0x38, 0x43, 0xe4, 0x79, 0x85, 0xcd, 0x28, 0xb4, 0xe9,
	0x20, 0x06, 0x47, 0x93, 0xe5, 0x95, 0xd4, 0xca, 0xe6, 0x55, 0x86, 0x58, 0xff, 0x7b, 0x0e, 0x2a,
	0x59, 0x27, 0xd0, 0xff, 0x01, 0x9c, 0x50, 0x1a, 0xe8, 0x81, 0x1f, 0x52, 0x52, 0xcb, 0xf1, 0xed,
	0xbf, 0x79, 0xa6, 0x75, 0x34, 0xb6, 0x29, 0x0d, 0x0e, 0x98, 0x7a, 0xd2, 0x49, 0x0a, 0x5a, 0xf1,
	0x24, 0x26, 0xa2, 0x1b, 0x70, 0x11, 0x7b, 0x46, 0xd7, 0xc1, 0x7a, 0x62, 0x48, 0x37, 0x4c, 0x13,
	0x13, 0xc2, 0x4b, 0xe4, 0x9c, 0x70, 0x75, 0x59, 0xc8, 0xc4, 0x58, 0x2d, 0x2e, 0xb0, 0x72, 0x13,
	0x2a, 0x59, 0xf4, 0x33, 0x15, 0xdc, 0xeb, 0xb0, 0x38, 0xb2, 0xab, 0xbc, 0x87, 0xfb, 0x8e, 0x6d,
	0x0e, 0xf4, 0x28, 0xb4, 0xd5, 0x82, 0x5b, 0x14, 0xe4, 0xa3, 0xd0, 0xae, 0xb7, 0xa1, 0x3a, 0x9c,
	0x72, 0xe8, 0x1a, 0x2c, 0xb1, 0x0a, 0x1c, 0x58, 0x7a, 0xdf, 0x25, 0x7a, 0x1f, 0x0f, 0x44, 0x7b,
	0x57, 0x00, 0x16, 0x7a, 0x26, 0x3e, 0xb0, 0xee, 0xb8, 0xe4, 0x0e, 0x1e, 0xb0, 0x16, 0x5f, 0xff,
	0x72, 0x0a, 0xaa, 0xc3, 0xc5, 0x17, 0xbd, 0x02, 0x73, 0x8f, 0x7c, 0x0f, 0x0f, 0x5b, 0x9f, 0x65,
	0xc4, 0xa3, 0xd0, 0x46, 0xaf, 0x41, 0xc9, 0xc3, 0x94, 0x95, 0x30, 0x2e, 0x92, 0x4f, 0x45, 0x40,
	0xd2, 0x99, 0xd4, 0x65, 0xa8, 0x90, 0xa8, 0xab, 0x0a, 0xce, 0xa4, 0x82, 0xe5, 0x94, 0xc5, 0x64,
	0xaf, 0x42, 0xd5, 0xf6, 0x28, 0x0e, 0x3d, 0xc3, 0xd1, 0xed, 0x40, 0xf7, 0x3d, 0x87, 0x35, 0xe1,
	0x24, 0xf2, 0x95, 0x98, 0xb9, 0x13, 0xec, 0x7b, 0xce, 0x00, 0x5d, 0x61, 0x19, 0x18, 0x3e, 0xb0,
	0x4d, 0xcc, 0xb6, 0xc9, 0x8f, 0x3c, 0xca, 0xfb, 0x4c, 0x31, 0x49, 0x29, 0xce, 0x6b, 0x09, 0x16,
	0x7a, 0x1f, 0x2e, 0x0c, 0x49, 0xeb, 0xc4, 0xf4, 0x03, 0x4c, 0x6a, 0x85, 0xd5, 0x42, 0xac, 0xb4,
	0x9c, 0x55, 0x3a, 0xe4, 0x02, 0x08, 0xc1, 0x14, 0x35, 0x7a, 0x6c, 0xc6, 0x28, 0xac, 0x15, 0x35,
	0xfe, 0x8c, 0xee, 0xc3, 0x9c, 0x8b, 0xa9, 0xc1, 0x52, 0xae, 0x36, 0xcd, 0x93, 0xf1, 0xc3, 0x33,
	0x76, 0xb7, 0xc6, 0x5d, 0xa9, 0xcf, 0xf3, 0x45, 0x4b, 0xe0, 0xd0, 0x27, 0xb0, 0x1c, 0x62, 0xe6,
	0x88, 0xac, 0x78, 0xc7, 0xc7, 0xac, 0x4e, 0x0d, 0x6a, 0xa5, 0x89, 0xfa, 0x83, 0x96, 0xaa, 0xb6,
	0xa4, 0xa6, 0x58, 0xdb, 0x52, 0x38, 0xca, 0x59, 0xf9, 0x00, 0xca, 0x19, 0x37, 0xce, 0x94, 0xb6,
	0x3f, 0x9e, 0x82, 0xa5, 0x53, 0xda, 0x11, 0x9b, 0x16, 0xbc, 0xc8, 0xd5, 0x6d, 0xc9, 0x22, 0x1c,
	0x6d, 0x5a, 0x76, 0x43, 0x2f, 0x72, 0x63, 0x1d, 0xc2, 0xb2, 0x23, 0x96, 0xe2, 0x59, 0xca, 0xde,
	0xb4, 0x42, 0x3c, 0x1c, 0x95, 0x63, 0x16, 0xcb, 0x51, 0x82, 0x56, 0xa1, 0x68, 0xbb, 0x46, 0x4f,
	0x24, 0x64, 0x21, 0xdd, 0xe8, 0x39, 0x4e, 0x95, 0xf9, 0xe3, 0x1a, 0xe6, 0x89, 0xed, 0x61, 0x9d,
	0x0e, 0x02, 0x21, 0x38, 0xa5, 0x64, 0x84, 0x64, 0x76, 0x06, 0x01, 0x17, 0xdf, 0x87, 0x92, 0x65,
	0x93, 0x7e, 0x5c, 0xbd, 0xa6, 0x79, 0x78, 0xdf, 0x18, 0x13, 0xde, 0x4d, 0x9b, 0xf4, 0xd5, 0xca,
	0x05, 0x56, 0x42, 0xe0, 0xab, 0x21, 0x7a, 0x10, 0x62, 0xec, 0x06, 0xd4, 0xee, 0x3a, 0x98, 0xe7,
	0xba, 0xcc, 0xde, 0xb2, 0x4d, 0x0e, 0x52, 0x0e, 0x3a, 0x81, 0x65, 0xd7, 0xf0, 0x8c, 0x1e, 0xb6,
	0xf4, 0x1e, 0x0b, 0x5d, 0xec, 0xc5, 0x2c, 0xf7, 0xe2, 0xda, 0x18, 0x2f, 0xee, 0x0a, 0xd5, 0xa1,
	0x19, 0xa0, 0xa0, 0x21, 0x77, 0x84, 0x81, 0xee, 0xc3, 0x3c, 0xab, 0x62, 0x0e, 0x3b, 0x91, 0xf8,
	0x61, 0x3c, 0x7a, 0x8f, 0xed, 0x32, 0xa9, 0x4a, 0x66, 0x98, 0x51, 0xa1, 0xd0, 0x1a, 0x54, 0x5d,
	0xdb, 0xd3, 0xcd, 0x20, 0xd2, 0x03, 0xc7, 0xa0, 0xc7, 0x7e, 0xe8, 0xf2, 0x59, 0xac, 0xa8, 0x55,
	0x5c, 0xdb, 0xdb, 0x08, 0xa2, 0x03, 0x49, 0xad, 0x7f, 0x9e, 0x03, 0x34, 0xea, 0x34, 0x7b, 0x29,
	0x93, 0xfd, 0xa7, 0xd8, 0x65, 0x20, 0x78, 0xa8, 0x5c, 0x15, 0xb4, 0xe5, 0x58, 0xa4, 0x23, 0x25,
	0xf8, 0xb1, 0xe4, 0x16, 0x5c, 0x4a, 0x54, 0x45, 0x04, 0xc5, 0xda, 0x87, 0x4f, 0x33, 0x05, 0xad,
	0x66, 0xab, 0x39, 0x2a, 0xbc, 0xe0, 0x47, 0x9b, 0x7a, 0x08, 0x8b, 0x23, 0xeb, 0x44, 0x6f, 0xc1,
	0xb2, 0xb2, 0xc8, 0x34, 0x93, 0xc4, 0x2b, 0x81, 0x14, 0x5e, 0x9c, 0x48, 0x6f, 0xc2, 0xa2, 0xaa,
	0x21, 0x4a, 0x11, 0x73, 0x60, 0x5a, 0xab, 0x1a, 0x2a, 0x7e, 0xe4, 0xd1, 0xfa, 0xf7, 0x72, 0x00,
	0x69, 0x12, 0xa1, 0x37, 0xa0, 0xd2, 0xf5, 0x7d, 0xaa, 0xf3, 0x4c, 0x64, 0xb6, 0xd4, 0xd4, 0x9e,
	0x67, 0x2c, 0x26, 0xcc, 0x2c, 0xa1, 0x06, 0x2c, 0xa6, 0xa2, 0xc4, 0x7e, 0x84, 0xf5, 0x5e, 0x57,
	0x7d, 0xb5, 0x2a, 0xb1, 0xf4, 0xa1, 0xfd, 0x08, 0x6f, 0x75, 0xd1, 0x6b, 0x50, 0x61, 0xaf, 0xa1,
	0xe3, 0x9b, 0x86, 0xa3, 0x13, 0x62, 0x11, 0xe9, 0x13, 0x7b, 0x05, 0x77, 0x19, 0xf1, 0x90, 0x58,
	0xa4, 0xfe, 0xd3, 0x3c, 0x2c, 0x0c, 0x0d, 0x63, 0xe8, 0x36, 0x2c, 0xd8, 0x96, 0x83, 0x75, 0x0b,
	0x3b, 0x98, 0x62, 0x9d, 0x52, 0x87, 0xdb, 0x29, 0xad, 0xbf, 0x14, 0x67, 0x4d, 0x7c, 0x0a, 0x6d,
	0x6c, 0xca, 0x73, 0x6c, 0x9c, 0xe4, 0x96, 0x83, 0x37, 0xb9, 0x56, 0x87, 0x3a, 0xe8, 0x36, 0x54,
	0xd9, 0x54, 0x92, 0xe0, 0xd8, 0x72, 0x63, 0x4a, 0xeb, 0x2b, 0x23, 0x40, 0x9d, 0xf8, 0x38, 0xbb,
	0x7d, 0x4e, 0xab, 0x30, 0x2d, 0x09, 0x63, 0xbb, 0x18, 0x6d, 0xc0, 0x42, 0x06, 0x87, 0x3a, 0xf2,
	0x2c, 0xfa, 0x64, 0x7f, 0xb6, 0xcf, 0x69, 0x65, 0x05, 0x85, 0x3a, 0x68, 0x4b, 0x2e, 0x8a, 0x50,
	0x23, 0xa4, 0xc2, 0x97, 0xa9, 0x71, 0xbe, 0xc4, 0x85, 0xc8, 0x72, 0xf0, 0x21, 0x53, 0x63, 0x8c,
	0x5b, 0xd3, 0x50, 0xa0, 0xd4, 0xa9, 0x9f, 0x40, 0x25, 0x3b, 0xca, 0xa0, 0x7b, 0xb0, 0xd0, 0xc7,
	0x61, 0x17, 0x87, 0x3e, 0x89, 0x5f, 0xe7, 0xdc, 0x44, 0x23, 0xd1, 0x1d, 0xa9, 0x25, 0x70, 0xb4,
	0x4a, 0x3f, 0xf3, 0xbb, 0xfe, 0xc5, 0x0c, 0x54, 0xb2, 0x22, 0xac, 0xf7, 0xc9, 0x59, 0x25, 0x96,
	0xe5, 0xa6, 0xe6, 0x92, 0x59, 0x8d, 0xf1, 0x62, 0x1d, 0xf6, 0xae, 0x84, 0x2c, 0x73, 0x82, 0xd0,
	0xf6, 0x4c, 0x3b, 0x30, 0x1c, 0x3d, 0x30, 0x08, 0x79, 0xe8, 0x87, 0x56, 0xb6, 0x75, 0xe7, 0xb5,
	0x1a, 0x93, 0x3b, 0x88, 0xc5, 0x0e, 0xa4, 0x14, 0x4b, 0xf2, 0x57, 0xa1, 0x14, 0xcf, 0x13, 0x99,
	0x02, 0x9c, 0xd7, 0x8a, 0x7d, 0x3e, 0x49, 0x30, 0xa1, 0xd7, 0x61, 0xbe, 0x8f, 0x07, 0xec, 0xd8,
	0x3b, 0x52, 0x7d, 0x4b, 0x31, 0x43, 0x4e, 0x05, 0x34, 0x8c, 0x08, 0x4d, 0x25, 0xa7, 0x95, 0xa9,
	0x20, 0x65, 0x31, 0xd9, 0xeb, 0x70, 0x3e, 0xc1, 0xcc, 0xb8, 0xad, 0x0c, 0x12, 0x4b, 0xb1, 0x84,
	0xea, 0xf1, 0x55, 0xa8, 0x32, 0x6f, 0x33, 0x3a, 0xb3, 0x4a, 0x3b, 0xe8, 0xe3, 0x81, 0x2a, 0xfe,
	0x01, 0x5c, 0x54, 0x7c, 0xca, 0x68, 0x29, 0x63, 0xc5, 0xf9, 0x54, 0x46, 0x55, 0xbe, 0x01, 0x17,
	0xcd, 0xd0, 0x27, 0x44, 0x0f, 0xb1, 0xe1, 0xb8, 0x3a, 0x17, 0x12, 0xcf, 0xa2, 0x20, 0xca, 0xf1,
	0x82, 0xcb, 0x68, 0x8c, 0xdc, 0x61, 0x12, 0xfc, 0x09, 0xbd, 0x0b, 0xe7, 0x47, 0x75, 0xfb, 0x96,
	0xc9, 0x0f, 0x9e, 0x52, 0x13, 0x0d, 0x69, 0xde, 0xb1, 0x4c, 0xb4, 0x05, 0xaf, 0x8c, 0xea, 0x19,
	0x16, 0xab, 0xc8, 0xac, 0xd1, 0xe3, 0x90, 0x4f, 0x0c, 0x12, 0x60, 0x65, 0x08, 0xa0, 0xc5, 0xe4,
	0x0e, 0xb9, 0x18, 0xea, 0xc0, 0xbf, 0x8f, 0x02, 0x89, 0x3b, 0xae, 0x6c, 0x1c, 0xe6, 0x53, 0xbc,
	0xd5, 0x21, 0xbc, 0x43, 0x2e, 0xae, 0x86, 0x64, 0x0d, 0x2a, 0x7d, 0xcb, 0xd4, 0xad, 0x6e, 0x92,
	0x33, 0x65, 0x35, 0x1b, 0x2c, 0x73, 0xb3, 0x2b, 0xb3, 0xe6, 0x1a, 0x20, 0xda, 0xa3, 0x3a, 0x3b,
	0xfc, 0xb1, 0xd7, 0x52, 0x3f, 0xf1, 0xa3, 0x90, 0xf0, 0x73, 0xa4, 0xac, 0x6c, 0x55, 0xda, 0xa3,
	0xbb, 0x92, 0xbb, 0xcd, 0x98, 0xe8, 0x25, 0x98, 0x16, 0xd1, 0x5d, 0x48, 0x31, 0x05, 0xa5, 0xfe,
	0xc3, 0x1c, 0xd4, 0x9e, 0x74, 0xee, 0xe3, 0xef, 0xcd, 0xa7, 0xd8, 0x8c, 0x28, 0x7f, 0x77, 0x8e,
	0x6d, 0x07, 0xab, 0xb7, 0x63, 0x95, 0x94, 0x77, 0xdb, 0x76, 0x30, 0xba, 0x03, 0x8b, 0x82, 0xc2,
	0xe6, 0x30, 0x66, 0xdc, 0x8f, 0xa8, 0x2c, 0x60, 0xe3, 0x2a, 0x61, 0x35, 0x51, 0xec, 0x08, 0xbd,
	0xfa, 0x97, 0x85, 0xe4, 0x56, 0x45, 0x5c, 0x16, 0xa1, 0xbb, 0x30, 0x4d, 0xa8, 0x41, 0x85, 0x0b,
	0x95, 0x49, 0x6f, 0xc3, 0x84, 0x72, 0x83, 0xfd, 0xc1, 0xa2, 0x3e, 0x09, 0x14, 0x74, 0x09, 0x66,
	0x2c, 0x4c, 0x0d, 0xdb, 0x51, 0x9b, 0x9f, 0x24, 0xa1, 0x1d, 0xa8, 0x72, 0x29, 0xb5, 0xfc, 0x15,
	0x26, 0x2b, 0x7f, 0xfc, 0x5e, 0x2c, 0xad, 0x7f, 0xe8, 0x1e, 0xcc, 0x91, 0xa8, 0x2b, 0x3c, 0x9f,
	0xe2, 0x9e, 0xbf, 0x73, 0x36, 0xcf, 0xa5, 0xb2, 0x40, 0x4f, 0xb0, 0xea, 0xf7, 0x60, 0x9a, 0x2f,
	0x0a, 0x95, 0x60, 0xf6, 0x68, 0xef, 0xce, 0xde, 0xfe, 0xc7, 0x7b, 0xd5, 0x73, 0x68, 0x1e, 0xe6,
	0x36, 0xb4, 0x76, 0xab, 0xb3, 0xb3, 0xb7, 0x55, 0xcd, 0x31, 0x96, 0x76, 0xb4, 0xb7, 0xc7, 0x7e,
	0xe4, 0x51, 0x11, 0xa6, 0xdb, 0x9a, 0xb6, 0xaf, 0x55, 0x0b, 0x4c, 0x6a, 0xb3, 0xbd, 0xdb, 0xe6,
	0x52, 0x53, 0xec, 0xd7, 0xd1, 0xc1, 0xa6, 0xd0, 0x99, 0xae, 0xdf, 0x84, 0xb9, 0xd8, 0x24, 0x5a,
	0x80, 0xd2, 0xd1, 0xde, 0xe1, 0x41, 0x7b, 0x63, 0xe7, 0xf6, 0x4e, 0x7b, 0xb3, 0x7a, 0x0e, 0x95,
	0xa1, 0x78, 0xb4, 0xb7, 0xdd, 0x6e, 0xed, 0x76, 0xb6, 0xef, 0x57, 0x73, 0xa8, 0x0a, 0xf3, 0x87,
	0x9d, 0xd6, 0x6e, 0x5b, 0x3f, 0xec, 0xb4, 0x3a, 0x47, 0x87, 0xd5, 0x7c, 0xfd, 0x67, 0x79, 0xa8,
	0x64, 0xaf, 0x42, 0xd8, 0x7c, 0x2b, 0x26, 0xd1, 0x07, 0x38, 0x24, 0xb6, 0xef, 0x65, 0x6e, 0xc3,
	0x38, 0xe7, 0x9e, 0x60, 0xa0, 0x2e, 0xbf, 0x87, 0x0d, 0x70, 0x48, 0x6d, 0x39, 0xdb, 0x8e, 0x3f,
	0x27, 0x64, 0x8d, 0x35, 0x0e, 0x12, 0x7d, 0xe5, 0xfe, 0x53, 0x41, 0x45, 0xf7, 0x61, 0xc9, 0xe7,
	0xe7, 0x3f, 0xc3, 0xd1, 0x4d, 0xdf, 0x0d, 0x7c, 0x0f, 0x7b, 0x54, 0x9c, 0x6a, 0x2a, 0xeb, 0x6b,
	0xe3, 0x76, 0x26, 0x56, 0xd0, 0x50, 0x0c, 0x92, 0x90, 0xc8, 0xca, 0x87, 0xb0, 0x30, 0x64, 0xfe,
	0x4c, 0xe7, 0x83, 0x3f, 0xe5, 0xa1, 0x92, 0xbd, 0xa3, 0x44, 0x06, 0xcc, 0x9f, 0x58, 0xc7, 0x44,
	0x8f, 0x2f, 0x3a, 0xc5, 0x39, 0xfe, 0xa3, 0x33, 0x5d, 0x74, 0x36, 0xb6, 0xad, 0x63, 0x22, 0x9f,
	0xc5, 0xd9, 0xa9, 0x74, 0x92, 0x52, 0x98, 0x89, 0x81, 0x11, 0x7a, 0x89, 0x89, 0xfc, 0xb3, 0x98,
	0xb8, 0x6f, 0x84, 0x5e, 0xd6, 0xc4, 0x20, 0xa5, 0xac, 0x7c, 0x04, 0xd5, 0x61, 0x1f, 0xc6, 0x05,
	0xa6, 0xa0, 0x04, 0x86, 0xe9, 0x0f, 0x1b, 0x38, 0x8b, 0x7e, 0xfd, 0x57, 0x39, 0x58, 0xde, 0x08,
	0xb1, 0x41, 0xe3, 0x13, 0xa5, 0x86, 0xff, 0x3f, 0xc2, 0x84, 0x4e, 0x74, 0xef, 0x7f, 0x09, 0x66,
	0x42, 0xdc, 0x63, 0x69, 0xab, 0xf4, 0x70, 0x49, 0x42, 0x6d, 0x98, 0x95, 0x57, 0xb7, 0xb2, 0xce,
	0xbd, 0x3e, 0x59, 0xdc, 0x04, 0x4a, 0xac, 0xcb, 0xfc, 0x08, 0x85, 0x4b, 0xcc, 0x0f, 0x65, 0x0a,
	0x28, 0x4a, 0xf2, 0x8e, 0x55, 0xff, 0x7e, 0x01, 0x96, 0x8f, 0x02, 0xeb, 0x79, 0x17, 0x31, 0x3d,
	0xba, 0x88, 0x49, 0xbf, 0x6c, 0x28, 0x8b, 0x2d, 0x3c, 0xc7, 0x62, 0xbb, 0xf0, 0x72, 0x2f, 0x34,
	0x4c, 0x7c, 0x1c, 0x39, 0xba, 0x85, 0x4d, 0xdf, 0x75, 0x6d, 0x42, 0xd4, 0x8e, 0x31, 0x33, 0x51,
	0xc7, 0xb8, 0x14, 0x83, 0x6c, 0x2a, 0x18, 0xb2, 0x79, 0xa0, 0xff, 0x80, 0x52, 0xc4, 0x63, 0xc5,
	0x3f, 0x09, 0x3d, 0x71, 0x70, 0xbd, 0x6d, 0x63, 0xc7, 0xba, 0x6b, 0x90, 0xbe, 0x70, 0x11, 0x84,
	0x0e, 0x23, 0x0c, 0x6d, 0xc9, 0xec, 0xa9, 0x5b, 0xf2, 0xdb, 0x1c, 0x2c, 0x8b, 0x81, 0xf9, 0x45,
	0xe7, 0xd5, 0xa4, 0x5b, 0x32, 0xfc, 0xad, 0x44, 0x1d, 0x20, 0xd5, 0x6f, 0x25, 0xd9, 0xd5, 0x4c,
	0x9f, 0xba, 0x9a, 0x6f, 0xc1, 0xe2, 0x16, 0xa6, 0xdf, 0xd0, 0x4a, 0xea, 0x3f, 0xcf, 0xc1, 0xd2,
	0xae, 0x4d, 0x62, 0xfb, 0xe4, 0xd9, 0x1c, 0x98, 0x1a, 0x75, 0xe0, 0x12, 0xcc, 0x1c, 0xdb, 0x0e,
	0x4b, 0x5a, 0x65, 0xd9, 0x92, 0x84, 0x56, 0xa1, 0x18, 0xb0, 0xce, 0xc4, 0x8e, 0x87, 0xe2, 0xb8,
	0x27, 0x2f, 0x49, 0x18, 0x95, 0x9d, 0x0b, 0xb9, 0x7d, 0x26, 0x41, 0xfd, 0x3e, 0xf6, 0xd4, 0xc3,
	0x26, 0x57, 0xec, 0x30, 0x6a, 0xfd, 0xbb, 0x39, 0x58, 0xce, 0xfa, 0x4e, 0x02, 0xdf, 0x23, 0x18,
	0x6d, 0xc1, 0x5c, 0xfc, 0x41, 0x57, 0x96, 0xee, 0x33, 0xbc, 0x32, 0x05, 0x2d, 0x51, 0x46, 0x6f,
	0xc2, 0x82, 0x87, 0x3f, 0xa5, 0xba, 0xe2, 0x8a, 0x32, 0xb4, 0x94, 0x19, 0xef, 0x20, 0x71, 0xe7,
	0xdb, 0x39, 0xb8, 0xb0, 0x69, 0x1b, 0x3d, 0xcf, 0x27, 0xdf, 0x54, 0x62, 0xd6, 0x6f, 0x9e, 0xe2,
	0x02, 0x89, 0x1c, 0x4a, 0x98, 0x0b, 0x7e, 0x44, 0x83, 0x88, 0x66, 0x6f, 0x4a, 0x0b, 0x5a, 0x51,
	0x90, 0x8f, 0x42, 0xbb, 0xfe, 0xa3, 0x3c, 0x2c, 0x9d, 0x72, 0x31, 0x87, 0x1e, 0x40, 0xcd, 0xf4,
	0x3d, 0x12, 0xb9, 0x58, 0x57, 0xaf, 0xfc, 0xf8, 0x3d, 0x80, 0x18, 0x0a, 0xaf, 0x9f, 0xfd, 0xba,
	0xaf, 0xd1, 0x19, 0x04, 0x58, 0xec, 0xe9, 0x05, 0x89, 0xae, 0x48, 0xf1, 0xab, 0x84, 0xf3, 0xa2,
	0xd9, 0x28, 0x77, 0xb6, 0xbc, 0xe3, 0x5c, 0x82, 0x19, 0xde, 0x64, 0x32, 0x77, 0xa2, 0x92, 0x54,
	0xd7, 0x61, 0x8a, 0xeb, 0x2e, 0x43, 0xb5, 0x73, 0xff, 0xa0, 0xad, 0x67, 0xe7, 0x28, 0x04, 0x95,
	0xbd, 0x7d, 0x5d, 0x6b, 0x1f, 0xb6, 0xb5, 0x7b, 0xad, 0xce, 0xce, 0xfe, 0x5e, 0x35, 0x87, 0x96,
	0x60, 0xa1, 0xb5, 0x77, 0x3f, 0x43, 0xcc, 0xa3, 0x1a, 0x2c, 0x4b, 0xbd, 0x8d, 0x0c, 0xa7, 0xb0,
	0xfe, 0xd7, 0x32, 0x2c, 0xa6, 0x37, 0xa4, 0x34, 0xf4, 0x1d, 0x07, 0x87, 0xe8, 0x07, 0x79, 0x28,
	0x67, 0x7a, 0x1d, 0x7a, 0x7b, 0x5c, 0xca, 0x9d, 0xd2, 0x19, 0x57, 0x5e, 0x8e, 0x95, 0x94, 0xcf,
	0xf4, 0x8d, 0xfd, 0xf8, 0x33, 0x7d, 0xfd, 0x8b, 0xdc, 0x57, 0xad, 0x56, 0xfa, 0xfd, 0xfc, 0xdd,
	0x89, 0x92, 0x3a, 0x51, 0x8f, 0xaf, 0x50, 0xbf, 0x6e, 0x5d, 0x4a, 0xb3, 0xf1, 0xca, 0xaa, 0x48,
	0xb1, 0x2b, 0xab, 0x32, 0x8f, 0xbe, 0xf3, 0x87, 0xbf, 0x7c, 0x9e, 0xdf, 0xa8, 0xbf, 0x97, 0xfc,
	0x1b, 0x81, 0x94, 0x25, 0xcd, 0xc7, 0xa9, 0xd6, 0x67, 0x4d, 0xa1, 0x45, 0x9a, 0x8f, 0xc5, 0xc3,
	0x67, 0xc9, 0xbf, 0x50, 0xdc, 0x48, 0x3a, 0xce, 0x2f, 0xf3, 0x50, 0xce, 0xb4, 0xce, 0xb1, 0x31,
	0x39, 0xad, 0xd1, 0x8e, 0x8b, 0xc9, 0x1f, 0x5f, 0x50, 0x4c, 0xde, 0x7d, 0x4a, 0x4c, 0xf8, 0x4b,
	0x97, 0xfc, 0xba, 0xb2, 0xaa, 0x34, 0x39, 0x1e, 0x2e, 0x6d, 0x7d, 0xeb, 0x59, 0xc3, 0xd5, 0x7c,
	0xac, 0xda, 0xf8, 0x2c, 0x8d, 0xde, 0x4f, 0xf2, 0x50, 0xce, 0x74, 0xb9, 0xb1, 0xd1, 0x3b, 0xad,
	0x27, 0x8e, 0x8b, 0xde, 0xaf, 0x73, 0x5f, 0xb5, 0xf6, 0xe1, 0xfc, 0x70, 0x87, 0x6e, 0xbb, 0x01,
	0x1d, 0x3c, 0x7b, 0x2c, 0x57, 0xc7, 0xc5, 0x92, 0x47, 0x6d, 0xe7, 0xf2, 0x8b, 0x8a, 0x1a, 0xfa,
	0x3a, 0x07, 0x90, 0x76, 0x51, 0x34, 0xee, 0xda, 0x78, 0xa4, 0xe1, 0xae, 0x4c, 0xd8, 0x20, 0xea,
	0xe1, 0xc4, 0x8b, 0x43, 0x2f, 0x6c, 0x71, 0x7f, 0xcb, 0xc1, 0xbc, 0xda, 0xe7, 0xd0, 0xfa, 0xd8,
	0xaf, 0xd6, 0x23, 0x0d, 0x7d, 0xe5, 0xed, 0x33, 0xe9, 0x88, 0x46, 0xca, 0x56, 0x8b, 0x46, 0x57,
	0xfb, 0x75, 0x6b, 0xe5, 0xb4, 0x10, 0x88, 0xde, 0xce, 0x17, 0x7f, 0x03, 0x3d, 0x73, 0xf9, 0x40,
	0xbf, 0xc8, 0xc3, 0xc2, 0x50, 0x0f, 0x43, 0xef, 0x8c, 0xfd, 0xdc, 0x71, 0x5a, 0xdb, 0x1d, 0x97,
	0xfb, 0xbf, 0xfb, 0x06, 0x73, 0xff, 0xa8, 0x7e, 0xf0, 0xa2, 0x2a, 0x86, 0x25, 0x17, 0x7f, 0x23,
	0x77, 0x79, 0xe5, 0xce, 0x57, 0xad, 0x8b, 0x89, 0xaf, 0x62, 0x05, 0x46, 0x60, 0x93, 0x86, 0xe9,
	0xbb, 0xbf, 0x6f, 0x35, 0x4e, 0x28, 0x0d, 0xc8, 0x8d, 0x66, 0xf3, 0xe1, 0xc3, 0x87, 0x43, 0xcc,
	0xa6, 0x11, 0xd1, 0x13, 0xf1, 0x7f, 0x64, 0x57, 0xe3, 0x6f, 0x24, 0xb7, 0x1e, 0xc3, 0xbf, 0x99,
	0xbe, 0xfb, 0xf4, 0xd0, 0xdf, 0x8a, 0x2f, 0x8b, 0xc8, 0x01, 0x8b, 0xdf, 0x41, 0xee, 0xbf, 0xda,
	0x52, 0xbe, 0xe7, 0x3b, 0x86, 0xd7, 0x6b, 0xf8, 0x61, 0xaf, 0xd9, 0xc3, 0x1e, 0x8f, 0x6e, 0x33,
	0x35, 0xfa, 0x84, 0xff, 0x59, 0xfb, 0x20, 0x26, 0x74, 0x67, 0xb8, 0xc6, 0xdb, 0xff, 0x0c, 0x00,
	0x00, 0xff, 0xff, 0x8d, 0x21, 0xcd, 0x5a, 0xb9, 0x27, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ClusterControllerClient is the client API for ClusterController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClusterControllerClient interface {
	// Creates a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](/dataproc/docs/reference/rpc/google.cloud.dataproc.v1beta2#clusteroperationmetadata).
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](/dataproc/docs/reference/rpc/google.cloud.dataproc.v1beta2#clusteroperationmetadata).
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](/dataproc/docs/reference/rpc/google.cloud.dataproc.v1beta2#clusteroperationmetadata).
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets cluster diagnostic information. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](/dataproc/docs/reference/rpc/google.cloud.dataproc.v1beta2#clusteroperationmetadata).
	// After the operation completes,
	// [Operation.response][google.longrunning.Operation.response]
	// contains
	// [Empty](google.protobuf.Empty).
	DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type clusterControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewClusterControllerClient(cc grpc.ClientConnInterface) ClusterControllerClient {
	return &clusterControllerClient{cc}
}

func (c *clusterControllerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.ClusterController/CreateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.ClusterController/UpdateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.ClusterController/DeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.ClusterController/GetCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.ClusterController/ListClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.ClusterController/DiagnoseCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterControllerServer is the server API for ClusterController service.
type ClusterControllerServer interface {
	// Creates a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](/dataproc/docs/reference/rpc/google.cloud.dataproc.v1beta2#clusteroperationmetadata).
	CreateCluster(context.Context, *CreateClusterRequest) (*longrunning.Operation, error)
	// Updates a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](/dataproc/docs/reference/rpc/google.cloud.dataproc.v1beta2#clusteroperationmetadata).
	UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunning.Operation, error)
	// Deletes a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](/dataproc/docs/reference/rpc/google.cloud.dataproc.v1beta2#clusteroperationmetadata).
	DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunning.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets cluster diagnostic information. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](/dataproc/docs/reference/rpc/google.cloud.dataproc.v1beta2#clusteroperationmetadata).
	// After the operation completes,
	// [Operation.response][google.longrunning.Operation.response]
	// contains
	// [Empty](google.protobuf.Empty).
	DiagnoseCluster(context.Context, *DiagnoseClusterRequest) (*longrunning.Operation, error)
}

// UnimplementedClusterControllerServer can be embedded to have forward compatible implementations.
type UnimplementedClusterControllerServer struct {
}

func (*UnimplementedClusterControllerServer) CreateCluster(ctx context.Context, req *CreateClusterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (*UnimplementedClusterControllerServer) UpdateCluster(ctx context.Context, req *UpdateClusterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (*UnimplementedClusterControllerServer) DeleteCluster(ctx context.Context, req *DeleteClusterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (*UnimplementedClusterControllerServer) GetCluster(ctx context.Context, req *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (*UnimplementedClusterControllerServer) ListClusters(ctx context.Context, req *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (*UnimplementedClusterControllerServer) DiagnoseCluster(ctx context.Context, req *DiagnoseClusterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DiagnoseCluster not implemented")
}

func RegisterClusterControllerServer(s *grpc.Server, srv ClusterControllerServer) {
	s.RegisterService(&_ClusterController_serviceDesc, srv)
}

func _ClusterController_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.ClusterController/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.ClusterController/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.ClusterController/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.ClusterController/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.ClusterController/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DiagnoseCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiagnoseClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.ClusterController/DiagnoseCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, req.(*DiagnoseClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1beta2.ClusterController",
	HandlerType: (*ClusterControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterController_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterController_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterController_DeleteCluster_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterController_GetCluster_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _ClusterController_ListClusters_Handler,
		},
		{
			MethodName: "DiagnoseCluster",
			Handler:    _ClusterController_DiagnoseCluster_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1beta2/clusters.proto",
}
