// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/maps/playablelocations/v3/playablelocations.proto

package playablelocations

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	sample "google.golang.org/genproto/googleapis/maps/playablelocations/v3/sample"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

//
// Life of a query:
//
// - When a game starts in a new location, your game server issues a
// [SamplePlayableLocations][google.maps.playablelocations.v3.PlayableLocations.SamplePlayableLocations]
// request. The request specifies the S2 cell, and contains one or more
// "criteria" for filtering:
//
// - Criterion 0: i locations for long-lived bases, or level 0 monsters, or...
// - Criterion 1: j locations for short-lived bases, or level 1 monsters, ...
// - Criterion 2: k locations for random objects.
// - etc (up to 5 criterion may be specified).
//
// `PlayableLocationList` will then contain mutually
// exclusive lists of `PlayableLocation` objects that satisfy each of
// the criteria. Think of it as a collection of real-world locations that you
// can then associate with your game state.
//
// Note: These points are impermanent in nature. E.g, parks can close, and
// places can be removed.
//
// The response specifies how long you can expect the playable locations to
// last. Once they expire, you should query the `samplePlayableLocations` API
// again to get a fresh view of the real world.
type SamplePlayableLocationsRequest struct {
	// Required. Specifies the area to search within for playable locations.
	AreaFilter *sample.AreaFilter `protobuf:"bytes,1,opt,name=area_filter,json=areaFilter,proto3" json:"area_filter,omitempty"`
	// Required. Specifies one or more (up to 5) criteria for filtering the
	// returned playable locations.
	Criteria             []*sample.Criterion `protobuf:"bytes,2,rep,name=criteria,proto3" json:"criteria,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *SamplePlayableLocationsRequest) Reset()         { *m = SamplePlayableLocationsRequest{} }
func (m *SamplePlayableLocationsRequest) String() string { return proto.CompactTextString(m) }
func (*SamplePlayableLocationsRequest) ProtoMessage()    {}
func (*SamplePlayableLocationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0280e761c74de946, []int{0}
}

func (m *SamplePlayableLocationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SamplePlayableLocationsRequest.Unmarshal(m, b)
}
func (m *SamplePlayableLocationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SamplePlayableLocationsRequest.Marshal(b, m, deterministic)
}
func (m *SamplePlayableLocationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SamplePlayableLocationsRequest.Merge(m, src)
}
func (m *SamplePlayableLocationsRequest) XXX_Size() int {
	return xxx_messageInfo_SamplePlayableLocationsRequest.Size(m)
}
func (m *SamplePlayableLocationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SamplePlayableLocationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SamplePlayableLocationsRequest proto.InternalMessageInfo

func (m *SamplePlayableLocationsRequest) GetAreaFilter() *sample.AreaFilter {
	if m != nil {
		return m.AreaFilter
	}
	return nil
}

func (m *SamplePlayableLocationsRequest) GetCriteria() []*sample.Criterion {
	if m != nil {
		return m.Criteria
	}
	return nil
}

//
// Response for the
// [SamplePlayableLocations][google.maps.playablelocations.v3.PlayableLocations.SamplePlayableLocations]
// method.
type SamplePlayableLocationsResponse struct {
	// Each PlayableLocation object corresponds to a game_object_type specified
	// in the request.
	LocationsPerGameObjectType map[int32]*sample.PlayableLocationList `protobuf:"bytes,1,rep,name=locations_per_game_object_type,json=locationsPerGameObjectType,proto3" json:"locations_per_game_object_type,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Specifies the "time-to-live" for the set of playable locations. You can use
	// this value to determine how long to cache the set of playable locations.
	// After this length of time, your back-end game server should issue a new
	// [SamplePlayableLocations][google.maps.playablelocations.v3.PlayableLocations.SamplePlayableLocations]
	// request to get a fresh set of playable locations (because for example, they
	// might have been removed, a park might have closed for the day, a
	// business might have closed permanently).
	Ttl                  *duration.Duration `protobuf:"bytes,9,opt,name=ttl,proto3" json:"ttl,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SamplePlayableLocationsResponse) Reset()         { *m = SamplePlayableLocationsResponse{} }
func (m *SamplePlayableLocationsResponse) String() string { return proto.CompactTextString(m) }
func (*SamplePlayableLocationsResponse) ProtoMessage()    {}
func (*SamplePlayableLocationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0280e761c74de946, []int{1}
}

func (m *SamplePlayableLocationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SamplePlayableLocationsResponse.Unmarshal(m, b)
}
func (m *SamplePlayableLocationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SamplePlayableLocationsResponse.Marshal(b, m, deterministic)
}
func (m *SamplePlayableLocationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SamplePlayableLocationsResponse.Merge(m, src)
}
func (m *SamplePlayableLocationsResponse) XXX_Size() int {
	return xxx_messageInfo_SamplePlayableLocationsResponse.Size(m)
}
func (m *SamplePlayableLocationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SamplePlayableLocationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SamplePlayableLocationsResponse proto.InternalMessageInfo

func (m *SamplePlayableLocationsResponse) GetLocationsPerGameObjectType() map[int32]*sample.PlayableLocationList {
	if m != nil {
		return m.LocationsPerGameObjectType
	}
	return nil
}

func (m *SamplePlayableLocationsResponse) GetTtl() *duration.Duration {
	if m != nil {
		return m.Ttl
	}
	return nil
}

func init() {
	proto.RegisterType((*SamplePlayableLocationsRequest)(nil), "google.maps.playablelocations.v3.SamplePlayableLocationsRequest")
	proto.RegisterType((*SamplePlayableLocationsResponse)(nil), "google.maps.playablelocations.v3.SamplePlayableLocationsResponse")
	proto.RegisterMapType((map[int32]*sample.PlayableLocationList)(nil), "google.maps.playablelocations.v3.SamplePlayableLocationsResponse.LocationsPerGameObjectTypeEntry")
}

func init() {
	proto.RegisterFile("google/maps/playablelocations/v3/playablelocations.proto", fileDescriptor_0280e761c74de946)
}

var fileDescriptor_0280e761c74de946 = []byte{
	// 533 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x94, 0xcf, 0xaa, 0xd3, 0x40,
	0x14, 0xc6, 0x99, 0xd4, 0x2b, 0x3a, 0xdd, 0x68, 0x16, 0xde, 0x1a, 0xa5, 0x0d, 0x55, 0xe4, 0xa2,
	0x30, 0x81, 0x66, 0xe1, 0xa5, 0x22, 0xd8, 0xfa, 0xa7, 0x9b, 0x5e, 0xac, 0xa9, 0x08, 0xba, 0x09,
	0xd3, 0xdc, 0xd3, 0x18, 0x9d, 0x64, 0xc6, 0x99, 0x69, 0xa1, 0x4b, 0x05, 0x77, 0xee, 0x7c, 0x03,
	0xc1, 0x8d, 0xef, 0xe0, 0xd6, 0x85, 0x2b, 0xc1, 0x17, 0x70, 0xe1, 0x83, 0x48, 0x26, 0x69, 0x2d,
	0xc6, 0x92, 0x0b, 0x77, 0xd7, 0x9e, 0x39, 0xdf, 0xf7, 0xfb, 0xe6, 0x9c, 0x21, 0xf8, 0x30, 0xe6,
	0x3c, 0x66, 0xe0, 0xa5, 0x54, 0x28, 0x4f, 0x30, 0xba, 0xa2, 0x33, 0x06, 0x8c, 0x47, 0x54, 0x27,
	0x3c, 0x53, 0xde, 0xd2, 0xaf, 0x16, 0x89, 0x90, 0x5c, 0x73, 0xdb, 0x2d, 0x94, 0x24, 0x57, 0x92,
	0x6a, 0xd3, 0xd2, 0x77, 0xae, 0x96, 0xde, 0x54, 0x24, 0x1e, 0xcd, 0x32, 0xae, 0xb7, 0xf5, 0x4e,
	0x67, 0xeb, 0x74, 0x9e, 0x00, 0x3b, 0x0e, 0x67, 0xf0, 0x92, 0x2e, 0x13, 0x2e, 0xcb, 0x86, 0xdb,
	0xb5, 0xd1, 0x14, 0x4d, 0x05, 0x03, 0x4f, 0x82, 0xe2, 0x0b, 0x19, 0xc1, 0xda, 0xb9, 0x5d, 0x0a,
	0xcd, 0xbf, 0xd9, 0x62, 0xee, 0x1d, 0x2f, 0xa4, 0x11, 0x95, 0xe7, 0xfb, 0x5b, 0xe4, 0x88, 0x25,
	0x90, 0xe9, 0xe2, 0xa0, 0xfb, 0x03, 0xe1, 0xf6, 0xd4, 0x78, 0x4e, 0x4a, 0xdc, 0x78, 0x8d, 0x0b,
	0xe0, 0xcd, 0x02, 0x94, 0xb6, 0x9f, 0xe3, 0x26, 0x95, 0x40, 0xc3, 0x79, 0xc2, 0x34, 0xc8, 0x16,
	0x72, 0xd1, 0x41, 0xb3, 0xe7, 0x93, 0xba, 0x59, 0x90, 0x22, 0x2a, 0x19, 0x48, 0xa0, 0x8f, 0x8c,
	0x74, 0xd8, 0xf8, 0x35, 0xb0, 0x02, 0x4c, 0x37, 0x05, 0x7b, 0x8a, 0xcf, 0x45, 0x32, 0xd1, 0x20,
	0x13, 0xda, 0xb2, 0xdc, 0xc6, 0x41, 0xb3, 0xd7, 0x3b, 0xb1, 0xef, 0xfd, 0x42, 0xc8, 0xb3, 0xc2,
	0x76, 0x63, 0xd4, 0x7d, 0xdf, 0xc0, 0x9d, 0x9d, 0x57, 0x52, 0x82, 0x67, 0x0a, 0xec, 0xcf, 0x08,
	0xb7, 0x37, 0xa6, 0xa1, 0x00, 0x19, 0xc6, 0x34, 0x85, 0x90, 0xcf, 0x5e, 0x41, 0xa4, 0x43, 0xbd,
	0x12, 0xd0, 0x42, 0x26, 0x0f, 0xad, 0xcf, 0x53, 0xc3, 0x22, 0x9b, 0xca, 0x04, 0xe4, 0x88, 0xa6,
	0xf0, 0xd8, 0x40, 0x9e, 0xae, 0x04, 0x3c, 0xcc, 0xb4, 0x5c, 0x05, 0x0e, 0xdb, 0xd9, 0x60, 0xdf,
	0xc2, 0x0d, 0xad, 0x59, 0xeb, 0xbc, 0x99, 0xf9, 0xe5, 0x75, 0x96, 0xf5, 0x96, 0xc9, 0x83, 0x72,
	0xcb, 0x41, 0xde, 0xe5, 0x7c, 0x40, 0xb8, 0x53, 0x03, 0xb3, 0x2f, 0xe0, 0xc6, 0x6b, 0x58, 0x99,
	0x25, 0xee, 0x05, 0xf9, 0x4f, 0x7b, 0x8a, 0xf7, 0x96, 0x94, 0x2d, 0xa0, 0x65, 0x19, 0xc8, 0xdd,
	0x13, 0x2f, 0xe0, 0xdf, 0x1b, 0x8f, 0x13, 0xa5, 0x83, 0xc2, 0xab, 0x6f, 0x1d, 0xa2, 0xde, 0x5b,
	0x0b, 0x5f, 0xac, 0x4c, 0xc5, 0xfe, 0x86, 0xf0, 0xfe, 0x8e, 0x89, 0xd9, 0xf7, 0x4e, 0x31, 0x6c,
	0xf3, 0x56, 0x9d, 0xc1, 0xa9, 0xd7, 0xd5, 0xbd, 0xf1, 0xee, 0xe7, 0xef, 0x8f, 0x96, 0xdb, 0xbd,
	0xe2, 0x2d, 0xfd, 0xbe, 0xfa, 0x7f, 0x73, 0x1f, 0xdd, 0x74, 0xae, 0x7d, 0x1f, 0xb8, 0x55, 0x40,
	0x81, 0xa7, 0x22, 0x51, 0x24, 0xe2, 0xe9, 0xf0, 0x2b, 0xc2, 0xd7, 0x23, 0x9e, 0xd6, 0xa6, 0x1a,
	0x5e, 0xaa, 0x30, 0x26, 0xf9, 0x92, 0x27, 0xe8, 0xc5, 0x93, 0x52, 0x1b, 0x73, 0x46, 0xb3, 0x98,
	0x70, 0x19, 0x7b, 0x31, 0x64, 0xe6, 0x09, 0x78, 0x7f, 0x69, 0xbb, 0x3f, 0x19, 0x77, 0x2a, 0xc5,
	0x4f, 0xd6, 0x99, 0xd1, 0xd1, 0x64, 0xfc, 0xc5, 0x72, 0x47, 0x85, 0xf5, 0x51, 0x1e, 0xab, 0x12,
	0x80, 0x3c, 0xf3, 0x67, 0x67, 0x0d, 0xc7, 0xff, 0x13, 0x00, 0x00, 0xff, 0xff, 0x6e, 0x89, 0xe9,
	0x23, 0x34, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PlayableLocationsClient is the client API for PlayableLocations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PlayableLocationsClient interface {
	// Returns a set of playable locations that lie within a specified area,
	// that satisfy optional filter criteria.
	//
	// Note: Identical `SamplePlayableLocations` requests can return different
	// results as the state of the world changes over time.
	SamplePlayableLocations(ctx context.Context, in *SamplePlayableLocationsRequest, opts ...grpc.CallOption) (*SamplePlayableLocationsResponse, error)
}

type playableLocationsClient struct {
	cc grpc.ClientConnInterface
}

func NewPlayableLocationsClient(cc grpc.ClientConnInterface) PlayableLocationsClient {
	return &playableLocationsClient{cc}
}

func (c *playableLocationsClient) SamplePlayableLocations(ctx context.Context, in *SamplePlayableLocationsRequest, opts ...grpc.CallOption) (*SamplePlayableLocationsResponse, error) {
	out := new(SamplePlayableLocationsResponse)
	err := c.cc.Invoke(ctx, "/google.maps.playablelocations.v3.PlayableLocations/SamplePlayableLocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PlayableLocationsServer is the server API for PlayableLocations service.
type PlayableLocationsServer interface {
	// Returns a set of playable locations that lie within a specified area,
	// that satisfy optional filter criteria.
	//
	// Note: Identical `SamplePlayableLocations` requests can return different
	// results as the state of the world changes over time.
	SamplePlayableLocations(context.Context, *SamplePlayableLocationsRequest) (*SamplePlayableLocationsResponse, error)
}

// UnimplementedPlayableLocationsServer can be embedded to have forward compatible implementations.
type UnimplementedPlayableLocationsServer struct {
}

func (*UnimplementedPlayableLocationsServer) SamplePlayableLocations(ctx context.Context, req *SamplePlayableLocationsRequest) (*SamplePlayableLocationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SamplePlayableLocations not implemented")
}

func RegisterPlayableLocationsServer(s *grpc.Server, srv PlayableLocationsServer) {
	s.RegisterService(&_PlayableLocations_serviceDesc, srv)
}

func _PlayableLocations_SamplePlayableLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SamplePlayableLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlayableLocationsServer).SamplePlayableLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.playablelocations.v3.PlayableLocations/SamplePlayableLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlayableLocationsServer).SamplePlayableLocations(ctx, req.(*SamplePlayableLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PlayableLocations_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.playablelocations.v3.PlayableLocations",
	HandlerType: (*PlayableLocationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SamplePlayableLocations",
			Handler:    _PlayableLocations_SamplePlayableLocations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/playablelocations/v3/playablelocations.proto",
}
