/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/sriov-network-operator/pkg/apis/sriovnetwork/v1"
	scheme "github.com/openshift/sriov-network-operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SriovNetworkNodeStatesGetter has a method to return a SriovNetworkNodeStateInterface.
// A group's client should implement this interface.
type SriovNetworkNodeStatesGetter interface {
	SriovNetworkNodeStates(namespace string) SriovNetworkNodeStateInterface
}

// SriovNetworkNodeStateInterface has methods to work with SriovNetworkNodeState resources.
type SriovNetworkNodeStateInterface interface {
	Create(*v1.SriovNetworkNodeState) (*v1.SriovNetworkNodeState, error)
	Update(*v1.SriovNetworkNodeState) (*v1.SriovNetworkNodeState, error)
	UpdateStatus(*v1.SriovNetworkNodeState) (*v1.SriovNetworkNodeState, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.SriovNetworkNodeState, error)
	List(opts metav1.ListOptions) (*v1.SriovNetworkNodeStateList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.SriovNetworkNodeState, err error)
	SriovNetworkNodeStateExpansion
}

// sriovNetworkNodeStates implements SriovNetworkNodeStateInterface
type sriovNetworkNodeStates struct {
	client rest.Interface
	ns     string
}

// newSriovNetworkNodeStates returns a SriovNetworkNodeStates
func newSriovNetworkNodeStates(c *SriovnetworkV1Client, namespace string) *sriovNetworkNodeStates {
	return &sriovNetworkNodeStates{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the sriovNetworkNodeState, and returns the corresponding sriovNetworkNodeState object, and an error if there is any.
func (c *sriovNetworkNodeStates) Get(name string, options metav1.GetOptions) (result *v1.SriovNetworkNodeState, err error) {
	result = &v1.SriovNetworkNodeState{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SriovNetworkNodeStates that match those selectors.
func (c *sriovNetworkNodeStates) List(opts metav1.ListOptions) (result *v1.SriovNetworkNodeStateList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.SriovNetworkNodeStateList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested sriovNetworkNodeStates.
func (c *sriovNetworkNodeStates) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a sriovNetworkNodeState and creates it.  Returns the server's representation of the sriovNetworkNodeState, and an error, if there is any.
func (c *sriovNetworkNodeStates) Create(sriovNetworkNodeState *v1.SriovNetworkNodeState) (result *v1.SriovNetworkNodeState, err error) {
	result = &v1.SriovNetworkNodeState{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		Body(sriovNetworkNodeState).
		Do().
		Into(result)
	return
}

// Update takes the representation of a sriovNetworkNodeState and updates it. Returns the server's representation of the sriovNetworkNodeState, and an error, if there is any.
func (c *sriovNetworkNodeStates) Update(sriovNetworkNodeState *v1.SriovNetworkNodeState) (result *v1.SriovNetworkNodeState, err error) {
	result = &v1.SriovNetworkNodeState{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		Name(sriovNetworkNodeState.Name).
		Body(sriovNetworkNodeState).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *sriovNetworkNodeStates) UpdateStatus(sriovNetworkNodeState *v1.SriovNetworkNodeState) (result *v1.SriovNetworkNodeState, err error) {
	result = &v1.SriovNetworkNodeState{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		Name(sriovNetworkNodeState.Name).
		SubResource("status").
		Body(sriovNetworkNodeState).
		Do().
		Into(result)
	return
}

// Delete takes name of the sriovNetworkNodeState and deletes it. Returns an error if one occurs.
func (c *sriovNetworkNodeStates) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *sriovNetworkNodeStates) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched sriovNetworkNodeState.
func (c *sriovNetworkNodeStates) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.SriovNetworkNodeState, err error) {
	result = &v1.SriovNetworkNodeState{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
