package servicemap

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/operationalinsights/mgmt/2015-11-01-preview/servicemap"

// Accuracy enumerates the values for accuracy.
type Accuracy string

const (
	// Actual ...
	Actual Accuracy = "actual"
	// Estimated ...
	Estimated Accuracy = "estimated"
)

// PossibleAccuracyValues returns an array of possible values for the Accuracy const type.
func PossibleAccuracyValues() []Accuracy {
	return []Accuracy{Actual, Estimated}
}

// AzureCloudServiceRoleType enumerates the values for azure cloud service role type.
type AzureCloudServiceRoleType string

const (
	// Unknown ...
	Unknown AzureCloudServiceRoleType = "unknown"
	// Web ...
	Web AzureCloudServiceRoleType = "web"
	// Worker ...
	Worker AzureCloudServiceRoleType = "worker"
)

// PossibleAzureCloudServiceRoleTypeValues returns an array of possible values for the AzureCloudServiceRoleType const type.
func PossibleAzureCloudServiceRoleTypeValues() []AzureCloudServiceRoleType {
	return []AzureCloudServiceRoleType{Unknown, Web, Worker}
}

// Bitness enumerates the values for bitness.
type Bitness string

const (
	// SixFourbit ...
	SixFourbit Bitness = "64bit"
	// ThreeTwobit ...
	ThreeTwobit Bitness = "32bit"
)

// PossibleBitnessValues returns an array of possible values for the Bitness const type.
func PossibleBitnessValues() []Bitness {
	return []Bitness{SixFourbit, ThreeTwobit}
}

// ConnectionFailureState enumerates the values for connection failure state.
type ConnectionFailureState string

const (
	// Failed ...
	Failed ConnectionFailureState = "failed"
	// Mixed ...
	Mixed ConnectionFailureState = "mixed"
	// Ok ...
	Ok ConnectionFailureState = "ok"
)

// PossibleConnectionFailureStateValues returns an array of possible values for the ConnectionFailureState const type.
func PossibleConnectionFailureStateValues() []ConnectionFailureState {
	return []ConnectionFailureState{Failed, Mixed, Ok}
}

// HypervisorType enumerates the values for hypervisor type.
type HypervisorType string

const (
	// HypervisorTypeHyperv ...
	HypervisorTypeHyperv HypervisorType = "hyperv"
	// HypervisorTypeUnknown ...
	HypervisorTypeUnknown HypervisorType = "unknown"
)

// PossibleHypervisorTypeValues returns an array of possible values for the HypervisorType const type.
func PossibleHypervisorTypeValues() []HypervisorType {
	return []HypervisorType{HypervisorTypeHyperv, HypervisorTypeUnknown}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindRefclientgroup ...
	KindRefclientgroup Kind = "ref:clientgroup"
	// KindRefmachine ...
	KindRefmachine Kind = "ref:machine"
	// KindRefmachinewithhints ...
	KindRefmachinewithhints Kind = "ref:machinewithhints"
	// KindRefport ...
	KindRefport Kind = "ref:port"
	// KindRefprocess ...
	KindRefprocess Kind = "ref:process"
	// KindResourceReference ...
	KindResourceReference Kind = "ResourceReference"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindRefclientgroup, KindRefmachine, KindRefmachinewithhints, KindRefport, KindRefprocess, KindResourceReference}
}

// KindBasicCoreResource enumerates the values for kind basic core resource.
type KindBasicCoreResource string

const (
	// KindClientGroup ...
	KindClientGroup KindBasicCoreResource = "clientGroup"
	// KindCoreResource ...
	KindCoreResource KindBasicCoreResource = "CoreResource"
	// KindMachine ...
	KindMachine KindBasicCoreResource = "machine"
	// KindMachineGroup ...
	KindMachineGroup KindBasicCoreResource = "machineGroup"
	// KindPort ...
	KindPort KindBasicCoreResource = "port"
	// KindProcess ...
	KindProcess KindBasicCoreResource = "process"
)

// PossibleKindBasicCoreResourceValues returns an array of possible values for the KindBasicCoreResource const type.
func PossibleKindBasicCoreResourceValues() []KindBasicCoreResource {
	return []KindBasicCoreResource{KindClientGroup, KindCoreResource, KindMachine, KindMachineGroup, KindPort, KindProcess}
}

// KindBasicHostingConfiguration enumerates the values for kind basic hosting configuration.
type KindBasicHostingConfiguration string

const (
	// KindHostingConfiguration ...
	KindHostingConfiguration KindBasicHostingConfiguration = "HostingConfiguration"
	// KindProviderazure ...
	KindProviderazure KindBasicHostingConfiguration = "provider:azure"
)

// PossibleKindBasicHostingConfigurationValues returns an array of possible values for the KindBasicHostingConfiguration const type.
func PossibleKindBasicHostingConfigurationValues() []KindBasicHostingConfiguration {
	return []KindBasicHostingConfiguration{KindHostingConfiguration, KindProviderazure}
}

// KindBasicMapRequest enumerates the values for kind basic map request.
type KindBasicMapRequest string

const (
	// KindMapmachineGroupDependency ...
	KindMapmachineGroupDependency KindBasicMapRequest = "map:machine-group-dependency"
	// KindMapmachineListDependency ...
	KindMapmachineListDependency KindBasicMapRequest = "map:machine-list-dependency"
	// KindMapRequest ...
	KindMapRequest KindBasicMapRequest = "MapRequest"
	// KindMapsingleMachineDependency ...
	KindMapsingleMachineDependency KindBasicMapRequest = "map:single-machine-dependency"
	// KindMultipleMachinesMapRequest ...
	KindMultipleMachinesMapRequest KindBasicMapRequest = "MultipleMachinesMapRequest"
)

// PossibleKindBasicMapRequestValues returns an array of possible values for the KindBasicMapRequest const type.
func PossibleKindBasicMapRequestValues() []KindBasicMapRequest {
	return []KindBasicMapRequest{KindMapmachineGroupDependency, KindMapmachineListDependency, KindMapRequest, KindMapsingleMachineDependency, KindMultipleMachinesMapRequest}
}

// KindBasicProcessHostingConfiguration enumerates the values for kind basic process hosting configuration.
type KindBasicProcessHostingConfiguration string

const (
	// KindBasicProcessHostingConfigurationKindProcessHostingConfiguration ...
	KindBasicProcessHostingConfigurationKindProcessHostingConfiguration KindBasicProcessHostingConfiguration = "ProcessHostingConfiguration"
	// KindBasicProcessHostingConfigurationKindProviderazure ...
	KindBasicProcessHostingConfigurationKindProviderazure KindBasicProcessHostingConfiguration = "provider:azure"
)

// PossibleKindBasicProcessHostingConfigurationValues returns an array of possible values for the KindBasicProcessHostingConfiguration const type.
func PossibleKindBasicProcessHostingConfigurationValues() []KindBasicProcessHostingConfiguration {
	return []KindBasicProcessHostingConfiguration{KindBasicProcessHostingConfigurationKindProcessHostingConfiguration, KindBasicProcessHostingConfigurationKindProviderazure}
}

// KindBasicRelationship enumerates the values for kind basic relationship.
type KindBasicRelationship string

const (
	// KindRelacceptor ...
	KindRelacceptor KindBasicRelationship = "rel:acceptor"
	// KindRelationship ...
	KindRelationship KindBasicRelationship = "Relationship"
	// KindRelconnection ...
	KindRelconnection KindBasicRelationship = "rel:connection"
)

// PossibleKindBasicRelationshipValues returns an array of possible values for the KindBasicRelationship const type.
func PossibleKindBasicRelationshipValues() []KindBasicRelationship {
	return []KindBasicRelationship{KindRelacceptor, KindRelationship, KindRelconnection}
}

// MachineGroupType enumerates the values for machine group type.
type MachineGroupType string

const (
	// MachineGroupTypeAzureCs ...
	MachineGroupTypeAzureCs MachineGroupType = "azure-cs"
	// MachineGroupTypeAzureSf ...
	MachineGroupTypeAzureSf MachineGroupType = "azure-sf"
	// MachineGroupTypeAzureVmss ...
	MachineGroupTypeAzureVmss MachineGroupType = "azure-vmss"
	// MachineGroupTypeUnknown ...
	MachineGroupTypeUnknown MachineGroupType = "unknown"
	// MachineGroupTypeUserStatic ...
	MachineGroupTypeUserStatic MachineGroupType = "user-static"
)

// PossibleMachineGroupTypeValues returns an array of possible values for the MachineGroupType const type.
func PossibleMachineGroupTypeValues() []MachineGroupType {
	return []MachineGroupType{MachineGroupTypeAzureCs, MachineGroupTypeAzureSf, MachineGroupTypeAzureVmss, MachineGroupTypeUnknown, MachineGroupTypeUserStatic}
}

// MachineRebootStatus enumerates the values for machine reboot status.
type MachineRebootStatus string

const (
	// MachineRebootStatusNotRebooted ...
	MachineRebootStatusNotRebooted MachineRebootStatus = "notRebooted"
	// MachineRebootStatusRebooted ...
	MachineRebootStatusRebooted MachineRebootStatus = "rebooted"
	// MachineRebootStatusUnknown ...
	MachineRebootStatusUnknown MachineRebootStatus = "unknown"
)

// PossibleMachineRebootStatusValues returns an array of possible values for the MachineRebootStatus const type.
func PossibleMachineRebootStatusValues() []MachineRebootStatus {
	return []MachineRebootStatus{MachineRebootStatusNotRebooted, MachineRebootStatusRebooted, MachineRebootStatusUnknown}
}

// MonitoringState enumerates the values for monitoring state.
type MonitoringState string

const (
	// Discovered ...
	Discovered MonitoringState = "discovered"
	// Monitored ...
	Monitored MonitoringState = "monitored"
)

// PossibleMonitoringStateValues returns an array of possible values for the MonitoringState const type.
func PossibleMonitoringStateValues() []MonitoringState {
	return []MonitoringState{Discovered, Monitored}
}

// OperatingSystemFamily enumerates the values for operating system family.
type OperatingSystemFamily string

const (
	// OperatingSystemFamilyAix ...
	OperatingSystemFamilyAix OperatingSystemFamily = "aix"
	// OperatingSystemFamilyLinux ...
	OperatingSystemFamilyLinux OperatingSystemFamily = "linux"
	// OperatingSystemFamilySolaris ...
	OperatingSystemFamilySolaris OperatingSystemFamily = "solaris"
	// OperatingSystemFamilyUnknown ...
	OperatingSystemFamilyUnknown OperatingSystemFamily = "unknown"
	// OperatingSystemFamilyWindows ...
	OperatingSystemFamilyWindows OperatingSystemFamily = "windows"
)

// PossibleOperatingSystemFamilyValues returns an array of possible values for the OperatingSystemFamily const type.
func PossibleOperatingSystemFamilyValues() []OperatingSystemFamily {
	return []OperatingSystemFamily{OperatingSystemFamilyAix, OperatingSystemFamilyLinux, OperatingSystemFamilySolaris, OperatingSystemFamilyUnknown, OperatingSystemFamilyWindows}
}

// ProcessRole enumerates the values for process role.
type ProcessRole string

const (
	// AppServer ...
	AppServer ProcessRole = "appServer"
	// DatabaseServer ...
	DatabaseServer ProcessRole = "databaseServer"
	// LdapServer ...
	LdapServer ProcessRole = "ldapServer"
	// SmbServer ...
	SmbServer ProcessRole = "smbServer"
	// WebServer ...
	WebServer ProcessRole = "webServer"
)

// PossibleProcessRoleValues returns an array of possible values for the ProcessRole const type.
func PossibleProcessRoleValues() []ProcessRole {
	return []ProcessRole{AppServer, DatabaseServer, LdapServer, SmbServer, WebServer}
}

// Provider enumerates the values for provider.
type Provider string

const (
	// Azure ...
	Azure Provider = "azure"
)

// PossibleProviderValues returns an array of possible values for the Provider const type.
func PossibleProviderValues() []Provider {
	return []Provider{Azure}
}

// Provider1 enumerates the values for provider 1.
type Provider1 string

const (
	// Provider1Azure ...
	Provider1Azure Provider1 = "azure"
)

// PossibleProvider1Values returns an array of possible values for the Provider1 const type.
func PossibleProvider1Values() []Provider1 {
	return []Provider1{Provider1Azure}
}

// VirtualizationState enumerates the values for virtualization state.
type VirtualizationState string

const (
	// VirtualizationStateHypervisor ...
	VirtualizationStateHypervisor VirtualizationState = "hypervisor"
	// VirtualizationStatePhysical ...
	VirtualizationStatePhysical VirtualizationState = "physical"
	// VirtualizationStateUnknown ...
	VirtualizationStateUnknown VirtualizationState = "unknown"
	// VirtualizationStateVirtual ...
	VirtualizationStateVirtual VirtualizationState = "virtual"
)

// PossibleVirtualizationStateValues returns an array of possible values for the VirtualizationState const type.
func PossibleVirtualizationStateValues() []VirtualizationState {
	return []VirtualizationState{VirtualizationStateHypervisor, VirtualizationStatePhysical, VirtualizationStateUnknown, VirtualizationStateVirtual}
}

// VirtualMachineType enumerates the values for virtual machine type.
type VirtualMachineType string

const (
	// VirtualMachineTypeHyperv ...
	VirtualMachineTypeHyperv VirtualMachineType = "hyperv"
	// VirtualMachineTypeLdom ...
	VirtualMachineTypeLdom VirtualMachineType = "ldom"
	// VirtualMachineTypeLpar ...
	VirtualMachineTypeLpar VirtualMachineType = "lpar"
	// VirtualMachineTypeUnknown ...
	VirtualMachineTypeUnknown VirtualMachineType = "unknown"
	// VirtualMachineTypeVirtualPc ...
	VirtualMachineTypeVirtualPc VirtualMachineType = "virtualPc"
	// VirtualMachineTypeVmware ...
	VirtualMachineTypeVmware VirtualMachineType = "vmware"
	// VirtualMachineTypeXen ...
	VirtualMachineTypeXen VirtualMachineType = "xen"
)

// PossibleVirtualMachineTypeValues returns an array of possible values for the VirtualMachineType const type.
func PossibleVirtualMachineTypeValues() []VirtualMachineType {
	return []VirtualMachineType{VirtualMachineTypeHyperv, VirtualMachineTypeLdom, VirtualMachineTypeLpar, VirtualMachineTypeUnknown, VirtualMachineTypeVirtualPc, VirtualMachineTypeVmware, VirtualMachineTypeXen}
}

// Acceptor a process accepting on a port.
type Acceptor struct {
	*AcceptorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindRelationship', 'KindRelconnection', 'KindRelacceptor'
	Kind KindBasicRelationship `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for Acceptor.
func (a Acceptor) MarshalJSON() ([]byte, error) {
	a.Kind = KindRelacceptor
	objectMap := make(map[string]interface{})
	if a.AcceptorProperties != nil {
		objectMap["properties"] = a.AcceptorProperties
	}
	if a.Kind != "" {
		objectMap["kind"] = a.Kind
	}
	return json.Marshal(objectMap)
}

// AsConnection is the BasicRelationship implementation for Acceptor.
func (a Acceptor) AsConnection() (*Connection, bool) {
	return nil, false
}

// AsAcceptor is the BasicRelationship implementation for Acceptor.
func (a Acceptor) AsAcceptor() (*Acceptor, bool) {
	return &a, true
}

// AsRelationship is the BasicRelationship implementation for Acceptor.
func (a Acceptor) AsRelationship() (*Relationship, bool) {
	return nil, false
}

// AsBasicRelationship is the BasicRelationship implementation for Acceptor.
func (a Acceptor) AsBasicRelationship() (BasicRelationship, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Acceptor struct.
func (a *Acceptor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var acceptorProperties AcceptorProperties
				err = json.Unmarshal(*v, &acceptorProperties)
				if err != nil {
					return err
				}
				a.AcceptorProperties = &acceptorProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicRelationship
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				a.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		}
	}

	return nil
}

// AcceptorProperties properties for an acceptor relationship.
type AcceptorProperties struct {
	// Source - Port being accepted.
	Source *PortReference `json:"source,omitempty"`
	// Destination - Accepting process.
	Destination *ProcessReference `json:"destination,omitempty"`
	// StartTime - Relationship start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Relationship end time.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// AgentConfiguration describes the configuration of the Dependency Agent installed on a machine.
type AgentConfiguration struct {
	// AgentID - Health Service Agent unique identifier.
	AgentID *string `json:"agentId,omitempty"`
	// DependencyAgentID - Dependency Agent unique identifier.
	DependencyAgentID *string `json:"dependencyAgentId,omitempty"`
	// DependencyAgentVersion - Dependency Agent version number.
	DependencyAgentVersion *string `json:"dependencyAgentVersion,omitempty"`
	// DependencyAgentRevision - Dependency Agent revision number.
	DependencyAgentRevision *string `json:"dependencyAgentRevision,omitempty"`
	// RebootStatus - Specifies whether the machine has been rebooted since the Dependency Agent installation. Possible values include: 'MachineRebootStatusUnknown', 'MachineRebootStatusRebooted', 'MachineRebootStatusNotRebooted'
	RebootStatus MachineRebootStatus `json:"rebootStatus,omitempty"`
	// ClockGranularity - Machine clock granularity in milliseconds.
	ClockGranularity *int32 `json:"clockGranularity,omitempty"`
}

// AzureCloudServiceConfiguration describes an Azure Cloud Service
type AzureCloudServiceConfiguration struct {
	// Name - Cloud Service name
	Name *string `json:"name,omitempty"`
	// InstanceID - Cloud Service instance identifier
	InstanceID *string `json:"instanceId,omitempty"`
	// Deployment - Cloud Service deployment identifier
	Deployment *string `json:"deployment,omitempty"`
	// RoleName - Cloud Service role name
	RoleName *string `json:"roleName,omitempty"`
	// RoleType - Used to specify type of an Azure Cloud Service role. Possible values include: 'Unknown', 'Worker', 'Web'
	RoleType AzureCloudServiceRoleType `json:"roleType,omitempty"`
}

// AzureHostingConfiguration provides information about how a machine is hosted in Azure
type AzureHostingConfiguration struct {
	// VMID - Virtual Machine ID (unique identifier).
	VMID *string `json:"vmId,omitempty"`
	// Location - Geographical location of the VM.
	Location *string `json:"location,omitempty"`
	// Name - Machine name according to the hosting provider.
	Name *string `json:"name,omitempty"`
	// Size - Size of the VM.
	Size *string `json:"size,omitempty"`
	// UpdateDomain - Update domain of the VM.
	UpdateDomain *string `json:"updateDomain,omitempty"`
	// FaultDomain - Fault domain of the VM.
	FaultDomain *string `json:"faultDomain,omitempty"`
	// SubscriptionID - Subscription ID.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - Resource group name within the specified subscription.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ResourceID - Unique identifier of the resource.
	ResourceID *string `json:"resourceId,omitempty"`
	// Image - Image of the machine.
	Image *ImageConfiguration `json:"image,omitempty"`
	// CloudService - Contains information about machines hosted as an Azure Cloud Service
	CloudService *AzureCloudServiceConfiguration `json:"cloudService,omitempty"`
	// VMScaleSet - Contains information about machines hosted as an Azure Virtual Machine Scale Set
	VMScaleSet *AzureVMScaleSetConfiguration `json:"vmScaleSet,omitempty"`
	// ServiceFabricCluster - Contains information about machines that belong an Azure Service Fabric Cluster
	ServiceFabricCluster *AzureServiceFabricClusterConfiguration `json:"serviceFabricCluster,omitempty"`
	// Provider - The hosting provider of the VM. Possible values include: 'Azure'
	Provider Provider `json:"provider,omitempty"`
	// Kind - Possible values include: 'KindHostingConfiguration', 'KindProviderazure'
	Kind KindBasicHostingConfiguration `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureHostingConfiguration.
func (ahc AzureHostingConfiguration) MarshalJSON() ([]byte, error) {
	ahc.Kind = KindProviderazure
	objectMap := make(map[string]interface{})
	if ahc.VMID != nil {
		objectMap["vmId"] = ahc.VMID
	}
	if ahc.Location != nil {
		objectMap["location"] = ahc.Location
	}
	if ahc.Name != nil {
		objectMap["name"] = ahc.Name
	}
	if ahc.Size != nil {
		objectMap["size"] = ahc.Size
	}
	if ahc.UpdateDomain != nil {
		objectMap["updateDomain"] = ahc.UpdateDomain
	}
	if ahc.FaultDomain != nil {
		objectMap["faultDomain"] = ahc.FaultDomain
	}
	if ahc.SubscriptionID != nil {
		objectMap["subscriptionId"] = ahc.SubscriptionID
	}
	if ahc.ResourceGroup != nil {
		objectMap["resourceGroup"] = ahc.ResourceGroup
	}
	if ahc.ResourceID != nil {
		objectMap["resourceId"] = ahc.ResourceID
	}
	if ahc.Image != nil {
		objectMap["image"] = ahc.Image
	}
	if ahc.CloudService != nil {
		objectMap["cloudService"] = ahc.CloudService
	}
	if ahc.VMScaleSet != nil {
		objectMap["vmScaleSet"] = ahc.VMScaleSet
	}
	if ahc.ServiceFabricCluster != nil {
		objectMap["serviceFabricCluster"] = ahc.ServiceFabricCluster
	}
	if ahc.Provider != "" {
		objectMap["provider"] = ahc.Provider
	}
	if ahc.Kind != "" {
		objectMap["kind"] = ahc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAzureHostingConfiguration is the BasicHostingConfiguration implementation for AzureHostingConfiguration.
func (ahc AzureHostingConfiguration) AsAzureHostingConfiguration() (*AzureHostingConfiguration, bool) {
	return &ahc, true
}

// AsHostingConfiguration is the BasicHostingConfiguration implementation for AzureHostingConfiguration.
func (ahc AzureHostingConfiguration) AsHostingConfiguration() (*HostingConfiguration, bool) {
	return nil, false
}

// AsBasicHostingConfiguration is the BasicHostingConfiguration implementation for AzureHostingConfiguration.
func (ahc AzureHostingConfiguration) AsBasicHostingConfiguration() (BasicHostingConfiguration, bool) {
	return &ahc, true
}

// AzureProcessHostingConfiguration describes the hosting configuration of a process when hosted on azure
type AzureProcessHostingConfiguration struct {
	// CloudService - Contains information about the cloud service the process belongs to
	CloudService *AzureCloudServiceConfiguration `json:"cloudService,omitempty"`
	// Provider - The hosting provider of the VM. Possible values include: 'Provider1Azure'
	Provider Provider1 `json:"provider,omitempty"`
	// Kind - Possible values include: 'KindBasicProcessHostingConfigurationKindProcessHostingConfiguration', 'KindBasicProcessHostingConfigurationKindProviderazure'
	Kind KindBasicProcessHostingConfiguration `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureProcessHostingConfiguration.
func (aphc AzureProcessHostingConfiguration) MarshalJSON() ([]byte, error) {
	aphc.Kind = KindBasicProcessHostingConfigurationKindProviderazure
	objectMap := make(map[string]interface{})
	if aphc.CloudService != nil {
		objectMap["cloudService"] = aphc.CloudService
	}
	if aphc.Provider != "" {
		objectMap["provider"] = aphc.Provider
	}
	if aphc.Kind != "" {
		objectMap["kind"] = aphc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAzureProcessHostingConfiguration is the BasicProcessHostingConfiguration implementation for AzureProcessHostingConfiguration.
func (aphc AzureProcessHostingConfiguration) AsAzureProcessHostingConfiguration() (*AzureProcessHostingConfiguration, bool) {
	return &aphc, true
}

// AsProcessHostingConfiguration is the BasicProcessHostingConfiguration implementation for AzureProcessHostingConfiguration.
func (aphc AzureProcessHostingConfiguration) AsProcessHostingConfiguration() (*ProcessHostingConfiguration, bool) {
	return nil, false
}

// AsBasicProcessHostingConfiguration is the BasicProcessHostingConfiguration implementation for AzureProcessHostingConfiguration.
func (aphc AzureProcessHostingConfiguration) AsBasicProcessHostingConfiguration() (BasicProcessHostingConfiguration, bool) {
	return &aphc, true
}

// AzureServiceFabricClusterConfiguration describes an Azure Service Fabric Cluster
type AzureServiceFabricClusterConfiguration struct {
	// Name - Service Fabric cluster name.
	Name *string `json:"name,omitempty"`
	// ClusterID - Service Fabric cluster identifier.
	ClusterID *string `json:"clusterId,omitempty"`
}

// AzureVMScaleSetConfiguration describes an Azure Virtual Machine Scale Set
type AzureVMScaleSetConfiguration struct {
	// Name - Virtual Machine Scale Set name
	Name *string `json:"name,omitempty"`
	// InstanceID - Virtual Machine Scale Set instance identifier
	InstanceID *string `json:"instanceId,omitempty"`
	// Deployment - Virtual Machine Scale Set deployment identifier
	Deployment *string `json:"deployment,omitempty"`
	// ResourceID - Unique identifier of the resource.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ClientGroup represents a collection of clients of a resource. A client group can represent the clients
// of a port, process, or a machine.
type ClientGroup struct {
	autorest.Response `json:"-"`
	// ClientGroupProperties - Resource properties.
	*ClientGroupProperties `json:"properties,omitempty"`
	// Etag - Resource ETAG.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindCoreResource', 'KindMachine', 'KindProcess', 'KindPort', 'KindClientGroup', 'KindMachineGroup'
	Kind KindBasicCoreResource `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClientGroup.
func (cg ClientGroup) MarshalJSON() ([]byte, error) {
	cg.Kind = KindClientGroup
	objectMap := make(map[string]interface{})
	if cg.ClientGroupProperties != nil {
		objectMap["properties"] = cg.ClientGroupProperties
	}
	if cg.Etag != nil {
		objectMap["etag"] = cg.Etag
	}
	if cg.Kind != "" {
		objectMap["kind"] = cg.Kind
	}
	return json.Marshal(objectMap)
}

// AsMachine is the BasicCoreResource implementation for ClientGroup.
func (cg ClientGroup) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicCoreResource implementation for ClientGroup.
func (cg ClientGroup) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicCoreResource implementation for ClientGroup.
func (cg ClientGroup) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicCoreResource implementation for ClientGroup.
func (cg ClientGroup) AsClientGroup() (*ClientGroup, bool) {
	return &cg, true
}

// AsMachineGroup is the BasicCoreResource implementation for ClientGroup.
func (cg ClientGroup) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsCoreResource is the BasicCoreResource implementation for ClientGroup.
func (cg ClientGroup) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicCoreResource implementation for ClientGroup.
func (cg ClientGroup) AsBasicCoreResource() (BasicCoreResource, bool) {
	return &cg, true
}

// UnmarshalJSON is the custom unmarshaler for ClientGroup struct.
func (cg *ClientGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clientGroupProperties ClientGroupProperties
				err = json.Unmarshal(*v, &clientGroupProperties)
				if err != nil {
					return err
				}
				cg.ClientGroupProperties = &clientGroupProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cg.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicCoreResource
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cg.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cg.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cg.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cg.Name = &name
			}
		}
	}

	return nil
}

// ClientGroupMember represents a member of a client group
type ClientGroupMember struct {
	// ClientGroupMemberProperties - Resource properties.
	*ClientGroupMemberProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for ClientGroupMember.
func (cgm ClientGroupMember) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cgm.ClientGroupMemberProperties != nil {
		objectMap["properties"] = cgm.ClientGroupMemberProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClientGroupMember struct.
func (cgm *ClientGroupMember) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clientGroupMemberProperties ClientGroupMemberProperties
				err = json.Unmarshal(*v, &clientGroupMemberProperties)
				if err != nil {
					return err
				}
				cgm.ClientGroupMemberProperties = &clientGroupMemberProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cgm.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cgm.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cgm.Name = &name
			}
		}
	}

	return nil
}

// ClientGroupMemberProperties resource properties.
type ClientGroupMemberProperties struct {
	// IPAddress - IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Port - Port into which this client connected
	Port *PortReference `json:"port,omitempty"`
	// Processes - Processes accepting on the above port that received connections from this client.
	Processes *[]ProcessReference `json:"processes,omitempty"`
}

// ClientGroupMembersCollection collection of ClientGroupMember resources.
type ClientGroupMembersCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of ClientGroupMember resources.
	Value *[]ClientGroupMember `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClientGroupMembersCollectionIterator provides access to a complete listing of ClientGroupMember values.
type ClientGroupMembersCollectionIterator struct {
	i    int
	page ClientGroupMembersCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClientGroupMembersCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClientGroupMembersCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClientGroupMembersCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClientGroupMembersCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClientGroupMembersCollectionIterator) Response() ClientGroupMembersCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClientGroupMembersCollectionIterator) Value() ClientGroupMember {
	if !iter.page.NotDone() {
		return ClientGroupMember{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClientGroupMembersCollectionIterator type.
func NewClientGroupMembersCollectionIterator(page ClientGroupMembersCollectionPage) ClientGroupMembersCollectionIterator {
	return ClientGroupMembersCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cgmc ClientGroupMembersCollection) IsEmpty() bool {
	return cgmc.Value == nil || len(*cgmc.Value) == 0
}

// clientGroupMembersCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cgmc ClientGroupMembersCollection) clientGroupMembersCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if cgmc.NextLink == nil || len(to.String(cgmc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cgmc.NextLink)))
}

// ClientGroupMembersCollectionPage contains a page of ClientGroupMember values.
type ClientGroupMembersCollectionPage struct {
	fn   func(context.Context, ClientGroupMembersCollection) (ClientGroupMembersCollection, error)
	cgmc ClientGroupMembersCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClientGroupMembersCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClientGroupMembersCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cgmc)
	if err != nil {
		return err
	}
	page.cgmc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClientGroupMembersCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClientGroupMembersCollectionPage) NotDone() bool {
	return !page.cgmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClientGroupMembersCollectionPage) Response() ClientGroupMembersCollection {
	return page.cgmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClientGroupMembersCollectionPage) Values() []ClientGroupMember {
	if page.cgmc.IsEmpty() {
		return nil
	}
	return *page.cgmc.Value
}

// Creates a new instance of the ClientGroupMembersCollectionPage type.
func NewClientGroupMembersCollectionPage(getNextPage func(context.Context, ClientGroupMembersCollection) (ClientGroupMembersCollection, error)) ClientGroupMembersCollectionPage {
	return ClientGroupMembersCollectionPage{fn: getNextPage}
}

// ClientGroupMembersCount specifies the number of members in a client group.
type ClientGroupMembersCount struct {
	autorest.Response `json:"-"`
	// StartTime - Membership interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Membership interval start time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// GroupID - Client Group URI.
	GroupID *string `json:"groupId,omitempty"`
	// Count - Number of members in the client group. Use this value together with the value of ```accuracy```. If accuracy is `exact` then the value represents the actual number of members in the cloud. When accuracy is `estimated`, the actual number of members is larger than the value of ```count```.
	Count *int32 `json:"count,omitempty"`
	// Accuracy - Accuracy of the reported count. Possible values include: 'Actual', 'Estimated'
	Accuracy Accuracy `json:"accuracy,omitempty"`
}

// ClientGroupProperties resource properties.
type ClientGroupProperties struct {
	// ClientsOf - Reference to the resource whose clients are represented by this group.
	ClientsOf BasicResourceReference `json:"clientsOf,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ClientGroupProperties struct.
func (cg *ClientGroupProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "clientsOf":
			if v != nil {
				clientsOf, err := unmarshalBasicResourceReference(*v)
				if err != nil {
					return err
				}
				cg.ClientsOf = clientsOf
			}
		}
	}

	return nil
}

// ClientGroupReference reference to a client group.
type ClientGroupReference struct {
	// ID - Resource URI.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type qualifier.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindResourceReference', 'KindRefmachine', 'KindRefprocess', 'KindRefport', 'KindRefmachinewithhints', 'KindRefclientgroup'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClientGroupReference.
func (cgr ClientGroupReference) MarshalJSON() ([]byte, error) {
	cgr.Kind = KindRefclientgroup
	objectMap := make(map[string]interface{})
	if cgr.ID != nil {
		objectMap["id"] = cgr.ID
	}
	if cgr.Kind != "" {
		objectMap["kind"] = cgr.Kind
	}
	return json.Marshal(objectMap)
}

// AsMachineReference is the BasicResourceReference implementation for ClientGroupReference.
func (cgr ClientGroupReference) AsMachineReference() (*MachineReference, bool) {
	return nil, false
}

// AsProcessReference is the BasicResourceReference implementation for ClientGroupReference.
func (cgr ClientGroupReference) AsProcessReference() (*ProcessReference, bool) {
	return nil, false
}

// AsPortReference is the BasicResourceReference implementation for ClientGroupReference.
func (cgr ClientGroupReference) AsPortReference() (*PortReference, bool) {
	return nil, false
}

// AsMachineReferenceWithHints is the BasicResourceReference implementation for ClientGroupReference.
func (cgr ClientGroupReference) AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool) {
	return nil, false
}

// AsClientGroupReference is the BasicResourceReference implementation for ClientGroupReference.
func (cgr ClientGroupReference) AsClientGroupReference() (*ClientGroupReference, bool) {
	return &cgr, true
}

// AsResourceReference is the BasicResourceReference implementation for ClientGroupReference.
func (cgr ClientGroupReference) AsResourceReference() (*ResourceReference, bool) {
	return nil, false
}

// AsBasicResourceReference is the BasicResourceReference implementation for ClientGroupReference.
func (cgr ClientGroupReference) AsBasicResourceReference() (BasicResourceReference, bool) {
	return &cgr, true
}

// Connection a network connection.
type Connection struct {
	*ConnectionProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindRelationship', 'KindRelconnection', 'KindRelacceptor'
	Kind KindBasicRelationship `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Connection.
func (c Connection) MarshalJSON() ([]byte, error) {
	c.Kind = KindRelconnection
	objectMap := make(map[string]interface{})
	if c.ConnectionProperties != nil {
		objectMap["properties"] = c.ConnectionProperties
	}
	if c.Kind != "" {
		objectMap["kind"] = c.Kind
	}
	return json.Marshal(objectMap)
}

// AsConnection is the BasicRelationship implementation for Connection.
func (c Connection) AsConnection() (*Connection, bool) {
	return &c, true
}

// AsAcceptor is the BasicRelationship implementation for Connection.
func (c Connection) AsAcceptor() (*Acceptor, bool) {
	return nil, false
}

// AsRelationship is the BasicRelationship implementation for Connection.
func (c Connection) AsRelationship() (*Relationship, bool) {
	return nil, false
}

// AsBasicRelationship is the BasicRelationship implementation for Connection.
func (c Connection) AsBasicRelationship() (BasicRelationship, bool) {
	return &c, true
}

// UnmarshalJSON is the custom unmarshaler for Connection struct.
func (c *Connection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var connectionProperties ConnectionProperties
				err = json.Unmarshal(*v, &connectionProperties)
				if err != nil {
					return err
				}
				c.ConnectionProperties = &connectionProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicRelationship
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				c.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		}
	}

	return nil
}

// ConnectionCollection collection of Connection resources.
type ConnectionCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Connection resources.
	Value *[]Connection `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConnectionCollectionIterator provides access to a complete listing of Connection values.
type ConnectionCollectionIterator struct {
	i    int
	page ConnectionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConnectionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectionCollectionIterator) Response() ConnectionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectionCollectionIterator) Value() Connection {
	if !iter.page.NotDone() {
		return Connection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConnectionCollectionIterator type.
func NewConnectionCollectionIterator(page ConnectionCollectionPage) ConnectionCollectionIterator {
	return ConnectionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cc ConnectionCollection) IsEmpty() bool {
	return cc.Value == nil || len(*cc.Value) == 0
}

// connectionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cc ConnectionCollection) connectionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if cc.NextLink == nil || len(to.String(cc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cc.NextLink)))
}

// ConnectionCollectionPage contains a page of Connection values.
type ConnectionCollectionPage struct {
	fn func(context.Context, ConnectionCollection) (ConnectionCollection, error)
	cc ConnectionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cc)
	if err != nil {
		return err
	}
	page.cc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConnectionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectionCollectionPage) NotDone() bool {
	return !page.cc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectionCollectionPage) Response() ConnectionCollection {
	return page.cc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectionCollectionPage) Values() []Connection {
	if page.cc.IsEmpty() {
		return nil
	}
	return *page.cc.Value
}

// Creates a new instance of the ConnectionCollectionPage type.
func NewConnectionCollectionPage(getNextPage func(context.Context, ConnectionCollection) (ConnectionCollection, error)) ConnectionCollectionPage {
	return ConnectionCollectionPage{fn: getNextPage}
}

// ConnectionProperties properties for a connection resource.
type ConnectionProperties struct {
	// ServerPort - Reference to the server port via which this connection has been established.
	ServerPort *PortReference `json:"serverPort,omitempty"`
	// FailureState - Specifies whether there are only successful, failed or a mixture of both connections represented by this resource. Possible values include: 'Ok', 'Failed', 'Mixed'
	FailureState ConnectionFailureState `json:"failureState,omitempty"`
	// Source - Source resource of the relationship.
	Source BasicResourceReference `json:"source,omitempty"`
	// Destination - Destination resource of the relationship.
	Destination BasicResourceReference `json:"destination,omitempty"`
	// StartTime - Relationship start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Relationship end time.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ConnectionProperties struct.
func (cp *ConnectionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "serverPort":
			if v != nil {
				var serverPort PortReference
				err = json.Unmarshal(*v, &serverPort)
				if err != nil {
					return err
				}
				cp.ServerPort = &serverPort
			}
		case "failureState":
			if v != nil {
				var failureState ConnectionFailureState
				err = json.Unmarshal(*v, &failureState)
				if err != nil {
					return err
				}
				cp.FailureState = failureState
			}
		case "source":
			if v != nil {
				source, err := unmarshalBasicResourceReference(*v)
				if err != nil {
					return err
				}
				cp.Source = source
			}
		case "destination":
			if v != nil {
				destination, err := unmarshalBasicResourceReference(*v)
				if err != nil {
					return err
				}
				cp.Destination = destination
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				cp.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				cp.EndTime = &endTime
			}
		}
	}

	return nil
}

// BasicCoreResource marker resource for the core Service Map resources
type BasicCoreResource interface {
	AsMachine() (*Machine, bool)
	AsProcess() (*Process, bool)
	AsPort() (*Port, bool)
	AsClientGroup() (*ClientGroup, bool)
	AsMachineGroup() (*MachineGroup, bool)
	AsCoreResource() (*CoreResource, bool)
}

// CoreResource marker resource for the core Service Map resources
type CoreResource struct {
	// Etag - Resource ETAG.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindCoreResource', 'KindMachine', 'KindProcess', 'KindPort', 'KindClientGroup', 'KindMachineGroup'
	Kind KindBasicCoreResource `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
}

func unmarshalBasicCoreResource(body []byte) (BasicCoreResource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindMachine):
		var mVar Machine
		err := json.Unmarshal(body, &mVar)
		return mVar, err
	case string(KindProcess):
		var p Process
		err := json.Unmarshal(body, &p)
		return p, err
	case string(KindPort):
		var p Port
		err := json.Unmarshal(body, &p)
		return p, err
	case string(KindClientGroup):
		var cg ClientGroup
		err := json.Unmarshal(body, &cg)
		return cg, err
	case string(KindMachineGroup):
		var mg MachineGroup
		err := json.Unmarshal(body, &mg)
		return mg, err
	default:
		var cr CoreResource
		err := json.Unmarshal(body, &cr)
		return cr, err
	}
}
func unmarshalBasicCoreResourceArray(body []byte) ([]BasicCoreResource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	crArray := make([]BasicCoreResource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cr, err := unmarshalBasicCoreResource(*rawMessage)
		if err != nil {
			return nil, err
		}
		crArray[index] = cr
	}
	return crArray, nil
}

// MarshalJSON is the custom marshaler for CoreResource.
func (cr CoreResource) MarshalJSON() ([]byte, error) {
	cr.Kind = KindCoreResource
	objectMap := make(map[string]interface{})
	if cr.Etag != nil {
		objectMap["etag"] = cr.Etag
	}
	if cr.Kind != "" {
		objectMap["kind"] = cr.Kind
	}
	return json.Marshal(objectMap)
}

// AsMachine is the BasicCoreResource implementation for CoreResource.
func (cr CoreResource) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicCoreResource implementation for CoreResource.
func (cr CoreResource) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicCoreResource implementation for CoreResource.
func (cr CoreResource) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicCoreResource implementation for CoreResource.
func (cr CoreResource) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsMachineGroup is the BasicCoreResource implementation for CoreResource.
func (cr CoreResource) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsCoreResource is the BasicCoreResource implementation for CoreResource.
func (cr CoreResource) AsCoreResource() (*CoreResource, bool) {
	return &cr, true
}

// AsBasicCoreResource is the BasicCoreResource implementation for CoreResource.
func (cr CoreResource) AsBasicCoreResource() (BasicCoreResource, bool) {
	return &cr, true
}

// Error error details.
type Error struct {
	// Code - Error code identifying the specific error.
	Code *string `json:"code,omitempty"`
	// Message - Error message in the caller's locale.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse an error response from the API.
type ErrorResponse struct {
	// Error - Error information.
	Error *Error `json:"error,omitempty"`
}

// BasicHostingConfiguration describes the hosting configuration of a machine.
type BasicHostingConfiguration interface {
	AsAzureHostingConfiguration() (*AzureHostingConfiguration, bool)
	AsHostingConfiguration() (*HostingConfiguration, bool)
}

// HostingConfiguration describes the hosting configuration of a machine.
type HostingConfiguration struct {
	// Provider - The hosting provider of the VM. Possible values include: 'Azure'
	Provider Provider `json:"provider,omitempty"`
	// Kind - Possible values include: 'KindHostingConfiguration', 'KindProviderazure'
	Kind KindBasicHostingConfiguration `json:"kind,omitempty"`
}

func unmarshalBasicHostingConfiguration(body []byte) (BasicHostingConfiguration, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindProviderazure):
		var ahc AzureHostingConfiguration
		err := json.Unmarshal(body, &ahc)
		return ahc, err
	default:
		var hc HostingConfiguration
		err := json.Unmarshal(body, &hc)
		return hc, err
	}
}
func unmarshalBasicHostingConfigurationArray(body []byte) ([]BasicHostingConfiguration, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	hcArray := make([]BasicHostingConfiguration, len(rawMessages))

	for index, rawMessage := range rawMessages {
		hc, err := unmarshalBasicHostingConfiguration(*rawMessage)
		if err != nil {
			return nil, err
		}
		hcArray[index] = hc
	}
	return hcArray, nil
}

// MarshalJSON is the custom marshaler for HostingConfiguration.
func (hc HostingConfiguration) MarshalJSON() ([]byte, error) {
	hc.Kind = KindHostingConfiguration
	objectMap := make(map[string]interface{})
	if hc.Provider != "" {
		objectMap["provider"] = hc.Provider
	}
	if hc.Kind != "" {
		objectMap["kind"] = hc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAzureHostingConfiguration is the BasicHostingConfiguration implementation for HostingConfiguration.
func (hc HostingConfiguration) AsAzureHostingConfiguration() (*AzureHostingConfiguration, bool) {
	return nil, false
}

// AsHostingConfiguration is the BasicHostingConfiguration implementation for HostingConfiguration.
func (hc HostingConfiguration) AsHostingConfiguration() (*HostingConfiguration, bool) {
	return &hc, true
}

// AsBasicHostingConfiguration is the BasicHostingConfiguration implementation for HostingConfiguration.
func (hc HostingConfiguration) AsBasicHostingConfiguration() (BasicHostingConfiguration, bool) {
	return &hc, true
}

// HypervisorConfiguration describes the hypervisor configuration of a machine.
type HypervisorConfiguration struct {
	// HypervisorType - Specifies the virtualization technology used by the hypervisor (hyperv, vmware, etc.). Possible values include: 'HypervisorTypeUnknown', 'HypervisorTypeHyperv'
	HypervisorType HypervisorType `json:"hypervisorType,omitempty"`
	// NativeHostMachineID - The unique identifier of the hypervisor machine as reported by the underlying virtualization system.
	NativeHostMachineID *string `json:"nativeHostMachineId,omitempty"`
}

// ImageConfiguration describes the VM image of a machine.
type ImageConfiguration struct {
	// Publisher - Publisher of the VM image.
	Publisher *string `json:"publisher,omitempty"`
	// Offering - Offering of the VM image.
	Offering *string `json:"offering,omitempty"`
	// Sku - SKU of the VM image.
	Sku *string `json:"sku,omitempty"`
	// Version - Version of the VM image.
	Version *string `json:"version,omitempty"`
}

// Ipv4NetworkInterface describes an IPv4 network interface.
type Ipv4NetworkInterface struct {
	// IPAddress - IPv4 address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// SubnetMask - IPv4 subnet mask.
	SubnetMask *string `json:"subnetMask,omitempty"`
}

// Ipv6NetworkInterface describes an IPv6 network interface.
type Ipv6NetworkInterface struct {
	// IPAddress - IPv6 address.
	IPAddress *string `json:"ipAddress,omitempty"`
}

// Liveness specifies the contents of a check liveness response.
type Liveness struct {
	autorest.Response `json:"-"`
	// StartTime - Liveness interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Liveness interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Live - `true` if the resource is live during [startTime, endTime], `false` otherwise
	Live *bool `json:"live,omitempty"`
}

// Machine a machine resource represents a discovered computer system. It can be *monitored*, i.e., a
// Dependency Agent is running on it, or *discovered*, i.e., its existence was inferred by observing the
// data stream from monitored machines. As machines change, prior versions of the machine resource are
// preserved and available for access. A machine is live during an interval of time, if either its
// Dependency Agent has reported data during (parts) of that interval, or a Dependency agent running on
// other machines has reported activity associated with the machine.
type Machine struct {
	autorest.Response `json:"-"`
	// MachineProperties - Resource properties.
	*MachineProperties `json:"properties,omitempty"`
	// Etag - Resource ETAG.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindCoreResource', 'KindMachine', 'KindProcess', 'KindPort', 'KindClientGroup', 'KindMachineGroup'
	Kind KindBasicCoreResource `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Machine.
func (mVar Machine) MarshalJSON() ([]byte, error) {
	mVar.Kind = KindMachine
	objectMap := make(map[string]interface{})
	if mVar.MachineProperties != nil {
		objectMap["properties"] = mVar.MachineProperties
	}
	if mVar.Etag != nil {
		objectMap["etag"] = mVar.Etag
	}
	if mVar.Kind != "" {
		objectMap["kind"] = mVar.Kind
	}
	return json.Marshal(objectMap)
}

// AsMachine is the BasicCoreResource implementation for Machine.
func (mVar Machine) AsMachine() (*Machine, bool) {
	return &mVar, true
}

// AsProcess is the BasicCoreResource implementation for Machine.
func (mVar Machine) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicCoreResource implementation for Machine.
func (mVar Machine) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicCoreResource implementation for Machine.
func (mVar Machine) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsMachineGroup is the BasicCoreResource implementation for Machine.
func (mVar Machine) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsCoreResource is the BasicCoreResource implementation for Machine.
func (mVar Machine) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicCoreResource implementation for Machine.
func (mVar Machine) AsBasicCoreResource() (BasicCoreResource, bool) {
	return &mVar, true
}

// UnmarshalJSON is the custom unmarshaler for Machine struct.
func (mVar *Machine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var machineProperties MachineProperties
				err = json.Unmarshal(*v, &machineProperties)
				if err != nil {
					return err
				}
				mVar.MachineProperties = &machineProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mVar.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicCoreResource
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mVar.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		}
	}

	return nil
}

// MachineCollection collection of Machine resources.
type MachineCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Machine resources.
	Value *[]Machine `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MachineCollectionIterator provides access to a complete listing of Machine values.
type MachineCollectionIterator struct {
	i    int
	page MachineCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MachineCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MachineCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MachineCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MachineCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MachineCollectionIterator) Response() MachineCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MachineCollectionIterator) Value() Machine {
	if !iter.page.NotDone() {
		return Machine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MachineCollectionIterator type.
func NewMachineCollectionIterator(page MachineCollectionPage) MachineCollectionIterator {
	return MachineCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mc MachineCollection) IsEmpty() bool {
	return mc.Value == nil || len(*mc.Value) == 0
}

// machineCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mc MachineCollection) machineCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if mc.NextLink == nil || len(to.String(mc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mc.NextLink)))
}

// MachineCollectionPage contains a page of Machine values.
type MachineCollectionPage struct {
	fn func(context.Context, MachineCollection) (MachineCollection, error)
	mc MachineCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MachineCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MachineCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.mc)
	if err != nil {
		return err
	}
	page.mc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MachineCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MachineCollectionPage) NotDone() bool {
	return !page.mc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MachineCollectionPage) Response() MachineCollection {
	return page.mc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MachineCollectionPage) Values() []Machine {
	if page.mc.IsEmpty() {
		return nil
	}
	return *page.mc.Value
}

// Creates a new instance of the MachineCollectionPage type.
func NewMachineCollectionPage(getNextPage func(context.Context, MachineCollection) (MachineCollection, error)) MachineCollectionPage {
	return MachineCollectionPage{fn: getNextPage}
}

// MachineCountsByOperatingSystem machines by operating system.
type MachineCountsByOperatingSystem struct {
	// Windows - Number of live Windows machines.
	Windows *int32 `json:"windows,omitempty"`
	// Linux - Number of live Linux machines.
	Linux *int32 `json:"linux,omitempty"`
}

// MachineGroup a user-defined logical grouping of machines.
type MachineGroup struct {
	autorest.Response `json:"-"`
	// MachineGroupProperties - Resource properties.
	*MachineGroupProperties `json:"properties,omitempty"`
	// Etag - Resource ETAG.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindCoreResource', 'KindMachine', 'KindProcess', 'KindPort', 'KindClientGroup', 'KindMachineGroup'
	Kind KindBasicCoreResource `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineGroup.
func (mg MachineGroup) MarshalJSON() ([]byte, error) {
	mg.Kind = KindMachineGroup
	objectMap := make(map[string]interface{})
	if mg.MachineGroupProperties != nil {
		objectMap["properties"] = mg.MachineGroupProperties
	}
	if mg.Etag != nil {
		objectMap["etag"] = mg.Etag
	}
	if mg.Kind != "" {
		objectMap["kind"] = mg.Kind
	}
	return json.Marshal(objectMap)
}

// AsMachine is the BasicCoreResource implementation for MachineGroup.
func (mg MachineGroup) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicCoreResource implementation for MachineGroup.
func (mg MachineGroup) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicCoreResource implementation for MachineGroup.
func (mg MachineGroup) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicCoreResource implementation for MachineGroup.
func (mg MachineGroup) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsMachineGroup is the BasicCoreResource implementation for MachineGroup.
func (mg MachineGroup) AsMachineGroup() (*MachineGroup, bool) {
	return &mg, true
}

// AsCoreResource is the BasicCoreResource implementation for MachineGroup.
func (mg MachineGroup) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicCoreResource implementation for MachineGroup.
func (mg MachineGroup) AsBasicCoreResource() (BasicCoreResource, bool) {
	return &mg, true
}

// UnmarshalJSON is the custom unmarshaler for MachineGroup struct.
func (mg *MachineGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var machineGroupProperties MachineGroupProperties
				err = json.Unmarshal(*v, &machineGroupProperties)
				if err != nil {
					return err
				}
				mg.MachineGroupProperties = &machineGroupProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mg.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicCoreResource
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mg.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mg.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mg.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mg.Name = &name
			}
		}
	}

	return nil
}

// MachineGroupCollection collection of Machine Group resources.
type MachineGroupCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Machine Group resources.
	Value *[]MachineGroup `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MachineGroupCollectionIterator provides access to a complete listing of MachineGroup values.
type MachineGroupCollectionIterator struct {
	i    int
	page MachineGroupCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MachineGroupCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MachineGroupCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MachineGroupCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MachineGroupCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MachineGroupCollectionIterator) Response() MachineGroupCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MachineGroupCollectionIterator) Value() MachineGroup {
	if !iter.page.NotDone() {
		return MachineGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MachineGroupCollectionIterator type.
func NewMachineGroupCollectionIterator(page MachineGroupCollectionPage) MachineGroupCollectionIterator {
	return MachineGroupCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mgc MachineGroupCollection) IsEmpty() bool {
	return mgc.Value == nil || len(*mgc.Value) == 0
}

// machineGroupCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mgc MachineGroupCollection) machineGroupCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if mgc.NextLink == nil || len(to.String(mgc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mgc.NextLink)))
}

// MachineGroupCollectionPage contains a page of MachineGroup values.
type MachineGroupCollectionPage struct {
	fn  func(context.Context, MachineGroupCollection) (MachineGroupCollection, error)
	mgc MachineGroupCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MachineGroupCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MachineGroupCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.mgc)
	if err != nil {
		return err
	}
	page.mgc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MachineGroupCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MachineGroupCollectionPage) NotDone() bool {
	return !page.mgc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MachineGroupCollectionPage) Response() MachineGroupCollection {
	return page.mgc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MachineGroupCollectionPage) Values() []MachineGroup {
	if page.mgc.IsEmpty() {
		return nil
	}
	return *page.mgc.Value
}

// Creates a new instance of the MachineGroupCollectionPage type.
func NewMachineGroupCollectionPage(getNextPage func(context.Context, MachineGroupCollection) (MachineGroupCollection, error)) MachineGroupCollectionPage {
	return MachineGroupCollectionPage{fn: getNextPage}
}

// MachineGroupMapRequest specifies the computation of a machine group dependency map. A machine group
// dependency map includes all direct dependencies the machines in the group.
type MachineGroupMapRequest struct {
	// MachineGroupID - URI of machine group resource for which to generate the map.
	MachineGroupID *string `json:"machineGroupId,omitempty"`
	// FilterProcesses - If true, only processes between specified machines will be included. Any connections in or out of those processes will be included.
	FilterProcesses *bool `json:"filterProcesses,omitempty"`
	// StartTime - Map interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Map interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Kind - Possible values include: 'KindMapRequest', 'KindMapsingleMachineDependency', 'KindMultipleMachinesMapRequest', 'KindMapmachineListDependency', 'KindMapmachineGroupDependency'
	Kind KindBasicMapRequest `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) MarshalJSON() ([]byte, error) {
	mgmr.Kind = KindMapmachineGroupDependency
	objectMap := make(map[string]interface{})
	if mgmr.MachineGroupID != nil {
		objectMap["machineGroupId"] = mgmr.MachineGroupID
	}
	if mgmr.FilterProcesses != nil {
		objectMap["filterProcesses"] = mgmr.FilterProcesses
	}
	if mgmr.StartTime != nil {
		objectMap["startTime"] = mgmr.StartTime
	}
	if mgmr.EndTime != nil {
		objectMap["endTime"] = mgmr.EndTime
	}
	if mgmr.Kind != "" {
		objectMap["kind"] = mgmr.Kind
	}
	return json.Marshal(objectMap)
}

// AsSingleMachineDependencyMapRequest is the BasicMapRequest implementation for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) AsSingleMachineDependencyMapRequest() (*SingleMachineDependencyMapRequest, bool) {
	return nil, false
}

// AsMultipleMachinesMapRequest is the BasicMapRequest implementation for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) AsMultipleMachinesMapRequest() (*MultipleMachinesMapRequest, bool) {
	return nil, false
}

// AsBasicMultipleMachinesMapRequest is the BasicMapRequest implementation for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) AsBasicMultipleMachinesMapRequest() (BasicMultipleMachinesMapRequest, bool) {
	return &mgmr, true
}

// AsMachineListMapRequest is the BasicMapRequest implementation for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) AsMachineListMapRequest() (*MachineListMapRequest, bool) {
	return nil, false
}

// AsMachineGroupMapRequest is the BasicMapRequest implementation for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) AsMachineGroupMapRequest() (*MachineGroupMapRequest, bool) {
	return &mgmr, true
}

// AsMapRequest is the BasicMapRequest implementation for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) AsMapRequest() (*MapRequest, bool) {
	return nil, false
}

// AsBasicMapRequest is the BasicMapRequest implementation for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) AsBasicMapRequest() (BasicMapRequest, bool) {
	return &mgmr, true
}

// MachineGroupProperties resource properties.
type MachineGroupProperties struct {
	// GroupType - Type of the machine group. Possible values include: 'MachineGroupTypeUnknown', 'MachineGroupTypeAzureCs', 'MachineGroupTypeAzureSf', 'MachineGroupTypeAzureVmss', 'MachineGroupTypeUserStatic'
	GroupType MachineGroupType `json:"groupType,omitempty"`
	// DisplayName - User defined name for the group
	DisplayName *string `json:"displayName,omitempty"`
	// Count - Count of machines in this group. The value of count may be bigger than the number of machines in case of the group has been truncated due to exceeding the max number of machines a group can handle.
	Count *int32 `json:"count,omitempty"`
	// Machines - References of the machines in this group. The hints within each reference do not represent the current value of the corresponding fields. They are a snapshot created during the last time the machine group was updated.
	Machines *[]MachineReferenceWithHints `json:"machines,omitempty"`
}

// MachineListMapRequest specifies the computation of a one hope dependency map for a list of machines. The
// resulting map includes all direct dependencies for the specified machines.
type MachineListMapRequest struct {
	// MachineIds - a list of URIs of machine resources for which to generate the map.
	MachineIds *[]string `json:"machineIds,omitempty"`
	// FilterProcesses - If true, only processes between specified machines will be included. Any connections in or out of those processes will be included.
	FilterProcesses *bool `json:"filterProcesses,omitempty"`
	// StartTime - Map interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Map interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Kind - Possible values include: 'KindMapRequest', 'KindMapsingleMachineDependency', 'KindMultipleMachinesMapRequest', 'KindMapmachineListDependency', 'KindMapmachineGroupDependency'
	Kind KindBasicMapRequest `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineListMapRequest.
func (mlmr MachineListMapRequest) MarshalJSON() ([]byte, error) {
	mlmr.Kind = KindMapmachineListDependency
	objectMap := make(map[string]interface{})
	if mlmr.MachineIds != nil {
		objectMap["machineIds"] = mlmr.MachineIds
	}
	if mlmr.FilterProcesses != nil {
		objectMap["filterProcesses"] = mlmr.FilterProcesses
	}
	if mlmr.StartTime != nil {
		objectMap["startTime"] = mlmr.StartTime
	}
	if mlmr.EndTime != nil {
		objectMap["endTime"] = mlmr.EndTime
	}
	if mlmr.Kind != "" {
		objectMap["kind"] = mlmr.Kind
	}
	return json.Marshal(objectMap)
}

// AsSingleMachineDependencyMapRequest is the BasicMapRequest implementation for MachineListMapRequest.
func (mlmr MachineListMapRequest) AsSingleMachineDependencyMapRequest() (*SingleMachineDependencyMapRequest, bool) {
	return nil, false
}

// AsMultipleMachinesMapRequest is the BasicMapRequest implementation for MachineListMapRequest.
func (mlmr MachineListMapRequest) AsMultipleMachinesMapRequest() (*MultipleMachinesMapRequest, bool) {
	return nil, false
}

// AsBasicMultipleMachinesMapRequest is the BasicMapRequest implementation for MachineListMapRequest.
func (mlmr MachineListMapRequest) AsBasicMultipleMachinesMapRequest() (BasicMultipleMachinesMapRequest, bool) {
	return &mlmr, true
}

// AsMachineListMapRequest is the BasicMapRequest implementation for MachineListMapRequest.
func (mlmr MachineListMapRequest) AsMachineListMapRequest() (*MachineListMapRequest, bool) {
	return &mlmr, true
}

// AsMachineGroupMapRequest is the BasicMapRequest implementation for MachineListMapRequest.
func (mlmr MachineListMapRequest) AsMachineGroupMapRequest() (*MachineGroupMapRequest, bool) {
	return nil, false
}

// AsMapRequest is the BasicMapRequest implementation for MachineListMapRequest.
func (mlmr MachineListMapRequest) AsMapRequest() (*MapRequest, bool) {
	return nil, false
}

// AsBasicMapRequest is the BasicMapRequest implementation for MachineListMapRequest.
func (mlmr MachineListMapRequest) AsBasicMapRequest() (BasicMapRequest, bool) {
	return &mlmr, true
}

// MachineProperties resource properties.
type MachineProperties struct {
	// Timestamp - UTC date and time when this resource was updated in the system.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// MonitoringState - Specifies whether the machine is actively monitored or discovered. Possible values include: 'Monitored', 'Discovered'
	MonitoringState MonitoringState `json:"monitoringState,omitempty"`
	// VirtualizationState - Specifies whether the machine is virtualized. Possible values include: 'VirtualizationStateUnknown', 'VirtualizationStatePhysical', 'VirtualizationStateVirtual', 'VirtualizationStateHypervisor'
	VirtualizationState VirtualizationState `json:"virtualizationState,omitempty"`
	// DisplayName - Name to use for display purposes
	DisplayName *string `json:"displayName,omitempty"`
	// ComputerName - Name of the machine, e.g., server
	ComputerName *string `json:"computerName,omitempty"`
	// FullyQualifiedDomainName - Fully-qualified name of the machine, e.g., server.company.com
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
	// BootTime - UTC date and time when the machine last booted
	BootTime *date.Time `json:"bootTime,omitempty"`
	// Timezone - Timezone of the machine.
	Timezone *Timezone `json:"timezone,omitempty"`
	// Agent - Dependency Agent configuration.
	Agent *AgentConfiguration `json:"agent,omitempty"`
	// Resources - Machine resources (memory, cpu, etc.).
	Resources *MachineResourcesConfiguration `json:"resources,omitempty"`
	// Networking - Network configuration (ips, gateways, dns, etc.)
	Networking *NetworkConfiguration `json:"networking,omitempty"`
	// OperatingSystem - Operating system information.
	OperatingSystem *OperatingSystemConfiguration `json:"operatingSystem,omitempty"`
	// VirtualMachine - Virtualization-related configuration. Present only when `virtualizationState` is `virtual`.
	VirtualMachine *VirtualMachineConfiguration `json:"virtualMachine,omitempty"`
	// Hypervisor - Hypervisor-related configuration. Present only when 'virtualizationState' is `hypervisor`.
	Hypervisor *HypervisorConfiguration `json:"hypervisor,omitempty"`
	// Hosting - Hosting-related configuration. Present if hosting information is discovered for the VM.
	Hosting BasicHostingConfiguration `json:"hosting,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for MachineProperties struct.
func (mVar *MachineProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "timestamp":
			if v != nil {
				var timestamp date.Time
				err = json.Unmarshal(*v, &timestamp)
				if err != nil {
					return err
				}
				mVar.Timestamp = &timestamp
			}
		case "monitoringState":
			if v != nil {
				var monitoringState MonitoringState
				err = json.Unmarshal(*v, &monitoringState)
				if err != nil {
					return err
				}
				mVar.MonitoringState = monitoringState
			}
		case "virtualizationState":
			if v != nil {
				var virtualizationState VirtualizationState
				err = json.Unmarshal(*v, &virtualizationState)
				if err != nil {
					return err
				}
				mVar.VirtualizationState = virtualizationState
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				mVar.DisplayName = &displayName
			}
		case "computerName":
			if v != nil {
				var computerName string
				err = json.Unmarshal(*v, &computerName)
				if err != nil {
					return err
				}
				mVar.ComputerName = &computerName
			}
		case "fullyQualifiedDomainName":
			if v != nil {
				var fullyQualifiedDomainName string
				err = json.Unmarshal(*v, &fullyQualifiedDomainName)
				if err != nil {
					return err
				}
				mVar.FullyQualifiedDomainName = &fullyQualifiedDomainName
			}
		case "bootTime":
			if v != nil {
				var bootTime date.Time
				err = json.Unmarshal(*v, &bootTime)
				if err != nil {
					return err
				}
				mVar.BootTime = &bootTime
			}
		case "timezone":
			if v != nil {
				var timezone Timezone
				err = json.Unmarshal(*v, &timezone)
				if err != nil {
					return err
				}
				mVar.Timezone = &timezone
			}
		case "agent":
			if v != nil {
				var agent AgentConfiguration
				err = json.Unmarshal(*v, &agent)
				if err != nil {
					return err
				}
				mVar.Agent = &agent
			}
		case "resources":
			if v != nil {
				var resources MachineResourcesConfiguration
				err = json.Unmarshal(*v, &resources)
				if err != nil {
					return err
				}
				mVar.Resources = &resources
			}
		case "networking":
			if v != nil {
				var networking NetworkConfiguration
				err = json.Unmarshal(*v, &networking)
				if err != nil {
					return err
				}
				mVar.Networking = &networking
			}
		case "operatingSystem":
			if v != nil {
				var operatingSystem OperatingSystemConfiguration
				err = json.Unmarshal(*v, &operatingSystem)
				if err != nil {
					return err
				}
				mVar.OperatingSystem = &operatingSystem
			}
		case "virtualMachine":
			if v != nil {
				var virtualMachine VirtualMachineConfiguration
				err = json.Unmarshal(*v, &virtualMachine)
				if err != nil {
					return err
				}
				mVar.VirtualMachine = &virtualMachine
			}
		case "hypervisor":
			if v != nil {
				var hypervisor HypervisorConfiguration
				err = json.Unmarshal(*v, &hypervisor)
				if err != nil {
					return err
				}
				mVar.Hypervisor = &hypervisor
			}
		case "hosting":
			if v != nil {
				hosting, err := unmarshalBasicHostingConfiguration(*v)
				if err != nil {
					return err
				}
				mVar.Hosting = hosting
			}
		}
	}

	return nil
}

// MachineReference reference to a machine.
type MachineReference struct {
	// ID - Resource URI.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type qualifier.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindResourceReference', 'KindRefmachine', 'KindRefprocess', 'KindRefport', 'KindRefmachinewithhints', 'KindRefclientgroup'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineReference.
func (mr MachineReference) MarshalJSON() ([]byte, error) {
	mr.Kind = KindRefmachine
	objectMap := make(map[string]interface{})
	if mr.ID != nil {
		objectMap["id"] = mr.ID
	}
	if mr.Kind != "" {
		objectMap["kind"] = mr.Kind
	}
	return json.Marshal(objectMap)
}

// AsMachineReference is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsMachineReference() (*MachineReference, bool) {
	return &mr, true
}

// AsProcessReference is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsProcessReference() (*ProcessReference, bool) {
	return nil, false
}

// AsPortReference is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsPortReference() (*PortReference, bool) {
	return nil, false
}

// AsMachineReferenceWithHints is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool) {
	return nil, false
}

// AsClientGroupReference is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsClientGroupReference() (*ClientGroupReference, bool) {
	return nil, false
}

// AsResourceReference is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsResourceReference() (*ResourceReference, bool) {
	return nil, false
}

// AsBasicResourceReference is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsBasicResourceReference() (BasicResourceReference, bool) {
	return &mr, true
}

// MachineReferenceWithHints a machine reference with a hint of the machine's name and operating system.
type MachineReferenceWithHints struct {
	// MachineReferenceWithHintsProperties - Machine reference with name and os hints.
	*MachineReferenceWithHintsProperties `json:"properties,omitempty"`
	// ID - Resource URI.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type qualifier.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindResourceReference', 'KindRefmachine', 'KindRefprocess', 'KindRefport', 'KindRefmachinewithhints', 'KindRefclientgroup'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) MarshalJSON() ([]byte, error) {
	mrwh.Kind = KindRefmachinewithhints
	objectMap := make(map[string]interface{})
	if mrwh.MachineReferenceWithHintsProperties != nil {
		objectMap["properties"] = mrwh.MachineReferenceWithHintsProperties
	}
	if mrwh.ID != nil {
		objectMap["id"] = mrwh.ID
	}
	if mrwh.Kind != "" {
		objectMap["kind"] = mrwh.Kind
	}
	return json.Marshal(objectMap)
}

// AsMachineReference is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsMachineReference() (*MachineReference, bool) {
	return nil, false
}

// AsProcessReference is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsProcessReference() (*ProcessReference, bool) {
	return nil, false
}

// AsPortReference is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsPortReference() (*PortReference, bool) {
	return nil, false
}

// AsMachineReferenceWithHints is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool) {
	return &mrwh, true
}

// AsClientGroupReference is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsClientGroupReference() (*ClientGroupReference, bool) {
	return nil, false
}

// AsResourceReference is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsResourceReference() (*ResourceReference, bool) {
	return nil, false
}

// AsBasicResourceReference is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsBasicResourceReference() (BasicResourceReference, bool) {
	return &mrwh, true
}

// UnmarshalJSON is the custom unmarshaler for MachineReferenceWithHints struct.
func (mrwh *MachineReferenceWithHints) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var machineReferenceWithHintsProperties MachineReferenceWithHintsProperties
				err = json.Unmarshal(*v, &machineReferenceWithHintsProperties)
				if err != nil {
					return err
				}
				mrwh.MachineReferenceWithHintsProperties = &machineReferenceWithHintsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mrwh.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mrwh.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mrwh.Name = &name
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mrwh.Kind = kind
			}
		}
	}

	return nil
}

// MachineReferenceWithHintsProperties machine reference with name and os hints.
type MachineReferenceWithHintsProperties struct {
	// DisplayNameHint - READ-ONLY; Last known display name.
	DisplayNameHint *string `json:"displayNameHint,omitempty"`
	// OsFamilyHint - READ-ONLY; Last known operating system family. Possible values include: 'OperatingSystemFamilyUnknown', 'OperatingSystemFamilyWindows', 'OperatingSystemFamilyLinux', 'OperatingSystemFamilySolaris', 'OperatingSystemFamilyAix'
	OsFamilyHint OperatingSystemFamily `json:"osFamilyHint,omitempty"`
}

// MachineResourcesConfiguration describes the resources of a machine.
type MachineResourcesConfiguration struct {
	// PhysicalMemory - Physical memory in megabytes (MB).
	PhysicalMemory *int32 `json:"physicalMemory,omitempty"`
	// Cpus - Number of CPUs.
	Cpus *int32 `json:"cpus,omitempty"`
	// CPUSpeed - CPU speed in megahertz (Mhz).
	CPUSpeed *int32 `json:"cpuSpeed,omitempty"`
	// CPUSpeedAccuracy - Describes the accuracy of the cpuSpeed field. Possible values include: 'Actual', 'Estimated'
	CPUSpeedAccuracy Accuracy `json:"cpuSpeedAccuracy,omitempty"`
}

// MachinesSummary a summary of the machines in the workspace.
type MachinesSummary struct {
	autorest.Response          `json:"-"`
	*MachinesSummaryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for MachinesSummary.
func (ms MachinesSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ms.MachinesSummaryProperties != nil {
		objectMap["properties"] = ms.MachinesSummaryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MachinesSummary struct.
func (ms *MachinesSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var machinesSummaryProperties MachinesSummaryProperties
				err = json.Unmarshal(*v, &machinesSummaryProperties)
				if err != nil {
					return err
				}
				ms.MachinesSummaryProperties = &machinesSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ms.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ms.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ms.Name = &name
			}
		}
	}

	return nil
}

// MachinesSummaryProperties summarizes machines in the workspace.
type MachinesSummaryProperties struct {
	// Total - Total number of machines.
	Total *int32 `json:"total,omitempty"`
	// Live - Number of live machines.
	Live *int32 `json:"live,omitempty"`
	// Os - Machine counts by operating system.
	Os *MachineCountsByOperatingSystem `json:"os,omitempty"`
	// StartTime - Summary interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Summary interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// Map a map of resources and relationships between them.
type Map struct {
	Nodes *MapNodes `json:"nodes,omitempty"`
	Edges *MapEdges `json:"edges,omitempty"`
}

// MapEdges the edges (relationships) of a map.
type MapEdges struct {
	// Connections - Network connections.
	Connections *[]Connection `json:"connections,omitempty"`
	// Acceptors - Processes accepting on a port.
	Acceptors *[]Acceptor `json:"acceptors,omitempty"`
}

// MapNodes the nodes (entities) of a map.
type MapNodes struct {
	// Machines - Machine resources.
	Machines *[]Machine `json:"machines,omitempty"`
	// Processes - Process resources.
	Processes *[]Process `json:"processes,omitempty"`
	// Ports - Port resources.
	Ports *[]Port `json:"ports,omitempty"`
	// ClientGroups - Client Group resources.
	ClientGroups *[]ClientGroup `json:"clientGroups,omitempty"`
}

// BasicMapRequest specifies the contents of request to generate a map.
type BasicMapRequest interface {
	AsSingleMachineDependencyMapRequest() (*SingleMachineDependencyMapRequest, bool)
	AsMultipleMachinesMapRequest() (*MultipleMachinesMapRequest, bool)
	AsBasicMultipleMachinesMapRequest() (BasicMultipleMachinesMapRequest, bool)
	AsMachineListMapRequest() (*MachineListMapRequest, bool)
	AsMachineGroupMapRequest() (*MachineGroupMapRequest, bool)
	AsMapRequest() (*MapRequest, bool)
}

// MapRequest specifies the contents of request to generate a map.
type MapRequest struct {
	// StartTime - Map interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Map interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Kind - Possible values include: 'KindMapRequest', 'KindMapsingleMachineDependency', 'KindMultipleMachinesMapRequest', 'KindMapmachineListDependency', 'KindMapmachineGroupDependency'
	Kind KindBasicMapRequest `json:"kind,omitempty"`
}

func unmarshalBasicMapRequest(body []byte) (BasicMapRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindMapsingleMachineDependency):
		var smdmr SingleMachineDependencyMapRequest
		err := json.Unmarshal(body, &smdmr)
		return smdmr, err
	case string(KindMultipleMachinesMapRequest):
		var mmmr MultipleMachinesMapRequest
		err := json.Unmarshal(body, &mmmr)
		return mmmr, err
	case string(KindMapmachineListDependency):
		var mlmr MachineListMapRequest
		err := json.Unmarshal(body, &mlmr)
		return mlmr, err
	case string(KindMapmachineGroupDependency):
		var mgmr MachineGroupMapRequest
		err := json.Unmarshal(body, &mgmr)
		return mgmr, err
	default:
		var mr MapRequest
		err := json.Unmarshal(body, &mr)
		return mr, err
	}
}
func unmarshalBasicMapRequestArray(body []byte) ([]BasicMapRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mrArray := make([]BasicMapRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mr, err := unmarshalBasicMapRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		mrArray[index] = mr
	}
	return mrArray, nil
}

// MarshalJSON is the custom marshaler for MapRequest.
func (mr MapRequest) MarshalJSON() ([]byte, error) {
	mr.Kind = KindMapRequest
	objectMap := make(map[string]interface{})
	if mr.StartTime != nil {
		objectMap["startTime"] = mr.StartTime
	}
	if mr.EndTime != nil {
		objectMap["endTime"] = mr.EndTime
	}
	if mr.Kind != "" {
		objectMap["kind"] = mr.Kind
	}
	return json.Marshal(objectMap)
}

// AsSingleMachineDependencyMapRequest is the BasicMapRequest implementation for MapRequest.
func (mr MapRequest) AsSingleMachineDependencyMapRequest() (*SingleMachineDependencyMapRequest, bool) {
	return nil, false
}

// AsMultipleMachinesMapRequest is the BasicMapRequest implementation for MapRequest.
func (mr MapRequest) AsMultipleMachinesMapRequest() (*MultipleMachinesMapRequest, bool) {
	return nil, false
}

// AsBasicMultipleMachinesMapRequest is the BasicMapRequest implementation for MapRequest.
func (mr MapRequest) AsBasicMultipleMachinesMapRequest() (BasicMultipleMachinesMapRequest, bool) {
	return nil, false
}

// AsMachineListMapRequest is the BasicMapRequest implementation for MapRequest.
func (mr MapRequest) AsMachineListMapRequest() (*MachineListMapRequest, bool) {
	return nil, false
}

// AsMachineGroupMapRequest is the BasicMapRequest implementation for MapRequest.
func (mr MapRequest) AsMachineGroupMapRequest() (*MachineGroupMapRequest, bool) {
	return nil, false
}

// AsMapRequest is the BasicMapRequest implementation for MapRequest.
func (mr MapRequest) AsMapRequest() (*MapRequest, bool) {
	return &mr, true
}

// AsBasicMapRequest is the BasicMapRequest implementation for MapRequest.
func (mr MapRequest) AsBasicMapRequest() (BasicMapRequest, bool) {
	return &mr, true
}

// MapResponse specified the contents of a map response.
type MapResponse struct {
	autorest.Response `json:"-"`
	// StartTime - Map interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Map interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Map - The generated map.
	Map *Map `json:"map,omitempty"`
}

// BasicMultipleMachinesMapRequest provides a base class for describing map requests for a collection of machines
type BasicMultipleMachinesMapRequest interface {
	AsMachineListMapRequest() (*MachineListMapRequest, bool)
	AsMachineGroupMapRequest() (*MachineGroupMapRequest, bool)
	AsMultipleMachinesMapRequest() (*MultipleMachinesMapRequest, bool)
}

// MultipleMachinesMapRequest provides a base class for describing map requests for a collection of machines
type MultipleMachinesMapRequest struct {
	// FilterProcesses - If true, only processes between specified machines will be included. Any connections in or out of those processes will be included.
	FilterProcesses *bool `json:"filterProcesses,omitempty"`
	// StartTime - Map interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Map interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Kind - Possible values include: 'KindMapRequest', 'KindMapsingleMachineDependency', 'KindMultipleMachinesMapRequest', 'KindMapmachineListDependency', 'KindMapmachineGroupDependency'
	Kind KindBasicMapRequest `json:"kind,omitempty"`
}

func unmarshalBasicMultipleMachinesMapRequest(body []byte) (BasicMultipleMachinesMapRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindMapmachineListDependency):
		var mlmr MachineListMapRequest
		err := json.Unmarshal(body, &mlmr)
		return mlmr, err
	case string(KindMapmachineGroupDependency):
		var mgmr MachineGroupMapRequest
		err := json.Unmarshal(body, &mgmr)
		return mgmr, err
	default:
		var mmmr MultipleMachinesMapRequest
		err := json.Unmarshal(body, &mmmr)
		return mmmr, err
	}
}
func unmarshalBasicMultipleMachinesMapRequestArray(body []byte) ([]BasicMultipleMachinesMapRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mmmrArray := make([]BasicMultipleMachinesMapRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mmmr, err := unmarshalBasicMultipleMachinesMapRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		mmmrArray[index] = mmmr
	}
	return mmmrArray, nil
}

// MarshalJSON is the custom marshaler for MultipleMachinesMapRequest.
func (mmmr MultipleMachinesMapRequest) MarshalJSON() ([]byte, error) {
	mmmr.Kind = KindMultipleMachinesMapRequest
	objectMap := make(map[string]interface{})
	if mmmr.FilterProcesses != nil {
		objectMap["filterProcesses"] = mmmr.FilterProcesses
	}
	if mmmr.StartTime != nil {
		objectMap["startTime"] = mmmr.StartTime
	}
	if mmmr.EndTime != nil {
		objectMap["endTime"] = mmmr.EndTime
	}
	if mmmr.Kind != "" {
		objectMap["kind"] = mmmr.Kind
	}
	return json.Marshal(objectMap)
}

// AsSingleMachineDependencyMapRequest is the BasicMapRequest implementation for MultipleMachinesMapRequest.
func (mmmr MultipleMachinesMapRequest) AsSingleMachineDependencyMapRequest() (*SingleMachineDependencyMapRequest, bool) {
	return nil, false
}

// AsMultipleMachinesMapRequest is the BasicMapRequest implementation for MultipleMachinesMapRequest.
func (mmmr MultipleMachinesMapRequest) AsMultipleMachinesMapRequest() (*MultipleMachinesMapRequest, bool) {
	return &mmmr, true
}

// AsBasicMultipleMachinesMapRequest is the BasicMapRequest implementation for MultipleMachinesMapRequest.
func (mmmr MultipleMachinesMapRequest) AsBasicMultipleMachinesMapRequest() (BasicMultipleMachinesMapRequest, bool) {
	return &mmmr, true
}

// AsMachineListMapRequest is the BasicMapRequest implementation for MultipleMachinesMapRequest.
func (mmmr MultipleMachinesMapRequest) AsMachineListMapRequest() (*MachineListMapRequest, bool) {
	return nil, false
}

// AsMachineGroupMapRequest is the BasicMapRequest implementation for MultipleMachinesMapRequest.
func (mmmr MultipleMachinesMapRequest) AsMachineGroupMapRequest() (*MachineGroupMapRequest, bool) {
	return nil, false
}

// AsMapRequest is the BasicMapRequest implementation for MultipleMachinesMapRequest.
func (mmmr MultipleMachinesMapRequest) AsMapRequest() (*MapRequest, bool) {
	return nil, false
}

// AsBasicMapRequest is the BasicMapRequest implementation for MultipleMachinesMapRequest.
func (mmmr MultipleMachinesMapRequest) AsBasicMapRequest() (BasicMapRequest, bool) {
	return &mmmr, true
}

// NetworkConfiguration describes the network configuration of a machine.
type NetworkConfiguration struct {
	// Ipv4Interfaces - IPv4 interfaces.
	Ipv4Interfaces *[]Ipv4NetworkInterface `json:"ipv4Interfaces,omitempty"`
	// Ipv6Interfaces - IPv6 interfaces.
	Ipv6Interfaces *[]Ipv6NetworkInterface `json:"ipv6Interfaces,omitempty"`
	// DefaultIpv4Gateways - Default IPv4 gateways.
	DefaultIpv4Gateways *[]string `json:"defaultIpv4Gateways,omitempty"`
	// MacAddresses - MAC addresses of all active network interfaces.
	MacAddresses *[]string `json:"macAddresses,omitempty"`
	// DNSNames - DNS names associated with the machine.
	DNSNames *[]string `json:"dnsNames,omitempty"`
}

// OperatingSystemConfiguration describes the configuration of the operating system of a machine.
type OperatingSystemConfiguration struct {
	// Family - Windows, Linux, etc. Possible values include: 'OperatingSystemFamilyUnknown', 'OperatingSystemFamilyWindows', 'OperatingSystemFamilyLinux', 'OperatingSystemFamilySolaris', 'OperatingSystemFamilyAix'
	Family OperatingSystemFamily `json:"family,omitempty"`
	// FullName - Operating system full name.
	FullName *string `json:"fullName,omitempty"`
	// Bitness - Operating system bitness (32-bit or 64-bit). Possible values include: 'ThreeTwobit', 'SixFourbit'
	Bitness Bitness `json:"bitness,omitempty"`
}

// Port a port resource represents a server port on a machine. The port may be actively *monitored*, i.e.,
// a Dependency Agent is running on its machine, or *discovered*, i.e., its existence was inferred by
// observing the data stream from monitored machines. A port is live during an interval of time, if that
// port had associated activity during (parts) of that interval.
type Port struct {
	autorest.Response `json:"-"`
	// PortProperties - Resource properties.
	*PortProperties `json:"properties,omitempty"`
	// Etag - Resource ETAG.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindCoreResource', 'KindMachine', 'KindProcess', 'KindPort', 'KindClientGroup', 'KindMachineGroup'
	Kind KindBasicCoreResource `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Port.
func (p Port) MarshalJSON() ([]byte, error) {
	p.Kind = KindPort
	objectMap := make(map[string]interface{})
	if p.PortProperties != nil {
		objectMap["properties"] = p.PortProperties
	}
	if p.Etag != nil {
		objectMap["etag"] = p.Etag
	}
	if p.Kind != "" {
		objectMap["kind"] = p.Kind
	}
	return json.Marshal(objectMap)
}

// AsMachine is the BasicCoreResource implementation for Port.
func (p Port) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicCoreResource implementation for Port.
func (p Port) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicCoreResource implementation for Port.
func (p Port) AsPort() (*Port, bool) {
	return &p, true
}

// AsClientGroup is the BasicCoreResource implementation for Port.
func (p Port) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsMachineGroup is the BasicCoreResource implementation for Port.
func (p Port) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsCoreResource is the BasicCoreResource implementation for Port.
func (p Port) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicCoreResource implementation for Port.
func (p Port) AsBasicCoreResource() (BasicCoreResource, bool) {
	return &p, true
}

// UnmarshalJSON is the custom unmarshaler for Port struct.
func (p *Port) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var portProperties PortProperties
				err = json.Unmarshal(*v, &portProperties)
				if err != nil {
					return err
				}
				p.PortProperties = &portProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				p.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicCoreResource
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				p.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		}
	}

	return nil
}

// PortCollection collection of Port resources.
type PortCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Port resources.
	Value *[]Port `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// PortCollectionIterator provides access to a complete listing of Port values.
type PortCollectionIterator struct {
	i    int
	page PortCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PortCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PortCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PortCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PortCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PortCollectionIterator) Response() PortCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PortCollectionIterator) Value() Port {
	if !iter.page.NotDone() {
		return Port{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PortCollectionIterator type.
func NewPortCollectionIterator(page PortCollectionPage) PortCollectionIterator {
	return PortCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pc PortCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// portCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc PortCollection) portCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if pc.NextLink == nil || len(to.String(pc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// PortCollectionPage contains a page of Port values.
type PortCollectionPage struct {
	fn func(context.Context, PortCollection) (PortCollection, error)
	pc PortCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PortCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PortCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pc)
	if err != nil {
		return err
	}
	page.pc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PortCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PortCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PortCollectionPage) Response() PortCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PortCollectionPage) Values() []Port {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// Creates a new instance of the PortCollectionPage type.
func NewPortCollectionPage(getNextPage func(context.Context, PortCollection) (PortCollection, error)) PortCollectionPage {
	return PortCollectionPage{fn: getNextPage}
}

// PortProperties resource properties.
type PortProperties struct {
	// MonitoringState - Specifies whether the port is actively monitored or discovered. Possible values include: 'Monitored', 'Discovered'
	MonitoringState MonitoringState `json:"monitoringState,omitempty"`
	// Machine - Machine hosting this port.
	Machine BasicResourceReference `json:"machine,omitempty"`
	// DisplayName - Name to use for display purposes.
	DisplayName *string `json:"displayName,omitempty"`
	// IPAddress - IP address associated with the port. At present only IPv4 addresses are supported.
	IPAddress *string `json:"ipAddress,omitempty"`
	// PortNumber - Port number.
	PortNumber *int32 `json:"portNumber,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PortProperties struct.
func (p *PortProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "monitoringState":
			if v != nil {
				var monitoringState MonitoringState
				err = json.Unmarshal(*v, &monitoringState)
				if err != nil {
					return err
				}
				p.MonitoringState = monitoringState
			}
		case "machine":
			if v != nil {
				machine, err := unmarshalBasicResourceReference(*v)
				if err != nil {
					return err
				}
				p.Machine = machine
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				p.DisplayName = &displayName
			}
		case "ipAddress":
			if v != nil {
				var IPAddress string
				err = json.Unmarshal(*v, &IPAddress)
				if err != nil {
					return err
				}
				p.IPAddress = &IPAddress
			}
		case "portNumber":
			if v != nil {
				var portNumber int32
				err = json.Unmarshal(*v, &portNumber)
				if err != nil {
					return err
				}
				p.PortNumber = &portNumber
			}
		}
	}

	return nil
}

// PortReference reference to a port.
type PortReference struct {
	// PortReferenceProperties - Resource properties.
	*PortReferenceProperties `json:"properties,omitempty"`
	// ID - Resource URI.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type qualifier.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindResourceReference', 'KindRefmachine', 'KindRefprocess', 'KindRefport', 'KindRefmachinewithhints', 'KindRefclientgroup'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for PortReference.
func (pr PortReference) MarshalJSON() ([]byte, error) {
	pr.Kind = KindRefport
	objectMap := make(map[string]interface{})
	if pr.PortReferenceProperties != nil {
		objectMap["properties"] = pr.PortReferenceProperties
	}
	if pr.ID != nil {
		objectMap["id"] = pr.ID
	}
	if pr.Kind != "" {
		objectMap["kind"] = pr.Kind
	}
	return json.Marshal(objectMap)
}

// AsMachineReference is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsMachineReference() (*MachineReference, bool) {
	return nil, false
}

// AsProcessReference is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsProcessReference() (*ProcessReference, bool) {
	return nil, false
}

// AsPortReference is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsPortReference() (*PortReference, bool) {
	return &pr, true
}

// AsMachineReferenceWithHints is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool) {
	return nil, false
}

// AsClientGroupReference is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsClientGroupReference() (*ClientGroupReference, bool) {
	return nil, false
}

// AsResourceReference is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsResourceReference() (*ResourceReference, bool) {
	return nil, false
}

// AsBasicResourceReference is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsBasicResourceReference() (BasicResourceReference, bool) {
	return &pr, true
}

// UnmarshalJSON is the custom unmarshaler for PortReference struct.
func (pr *PortReference) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var portReferenceProperties PortReferenceProperties
				err = json.Unmarshal(*v, &portReferenceProperties)
				if err != nil {
					return err
				}
				pr.PortReferenceProperties = &portReferenceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pr.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pr.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pr.Kind = kind
			}
		}
	}

	return nil
}

// PortReferenceProperties resource properties.
type PortReferenceProperties struct {
	// Machine - READ-ONLY; Machine hosting the port.
	Machine *MachineReference `json:"machine,omitempty"`
	// IPAddress - READ-ONLY; IP address of the port.
	IPAddress *string `json:"ipAddress,omitempty"`
	// PortNumber - Port number.
	PortNumber *int32 `json:"portNumber,omitempty"`
}

// Process a process resource represents a process running on a machine. The process may be actively
// *monitored*, i.e., a Dependency Agent is running on its machine, or *discovered*, i.e., its existence
// was inferred by observing the data stream from monitored machines. A process resource represents a pool
// of actual operating system resources that share command lines and metadata. As the process pool evolves
// over time, prior versions of the process resource are preserved and available for access. A process is
// live during an interval of time, if that process is executing during (parts) of that interval
type Process struct {
	autorest.Response `json:"-"`
	// ProcessProperties - Resource properties.
	*ProcessProperties `json:"properties,omitempty"`
	// Etag - Resource ETAG.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindCoreResource', 'KindMachine', 'KindProcess', 'KindPort', 'KindClientGroup', 'KindMachineGroup'
	Kind KindBasicCoreResource `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Process.
func (p Process) MarshalJSON() ([]byte, error) {
	p.Kind = KindProcess
	objectMap := make(map[string]interface{})
	if p.ProcessProperties != nil {
		objectMap["properties"] = p.ProcessProperties
	}
	if p.Etag != nil {
		objectMap["etag"] = p.Etag
	}
	if p.Kind != "" {
		objectMap["kind"] = p.Kind
	}
	return json.Marshal(objectMap)
}

// AsMachine is the BasicCoreResource implementation for Process.
func (p Process) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicCoreResource implementation for Process.
func (p Process) AsProcess() (*Process, bool) {
	return &p, true
}

// AsPort is the BasicCoreResource implementation for Process.
func (p Process) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicCoreResource implementation for Process.
func (p Process) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsMachineGroup is the BasicCoreResource implementation for Process.
func (p Process) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsCoreResource is the BasicCoreResource implementation for Process.
func (p Process) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicCoreResource implementation for Process.
func (p Process) AsBasicCoreResource() (BasicCoreResource, bool) {
	return &p, true
}

// UnmarshalJSON is the custom unmarshaler for Process struct.
func (p *Process) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var processProperties ProcessProperties
				err = json.Unmarshal(*v, &processProperties)
				if err != nil {
					return err
				}
				p.ProcessProperties = &processProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				p.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicCoreResource
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				p.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		}
	}

	return nil
}

// ProcessCollection collection of Process resources.
type ProcessCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Process resources.
	Value *[]Process `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProcessCollectionIterator provides access to a complete listing of Process values.
type ProcessCollectionIterator struct {
	i    int
	page ProcessCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProcessCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProcessCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProcessCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProcessCollectionIterator) Response() ProcessCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProcessCollectionIterator) Value() Process {
	if !iter.page.NotDone() {
		return Process{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProcessCollectionIterator type.
func NewProcessCollectionIterator(page ProcessCollectionPage) ProcessCollectionIterator {
	return ProcessCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pc ProcessCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// processCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc ProcessCollection) processCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if pc.NextLink == nil || len(to.String(pc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// ProcessCollectionPage contains a page of Process values.
type ProcessCollectionPage struct {
	fn func(context.Context, ProcessCollection) (ProcessCollection, error)
	pc ProcessCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProcessCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pc)
	if err != nil {
		return err
	}
	page.pc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProcessCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProcessCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProcessCollectionPage) Response() ProcessCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProcessCollectionPage) Values() []Process {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// Creates a new instance of the ProcessCollectionPage type.
func NewProcessCollectionPage(getNextPage func(context.Context, ProcessCollection) (ProcessCollection, error)) ProcessCollectionPage {
	return ProcessCollectionPage{fn: getNextPage}
}

// ProcessDetails describes process metadata.
type ProcessDetails struct {
	// PersistentKey - A unique identifier for a process, generally resilient to process restart, computed by Service Map.
	PersistentKey *string `json:"persistentKey,omitempty"`
	// PoolID - Represents the identity of the process pool assigned to the process by Dependency Agent.
	PoolID *int32 `json:"poolId,omitempty"`
	// FirstPid - The Operating System Process Identifier (PID) of the first process in this process pool.
	FirstPid *int32 `json:"firstPid,omitempty"`
	// Description - Process description.
	Description *string `json:"description,omitempty"`
	// CompanyName - Name of company that created the process executable.
	CompanyName *string `json:"companyName,omitempty"`
	// InternalName - Internal process name.
	InternalName *string `json:"internalName,omitempty"`
	// ProductName - Product name.
	ProductName *string `json:"productName,omitempty"`
	// ProductVersion - Product version.
	ProductVersion *string `json:"productVersion,omitempty"`
	// FileVersion - File version.
	FileVersion *string `json:"fileVersion,omitempty"`
	// CommandLine - Process command line.
	CommandLine *string `json:"commandLine,omitempty"`
	// ExecutablePath - Process executable path.
	ExecutablePath *string `json:"executablePath,omitempty"`
	// WorkingDirectory - Process workingDirectory.
	WorkingDirectory *string `json:"workingDirectory,omitempty"`
	// Services - Collection of services hosted by this Process (Windows only).
	Services *[]ProcessHostedService `json:"services,omitempty"`
	// ZoneName - Process zone name (Linux only).
	ZoneName *string `json:"zoneName,omitempty"`
}

// ProcessHostedService a service hosted by a process.
type ProcessHostedService struct {
	// Name - The name of the service.
	Name *string `json:"name,omitempty"`
	// DisplayName - The service's display name.
	DisplayName *string `json:"displayName,omitempty"`
}

// BasicProcessHostingConfiguration describes the hosting configuration of a process.
type BasicProcessHostingConfiguration interface {
	AsAzureProcessHostingConfiguration() (*AzureProcessHostingConfiguration, bool)
	AsProcessHostingConfiguration() (*ProcessHostingConfiguration, bool)
}

// ProcessHostingConfiguration describes the hosting configuration of a process.
type ProcessHostingConfiguration struct {
	// Provider - The hosting provider of the VM. Possible values include: 'Provider1Azure'
	Provider Provider1 `json:"provider,omitempty"`
	// Kind - Possible values include: 'KindBasicProcessHostingConfigurationKindProcessHostingConfiguration', 'KindBasicProcessHostingConfigurationKindProviderazure'
	Kind KindBasicProcessHostingConfiguration `json:"kind,omitempty"`
}

func unmarshalBasicProcessHostingConfiguration(body []byte) (BasicProcessHostingConfiguration, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicProcessHostingConfigurationKindProviderazure):
		var aphc AzureProcessHostingConfiguration
		err := json.Unmarshal(body, &aphc)
		return aphc, err
	default:
		var phc ProcessHostingConfiguration
		err := json.Unmarshal(body, &phc)
		return phc, err
	}
}
func unmarshalBasicProcessHostingConfigurationArray(body []byte) ([]BasicProcessHostingConfiguration, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	phcArray := make([]BasicProcessHostingConfiguration, len(rawMessages))

	for index, rawMessage := range rawMessages {
		phc, err := unmarshalBasicProcessHostingConfiguration(*rawMessage)
		if err != nil {
			return nil, err
		}
		phcArray[index] = phc
	}
	return phcArray, nil
}

// MarshalJSON is the custom marshaler for ProcessHostingConfiguration.
func (phc ProcessHostingConfiguration) MarshalJSON() ([]byte, error) {
	phc.Kind = KindBasicProcessHostingConfigurationKindProcessHostingConfiguration
	objectMap := make(map[string]interface{})
	if phc.Provider != "" {
		objectMap["provider"] = phc.Provider
	}
	if phc.Kind != "" {
		objectMap["kind"] = phc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAzureProcessHostingConfiguration is the BasicProcessHostingConfiguration implementation for ProcessHostingConfiguration.
func (phc ProcessHostingConfiguration) AsAzureProcessHostingConfiguration() (*AzureProcessHostingConfiguration, bool) {
	return nil, false
}

// AsProcessHostingConfiguration is the BasicProcessHostingConfiguration implementation for ProcessHostingConfiguration.
func (phc ProcessHostingConfiguration) AsProcessHostingConfiguration() (*ProcessHostingConfiguration, bool) {
	return &phc, true
}

// AsBasicProcessHostingConfiguration is the BasicProcessHostingConfiguration implementation for ProcessHostingConfiguration.
func (phc ProcessHostingConfiguration) AsBasicProcessHostingConfiguration() (BasicProcessHostingConfiguration, bool) {
	return &phc, true
}

// ProcessProperties resource properties.
type ProcessProperties struct {
	// Timestamp - UTC date and time when this process resource was updated in the system
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// MonitoringState - Specifies whether the process is actively monitored or discovered. Possible values include: 'Monitored', 'Discovered'
	MonitoringState MonitoringState `json:"monitoringState,omitempty"`
	// Machine - Machine hosting this process.
	Machine BasicResourceReference `json:"machine,omitempty"`
	// ExecutableName - The name of the process executable
	ExecutableName *string `json:"executableName,omitempty"`
	// DisplayName - Name to use for display purposes
	DisplayName *string `json:"displayName,omitempty"`
	// StartTime - UTC date and time when the process started
	StartTime *date.Time `json:"startTime,omitempty"`
	// Role - The inferred role of this process based on its name, command line, etc. Possible values include: 'WebServer', 'AppServer', 'DatabaseServer', 'LdapServer', 'SmbServer'
	Role ProcessRole `json:"role,omitempty"`
	// Group - The name of the product or suite of the process. The group is determined by its executable name, command line, etc.
	Group *string `json:"group,omitempty"`
	// Details - Process metadata (command line, product name, etc.).
	Details *ProcessDetails `json:"details,omitempty"`
	// User - Information about the account under which the process is executing.
	User *ProcessUser `json:"user,omitempty"`
	// ClientOf - Present only for a discovered process acting as a client of a monitored process/machine/port. References the monitored process/machine/port that this process is a client of.
	ClientOf BasicResourceReference `json:"clientOf,omitempty"`
	// AcceptorOf - Present only for a discovered process acting as a server. References the port on which the discovered process is accepting.
	AcceptorOf BasicResourceReference `json:"acceptorOf,omitempty"`
	// Hosting - Information about the hosting environment
	Hosting BasicProcessHostingConfiguration `json:"hosting,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ProcessProperties struct.
func (p *ProcessProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "timestamp":
			if v != nil {
				var timestamp date.Time
				err = json.Unmarshal(*v, &timestamp)
				if err != nil {
					return err
				}
				p.Timestamp = &timestamp
			}
		case "monitoringState":
			if v != nil {
				var monitoringState MonitoringState
				err = json.Unmarshal(*v, &monitoringState)
				if err != nil {
					return err
				}
				p.MonitoringState = monitoringState
			}
		case "machine":
			if v != nil {
				machine, err := unmarshalBasicResourceReference(*v)
				if err != nil {
					return err
				}
				p.Machine = machine
			}
		case "executableName":
			if v != nil {
				var executableName string
				err = json.Unmarshal(*v, &executableName)
				if err != nil {
					return err
				}
				p.ExecutableName = &executableName
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				p.DisplayName = &displayName
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				p.StartTime = &startTime
			}
		case "role":
			if v != nil {
				var role ProcessRole
				err = json.Unmarshal(*v, &role)
				if err != nil {
					return err
				}
				p.Role = role
			}
		case "group":
			if v != nil {
				var group string
				err = json.Unmarshal(*v, &group)
				if err != nil {
					return err
				}
				p.Group = &group
			}
		case "details":
			if v != nil {
				var details ProcessDetails
				err = json.Unmarshal(*v, &details)
				if err != nil {
					return err
				}
				p.Details = &details
			}
		case "user":
			if v != nil {
				var userVar ProcessUser
				err = json.Unmarshal(*v, &userVar)
				if err != nil {
					return err
				}
				p.User = &userVar
			}
		case "clientOf":
			if v != nil {
				clientOf, err := unmarshalBasicResourceReference(*v)
				if err != nil {
					return err
				}
				p.ClientOf = clientOf
			}
		case "acceptorOf":
			if v != nil {
				acceptorOf, err := unmarshalBasicResourceReference(*v)
				if err != nil {
					return err
				}
				p.AcceptorOf = acceptorOf
			}
		case "hosting":
			if v != nil {
				hosting, err := unmarshalBasicProcessHostingConfiguration(*v)
				if err != nil {
					return err
				}
				p.Hosting = hosting
			}
		}
	}

	return nil
}

// ProcessReference reference to a process.
type ProcessReference struct {
	// ProcessReferenceProperties - Resource properties.
	*ProcessReferenceProperties `json:"properties,omitempty"`
	// ID - Resource URI.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type qualifier.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindResourceReference', 'KindRefmachine', 'KindRefprocess', 'KindRefport', 'KindRefmachinewithhints', 'KindRefclientgroup'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessReference.
func (pr ProcessReference) MarshalJSON() ([]byte, error) {
	pr.Kind = KindRefprocess
	objectMap := make(map[string]interface{})
	if pr.ProcessReferenceProperties != nil {
		objectMap["properties"] = pr.ProcessReferenceProperties
	}
	if pr.ID != nil {
		objectMap["id"] = pr.ID
	}
	if pr.Kind != "" {
		objectMap["kind"] = pr.Kind
	}
	return json.Marshal(objectMap)
}

// AsMachineReference is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsMachineReference() (*MachineReference, bool) {
	return nil, false
}

// AsProcessReference is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsProcessReference() (*ProcessReference, bool) {
	return &pr, true
}

// AsPortReference is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsPortReference() (*PortReference, bool) {
	return nil, false
}

// AsMachineReferenceWithHints is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool) {
	return nil, false
}

// AsClientGroupReference is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsClientGroupReference() (*ClientGroupReference, bool) {
	return nil, false
}

// AsResourceReference is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsResourceReference() (*ResourceReference, bool) {
	return nil, false
}

// AsBasicResourceReference is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsBasicResourceReference() (BasicResourceReference, bool) {
	return &pr, true
}

// UnmarshalJSON is the custom unmarshaler for ProcessReference struct.
func (pr *ProcessReference) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var processReferenceProperties ProcessReferenceProperties
				err = json.Unmarshal(*v, &processReferenceProperties)
				if err != nil {
					return err
				}
				pr.ProcessReferenceProperties = &processReferenceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pr.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pr.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pr.Kind = kind
			}
		}
	}

	return nil
}

// ProcessReferenceProperties resource properties.
type ProcessReferenceProperties struct {
	// Machine - READ-ONLY; Machine hosting the process.
	Machine *MachineReference `json:"machine,omitempty"`
}

// ProcessUser describes the user under which a process is running.
type ProcessUser struct {
	// UserName - User name under which the process is running.
	UserName *string `json:"userName,omitempty"`
	// UserDomain - Domain name for the user.
	UserDomain *string `json:"userDomain,omitempty"`
}

// BasicRelationship a typed relationship between two entities.
type BasicRelationship interface {
	AsConnection() (*Connection, bool)
	AsAcceptor() (*Acceptor, bool)
	AsRelationship() (*Relationship, bool)
}

// Relationship a typed relationship between two entities.
type Relationship struct {
	// Kind - Possible values include: 'KindRelationship', 'KindRelconnection', 'KindRelacceptor'
	Kind KindBasicRelationship `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
}

func unmarshalBasicRelationship(body []byte) (BasicRelationship, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindRelconnection):
		var c Connection
		err := json.Unmarshal(body, &c)
		return c, err
	case string(KindRelacceptor):
		var a Acceptor
		err := json.Unmarshal(body, &a)
		return a, err
	default:
		var r Relationship
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicRelationshipArray(body []byte) ([]BasicRelationship, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicRelationship, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicRelationship(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Relationship.
func (r Relationship) MarshalJSON() ([]byte, error) {
	r.Kind = KindRelationship
	objectMap := make(map[string]interface{})
	if r.Kind != "" {
		objectMap["kind"] = r.Kind
	}
	return json.Marshal(objectMap)
}

// AsConnection is the BasicRelationship implementation for Relationship.
func (r Relationship) AsConnection() (*Connection, bool) {
	return nil, false
}

// AsAcceptor is the BasicRelationship implementation for Relationship.
func (r Relationship) AsAcceptor() (*Acceptor, bool) {
	return nil, false
}

// AsRelationship is the BasicRelationship implementation for Relationship.
func (r Relationship) AsRelationship() (*Relationship, bool) {
	return &r, true
}

// AsBasicRelationship is the BasicRelationship implementation for Relationship.
func (r Relationship) AsBasicRelationship() (BasicRelationship, bool) {
	return &r, true
}

// RelationshipProperties relationship properties.
type RelationshipProperties struct {
	// Source - Source resource of the relationship.
	Source BasicResourceReference `json:"source,omitempty"`
	// Destination - Destination resource of the relationship.
	Destination BasicResourceReference `json:"destination,omitempty"`
	// StartTime - Relationship start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Relationship end time.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RelationshipProperties struct.
func (rp *RelationshipProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "source":
			if v != nil {
				source, err := unmarshalBasicResourceReference(*v)
				if err != nil {
					return err
				}
				rp.Source = source
			}
		case "destination":
			if v != nil {
				destination, err := unmarshalBasicResourceReference(*v)
				if err != nil {
					return err
				}
				rp.Destination = destination
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				rp.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				rp.EndTime = &endTime
			}
		}
	}

	return nil
}

// Resource resource model definition.
type Resource struct {
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
}

// BasicResourceReference represents a reference to another resource.
type BasicResourceReference interface {
	AsMachineReference() (*MachineReference, bool)
	AsProcessReference() (*ProcessReference, bool)
	AsPortReference() (*PortReference, bool)
	AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool)
	AsClientGroupReference() (*ClientGroupReference, bool)
	AsResourceReference() (*ResourceReference, bool)
}

// ResourceReference represents a reference to another resource.
type ResourceReference struct {
	// ID - Resource URI.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type qualifier.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindResourceReference', 'KindRefmachine', 'KindRefprocess', 'KindRefport', 'KindRefmachinewithhints', 'KindRefclientgroup'
	Kind Kind `json:"kind,omitempty"`
}

func unmarshalBasicResourceReference(body []byte) (BasicResourceReference, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindRefmachine):
		var mr MachineReference
		err := json.Unmarshal(body, &mr)
		return mr, err
	case string(KindRefprocess):
		var pr ProcessReference
		err := json.Unmarshal(body, &pr)
		return pr, err
	case string(KindRefport):
		var pr PortReference
		err := json.Unmarshal(body, &pr)
		return pr, err
	case string(KindRefmachinewithhints):
		var mrwh MachineReferenceWithHints
		err := json.Unmarshal(body, &mrwh)
		return mrwh, err
	case string(KindRefclientgroup):
		var cgr ClientGroupReference
		err := json.Unmarshal(body, &cgr)
		return cgr, err
	default:
		var rr ResourceReference
		err := json.Unmarshal(body, &rr)
		return rr, err
	}
}
func unmarshalBasicResourceReferenceArray(body []byte) ([]BasicResourceReference, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rrArray := make([]BasicResourceReference, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rr, err := unmarshalBasicResourceReference(*rawMessage)
		if err != nil {
			return nil, err
		}
		rrArray[index] = rr
	}
	return rrArray, nil
}

// MarshalJSON is the custom marshaler for ResourceReference.
func (rr ResourceReference) MarshalJSON() ([]byte, error) {
	rr.Kind = KindResourceReference
	objectMap := make(map[string]interface{})
	if rr.ID != nil {
		objectMap["id"] = rr.ID
	}
	if rr.Kind != "" {
		objectMap["kind"] = rr.Kind
	}
	return json.Marshal(objectMap)
}

// AsMachineReference is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsMachineReference() (*MachineReference, bool) {
	return nil, false
}

// AsProcessReference is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsProcessReference() (*ProcessReference, bool) {
	return nil, false
}

// AsPortReference is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsPortReference() (*PortReference, bool) {
	return nil, false
}

// AsMachineReferenceWithHints is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool) {
	return nil, false
}

// AsClientGroupReference is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsClientGroupReference() (*ClientGroupReference, bool) {
	return nil, false
}

// AsResourceReference is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsResourceReference() (*ResourceReference, bool) {
	return &rr, true
}

// AsBasicResourceReference is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsBasicResourceReference() (BasicResourceReference, bool) {
	return &rr, true
}

// SingleMachineDependencyMapRequest specifies the computation of a single server dependency map. A single
// server dependency map includes all direct dependencies of a given machine.
type SingleMachineDependencyMapRequest struct {
	// MachineID - URI of machine resource for which to generate the map.
	MachineID *string `json:"machineId,omitempty"`
	// StartTime - Map interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Map interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Kind - Possible values include: 'KindMapRequest', 'KindMapsingleMachineDependency', 'KindMultipleMachinesMapRequest', 'KindMapmachineListDependency', 'KindMapmachineGroupDependency'
	Kind KindBasicMapRequest `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) MarshalJSON() ([]byte, error) {
	smdmr.Kind = KindMapsingleMachineDependency
	objectMap := make(map[string]interface{})
	if smdmr.MachineID != nil {
		objectMap["machineId"] = smdmr.MachineID
	}
	if smdmr.StartTime != nil {
		objectMap["startTime"] = smdmr.StartTime
	}
	if smdmr.EndTime != nil {
		objectMap["endTime"] = smdmr.EndTime
	}
	if smdmr.Kind != "" {
		objectMap["kind"] = smdmr.Kind
	}
	return json.Marshal(objectMap)
}

// AsSingleMachineDependencyMapRequest is the BasicMapRequest implementation for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) AsSingleMachineDependencyMapRequest() (*SingleMachineDependencyMapRequest, bool) {
	return &smdmr, true
}

// AsMultipleMachinesMapRequest is the BasicMapRequest implementation for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) AsMultipleMachinesMapRequest() (*MultipleMachinesMapRequest, bool) {
	return nil, false
}

// AsBasicMultipleMachinesMapRequest is the BasicMapRequest implementation for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) AsBasicMultipleMachinesMapRequest() (BasicMultipleMachinesMapRequest, bool) {
	return nil, false
}

// AsMachineListMapRequest is the BasicMapRequest implementation for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) AsMachineListMapRequest() (*MachineListMapRequest, bool) {
	return nil, false
}

// AsMachineGroupMapRequest is the BasicMapRequest implementation for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) AsMachineGroupMapRequest() (*MachineGroupMapRequest, bool) {
	return nil, false
}

// AsMapRequest is the BasicMapRequest implementation for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) AsMapRequest() (*MapRequest, bool) {
	return nil, false
}

// AsBasicMapRequest is the BasicMapRequest implementation for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) AsBasicMapRequest() (BasicMapRequest, bool) {
	return &smdmr, true
}

// Summary base for all resource summaries.
type Summary struct {
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
}

// SummaryProperties base for all summaries.
type SummaryProperties struct {
	// StartTime - Summary interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Summary interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// Timezone describes a timezone.
type Timezone struct {
	// FullName - Timezone full name.
	FullName *string `json:"fullName,omitempty"`
}

// VirtualMachineConfiguration describes the virtualization-related configuration of a machine.
type VirtualMachineConfiguration struct {
	// VirtualMachineType - Specifies the virtualization technology used by the machine (hyperv, vmware, etc.). Possible values include: 'VirtualMachineTypeUnknown', 'VirtualMachineTypeHyperv', 'VirtualMachineTypeLdom', 'VirtualMachineTypeLpar', 'VirtualMachineTypeVmware', 'VirtualMachineTypeVirtualPc', 'VirtualMachineTypeXen'
	VirtualMachineType VirtualMachineType `json:"virtualMachineType,omitempty"`
	// NativeMachineID - The unique identifier of the virtual machine as reported by the underlying virtualization system.
	NativeMachineID *string `json:"nativeMachineId,omitempty"`
	// VirtualMachineName - The Name of the virtual machine.
	VirtualMachineName *string `json:"virtualMachineName,omitempty"`
	// NativeHostMachineID - The unique identifier of the host of this virtual machine as reported by the underlying virtualization system.
	NativeHostMachineID *string `json:"nativeHostMachineId,omitempty"`
}
