documentation_complete: true

title: 'Example Server Profile'

description: 'This profile is an example of a customized server profile.'

selections:
    - accounts_password_minlen_login_defs
    - var_accounts_password_minlen_login_defs=14
    - accounts_minimum_age_login_defs
    - var_accounts_minimum_age_login_defs=1
    - accounts_maximum_age_login_defs
    - var_accounts_maximum_age_login_defs=180
    - cracklib_accounts_password_pam_dcredit
    - cracklib_accounts_password_pam_ucredit
    - cracklib_accounts_password_pam_ocredit
    - cracklib_accounts_password_pam_lcredit
    - cracklib_accounts_password_pam_difok
    - accounts_password_pam_unix_remember
    - var_password_pam_unix_remember=10
    - accounts_password_warn_age_login_defs
    - account_disable_post_pw_expiration
    - accounts_passwords_pam_faillock_deny
    - cracklib_accounts_password_pam_retry
    - accounts_max_concurrent_login_sessions
    - var_accounts_max_concurrent_login_sessions=3
    - partition_for_tmp
    - partition_for_var
    - partition_for_var_log
    - partition_for_var_log_audit
    - partition_for_home
    - ensure_redhat_gpgkey_installed
    - ensure_gpgcheck_globally_activated
    - ensure_gpgcheck_never_disabled
    - rpm_verify_hashes
    - rpm_verify_permissions
    - package_aide_installed
    - aide_build_database
    - mount_option_nodev_removable_partitions
    - mount_option_noexec_removable_partitions
    - mount_option_nosuid_removable_partitions
    - mount_option_tmp_nodev
    - mount_option_tmp_noexec
    - mount_option_tmp_nosuid
    - mount_option_dev_shm_nodev
    - mount_option_dev_shm_noexec
    - mount_option_dev_shm_nosuid
    - mount_option_var_tmp_bind
    - kernel_module_usb-storage_disabled
    - grub_legacy_nousb_argument
    - kernel_module_cramfs_disabled
    - kernel_module_freevxfs_disabled
    - kernel_module_jffs2_disabled
    - kernel_module_hfs_disabled
    - kernel_module_hfsplus_disabled
    - kernel_module_squashfs_disabled
    - kernel_module_udf_disabled
    - dir_perms_world_writable_sticky_bits
    - file_permissions_unauthorized_world_writable
    - no_files_unowned_by_user
    - file_permissions_ungroupowned
    - dir_perms_world_writable_system_owned
    - umask_for_daemons
    - var_umask_for_daemons=027
    - disable_users_coredumps
    - sysctl_kernel_randomize_va_space
    - sysctl_kernel_exec_shield
    - install_PAE_kernel_on_x86-32
    - disable_prelink
    - account_unique_name
    - accounts_password_all_shadowed
    - accounts_no_uid_except_zero
    - set_password_hashing_algorithm_systemauth
    - set_password_hashing_algorithm_logindefs
    - set_password_hashing_algorithm_libuserconf
    - accounts_root_path_dirs_no_write
    - accounts_umask_etc_bashrc
    - accounts_umask_etc_login_defs
    - var_accounts_user_umask=077
    - no_shelllogin_for_systemaccounts
    - root_path_default
    - no_empty_passwords
    - accounts_umask_etc_csh_cshrc
    - accounts_umask_etc_profile
    - no_netrc_files
    - grub_legacy_disable_interactive_boot
    - package_screen_installed
    - kernel_module_dccp_disabled
    - kernel_module_sctp_disabled
    - kernel_module_rds_disabled
    - kernel_module_tipc_disabled
    - package_rsyslog_installed
    - service_rsyslog_enabled
    - rsyslog_remote_loghost
    - ensure_logrotate_activated
    - disable_logwatch_for_logserver
    - rsyslog_files_ownership
    - rsyslog_files_groupownership
    - rsyslog_files_permissions
    - rsyslog_nolisten
    - logwatch_configured_splithosts
    - audit_rules_time_adjtimex
    - audit_rules_time_settimeofday
    - audit_rules_time_stime
    - audit_rules_time_clock_settime
    - audit_rules_time_watch_localtime
    - audit_rules_usergroup_modification
    - audit_rules_networkconfig_modification
    - audit_rules_mac_modification
    - audit_rules_dac_modification_chmod
    - audit_rules_dac_modification_chown
    - audit_rules_dac_modification_fchmod
    - audit_rules_dac_modification_fchmodat
    - audit_rules_dac_modification_fchown
    - audit_rules_dac_modification_fchownat
    - audit_rules_dac_modification_fremovexattr
    - audit_rules_dac_modification_fsetxattr
    - audit_rules_dac_modification_lchown
    - audit_rules_dac_modification_lremovexattr
    - audit_rules_dac_modification_lsetxattr
    - audit_rules_dac_modification_removexattr
    - audit_rules_dac_modification_setxattr
    - audit_rules_kernel_module_loading
    - audit_rules_immutable
    - file_permissions_var_log_audit
    - file_ownership_var_log_audit
    - audit_rules_login_events
    - audit_rules_session_events
    - audit_rules_unsuccessful_file_modification
    - audit_rules_privileged_commands
    - audit_rules_media_export
    - audit_rules_file_deletion_events
    - securetty_root_login_console_only
    - no_direct_root_logins
    - file_owner_etc_shadow
    - file_groupowner_etc_shadow
    - file_permissions_etc_shadow
    - file_owner_etc_gshadow
    - file_groupowner_etc_gshadow
    - file_permissions_etc_gshadow
    - file_owner_etc_passwd
    - file_groupowner_etc_passwd
    - file_permissions_etc_passwd
    - file_owner_etc_group
    - file_groupowner_etc_group
    - file_permissions_etc_group
    - file_permissions_library_dirs
    - file_ownership_library_dirs
    - file_permissions_binary_dirs
    - file_ownership_binary_dirs
    - gid_passwd_group_same
    - file_permissions_home_dirs
    - file_owner_grub_conf
    - file_groupowner_grub_conf
    - file_permissions_grub_conf
    - sysctl_fs_suid_dumpable
    - service_restorecond_enabled
    - selinux_confinement_of_daemons
    - selinux_all_devicefiles_labeled
    - selinux_state
    - selinux_policytype
    - require_singleuser_auth
    - disable_ctrlaltdel_reboot
    - grub_legacy_password
    - gconf_gnome_screensaver_idle_delay
    - inactivity_timeout_value=15_minutes
    - gconf_gnome_screensaver_idle_activation_enabled
    - gconf_gnome_screensaver_lock_enabled
    - banner_etc_issue
    - gconf_gdm_enable_warning_gui_banner
    - gconf_gdm_set_login_banner_text
    - login_banner_text=dod_default
    - gconf_gnome_disable_thumbnailers
    - gconf_gnome_disable_automount
    - network_disable_zeroconf
    - sysctl_net_ipv4_conf_default_send_redirects
    - sysctl_net_ipv4_conf_all_send_redirects
    - sysctl_net_ipv4_ip_forward
    - sysctl_net_ipv4_conf_all_accept_source_route
    - sysctl_net_ipv4_conf_all_accept_redirects
    - sysctl_net_ipv4_conf_all_secure_redirects
    - sysctl_net_ipv4_conf_all_log_martians
    - sysctl_net_ipv4_conf_default_accept_source_route
    - sysctl_net_ipv4_conf_default_secure_redirects
    - sysctl_net_ipv4_conf_default_accept_redirects
    - sysctl_net_ipv4_icmp_echo_ignore_broadcasts
    - sysctl_net_ipv4_icmp_ignore_bogus_error_responses
    - sysctl_net_ipv4_tcp_syncookies
    - sysctl_net_ipv4_conf_all_rp_filter
    - sysctl_net_ipv4_conf_default_rp_filter
    - kernel_module_ipv6_option_disabled
    - network_ipv6_disable_interfaces
    - network_ipv6_disable_rpc
    - network_ipv6_static_address
    - network_ipv6_privacy_extensions
    - network_ipv6_default_gateway
    - sysctl_net_ipv6_conf_default_accept_ra
    - sysctl_net_ipv6_conf_default_accept_redirects
    - network_sniffer_disabled
    - wireless_disable_in_bios
    - wireless_disable_interfaces
    - service_bluetooth_disabled
    - kernel_module_bluetooth_disabled
    - service_crond_enabled
    - service_abrtd_disabled
    - service_acpid_disabled
    - service_atd_disabled
    - service_autofs_disabled
    - service_certmonger_disabled
    - service_cgconfig_disabled
    - service_cgred_disabled
    - service_cpuspeed_disabled
    - service_haldaemon_disabled
    - service_irqbalance_enabled
    - service_kdump_disabled
    - service_mdmonitor_disabled
    - service_messagebus_disabled
    - service_netconsole_disabled
    - service_ntpdate_disabled
    - service_oddjobd_disabled
    - service_portreserve_disabled
    - service_qpidd_disabled
    - service_rdisc_disabled
    - service_rhnsd_disabled
    - service_saslauthd_disabled
    - service_rhsmcertd_disabled
    - service_smartd_disabled
    - service_sysstat_disabled
    - service_xinetd_disabled
    - package_xinetd_removed
    - package_telnet-server_removed
    - service_telnet_disabled
    - package_rsh-server_removed
    - service_rsh_disabled
    - package_ypserv_removed
    - service_ypbind_disabled
    - service_sshd_disabled
    - sshd_allow_only_protocol2
    - sshd_idle_timeout_value=60_minutes
    - sshd_set_keepalive
    - sshd_disable_rhosts
    - sshd_disable_root_login
    - sshd_disable_empty_passwords
    - sshd_enable_warning_banner
    - sshd_do_not_permit_user_env
    - sshd_limit_user_access
    - sshd_use_approved_ciphers
    - xwindows_runlevel_setting
    - package_xorg-x11-server-common_removed
    - service_cups_disabled
    - cups_disable_browsing
    - sysconfig_networking_bootproto_ifcfg
    - dhcp_server_disable_ddns
    - dhcp_server_deny_decline
    - dhcp_server_deny_bootp
    - dhcp_server_minimize_served_info
    - dhcp_server_configure_logging
    - service_ntpd_enabled
    - ntpd_specify_remote_server
    - service_postfix_enabled
    - package_sendmail_removed
    - ldap_client_start_tls
    - service_nfslock_disabled
    - service_rpcgssd_disabled
    - service_rpcidmapd_disabled
    - service_netfs_disabled
    - nfs_fixed_lockd_tcp_port
    - nfs_fixed_lockd_udp_port
    - nfs_fixed_statd_port
    - nfs_fixed_mountd_port
    - service_nfs_disabled
    - service_rpcsvcgssd_disabled
    - mount_option_nodev_remote_filesystems
    - mount_option_nosuid_remote_filesystems
    - use_root_squashing_all_exports
    - restrict_nfs_clients_to_privileged_ports
    - no_insecure_locks_exports
    - nfs_no_anonymous
    - service_named_disabled
    - package_bind_removed
    - dns_server_disable_dynamic_updates
    - package_tftp-server_removed
    - service_tftp_disabled
    - service_vsftpd_disabled
    - package_vsftpd_removed
    - ftp_log_transactions
    - ftp_present_banner
    - package_httpd_removed
    - httpd_servertokens_prod
    - httpd_mod_rewrite
    - httpd_server_side_includes
    - httpd_webdav
    - httpd_server_activity_status
    - httpd_server_configuration_display
    - httpd_url_correction
    - httpd_proxy_support
    - httpd_cache_support
    - httpd_cgi_support
    - httpd_digest_authentication
    - httpd_ldap_support
    - httpd_mime_magic
    - httpd_restrict_root_directory
    - httpd_restrict_web_directory
    - httpd_restrict_critical_directories
    - httpd_limit_available_methods
    - httpd_install_mod_ssl
    - httpd_install_mod_security
    - dir_perms_etc_httpd_conf
    - file_permissions_httpd_server_conf_files
    - service_dovecot_disabled
    - package_dovecot_removed
    - dovecot_enable_ssl
    - dovecot_configure_ssl_cert
    - dovecot_configure_ssl_key
    - service_smb_disabled
    - require_smb_client_signing
    - mount_option_smb_client_signing
    - smb_server_disable_root
    - service_squid_disabled
    - package_squid_removed
    - service_snmpd_disabled
    - package_net-snmp_removed
    - package_libreswan_installed
    - no_rsh_trust_files
    - tftpd_uses_secure_mode
    - service_avahi-daemon_disabled
    - avahi_ip_only
    - avahi_check_ttl
    - avahi_prevent_port_sharing
    - avahi_disable_publishing
