documentation_complete: true

title: 'Standard System Security Profile for Red Hat Enterprise Linux 6'

description: |-
    This profile contains rules to ensure standard security baseline
    of a Red Hat Enterprise Linux 6 system. Regardless of your system's workload
    all of these checks should pass.

selections:
    - partition_for_tmp
    - partition_for_var
    - partition_for_var_log
    - partition_for_var_log_audit
    - partition_for_home
    - ensure_redhat_gpgkey_installed
    - service_rhnsd_disabled
    - security_patches_up_to_date
    - ensure_gpgcheck_globally_activated
    - rpm_verify_permissions
    - rpm_verify_hashes
    - ensure_gpgcheck_never_disabled
    - package_aide_installed
    - grub_legacy_enable_selinux
    - no_rsh_trust_files
    - selinux_state
    - selinux_policytype
    - selinux_all_devicefiles_labeled
    - securetty_root_login_console_only
    - restrict_serial_port_logins
    - no_shelllogin_for_systemaccounts
    - no_empty_passwords
    - file_permissions_unauthorized_sgid
    - file_permissions_unauthorized_suid
    - file_permissions_unauthorized_world_writable
    - accounts_root_path_dirs_no_write
    - dir_perms_world_writable_sticky_bits
    - accounts_password_all_shadowed
    - accounts_no_uid_except_zero
    - file_owner_etc_shadow
    - file_groupowner_etc_shadow
    - file_permissions_etc_shadow
    - file_owner_etc_gshadow
    - file_groupowner_etc_gshadow
    - file_permissions_etc_gshadow
    - file_owner_etc_passwd
    - file_groupowner_etc_passwd
    - file_permissions_etc_passwd
    - file_owner_etc_group
    - file_groupowner_etc_group
    - file_permissions_etc_group
    - file_permissions_library_dirs
    - file_ownership_library_dirs
    - file_permissions_binary_dirs
    - file_ownership_binary_dirs
    - file_permissions_var_log_audit
    - accounts_password_minlen_login_defs
    - accounts_minimum_age_login_defs
    - accounts_maximum_age_login_defs
    - accounts_password_warn_age_login_defs
    - cracklib_accounts_password_pam_retry
    - cracklib_accounts_password_pam_dcredit
    - cracklib_accounts_password_pam_ucredit
    - cracklib_accounts_password_pam_ocredit
    - cracklib_accounts_password_pam_lcredit
    - cracklib_accounts_password_pam_difok
    - accounts_passwords_pam_faillock_deny
    - set_password_hashing_algorithm_systemauth
    - set_password_hashing_algorithm_logindefs
    - set_password_hashing_algorithm_libuserconf
    - file_owner_grub_conf
    - file_groupowner_grub_conf
    - file_permissions_grub_conf
    - grub_legacy_password
    - require_singleuser_auth
    - grub_legacy_disable_interactive_boot
    - package_screen_installed
    - banner_etc_issue
    - sysctl_kernel_randomize_va_space
    - sysctl_kernel_exec_shield
    - sysctl_net_ipv4_conf_default_send_redirects
    - sysctl_net_ipv4_conf_all_send_redirects
    - sysctl_net_ipv4_ip_forward
    - sysctl_net_ipv4_conf_all_accept_source_route
    - sysctl_net_ipv4_conf_all_accept_redirects
    - sysctl_net_ipv4_conf_all_secure_redirects
    - sysctl_net_ipv4_conf_all_log_martians
    - sysctl_net_ipv4_conf_default_accept_source_route
    - sysctl_net_ipv4_conf_default_secure_redirects
    - sysctl_net_ipv4_conf_default_accept_redirects
    - sysctl_net_ipv4_icmp_echo_ignore_broadcasts
    - sysctl_net_ipv4_icmp_ignore_bogus_error_responses
    - sysctl_net_ipv4_tcp_syncookies
    - sysctl_net_ipv4_conf_all_rp_filter
    - sysctl_net_ipv4_conf_default_rp_filter
    - sysctl_net_ipv6_conf_default_accept_redirects
    - service_ip6tables_enabled
    - service_iptables_enabled
    - set_iptables_default_rule
    - set_ip6tables_default_rule
    - kernel_module_dccp_disabled
    - kernel_module_sctp_disabled
    - kernel_module_rds_disabled
    - kernel_module_tipc_disabled
    - package_rsyslog_installed
    - service_rsyslog_enabled
    - rsyslog_files_ownership
    - rsyslog_files_groupownership
    - rsyslog_files_permissions
    - rsyslog_remote_loghost
    - ensure_logrotate_activated
    - service_auditd_enabled
    - grub_legacy_audit_argument
    - auditd_data_retention_num_logs
    - auditd_data_retention_max_log_file
    - auditd_data_retention_max_log_file_action
    - auditd_data_retention_admin_space_left_action
    - audit_rules_time_adjtimex
    - audit_rules_time_settimeofday
    - audit_rules_time_stime
    - audit_rules_time_clock_settime
    - audit_rules_time_watch_localtime
    - audit_rules_usergroup_modification
    - audit_rules_networkconfig_modification
    - audit_rules_mac_modification
    - audit_rules_dac_modification_chmod
    - audit_rules_dac_modification_chown
    - audit_rules_dac_modification_fchmod
    - audit_rules_dac_modification_fchmodat
    - audit_rules_dac_modification_fchown
    - audit_rules_dac_modification_fchownat
    - audit_rules_dac_modification_fremovexattr
    - audit_rules_dac_modification_fsetxattr
    - audit_rules_dac_modification_lchown
    - audit_rules_dac_modification_lremovexattr
    - audit_rules_dac_modification_lsetxattr
    - audit_rules_dac_modification_removexattr
    - audit_rules_dac_modification_setxattr
    - audit_rules_unsuccessful_file_modification
    - audit_rules_privileged_commands
    - audit_rules_media_export
    - audit_rules_file_deletion_events
    - audit_rules_sysadmin_actions
    - audit_rules_kernel_module_loading
    - service_xinetd_disabled
    - package_xinetd_removed
    - package_telnet-server_removed
    - service_telnet_disabled
    - package_rsh-server_removed
    - service_rsh_disabled
    - service_rexec_disabled
    - service_rlogin_disabled
    - package_ypserv_removed
    - service_ypbind_disabled
    - package_tftp-server_removed
    - service_tftp_disabled
    - service_crond_enabled
    - sshd_allow_only_protocol2
    - sshd_set_idle_timeout
    - sshd_set_keepalive
    - disable_host_auth
    - sshd_disable_root_login
    - sshd_disable_empty_passwords
    - sshd_enable_warning_banner
    - sshd_do_not_permit_user_env
    - sshd_use_approved_ciphers
    - service_avahi-daemon_disabled
    - service_ntpd_enabled
    - ntpd_specify_remote_server
    - postfix_network_listening_disabled
    - ldap_client_start_tls
    - ldap_client_tls_cacertpath
    - package_openldap-servers_removed
    - gconf_gnome_screensaver_idle_delay
    - inactivity_timeout_value=15_minutes
    - var_accounts_tmout=10_min
    - accounts_tmout
    - gconf_gnome_screensaver_idle_activation_enabled
    - gconf_gnome_screensaver_lock_enabled
    - gconf_gnome_screensaver_mode_blank
    - service_abrtd_disabled
    - service_atd_disabled
    - service_autofs_disabled
    - service_ntpdate_disabled
    - service_oddjobd_disabled
    - service_qpidd_disabled
    - service_rdisc_disabled
    - mount_option_nodev_remote_filesystems
    - mount_option_nosuid_remote_filesystems
    - mount_option_noexec_removable_partitions
    - require_smb_client_signing
    - mount_option_smb_client_signing
    - accounts_password_pam_unix_remember
    - var_umask_for_daemons=027
    - var_accounts_password_minlen_login_defs=15
    - var_accounts_maximum_age_login_defs=90
    - var_accounts_minimum_age_login_defs=7
    - var_accounts_password_warn_age_login_defs=7
    - var_password_pam_retry=3
    - var_password_pam_minlen=14
    - var_password_pam_dcredit=1
    - var_password_pam_ucredit=2
    - var_password_pam_ocredit=2
    - var_password_pam_lcredit=2
    - var_password_pam_difok=3
    - var_password_pam_unix_remember=5
    - var_accounts_user_umask=077
    - login_banner_text=usgcb_default
    - var_selinux_state=enforcing
    - var_selinux_policy_name=targeted
    - var_auditd_num_logs=5
    - var_auditd_max_log_file=6
    - var_auditd_max_log_file_action=rotate
    - var_auditd_admin_space_left_action=single
    - sysctl_net_ipv4_conf_all_accept_source_route_value=disabled
    - sysctl_net_ipv4_conf_all_accept_redirects_value=disabled
    - sysctl_net_ipv4_conf_all_secure_redirects_value=disabled
    - sysctl_net_ipv4_conf_all_log_martians_value=enabled
    - sysctl_net_ipv4_conf_default_accept_source_route_value=disabled
    - sysctl_net_ipv4_conf_default_accept_redirects_value=disabled
    - sysctl_net_ipv4_conf_default_secure_redirects_value=disabled
    - sysctl_net_ipv4_icmp_echo_ignore_broadcasts_value=enabled
    - sysctl_net_ipv4_tcp_syncookies_value=enabled
    - sysctl_net_ipv4_conf_all_rp_filter_value=enabled
    - sysctl_net_ipv4_conf_default_rp_filter_value=enabled
    - file_owner_logfiles_value=root
    - file_groupowner_logfiles_value=root
    - sshd_idle_timeout_value=5_minutes
