package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyScreenSetting invokes the aegis.ModifyScreenSetting API synchronously
// api document: https://help.aliyun.com/api/aegis/modifyscreensetting.html
func (client *Client) ModifyScreenSetting(request *ModifyScreenSettingRequest) (response *ModifyScreenSettingResponse, err error) {
	response = CreateModifyScreenSettingResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyScreenSettingWithChan invokes the aegis.ModifyScreenSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/modifyscreensetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyScreenSettingWithChan(request *ModifyScreenSettingRequest) (<-chan *ModifyScreenSettingResponse, <-chan error) {
	responseChan := make(chan *ModifyScreenSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyScreenSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyScreenSettingWithCallback invokes the aegis.ModifyScreenSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/modifyscreensetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyScreenSettingWithCallback(request *ModifyScreenSettingRequest, callback func(response *ModifyScreenSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyScreenSettingResponse
		var err error
		defer close(result)
		response, err = client.ModifyScreenSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyScreenSettingRequest is the request struct for api ModifyScreenSetting
type ModifyScreenSettingRequest struct {
	*requests.RpcRequest
	SourceIp        string `position:"Query" name:"SourceIp"`
	ScreenTitle     string `position:"Query" name:"ScreenTitle"`
	ScreenIdSetting string `position:"Query" name:"ScreenIdSetting"`
}

// ModifyScreenSettingResponse is the response struct for api ModifyScreenSetting
type ModifyScreenSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyScreenSettingRequest creates a request to invoke ModifyScreenSetting API
func CreateModifyScreenSettingRequest() (request *ModifyScreenSettingRequest) {
	request = &ModifyScreenSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "ModifyScreenSetting", "vipaegis", "openAPI")
	return
}

// CreateModifyScreenSettingResponse creates a response to parse from ModifyScreenSetting response
func CreateModifyScreenSettingResponse() (response *ModifyScreenSettingResponse) {
	response = &ModifyScreenSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
