package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMySuccessApplies invokes the baas.GetMySuccessApplies API synchronously
// api document: https://help.aliyun.com/api/baas/getmysuccessapplies.html
func (client *Client) GetMySuccessApplies(request *GetMySuccessAppliesRequest) (response *GetMySuccessAppliesResponse, err error) {
	response = CreateGetMySuccessAppliesResponse()
	err = client.DoAction(request, response)
	return
}

// GetMySuccessAppliesWithChan invokes the baas.GetMySuccessApplies API asynchronously
// api document: https://help.aliyun.com/api/baas/getmysuccessapplies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMySuccessAppliesWithChan(request *GetMySuccessAppliesRequest) (<-chan *GetMySuccessAppliesResponse, <-chan error) {
	responseChan := make(chan *GetMySuccessAppliesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMySuccessApplies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMySuccessAppliesWithCallback invokes the baas.GetMySuccessApplies API asynchronously
// api document: https://help.aliyun.com/api/baas/getmysuccessapplies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMySuccessAppliesWithCallback(request *GetMySuccessAppliesRequest, callback func(response *GetMySuccessAppliesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMySuccessAppliesResponse
		var err error
		defer close(result)
		response, err = client.GetMySuccessApplies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMySuccessAppliesRequest is the request struct for api GetMySuccessApplies
type GetMySuccessAppliesRequest struct {
	*requests.RpcRequest
}

// GetMySuccessAppliesResponse is the response struct for api GetMySuccessApplies
type GetMySuccessAppliesResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateGetMySuccessAppliesRequest creates a request to invoke GetMySuccessApplies API
func CreateGetMySuccessAppliesRequest() (request *GetMySuccessAppliesRequest) {
	request = &GetMySuccessAppliesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "GetMySuccessApplies", "", "")
	return
}

// CreateGetMySuccessAppliesResponse creates a response to parse from GetMySuccessApplies response
func CreateGetMySuccessAppliesResponse() (response *GetMySuccessAppliesResponse) {
	response = &GetMySuccessAppliesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
