package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListScenarioTemplates invokes the ccc.ListScenarioTemplates API synchronously
// api document: https://help.aliyun.com/api/ccc/listscenariotemplates.html
func (client *Client) ListScenarioTemplates(request *ListScenarioTemplatesRequest) (response *ListScenarioTemplatesResponse, err error) {
	response = CreateListScenarioTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListScenarioTemplatesWithChan invokes the ccc.ListScenarioTemplates API asynchronously
// api document: https://help.aliyun.com/api/ccc/listscenariotemplates.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListScenarioTemplatesWithChan(request *ListScenarioTemplatesRequest) (<-chan *ListScenarioTemplatesResponse, <-chan error) {
	responseChan := make(chan *ListScenarioTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListScenarioTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListScenarioTemplatesWithCallback invokes the ccc.ListScenarioTemplates API asynchronously
// api document: https://help.aliyun.com/api/ccc/listscenariotemplates.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListScenarioTemplatesWithCallback(request *ListScenarioTemplatesRequest, callback func(response *ListScenarioTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListScenarioTemplatesResponse
		var err error
		defer close(result)
		response, err = client.ListScenarioTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListScenarioTemplatesRequest is the request struct for api ListScenarioTemplates
type ListScenarioTemplatesRequest struct {
	*requests.RpcRequest
}

// ListScenarioTemplatesResponse is the response struct for api ListScenarioTemplates
type ListScenarioTemplatesResponse struct {
	*responses.BaseResponse
	RequestId         string     `json:"RequestId" xml:"RequestId"`
	Success           bool       `json:"Success" xml:"Success"`
	Code              string     `json:"Code" xml:"Code"`
	Message           string     `json:"Message" xml:"Message"`
	HttpStatusCode    int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ScenarioTemplates []Scenario `json:"ScenarioTemplates" xml:"ScenarioTemplates"`
}

// CreateListScenarioTemplatesRequest creates a request to invoke ListScenarioTemplates API
func CreateListScenarioTemplatesRequest() (request *ListScenarioTemplatesRequest) {
	request = &ListScenarioTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "ListScenarioTemplates", "", "")
	return
}

// CreateListScenarioTemplatesResponse creates a response to parse from ListScenarioTemplates response
func CreateListScenarioTemplatesResponse() (response *ListScenarioTemplatesResponse) {
	response = &ListScenarioTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
