package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableHostAvailability invokes the cms.DisableHostAvailability API synchronously
// api document: https://help.aliyun.com/api/cms/disablehostavailability.html
func (client *Client) DisableHostAvailability(request *DisableHostAvailabilityRequest) (response *DisableHostAvailabilityResponse, err error) {
	response = CreateDisableHostAvailabilityResponse()
	err = client.DoAction(request, response)
	return
}

// DisableHostAvailabilityWithChan invokes the cms.DisableHostAvailability API asynchronously
// api document: https://help.aliyun.com/api/cms/disablehostavailability.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DisableHostAvailabilityWithChan(request *DisableHostAvailabilityRequest) (<-chan *DisableHostAvailabilityResponse, <-chan error) {
	responseChan := make(chan *DisableHostAvailabilityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableHostAvailability(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableHostAvailabilityWithCallback invokes the cms.DisableHostAvailability API asynchronously
// api document: https://help.aliyun.com/api/cms/disablehostavailability.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DisableHostAvailabilityWithCallback(request *DisableHostAvailabilityRequest, callback func(response *DisableHostAvailabilityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableHostAvailabilityResponse
		var err error
		defer close(result)
		response, err = client.DisableHostAvailability(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableHostAvailabilityRequest is the request struct for api DisableHostAvailability
type DisableHostAvailabilityRequest struct {
	*requests.RpcRequest
	Id *[]string `position:"Query" name:"Id"  type:"Repeated"`
}

// DisableHostAvailabilityResponse is the response struct for api DisableHostAvailability
type DisableHostAvailabilityResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableHostAvailabilityRequest creates a request to invoke DisableHostAvailability API
func CreateDisableHostAvailabilityRequest() (request *DisableHostAvailabilityRequest) {
	request = &DisableHostAvailabilityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DisableHostAvailability", "cms", "openAPI")
	return
}

// CreateDisableHostAvailabilityResponse creates a response to parse from DisableHostAvailability response
func CreateDisableHostAvailabilityResponse() (response *DisableHostAvailabilityResponse) {
	response = &DisableHostAvailabilityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
