package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAlertUserGroup invokes the emr.ModifyAlertUserGroup API synchronously
// api document: https://help.aliyun.com/api/emr/modifyalertusergroup.html
func (client *Client) ModifyAlertUserGroup(request *ModifyAlertUserGroupRequest) (response *ModifyAlertUserGroupResponse, err error) {
	response = CreateModifyAlertUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAlertUserGroupWithChan invokes the emr.ModifyAlertUserGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyalertusergroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyAlertUserGroupWithChan(request *ModifyAlertUserGroupRequest) (<-chan *ModifyAlertUserGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyAlertUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAlertUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAlertUserGroupWithCallback invokes the emr.ModifyAlertUserGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyalertusergroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyAlertUserGroupWithCallback(request *ModifyAlertUserGroupRequest, callback func(response *ModifyAlertUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAlertUserGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyAlertUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAlertUserGroupRequest is the request struct for api ModifyAlertUserGroup
type ModifyAlertUserGroupRequest struct {
	*requests.RpcRequest
	UserList        string           `position:"Query" name:"UserList"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BizId           string           `position:"Query" name:"BizId"`
	Name            string           `position:"Query" name:"Name"`
	Description     string           `position:"Query" name:"Description"`
}

// ModifyAlertUserGroupResponse is the response struct for api ModifyAlertUserGroup
type ModifyAlertUserGroupResponse struct {
	*responses.BaseResponse
	Done bool `json:"Done" xml:"Done"`
}

// CreateModifyAlertUserGroupRequest creates a request to invoke ModifyAlertUserGroup API
func CreateModifyAlertUserGroupRequest() (request *ModifyAlertUserGroupRequest) {
	request = &ModifyAlertUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyAlertUserGroup", "emr", "openAPI")
	return
}

// CreateModifyAlertUserGroupResponse creates a response to parse from ModifyAlertUserGroup response
func CreateModifyAlertUserGroupResponse() (response *ModifyAlertUserGroupResponse) {
	response = &ModifyAlertUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
