package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeShardDbConnectionInfo invokes the drds.DescribeShardDbConnectionInfo API synchronously
// api document: https://help.aliyun.com/api/drds/describesharddbconnectioninfo.html
func (client *Client) DescribeShardDbConnectionInfo(request *DescribeShardDbConnectionInfoRequest) (response *DescribeShardDbConnectionInfoResponse, err error) {
	response = CreateDescribeShardDbConnectionInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeShardDbConnectionInfoWithChan invokes the drds.DescribeShardDbConnectionInfo API asynchronously
// api document: https://help.aliyun.com/api/drds/describesharddbconnectioninfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeShardDbConnectionInfoWithChan(request *DescribeShardDbConnectionInfoRequest) (<-chan *DescribeShardDbConnectionInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeShardDbConnectionInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeShardDbConnectionInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeShardDbConnectionInfoWithCallback invokes the drds.DescribeShardDbConnectionInfo API asynchronously
// api document: https://help.aliyun.com/api/drds/describesharddbconnectioninfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeShardDbConnectionInfoWithCallback(request *DescribeShardDbConnectionInfoRequest, callback func(response *DescribeShardDbConnectionInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeShardDbConnectionInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeShardDbConnectionInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeShardDbConnectionInfoRequest is the request struct for api DescribeShardDbConnectionInfo
type DescribeShardDbConnectionInfoRequest struct {
	*requests.RpcRequest
	DbName         string `position:"Query" name:"DbName"`
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	SubDbName      string `position:"Query" name:"SubDbName"`
}

// DescribeShardDbConnectionInfoResponse is the response struct for api DescribeShardDbConnectionInfo
type DescribeShardDbConnectionInfoResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	ConnectionInfo ConnectionInfo `json:"ConnectionInfo" xml:"ConnectionInfo"`
}

// CreateDescribeShardDbConnectionInfoRequest creates a request to invoke DescribeShardDbConnectionInfo API
func CreateDescribeShardDbConnectionInfoRequest() (request *DescribeShardDbConnectionInfoRequest) {
	request = &DescribeShardDbConnectionInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2017-10-16", "DescribeShardDbConnectionInfo", "", "")
	return
}

// CreateDescribeShardDbConnectionInfoResponse creates a response to parse from DescribeShardDbConnectionInfo response
func CreateDescribeShardDbConnectionInfoResponse() (response *DescribeShardDbConnectionInfoResponse) {
	response = &DescribeShardDbConnectionInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
