package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertApplication invokes the edas.InsertApplication API synchronously
// api document: https://help.aliyun.com/api/edas/insertapplication.html
func (client *Client) InsertApplication(request *InsertApplicationRequest) (response *InsertApplicationResponse, err error) {
	response = CreateInsertApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// InsertApplicationWithChan invokes the edas.InsertApplication API asynchronously
// api document: https://help.aliyun.com/api/edas/insertapplication.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertApplicationWithChan(request *InsertApplicationRequest) (<-chan *InsertApplicationResponse, <-chan error) {
	responseChan := make(chan *InsertApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertApplicationWithCallback invokes the edas.InsertApplication API asynchronously
// api document: https://help.aliyun.com/api/edas/insertapplication.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertApplicationWithCallback(request *InsertApplicationRequest, callback func(response *InsertApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertApplicationResponse
		var err error
		defer close(result)
		response, err = client.InsertApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertApplicationRequest is the request struct for api InsertApplication
type InsertApplicationRequest struct {
	*requests.RoaRequest
	WebContainer    string           `position:"Query" name:"WebContainer"`
	EcuInfo         string           `position:"Query" name:"EcuInfo"`
	BuildPackId     requests.Integer `position:"Query" name:"BuildPackId"`
	HealthCheckURL  string           `position:"Query" name:"HealthCheckURL"`
	ReservedPortStr string           `position:"Query" name:"ReservedPortStr"`
	Description     string           `position:"Query" name:"Description"`
	Cpu             requests.Integer `position:"Query" name:"Cpu"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	ApplicationName string           `position:"Query" name:"ApplicationName"`
	Jdk             string           `position:"Query" name:"Jdk"`
	Mem             requests.Integer `position:"Query" name:"Mem"`
	LogicalRegionId string           `position:"Query" name:"LogicalRegionId"`
	PackageType     string           `position:"Query" name:"PackageType"`
}

// InsertApplicationResponse is the response struct for api InsertApplication
type InsertApplicationResponse struct {
	*responses.BaseResponse
	Code            int             `json:"Code" xml:"Code"`
	Message         string          `json:"Message" xml:"Message"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	ApplicationInfo ApplicationInfo `json:"ApplicationInfo" xml:"ApplicationInfo"`
}

// CreateInsertApplicationRequest creates a request to invoke InsertApplication API
func CreateInsertApplicationRequest() (request *InsertApplicationRequest) {
	request = &InsertApplicationRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "InsertApplication", "/pop/v5/changeorder/co_create_app", "", "")
	request.Method = requests.POST
	return
}

// CreateInsertApplicationResponse creates a response to parse from InsertApplication response
func CreateInsertApplicationResponse() (response *InsertApplicationResponse) {
	response = &InsertApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
